#ifndef CFURLACCESS_H
#define CFURLACCESS_H

#include <CoreFoundation/CFBase.h>

#ifndef CFARRAY_H
#include <CoreFoundation/CFArray.h>
#endif

#include <CoreFoundation/CFData.h>
#include <CoreFoundation/CFDictionary.h>
#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFURL.h>

#if defined(__cplusplus)
extern "C" {
#endif
/*CFURLCreateDataAndPropertiesFromResource

Loads the data and properties referred to by a given URL.

Boolean CFURLCreateDataAndPropertiesFromResource (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFDataRef *resourceData,
   CFDictionaryRef *properties,
   CFArrayRef desiredProperties,
   SInt32 *errorCode
);
Parameters
allocator

The allocator to use to allocate memory for the new CFData and CFDictionary objects returned in resourceData and properties. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The URL referring to the data and/or properties you wish to load.
resourceData

On return, contains a CFData object containing the data referred to by url. Ownership follows the Create Rule.
properties

On return, a pointer to a CFDictionary object containing the resource properties referred to by url. Ownership follows the Create Rule. 
desiredProperties

A list of the properties you wish to obtain and return in properties. See “File URL Properties” and “HTTP URL Properties” for the list of available properties.
errorCode

0 if successful, otherwise an error code indicating the nature of the problem. See “Error Codes” for a list of possible error codes.
Return Value

true if successful, false otherwise. 
Discussion

If you are interested in loading only the resource data or the resource's properties, pass NULL for the one you don't want. If properties is non-NULL and desiredProperties is NULL then all properties are fetched. Note that as much work as possible is done even if false is returned. For instance, if one property is not available, the others are fetched anyway. This function is intended for convenience, not performance.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFURLAccess.h*/
Boolean CFURLCreateDataAndPropertiesFromResource (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFDataRef *resourceData,
   CFDictionaryRef *properties,
   CFArrayRef desiredProperties,
   SInt32 *errorCode
);
/*CFURLWriteDataAndPropertiesToResource

Writes the given data and properties to a given URL.

Boolean CFURLWriteDataAndPropertiesToResource (
   CFURLRef url,
   CFDataRef dataToWrite,
   CFDictionaryRef propertiesToWrite,
   SInt32 *errorCode
);
Parameters
url

The resource to write. 
dataToWrite

The data to write. Pass NULL to write only properties. 
propertiesToWrite

The properties to write. Pass NULL to write only data. See “File URL Properties” and “HTTP URL Properties” for the list of available properties.
errorCode

Upon return, 0 if successful, otherwise contains an error code indicating the nature of the problem. See “Error Codes” for a list of possible error codes.
Return Value

true if successful, false otherwise. 
Discussion

Properties not present in propertiesToWrite are left unchanged, hence if propertiesToWrite is NULL or empty, the URL's properties are not changed at all. 

If url uses a file scheme and it references a file, the contents of dataToWrite are written to the referenced file, overwriting any preexisting data, and the file’s properties are modified according to propertiesToWrite. If the file does not exist, but all intermediate directories along the path do already exist, the file is created (otherwise it is not).

If url uses a file scheme and it references a directory (the last path character is "/"), the contents of dataToWrite are ignored, but if the parameter value is not NULL—and all intermediate directories along the path do already exist—a new directory is created (otherwise it is not).

If url uses an http scheme, an http PUT request is sent to the resource with propertiesToWrite as the header fields and dataToWrite as the data.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFURLAccess.h*/
Boolean CFURLWriteDataAndPropertiesToResource (
   CFURLRef url,
   CFDataRef dataToWrite,
   CFDictionaryRef propertiesToWrite,
   SInt32 *errorCode
);


#ifdef __cplusplus
}
#endif

#endif