#ifndef TEXTCOMMON_H
#define  TEXTCOMMON_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif


#include <APPLE/CarbonCore/TextCommon.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Common and Special Unicode Values

Specify sommon and special Unicode code values.

enum {
   kUnicodeByteOrderMark = 0xFEFF,
   kUnicodeObjectReplacement = 0xFFFC,
   kUnicodeReplacementChar = 0xFFFD,
   kUnicodeSwappedByteOrderMark = 0xFFFE,
   kUnicodeNotAChar = 0xFFFF
};
Constants
kUnicodeByteOrderMark

Available in Mac OS X v10.0 and later.
kUnicodeObjectReplacement

A placeholder for a non-text object.

Available in Mac OS X v10.0 and later.
kUnicodeReplacementChar

Unicode replacement for an input character that cannot be converted.

Available in Mac OS X v10.0 and later.
kUnicodeSwappedByteOrderMark

Not a Unicode character; byte-swapped version of FEFF.

Available in Mac OS X v10.0 and later.
kUnicodeNotAChar

Not a Unicode character; may be used as a terminator.

Available in Mac OS X v10.0 and later.*/
enum {
   kUnicodeByteOrderMark = 0xFEFF,
   kUnicodeObjectReplacement = 0xFFFC,
   kUnicodeReplacementChar = 0xFFFD,
   kUnicodeSwappedByteOrderMark = 0xFFFE,
   kUnicodeNotAChar = 0xFFFF
};

/*Text Encoding Variants

Specify minor variants of a base encoding or group of base encodings.

enum {
   kTextEncodingDefaultVariant = 0
};
Constants
kTextEncodingDefaultVariant

The standard default variant for any base encoding. 

Available in Mac OS X v10.0 and later.
Discussion

This enumeration defines constants for the default variant of any base text encoding and for variants of the Mac OS Japanese, Mac OS Arabic, Mac OS Farsi, Mac OS Hebrew, and Unicode base encodings. 

A text encoding variant specifies one among possibly several minor variants of a particular base encoding or group of base encodings. Text encoding variants are often used to support special cases such as the following:
Differences among fonts that are all intended to support the same encoding. For example, different fonts associated with the MacJapanese and MacArabic encodings support slightly different encoding variants. These fonts would typically coexist on the same system without the user being aware of any differences. 
Artificial variants created by excluding some of the characters in an encoding. For example, the MacJapanese encoding includes separately-encoded vertical forms for some characters. In some contexts (such as with QuickDraw GX), it may be desirable to exclude these. 
Different mappings of a particular character or group of characters for different usages. 

For a given text encoding base or small set of related text encoding base values, there may be an enumeration of TextEncodingVariant values, which always begins with 0, the default variant. In addition, for a possibly larger set of related text encoding base values, there may be bit masks that can be used independently to designate additional artificial variants. For example, there is an enumeration of six variants for the Mac OS Japanese encoding. In addition, there are bit masks that can also be used as part of the variant for any Japanese encoding to exclude 1-byte kana or to control the mapping of the reverse solidus (backslash) character.

Languages that are dissimilar but use similar character sets are generally not designated as variants of the same base encoding (for example, MacIcelandic and MacTurkish both use a slight modification of the MacRoman character set, but they are considered separate base encodings). 

When you create a new text encoding, you can specify an explicit variant of a base encoding or you can specify the default variant of that base. A text encoding variant is defined by the TextEncodingVariant data type. The function GetTextEncodingVariant returns the text encoding variant of a text encoding specification.*/
enum {
   kTextEncodingDefaultVariant = 0
};


/*Encoding Variants for Unicode

Specify variants of Unicode.

enum {
   kUnicodeNoSubset = 0,
   kUnicodeCanonicalDecompVariant = 2,
   kUnicodeCanonicalCompVariant = 3,
   kUnicodeHFSPlusDecompVariant = 8,
   kUnicodeHFSPlusCompVariant = 9
};
Constants
kUnicodeNoSubset

The standard Unicode encoded character set in which the full set of Unicode characters are supported.

Available in Mac OS X v10.0 and later.
kUnicodeCanonicalDecompVariant

A variant of Unicode using maximal decomposition with characters in canonical order. This variant does not include most characters which have a canonical decomposition, such as single characters for accented Latin letters or single characters for Korean Hangul syllables (however, this restriction is relaxed for symbol characters in the range U+2000 to U+2FFF). In TEC Manager 1.3, the Unicode Converter supports this variant for converting to and from Mac OS encodings.

Available in Mac OS X v10.0 and later.
kUnicodeCanonicalCompVariant

This is the normal canonical composition according to Unicode 3.2 rules.

Available in Mac OS X v10.2 and later.
kUnicodeHFSPlusDecompVariant

Specifies canonical decomposition according to Unicode 3.2 rules, with HFS+ exclusions ("HFS+ decomposition 3.2"). That is, it doesn't decompose in 2000-2FFF, F900-FAFF, 2F800-2FAFF. You can use ths option when converting HFS file names.

Available in Mac OS X v10.2 and later.
kUnicodeHFSPlusCompVariant

Specifies canonical composition according to Unicode 3.2 rules, but using the HFS+ decomposition exclusions. You can use ths option when converting HFS file names. You should use this form when you want to obtain a composed form that can be converted to and from the decomposed form specified by kUnicodeHFSPlusDecompVariant. This is the recommended way to request decompositions with HFS+ exclusions, instead of using mappingVersion = kUnicodeUseHFSPlusMapping.

Available in Mac OS X v10.2 and later.*/
enum {
   kUnicodeNoSubset = 0,
   kUnicodeCanonicalDecompVariant = 2,
   kUnicodeCanonicalCompVariant = 3,
   kUnicodeHFSPlusDecompVariant = 8,
   kUnicodeHFSPlusCompVariant = 9
};




/*Unwanted Data Constants

Specify data you don’t care about receiving.

enum {
   kTextScriptDontCare = -128,
   kTextLanguageDontCare = -128,
   kTextRegionDontCare = -128
};
Constants
kTextScriptDontCare

Indicates that the code is not provided for the derivation.

Available in Mac OS X v10.0 and later.
kTextLanguageDontCare

Indicates that language code is not provided for the derivation.

Available in Mac OS X v10.0 and later.
kTextRegionDontCare

The region code is not provided for the derivation. 

Available in Mac OS X v10.0 and later.
Discussion

For backward compatibility with earlier releases of the Mac OS, the Text Encoding Conversion Manager provides the functions UpgradeScriptInfoToTextEncoding and RevertTextEncodingToScriptInfo that you can use to derive Script Manager values from a text encoding or vice versa. 

When using these functions, you can specify a Script Manager language code, script code, and/or font values to derive a text encoding. These three constants are defined to allow you to identify any part of the derivation you don’t care about. When reverting from a text encoding to Script Manager values, the Unicode Converter returns these constants for a corresponding value it does not derive: kTextLanguageDontCare, kTextScriptDontCare, and kTextRegionDontCare.*/

enum {
   kTextScriptDontCare = -128,
   kTextLanguageDontCare = -128,
   kTextRegionDontCare = -128
};


/*Text Encoding Formats

Specify a text encoding format.

typedef UInt32 TextEncodingFormat;
enum {
   kTextEncodingDefaultFormat = 0,
   kUnicode16BitFormat = 0,
   kUnicodeUTF7Format = 1,
   kUnicodeUTF8Format = 2,
   kUnicode32BitFormat = 3
};
Constants
kTextEncodingDefaultFormat

The standard default format for any base encoding. 

Available in Mac OS X v10.0 and later.
kUnicode16BitFormat

The 16-bit character encoding format specified by the Unicode standard, equivalent to the UCS-2 format for ISO 10646. This includes support for the UTF-16 method of including non-BMP characters in a stream of 16-bit values. 

Available in Mac OS X v10.0 and later.
kUnicodeUTF7Format

The Unicode transformation format in which characters encodings are represented by a sequence of 7-bit values. This format cannot be handled by the Unicode Converter, only by the Text Encoding Converter. 

Available in Mac OS X v10.0 and later.
kUnicodeUTF8Format

The Unicode transformation format in which characters are represented by a sequence of 8-bit values. 

Available in Mac OS X v10.0 and later.
kUnicode32BitFormat

The UCS-4 32-bit format defined for ISO 10646. This format is not currently supported. 

Available in Mac OS X v10.0 and later.
Discussion

A text encoding format specifies a way of formatting or algorithmically transforming a particular base encoding. For example, the UTF-7 format is the Unicode standard formatted for transmission through channels that can handle only 7-bit values. Other text encoding formats for Unicode include UTF-8 and 16-bit or 32-bit formats. These transformations are not viewed as different base encodings. Rather, they are different formats for representing the same base encoding.

Similar to text encoding variant values, text encoding format values are specific to a particular text encoding base value or to a small set of text encoding base values. A text encoding format is defined by the TextEncodingFormat data type.

The function GetTextEncodingFormat returns the text encoding format of a text encoding specification.*/
typedef UInt32 TextEncodingFormat;
enum {
   kTextEncodingDefaultFormat = 0,
   kUnicode16BitFormat = 0,
   kUnicodeUTF7Format = 1,
   kUnicodeUTF8Format = 2,
   kUnicode32BitFormat = 3
};


/*TextEncodingVariant

Defines a data type for a text encoding variant. 

typedef UInt32 TextEncodingVariant;
Discussion

The following enumerations define text encoding variant constants: “Encoding Variants for Big-5”, “Encoding Variants for MacArabic”, “Encoding Variants for MacCroatian”, “Encoding Variants for MacCyrillic”, “Encoding Variants for MacFarsi”, “Encoding Variants for MacHebrew”, “Encoding Variants for MacIcelandic”, “Encoding Variants for MacJapanese”, “Encoding Variants for MacRoman Related to Currency”, “Encoding Variants for MacRomanian”, “Encoding Variants for MacRomanLatin1”, “Encoding Variants for MacRoman”, and “Encoding Variants for MacVT100”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 TextEncodingVariant;

/*Encoding Variants for Mac OS Encodings

Specify variant Mac OS encodings that use script codes other than 0

enum {
   kTextEncodingMacFarsi = 0x8C,
   kTextEncodingMacUkrainian = 0x98,
   kTextEncodingMacInuit = 0xEC,
   kTextEncodingMacVT100 = 0xFC
};
Constants
kTextEncodingMacFarsi

Uses script code 4, smArabic. It is similar to Mac Arabic but uses Farsi digits.]

Available in Mac OS X v10.0 and later.
kTextEncodingMacUkrainian

Uses script code 7, smCyrillic.]

Available in Mac OS X v10.0 and later.
kTextEncodingMacInuit

Uses script code 28, smEthiopic.]

Available in Mac OS X v10.0 and later.
kTextEncodingMacVT100

Uses script code 32, smUninterp; VT100/102 font from the common toolbox; Latin-1 characters plus box drawing.]

Available in Mac OS X v10.0 and later.*/
enum {
   kTextEncodingMacFarsi = 0x8C,
   kTextEncodingMacUkrainian = 0x98,
   kTextEncodingMacInuit = 0xEC,
   kTextEncodingMacVT100 = 0xFC
};


/*Mac Unicode Text Encoding

Specifies a script code that should be handled as a special Mac OS script code.

enum {
   kTextEncodingMacUnicode = 0x7E
};
Constants
kTextEncodingMacUnicode

Beginning with Mac OS 8.5, the set of Mac OS script codes has been extended for some Mac OS components to include Unicode. Some of these components have only 7 bits available for script code, so kTextEncodingUnicodeDefault cannot be used to indicate Unicode. Instead, kTextEncodingMacUnicode is used as a meta-value to indicate that Unicode handles the script code a special Mac OS script code. The Text Encoding Converter handles this value similar to the way it handles the constant kTextEncodingUnicodeDefault.

Available in Mac OS X v10.0 and later.*/

enum {
   kTextEncodingMacUnicode = 0x7E
};


/*Unicode and ISO UCS Text Encodings

Specify Unicode and IOS UCS text encodings.

enum {
   kTextEncodingUnicodeDefault = 0x0100,
   kTextEncodingUnicodeV1_1 = 0x0101,
   kTextEncodingISO10646_1993 = 0x0101,
   kTextEncodingUnicodeV2_0 = 0x0103,
   kTextEncodingUnicodeV2_1 = 0x0103,
   kTextEncodingUnicodeV3_0 = 0x0104,
   kTextEncodingUnicodeV3_1 = 0x0105,
   kTextEncodingUnicodeV3_2 = 0x0106
};
Constants
kTextEncodingUnicodeDefault

This is a meta value that takes on one of the following values, depending on the system.

Available in Mac OS X v10.0 and later.
kTextEncodingUnicodeV1_1

This is a Unicode encoding.

Available in Mac OS X v10.0 and later.
kTextEncodingISO10646_1993

This ISO UCS encoding has code points identical to Unicode 1.1.

Available in Mac OS X v10.0 and later.
kTextEncodingUnicodeV2_0

This is the new location for Korean Hangul.

Available in Mac OS X v10.0 and later.
kTextEncodingUnicodeV2_1

For the Text Encoding Converter, Unicode 2.0 is equivalent to Unicode 2.1.

Available in Mac OS X v10.0 and later.
kTextEncodingUnicodeV3_0

Available in Mac OS X v10.0 and later.
kTextEncodingUnicodeV3_1

Adds characters requiring surrogate pairs in UTF-16

Available in Mac OS X v10.1 and later.
kTextEncodingUnicodeV3_2

Available in Mac OS X v10.1 and later.*/
enum {
   kTextEncodingUnicodeDefault = 0x0100,
   kTextEncodingUnicodeV1_1 = 0x0101,
   kTextEncodingISO10646_1993 = 0x0101,
   kTextEncodingUnicodeV2_0 = 0x0103,
   kTextEncodingUnicodeV2_1 = 0x0103,
   kTextEncodingUnicodeV3_0 = 0x0104,
   kTextEncodingUnicodeV3_1 = 0x0105,
   kTextEncodingUnicodeV3_2 = 0x0106
};



/*UniCharArrayOffset

Represents the boundary between two characters.

typedef UInt32 UniCharArrayOffset;
Discussion

A UniCharArrayOffset represents the boundary between two characters. For example, the first character in a buffer lies between offsets 0 and 1. So the first character in the buffer can be referred to as either “offset 0, leading” or “offset 1, trailing.” This distinction is useful when you deal with caret positions. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 UniCharArrayOffset;



/*ConstUniCharArrayPtr

Defines a constant Unicode character array pointer.

typedef const UniChar * ConstUniCharArrayPtr;
Discussion

You specify a constant Unicode character array pointer for Unicode strings used within the scope of a function whose contents are not modified by that function.
Availability
Available in Mac OS X v10.0 and later.*/
typedef const UniChar * ConstUniCharArrayPtr;


/*TextEncoding

Defines a data type for a text encoding value.

typedef UInt32 TextEncoding;
Discussion

A TextEncoding value is specified by a text encoding base, a text encoding variant, and a text encoding format. You can obtain a TextEncoding value by calling the function CreateTextEncoding. When you call this function, you can provide the TextEncodingBase, TextEncodingVariant, and TextEncodingFormat data types.

A TextEncoding value is used, for example, to identify the encoding of text passed to a text converter. Two TextEncoding values are needed?for source and destination encoding?when calling the Text Encoding Converter or the Unicode Converter to convert text. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 TextEncoding;

/*Special Text Encoding Values

Specify special cases of text encodings.

enum {
   kTextEncodingMultiRun = 0x0FFF,
   kTextEncodingUnknown = 0xFFFF
};
Constants
kTextEncodingMultiRun

This is a special value for multiple encoded text, external run information.

Available in Mac OS X v10.0 and later.
kTextEncodingUnknown

Available in Mac OS X v10.0 and later.*/
enum {
   kTextEncodingMultiRun = 0x0FFF,
   kTextEncodingUnknown = 0xFFFF
};

/*Base Text Encodings

Specify base text encodings.

typedef UInt32 TextEncodingBase;
enum {
   kTextEncodingMacRoman = 0,
   kTextEncodingMacJapanese = 1,
   kTextEncodingMacChineseTrad = 2,
   kTextEncodingMacKorean = 3,
   kTextEncodingMacArabic = 4,
   kTextEncodingMacHebrew = 5,
   kTextEncodingMacGreek = 6,
   kTextEncodingMacCyrillic = 7,
   kTextEncodingMacDevanagari = 9,
   kTextEncodingMacGurmukhi = 10,
   kTextEncodingMacGujarati = 11,
   kTextEncodingMacOriya = 12,
   kTextEncodingMacBengali = 13,
   kTextEncodingMacTamil = 14,
   kTextEncodingMacTelugu = 15,
   kTextEncodingMacKannada = 16,
   kTextEncodingMacMalayalam = 17,
   kTextEncodingMacSinhalese = 18,
   kTextEncodingMacBurmese = 19,
   kTextEncodingMacKhmer = 20,
   kTextEncodingMacThai = 21,
   kTextEncodingMacLaotian = 22,
   kTextEncodingMacGeorgian = 23,
   kTextEncodingMacArmenian = 24,
   kTextEncodingMacChineseSimp = 25,
   kTextEncodingMacTibetan = 26,
   kTextEncodingMacMongolian = 27,
   kTextEncodingMacEthiopic = 28,
   kTextEncodingMacCentralEurRoman = 29,
   kTextEncodingMacVietnamese = 30,
   kTextEncodingMacExtArabic = 31,
   kTextEncodingMacSymbol = 33,
   kTextEncodingMacDingbats = 34,
   kTextEncodingMacTurkish = 35,
   kTextEncodingMacCroatian = 36,
   kTextEncodingMacIcelandic = 37,
   kTextEncodingMacRomanian = 38,
   kTextEncodingMacCeltic = 39,
   kTextEncodingMacGaelic = 40,
   kTextEncodingMacKeyboardGlyphs = 41
};
Constants
kTextEncodingMacRoman

The encoding for Mac OS Roman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacJapanese

The encoding for Mac OS Japanese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacChineseTrad

The encoding for Mac OS traditional Chinese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKorean

The encoding for Mac OS Korean.

Available in Mac OS X v10.0 and later.
kTextEncodingMacArabic

The encoding for Mac OS Arabic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacHebrew

The encoding for Mac OS Hebrew.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGreek

The encoding for Mac OS Greek.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCyrillic

The encoding for Mac OS Cyrillic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacDevanagari

The encoding for Mac OS Devanagari.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGurmukhi

The encoding for Mac OS Gurmukhi.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGujarati

The encoding for Mac OS Gujurati.

Available in Mac OS X v10.0 and later.
kTextEncodingMacOriya

The encoding for Mac OS Oriya.

Available in Mac OS X v10.0 and later.
kTextEncodingMacBengali

The encoding for Mac OS Bengali.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTamil

The encoding for Mac OS Tamil.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTelugu

The encoding for Mac OS Telugu.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKannada

The encoding for Mac OS Kannada.

Available in Mac OS X v10.0 and later.
kTextEncodingMacMalayalam

The encoding for Mac OS Malayalam.

Available in Mac OS X v10.0 and later.
kTextEncodingMacSinhalese

The encoding for Mac OS Sinhalese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacBurmese

The encoding for Mac OS Burmese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKhmer

The encoding for Mac OS Khmer.

Available in Mac OS X v10.0 and later.
kTextEncodingMacThai

The encoding for Mac OS Thai.

Available in Mac OS X v10.0 and later.
kTextEncodingMacLaotian

The encoding for Mac OS Laotian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGeorgian

The encoding for Mac OS Georgian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacArmenian

The encoding for Mac OS Armenian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacChineseSimp

The encoding for Mac OS simple Chinese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTibetan

The encoding for Mac OS Tibetan.

Available in Mac OS X v10.0 and later.
kTextEncodingMacMongolian

The encoding for Mac OS Mongolian.

Available in Mac OS X v10.0 and later.
kTextEncodingMacEthiopic

The encoding for Mac OS Ethiopic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCentralEurRoman

The encoding for Mac OS Central European Roman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacVietnamese

The encoding for Mac OS Vietnamese.

Available in Mac OS X v10.0 and later.
kTextEncodingMacExtArabic

The encoding for Mac OS ExtArabic.

Available in Mac OS X v10.0 and later.
kTextEncodingMacSymbol

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacDingbats

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacTurkish

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCroatian

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacIcelandic

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacRomanian

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacCeltic

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacGaelic

This Mac OS encoding uses script code 0, smRoman.

Available in Mac OS X v10.0 and later.
kTextEncodingMacKeyboardGlyphs

Available in Mac OS X v10.0 and later.
Discussion

You use a base text encoding data type to specify which text encoding or text encoding scheme you have used to express a given text. The text encoding base value is the primary specification of the source or target encoding. Values 0 through 32 correspond directly to Mac OS script codes. Values 33 through 254 are for other Mac OS encodings that do not have their own script codes, such as the Symbol encoding implemented by the Symbol font. You can also specify a meta-value as a base text encoding, such as kTextEncodingMacHFS and kTextEncodingUnicodeDefault. A meta-value is mapped to a real value. 

The function GetTextEncodingBase returns the text encoding base of a text encoding specification.

A base text encoding is defined by the TextEncodingBase data type.*/
typedef UInt32 TextEncodingBase;
enum {
   kTextEncodingMacRoman = 0,
   kTextEncodingMacJapanese = 1,
   kTextEncodingMacChineseTrad = 2,
   kTextEncodingMacKorean = 3,
   kTextEncodingMacArabic = 4,
   kTextEncodingMacHebrew = 5,
   kTextEncodingMacGreek = 6,
   kTextEncodingMacCyrillic = 7,
   kTextEncodingMacDevanagari = 9,
   kTextEncodingMacGurmukhi = 10,
   kTextEncodingMacGujarati = 11,
   kTextEncodingMacOriya = 12,
   kTextEncodingMacBengali = 13,
   kTextEncodingMacTamil = 14,
   kTextEncodingMacTelugu = 15,
   kTextEncodingMacKannada = 16,
   kTextEncodingMacMalayalam = 17,
   kTextEncodingMacSinhalese = 18,
   kTextEncodingMacBurmese = 19,
   kTextEncodingMacKhmer = 20,
   kTextEncodingMacThai = 21,
   kTextEncodingMacLaotian = 22,
   kTextEncodingMacGeorgian = 23,
   kTextEncodingMacArmenian = 24,
   kTextEncodingMacChineseSimp = 25,
   kTextEncodingMacTibetan = 26,
   kTextEncodingMacMongolian = 27,
   kTextEncodingMacEthiopic = 28,
   kTextEncodingMacCentralEurRoman = 29,
   kTextEncodingMacVietnamese = 30,
   kTextEncodingMacExtArabic = 31,
   kTextEncodingMacSymbol = 33,
   kTextEncodingMacDingbats = 34,
   kTextEncodingMacTurkish = 35,
   kTextEncodingMacCroatian = 36,
   kTextEncodingMacIcelandic = 37,
   kTextEncodingMacRomanian = 38,
   kTextEncodingMacCeltic = 39,
   kTextEncodingMacGaelic = 40,
   kTextEncodingMacKeyboardGlyphs = 41
};

/*Compatibility TextEncodings

Specify text encodings that are provided for backward compatibility.

enum {
   kTextEncodingMacTradChinese = kTextEncodingMacChineseTrad,
   kTextEncodingMacRSymbol = 8,
   kTextEncodingMacSimpChinese = kTextEncodingMacChineseSimp,
   kTextEncodingMacGeez = kTextEncodingMacEthiopic,
   kTextEncodingMacEastEurRoman = kTextEncodingMacCentralEurRoman,
   kTextEncodingMacUninterp = 32
};*/
enum {
   kTextEncodingMacTradChinese = kTextEncodingMacChineseTrad,
   kTextEncodingMacRSymbol = 8,
   kTextEncodingMacSimpChinese = kTextEncodingMacChineseSimp,
   kTextEncodingMacGeez = kTextEncodingMacEthiopic,
   kTextEncodingMacEastEurRoman = kTextEncodingMacCentralEurRoman,
   kTextEncodingMacUninterp = 32
};

//func

/*UpgradeScriptInfoToTextEncoding

Converts any combination of a Mac OS script code, a language code, a region code, and a font name to a text encoding.

OSStatus UpgradeScriptInfoToTextEncoding (
   ScriptCode iTextScriptID,
   LangCode iTextLanguageID,
   RegionCode iRegionID,
   ConstStr255Param iTextFontname,
   TextEncoding * oEncoding
);
Parameters
iTextScriptID

A valid Script Manager script code. The Mac OS Script Manager defines constants for script codes using this format: smXxx. To designate the system script, specify the meta-value of smSystemScript. To designate the current script based on the font specified in the graphics port (grafPort), specify the metavalue of smCurrentScript. To indicate that you do not want to provide a script code for this parameter, specify the constant kTextScriptDontCare. 
iTextLanguageID

A valid Script Manager language code. The Mac OS Script Manager defines constants for language codes using this format: langXxx. To indicate that you do not want to provide a language code for this parameter, specify the constant kTextLanguageDontCare. 
iRegionID

A valid Script Manager region code. The Mac OS Script Manager defines constants for region codes using this format: verXxx. To indicate that you do not want to provide a region code for this parameter, specify the constant kTextRegionDontCare. 
iTextFontname

The name of a font associated with a particular text encoding specification, such as Symbol or Zapf Dingbats, or the name of any font that is currently installed on the system. To indicate that you do not want to provide a font name, specify a value of NULL. 
oEncoding

A pointer to a value of type TextEncoding. On return, this value holds the text encoding specification that the function created from the other values you provided. 
Return Value

A result code. See “TEC Manager Result Codes”. This function returns paramErr if two or more of the input parameter values conflict in some way—for example, the Mac OS language code does not belong to the script whose script code you specified, or if the input parameter values are invalid. The function returns a kTECTableFormatErr result code if the internal mapping tables used for translation are invalid.
Discussion

The UpgradeScriptInfoToTextEncoding function allows you to derive a text encoding specification from script codes, language codes, region codes, and font names. A one-to-one correspondence exists between many of the Script Manager’s script codes and a particular Mac OS text encoding base value. However, because text encodings are a superset of script codes, some combinations of script code, language code, region code, and font name might result in a different text encoding base value than would be the case if the translation were based on the script code alone. 

When you call the UpgradeScriptInfoToTextEncoding function, you can specify any combination of its parameters, but you must specify at least one. 

If you don’t specify an explicit value for a script, language, or region code parameter, you must pass the do-not-care constant appropriate to that parameter. If you do not specify an explicit value for iTextFontName, you must pass NULL. UpgradeScriptInfoToTextEncoding uses as much information as you supply to determine the equivalent text encoding or the closest approximation. If you provide more than one parameter, all parameters are checked against one another to ensure that they are valid in combination. 

A font name, such as 'Symbol' or 'Zapf Dingbats,' can indicate a particular text encoding base. Other font names can indicate particular variants associated with a particular text encoding base. Otherwise, the font name is used to obtain a script code, and this script code will be checked against any script code you supply (in this case, the font must be installed; if it is not, the function returns a paramErr result code). If you do not supply either a language code or a region code and the script code you supply or the one that is derived matches the system script, then the system’s localization is used to determine the appropriate region and language code. This is used for deriving text encoding base values that depend on region and language, such as kTextEncodingMacTurkish. 

For more information see the RevertTextEncodingToScriptInfo function and “Base Text Encodings”. 
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
TextCommon.h*/

OSStatus UpgradeScriptInfoToTextEncoding (
   ScriptCode iTextScriptID,
   LangCode iTextLanguageID,
   RegionCode iRegionID,
   ConstStr255Param iTextFontname,
   TextEncoding * oEncoding
);

/*CreateTextEncoding

Creates and returns a text encoding specification.

TextEncoding CreateTextEncoding (
   TextEncodingBase encodingBase,
   TextEncodingVariant encodingVariant,
   TextEncodingFormat encodingFormat
);
Parameters
encodingBase

A base text encoding.
encodingVariant

A variant of the base text encoding. To specify the default variant for the base encoding given in the encodingBase parameter, you can use the kTextEncodingDefaultVariant constant. 
encodingFormat

A format for the base text encoding. To specify the default format for the base encoding, you can use the kTextEncodingDefaultFormat constant. If you want to obtain a TextEncoding value that references UTF-16 or UTF-8, pass kUnicode16BitFormat or kUnicodeUTF8Format . 
Return Value

The text encoding specification that the function creates from the values you pass it.
Discussion

When you create a text encoding specification, the three values that you specify are packed into an unsigned integer, which you can then pass by value to the functions that use text encodings. See the data type TextEncodingRun. 
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
TextCommon.h*/

TextEncoding CreateTextEncoding (
   TextEncodingBase encodingBase,
   TextEncodingVariant encodingVariant,
   TextEncodingFormat encodingFormat
);

/*GetTextEncodingBase

Returns the base encoding of the specified text encoding. 

TextEncodingBase GetTextEncodingBase (
   TextEncoding encoding
);
Parameters
encoding

A text encoding specification whose base encoding you want to obtain. 
Return Value

The base encoding portion of the specified text encoding. 
Discussion

See the data type TextEncodingRun
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
TextCommon.h*/
TextEncodingBase GetTextEncodingBase (
   TextEncoding encoding
);


#ifdef __cplusplus
}
#endif

#endif