#ifndef CFHTTPSTREAM_H
#define CFHTTPSTREAM_H

#ifndef CFSTREAM_H
#include <CoreFoundation/CFStream.h>
#endif

#ifndef CFHTTPMESSAGE_H
#include <CFNetwork/CFHTTPMessage.h>
#endif


#ifndef  CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFStream HTTP Property Constants

Constants for setting and copying CFStream HTTP properties.

const CFStringRef kCFStreamPropertyHTTPAttemptPersistentConnection;
const CFStringRef kCFStreamPropertyHTTPFinalURL;
const CFStringRef kCFStreamPropertyHTTPProxy;
const CFStringRef kCFStreamPropertyHTTPRequestBytesWrittenCount;
const CFStringRef kCFStreamPropertyHTTPResponseHeader;
const CFStringRef kCFStreamPropertyHTTPShouldAutoredirect;
Constants
kCFStreamPropertyHTTPAttemptPersistentConnection

HTTP Attempt Persistent Connection property. The value of this property is a CFBoolean. If this property is set to kCFBooleanTrue, the HTTP stream looks for an appropriate existing persistent connection to use. If it cannot find one, the HTTP stream will try to create one.

Available in Mac OS X v10.2 and later.
kCFStreamPropertyHTTPFinalURL

HTTP Final URL property. A value of type CFURL containing the final HTTP URL. This value differs from the URL in the original HTTP request if an autoredirection occurred. This property cannot be set.

Available in Mac OS X v10.2 and later.
kCFStreamPropertyHTTPProxy

HTTP Proxy property. To cause an HTTP CFStream to use an HTTP proxy, set the value of this property to a CFDictionary that includes at least one host/port pair described in “CFStream SOCKS Proxy Key Constants” in CFStream Reference. SystemConfiguration returns a CFDictionary that is usable without modification.

Available in Mac OS X v10.2 and later.
kCFStreamPropertyHTTPRequestBytesWrittenCount

HTTP Request Bytes Written property. This property can only be retrieved; it cannot be set. The value of this property is a CFNumber containing the number of body bytes that have been written to the server thus far. HTTP header bytes are not included in the count. You can use this property to track the progress of HTTP uploads that take a substantial amount of time to complete.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyHTTPResponseHeader

HTTP Response Header property. When copied by CFReadStreamCopyProperty, the header of an HTTP response message is returned.

Available in Mac OS X v10.1 and later.
kCFStreamPropertyHTTPShouldAutoRedirect

HTTP Should Auto Redirect property. Set this property to kCFBooleanTrue to enable autoredirection; set this property to kCFBooleanFalse to disable autoredirection.
Discussion

The CFStream HTTP property constants are used to specify the HTTP property to set when calling CFReadStreamSetProperty or CFWriteStreamSetProperty. They are also used to specify the HTTP property to copy when calling CFReadStreamCopyProperty or CFWriteStreamCopyProperty.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
<CFNetwork/CFHTTPStream.h>*/
extern const CFStringRef kCFStreamPropertyHTTPAttemptPersistentConnection;
extern const CFStringRef kCFStreamPropertyHTTPFinalURL;
extern const CFStringRef kCFStreamPropertyHTTPProxy;
extern const CFStringRef kCFStreamPropertyHTTPRequestBytesWrittenCount;
extern const CFStringRef kCFStreamPropertyHTTPResponseHeader;
extern const CFStringRef kCFStreamPropertyHTTPShouldAutoredirect;

/*CFReadStreamCreateForHTTPRequest

Creates a read stream for a CFHTTP request message.

CFReadStreamRef CFReadStreamCreateForHTTPRequest (
    CFAllocatorRef alloc,
    CFHTTPMessageRef request
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
request

A CFHTTP request message whose body and headers have been set.
Return Value

A new read stream, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates a read stream and associates it with the specified request. Automatic redirection is disabled by default. After creating the read stream, you can call CFReadStreamGetError at any time to check the status of the stream. You may want to call CFHTTPReadStreamSetRedirectsAutomatically to enable automatic redirection, or CFHTTPReadStreamSetProxy to set the name and port number for a proxy. To serialize the request and send it, call CFReadStreamOpen.

If the body of the request is too long to keep in memory, call CFReadStreamCreateForStreamedHTTPRequest instead of this function.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPStream.h*/
CFReadStreamRef CFReadStreamCreateForHTTPRequest (
    CFAllocatorRef alloc,
    CFHTTPMessageRef request
);

#ifdef __cplusplus
}
#endif

#endif
