#import <AppKit/NSControl.h>
@class NSImage;

@interface NSSegmentedControl : NSControl 

/*selectedSegment

Returns the index of the selected segment of the receiver.

- (int)selectedSegment
Return Value

The index of the currently selected segment or -1 if no segment is selected. If the receiver allows multiple selections, this method returns the most recently selected segment.
Availability
Available in Mac OS X v10.3 and later.
See Also
– setSelectedSegment:*/
- (int)selectedSegment;

/*setImage:forSegment:

Sets the image for the specified segment.

- (void)setImage:(NSImage *)image forSegment:(int)segment
Parameters
image

The image to apply to the segment or nil if you want to clear the existing image. Images are not scaled to fit inside a segment. If the image is larger than the available space, it is clipped. 
segment

The index of the segment whose image you want to set. This method raises an NSRangeException if the index is out of bounds.
Availability
Available in Mac OS X v10.3 and later.
See Also
– imageForSegment:*/
- (void)setImage:(NSImage *)image forSegment:(int)segment;

/*setSelectedSegment:

Sets the selected segment of the receiver. 

- (void)setSelectedSegment:(int)selectedSegment
Parameters
selectedSegment

The zero-based index of the desired segment. This method raises an NSRangeException if the index is out of bounds.
Discussion

If the receiver allows multiple selections, this method selects the specified segment using setSelected:forSegment:. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– selectedSegment*/
- (void)setSelectedSegment:(int)selectedSegment;

/*setEnabled:forSegment:

Sets the enabled state of the specified segment 

- (void)setEnabled:(BOOL)flag forSegment:(int)segment
Parameters
flag

YES to enable the segment; otherwise, NO to disable it.
segment

The index of the segment you want to enable or disable. This method raises an NSRangeException if the index is out of bounds.
Availability
Available in Mac OS X v10.3 and later.
See Also
– isEnabledForSegment:*/
- (void)setEnabled:(BOOL)flag forSegment:(int)segment;

@end




