//inclu
#ifndef AEMACH_H
#define AEMACH_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef AEDATAMODEL_H
#include <AE/AEDataModel.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

#include <mach/message.h>
#ifdef __cplusplus
}
#endif
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*keyReplyPortAttr

enum {
   keyReplyPortAttr = 'repp'
};*/
enum {
   keyReplyPortAttr = 'repp'
};

/*AESendMessage

Sends an AppleEvent to a target process without some of the overhead required by AESend.

OSStatus AESendMessage (
   const AppleEvent * event,
   AppleEvent * reply,
   AESendMode sendMode,
   long timeOutInTicks
);
Parameters
event

A pointer to the Apple event to send.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AESendMessage function allows you to send Apple events by linking with just the Application Services framework, and not the entire Carbon framework, as required by AESend. Linking with Carbon brings in the HIToolbox framework, which requires that your application have a connection to the window server. Daemons and other applications that have no interface but wish to send and receive Apple events can use the following functions for working with Apple events at a lower level: AESendMessage, AEGetRegisteredMachPort, AEDecodeMessage, and AEProcessMessage. See the descriptions for those functions for more information on when you might use them.

The AESendMessage function is both asynchronous and thread-safe, so you could, for example, set up a thread to send an Apple event and wait for a reply. If you use threads, you must add a typeReplyPortAttr attribute to your event that identifies the mach port on which to receive the reply. 

If the target of an event sent with AESendMessage is the current process (as specified by using typeProcessSerialNumber of { 0, kCurrentProcess } in the Apple event being sent), the Apple event is dispatched directly to the appropriate event handler in your process and not serialized.
Availability
Not available in CarbonLib.
Available in Mac OS X v10.0 and later.
Declared In
AEMach.h*/
OSStatus AESendMessage (
   const AppleEvent * event,
   AppleEvent * reply,
   AESendMode sendMode,
   long timeOutInTicks
);

#ifdef __cplusplus
}
#endif

#endif 
