#include <stdio.h>
#include <vImage/vImage.h>


/*vImageTableLookUp_ARGB8888

This function transforms an ARGB8888 image by substituting each pixel value with another pixel value, as specified by four lookup tables. Each pixel is separated into its four channels—alpha, red, green, and blue. The substitution is done for each channel separately, using the appropriate table. Then the pixel is recombined into a single ARGB8888 value. The transformed image is placed in a destination buffer.

vImage_Error vImageTableLookUp_ARGB8888 (
const vImage_Buffer *src,
const vImage_Buffer *dest,
const Pixel_8 alphaTable[256],
const Pixel_8 redTable[256],
const  Pixel_8 greenTable[256],
const  Pixel_8 blueTable[256],
vImage_Flags flags
);
Parameters
src

A pointer to a structure of type vImage_Buffer containing the ARGB8888 source image.
dest

A pointer to a structure of type vImage_Buffer. On return, it contains the ARGB8888 destination image.
alphaTable

A lookup table to be used for the alpha channel of the source image. If you pass NULL for this table, the alpha channel will be copied unchanged to the destination buffer.
redTable

A lookup table to be used for the red channel of the source image. If you pass NULL for this table, the red channel will be copied unchanged to the destination buffer.
greenTable

A lookup table to be used for the green channel of the source image. If you pass NULL for this table, the green channel will be copied unchanged to the destination buffer.
blueTable

A lookup table to be used for the blue channel of the source image. If you pass NULL for this table, the blue channel will be copied unchanged to the destination buffer.
flags

The following flag is used: 
kvImageDoNotTile

Setting this flag prevents internal tiling and/or multithreading. Please see “Tiling for Cache Utilization”.
Return Value

If the function succeeds, it returns kvImageNoError. Otherwise it returns an error code.
Discussion

The source image and destination buffer must have the same height and the same width (in pixels). This function works in place.

Note that you can not use this function to do a completely arbitrary color mapping. If two different source colors have the same green component (just for example), they must be mapped to two destination colors whose green components are equal. They can not be mapped to two arbitrary colors.
Availability
Available in Mac OS X v10.3 and later.*/
vImage_Error vImageTableLookUp_ARGB8888 (
const vImage_Buffer *src,
const vImage_Buffer *dest,
const Pixel_8 alphaTable[256],
const Pixel_8 redTable[256],
const  Pixel_8 greenTable[256],
const  Pixel_8 blueTable[256],
vImage_Flags flags
){
printf ("vImageTableLookUp_ARGB8888",*src,*dest,alphaTable,redTable,greenTable,blueTable,flags);
};
