#include <QuickTime/QuickTime.h>

/*QTVRGetTiltAngle

Obtains the tilt angle of a QuickTime VR movie.

float QTVRGetTiltAngle (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

A floating-point value that represents the current tilt angle of the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetTiltAngle (
   QTVRInstance    qtvr ){
printf ("QTVRGetTiltAngle ",qtvr);
};


/*QTVRGetPanAngle

Obtains the pan angle of a QuickTime VR movie.

float QTVRGetPanAngle (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

A floating-point value that represents the current pan angle of the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetPanAngle (
   QTVRInstance    qtvr ){
printf ("QTVRGetPanAngle",qtvr);
};

/*QTVRWrapAndConstrain

Preflights a change in the viewing or control characteristics of a QTVR object or panoramic node.

OSErr QTVRWrapAndConstrain (
   QTVRInstance    qtvr,
   short           kind,
   float           value,
   float           *result );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
kind

A constraint type (see below). See these constants: 
kQTVRPan
kQTVRTilt
kQTVRFieldOfView
kQTVRViewCenterH
kQTVRViewCenterV
value

The desired value of the specified viewing characteristic.
result

On return, the value to which the specified viewing characteristic would be set if it were changed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the result parameter, the constrained or wrapped value that would result from setting the viewing or control characteristic specified by the kind parameter to the value specified by the value parameter. For example, if the kind parameter is set to kQTVRPan, then this function returns the value that would result from calling QTVRSetPanAngle with its panAngle parameter set to the value parameter. Similarly, you can use this function to find the current bounds of the view center. It takes into account the current constraints and wrapping modes of the node specified by the qtvr parameter. This function does not change the current view or other settings of the specified object or panorama.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRWrapAndConstrain (
   QTVRInstance    qtvr,
   short           kind,
   float           value,
   float           *result ){
printf ("QTVRWrapAndConstrain",qtvr,kind,value,*result);
};

//work

/*QTVRGetHotSpotType

Obtains the type of a QuickTime VR hot spot.

OSErr QTVRGetHotSpotType (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   OSType          *hotSpotType );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpotID

A hot spot ID.
hotSpotType

On entry, a pointer to a long integer. On return, that long integer contains the type of the hot spot specified by the hot spot ID.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function gets the type of a hot spot whose ID you specify. In combination with the kQTVRGetHotSpotTypeSelector intercept selector (see QTVRInstallInterceptProc), this allows an application to change a hot spot's type dynamically. For example, an application can take an existing movie and cause VR to display the cursors for a type of hotspot different from the one the movie was originally authored with. In combination with intercepting kQTVRTriggerHotSpotSelector, this would allow an Internet plugin to override undefined or link hotspots in movies to make them appear and act as though they are URL links instead. If kQTVRTriggerHotSpotSelector is not intercepted, VR will attempt to act on the hotspot in the normal way; by storing both link and URL data in a file, the exact behavior can be determined at runtime by an application to allow linking to either another node locally or a remote URL link, depending on system configuration or other arbitrary considerations.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetHotSpotType (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   OSType          *hotSpotType ){};

/*QTVRSetMouseOverHotSpotProc

Installs or removes a mouse over hot spot procedure.

OSErr QTVRSetMouseOverHotSpotProc (
   QTVRInstance               qtvr,
   QTVRMouseOverHotSpotUPP    mouseOverHotSpotProc,
   SInt32                     refCon,
   UInt32                     flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
mouseOverHotSpotProc

A Universal Procedure Pointer for a QTVRMouseOverHotSpotProc callback. To remove a previously installed QTVRMouseOverHotSpotUPP callback, set mouseOverHotSpotProc to NIL.
refCon

A reference constant. This value is passed to the specified mouse over hot spot callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the routine specified by the mouseOverHotSpotProc parameter as a mouse over hot spot procedure for the QuickTime VR movie specified by the qtvr parameter. Subsequent user actions (such as moving the cursor over an enabled hot spot in that movie) cause the callback routine to be executed. The reference constant specified by the refCon parameter is passed unchanged to your callback routine.
Special Considerations

Your mouse over hot spot procedure is called only for enabled hot spots.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetMouseOverHotSpotProc (
   QTVRInstance               qtvr,
   QTVRMouseOverHotSpotUPP    mouseOverHotSpotProc,
   SInt32                     refCon,
   UInt32                     flags ){};

/*NewQTVRMouseOverHotSpotUPP

Allocates a Universal Procedure Pointer for the QTVRMouseOverHotSpotProc callback.

QTVRMouseOverHotSpotUPP NewQTVRMouseOverHotSpotUPP (
   QTVRMouseOverHotSpotProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRMouseOverHotSpotProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVRMouseOverHotSpotUPP NewQTVRMouseOverHotSpotUPP (
   QTVRMouseOverHotSpotProcPtr    userRoutine ){};

/*QTVRRefreshBackBuffer

Refreshes the QTVR back buffer.

OSErr QTVRRefreshBackBuffer (
   QTVRInstance    qtvr,
   UInt32          flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function refreshes some or all of the back buffer associated with the QuickTime VR movie specified by the qtvr parameter by reloading the appropriate data from the diced frames in the panorama image track. You can call this function either in a back buffer imaging procedure or elsewhere in your application. If you call this function in a back buffer imaging procedure, only the current rectangle (that is, the rectangle specified by the procedure's drawRect parameter) is refreshed. If you call this function outside of a back buffer imaging procedure, all areas of interest specified in the most recent call to QTVRSetBackBufferImagingProc are refreshed.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRRefreshBackBuffer (
   QTVRInstance    qtvr,
   UInt32          flags ){};



/*QTVRSetBackBufferImagingProc

Installs or removes a QTVR back buffer imaging procedure.

OSErr QTVRSetBackBufferImagingProc (
   QTVRInstance                qtvr,
   QTVRBackBufferImagingUPP    backBufferImagingProc,
   UInt16                      numAreas,
   QTVRAreaOfInterest          areasOfInterest[],
   SInt32                      refCon );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
backBufferImagingProc

A Universal Procedure Pointer for a QTVRBackBufferImagingProc callback. To remove a previously installed back buffer imaging procedure, pass NIL.
numAreas

The number of area of interest structures in the array pointed to by the areasOfInterest parameter.
areasOfInterest[]

A pointer to an array of QTVRAreaOfInterest structures. Each structure defines a rectangular areas about which you want your back buffer imaging procedure to be notified. Your procedure is called for each area of interest as it becomes visible or not visible. You indicate when you want your procedure to be called for a particular area of interest by setting flags in the flags field in the corresponding area of interest structure. The width of the area of interest is limited by the size of the back buffer. If the back buffer is less than the full cache size, then the area of interest can be no wider than half the size of the back buffer. (For vertical cylinder geometries, limiting factor would be the height of the buffer.) For a full cache back buffer, the width of the area of interest can be the full size of the buffer. If the width limit is exceeded, this function returns constraintReachedErr. 
refCon

A reference constant. This value is passed to the specified back buffer imaging callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the backBufferImagingProc parameter as a back buffer imaging procedure for the panoramic node specified by the qtvr parameter. You can use that procedure to draw directly into the back buffer. Coordinates in the back buffer are dependent on the current correction mode; as a result, you need to indicate the area you're interested in drawing into by specifying a pan angle and tilt angle to determine the upper-left corner of the area and a height and width relative to that corner. Specifying a height and width instead of a second pair of pan and tilt angles for the bottom-right coordinate allows the rectangle to wrap around the edge of the panorama.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetBackBufferImagingProc (
   QTVRInstance                qtvr,
   QTVRBackBufferImagingUPP    backBufferImagingProc,
   UInt16                      numAreas,
   QTVRAreaOfInterest          areasOfInterest[],
   SInt32                      refCon ){};


/*QTVRGetNodeInfo

Obtains the node information atom container that describes a node and all the hot spots in the node.

OSErr QTVRGetNodeInfo (
   QTVRInstance       qtvr,
   UInt32             nodeID,
   QTAtomContainer    *nodeInfo );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

A node ID. Set this parameter to kQTVRCurrentNode to receive information about the current node.
nodeInfo

On return, a pointer to an atom container that contains information about the specified node.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the nodeInfo parameter, a pointer to an atom container that contains information about the node specified by the nodeID parameter in the movie specified by the qtvr parameter. The atom container includes information about all the hot spots contained in that node. You can use the QuickTime atom functions to extract atoms from that container. You can also use those functions to access the hot spot atom list. All hot spot atoms are contained in the hot spot parent atom.
Special Considerations

The node information atom container returned by this function is a copy of the atom container maintained internally by the QuickTime VR Manager. You should dispose of the node information atom container, by calling QTDisposeAtomContainer, when you're finished using it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetNodeInfo (
   QTVRInstance       qtvr,
   UInt32             nodeID,
   QTAtomContainer    *nodeInfo ){};


/*QTVRGetVRWorld

Obtains the VR world atom container for a movie.

OSErr QTVRGetVRWorld (
   QTVRInstance       qtvr,
   QTAtomContainer    *VRWorld );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
VRWorld

On return, a pointer to an atom container that contains information about the specified movie.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the VRWorld parameter, a pointer to an atom container that contains general scene information about the QuickTime VR movie specified by the qtvr parameter, as well as a list of all the nodes in that movie. You can use the QuickTime atom functions to extract atoms from that container.
Special Considerations

The VR world atom container returned by this function is a copy of the atom container maintained internally by the QuickTime VR Manager. You should dispose of the VR world atom container by calling QTDisposeAtomContainer when you're finished using it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetVRWorld (
   QTVRInstance       qtvr,
   QTAtomContainer    *VRWorld ){};

/*QTVRGetBackBufferSettings

Obtains information about the resolution, pixel format, and size of the back buffer maintained internally by QuickTime VR for caching a panoramic image in a particular pixel format.

OSErr QTVRGetBackBufferSettings (
   QTVRInstance    qtvr,
   UInt32          *geometry,
   UInt16          *resolution,
   UInt32          *cachePixelFormat,
   SInt16          *cacheSize );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
geometry

The type and orientation of the panorama data (see below). See these constants: 
kQTVRUseMovieGeometry
kQTVRVerticalCylinder
resolution

On entry, a pointer to an unsigned short integer. On return, that integer is set to the index of the current image resolution (see below). See these constants: 
kQTVRDefaultRes
kQTVRFullRes
kQTVRHalfRes
kQTVRQuarterRes
cachePixelFormat

On entry, a pointer to a long integer. On return, that long integer is set to the pixel format of the current panorama back buffer (see below). See these constants: 
cacheSize

On entry, a pointer to a short integer. On return, that integer is set to a value that describes the size of the current panorama back buffer. See these constants: 
kQTVRMinimumCache
kQTVRSuggestedCache
kQTVRFullCache
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, through the resolution parameter, the index of the current resolution for the QuickTime VR movie specified by the qtvr parameter. The index indicates which bit in the mask value returned by QTVRGetAvailableResolutions specifies the current resolution. For example, if the returned index is 1, the base resolution is being used. If the returned index is 2, then a resolution of half the base resolution is being used. This function also returns the pixel format and the cache size in the cachePixelFormat and cacheSize parameters, respectively.

The QuickTime VR file might not contain an image track corresponding to the resolution indicated by the resolution value returned. The QuickTime VR Manager may have set a lower resolution because memory is low, or the resolution may have been set by a call to QTVRSetBackBufferPrefs.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetBackBufferSettings (
   QTVRInstance    qtvr,
   UInt32          *geometry,
   UInt16          *resolution,
   UInt32          *cachePixelFormat,
   SInt16          *cacheSize ){};


/*QTVRGetNodeType

Obtains the type of a movie node.

OSType QTVRGetNodeType (
   QTVRInstance    qtvr,
   UInt32          nodeID );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

A node ID. Pass kQTVRCurrentNode for the current node.
Return Value

The type of the node specified by the nodeID parameter in the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSType QTVRGetNodeType (
   QTVRInstance    qtvr,
   UInt32          nodeID ){};


/*QTVRGetControlSetting

Obtains the current state of a control setting for an object node.

OSErr QTVRGetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               *enable );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
setting

A control setting (see below). See these constants: 
kQTVRWrapPan
kQTVRWrapTilt
kQTVRCanZoom
kQTVRReverseHControl
kQTVRReverseVControl
kQTVRSwapHVControl
kQTVRTranslation
enable

On entry, a pointer to a Boolean value. On return, that value is set to TRUE if the specified control setting is currently enabled for the specified object node or to FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, through the enable parameter, the current state of the control setting specified by the setting parameter for the object node specified by the qtvr parameter. If enable is TRUE, the specified setting is currently enabled; otherwise, the setting is disabled.
Special Considerations

QTVRGetControlSetting is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               *enable ){};

/*QTVRSetTiltAngle

Sets the tilt angle of a QuickTime VR movie.

OSErr QTVRSetTiltAngle (
   QTVRInstance    qtvr,
   float           tiltAngle );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
tiltAngle

The desired tilt angle of the specified movie. This value is constrained by the maximum and minimum tilt angles of the movie. If the angle falls outside of those constraints and the control setting kQTVRWrapTilt is disabled, the angle is set to the minimum or maximum, whichever is closer. If wrapping is enabled, the tilt angle is clipped to fall within the constraints. Tilt angle values are also clipped if the requested tilt angle, when combined with the current pan angle and field of view, would cause an image to lie outside the current constraints. 
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code constraintReachedErr if wrapping is off and the angle is set to the minimum or maximum constraint value.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetTiltAngle (
   QTVRInstance    qtvr,
   float           tiltAngle ){};

/*QTVRSetPanAngle

Sets the pan angle of a QuickTime VR movie.

OSErr QTVRSetPanAngle (
   QTVRInstance    qtvr,
   float           panAngle );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
panAngle

The desired pan angle of the specified movie. This value is constrained by the maximum and minimum pan angles of the movie. If the angle falls outside of those constraints and the control setting kQTVRWrapPan is disabled, the angle is set to the minimum or maximum, whichever is closer. If wrapping is enabled, the pan angle is clipped to fall within the constraints. Pan angle values are also clipped if the requested pan angle, when combined with the current tilt angle and field of view, would cause an image to lie outside the current constraints.
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code constraintReachedErr if wrapping is off and the angle is set to the minimum or maximum constraint value.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetPanAngle (
   QTVRInstance    qtvr,
   float           panAngle ){};



/*Disposes of a QTVRImagingCompleteUPP pointer.

void DisposeQTVRImagingCompleteUPP (
   QTVRImagingCompleteUPP    userUPP );
Parameters
userUPP

A QTVRImagingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

void DisposeQTVRImagingCompleteUPP (
   QTVRImagingCompleteUPP    userUPP ){};



/*DisposeQTVRBackBufferImagingUPP

Disposes of a QTVRBackBufferImagingUPP pointer.

void DisposeQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingUPP    userUPP );
Parameters
userUPP

A QTVRBackBufferImagingUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
void DisposeQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingUPP    userUPP ){};



/*QTVRGetCurrentNodeID

Obtains the current node of a movie.

UInt32 QTVRGetCurrentNodeID (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The ID of the current node of the specified movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
UInt32 QTVRGetCurrentNodeID (
   QTVRInstance    qtvr ){};


/*NewQTVRBackBufferImagingUPP

Allocates a Universal Procedure Pointer for the QTVRBackBufferImagingProc callback.

QTVRBackBufferImagingUPP NewQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRBackBufferImagingProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVRBackBufferImagingUPP NewQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingProcPtr    userRoutine ){};


/*NewQTVRImagingCompleteUPP

Allocates a Universal Procedure Pointer for the QTVRImagingCompleteProc callback.

QTVRImagingCompleteUPP NewQTVRImagingCompleteUPP (
   QTVRImagingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRImagingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
QTVRImagingCompleteUPP NewQTVRImagingCompleteUPP (
   QTVRImagingCompleteProcPtr    userRoutine ){};


/*QTVRSetAngularUnits

Sets the type of unit used when specifying QTVR angles.

OSErr QTVRSetAngularUnits (
   QTVRInstance        qtvr,
   QTVRAngularUnits    units );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
units

A constant (see below) that indicates the type of angular units to use. See these constants: 
kQTVRDegrees
kQTVRRadians
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the type of angular units to be used in all subsequent QuickTime VR Manager calls for the QuickTime VR movie specified by the qtvr parameter to the unit type specified by the units parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetAngularUnits (
   QTVRInstance        qtvr,
   QTVRAngularUnits    units ){};


/*QTVRGetQTVRTrack

Obtains a QTVR track contained in a QuickTime movie to use in the QTVRGetQTVRInstance call.

Track QTVRGetQTVRTrack (
   Movie     theMovie,
   SInt32    index );
Parameters
theMovie

A QuickTime movie.
index

The index of the desired QTVR track.
Return Value

A track identifier for the QTVR track that has the index specified by the index parameter in the QuickTime movie specified by the theMovie parameter. If there is no such track, or the movie is not a QTVR movie, this function returns the value NIL.
Discussion

Here's an example of using this function to help get an instance of a QTVR movie running in a movie controller:// QTVRGetQTVRTrack coding example
// See "Discovering QuickTime," page 390
QTVRInstance MyGetQTVRInstanceFromMC (MovieController mc)
{
    Track               track =NIL;
    QTVRInstance        qtvrinstance =NIL;
    Movie               movie =NIL;
    //Get the movie from the movie controller.
    movie =MCGetMovie(mc);
    if (movie !=NIL) {
        //Get the first QTVR track in the movie.
        track =QTVRGetQTVRTrack(movie, 1);
        //Get a QTVR instance for that QTVR track.
        if (track !=NIL) {
            QTVRGetQTVRInstance(qtvrinstance, track, mc);
            //Set our units to be degrees.
            if (qtvrinstance !=NIL)
                QTVRSetAngularUnits(qtvrinstance, kQTVRDegrees);
        }
    }
    return qtvrinstance;
}

Version Notes

Introduced in QuickTime 3 or earlier. QuickTime VR 2.1 supports files with at most one QTVR track; hence the value for the index parameter of a movie made with QuickTime VR 2.1 is always 1. Panorama and object movies made with QuickTime VR version 1.0 have no QTVR track. This function returns the track ID of the panorama track for version 1.0 panorama movies and the track ID of the image video track for version 1.0 object movies. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
Track QTVRGetQTVRTrack (
   Movie     theMovie,
   SInt32    index ){};


/*QTVRNudge

Turns one step in a particular direction and displays the new view.

OSErr QTVRNudge (
   QTVRInstance        qtvr,
   QTVRNudgeControl    direction );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
direction

The direction of the nudge (see below). Any value of the direction parameter that is not predefined is mapped to the closest defined value. See these constants: 
kQTVRRight
kQTVRUpRight
kQTVRUp
kQTVRUpLeft
kQTVRLeft
kQTVRDown
kQTVRDownRight
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function adjusts the current view of the movie specified by the qtvr parameter as indicated by the direction parameter. In particular, it turns one step in the indicated direction and displays the new view. For example, to move to the next view that is right and up from the current view, set the direction parameter to kQTVRUpRight (that is, pi/4 radians, or 45 degrees). For objects, if no view is located at the adjacent object view defined by the nudge direction and wrapping is off in the desired direction, then this function remains at the current view and returns the result code constraintReachedErr. For objects, this function is useful for changing to an adjacent view without having to know the new pan and tilt angles. The direction of the nudge is affected by the current control settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRNudge (
   QTVRInstance        qtvr,
   QTVRNudgeControl    direction ){};

/*QTVRUpdate

Forces an immediate update of a QuickTime VR movie image.

OSErr QTVRUpdate (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
imagingMode

An imaging mode. You can specify kQTVRCurrentMode (see below) to use the current imaging mode. See these constants: 
kQTVRCurrentMode
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function immediately updates the image for the QuickTime VR movie specified by the qtvr parameter, without waiting for the next call to MoviesTask in your application's main event loop. If you plan to call this function repeatedly for a movie instance, then for improved performance you should bracket those calls with calls to QTVRBeginUpdateStream and QTVREndUpdateStream.
Special Considerations

If you call this function after calling QTVRBeginUpdateStream but before calling QTVREndUpdateStream, the imagingMode parameter passed to it must be the same as the imagingMode parameter passed to QTVRBeginUpdateStream. If you do not specify the same imaging mode to those two functions, an error will result.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRUpdate (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode ){};



/*QTVRGetQTVRInstance

Obtains an instance of a QuickTime VR movie.

OSErr QTVRGetQTVRInstance (
   QTVRInstance       *qtvr,
   Track              qtvrTrack,
   MovieController    mc );
Parameters
qtvr

On return, an instance of the specified QuickTime VR movie.
qtvrTrack

A QTVR track contained in a QuickTime movie. You can obtain a reference to this track by calling QTVRGetQTVRTrack.
mc

An identifier for the movie controller to be associated with the new QuickTime VR movie instance. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If qtvrTrack does not specify a QTVR track, this function returns NIL in the qtvr parameter and an error code as its function result. See Error Codes. Returns noErr if there is no error.
Discussion

You need a QuickTime VR movie instance to call most other QuickTime VR functions. This function returns, in the qtvr parameter, an instance of the QuickTime VR movie specified by the qtvrTrack parameter. Here's an example of code that gets a QTVR instance:// QTVRGetQTVRInstance coding example
// See "Discovering QuickTime," page 390
QTVRInstance MyGetQTVRInstanceFromMC (MovieController mc)
{
    Track               track =NIL;
    QTVRInstance        qtvrinstance =NIL;
    Movie               movie =NIL;
    //Get the movie from the movie controller.
    movie =MCGetMovie(mc);
    if (movie !=NIL) {
        //Get the first QTVR track in the movie.
        track =QTVRGetQTVRTrack(movie, 1);
        //Get a QTVR instance for that QTVR track.
        if (track !=NIL) {
            QTVRGetQTVRInstance(qtvrinstance, track, mc);
            //Set our units to be degrees.
            if (qtvrinstance !=NIL)
                QTVRSetAngularUnits(qtvrinstance, kQTVRDegrees);
        }
    }
    return qtvrinstance;
}

Special Considerations

It's not necessary to dispose of a QuickTime VR movie instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRGetQTVRInstance (
   QTVRInstance       *qtvr,
   Track              qtvrTrack,
   MovieController    mc ){};





/*QTVRReplaceCursor

Replaces any of the standard QuickTime VR cursors with your own custom cursor.

OSErr QTVRReplaceCursor (
   QTVRInstance        qtvr,
   QTVRCursorRecord    *cursRecord );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
cursRecord

A pointer to a QTVRCursorRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function replaces one or more of the standard QuickTime VR cursors associated with the instance specified by the qtvr parameter with the cursors specified in the cursor record pointed to by the cursRecord parameter. If the type field of the specified cursor record is kQTVRUseDefaultCursor, the default cursor for the given resource ID is reloaded; in this case, the handle field of that record should be set to NIL.
Special Considerations

This function replaces the standard cursors only for the specified QuickTime VR movie instance. To replace the standard cursors for all QuickTime VR movie instances you create, you need to call this function for each such instance.
Version Notes

Introduced in QuickTime 3 or earlier. Note that QuickTime VR 2.1 makes a copy of the cursor handle specified in the cursor record. The application is responsible for disposing of its own cursor handle.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRReplaceCursor (
   QTVRInstance        qtvr,
   QTVRCursorRecord    *cursRecord ){};



/*QTVRGetConstraints

Obtains the current constraints of a QuickTime VR movie.

OSErr QTVRGetConstraints (
   QTVRInstance    qtvr,
   UInt16          kind,
   float           *minValue,
   float           *maxValue );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
kind

The type of constraints to be returned (see below). See these constants: 
kQTVRPan
kQTVRTilt
kQTVRFieldOfView

minValue

On entry, a pointer to a floating-point value. On return, the current minimum constraint of the specified type is copied into that value.
maxValue

On entry, a pointer to a floating-point value. On return, the current maximum constraint of the specified type is copied into that value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the floating-point values pointed to by the minValue and maxValue parameters, the current minimum and maximum constraints of the type specified by the kind parameter. The values returned by this function are unaffected by the current control settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRGetConstraints (
   QTVRInstance    qtvr,
   UInt16          kind,
   float           *minValue,
   float           *maxValue ){};

/*QTVREndUpdateStream

Ends a stream of immediate updates to a QuickTime VR movie.

OSErr QTVREndUpdateStream (
   QTVRInstance    qtvr );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function unlocks the memory locked by the matching call to QTVRBeginUpdateStream for the QuickTime VR movie specified by the qtvr parameter and reverses any other actions performed by that call. Each call to QTVRBeginUpdateStream must be balanced by a call to this function, but you can nest these calls. For nested calls, only the final call to this function unlocks the memory locked by the first call to QTVRBeginUpdateStream.
Special Considerations

QTVREndUpdateStream is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVREndUpdateStream (
   QTVRInstance    qtvr ){};


/*QTVRBeginUpdateStream

Begins a stream of immediate updates to a QuickTime VR movie.

OSErr QTVRBeginUpdateStream (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
imagingMode

An imaging mode (see below). See these constants: 
kQTVRStatic
kQTVRMotion
kQTVRAllModes

Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function configures the QuickTime VR movie specified by the qtvr parameter for a stream of immediate updates to its movie image. After calling QTVRBeginUpdateStream, you perform the updates by calling QTVRUpdate. When you are finished performing the updates, call QTVREndUpdateStream. Issuing a stream of image updates in this manner is significantly faster than simply calling QTVRUpdate repeatedly (that is, not within a begin/end update sequence). Each call to this function must be balanced by a call to QTVREndUpdateStream, but you can nest these calls.
Special Considerations

After you call this function and before you call QTVREndUpdateStream, you must not change any of the QuickTime VR movie's imaging properties.

Calling this function locks down large blocks of memory. As a result, you should minimize the amount of time before calling QTVREndUpdateStream.

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRBeginUpdateStream (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode ){};

/*QTVRSetPrescreenImagingCompleteProc

Installs or removes a prescreen buffer imaging completion procedure.

OSErr QTVRSetPrescreenImagingCompleteProc (
   QTVRInstance              qtvr,
   QTVRImagingCompleteUPP    imagingCompleteProc,
   SInt32                    refCon,
   UInt32                    flags );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
imagingCompleteProc

A Universal Procedure Pointer for a QTVRImagingCompleteProc callback. To remove a previously installed QTVRImagingCompleteProc callback, set imagingCompleteProc to NIL.
refCon

A reference constant. This value is passed to the specified prescreen buffer imaging completion callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

A constant (see below) that causes a draw attempt on every idle passed to the movie controller besides being called whenever QuickTime VR finishes drawing an image into the prescreen buffer. See these constants: 
kQTVRPreScreenEveryIdle

Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the imagingCompleteProc parameter as a prescreen buffer imaging completion procedure for the QuickTime VR movie specified by the qtvr parameter. Your procedure is called whenever QuickTime VR finishes drawing an image into the prescreen buffer. The reference constant specified by the refCon parameter is passed unchanged to that prescreen buffer imaging completion procedure.
Special Considerations

QTVRSetPrescreenImagingCompleteProc is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetPrescreenImagingCompleteProc (
   QTVRInstance              qtvr,
   QTVRImagingCompleteUPP    imagingCompleteProc,
   SInt32                    refCon,
   UInt32                    flags ){};

/*QTVRInstallInterceptProc

Installs or removes an intercept procedure for a QuickTime VR Manager function.

OSErr QTVRInstallInterceptProc (
   QTVRInstance        qtvr,
   QTVRProcSelector    selector,
   QTVRInterceptUPP    interceptProc,
   SInt32              refCon,
   UInt32              flags );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
selector

A selector (see below) that indicates which QuickTime VR function to intercept. See these constants: 
kQTVRSetPanAngleSelector
kQTVRSetTiltAngleSelector
kQTVRSetFieldOfViewSelector
kQTVRSetViewCenterSelector
kQTVRMouseEnterSelector
kQTVRMouseWithinSelector
kQTVRMouseLeaveSelector
kQTVRMouseDownSelector
kQTVRMouseStillDownSelector
kQTVRMouseUpSelector
kQTVRTriggerHotSpotSelector
kQTVRGetHotSpotTypeSelector

interceptProc

A Universal Procedure Pointer for a QTVRInterceptProc callback. Set this parameter to NIL to remove a previously installed intercept procedure.
refCon

A reference constant to be passed to your intercept callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the interceptProc parameter as an intercept procedure for the QuickTime VR function specified by the selector parameter for the QuickTime VR movie specified by the qtvr parameter. Your intercept procedure is called whenever QuickTime VR is about to execute the function you are intercepting.

Your procedure can simply replace the intercepted function, by returning TRUE in the cancel parameter; or it can call through to the intercepted function, by calling QTVRCallInterceptedProc; or it can allow the intercepted function to execute when the intercept procedure returns, by returning FALSE in the cancel parameter.

Here's an example of using this function:// QTVRInstallInterceptProc coding example
// See "Discovering QuickTime," page 398
QTVRInterceptUPP MyInstallInterceptProcedure (QTVRInstance qtvrinstance)
{
    QTVRInterceptUPP    lpfnIntercept;
    lpfnIntercept =NewQTVRInterceptProc(MyInterceptProc);
    QTVRInstallInterceptProc(qtvrinstance, kQTVRSetPanAngleSelector,
                                                lpfnIntercept, 0, 0);
    return lpfnIntercept
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRInstallInterceptProc (
   QTVRInstance        qtvr,
   QTVRProcSelector    selector,
   QTVRInterceptUPP    interceptProc,
   SInt32              refCon,
   UInt32              flags ){};

/*NewQTVRInterceptUPP

Allocates a Universal Procedure Pointer for the QTVRInterceptProc callback.

QTVRInterceptUPP NewQTVRInterceptUPP (
   QTVRInterceptProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRInterceptProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
QTVRInterceptUPP NewQTVRInterceptUPP (
   QTVRInterceptProcPtr    userRoutine ){};

/*NewQTVRLeavingNodeUPP

Allocates a Universal Procedure Pointer for the QTVRLeavingNodeProc callback.

QTVRLeavingNodeUPP NewQTVRLeavingNodeUPP (
   QTVRLeavingNodeProcPtr    userRoutine );

Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRLeavingNodeProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
QTVRLeavingNodeUPP NewQTVRLeavingNodeUPP (
   QTVRLeavingNodeProcPtr    userRoutine ){};


/*QTVRSetConstraints

Sets the constraints of a VR movie.

OSErr QTVRSetConstraints (
   QTVRInstance    qtvr,
   UInt16          kind,
   float           minValue,
   float           maxValue );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
kind

The type of constraint to set (see below). See these constants: 
kQTVRPan
kQTVRTilt
kQTVRFieldOfView

minValue

A floating-point value that contains the desired minimum constraint of the specified type.
maxValue

A floating-point value that contains the desired maximum constraint of the specified type.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the minimum and maximum constraints of the type specified by the kind parameter to the values specified by the minValue and maxValue parameters. Note that when you want to specify a pan angle constraint, the minValue and maxValue parameters should be specified so that a clockwise sweep from minValue to maxValue selects the desired angular expanse. For example, to constrain panning in the 90-degree expanse that spreads out 45 degrees on each side of the pan angle 0 degrees, you should set the minValue parameter to 315 degrees and the maxValue parameter to 45 degrees. Similarly, to constrain panning in the remaining 270-degree expanse, you should set the minValue parameter to 45 degrees and the maxValue parameter to 315 degrees.
Special Considerations

The values passed to this function are unaffected by the current control settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetConstraints (
   QTVRInstance    qtvr,
   UInt16          kind,
   float           minValue,
   float           maxValue ){};


/*QTVRSetEnteringNodeProc

Installs or removes a node-entering procedure.

OSErr QTVRSetEnteringNodeProc (
   QTVRInstance           qtvr,
   QTVREnteringNodeUPP    enteringNodeProc,
   SInt32                 refCon,
   UInt32                 flags );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
enteringNodeProc

A Universal Procedure Pointer for a QTVREnteringNodeProc callback. To remove a previously installed QTVREnteringNodeProc callback, set enteringNodeProc to NIL.
refCon

A reference constant. This value is passed to the specified node-entering callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the enteringNodeProc parameter as a node-entering procedure for the QuickTime VR movie specified by the qtvr parameter. Your procedure is called whenever a node is entered (either in response to user actions or in response to QuickTime VR Manager functions that change nodes). The reference constant specified by the refCon parameter is passed unchanged to that node-entering procedure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetEnteringNodeProc (
   QTVRInstance           qtvr,
   QTVREnteringNodeUPP    enteringNodeProc,
   SInt32                 refCon,
   UInt32                 flags ){};

/*NewQTVREnteringNodeUPP

Allocates a Universal Procedure Pointer for the QTVREnteringNodeProc callback.

QTVREnteringNodeUPP NewQTVREnteringNodeUPP (
   QTVREnteringNodeProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVREnteringNodeProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVREnteringNodeUPP NewQTVREnteringNodeUPP (
   QTVREnteringNodeProcPtr    userRoutine ){};


/*QTVRSetLeavingNodeProc

Installs or removes a node-leaving procedure.

OSErr QTVRSetLeavingNodeProc (
   QTVRInstance          qtvr,
   QTVRLeavingNodeUPP    leavingNodeProc,
   SInt32                refCon,
   UInt32                flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
leavingNodeProc

A Universal Procedure Pointer for a QTVRLeavingNodeProc callback. To remove a previously installed QTVRLeavingNodeProc callback, set leavingNodeProc to NIL.
refCon

A reference constant. This value is passed to the specified node-leaving callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the leavingNodeProc parameter as a node-leaving procedure for the QuickTime VR movie specified by the qtvr parameter. Your procedure is called whenever a node is left (either in response to user actions or in response to QuickTime VR Manager functions that change nodes). The reference constant specified by the refCon parameter is passed unchanged to that node-leaving procedure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetLeavingNodeProc (
   QTVRInstance          qtvr,
   QTVRLeavingNodeUPP    leavingNodeProc,
   SInt32                refCon,
   UInt32                flags ){};


/*QTVRGoToNodeID

Sets the current node of a movie.

OSErr QTVRGoToNodeID (
   QTVRInstance    qtvr,
   UInt32          nodeID );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

The ID of the node you want to be the current node. The QuickTime VR Manager defines several constants (see below) for specific nodes. See these constants: 
kQTVRCurrentNode
kQTVRPreviousNode
kQTVRDefaultNode

Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

Setting the current node also sets the pan, tilt, and field of view of the new current node to their default values. As a result, if you wish to set non-default angles, you should call this function before you call QTVRSetPanAngle, QTVRSetTiltAngle, or QTVRSetFieldOfView.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRGoToNodeID (
   QTVRInstance    qtvr,
   UInt32          nodeID ){};


/*QTVRShowDefaultView

Displays the default view of a QTVR node.

OSErr QTVRShowDefaultView (
   QTVRInstance    qtvr );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the default values of the pan angle, tilt angle, field of view, view center (for object nodes), default state, mouse-down state, and all applicable animation and control settings for the VR movie specified by the qtvr parameter. A VR movie's default view values are stored in the movie file.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRShowDefaultView (
   QTVRInstance    qtvr ){};


/*QTVRSetImagingProperty

Sets the value of an imaging property of a movie.

OSErr QTVRSetImagingProperty (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode,
   UInt32             imagingProperty,
   SInt32             propertyValue );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
imagingMode

An imaging mode (see below). See these constants: 
kQTVRStatic
kQTVRMotion
kQTVRAllModes

imagingProperty

An imaging property (see below). See these constants: 
kQTVRImagingCorrection
kQTVRImagingQuality
kQTVRImagingDirectDraw
kQTVRImagingCurrentMode

propertyValue

The desired value for the specified imaging property for the specified mode.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Default values for all imaging properties can be contained in a QuickTime VR movie file. If no defaults are specified in a movie file, the QuickTime VR Manager uses these values: for static mode, the kQTVRImagingQuality property is codecHighQuality and kQTVRImagingDirectDraw is TRUE; for motion mode, the kQTVRImagingQuality property is codecLowQuality and kQTVRImagingDirectDraw is TRUE. The default correction mode is kQTVRFullCorrection for both static and motion imaging modes. Note that it would look strange to have one correction mode for static imaging and a different correction mode for motion imaging. As a result, you should typically set the imagingMode parameter to kQTVRAllModes when setting a property of type kQTVRImagingCorrection.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetImagingProperty (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode,
   UInt32             imagingProperty,
   SInt32             propertyValue ){};



/*QTVRSetTransitionProperty

Sets the value of a transition property.

OSErr QTVRSetTransitionProperty (
   QTVRInstance    qtvr,
   UInt32          transitionType,
   UInt32          transitionProperty,
   SInt32          transitionValue );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
transitionType

A type of transition (see below). See these constants: 
kQTVRTransitionSwing

transitionProperty

A type of transition property (see below). See these constants: 
kQTVRTransitionSpeed
kQTVRTransitionDirection

transitionValue

The desired value for the specified transition property.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the value of the transition property whose type is specified by the transitionType and transitionProperty parameters for the movie specified by the qtvr parameter to the value specified by the transitionValue parameter. Note that calling this function simply sets a transition property's value; you must still call QTVREnableTransition to enable that transition effect.
Special Considerations

QTVRSetTransitionProperty is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetTransitionProperty (
   QTVRInstance    qtvr,
   UInt32          transitionType,
   UInt32          transitionProperty,
   SInt32          transitionValue ){};


/*QTVREnableTransition

Enables or disables a transition effect.

OSErr QTVREnableTransition (
   QTVRInstance    qtvr,
   UInt32          transitionType,
   Boolean         enable );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
transitionType

A type of transition property (see below). Currently only one constant is available for this parameter. See these constants: 
kQTVRTransitionSwing

enable

A Boolean value that indicates whether the specified transition property is to be enabled (TRUE) or disabled (FALSE).
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function enables or disables the transition property specified by the transitionType parameter for the movie specified by the qtvr parameter, as indicated by the value of the enable parameter. Once a transition effect is enabled, it is used at the appropriate time until it is disabled by a subsequent call to this function.
Special Considerations

QTVREnableTransition is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVREnableTransition (
   QTVRInstance    qtvr,
   UInt32          transitionType,
   Boolean         enable ){};


/*QTVRGetFieldOfView

Obtains the vertical field of view of a QuickTime VR movie.

float QTVRGetFieldOfView (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The current vertical field of view of the QuickTime VR movie specified by the qtvr parameter. The vertical field of view is a floating-point value that specifies the angle created by the two lines that connect the viewpoint to the top and bottom of the image.
Discussion

The following code fragment illustrates the use of this function:// QTVRGetFieldOfView coding example
#define kDirIn       4L
#define kDirOut      5L
void MyZoomInOrOut (QTVRInstance theInstance, long theDir)
{
    float    theFloat;
    theFloat =QTVRGetFieldOfView(theInstance);
    switch (theDir) {
        case kDirIn:
            theFloat =theFloat / 2.0;
            break;
        case kDirOut:
            theFloat =theFloat * 2.0;
            break;
        default:
            break;
    }
    QTVRSetFieldOfView(theInstance, theFloat);
    QTVRUpdate(theInstance, kQTVRStatic);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
float QTVRGetFieldOfView (
   QTVRInstance    qtvr ){};

/*QTVRSetFieldOfView

Sets the vertical field of view of a QuickTime VR movie.

OSErr QTVRSetFieldOfView (
   QTVRInstance    qtvr,
   float           fieldOfView );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
fieldOfView

The desired vertical field of view for the specified movie. This value is constrained by the maximum field of view of the movie. Values that lie outside that limit are clipped to the maximum. Pan and tilt angle values are also clipped if, when combined with the current field of view, they would cause an image to lie outside the current constraints.
Return Value

See Error Codes. Returns noErr if there is no error. If the control setting kQTVRCanZoom is disabled, the field of view is unchanged and this function returns the result code constraintReachedErr. You can use QTVRSetControlSetting to control the setting of kQTVRCanZoom.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetFieldOfView (
   QTVRInstance    qtvr,
   float           fieldOfView ){};

/*QTVRSetInteractionProperty

Sets the value of an interaction property.

OSErr QTVRSetInteractionProperty (
   QTVRInstance    qtvr,
   UInt32          property,
   void            *value );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
property

An interaction property type (see below). See these constants: 
kQTVRInteractionMouseClickHysteresis
kQTVRInteractionMouseClickTimeout
kQTVRInteractionPanTiltSpeed
kQTVRInteractionZoomSpeed
kQTVRInteractionTranslateOnMouseDown
kQTVRInteractionMouseMotionScale
kQTVRInteractionNudgeMode

value

The desired value of the specified interaction property.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the value of the interaction property of the type specified by the property parameter for the movie specified by the qtvr parameter to the value specified by the value parameter. For types that occupy 32 or fewer bits of memory, you pass the desired value itself (cast to a void* type) in the value parameter. For structures and floating-point values, you must pass a pointer to the desired value in the value parameter. Note that floating-point values are usually stored as 32-bit values, but compilers differ in how they pass floating-point values as parameters; as a result, this function demands that floating-point values always be passed by reference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetInteractionProperty (
   QTVRInstance    qtvr,
   UInt32          property,
   void            *value ){};


/*QTVREnableHotSpot

Enables or disables one or more QTVR hot spots.

OSErr QTVREnableHotSpot (
   QTVRInstance    qtvr,
   UInt32          enableFlag,
   UInt32          hotSpotValue,
   Boolean         enable );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
enableFlag

The kind of hot spot or hot spots to enable or disable (see below). See these constants: 
kQTVRHotSpotID
kQTVRHotSpotType
kQTVRAllHotSpots

hotSpotValue

The desired hot spot or spots, defined by the specified enabled flag (see below). 
enable

A Boolean value that indicates whether the specified hot spots are to be enabled (TRUE) or disabled (FALSE).
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function either enables or disables the hot spot or spots specified by the enableFlag and hotSpotValue parameters, according to the value of the enable parameter. The hot spots are always selected from among the hot spots in the current node of the QuickTime VR movie specified by the qtvr parameter.

Normally, all hot spots in a node are enabled (that is, the cursor automatically changes shape when it is moved over a hot spot, and the QTVRTriggerHotSpot function is called internally when the user clicks a hot spot). When a hot spot is disabled, QuickTime VR behaves as if the hot spot were not present.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVREnableHotSpot (
   QTVRInstance    qtvr,
   UInt32          enableFlag,
   UInt32          hotSpotValue,
   Boolean         enable ){};


/*QTVRGetFrameRate

Obtains the current frame rate of an object node.

float QTVRGetFrameRate (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The current frame rate of the object node specified by the qtvr parameter. A frame rate is a floating-point value in the range from -100.0 to +100.0.
Discussion

An object node's default frame rate is stored in the movie file.
Special Considerations

QTVRGetFrameRate is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetFrameRate (
   QTVRInstance    qtvr ){};
/*QTVRSetAnimationSetting

Sets the state of an animation setting for an object node.

OSErr QTVRSetAnimationSetting (
   QTVRInstance                  qtvr,
   QTVRObjectAnimationSetting    setting,
   Boolean                       enable );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
setting

An animation setting (see below). See these constants: 
kQTVRPalindromeViewFrames
kQTVRDontLoopViewFrames
kQTVRPlayEveryViewFrame
kQTVRSyncViewToFrameRate
kQTVRPalindromeViews
kQTVRPlayStreamingViews

enable

A Boolean value that indicates whether the specified animation setting is to be enabled for the specified object node (TRUE) or disabled (FALSE).
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

This function is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetAnimationSetting (
   QTVRInstance                  qtvr,
   QTVRObjectAnimationSetting    setting,
   Boolean                       enable ){};

/*QTVRSetControlSetting

Sets the state of a control setting for a QTVR object node.

OSErr QTVRSetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               enable );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
setting

A control setting (see below). See these constants: 
kQTVRWrapPan
kQTVRWrapTilt
kQTVRCanZoom
kQTVRReverseHControl
kQTVRReverseVControl
kQTVRSwapHVControl
kQTVRTranslation

enable

A Boolean value that indicates whether the specified control setting is to be enabled for the specified object node (TRUE) or disabled (FALSE).
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

This function is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               enable ){};

/*QTVREnableFrameAnimation

Enables or disables frame animation for an object node.

OSErr QTVREnableFrameAnimation (
   QTVRInstance    qtvr,
   Boolean         enable );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
enable

A Boolean value that indicates whether to enable (TRUE) or disable (FALSE) frame animation for the specified object node.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function enables or disables the frame animation state for the object node specified by the qtvr parameter, according to the value of the enable parameter. The current frame rate, set by the function QTVRSetFrameRate, is unaffected by the state of frame animation of an object node.
Special Considerations

This function is valid only for object nodes. You should use this function instead of standard QuickTime functions to control object animation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVREnableFrameAnimation (
   QTVRInstance    qtvr,
   Boolean         enable ){};

/*QTVRSetBackBufferPrefs

Sets the resolution, pixel format, and size of the back buffer maintained internally by QuickTime VR for caching a panoramic image in a particular pixel format.

OSErr QTVRSetBackBufferPrefs (
   QTVRInstance    qtvr,
   UInt32          geometry,
   UInt16          resolution,
   UInt32          cachePixelFormat,
   SInt16          cacheSize );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
geometry

The type and orientation of the panorama data (see below). See these constants: 
kQTVRUseMovieGeometry
kQTVRVerticalCylinder

resolution

The desired image resolution (see below). See these constants: 
kQTVRDefaultRes
kQTVRFullRes
kQTVRHalfRes
kQTVRQuarterRes

cachePixelFormat

The desired pixel format for the back buffer (see below). See these constants: 

cacheSize

The desired size for the panorama back buffer (see below). See these constants: 
kQTVRMinimumCache
kQTVRSuggestedCache
kQTVRFullCache

Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the resolution, pixel format, and size of the panorama back buffer for the movie specified by the qtvr parameter to the values specified by the resolution parameter an the cachePixelFormat and cacheSize parameters. You can specify a resolution that isn't contained in the movie file; if you do so, QuickTime VR takes the highest resolution image in the file and reduces it to fit into the specified buffer size. If you specify an unsupported pixel format, this function may return an error.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetBackBufferPrefs (
   QTVRInstance    qtvr,
   UInt32          geometry,
   UInt16          resolution,
   UInt32          cachePixelFormat,
   SInt16          cacheSize ){};


/*QTVRSetViewCenter

Sets the view center of a QuickTime VR movie.

OSErr QTVRSetViewCenter (
   QTVRInstance            qtvr,
   const QTVRFloatPoint    *viewCenter );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
viewCenter

A pointer to a QTVRFloatPoint structure that contains the desired view center of the specified movie. This point is constrained by the current field of view of the movie. The values you pass in the QTVRFloatPoint structure are adjusted so that the magnified area does not show anything outside the view.
Return Value

See Error Codes. Returns noErr if there is no error. If the kQTVRTranslation control setting is disabled, this function returns the result code constraintReachedErr and doesn't change the current view center. You can use QTVRSetControlSetting to control the setting of kQTVRTranslation.
Special Considerations

QTVRSetViewCenter is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetViewCenter (
   QTVRInstance            qtvr,
   const QTVRFloatPoint    *viewCenter ){};

/*QTVRSetFrameRate

Sets the frame rate of an object node.

OSErr QTVRSetFrameRate (
   QTVRInstance    qtvr,
   float           rate );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
rate

The desired frame rate of the specified movie. A frame rate is a floating-point value in the range from -100.0 to +100.0. Positive values indicate forward rates, and negative values indicate reverse rates. Set this parameter to 0 to stop the movie. If the value specified lies outside the valid range, this function returns the result code constraintReachedErr and sets the frame rate to the nearest constraint.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is most useful when an object is being viewed with a looping animation. (The current view of the object may contain frames that are played in a loop, as specified by the file format.) You can use this function to change the frame rate of the loop.
Special Considerations

This function is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetFrameRate (
   QTVRInstance    qtvr,
   float           rate ){};


/*QTVRSetViewState

Sets the value of a QTVR view state.

OSErr QTVRSetViewState (
   QTVRInstance         qtvr,
   QTVRViewStateType    viewStateType,
   UInt16               state );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
viewStateType

A view state type (see below). See these constants: 
kQTVRDefault
kQTVRCurrent
kQTVRMouseDown

state

The desired value of the specified type of view state.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

QTVRSetViewState is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetViewState (
   QTVRInstance         qtvr,
   QTVRViewStateType    viewStateType,
   UInt16               state ){};


/*QTVRGetViewCurrentTime

Obtains the current time in the current view.

TimeValue QTVRGetViewCurrentTime (
   QTVRInstance    qtvr );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The current time in the current view of the object node specified by the qtvr parameter. The returned value is always greater than or equal to 0 and less than or equal to the value returned by QTVRGetCurrentViewDuration.
Special Considerations

QTVRGetViewCurrentTime is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
TimeValue QTVRGetViewCurrentTime (
   QTVRInstance    qtvr ){};

/*QTVRSetViewCurrentTime

Sets the time in the current QTVR view.

OSErr QTVRSetViewCurrentTime (
   QTVRInstance    qtvr,
   TimeValue       time );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
time

The desired time in the current view. This value should be greater than or equal to 0 and less than or equal to the value returned by QTVRGetCurrentViewDuration.
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code timeNotInViewErr if the specified time value is greater than or equal to the view duration of the specified object node; in addition, it sets the current view time to 1 less than the view duration. Similarly, this function returns the result code timeNotInViewErr if the specified time value is less than 0; in that case, it sets the current view time to 0.
Special Considerations

QTVRSetViewCurrentTime is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetViewCurrentTime (
   QTVRInstance    qtvr,
   TimeValue       time ){};



/*QTVRGetViewRate

Obtains the current view rate of an object node.

float QTVRGetViewRate (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The current view rate of the object node specified by the qtvr parameter. A view rate is a floating-point value in the range from -100.0 to +100.0. An object node's default view rate is stored in the movie file.
Special Considerations

This function is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
float QTVRGetViewRate (
   QTVRInstance    qtvr ){};


/*QTVRSetViewRate

Sets the view rate of a QTVR object node.

OSErr QTVRSetViewRate (
   QTVRInstance    qtvr,
   float           rate );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
rate

The desired view rate of the specified movie. A view rate is a floating-point value in the range from -100.0 to +100.0. Positive values indicate forward rates, and negative values indicate reverse rates. Set this parameter to 0 to stop the movie.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the view rate of the object node specified by the qtvr parameter to the rate specified by the rate parameter. A node's view rate might be modified by the current animation settings. If the value specified in the rate parameter lies outside the valid range, this function returns the result code constraintReachedErr and sets the view rate to the nearest constraint.
Special Considerations

QTVRSetViewRate is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetViewRate (
   QTVRInstance    qtvr,
   float           rate ){};


/*QTVREnableViewAnimation

Enables or disables view animation for an object node.

OSErr QTVREnableViewAnimation (
   QTVRInstance    qtvr,
   Boolean         enable );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
enable

A Boolean value that indicates whether to enable (TRUE) or disable (FALSE) view animation for the specified object node.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You should use this function instead of standard QuickTime functions to control object animation.
Special Considerations

This function is valid only for object nodes. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVREnableViewAnimation (
   QTVRInstance    qtvr,
   Boolean         enable ){};


/*QTVRSetVisible

Sets a VR movie's visibility state.

OSErr QTVRSetVisible (
   QTVRInstance    qtvr,
   Boolean         visible );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
visible

A Boolean value that indicates whether the specified movie is to be visible (TRUE) or not (FALSE).
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Setting the visibility state to FALSE is useful if you want to turn off imaging a QuickTime VR movie without purging the associated data from memory. When a panoramic node's visibility state is FALSE, the corrected image is still drawn to the prescreen buffer. You can access the data in that buffer by calling QTVRSetPrescreenImagingCompleteProc.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetVisible (
   QTVRInstance    qtvr,
   Boolean         visible ){};

/*QTVRTriggerHotSpot

Triggers a QTVR hot spot.

OSErr QTVRTriggerHotSpot (
   QTVRInstance       qtvr,
   UInt32             hotSpotID,
   QTAtomContainer    nodeInfo,
   QTAtom             selectedAtom );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpotID

A hot spot ID.
nodeInfo

A node information atom container, obtained from a previous call to QTVRGetNodeInfo. You can pass the value 0 in this parameter to have QuickTime determine the appropriate node information atom container.
selectedAtom

The atom of the hot spot to trigger. You can pass the value 0 in this parameter to have QuickTime determine the appropriate hot spot atom.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

One way you can use this function is to execute any hot spot without the user's having clicked it. Usually, you need only specify the qtvr instance and the hot spot ID. You can pass zero for the nodeInfo and selectedAtom parameters.

The more common use of this function is not in calling it directly, but in setting up an intercept procedure on it. This function is called internally by QuickTime whenever a user clicks a hot spot. You can intercept calls to trigger your custom hot spots, which allows you to perform any custom actions you desire.

When this function is called internally (and then intercepted by your intercept procedure), the nodeInfo and selectedAtom parameters have been properly set by QuickTime and are available for your use. For undefined hot spots that do not have an associated hot spot atom in the node info atom container, the selectedAtom parameter will be set to zero.
Special Considerations

You can call this function even on hot spots that are currently disabled.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRTriggerHotSpot (
   QTVRInstance       qtvr,
   UInt32             hotSpotID,
   QTAtomContainer    nodeInfo,
   QTAtom             selectedAtom ){};


/*QTVRGetHotSpotRegion

Obtains the region occupied by a hot spot.

OSErr QTVRGetHotSpotRegion (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   RgnHandle       hotSpotRegion );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpotID

A hot spot ID.
hotSpotRegion

On entry, an initialized handle to a region. On return, this region is rewritten with the region occupied by the hot spot having the specified ID.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The returned region is clipped to the bounds of the movie's graphics world. You can obtain the regions of all visible hot spots by calling QTVRGetVisibleHotSpots and then calling this function for each hot spot ID in the list.
Special Considerations

The first time you call this function, a significant amount of memory might need to be allocated. Accordingly, you should always check for Memory Manager errors returned by this function. Your application is responsible for disposing of the memory occupied by the returned region.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRGetHotSpotRegion (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   RgnHandle       hotSpotRegion ){};

/*QTVRGetVisibleHotSpots

Obtains a list of the currently visible hot spots in a QuickTime VR movie.

UInt32 QTVRGetVisibleHotSpots (
   QTVRInstance    qtvr,
   Handle          hotSpots );

Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpots

On entry, a valid handle to a block of memory. On return, that block of memory is filled with a list of the IDs of the visible hot spots in the specified QuickTime VR movie. If necessary, the handle is resized to hold all the hot spot IDs. Accordingly, the handle must be unlocked at the time you call this function.
Return Value

The number of hot spot IDs returned though the hotSpots parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

UInt32 QTVRGetVisibleHotSpots (
   QTVRInstance    qtvr,
   Handle          hotSpots ){};



















