#include <QuickTime/QuickTime.h>


/*ExitMoviesOnThread

Indicates to QuickTime that the client will no longer be using QuickTime on the current thread.

OSErr ExitMoviesOnThread (void);
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a previous call to EnterMoviesOnThread was not made.
Discussion

This function should be called before exiting from a spawned thread that uses QuickTime. It undoes the setup performed by EnterMoviesOnThread. Each call to EnterMoviesOnThread should be matched with a call to this function. This function should not be called on a thread without a previous call to EnterMoviesOnThread.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExitMoviesOnThread (void){
printf ("ExitMoviesOnThread");
};


/*EnterMoviesOnThread

Indicates that the client will be using QuickTime on the current thread.

OSErr EnterMoviesOnThread (UInt32 inFlags);
Parameters
inFlags

Flag (see below) indicating how the executing thread will use QuickTime. Setting the thread mode is a convenience provided by this function. Pass 0 for the default options. See these constants: 
kQTEnterMoviesFlagDontSetComponentsThreadMode
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. This function returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a second call on the thread was made that used incompatible flags (for example, the first call required a shared state but a subsequent call required a private state).
Discussion

This function is analogous to EnterMovies. It initializes QuickTime and prepares QuickTime for calls from its thread. Unlike EnterMovies, this function allows the client to indicate if its access to QuickTime requires sharing of QuickTime state with the main thread. The default is to maintain a private state. 
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr EnterMoviesOnThread (UInt32 inFlags){
printf ("EnterMoviesOnThread ", inFlags);
};

/*MCDoAction

Invokes a movie controller component and makes it perform a specified action.

ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

The action to be taken. See Movie Controller Actions.
params

A pointer to the parameter data appropriate to the action. See Movie Controller Actions for information about the parameters required for each supported action.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params ){
printf ("MCDoAction", mc , action , params);
};


/*QTSoundDescriptionGetProperty

Gets a particular property of a sound description.

OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);
Parameters
inDesc

The sound description being interrogated.
inPropClass

The class of the property being requested. 
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

A pointer to the property value buffer.
outPropValueSizeUsed

The actual size of the returned property value (can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed){
printf ("QTSoundDescriptionGetProperty", inDesc , inPropClass, inPropID, inPropValueSize, outPropValueAddress, *outPropValueSizeUsed);
};


/*QTNewAlias

Creates a Mac OS alias to a file.

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );
Parameters
fss

A pointer to an FSSpec structure that specifies a file.
alias

On return, a pointer to a handle to a new AliasRecord structure that defines an alias to the file. If the function was unable to create an alias, the handle is set to NIL. This function does not create relative aliases. For further information about Mac OS file aliases, see Chapter 4 of Inside Macintosh: Files.
minimal

If you pass TRUE, the function writes in the AliasRecord structure only the target name, parent directory ID, volume name and creation date, and volume mounting information. If you pass FALSE, it fills out the structure fully.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal ){
printf ("QTNewAlias",*fss,*alias, minimal);
};




/*QTLockContainer

Locks an atom container in memory.

OSErr QTLockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be locked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to lock an atom container before calling QTGetAtomDataPtr to directly access a leaf atom's data. When you have finished accessing a leaf atom's data, you should call QTUnlockContainer. You may make nested pairs of calls to QTLockContainer and QTUnlockContainer; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTLockContainer (
   QTAtomContainer    container ){
printf ("QTLockContainer", container);
};

/*QTFindChildByIndex

Retrieves an atom by index from the child list of the specified parent atom.

QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
index

The index of the atom to be retrieved.
id

A pointer to an uninitialized QTAtomID data structure. On return, if the atom specified by index was found, the QTAtomID data structure contains the atom's ID. If you don't want this function to return the atom's ID, set the value of the id parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and index within that type from a parent atom's child list. The following code illustrates one way to use it:// QTFindChildByIndex coding example
if ((propertyAtom =QTFindChildByIndex (sprite, kParentAtomIsContainer,
    kSpritePropertyImageIndex, 1, NIL)) ==0)
    FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
        kSpritePropertyImageIndex, 1, 1, sizeof(short),&imageIndex,
        NIL));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id ){
printf ("QTFindChildByIndex",container,parentAtom, atomType, index, *id);
};


/*QTGetAtomDataPtr

Retrieves a pointer to the atom data for a specified leaf atom.

OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be retrieved.
dataSize

On return, contains a pointer to the length, in bytes, of the leaf atom's data.
atomData

On return, contains a pointer to the leaf atom's data.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function in retrieve a pointer to a leaf atom's data so that you can access the data directly.
Special Considerations

To ensure that the pointer returned in the atomData parameter will remain valid if memory is moved, you should call QTLockContainer before you call this function. If you call QTLockContainer, you should call QTUnlockContainer when you have finished using the atomData pointer. If you pass a locked atom container to a function that resizes atom containers, the function returns an error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData ){
printf ("QTGetAtomDataPtr", container, atom, *dataSize, *atomData);
};



/*QTUnlockContainer

Unlocks an atom container in memory.

OSErr QTUnlockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be unlocked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to unlock an atom container when you have finished accessing a leaf atom's data. You may make nested pairs of calls to QTLockContainer and this function; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTUnlockContainer (
   QTAtomContainer    container ){
printf ("QTUnlockContainer" , container);
};





/*QTDisposeAtomContainer

Disposes of an atom container.

OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );
Parameters
atomData

The atom container to be disposed of.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to dispose of an atom container data structure that was created by QTNewAtomContainer or QTCopyAtom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData ){
printf ("QTDisposeAtomContainer",atomData);
};


/*NewMovieFromProperties

Creates a new movie using movie properties.

OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );
Parameters
inputPropertyCount

The number of properties in the array passed in inputProperties.
inputProperties

A pointer to a property array describing how to instantiate the movie. See QTNewMoviePropertyElement.
outputPropertyCount

The number of properties in the array passed in outputProperties.
outputProperties

A pointer to a property array to receive output parameters. See QTNewMoviePropertyElement. You may pass NULL if you don't want this information. The caller is responsible for calling the appropriate routines to dispose of any property values returned here. Since callers specify the property classes and IDs, they know who to call to dispose of the property values.
theMovie

A pointer to a variable that receives the new movie.
Return Value

An error code. Returns memFullErr if the function could not allocate memory, paramErr if inputProperties or theMovie is NULL, or noErr if there is no error.
Discussion

This function can be used in all the cases where an existing NewMovieFrom... call is used. When calling this function, you supply a set of input properties that describe the information required to instantiate the movie (its data reference, audio context, visual context, and so on). You can also supply a set of output properties that you may be interested in; for example, information about whether the data reference was changed. See New Movie Property Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie ){
printf ("NewMovieFromProperties", inputPropertyCount,*inputProperties,outputPropertyCount,*outputProperties,*theMovie);
};

/*GoToBeginningOfMovie

Repositions a movie to play from its start.

void GoToBeginningOfMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Discussion

If the movie is in preview mode, the function goes to the start of the preview segment of the movie. In all other cases, this function goes to the start of the movie, where the movie time value is 0. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GoToBeginningOfMovie (
   Movie    theMovie ){
printf ("GoToBeginningOfMovie", theMovie);
};


/*GetMovieTimeBase

Returns a movie's time base.

TimeBase GetMovieTimeBase (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's TimeBaseRecord structure.
Special Considerations

The Movie Toolbox disposes of a movie's time base when you dispose of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase GetMovieTimeBase (
   Movie    theMovie ){
printf ("GetMovieTimeBase", theMovie);
};



/*StopMovie

Stops the playback of a movie.

void StopMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void StopMovie (
   Movie    theMovie ){
printf ("StopMovie", theMovie);
};



/*GetTrackMedia

Determines the media that contains a track's sample data.

Media GetTrackMedia (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The media identifier for the media that contains the track's sample data. If the function could not locate the media, it sets this returned value to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Media GetTrackMedia (
   Track    theTrack ){
printf ("GetTrackMedia", theTrack);
};



/*SetTimeBaseFlags

Sets the contents of the control flags of a time base.

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
timeBaseFlags

The control flags for this time base (see below). You may set only one flag to 1. Be sure to set unused flags to 0. See these constants: 
loopTimeBase
palindromeLoopTimeBase
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags ){
printf ("SetTimeBaseFlags",tb,timeBaseFlags);
};


/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse ){
printf ("MoviesTask",theMovie,maxMilliSecToUse);
};


/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie ){
printf ("UpdateMovie",theMovie);
};


/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime ){
printf ("GetMovieTime", theMovie,*currentTime);
};

/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext){
printf ("SetMovieVisualContext", movie,visualContext);
};


/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh ){
printf (" SetMovieGWorld", theMovie,port, gdh);
};




/*MovieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags ){
printf ("MovieAudioExtractionFillBuffer", session,*ioNumFrames,*ioData,*outFlags);
};


/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags ){
printf ("MovieAudioExtractionGetPropertyInfo",session,inPropClass,inPropID,*outPropType,*outPropValueSize, *outPropertyFlags);
};

/*SetMovieSelection

Sets a movie's current selection.

void SetMovieSelection (
   Movie        theMovie,
   TimeValue    selectionTime,
   TimeValue    selectionDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
selectionTime

A time value specifying the starting point of the current selection.
selectionDuration

A time value that specifies the duration of the current selection.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieSelection (
   Movie        theMovie,
   TimeValue    selectionTime,
   TimeValue    selectionDuration ){
printf ("SetMovieSelection", theMovie, selectionTime, selectionDuration);
};

/*AddMediaSampleReference

Works with samples that have already been added to a movie data file.

OSErr AddMediaSampleReference (
   Media                      theMedia,
   long                       dataOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOffset

The offset into the movie data file. This parameter is used differently by each data handler. For example, for the standard HFS data handler, this parameter specifies the offset into the file. This parameter contains either data you add yourself or the data offset returned by GetMediaSampleReference.
size

The number of bytes of sample data to be identified by the reference. This parameter indicates the total number of bytes in the sample data, not the number of bytes per sample. Use numberOfSamples to indicate the number of samples that are contained in the reference.
durationPerSample

The duration of each sample in the reference. You must specify this parameter in the media's time scale. For example, if you are referring to sound that was sampled at 22 kHz in a media that contains a sound track with the same time scale, to add a reference to a single sample you would set durationPerSample to 1. Similarly, if you are referring to video that was recorded at 10 frames per second in a video media that has a time scale of 60, you would set this parameter to 6 to add a reference to a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a sound description structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the reference. For details, see AddMediaSample. If the media does not require a SampleDescription structure, set this parameter to NIL.
sampleFlags

Contains flags (see below) that control the operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the reference to the media, the AddMediaSampleReference function returns the time where the reference was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function does not add sample data to the file or device that contains a media. Rather, it defines references to sample data that you previously added to a movie data file. Instead of actually writing out samples to disk, this function writes out references to existing samples, which you specify in dataOffset and the size parameter. As with AddMediaSample, your application specifies the media for the operation. Note that one reference may refer to more than one sample; all the samples described by a reference must be the same size. This function does not update the movie data file as part of the add operation. Therefore, your application does not have to call BeginMediaEdits before calling AddMediaSampleReference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddMediaSampleReference (
   Media                      theMedia,
   long                       dataOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime ){
printf ("AddMediaSampleReference",theMedia,dataOffset,size,durationPerSample,sampleDescriptionH,numberOfSamples,sampleFlags,*sampleTime);
};


/*DisposeMatte

Disposes of a matte obtained from the GetTrackMatte function.

void DisposeMatte (
   PixMapHandle    theMatte );
Parameters
theMatte

Handle to the matte to be disposed. Your application obtains this handle from GetTrackMatte.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMatte (
   PixMapHandle    theMatte ){
printf ("DisposeMatte",theMatte);
};


/*SetMovieAudioContext

Targets a movie to render into an audio context.

OSStatus SetMovieAudioContext (
   Movie      movie,
   QTAudioContextRef    audioContext;
Parameters
movie

The movie.
audioContext

The audio context that the movie will render into.
Return Value

An error code. Returns noErr if there is no error. .
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioContext (
   Movie      movie,
   QTAudioContextRef    audioContext){
printf ("SetMovieAudioContext",movie,audioContext);
};

/*GetTrackMatte

Retrieves a copy of a track's matte.

PixMapHandle GetTrackMatte (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to a PixMap structure that represents the specified track's matte. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

The matte defines which of the track's pixels are displayed in a movie, and it is valid for the entire duration of the movie.
Special Considerations

You should use DisposeMatte to dispose of the matte when you are finished with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
PixMapHandle GetTrackMatte (
   Track    theTrack ){
printf ("GetTrackMatte",theTrack);
};


/*SetTrackMatte

Sets a track's matte.

void SetTrackMatte (
   Track           theTrack,
   PixMapHandle    theMatte );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
theMatte

A handle to the matte. The Movie Toolbox makes a copy of the matte, including its ColorTable structure and pixels. Consequently, your application must dispose of the matte when you are done with it. Set this parameter to NIL to remove the track's matte.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This matte defines which of the track's pixels are displayed in a movie. You must specify the matte in a PixMap structure. The Movie Toolbox displays the weighted average of the track and its destination based on the corresponding pixel in the matte.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackMatte (
   Track           theTrack,
   PixMapHandle    theMatte ){
printf ("SetTrackMatt",theTrack,theMatte);
};


/*ConvertFileToMovieFile

Converts a file to a movie file and supports a user settings dialog box for import operations.

OSErr ConvertFileToMovieFile (
   const FSSpec         *inputFile,
   const FSSpec         *outputFile,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp,
   MovieProgressUPP     proc,
   long                 refCon );
Parameters
inputFile

A pointer to the file system specification for the file to be converted into a movie file.
outputFile

A pointer to the file specification for the destination movie file.
creator

The creator value for the file if it is a new one.
scriptTag

The script in which the movie file should be converted. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
resID

A pointer to a field that is to receive the resource ID of the file to be converted. If you don't want to receive the resource ID, set this parameter to NIL.
flags

Contains flags (see below) that control movie file conversion and determine whether or not the user settings dialog box appears. See these constants: 
createMovieFileDeleteCurFile
movieToFileOnlyExport
movieFileSpecValid
showUserSettingsDialog
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, it will be used by ConvertFileToMovieFile. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
proc

Points to your progress callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function. See MovieProgressProc for the interface your progress callback must support.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify an input file and convert it to a movie file. Because some conversions may take a nontrivial amount of time, you can pass a standard movie progress function in the proc and refCon parameters.
Special Considerations

Once you are finished working with a movie, you should release the resources used by the movie by calling DisposeMovie. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr ConvertFileToMovieFile (
   const FSSpec         *inputFile,
   const FSSpec         *outputFile,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp,
   MovieProgressUPP     proc,
   long                 refCon ){
printf ("ConvertFileToMovieFile",*inputFile,*outputFile,creator,scriptTag,*resID,flags,userComp,proc,refCon);
};


/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress ){
printf ("QTSoundDescriptionSetProperty",inDesc,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};

/*QTRemoveMoviePropertyListener

Removes a movie property monitoring callback.

OSErr QTRemoveMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTMoviePropertyListenerProc callback.
inUserData

User data to be passed to the callback.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTRemoveMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData ){
printf ("QTRemoveMoviePropertyListener",inMovie,inPropClass,inPropID,inListenerProc,inUserData);
};


/*QTAddTrackPropertyListener

Installs a callback to monitor a track property.

OSErr QTAddTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTTrackPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine installs a callback to monitor a track property.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTAddTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData ){
printf ("QTAddTrackPropertyListener ",inTrack,inPropClass,inPropID,inListenerProc,inUserData);
};

/*QTRemoveTrackPropertyListener

Removes a track property monitoring callback

OSErr QTRemoveTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTTrackPropertyListenerProc callback. 
inUserData

User data to be passed to the callback. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine removes a track property monitoring callback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTRemoveTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData ){
printf ("QTRemoveTrackPropertyListener",inTrack,inPropClass,inPropID,inListenerProc,inUserData);
};

/*QTGetTrackProperty

Returns the value of a specific track property.

OSErr QTGetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   QTPropertyValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns the value of a specific track property. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   QTPropertyValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed ){
printf ("QTGetTrackProperty",inTrack,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};



/*QTGetTrackPropertyInfo

Returns information about the properties of a track.

OSErr QTGetTrackPropertyInfo (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTPropertyValueType *outPropType,
   ByteCount *outPropValueSize,
   UInt32 *outPropertyFlags );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. 
outPropertyFlags

A pointer to memory allocated to hold property flags on return. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns information about the properties of a track.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetTrackPropertyInfo (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTPropertyValueType *outPropType,
   ByteCount *outPropValueSize,
   UInt32 *outPropertyFlags ){
printf ("QTGetTrackPropertyInfo",inTrack,inPropClass,inPropID,*outPropType,*outPropValueSize, *outPropertyFlags);
};

/*QTSetTrackProperty

Sets the value of a specific track property.

OSErr QTSetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstQTPropertyValuePtr inPropValueAddress );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the property value.
inPropValueAddress

A pointer to the the property value.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine sets the value of a specific track property.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTSetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstQTPropertyValuePtr inPropValueAddress ){
printf ("QTSetTrackProperty",inTrack,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*SetMovieVolume

Sets a movie's current volume but does not store the setting in the movie.

void SetMovieVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The current volume setting of the movie represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You can use the constants shown below. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The setting made by this function is not persistent. To store a volume setting in the movie, call SetMoviePreferredVolume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieVolume (
   Movie    theMovie,
   short    volume ){
printf ("SetMovieVolume",theMovie,volume);
};


/*QTAddMoviePropertyListener

Installs a callback to monitor a movie property.

OSErr QTAddMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTMoviePropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTAddMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData ){
printf ("QTAddMoviePropertyListener",inMovie,inPropClass,inPropID,inListenerProc,inUserData);
};


/*SpriteMediaSetSpriteProperty

Sets the specified property of a sprite or sprite track.

ComponentResult SpriteMediaSetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );
Parameters
mh

The sprite media handler for this operation.
spriteID

The ID of the sprite for this operation. Pass 'Trck' to set the properties of a whole sprite track.
propertyType

A constant (see below) that specifies the property whose value should be set. See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpriteTrackPropertyAllSpritesHitTestingMode
kSpriteTrackPropertyPreferredDepthInterpretationMode
propertyValue

A pointer to the new value of the selected property. The type of data you pass for this parameter depends on the property type.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Function introduced in QuickTime 3 or earlier. The kSpriteTrackPropertyAllSpritesHitTestingMode and kSpriteTrackPropertyPreferredDepthInterpretationMode constants were added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaSetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue ){
printf ("SpriteMediaSetSpriteProperty",mh,spriteID,propertyType,propertyValue);
};


/*SpriteMediaGetSpriteProperty

Retrieves the value of the specified sprite or sprite track property.

ComponentResult SpriteMediaGetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );
Parameters
mh

The sprite media handler for this operation.
spriteID

The ID of the sprite for this operation. Pass 'Trck' to return the properties of a whole sprite track.
propertyType

A constant (see below) that specifies the property whose value should be retrieved. See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpriteTrackPropertyAllSpritesHitTestingMode
kSpriteTrackPropertyPreferredDepthInterpretationMode
propertyValue

On return, a pointer to the value of the property; the data type of that value depends on the property.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Function introduced in QuickTime 3 or earlier. The kSpriteTrackPropertyAllSpritesHitTestingMode and kSpriteTrackPropertyPreferredDepthInterpretationMode constants were added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaGetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue ){
printf ("SpriteMediaGetSpriteProperty",mh,spriteID,propertyType,propertyValue);
};



/*SpriteMediaHitTestAllSprites

Determines whether any sprites are at a specified location.

ComponentResult SpriteMediaHitTestAllSprites (
   MediaHandler    mh,
   long            flags,
   Point           loc,
   QTAtomID        *spriteHitID );
Parameters
mh

The sprite media handler for this operation.
flags

Specifies flags (see below) that control the hit testing operation. See these constants: 
spriteHitTestBounds
spriteHitTestImage
spriteHitTestInvisibleSprites
spriteHitTestIsClick
spriteHitTestLocInDisplayCoordinates
loc

A point in the coordinate system of the sprite track's movie to test for the existence of a sprite.
spriteHitID

A pointer to a short integer. On return, this integer contains the ID of the frontmost sprite at the location specified by loc. If no sprite exists at the location, the function sets the value of this parameter to 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to determine whether any sprites exist at a specified location in the coordinate system of a sprite track's movie. You can pass flags to this function to control the hit testing operation more precisely. For example, you may want the hit test operation to detect a sprite whose bounding box contains the specified location.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaHitTestAllSprites (
   MediaHandler    mh,
   long            flags,
   Point           loc,
   QTAtomID        *spriteHitID ){
printf ("SpriteMediaHitTestAllSprites ",mh,flags,loc,*spriteHitID);
};

/*QTSetMovieProperty

Sets the value of a specific movie property.

OSErr QTSetMovieProperty (
   Movie                      inMovie,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the property value.
inPropValueAddress

A pointer to the the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTSetMovieProperty (
   Movie                      inMovie,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress ){
printf ("QTSetMovieProperty ",inMovie,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*GetTrackEnabled

Determines whether a track is currently enabled.

Boolean GetTrackEnabled (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

TRUE if the specified track is currently enabled, FALSE otherwise.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean GetTrackEnabled (
   Track    theTrack ){
printf (" GetTrackEnabled ",theTrack);
};



/*PutUserDataIntoHandle

Returns a handle to a user data structure.

OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );
Parameters
theUserData

The user data structure.
h

A handle to the UserDataRecord structure pointed to by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h ){
printf (" PutUserDataIntoHandle",theUserData,h);
};


/*NewUserDataFromHandle

Creates a new user data structure from a handle.

OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );
Parameters
h

A handle to the data structure specified in theUserData.
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData ){
printf ("NewUserDataFromHandle",h,*theUserData);
};


/*DisposeUserData

Disposes of a user data structure created by NewUserData.

OSErr DisposeUserData (
   UserData    theUserData );
Parameters
theUserData

The user data structure that is to be disposed of. It is acceptable but unnecessary to pass NIL in this parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DisposeUserData (
   UserData    theUserData ){
printf ("DisposeUserData",theUserData);
};

/*SetMoviePlayHints

Provides information to the Movie Toolbox that can influence movie playback.

void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

The optimizations that can be used with this movie. Each bit in the flags parameter corresponds to a specific optimization (see below). Be sure to set unused flags to 0. See these constants: 

hintsScrubMode

hintsUseSoundInterp

hintsAllowInterlace

hintsAllowBlacklining

hintsDontPurge

hintsInactive

hintsHighQuality
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the Movie Toolbox to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single optimization without altering the settings of other flags.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function accepts a flag in which you specify optimizations that the Movie Toolbox can use during movie playback. These optimizations apply to all of the media structures used by the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask ){
printf ("SetMoviePlayHints ",theMovie,flags,flagsMask);
};

/*SetTimeBaseMasterTimeBase

Assigns a master time base to a time base.

void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
master

The master time base to be assigned to this time base. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the slave time scale. This parameter allows you to set an offset between the time base and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or another time base. Don't use this function to assign a master time base to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero ){
printf ("SetTimeBaseMasterTimeBase",slave,master,*slaveZero);
};

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void ){
printf ("EnterMovies");
};



/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress ){
printf ("MovieAudioExtractionSetProperty ",session,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession ){
printf ("MovieAudioExtractionBegin",m,flags,*outSession);
};



/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia ){
printf ("BeginMediaEdits",theMedia);
};


/*DisposeTimeBase

Disposes of a time base once you are finished with it.

void DisposeTimeBase (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTimeBase (
   TimeBase    tb ){
printf ("DisposeTimeBase",tb);
};


/*CreateShortcutMovieFile

Creates a movie file that just contains a reference to another movie.

OSErr CreateShortcutMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   Handle          targetDataRef,
   OSType          targetDataRefType );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains movie file creation flags (see below). See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
targetDataRef

A handle to the data referred to by the movie that this function creates.
targetDataRefType

The type of the data referred to by the movie that this function creates; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateShortcutMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   Handle          targetDataRef,
   OSType          targetDataRefType ){
printf ("CreateShortcutMovieFile",*fileSpec,creator,scriptTag,createMovieFileFlags,targetDataRef,targetDataRefType);
};



/*NewTextMediaUPP

Allocates a Universal Procedure Pointer for the TextMediaProc callback.

TextMediaUPP NewTextMediaUPP (
   TextMediaProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewTextMediaProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TextMediaUPP NewTextMediaUPP (
   TextMediaProcPtr    userRoutine ){
printf ("NewTextMediaUPP",userRoutine);
};


/*DisposeTextMediaUPP

Disposes of a TextMediaUPP pointer.

void DisposeTextMediaUPP (
   TextMediaUPP    userUPP );
Parameters
userUPP

A TextMediaUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTextMediaUPP (
   TextMediaUPP    userUPP ){
printf ("DisposeTextMediaUPP",userUPP);
};

/*TextMediaSetTextProc

Specifies a custom function to be called whenever a text sample is displayed in a movie.

ComponentResult TextMediaSetTextProc (
   MediaHandler    mh,
   TextMediaUPP    TextProc,
   long            refcon );
Parameters
mh

The text media handler obtained by GetMediaHandler.
TextProc

A Universal Procedure Pointer that points to a TextMediaProc callback.
refcon

Indicates a reference constant that will be passed to your callback. Use this parameter to point to a data structure containing any information your function needs. Set this parameter to 0 if you don't need it.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaSetTextProc (
   MediaHandler    mh,
   TextMediaUPP    TextProc,
   long            refcon ){
printf ("TextMediaSetTextProc",mh,TextProc,refcon);
};

/*MovieSearchText

Searches for text in a movie.

OSErr MovieSearchText (
   Movie        theMovie,
   Ptr          text,
   long         size,
   long         searchFlags,
   Track        *searchTrack,
   TimeValue    *searchTime,
   long         *searchOffset );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
text

The text to be searched for.
size

The size of the text.
searchFlags

Flags (see below) that narrow the search process. See these constants: 
searchTextDontGoToFoundTime
searchTextDontHiliteFoundText
searchTextOneTrackOnly
searchTextEnabledTracksOnly
searchTrack

On return, a pointer to the found track.
searchTime

On return, a pointer to the found time.
searchOffset

On return, a pointer to the found offset to the text.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr MovieSearchText (
   Movie        theMovie,
   Ptr          text,
   long         size,
   long         searchFlags,
   Track        *searchTrack,
   TimeValue    *searchTime,
   long         *searchOffset ){
printf ("MovieSearchText",theMovie,text,size,searchFlags,*searchTrack,*searchTime,*searchOffset);
};


/*LoadTrackIntoRam

Loads a track's data into memory.

OSErr LoadTrackIntoRam (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to load. You must specify this time value in the movie's time coordinate system.
duration

The length of the segment to load. Use GetTrackDuration to determine the length of the entire movie. Note that the media handler may load more data than you specify.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

If the track does not fit, the function returns an error. See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr LoadTrackIntoRam (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration,
   long         flags ){
printf ("LoadTrackIntoRam",theTrack,time,duration,flags);
};


/*MediaTimeToSampleNum

Lets you find the sample that contains the data for a specified time.

void MediaTimeToSampleNum (
   Media        theMedia,
   TimeValue    time,
   long         *sampleNum,
   TimeValue    *sampleTime,
   TimeValue    *sampleDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
time

The time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The Movie Toolbox returns the sample number that identifies the sample that contains data for the time specified by the time parameter.
sampleTime

A pointer to a time value. The MediaTimeToSampleNum function updates this time value to indicate the starting time of the sample that contains data for the time specified by the time parameter. This time value is expressed in the media's time scale. Set this parameter to NIL if you don't want this information.
sampleDuration

A pointer to a time value. The Movie Toolbox returns the duration of the sample that contains data for the time specified by the time parameter. This time value is expressed in the media's time scale. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MediaTimeToSampleNum (
   Media        theMedia,
   TimeValue    time,
   long         *sampleNum,
   TimeValue    *sampleTime,
   TimeValue    *sampleDuration ){
printf ("MediaTimeToSampleNum",theMedia,time,*sampleTime,*sampleDuration);
};




/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType ){
printf ("NewTrackMedia",theTrack,mediaType,timeScale,dataRef,dataRefType);
};


/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed){
printf ("MovieAudioExtractionGetProperty",session,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};

/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate ){
printf ("InsertMediaIntoTrack",theTrack,trackStart,mediaTime,mediaTime,mediaRate);
};



/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia ){
printf ("GetMediaDuration",theMedia);
};



/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia ){
printf ("EndMediaEdits",theMedia);
};





/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia ){
printf ("GetMediaTrack ",theMedia);
};


/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh ){
printf ("CloseMovieStorage",dh);
};


/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh ){
printf ("AddMovieToStorage",theMovie,dh);
};



/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session ){
printf ("MovieAudioExtractionEnd",session);
};



/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType ){
printf ("NewMovieFromDataRef",*m,flags,*id,dataRef,dataRefType);
};


/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie ){
printf ("CreateMovieStorage",dataRef,dataRefType,creator,scriptTag,createMovieFileFlags,*outDataHandler,*newmovie);
};



/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut ){
printf ("AddMediaSample2 ",theMedia,*dataIn,size,decodeDurationPerSample,displayOffset,sampleDescriptionH,numberOfSamples,sampleFlags,*sampleDescriptionH);
};




/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){
printf ("QTNewDataReferenceFromFullPathCFString",filePath,pathStyle,flags,*outDataRef,*outDataRefType);
};


/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc ){
printf ("QTSoundDescriptionCreate",*inASBD,*inLayout,inLayoutSize,inMagicCookie,inMagicCookieSize,inRequestedKind,*outSoundDesc);
};





/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie ){
printf ("DisposeMovie",theMovie);
};



/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume ){
printf ("NewMovieTrack ",theMovie,width,height,trackVolume);
};


/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void ){
printf ("GetMoviesError");
};





/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate ){
printf ("PrerollMovie",theMovie,time,Rate);
};



/*GetTrackDuration

Returns the duration of a track.

TimeValue GetTrackDuration (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The duration of the specified track, expressed in the time scale of the movie that contains the track.
Discussion

The duration corresponds to the ending time of the track in the movie's time coordinate system (remember that all tracks start at movie time 0).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackDuration (
   Track    theTrack ){
printf (" GetTrackDuration",theTrack);
};


/*GetMediaSampleDescription

Retrieves a SampleDescription structure from a media.

void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to retrieve. This index corresponds to the structure itself, not to the samples in the media. Index numbers start with 1.
descH

Specifies a handle that is to receive the SampleDescription structure. The Movie Toolbox correctly resizes this handle for the returned structure. If there is no description for the specified index, the function returns this handle unchanged. Your application must allocate and dispose of this handle.
Discussion

The Movie Toolbox identifies a media's sample descriptions with an index value, ranging from 1 to the number of sample descriptions in the media. Sample description indexes provide a convenient way to access each sample description in a media. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

The format of sample descriptions differs by media type. Sample descriptions for image data are defined by ImageDescription structures. Sample descriptions for sound are defined by SoundDescription structures. Sample descriptions for text are defined by TextDescription structures.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH ){
printf ("GetMediaSampleDescription",theMedia,index,descH);
};


/*SampleNumToMediaDecodeTime

Finds the decode time for a specified sample.

void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration ){
printf ("SampleNumToMediaDecodeTime",theMedia,logicalSampleNum,*sampleDecodeTime,*sampleDecodeDuration);
};


/*MediaDecodeTimeToSampleNum

Finds the sample for a specified decode time.

void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
decodeTime

A 64-bit time value that represents the decode time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a variable that is to receive the sample number. The function returns the sample number that identifies the sample that contains data for the specified decode time, or 0 if it is not found.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDecodeTime is out of the decode time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration ){
printf ("MediaDecodeTimeToSampleNum",theMedia,decodeTime,*sampleNum,*sampleDecodeTime,*sampleDecodeDuration);
};



/*GetMediaSample2

Retrieves sample data from a media file.

OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataOut

A pointer to a buffer to receive sample data. The buffer must be large enough to contain at least maxDataSize bytes. If you do not want to receive sample data, pass NULL.
maxDataSize

The maximum number of bytes allocated to hold the sample data.
size

A pointer to memory where the function returns the number of bytes of sample data returned in the memory area specified by dataOut. Set this parameter to NULL if you are not interested in this information.
decodeTime

The starting time of the sample to be retrieved in decode time. You must specify this value in the media's time scale.
sampleDecodeTime

A pointer to a time value in decode time. The function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NULL.
decodeDurationPerSample

A pointer to a time value in decode time. The Movie Toolbox returns the duration of each sample in the media. Set this parameter to NULL if you don't want this information.
displayOffset

A pointer to a time value. The function updates this time value to indicate the display offset of the returned sample. This time value is expressed in the media's time scale. Set this parameter to NULL if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NULL.
sampleFlags

A pointer to a short integer in which the function returns flags that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NULL: mediaSampleNotSync This flag is set to 1 if the sample is not a sync sample and to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, maxSizeToGrowTooSmall if the sample data is larger than maxDataSize, or noErr if there is no error.
Discussion

Whereas GetMediaSample takes a resizable Handle and a maxSizeToGrow parameter, GetMediaSample2 takes a pointer and a maxDataSize parameter. If you want to read a sample into a Handle, you can use the following code:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags ){
printf ("GetMediaSample2",theMedia,*dataOut,maxDataSize,*size,decodeTime,*sampleDecodeTime,*decodeDurationPerSample,*displayOffset,sampleDescriptionH,*sampleDescriptionIndex,maxNumberOfSamples,*numberOfSamples,*sampleFlags);
};


/*GetMediaNextInterestingDecodeTime

Searches for decode times of interest in a media.

void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
interestingTimeFlags

Flags that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, or nextTimeSyncSample flags to 1. Set unused flags to 0: nextTimeMediaSample Set this flag to 1 to search for the next sample. nextTimeMediaEdit Set this flag to 1 to search for the next group of samples. nextTimeSyncSample Set this flag to 1 to search for the next sync sample. nextTimeEdgeOK Set this flag to 1 to accept information about elements that begin or end at the time specified by the decodeTime parameter. When this flag is set the function returns valid information about the beginning and end of a media. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
decodeTime

Specifies the starting point for the search in decode time. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingDecodeTime

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NULL if you are not interested in this information.
interestingDecodeDuration

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the duration of the interesting time in the media's time coordinate system. Set this parameter to NULL if you don't want this information; this lets the function works faster.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration ){
printf ("GetMediaNextInterestingDecodeTime",theMedia,interestingTimeFlags,decodeTime,rate,*interestingDecodeTime,*interestingDecodeDuration);
};



/*GetTrackMovie

Determines the movie that contains a specified track.

Movie GetTrackMovie (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The identifier of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Movie GetTrackMovie (
   Track    theTrack ){
printf ("GetTrackMovie",theTrack);
};

/*GetMediaTimeScale

Determines a media's time scale.

TimeScale GetMediaTimeScale (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMediaTimeScale (
   Media    theMedia ){
printf ("GetMediaTimeScale ",theMedia);
};



/*GetMediaSampleCount

Determines the number of samples in a media.

long GetMediaSampleCount (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

The number of samples in the media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMediaSampleCount (
   Media    theMedia ){
printf ("GetMediaSampleCount ",theMedia);
};


/*GetMediaDisplayDuration

Returns the display duration of a media.

TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's display duration. A media's display duration is its display end time minus its display start time. For media without nonzero display offsets, the decode duration and display duration are the same.
Discussion

When inserting media with display offsets into a track, use display time:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDisplayDuration (
   Media    theMedia ){
printf ("GetMediaDisplayDuratio",theMedia);
};


/*GetTrackNextInterestingTime

Searches for times of interest in a track.

void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works more quickly.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. In this case, sync samples don't rely on preceding frames for content. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration ){
printf ("GetTrackNextInterestingTime ",theTrack,interestingTimeFlags,time,rate,*interestingTime,*interestingDuration);
};


/*GetTrackEditRate

Returns the rate of the track edit of a specified track at an indicated time.

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );
Parameters
theTrack

The track identifier for which the rate of a track edit (at the time given in the atTime parameter) is to be determined.
atTime

Indicates a time value at which the rate of a track edit (of a track identified in the parameter theTrack) is to be determined.
Return Value

The rate of the track edit of the specified track at the specified time.
Discussion

This function is useful if you are stepping through track edits directly in your application or if you are a client of QuickTime's base media handler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime ){
printf ("GetTrackEditRate",theTrack,atTime);
};


/*CopyMediaMutableSampleTable

Obtains information about sample references in a media in the form of a sample table.

OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
startDecodeTime

A 64-bit time value that represents the starting decode time of the sample references to be retrieved. You must specify this value in the media's time scale.
sampleStartDecodeTime

A pointer to a time value. The function updates this time value to indicate the actual decode time of the first returned sample reference. If you are not interested in this information, set this parameter to NULL. The returned time may differ from the time you specified with the startDecodeTime parameter. This will occur if the time you specified falls in the middle of a sample.
maxNumberOfSamples

A 64-bit signed integer that contains the maximum number of sample references to be returned. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate to the media.
maxDecodeDuration

A 64-bit time value that represents the maximum decode duration to be returned. The function does not return samples with greater decode duration than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media.
sampleTableOut

A reference to an opaque sample table object. When you are done with the returned sample table, release it with QTSampleTableRelease.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

To find out how many samples were returned in the sample table, call QTSampleTableGetNumberOfSamples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut ){
printf ("CopyMediaMutableSampleTable",theMedia,startDecodeTime,*sampleStartDecodeTime,maxNumberOfSamples,maxDecodeDuration,*sampleTableOut);
};


/*QTSampleTableGetNumberOfSamples

Returns the number of samples in a sample table.

SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object.
Return Value

A 64-bit signed integer that contains the number of samples, or 0 if sampleTable is NULL.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable ){
printf ("QTSampleTableGetNumberOfSamples",sampleTable);
};


/*QTSampleTableGetDecodeDuration

Returns the decode duration of a sample.

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the decode duration of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetDecodeDuration",sampleTable,sampleNum);
};

/*GetMovieRate

Returns a movie's playback rate.

Fixed GetMovieRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The rate at which the movie is currently playing, expressed as a 32-bit fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. A value of 1 indicates normal speed, a value of 2 indicates double speed, -2 means the movie is playing backward at double speed, and so on. A value of 0 means the movie is paused or stopped.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetMovieRate (   Movie    theMovie ){
printf ("GetMovieRate",theMovie);
};

/*MCGetControllerBoundsRect

Returns a movie controller's boundary rectangle.

ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that is to receive the coordinates of the movie controller's boundary rectangle. If there is insufficient screen space to display the controller, the function may return an empty structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds ){
printf ("MCGetControllerBoundsRect ",mc,*bounds);
};


/*StartMovie

Starts the movie playing from the current movie time.

void StartMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You are not required to call this function to start a movie. It is included in the QuickTime API for convenience. Before playing the movie, the Movie Toolbox makes the movie active, prerolls the movie, and sets the movie to its preferred playback rate. You can use SetMoviePreferredRate to change this setting. 
Special Considerations

A movie's current time is saved when a movie is stored in a movie file. Therefore, your application should appropriately position a movie before playing the movie. Use GoToBeginningOfMovie to set a movie to play from its start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void StartMovie (
   Movie    theMovie ){
printf ("StartMovie ",theMovie);
};


/*MCDraw

Responds to an update event.

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the update event has occurred.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w ){
printf ("MCDraw ",mc,w);
};

/*GetMovieNaturalBoundsRect

Gets a movie's natural boundary rectangle.

void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
naturalBounds

A pointer to a Rect structure that represents the movie's bounding rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds ){
printf ("GetMovieNaturalBoundsRect",theMovie,*naturalBounds);
};



/*MCClick

Lets a controller respond when the user clicks in a movie controller window.

ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
where

The location of the click. This value is expressed in the local coordinates of the window specified by the w parameter. Your application must convert this value from the global coordinates returned in the EventRecord structure.
when

Indicates when the user pressed the mouse button. You obtain this value from the EventRecord structure.
modifiers

Specifies modifier flags for the event. You obtain this value from the EventRecord structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers ){
printf ("MCClick ",mc,w,where,when,modifiers);
};


/*DisposeMovieController

Disposes of a movie controller.

void DisposeMovieController (
   ComponentInstance    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from the Component Manager's OpenComponent or OpenDefaultComponent function, or from the NewMovieController function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function is implemented by the Movie Toolbox, not by movie controller components. If you are creating your own movie controller component, you do not have to support this function. The following code snippet illustrates its use:// DisposeMovieController coding example
// See "Discovering QuickTime," page 221
// Resource identifiers
#define IDM_OPEN         101
char            szMovieFile[MAX_PATH];              // Name of movie file
Movie           movie;                              // Movie object
MovieController mc;                                 // Movie controller
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    ...
    ...
    InitializeQTML(0);                          // Initialize QuickTime
    EnterMovies();                              // Initialize Toolbox
    ...
    //  Main message loop
    ...
    ExitMovies();                               // Terminate Toolbox
    TerminateQTML();                            // Terminate QuickTime
}  // end WinMain
//
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    MSG             msg;
    EventRecord     er;
 
    . . .                                       // Fill in contents of MSG structure
 
    WinEventToMacEvent(&msg, &er);                  // Convert message to a QT event
    MCIsPlayerEvent(mc, (const EventRecord *)&er);  // Pass event to movie controller
 
    switch (iMsg) {
        case WM_CREATE:
            CreatePortAssociation(hwnd, NIL, 0L);  // Register window with QT
            break;
        case WM_COMMAND:
            switch (LOWORD(wParam)) {
                case IDM_OPEN:
                    MyCloseMovie();                 // Close previous movie, if any
 
                    if (MyGetFile(szMovieFile))         // Get file name from user
                        MyOpenMovie(hwnd, szMovieFile); // Open the movie
                    break;
                    . . .
                default:
                    return DefWindowProc(hwnd, iMsg, wParam, lParam);
            }  // end switch (LOWORD(wParam))
            break;
        case WM_CLOSE:
            DestroyPortAssociation(GetNativeWindowPort(hwnd));  // Unregister window
            break;
        . . .
        default:
            return DefWindowProc(hwnd, iMsg, wParam, lParam);
 
    }  // end switch (iMsg)
 
    return 0;
}  // end WndProc
//
BOOL MyGetFile (char *lpszMovieFile)
{
    OPENFILENAME         ofn;
 
    // Fill in contents of OPENFILENAME structure
                ...
                ...
 
     if (GetOpenFileName(&ofn))                     // Let user select file
        return TRUE;
    else
        return FALSE;
}  // end MyGetFile
//
void MyOpenMovie (HWND hwnd, char szFileName[255])
{
    short   nFileRefNum =0;
    FSSpec  fss;
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);   // Set graphics port
    NativePathNameToFSSpec(szFileName, &fss, 0);    // Convert pathname and make FSSpec
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);    // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,     // Get movie from file
                    NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                    // Close movie file
 
    mc =NewMovieController(movie, ...);            // Make movie controller
        ...
        ...
 
}  // end MyOpenMovie
//
void MyCloseMovie (void)
{
    if (mc)                                     // Destroy movie controller, if any
        DisposeMovieController(mc);
 
    if (movie)                                  // Destroy movie object, if any
        DisposeMovie(movie);
}  // end MyCloseMovie

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieController (
   ComponentInstance    mc ){
printf ("DisposeMovieController",mc);
};


/*SetTrackEnabled

Enables or disables a track.

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
isEnabled

Enables or disables the track. Set this parameter to TRUE to enable the track. Set this parameter to FALSE to disable the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled ){
printf ("SetTrackEnabled",theTrack,isEnabled);
};


/*SetMovieRate

Sets a movie's playback rate.

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
rate

The new movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. This value immediately changes the rate at which the movie is playing. A value of 1 starts the movie playing at normal speed, a value of 2 causes the movie to play at double speed, -2 starts the movie playing backward at double speed, and so on. A value of 0 stops the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Use this function to change the speed at which a movie is playing. You do not normally use this function to start and stop movies; use the higher level functions StartMovie and StopMovie instead. If you start a movie using this function, you should call PrePrerollMovie and PrerollMovie first, to set up any network connections, buffers, and data structures necessary to play the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieRate (
   Movie    theMovie,
   Fixed    rate ){
printf ("SetMovieRate",theMovie,rate);
};


/*QTMetaDataRelease

Decrements the retain count of a metadata object.

void QTMetaDataRelease ( QTMetaDataRef inMetaData );
Discussion

This function releases a metadata object by decrementing its reference count. When the count becomes 0 the memory allocated to the object is freed and the object is destroyed. If you retain a metadata object you are responsible for releasing it when you no longer need it.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTMetaDataRelease ( QTMetaDataRef inMetaData ){
printf ("QTMetaDataRelease",inMetaData);
};


/*QTMetaDataGetItemProperty

Returns a property of a metadata item.

OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
inPropValueSize

Size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the item's property value.
outPropValueSizeUsed

On return, the actual size of buffer space used.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the property being asked about, buffersTooSmall if the allocated buffer is too small to hold the property, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed ){
printf ("QTMetaDataGetItemProperty",inMetaData,inItem,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};

/*QTMetaDataGetItemPropertyInfo

Returns information about a property of a metadata item.

OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the item property being asked about, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags ){
printf ("QTMetaDataGetItemPropertyInfo",inMetaData,inItem,inPropClass,inPropID,*outPropType,*outPropValueSize,*outPropFlags);
};


/*OpenMovieFile

Opens a specified movie file.

OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission );
Parameters
fileSpec

A pointer to the FSSpec structure for the movie file to be opened.
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. This reference number refers to the file fork that contains the movie resource. If the movie is stored in the data fork of the file, the returned reference number corresponds to the data fork.
permission

The permission level for the file (see below). If your application is only going to play the movie that is stored in the file, you can open the file with read permission. If you plan to add data to the file or change data in the file, you should open the file with write permission. See these constants: 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application must open a movie file before reading movie data from it or writing movie data to it. You can open a movie file more than once; be sure to call CloseMovieFile once for each time you call this function. Note that opening the movie file with write permission does not prevent other applications from reading data from the movie file.

If the specified file has a resource fork, this function opens the resource fork and returns a file reference number to the resource fork. If the movie file does not have a resource fork (that is, it is a single-fork movie file), this function opens the data fork instead. In this case, your application cannot use AddMovieResource with the movie file.

The following is an example of using OpenMovieFile:// OpenMovieFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by OpenMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission ){
printf ("OpenMovieFile ",*fileSpec,*resRefNum,permission);
};


/*GetTimeBaseMasterClock

Determines the clock component that is assigned to a time base.

ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
Return Value

A reference to a component instance. If a clock component is not assigned to the time base, the returned reference is NIL. In this case, the time base relies on another time base for its time source. Use GetTimeBaseMasterTimeBase to obtain the time base reference to that master time base.
Discussion

This function returns a reference to a component instance of the clock component that provides a time source to the specified time base. Every time base derives its time from either a clock component or from another time base. If a time base derives its time from a clock component, use this function to obtain the component instance of the clock component.
Special Considerations

The Component Manager allows a single component to serve multiple client applications at the same time. Each client application has a unique connection to the component, identified by a component instance. Don't close this connection; the time base is using it to maintain its time source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb ){
printf ("GetTimeBaseMasterClock",tb);
};

/*DisposeSpriteWorld

Disposes of a sprite world.

void DisposeSpriteWorld (
   SpriteWorld    theSpriteWorld );
Parameters
theSpriteWorld

The sprite world to dispose of. It is safe to pass NIL to this function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You call this function to dispose of a sprite world created by NewSpriteWorld. This function also disposes of all of the sprites associated with the sprite world. This function does not dispose of the graphics worlds associated with the sprite world. Here is an example of using it:// DisposeSpriteWorld coding example
// See "Discovering QuickTime," page 347
#define kNumSprites             4
#define kNumSpaceShipImages     24
SpriteWorld                 gSpriteWorld =NIL;
Sprite                      gSprites[kNumSprites];
Handle                      gCompressedPictures[kNumSpaceShipImages];
ImageDescriptionHandle      gImageDescriptions[kNumSpaceShipImages];
void MyDisposeEverything (void)
{
    short           nIndex;
    // dispose of the sprite world and associated graphics world
    if (gSpriteWorld)
        DisposeSpriteWorld(gSpriteWorld);
 
    // dispose of each sprite's image data
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        if (gCompressedPictures[nIndex])
            DisposeHandle(gCompressedPictures[nIndex]);
        if (gImageDescriptions[nIndex])
            DisposeHandle((Handle)gImageDescriptions[nIndex]);
    }
    DisposeGWorld(spritePlane);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeSpriteWorld (
   SpriteWorld    theSpriteWorld ){
printf ("DisposeSpriteWorld",theSpriteWorld);
};


/*GetMoviePreferredRate

Returns a movie's default playback rate.

Fixed GetMoviePreferredRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's default playback rate.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Fixed GetMoviePreferredRate (
   Movie    theMovie ){
printf ("GetMoviePreferredRate",theMovie);
};



/*QTMetaDataGetNextItem

Returns the next metadata item corresponding to a specified key.

OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );
Parameters
inMetaData

The metadata object for this operation.
inMetaDataFormat

The metadata storage format used by the object passed in inMetaData. The format may be UserData storage, iTunes metadata storage, or QuickTime metadata storage. Not all objects will include all forms of storage, and other storage formats may appear in the future. Pass kQTMetaDataStorageFormatWildcard to target all storage formats.
inCurrentItem

The opaque, unique UInt64 identifier of the current metadata item to start the search. Your application obtains this item identifier from such functions as QTMetaDataAddItem.
inKeyFormat

The format of the key.
inKeyPtr

A pointer to the key of the item to be fetched next. You may pass NULL in this parameter if you are not interested in any specific key.
inKeySize

The size of the key in bytes.
outNextItem

The ID of the next metadata item after the item specified by inCurrentItem that has the specified key.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, kQTMetaDataInvalidStorageFormatErr if the metatada storage format is invalid, kQTMetaDataInvalidKeyErr if the key or its format is invalid, kQTMetaDataNoMoreItemErr if the last item has been fetched, or noErr if there is no error. See Metadata Error Codes.
Discussion

If the item designated by inCurrentItem is kQTMetaDataItemUninitialized, the function returns the first item with the specified key in the storage format. If it refers to a valid item in the storage format, the function will return the next item with the key after the item designated by inCurrentItem.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem ){
printf ("QTMetaDataGetNextItem",inMetaData,inMetaDataFormat,inCurrentItem,inKeyFormat,*inKeyPtr,inKeySize,*outNextItem);
};



/*QTCopyMovieMetaData

Retains a movie's metadata object and returns it.

OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
outMetaData

A pointer to an opaque metadata object wrapper associated with the movie passed in inMovie.
Return Value

Returns invalidMovie if the movie passed in inMovie is invalid, or noErr if there is no error. 
Discussion

This function returns the metadata object associated with a movie. The object has retain/release semantics. It has already been retained before returning, but you should call QTMetaDataRelease when you are done. Because the movie can be disposed of at any time, the QTMetaDataRef may be valid when the movie no longer exists. In this case, the function will fail with a kQTMetaDataInvalidMetaDataErr error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData ){
printf ("QTCopyMovieMetaData",inMovie,*outMetaData);
};



/*GetMovieTimeScale

Returns the time scale of a movie.

TimeScale GetMovieTimeScale (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A long integer that contains the movie's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMovieTimeScale (
   Movie    theMovie ){
printf ("GetMovieTimeScale",theMovie);
};


/*GetMovieIndTrackType

Searches for all of a movie's tracks that share a given media type or media characteristic.

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
index

The index value of the track for this operation. This is not that same as the track's index value in the movie. Rather, this parameter is an index into the set of tracks that meet your other selection criteria.
trackType

Contains either a media type or a media characteristic value. The toolbox applies this value to the search, and returns information about tracks that meet this criterion. You indicate whether you have specified a media type or characteristic value by setting the flags parameter appropriately.
flags

Contains flags (see below) that control the search operation. Note that you may not set both movieTrackMediaType and movieTrackCharacteristic to 1. See these constants: 
movieTrackMediaType
movieTrackCharacteristic
movieTrackEnabledOnly
Return Value

A track identifier.
Discussion

The toolbox returns the track identifier that corresponds to the track that meets your selection criteria. If the toolbox cannot find a matching track, in returns a value of NIL. Note that the index parameter does not work the same way that is does in GetMovieIndTrack. With GetMovieIndTrackType, the index parameter specifies an index into the set of tracks that meet your other selection criteria. For example, in order to find the third track that supports the sound characteristic, you would call the function in the following manner:theTrack =GetMovieIndTrackType (theMovie, 3, AudioMediaCharacteristic, movieTrackCharacteristic);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags ){
printf ("GetMovieIndTrackType",theMovie,index,trackType,flags);
};




/*GetMediaDecodeDuration

Returns the decode duration of a media.

TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's decode duration. A media's decode duration is the sum of the decode durations of its samples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDecodeDuration (
   Media    theMedia ){
printf ("GetMediaDecodeDuration",theMedia);
};



/*TrackTimeToMediaDisplayTime

Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.

TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );
Parameters
value

A 64-bit time value that represents the track's time value; it must be expressed in the time scale of the movie that contains the track.
theTrack

A track identifier, which your application obtains from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A 64-bit time value that represents the corresponding time in media display time, in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack ){
printf ("TrackTimeToMediaDisplayTime",value,theTrack);
};



/*QTSampleTableGetDataSizePerSample

Returns the data size of a sample.

ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The size of the sample in bytes. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetDataSizePerSample",sampleTable,sampleNum);
};



/*QTSampleTableGetSampleFlags

Returns the media sample flags of a sample.

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A constant that describes characteristics of the sample (see below). Returns 0 if sampleTable is NULL or if the sample number is out of range.
Discussion

This function can return one or more of the following constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetSampleFlags",sampleTable,sampleNum);
};

/*QTSampleTableCopySampleDescription

Retrieves a sample description from a sample table.

OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleDescriptionID

The sample description ID.
mediaSampleDescriptionIndexOut

A pointer to a variable to receive a media sample description index. If the sample description came from a media, this is the index that could be passed to GetMediaSampleDescription to retrieve the same sample description handle. The index will be 0 if the sample description did not come directly from a media. Pass NULL if you do not want to receive this information.
sampleDescriptionHOut

A pointer to a variable to receive a newly allocated sample description handle. Pass NULL if you do not want one. The caller is responsible for disposing the returned sample description handle using DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut ){
printf ("QTSampleTableCopySampleDescription",sampleTable,sampleDescriptionID,*mediaSampleDescriptionIndexOut,*sampleDescriptionHOut);
};





/*SampleNumToMediaDisplayTime

Finds the display time for a specified sample.

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration ){
printf ("SampleNumToMediaDisplayTime ",theMedia,logicalSampleNum,*sampleDisplayTime,*sampleDisplayDuration);
};

/*QTSampleTableGetProperty

Returns the value of a specific sample table property.

OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
sampleTable

A reference to an opaque sample table object.
inPropClass

Pass the following constant to define the property class: kQTPropertyClass_SampleTable = 'qtst' Property of a sample table. See these constants: 
kQTPropertyClass_SampleTable
inPropID

Pass one of these constants to define the property ID: kQTSampleTablePropertyID_TotalDecodeDuration = 'tded' The total decode duration of all samples in the sample table. Read-only. kQTSampleTablePropertyID_MinDisplayOffset = '<ddd' The least display offset in the table. Negative offsets are less than positive offsets. Read-only. kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd' The greatest display offset in the table. Positive offsets are greater than negative offsets. Read-only. kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis' The least display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' The greatest display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. See these constants: 
kQTSampleTablePropertyID_TotalDecodeDuration
kQTSampleTablePropertyID_MinDisplayOffset
kQTSampleTablePropertyID_MaxDisplayOffset
kQTSampleTablePropertyID_MinRelativeDisplayTime
kQTSampleTablePropertyID_MaxRelativeDisplayTime
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

On return, the actual size of the property value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed ){
printf ("QTSampleTableGetProperty",sampleTable,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};


/*QTSampleTableRelease

Decrements the retain count of a sample table.

void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object. If you pass NULL in this parameter, nothing happens.
Discussion

If the retain count decreases to zero, the sample table is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTSampleTableRelease (
   QTSampleTableRef    sampleTable ){
printf ("QTSampleTableRelease ",sampleTable);
};


/*MediaDisplayTimeToSampleNum

Finds the sample number for a specified display time.

void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
displayTime

A 64-bit time value that represents the display time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The function returns the sample number that identifies the sample for the specified display time, or 0 if it is not found.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDisplayTime is out of the display time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration ){
printf ("MediaDisplayTimeToSampleNum",theMedia,displayTime,*sampleNum,*sampleDisplayTime,*sampleDisplayDuration);
};


/*GetMediaAdvanceDecodeTime

Returns the advance decode time of a media.

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's advance decode time. A media's advance decode time is the absolute value of the greatest-magnitude negative display offset of its samples, or 0 if there are no samples with negative display offsets. This is the amount that the decode time axis must be adjusted ahead of the display time axis to ensure that no sample's adjusted decode time is later than its display time. For media without nonzero display offsets, the advance decode time is 0.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia ){
printf ("GetMediaAdvanceDecodeTime",theMedia);
};

/*GetTrackDimensions

Determines a track's source rectangle.

void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A pointer to a fixed-point number. The Movie Toolbox returns the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A pointer to a fixed-point number. The Movie Toolbox returns the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height ){
printf (" GetTrackDimensions",theTrack,*width,*height);
};


/*QTSampleTableGetDisplayOffset

Returns the offset from decode time to display time of a sample.

TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the offset from decode time to display time of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf (" QTSampleTableGetDisplayOffset ",sampleTable,sampleNum);
};


/*QTSampleTableGetSampleDescriptionID

Returns the sample description ID of a sample.

QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The sample's sample description ID. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetSampleDescriptionID",sampleTable,sampleNum);
};


/*GetMediaQuality

Returns a media's quality level value.

short GetMediaQuality (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A short integer whose bits indicate quality constants (see below). More than one of these bits may be set to 1.
Discussion

The Movie Toolbox uses this quality value to influence which track of a movie it selects to play on a given computer. This even applies to sound media. The low-order 6 bits specify pixel depths and the upper 2 bits specify quality levels. If a bit is set to 1, the media can be played at the corresponding depth and quality level.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
short GetMediaQuality (
   Media    theMedia ){
printf ("GetMediaQuality",theMedia);
};


/*QTNextChildAnyType

Returns the next atom in the child list of the specified parent atom.

OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
currentChild

The last atom retrieved by this function. To retrieve the first atom in the child list, set the value of currentChild to 0.
nextChild

A pointer to an uninitialized QT atom data structure. On return, the data structure contains the offset of the next atom in the child list after the atom specified by currentChild, or 0 if the atom specified by currentChild was the last atom in the list.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to iterate through all the atoms in a parent atom's child list, regardless of their types and IDs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild ){
printf ("QTNextChildAnyType",container,parentAtom,currentChild,*nextChild);
};



/*QTGetAtomTypeAndID

Retrieves an atom's type and ID.

OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );
Parameters
container

The atom container that contains the atom.
atom

The atom whose type and ID should be retrieved.
atomType

A pointer to an atom type. On return, this parameter points to the type of the specified atom. You can pass NIL for this parameter if you don't need this information.
id

A pointer to an atom ID. On return, this parameter points to the ID of the specified atom. You can pass NIL for this parameter if you don't need this information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id ){
printf ("QTGetAtomTypeAndID",container,atom,*atomType,*id);
};



/*SetMovieActive

Activates or deactivates a movie.

void SetMovieActive (
   Movie      theMovie,
   Boolean    active );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
active

Activates or deactivates the movie. Set this parameter to TRUE to activate the movie; set this parameter to FALSE to deactivate the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieActive (
   Movie      theMovie,
   Boolean    active ){
printf ("SetMovieActive",theMovie,active);
};



/*IsMovieDone

Determines if a particular movie has completely finished playing.

Boolean IsMovieDone (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

Returns TRUE if the specified movie has finished playing, otherwise returns FALSE.
Discussion

A movie with a positive rate (playing forward) is considered done when its movie time reaches the movie end time. Conversely, a movie with a negative rate (playing backward) is considered done when its movie time reaches the movie start time. If your application has changed the movie's active segment, the status returned by this function is relative to the active segment, rather than to the entire movie. You can use SetMovieActiveSegment to change a movie's active segment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean IsMovieDone (
   Movie    theMovie ){
printf ("IsMovieDone",theMovie);
};


/*GetMovieBox

Returns a movie's boundary rectangle, which is a rectangle that encompasses all of the movie's enabled tracks.

void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle. GetMovieBox returns the coordinates of the movie's boundary rectangle into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The movie box is in the coordinate system of the movie's graphics world and defines the movie's boundaries over the entire duration of the movie. The movie's boundary rectangle defines the size and shape of the movie before the Movie Toolbox applies the display clipping region. The following code sample illustrates the use of GetMovieBox:// GetMovieBox coding example
// See "Discovering QuickTime," page 218
void main (void)
{
    WindowRef       pMacWnd;
    Rect            rectWnd;
    Rect            rectMovie;
    Movie           movie;
    Boolean         bDone =FALSE;
    OSErr           nErr;
    EventRecord     er;
    WindowRef       pWhichWnd;
    short           nPart;
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    nErr =EnterMovies();
    if (nErr !=noErr)
        return;
 
    SetRect(&rectWnd, 100, 100, 200, 200);
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pMovie", FALSE,
                            noGrowDocProc, (WindowRef)-1, TRUE, 0);
    SetPort(pMacWnd);
    movie =GetMovie();
    if (movie ==NIL)
        return;
 
    GetMovieBox(movie, &rectMovie);
    OffsetRect(&rectMovie, -rectMovie.left, -rectMovie.top);
    SetMovieBox(movie, &rectMovie);
 
    SizeWindow(pMacWnd, rectMovie.right, rectMovie.bottom, TRUE);
    ShowWindow(pMacWnd);
    SetMovieGWorld(movie, (CGrafPtr)pMacWnd, NIL);
 
    StartMovie(movie);
 
    . . .
 
    DisposeMovie(movie);
    DisposeWindow(pMacWnd);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect ){
printf ("GetMovieBox",theMovie,*boxRect);
};


/*NewMovieController

Locates a movie controller component and assigns a movie to that controller.

ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags );
Parameters
theMovie

The movie to be associated with the movie controller.
movieRect

A pointer to the Rect structure that is to define the display boundaries of the movie and its controller.
someFlags

Contains flags (see below) that control the operation. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by the movieRect parameter and scales the movie to fit in that rectangle. The control portion of the controller is also placed within that rectangle. You may control how the movie and the control are drawn by setting one or more flags to 1. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcWithBadge
mcNotVisible
mcWithFrame
Return Value

The ID of the new controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags ){
printf ("NewMovieController",theMovie,*movieRect,someFlags);
};


/*DisposeMovieDrawingCompleteUPP

Disposes of a MovieDrawingCompleteUPP pointer.

void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP );
Parameters
userUPP

A MovieDrawingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP ){
printf ("DisposeMovieDrawingCompleteUPP",userUPP);
};


/*NewMovieDrawingCompleteUPP

Allocates a Universal Procedure Pointer for the MovieDrawingCompleteProc callback.

MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieDrawingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine ){
printf ("NewMovieDrawingCompleteUPP",userRoutine);
};

/*QTNewDataReferenceFromCFURL

Creates a URL data reference from a CFURL.

OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );
Parameters
url

A reference to a Core Foundation struct that represents the URL to which you want a URL data reference. These structs contain two parts: the string and a base URL, which may be empty. With a relative URL, the string alone does not fully specify the address; with an absolute URL it does.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: Movies.h*/
OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType ){
printf ("QTNewDataReferenceFromCFURL",url,flags,*outDataRef,*outDataRefType);
};

long 
GetMovieTrackCount(Movie theMovie){
printf ("GetMovieTrackCount ",theMovie);
};

Track 
GetMovieIndTrack(
  Movie   theMovie,
  long    index){
printf ("GetMovieIndTrack",theMovie,index);
};

void 
GetMediaHandlerDescription(
  Media     theMedia,
  OSType *  mediaType,
  Str255    creatorName,
  OSType *  creatorManufacturer){
printf ("GetMediaHandlerDescription",theMedia,mediaType,creatorName,creatorManufacturer);
};

void 
SetMovieTimeScale(
  Movie       theMovie,
  TimeScale   timeScale){
printf ("SetMovieTimeScale",theMovie,timeScale);
};

//work



/*GetNextTrackReferenceType

Determines all of the track reference types that are defined for a given track.

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference. Set this parameter to 0 to retrieve the first track reference type. On subsequent requests, use the previous value returned by this function.
Return Value

An OSType containing the next track reference type value defined for the track; see Data References.
Discussion

There is no implied ordering of the values returned by this function . When you reach the end of the track's reference types, this function sets the returned value to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType ){};


/*GetMovieImporterForDataRef

Gets the movie importer component for a movie.

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer );
Parameters
dataRefType

The type of data reference; see Data References.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
flags

Flags (see below) that modify this function's behavior. See these constants: 
kGetMovieImporterDontConsiderGraphicsImporters
importer

A pointer to an importer component that can import the movie. Returns NIL if no importer can be found.
Return Value

If this function is allowed to use async calls (by being passed kGetMovieImporterUseAsyncCalls in the flags parameter), it returns notEnoughDataErr if it would block. You can access this error return through GetMoviesError and GetMoviesStickyError, as well as in the function result. For other errors, see Error Codes.
Discussion

You can use GetMovieImporterForDataRef to determine if a file can be opened by QuickTime as a movie (for example, in a drag-and-drop operation) as illustrated below:AliasHandle            alias;
MovieImportComponent   mi;
NewAliasMinimal(&reply.sfFile, &alias);
GetMovieImporterForDataRef(rAliasType, (Handle)alias,
kGetMovieImporterDontConsiderGraphicsImporters, &mi);
DisposeHandle((Handle)alias);
if (mi !=NIL) {
    // this file can be opened as a movie
    . . .
    }

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer ){};

/*GetUserData

Returns a specified user data item.

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data from the specified item. GetUserData resizes this handle as appropriate to accommodate the item. Your application is responsible for releasing this handle when you are done with it. Set this parameter to NIL if you don't want to retrieve the user data item. This can be useful if you want to verify that a user data item exists, but you don't need to work with the item's contents.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index ){};


/*GetTrackUserData

Obtains access to a track's user data list.

UserData GetTrackUserData (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A reference to the specified track's user data. If the function could not locate the track's user data, it sets this returned value to NIL.
Discussion

This function returns a reference to the track's user data list, which is valid until you dispose of the track. When you save the track, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetTrackUserData (
   Track    theTrack ){};


/*GetTimeBaseFlags

Obtains the control flags of a time base.

long GetTimeBaseFlags (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

Control flags (see below). Unused flags are set to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

long GetTimeBaseFlags (
   TimeBase    tb ){};




/*SetUserDataItem

Sets an item in a user data list.

OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this item reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer to the data item to be set in a user data list.
size

The size of the information pointed to by the data parameter.
udType

The type value assigned to the new item.
index

The item's index value. This parameter must specify an item in the user data list identified by theUserData. An index value of 0 or 1 implies the first item, which is created if it doesn't already exist.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index ){};



/*RemoveUserData

Removes an item from a user data list.

OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
udType

The item's type value.
index

The item's index value. This parameter must specify an item in the user data list identified by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

After the Movie Toolbox removes the item, it renumbers the remaining items of that type so that their index values are sequential and start at 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index ){};



/*CountUserDataType

Determines the number of items of a given type in a user data list.

short CountUserDataType (
   UserData    theUserData,
   OSType      udType );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData functions.
udType

The type. The Movie Toolbox determines the number of items of this type in the user data list.
Return Value

The number of items of the given type in the user data list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short CountUserDataType (
   UserData    theUserData,
   OSType      udType ){};



/*GetUserDataItem

Returns a specified user data item.

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer that is to receive the data from the specified item.
size

The size of the item.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index ){};





/*SetMoviePreferredVolume

Sets a movie's preferred volume setting.

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The preferred volume setting of the movie. The volume parameter must contain a 16-bit, fixed-point number that contains the movie's default volume. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You may find the constants shown below useful. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A movie's tracks may have their own volume settings. Use SetTrackVolume to set the volume of an individual track. A track's volume is scaled by the movie's volume to produce the track's final volume.
Special Considerations

After calling this function you must save the changes it has made, for example by updating or flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume ){};




/*GetMovieVolume

Returns a movie's current volume setting.

short GetMovieVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The current volume setting for the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMovieVolume (
   Movie    theMovie ){};


/*GetMoviePreferredVolume

Returns a movie's preferred volume setting.

short GetMoviePreferredVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's preferred volume setting.
Discussion

A movie's tracks have their own volume settings. A track's volume is scaled by the movie's volume to produce the track's final volume. On Macintosh computers, the movie's volume is further scaled by the sound volume that the user controls from the Sound control panel.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMoviePreferredVolume (
   Movie    theMovie ){};



/*MCPositionController

Controls the position of a movie and its controller on the computer display.

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
movieRect

A pointer to a Rect structure that specifies the coordinates of the movie's boundary Rect structure.
controllerRect

A pointer to a Rect structure that specifies the coordinates of the controller's boundary Rect structure. The movie controller component always centers the control portion of the controller inside this rectangle. The movie controller component only uses this parameter when the control portion of the controller is detached from the movie. If you are working with an attached controller, you can set this parameter to NIL.
someFlags

Flags (see below) that control how the movie is drawn. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by movieRect and scales the movie to fit in that rectangle. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcPositionDontInvalidate
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags ){};



/*MCSetControllerAttached

Lets your application control whether a movie controller is attached to its movie or detached from it.

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
attach

The action for this function. Set the attach parameter to TRUE to cause the controller to be attached to its movie. Set this parameter to FALSE to detach the controller from its movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach ){};


/*MCGetVisible

Returns a value that indicates whether or not a movie controller is visible.

ComponentResult MCGetVisible (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is visible, the function result is set to 1. If the controller is not showing, the function result is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCGetVisible (
   MovieController    mc ){};


/*MCUndo

Lets your application discard the effects of the most recent edit operation.

ComponentResult MCUndo (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCUndo(
   MovieController    mc ){};


/*MCCut

Returns a copy of the current movie selection from the movie associated with a specified controller and then removes the current movie selection from the source movie.

Movie MCCut (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the current movie selection.
Discussion

Your application is responsible for the returned movie. MCCut returns a movie containing the current selection from the movie associated with the specified controller. If the user has not made a selection, the returned movie reference is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCCut (
   MovieController    mc ){};


/*(MCCopy

Returns a copy of the current movie selection from the movie associated with a specified controller.

Movie MCCopy (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
Movie MCCopy (
   MovieController    mc ){};


/*MCPaste

Inserts a specified movie at the current movie time in the movie associated with a specified controller.

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
srcMovie

The movie to be inserted into the current selection in the movie associated with the movie controller specified by the mc parameter. If you set this parameter to NIL, the movie controller component retrieves the source movie from the scrap.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie ){};


/*MCClear

Removes the current movie selection from the movie associated with a specified controller.

ComponentResult MCClear (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClear (
   MovieController    mc ){};


/*PutMovieOnScrap

Places a movie into the Macintosh scrap.

OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieScrapFlags

Flags (see below) that control the operation. Be sure to set unused flags to 0. See these constants: 
movieScrapDontZeroScrap
movieScrapOnlyPutMovie
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags ){};

/*MCGetControllerInfo

Determines the current status of a movie controller and its associated movie, for menu highlighting.

ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
someFlags

A pointer to flags (see below) that specify the current status and capabilities of the controller. More than one flag may be set to 1. See these constants: 
mcInfoUndoAvailable
mcInfoCutAvailable
mcInfoCopyAvailable
mcInfoPasteAvailable
mcInfoClearAvailable
mcInfoHasSound
mcInfoIsPlaying
mcInfoIsLooping
mcInfoIsInPalindrome
mcInfoEditingEnabled
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can use the information returned by this function to control your application's menu highlighting.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags ){};

/*MCEnableEditing

Enables and disables editing for a movie controller.

ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
enabled

Specifies whether to enable or disable editing for the controller. Set this parameter to TRUE to enable editing; set it to FALSE to disable editing.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Once editing is enabled for a controller, the user may edit the movie associated with the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled ){};



/*MCSetActionFilterWithRefCon

Establishes an action filter function for a movie controller.

ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
blob

A pointer to your MCActionFilterWithRefConProc callback. Set this parameter to NIL to remove an existing callback.
refCon

A reference constant value. The movie controller component passes this reference constant to your action filter callback each time it calls it. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The movie controller component calls your action filter function each time the component receives an action for its movie controller. Your filter function is then free to handle the action or to refer it back to the movie controller component. If you refer it back to the movie controller component, the component handles the action.

If your filter function handles an action, you can handle the action in any way you desire. For example, your filter function could change the operation of movie controller buttons. More commonly, applications use the action filter function to monitor actions of the controller. For instance, your filter function might enable you to find out when the user clicks the play button, so that your application can enable appropriate menu selections. Alternatively, you can use the filter function to detect when the user resizes the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon ){};



/*NewMCActionFilterWithRefConUPP

Allocates a Universal Procedure Pointer for the MCActionFilterWithRefConProc callback.

MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMCActionFilterWithRefConProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine ){};


/*SetMovieProgressProc

Attaches a progress function to a movie.

void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
p

Points to your MovieProgressProc callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls your function only during long operations. It ensures that your progress function is called regularly, but not too often.

The following Movie Toolbox functions use progress functions: ConvertFileToMovieFile, CutMovieSelection, CopyMovieSelection, AddMovieSelection, and InsertMovieSegment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon ){};


/*QTInsertChildren

Inserts a container of atoms as children of the specified parent atom.

OSErr QTInsertChildren (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomContainer    childrenContainer );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
childrenContainer

The atom container that contains the child atoms to be inserted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to insert a container of atoms as children of a parent atom in another atom container. Each child atom is inserted as the last atom of its type and is assigned a corresponding index. The ID of a child atom to be inserted must not duplicate that of an existing child atom of the same type. The following code shows how you can use this function to create a container, insert an atom, and insert another container as a child of the atom:// QTInsertChildren coding example
FailOSErr (QTInsertChild (outerContainer, kParentAtomIsContainer,
    kSpriteAtomType, spriteID, 0, 0, NIL, &newParentAtom));
FailOSErr (QTInsertChildren (outerContainer, newParentAtom,
    innerContainer));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChildren (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomContainer    childrenContainer ){};


/*GetTrackID

Determines a track's unique track ID value.

long GetTrackID (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's unique track ID value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackID (
   Track    theTrack ){};

/*GetMediaNextInterestingTime

Searches for times of interest in a media.

void GetMediaNextInterestingTime (
   Media        theMedia,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit or nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the media's time coordinate system. Set this parameter to NIL if you don't want this information; this lets the function works faster.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. They do this by deriving frames from sync samples, which don't rely on preceding frames for content.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMediaNextInterestingTime (
   Media        theMedia,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration ){};

/*ConvertTimeScale

Converts a time from one time scale into a time that is relative to another time scale.

void ConvertTimeScale (
   TimeRecord    *theTime,
   TimeScale     newScale );
Parameters
theTime

A pointer to a time structure that contains the time value to be converted. ConvertTimeScale replaces the contents of this time structure with the time value relative to the specified time scale.
newScale

The time scale for this operation.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function does not include the rate associated with the time value in the conversion; therefore, you should use this function when you want to convert time durations, but not when converting time values.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ConvertTimeScale (
   TimeRecord    *theTime,
   TimeScale     newScale ){};

/*SetTrackMatrix

Establishes a track's transformation matrix.

void SetTrackMatrix (
   Track                 theTrack,
   const MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure that contains the track's new matrix. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackMatrix (
   Track                 theTrack,
   const MatrixRecord    *matrix ){};


/*SetTrackDimensions

Establishes a track's source rectangle.

void SetTrackDimensions (
   Track    theTrack,
   Fixed    width,
   Fixed    height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A fixed-point number that specifies the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A fixed-point number that specifies the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If you change the dimensions of an existing track, the media data is scaled to fit into the new rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackDimensions (
   Track    theTrack,
   Fixed    width,
   Fixed    height ){};


/*NewMovie

Creates a new movie in memory.

Movie NewMovie (
   long    flags );
Parameters
flags

Flags (see below) that specify control information for the new movie. Be sure to set unused flags to 0.
Return Value

The identifier for the new movie. If NewMovie fails, the returned identifier is set to NIL. You can use GetMoviesError to obtain the error result, or noErr if there was no error. See Error Codes.
Discussion

You can use NewMovie to create a new empty movie, which contains no tracks. The Movie Toolbox initializes the data structures for the new movie. Your application assigns the data to the movie by calling the functions that are described in NewMovieTrack.

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovie. To change the graphics world for the new movie, your application should use SetMovieGWorld. The default QuickTime movie time scale is 600 units per second; however, this number may change in the future. The default time scale was chosen because it is convenient for working with common video frame rates of 30, 25, 24, 15, 12, 10, and 8.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie NewMovie (
   long    flags ){};

/*GetMovieDuration

Returns the duration of a movie.

TimeValue GetMovieDuration (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The duration of the designated movie.
Discussion

This function returns a time value, expressed in the movie's time scale, that is calculated to be the maximum durations of all the tracks in the movie. The following code sample illustrates its use:// GetMovieDuration coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieDuration (
   Movie    theMovie ){};


/*QTCopyAtomDataToHandle

Copies the specified leaf atom's data to a handle.

OSErr QTCopyAtomDataToHandle (
   QTAtomContainer    container,
   QTAtom             atom,
   Handle             targetHandle );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
targetHandle

A handle. On return, the handle contains the atom's data. The handle must not be locked. This function resizes the handle, if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing an initialized handle, to retrieve a copy of a leaf atom's data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCopyAtomDataToHandle (
   QTAtomContainer    container,
   QTAtom             atom,
   Handle             targetHandle ){};

/*SetMovieDrawingCompleteProc

Assigns a drawing-complete function to a movie.

void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon );
Parameters
theMovie

The movie for this operation.
flags

Contains flags (see below) that control when your drawing complete function is called. See these constants: 
movieDrawingCallWhenChanged
movieDrawingCallAlways
proc

A pointer to your MovieDrawingCompleteProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

The reference constant you supplied when your application called your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls this function based upon guidelines you establish when you assign the function to the movie. 
Special Considerations

Some media handlers may take less efficient playback paths when a drawing-complete function is used, so it should be used only when absolutely necessary.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon ){};


/*MCIdle

Performs idle processing for a movie controller.

ComponentResult MCIdle (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCIdle (
   MovieController    mc ){};


/*QTNewDataReferenceFromFSRef

Creates an alias data reference from a file specification.

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );
Parameters
fileRef

A pointer to an opaque file system reference.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You can use File Manager functions to construct a file specification for a file to which you want the new alias data reference to point. Then you can pass the reference to other Movie Toolbox functions that take a data reference. To construct a file specification, the file must already exist. To create an alias data reference for a file that does not exist yet, such as a new file to be created by a Movie Toolbox function, call QTNewDataReferenceFromFSRefCFString.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType ){};



/*QTCountChildrenOfType

Returns the number of atoms of a given type in the child list of the specified parent atom.

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
childType

The atom type for this operation. To retrieve the total number of atoms in the child list, set this parameter to 0. 
Return Value

The number of atoms of a given type in the child list of the specified parent atom.
Discussion

You can call this function to determine the number of atoms of a specified type in a parent atom's child list. If the total number of atoms in the parent atom's child list is 0, the parent atom is a leaf atom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType ){};


/*QTInstallNextTaskNeededSoonerCallback

Installs a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback.
scale

The time scale that QuickTime will use when reporting the duration until the next time QuickTime needs to be called, via QTGetTimeUntilNextTask.
flags

Unused; set to 0.
refcon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This routine installs a callback procedure that specifies when QuickTime next needs to be tasked. The callback procedure may be called at interrupt time or from another Mac OS X thread, so you must be careful not to cause race conditions. You can install or uninstall multiple callback procedures if necessary; they will be called in sequence. You can also install the same callback multiple times with different refcon values, in which case it will be called once with each refcon value.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon ){};


/*CanQuickTimeOpenDataRef

Determines whether referenced data can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags );
Parameters
dataRef

A handle to the referenced data.
dataRefType

The type of data reference pointed to by dataRef; see Data References.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given area of data. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags ){};


/*QTGetEffectSpeed

Returns the speed of the effect, expressed in frames per second.

OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );
Parameters
parameters

Contains parameter values for the effect.
pFPS

The speed of the effect is returned in this parameter, expressed in frames per second. Effects can also return the pre-defined constant effectIsRealtime (see below) as their speed. See these constants: 
effectIsRealtime
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The value returned should not be treated as an absolute measurement of effect performance. In particular, most effects only return one value, regardless of parameter settings and hardware. This value is an estimate of execution speed on a reference hardware platform. Actual performance will vary depending on hardware, configuration and parameter options.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS ){};

/*AttachMovieToCurrentThread

Attaches a movie to the current thread.

OSErr AttachMovieToCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AttachMovieToCurrentThread (Movie m){};


/*DetachMovieFromCurrentThread

Detaches a movie from the current thread.

OSErr DetachMovieFromCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr DetachMovieFromCurrentThread (Movie m){};


/*NewMovieFromHandle

Creates a movie in memory from a movie resource or a handle you obtained from PutMovieIntoHandle.

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
h

A handle to the movie resource from which the movie is to be loaded.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromHandle. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The toolbox sets the value to TRUE if any references were changed. Set the dataRefWasChanged parameter to NIL if you don't want to receive this information.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromHandle. To change the graphics world for the new movie, your application should use SetMovieGWorld.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged ){};


/*QTUninstallNextTaskNeededSoonerCallback

Removes a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback that you installed by a previous call to QTInstallNextTaskNeededSoonerCallback.
refcon

A pointer to the reference constant that you passed when the callback was installed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You pass this routine both a pointer to a callback procedure and a pointer to its reference constant, so you can uninstall one instance of a callback that you installed more than once with different refcon values.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon ){};

/*QTGetMovieProperty

Returns the value of a specific movie property.

OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed ){};


/*QTGetMoviePropertyInfo

Returns information about the properties of a movie.

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags ){};


/*MCInvalidate

Invalidates a region of a movie controller's display.

ComponentResult MCInvalidate (
   MovieController    mc,
   WindowRef          w,
   RgnHandle          invalidRgn );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
invalidRgn

A handle to a MacRegion structure that defines a region to invalidate.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCInvalidate (
   MovieController    mc,
   WindowRef          w,
   RgnHandle          invalidRgn ){};


/*MCMovieChanged

Informs a movie controller component that your application has used the Movie Toolbox to change the characteristics of its associated movie.

ComponentResult MCMovieChanged (
   MovieController    mc,
   Movie              m );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
m

The movie that has been changed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCMovieChanged (
   MovieController    mc,
   Movie              m ){};

/*GetMovieLoadState

Returns a value that indicates the state of a movie's loading process.

long GetMovieLoadState (
   Movie    theMovie );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A constant (see below) that indicates the movie's loading status.
Discussion

This function lets your code perform relative comparisons against movie loading milestones to determine if certain operations make sense. Its return values are ordered so that they conform to this rule:kMovieLoadStateError
< kMovieLoadStateLoading
< kMovieLoadStatePlayable
< kMovieLoadStateComplete

Special Considerations

Because of the "voting system" involved, an application checking for the load state should throttle its calling of the routine. Not calling GetMovieLoadState more often than every quarter of a second is a good place to start.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMovieLoadState (
   Movie    theMovie ){};

/*SetMediaInputMap

Replaces the media's existing input map with a given input map.

OSErr SetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    inputMap );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
inputMap

The media input map for this operation. If the input map is set to NIL, the media's input map is reset to an empty input map.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify the media you want to set so you can modify or empty its input map. It makes a copy of the input map passed to it. The following sample code illustrates how to update an input map, using this function and GetMediaInputMap:// SetMediaInputMap coding example
QTAtomContainer inputMap;
QTAtom inputAtom;
OSType inputType;
Media aVideoMedia =GetTrackMedia(aVideoTrack);
GetMediaInputMap (aVideoMedia, &inputMap);
QTInsertChild(inputMap, kParentAtomIsContainer, kTrackModifierInput,
        addedIndex, 0,0, nil, &inputAtom);
inputType =kTrackModifierTypeClip;
QTInsertChild (inputMap, inputAtom, kTrackModifierType, 1, 0,
        sizeof(inputType), &inputType, nil);
SetMediaInputMap(aVideoMedia, inputMap);
QTDisposeAtomContainer(inputMap);

Special Considerations

Use QTNewAtomContainer to create an empty input map.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    inputMap ){};

/*MCGetControllerBoundsRgn

Returns the actual region occupied by the controller and its movie.

RgnHandle MCGetControllerBoundsRgn (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A handle to a MacRegion structure that reflects the size, shape, and location of the controller. Your application must dispose of this structure.
Discussion

As with MCGetControllerBoundsRect, this function returns a region even if the controller is hidden. Some movie controllers may not be rectangular in shape. If the movie is not attached to its controller, the boundary region encloses only the control portion of the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
RgnHandle MCGetControllerBoundsRgn (
   MovieController    mc ){};


/*OpenMovieStorage

Opens a data handler for movie storage.

OSErr OpenMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   long           flags,
   DataHandler    *outDataHandler );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
flags

A constant (see below) that determines the reading and writing capabilities of the data handler. See these constants: 
kDataHCanRead
kDataHCanWrite
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie file. Your application uses this value when calling other Movie Toolbox functions that work with movie files. If you pass NIL, the Movie Toolbox creates the movie storage but does not open it.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is rarely used. It is an alternative to OpenMovieFile.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr OpenMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   long           flags,
   DataHandler    *outDataHandler ){};

/*AddTrackReference

Adds a new track reference to a track.

OSErr AddTrackReference (
   Track     theTrack,
   Track     refTrack,
   OSType    refType,
   long      *addedIndex );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refTrack

The track to be identified in the track reference.
refType

The type of reference.
addedIndex

A pointer to a long integer. The toolbox returns the index value assigned to the new track reference. If you don't want this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how AddTrackReference can be used to add a modifier track reference to a sprite track.// AddTrackReference coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddTrackReference (
   Track     theTrack,
   Track     refTrack,
   OSType    refType,
   long      *addedIndex ){};

/*UpdateMovieInStorage

Updates a movie at a storage location.

OSErr UpdateMovieInStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function, which is similar to OpenMovieStorage, replaces the content of the movie in the storage associated with the specified data handler.
Version Notes

Introduced in QuickTime 6. Supersedes UpdateMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr UpdateMovieInStorage (
   Movie          theMovie,
   DataHandler    dh ){};


/*QTMovieNeedsTimeTable

Returns whether a movie is being progressively downloaded.

OSErr QTMovieNeedsTimeTable (
   Movie      theMovie,
   Boolean    *needsTimeTable );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
needsTimeTable

If TRUE, the movie is being progressively downloaded. If an error occurs, this parameter is set to FALSE.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

A movie can be progressively downloaded when its data is received over a network connection or other slow data channel. Progressive downloads are not necessary when the data for the movie is on a local disk. The Movie Toolbox creates a time table for a movie when either this function or GetMaxLoadedTimeInMovie is called for the movie, but the time table is used only by the toolbox and is not accessible to applications. The toolbox disposes of the time table when the download is complete.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTMovieNeedsTimeTable (
   Movie      theMovie,
   Boolean    *needsTimeTable ){};



/*FlattenMovieDataToDataRef

Performs a flattening operation to a movie at a storage location.

Movie FlattenMovieDataToDataRef (
   Movie         theMovie,
   long          movieFlattenFlags,
   Handle        dataRef,
   OSType        dataRefType,
   OSType        creator,
   ScriptCode    scriptTag,
   long          createMovieFileFlags );
Parameters
theMovie

The movie passed into this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Constants (see below) that control the process of adding movie data to the new container. QuickTime will read these flags later when it adds movies to the storage. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenForceMovieResourceBeforeMovieData
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets the returned identifier to NIL.
Discussion

This function performs a flattening operation to the destination data reference.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
Movie FlattenMovieDataToDataRef (
   Movie         theMovie,
   long          movieFlattenFlags,
   Handle        dataRef,
   OSType        dataRefType,
   OSType        creator,
   ScriptCode    scriptTag,
   long          createMovieFileFlags ){};


/*DisposeCallBack

Disposes of a callback event.

void DisposeCallBack (
   QTCallBack    cb );
Parameters
cb

The callback event for the operation. You obtain this value from NewCallBack.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You should call this function when you are done with each callback event.
Special Considerations

Don't call this function at interrupt time.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeCallBack (
   QTCallBack    cb ){};

/*SetMovieMasterTimeBase

Assigns a master time base to a movie.

void SetMovieMasterTimeBase (
   Movie               theMovie,
   TimeBase            tb,
   const TimeRecord    *slaveZero );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
tb

The master time base to be assigned to this movie. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the movie. This parameter allows you to set an offset between the movie and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieMasterTimeBase (
   Movie               theMovie,
   TimeBase            tb,
   const TimeRecord    *slaveZero ){};


/*SetMediaPropertyAtom

Sets the property atom container of a media handler.

OSErr SetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    propertyAtom );
Parameters
theMedia

A reference to the media handler for this operation.
propertyAtom

Specifies a QT atom container that contains the property atoms for the track associated with the media handler.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to set properties for the track associated with the specified media handler. The contents of the QT atom container are defined by the media handler. Here is some sample code that uses this function to define the background color for a sprite track:// SetMediaPropertyAtom coding example
// See "Discovering QuickTime," page 360
if (bWithBackgroundPicture) {
    QTAtomContainer         qtacTrackProperties;
    RGBColor                rgbcBackColor;
    rgbcBackColor.red =EndianU16_NtoB(0x8000);
    rgbcBackColor.green =EndianU16_NtoB(0);
    rgbcBackColor.blue =EndianU16_NtoB0(xffff);
    // create a new atom container for sprite track properties
    QTNewAtomContainer(&qtacTrackProperties);
    // add an atom for the background color property
    QTInsertChild(qtacTrackProperties, 0,
        kSpriteTrackPropertyBackgroundColor, 1, 1, sizeof(RGBColor),
        &rgbcBackColor, NIL);
    // set the sprite track's properties
    nErr =SetMediaPropertyAtom(media, qtacTrackProperties);
    QTDisposeAtomContainer(qtacTrackProperties);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    propertyAtom ){}


/*QTRemoveChildren

Removes all the children of an atom from the specified atom container.

OSErr QTRemoveChildren (
   QTAtomContainer    container,
   QTAtom             atom );
Parameters
container

The atom container for this operation. The atom container must not be locked.
atom

The atom whose children should be removed. To remove all the atoms in the atom container, pass a value of kParentAtomIsContainer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTRemoveChildren (
   QTAtomContainer    container,
   QTAtom             atom ){};



/*SetTrackGWorld

Forces a track to draw into a particular graphics world, which may be different from that of the movie.

void SetTrackGWorld (
   Track               theTrack,
   CGrafPtr            port,
   GDHandle            gdh,
   TrackTransferUPP    proc,
   long                refCon );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
port

Points to the graphics port structure or graphics world to which to draw the track. Set this parameter to NIL to use the movie's graphics port.
gdh

A handle to the movie's graphics device structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
proc

A pointer to your TrackTransferProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

A value to pass to your TrackTransferProc callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

After this function draws a track, it calls your transfer callback to copy the track to the actual movie graphics world. When your transfer callback is called, the current graphics world is set to the correct destination. You can also install a transfer callback and set the graphics world to NIL. In this case, the function calls your callback only as a notification that the track has been drawn; no transfer needs to take place.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackGWorld (
   Track               theTrack,
   CGrafPtr            port,
   GDHandle            gdh,
   TrackTransferUPP    proc,
   long                refCon ){};

/*SetTimeBaseValue

Sets the current time of a time base.

void SetTimeBaseValue (
   TimeBase     tb,
   TimeValue    t,
   TimeScale    s );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
t

The new time value.
s

The time scale of the new time value.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseValue (
   TimeBase     tb,
   TimeValue    t,
   TimeScale    s ){};


/*CallMeWhen

Schedules a callback event.

OSErr CallMeWhen (
   QTCallBack       cb,
   QTCallBackUPP    callBackProc,
   long             refCon,
   long             param1,
   long             param2,
   long             param3 );
Parameters
cb

The callback event for the operation. You obtain this identifier from NewCallBack.
callBackProc

Points to your callback function, described in QTCallBackProc.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
param1

Contains scheduling information. The Movie Toolbox interprets this parameter based on the value of the cbType parameter to NewCallBack. If cbType is set to callBackAtTime, the param1 parameter contains flags (see below) indicating when to invoke your callback function for this callback event. If the cbType parameter is set to callBackAtRate, param1 contains flags (see below) indicating when to invoke your callback function for this event. Be sure to set unused flags to 0.
param2

Contains scheduling information. The Movie Toolbox interprets this parameter based on the value of the cbType parameter to NewCallBack. If cbType is set to callBackAtTime, the param2 parameter contains the time value at which your callback function is to be invoked for this event. The param1 parameter contains flags affecting when the Movie Toolbox calls your function. If cbType is set to callBackAtRate, the param2 parameter contains the rate value at which your callback function is to be invoked for this event. The param1 parameter contains flags affecting when the Movie Toolbox calls your function.
param3

The time scale in which to interpret the time value that is stored in param3 if cbType is set to callBackAtTime.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function from your callback function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CallMeWhen (
   QTCallBack       cb,
   QTCallBackUPP    callBackProc,
   long             refCon,
   long             param1,
   long             param2,
   long             param3 ){};


/*NewCallBack

Creates a new callback event.

QTCallBack NewCallBack (
   TimeBase    tb,
   short       cbType );
Parameters
tb

The callback event's time base. You obtain this identifier from NewTimeBase.
cbType

Constants (see below) that specify when the callback event is to be invoked. The value of this field governs how the Movie Toolbox interprets the data supplied in the param1, param2, and param3 parameters to the CallMeWhen function. In addition, if the high-order bit of the cbType parameter is set to 1 (this bit is defined by the callBackAtInterrupt flag), the event can be invoked at interrupt time. See these constants: 
callBackAtTime
callBackAtRate
callBackAtTimeJump
callBackAtExtremes
callBackAtInterrupt
Return Value

A pointer to a CallBackRecord structure containing the new callback event.
Special Considerations

The callback event created is not active until you schedule it by calling the CallMeWhen function. You must not call this function at interrupt time.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTCallBack NewCallBack (
   TimeBase    tb,
   short       cbType ){};



/*QTNewDataReferenceFromURLCFString

Creates a URL data reference from a CFString that represents a URL string.

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
urlString

A CFString that represents a URL string.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){};



/*CanQuickTimeOpenFile

Determines whether a file can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags );
Parameters
fileSpec

Points to an FSSpec structure that identifies a file. To ask about a particular file type or file name suffix in general, pass NIL.
fileType

Contains the file type if already known, or 0 if not known. If fileSpec is provided and fileType is 0, QuickTime will determine the file type. If you pass NIL in fileSpec and 0 in fileNameExtension, you must pass a file type here.
fileNameExtension

Contains the file name suffix if already known, or 0 if not known. The file name suffix should be encoded as an uppercase four character code with trailing spaces; for instance, the suffix ".png" should be encoded as 'PNG ', or 0x504E4720. If fileSpec is provided and fileNameExtension is 0, QuickTime will examine fileSpec to determine the file name suffix. If you pass NIL in fileSpec and 0 in fileType, you must pass a file name suffix here.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given file or, in general, files of a given type. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags ){};


/*PutMovieIntoHandle

Creates a new movie resource.

OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
publicMovie

The handle that is to receive the new movie resource. The function resizes the handle if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this handle to store a QuickTime movie in a specialized storage format.
Special Considerations

Note that you cannot use this new movie with other Movie Toolbox functions, except for NewMovieFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie ){}



/*CreateMovieControl

Creates a movie control object to pass to the Mac OS Control Manager.

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl );
Parameters
theWindow

The window in which the control is placed.
localRect

A pointer to a Rect structure that describes in local coordinates the window in which the movie control is placed. If NIL is passed, the movie control is positioned at 0,0 within the window; it will have the natural dimensions of the movie plus the height of the movie controls if they are visible. If 0 height and width is passed, this parameter is interpreted as an anchor point and the top left point of the movie control will be located at this position with height and width as in the NIL case. For all other cases of rectangles, the movie control is centered within the rectangle by default and is sized to fit within it while maintaining the movie's aspect ratio.
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
options

Constants (see below) that determine parts of the movie control's appearance. See these constants: 
kMovieControlOptionHideController
kMovieControlOptionLocateTopLeft
kMovieControlOptionEnableEditing
kMovieControlOptionHandleEditingHI
kMovieControlOptionSetKeysEnabled
kMovieControlOptionManuallyIdled
returnedControl

A handle to a ControlRecord struct. This defines a movie control, suitable for passing to Mac OS Control Manager functions.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes. This routine returns an error if there is a problem with one of the parameters or if an error occurred while creating the underlying movie controller or the custom control itself. If an error is returned, the value of returnedControl is undefined.
Discussion

The Carbon Movie Control is implemented as a custom control, which installs an event handler to handle the Carbon Events sent to controls. When a Carbon Movie Control is created for a movie, a movie controller is also created. The movie control then directs user interface events to the controller. The application can install event handlers on the Carbon Movie Control to handle such things as contextual menu clicks or to intercept events to do special processing. Control Manager calls can be made as well.
Special Considerations

The control can be deleted by calling the Mac OS function DisposeControl. Note that the control is automatically disposed of if the enclosing window is destroyed. Note, too, that the underlying movie controller is disposed of when the control is deleted.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl){};



/*GetMovieAudioFrequencyLevels

Returns the current frequency meter levels of a movie mix.

OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
pAveragePowerLevels

A pointer to a QTAudioFrequencyLevels structure (page 325).
Return Value

An error code. Returns noErr if there is no error.
Discussion

In the structure pointed to by pAveragePowerLevels, the numChannels field must be set to the number of channels in the movie mix being metered and the numBands field must be set to the number of bands being metered (as previously configured). Enough memory for the structure must be allocated to hold 32-bit values for all bands in all channels. This function returns the current frequency meter levels in the level field of the structure, with all the band levels for the first channel first, all the band levels for the second channel next and so on.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels ){};


/*SetTrackVolume

Sets a track's current volume.

void SetTrackVolume (
   Track    theTrack,
   short    volume );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
volume

The current volume setting of the track represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You can use constants (see below) for full volume and no volume. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackVolume (
   Track    theTrack,
   short    volume ){};


/*NewMoviePrePrerollCompleteUPP

Allocates a Universal Procedure Pointer for the MoviePrePrerollCompleteProc callback.

MoviePrePrerollCompleteUPP NewMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMoviePrePrerollCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MoviePrePrerollCompleteUPP NewMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteProcPtr    userRoutine ){};

/*PrePrerollMovie

Sets up any necessary network connections to receive streaming content.

OSErr PrePrerollMovie (
   Movie                         m,
   TimeValue                     time,
   Fixed                         rate,
   MoviePrePrerollCompleteUPP    proc,
   void                          *refcon );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
proc

The MoviePrePrerollCompleteProc callback you want called when pre-prerolling is complete. If a completion proc is specified, PrePrerollMovie operates asynchronously. You must call MoviesTask periodically during asynchronous operation. If no completion proc is specified, PrePrerollMovie operates synchronously.
refcon

A reference constant that is passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Before a movie is played, it is normally prerolled. During preroll, the Movie Toolbox tells the appropriate media handlers to load the movie data, allocate sound channels, start up image-decompression sequences, and so on. Before a movie that contains streaming content is prerolled, it must be pre-prerolled. This sets up any necessary network connections between the client and the server. If a movie contains streaming content (one or more 'strm' tracks), you must call this function before calling PrerollMovie. If the movie does not contain streaming content, calling this function has no effect. If your application calls PrerollMovie, it should always call this function first. If you play movies using a movie controller, you don't need to preroll or pre-preroll the movie explicitly; it is done for you automatically. If a completion proc is specified in the proc parameter, this function operates asynchronously; it returns almost immediately and calls the completion proc when pre-prerolling is complete.
Special Considerations

You must call MoviesTask periodically to grant time for pre-prerolling during asynchronous operation. If no completion proc is specified, this function operates synchronously; the function will not return until pre-prerolling is complete. This can take a long time, particularly if a dial-up network connection must be established.
Version Notes

Introduced in QuickTime 4. Beginning with QuickTime 4, your application should call this function any time it calls PrerollMovie.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrePrerollMovie (
   Movie                         m,
   TimeValue                     time,
   Fixed                         rate,
   MoviePrePrerollCompleteUPP    proc,
   void                          *refcon ){};


/*QTGetEffectsList

Returns a QT atom container holding a list of the currently installed effects components.

OSErr QTGetEffectsList (
   QTAtomContainer        *returnedList,
   long                   minSources,
   long                   maxSources,
   QTEffectListOptions    getOptions );
Parameters
returnedList

If the function returns noErr, this parameter contains a newly created QT atom container holding a list of their currently installed effects. Any data stored in the parameter on entry is overwritten by the list of effects. It is the responsibility of the calling application to dispose of the storage by calling QTDisposeAtomContainer once the list is no longer required.
minSources

The minimum number of sources that an effect must have to be added to the list. Pass -1 as this parameter to specify no minimum.
maxSources

The maximum number of sources that an effect can have to be added to the list. Pass -1 as this parameter to specify no maximum. The minSources and maxSources parameters allow you to restrict which effects are returned in the list, by specifying the minimum and maximum number of sources that qualifying effects can have.
getOptions

Options (see below) that control which effects are added to the list. If you pass 0, the function includes every effect, except the "none" effect and any prohibited by the values of minSources and maxSources. See these constants: 
elOptionsIncludeNoneInList
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The returned list contains two atoms for each effect component. The first atom, of type kEffectNameAtom, contains the name of the effect. The second atom, of type kEffectTypeAtom, contains the type of the effect, which is the sub-type of the effect component. This list is sorted alphabetically on the names of the effects. You can constrain the list to certain types of effects, such as those that take two sources. Use this function to obtain a list of effects that you can pass to QTCreateStandardParameterDialog.
Special Considerations

This function can take a fairly long time to execute, as it searches the system for installed effects components. You will normally want to call this function once when your application starts, or after a pair of suspend and resume events.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectsList (
   QTAtomContainer        *returnedList,
   long                   minSources,
   long                   maxSources,
   QTEffectListOptions    getOptions ){};


/*QTCreateStandardParameterDialog

Creates a dialog box that allows the user to choose an effect from the list of effects passed to the function.

OSErr QTCreateStandardParameterDialog (
   QTAtomContainer             effectList,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   QTParameterDialog           *createdDialog );
Parameters
effectList

A list of the effects that the user can choose from. In most cases you should call QTGetEffectsList to generate this list. If you pass NIL in this parameter, the function calls QTGetEffectsList to retrieve the list of all currently installed effects; this list is then presented to the user.
parameters

An effect description containing the default parameter values for the effect. If the effect named in the parameter description is in effectlist, that effect is displayed when the dialog is first shown and its parameter values are set from the parameter description. Pass in an empty atom container to have the dialog box display the first effect in the list, set to its default parameters. On return, this atom container holds an effect description for the effect selected by the user, including the parameter settings. This effect description can then be added to the media of an effect track. You will need to add source atoms to this container for effects that require sources.
dialogOptions

Options (see below) that control the behavior of the dialog. See these constants: 
pdOptionsCollectOneValue
pdOptionsAllowOptionalInterpolations
createdDialog

Returns a reference to the dialog box that is created by this function. You should pass this value only to QTIsStandardParameterDialogEvent and QTDismissStandardParameterDialog. 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates and displays a standard parameter dialog box that allows the user to choose an effect from the list in the effectList parameter. The dialog box also allows the user to choose values for the parameters of the effect, to preview the effects as they choose and customize them, and to get more information about each effect. Your application must call the Mac OS function WaitNextEvent and QTIsStandardParameterDialogEvent to allow the user to interact with the dialog box that is shown. Note that the dialog box will remain hidden until the first event is processed by QTIsStandardParameterDialogEvent. At this point, the dialog box will be displayed. You can modify the default behavior of the dialog box that is created by calling QTStandardParameterDialogDoAction.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCreateStandardParameterDialog (
   QTAtomContainer             effectList,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   QTParameterDialog           *createdDialog ){};


/*QTStandardParameterDialogDoAction

Lets you change some of the default behaviors of the standard parameter dialog box.

OSErr QTStandardParameterDialogDoAction (
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params );
Parameters
createdDialog

The reference to the dialog box created by calling QTCreateStandardParameterDialog.
action

Determines which of the actions (see below) supported by this function will be performed. See these constants: 
pdActionSetAppleMenu
pdActionSetEditMenu
pdActionSetPreviewPicture
pdActionSetDialogTitle
pdActionGetSubPanelMenu
pdActionActivateSubPanel
pdActionConductStopAlert
params

Optional parameters to the action. The type passed in this parameter depends on the value of the action parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function allows you to change some of the default behaviors of a standard parameter dialog box you create using the QTCreateStandardParameterDialog function. To choose which of the available customizations to perform, pass an action selector value in the action parameter and, optionally, a single parameter in params.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTStandardParameterDialogDoAction (
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params ){};




/*QTIsStandardParameterDialogEvent

Determines if a Macintosh event is processed by a standard parameter dialog box created by QTCreateStandardParameterDialog.

OSErr QTIsStandardParameterDialogEvent (
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog );
Parameters
pEvent

The Macintosh event.
createdDialog

The reference to the standard parameters dialog box that is returned by QTCreateStandardParameterDialog.
Return Value

See below.
Discussion

After you create a standard parameter dialog box, pass every Macintosh event through this function to determine if your application should handle the event. Once the dialog box has been confirmed or cancelled by the user, you should no longer call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTIsStandardParameterDialogEvent (
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog ){};



/*QTDismissStandardParameterDialog

Closes a standard parameter dialog box that was created using QTCreateStandardParameterDialog.

OSErr QTDismissStandardParameterDialog (
   QTParameterDialog    createdDialog );
Parameters
createdDialog

The reference to the standard parameters dialog box that is returned by QTCreateStandardParameterDialog.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function disposes of all memory associated with the dialog box.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTDismissStandardParameterDialog (
   QTParameterDialog    createdDialog ){};


/*EndFullScreen

Ends full-screen mode for a graphics device.

OSErr EndFullScreen (
   Ptr     fullState,
   long    flags );
Parameters
fullState

The pointer to private state information returned by a previous call to BeginFullScreen.
flags

Reserved. Set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function restores the graphics device and other settings to the state specified by the private state information pointed to by the fullState parameter. The resulting state is that that was in effect prior to the immediately previous call to BeginFullScreen. The following code illustrates its use:OSErr QTFullScreen_RestoreScreen (void)
{
    OSErr       myErr =noErr;
 
#if TARGET_OS_WIN32
    DestroyPortAssociation((CGrafPtr)gFullScreenWindow);
#endif
    DisposeMovieController(gMC);
    myErr =EndFullScreen(gRestoreState, 0L);
 
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndFullScreen (
   Ptr     fullState,
   long    flags ){};


/*BeginFullScreen

Begins full-screen mode for a specified graphics device.

OSErr BeginFullScreen (
   Ptr          *restoreState,
   GDHandle     whichGD,
   short        *desiredWidth,
   short        *desiredHeight,
   WindowRef    *newWindow,
   RGBColor     *eraseColor,
   long         flags );
Parameters
restoreState

On exit, a pointer to a block of private state data that contains information on how to return from full-screen mode. This value is passed to EndFullScreen to enable it to return the monitor to its previous state.
whichGD

A handle to the graphics device to put into full-screen mode. Set this parameter to NIL to select the main screen.
desiredWidth

On entry, a pointer to a short integer that contains the desired width, in pixels, of the images to be displayed. On exit, that short integer is set to the actual number of pixels that can be displayed horizontally. Set this parameter to 0 to leave the width of the display unchanged.
desiredHeight

On entry, a pointer to a short integer that contains the desired height, in pixels, of the images to be displayed. On exit, that short integer is set to the actual number of pixels that can be displayed vertically. Set this parameter to 0 to leave the height of the display unchanged.
newWindow

On entry, a window-creation value. If this parameter is NIL, no window is created for you. If this parameter has any other value, BeginFullScreen creates a new window that is large enough to fill the entire screen and returns a pointer to that window in this parameter. You should not dispose of that window yourself; instead, EndFullScreen will do so.
eraseColor

The color to use when erasing the full-screen window created by BeginFullScreen if newWindow is not NIL on entry. If this parameter is NIL, BeginFullScreen uses black when initially erasing the window's content area.
flags

A set of bit flags (see below) that control certain aspects of the full-screen mode. See these constants: 
fullScreenHideCursor
fullScreenAllowEvents
fullScreenDontChangeMenuBar
fullScreenPreflightSize
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function returns, in the restoreState parameter, a pointer to a block of private state information that indicates how to return from full-screen mode. You pass that pointer as a parameter to the EndFullScreen function. The following sample code contains functions that illustrate how to play a QuickTime movie full screen. It prompts the user for a movie, opens that movie, configures it to play full screen, associates a movie controller, and lets the controller handle events. Your application would call QTFullScreen_EventLoopAction in its event loop (on the Mac OS) or when it gets idle events (on Windows).enum {
    fullScreenHideCursor            =1L << 0,
    fullScreenAllowEvents           =1L << 1,
    fullScreenDontChangeMenuBar     =1L << 2,
    fullScreenPreflightSize         =1L << 3
};
// QTFullScreen_PlayOnFullScreen
// Prompt the user for a movie and play it full screen.
OSErr QTFullScreen_PlayOnFullScreen (void)
{
    FSSpec              myFSSpec;
    Movie               myMovie =NIL;
    short               myRefNum =0;
    SFTypeList          myTypeList ={MovieFileType, 0, 0, 0};
    StandardFileReply   myReply;
    long                myFlags =fullScreenDontChangeMenuBar
                                                 | fullScreenAllowEvents;
    OSErr               myErr =noErr;
 
    StandardGetFilePreview(NIL, 1, myTypeList, &myReply);
    if (!myReply.sfGood)
        goto bail;
 
    // make an FSSpec record
    FSMakeFSSpec(myReply.sfFile.vRefNum, myReply.sfFile.parID,
                                          myReply.sfFile.name, &myFSSpec);
    myErr =OpenMovieFile(&myFSSpec, &myRefNum, fsRdPerm);
    if (myErr !=noErr)
        goto bail;
    // now fetch the first movie from the file
    myErr =NewMovieFromFile(&myMovie, myRefNum, NIL, NIL,
                                                    newMovieActive, NIL);
    if (myErr !=noErr)
        goto bail;
 
    CloseMovieFile(myRefNum);
    // set up for full-screen display
    myErr =BeginFullScreen(&gRestoreState, NIL, 0, 0,
                                       &gFullScreenWindow, NIL, myFlags);
#if TARGET_OS_WIN32
    // on Windows, set a window procedure for the new window
    // and associate a port with that window
    QTMLSetWindowWndProc(gFullScreenWindow, QTFullScreen_HandleMessages);
    CreatePortAssociation(GetPortNativeWindow(gFullScreenWindow), NIL, 0L);
#endif
    SetMovieGWorld(myMovie, (CGrafPtr)gFullScreenWindow,
                            GetGWorldDevice((CGrafPtr)gFullScreenWindow));
    SetMovieBox(myMovie, &gFullScreenWindow->
portRect);
    // create the movie controller
    gMC =NewMovieController(myMovie, &gFullScreenWindow->
portRect, 0);

Version Notes

The Macintosh human interface guidelines suggest that the menu bar must always be present, and that information must always appear in windows. However, many multimedia applications have chosen to change the look and feel of the interface based on their needs. The number of details to keep track of when doing this continues to increase. To help solve this problem, QuickTime 2.1 added functions to put a graphics device into full screen mode. The key elements to displaying full screen movies are the calls BeginFullScreen and EndFullScreen, introduced in QuickTime 2.5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr BeginFullScreen (
   Ptr          *restoreState,
   GDHandle     whichGD,
   short        *desiredWidth,
   short        *desiredHeight,
   WindowRef    *newWindow,
   RGBColor     *eraseColor,
   long         flags ){};

/*NewUserData

Creates a new user data structure.

OSErr NewUserData (
   UserData    *theUserData );
Parameters
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserData (
   UserData    *theUserData ){};


/*MCActivate

Lets a controller respond to activate, deactivate, suspend, and resume events.

ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
activate

The nature of the event. Set this parameter to TRUE for activate and resume events. Set it to FALSE for deactivate and suspend events.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate ){};


/*MCIsPlayerEvent

Handles all events for a movie controller.

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
e

A pointer to the current EventRecord structure.
Return Value

A long integer indicating whether the movie controller component handled the event. The component sets this long integer to 1 if it handled the event. Your application should then skip the rest of its event loop and wait for the next event. The return value is 0 otherwise. Your application must then handle the event as part of its normal event processing.
Discussion

The movie controller component does everything necessary to support the movie controller and its associated movie. For example, the component calls MoviesTask for each movie. The movie controller component also handles suspend and resume events. It treats suspend events as deactivate requests and resume events as activate requests.

The following sample code shows how to convert Windows messages to Macintosh events and then pass those events to the QuickTime movie controller, using this function:// MCIsPlayerEvent coding example
// See "Discovering QuickTime," page 240
MovieController   mc;                   // Movie controller for movie
LRESULT CALLBACK WndProc
        (HWND       hwnd,               // Handle to window
         UINT       iMsg,               // Message type
         WPARAM     wParam,             // Message-dependent parameter
         LPARAM     lParam)             // Message-dependent parameter
{
    MSG             msg;                // Windows message structure
    EventRecord     er;                 // Macintosh event record
    DWORD           dwPos;              // Mouse coordinates of message
    msg.hwnd        =hwnd;             // Window handle
    msg.message     =iMsg;             // Message type
    msg.wParam      =wParam;           // Word-length parameter
    msg.lParam      =lParam;           // Long-word parameter
 
    msg.time =GetMessageTime();        // Get time of message
    dwPos  =GetMessagePos();           // Get mouse position
    msg.pt.x =LOWORD(dwPos);           // Extract x coordinate
    msg.pt.y =HIWORD(dwPos);           // Extract y coordinate
 
    WinEventToMacEvent(&msg, &er);      // Convert to event
    MCIsPlayerEvent(mc, &er);           // Pass event to QuickTime
 
    switch (iMsg) {                     // Dispatch on message type
 
        . . .       // Handle message according to type
 
    }  // end switch (iMsg)
 
}  // end WndProc

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e ){};


/*GetMovieNextInterestingTime

Searches for times of interest in a movie's enabled tracks.

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeStep
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
numMediaTypes

The number of media types in the table referred to by the whichMediaType parameter. Set this parameter to 0 to search all media types.
whichMediaTypes

A pointer to an array of media type constants (see below). You can use this parameter to limit the search to a specified set of media types. Each entry in the table referred to by this parameter identifies a media type to be included in the search. You use the numMediaTypes parameter to indicate the number of entries in the table. Set this parameter to NIL to search all media types. See these constants: 
VisualMediaCharacteristic
AudioMediaCharacteristic
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. If you are not interested in this information, set this parameter to NIL.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works faster.
Discussion

The following code sample shows the use of GetMovieNextInterestingTime to return, through the time parameter, the starting time of the first video sample of the specified QuickTime movie. The trick here is to set the nextTimeEdgeOK flag, to indicate that you want to get the starting time of the beginning of the movie. If this function encounters an error, it returns a (bogus) starting time of -1, as shown below:static OSErr QTStep_GetStartTimeOfFirstVideoSample (Movie theMovie,
                                                    TimeValue *theTime)
{
    short           myFlags;
    OSType          myTypes[1];
 
    *theTime =kBogusStartingTime;               // a bogus starting time
    if (theMovie ==NIL)
        return(invalidMovie);
 
    myFlags =nextTimeMediaSample + nextTimeEdgeOK;
                                 // we want the first sample in the movie
    myTypes[0] =VisualMediaCharacteristic;      // we want video samples
    GetMovieNextInterestingTime(theMovie, myFlags, 1, myTypes,
                                      (TimeValue)0, fixed1, theTime, NIL);
    return(GetMoviesError());
}

Special Considerations

This function examines only the movie's enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration ){};


/*QTNewDataReferenceFromFSRefCFString

Creates an alias data reference from a file reference pointing to a directory and a file name.

OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
directoryRef

A pointer to an opaque file specification that specifies the directory of the newly created alias data reference.
fileName

A reference to a CFString that specifies the name of the file.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

This function is useful for creating an alias data reference to a file that does not exist yet. Note that you cannot construct an FSRef for a nonexistent file. You can use File Manager functions to construct an FSRef for the directory. Depending on where your file name comes from, you may already have it in a form of CFString, or you may have to call CFString functions to create a new CFString for the file name. Then you can pass the new alias data reference to other Movie Toolbox functions that take a data reference. If you already have an FSRef for the file you want, you can call QTNewDataReferenceFromFSRef instead.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){};

/*QTGetDataReferenceFullPathCFString

Returns the full pathname of the target of the data reference as a CFString.

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath );
Parameters
dataRef

An alias data reference to which you want a new data reference that points to the directory.
dataRefType

The type the input data reference; must be AliasDataHandlerSubType.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
outPath

A pointer to a CFStringRef entity where a reference to the newly created CFString will be returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters was NIL or the value of dataRefType is not AliasDataHandlerSubType.
Discussion

This function creates a new CFString that represents the full pathname of the target pointed to by the input data reference, which must be an alias data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath ){};


/*ExtendMediaDecodeDurationToDisplayEndTime

Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.

OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
mediaChanged

A pointer to a Boolean that returns TRUE if any samples in the media were adjusted, FALSE otherwise. If you don't want to receive this information, set this parameter to NULL.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

After adding a complete, well-formed set of samples to a media, the media's display end time should be the same as the media's decode end time (also called the media decode duration). However, this is not necessarily the case after individual sample-adding operations, and hence it is possible for a media to be left with a display end time later than its decode end time (if adding a sequence of frames is aborted halfway, for example).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged ){};


/*DeleteTrackSegment

Removes a specified segment from a track.

OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
startTime

A time value specifying the starting point of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
duration

A time value that specifies the duration of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration ){};

/*FlattenMovie

Creates a new movie file containing a specified movie.

void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Set this parameter to the Script Manager constant smSystemScript to use the system script; set it to smCurrentScript to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by the resId parameter is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. The Movie Toolbox assigns resource ID numbers sequentially, starting at 128. If the resId parameter is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value.
resName

Points to a character string with the name of the movie resource. If you set the resName parameter to NIL, the toolbox creates an unnamed resource.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The file created by FlattenMovie also contains all the data for the movie; that is, the Movie Toolbox resolves any data references and includes the corresponding movie data in the new movie file.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName ){}



/*MCSetControllerBoundsRect

Lets you change the position and size of a movie controller.

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that contains the new boundary Rect structure for the movie controller.
Return Value

See Error Codes. Returns a value of controllerBoundsNotExact if the boundary rectangle has been changed but does not correspond to the rectangle you specified. In this case, the new boundary rectangle is always smaller than the requested rectangle. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds ){};



/*SetMovieAudioFrequencyMeteringNumBands

Configures frequency metering for a particular audio mix in a movie.

OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
ioNumBands

A pointer to memory that stores the number of bands being metered. On calling this function, you specify the number of frequency bands you want to meter. If that number is higher than is possible (determined by factors such as the sample rate of the audio being metered), the function will return the number of bands it is actually going to meter. You can pass NIL or a pointer to 0 to disable metering.
Return Value

An error code. Returns noErr if there is no error.
Discussion

See GetMovieAudioFrequencyMeteringNumBands.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands ){};


/*QTGetTimeUntilNextTask

Reports the duration until the next time QuickTime needs to run a task.

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale );
Parameters
duration

A pointer to the duration until the next time QuickTime needs access to the processor. If the returned duration is 0, QuickTime needs to run a task immediately.
scale

The time scale in which to express the returned duration. For example, pass 60 if you want the duration value expressed in ticks (60ths of a second).
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Periodically, applications have to give processing time to QuickTime by calling a function such as MCIsPlayerEvent. Instead of routinely calling MCIsPlayerEvent 10 to 20 times per second, you can call QTGetTimeUntilNextTask to determine when QuickTime next needs access to the processor. The result is a more efficent use of processor resources. To handle cases when QuickTime may need to run a task earlier than projected by this function, you can install a QTNextTaskNeededSoonerCallbackProc callback.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale ){};


/*GetMovieUserData

Obtains access to a movie's user data list.

UserData GetMovieUserData (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The UserDataRecord structure for the movie. If the function could not locate the movie's user data, it sets this return value to NIL.
Discussion

This function returns a reference to the movie's user data list, which is valid until you dispose of the movie. When you save the movie, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetMovieUserData (
   Movie    theMovie ){};



/*GetUserDataText

Retrieves language-tagged text from an item in a user data list.

OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data. The GetUserDataText function resizes this handle as appropriate. Your application must dispose of the handle when you are done with it.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
itlRegionTag

The language code of the text to be retrieved. See Localization Codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, and the item's type value and language code. The Movie Toolbox retrieves the specified text from the user data item.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag ){};

/*QTFindChildByID

Retrieves an atom by ID from the child list of the specified parent atom.

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
id

The ID of the atom to be retrieved.
index

A pointer to an uninitialized short integer. On return, if the atom specified by the id parameter was found, the integer contains the atom's index. If you don't want this function to return the atom's index, set the value of the index parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and ID from a parent atom's child list. The following code shows how you can use this function to insert a copy of container B's atoms as children of the 'abcd' atom in container A:// QTFindChildByID coding example
QTAtom targetAtom;
targetAtom =QTFindChildByID (containerA, kParentAtomIsContainer, 'abcd',
    1000, NIL);
FailOSErr (QTInsertChildren (containerA, targetAtom, containerB));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index ){};


/*QTSetAtomData

Changes the data of a leaf atom.

OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData );
Parameters
container

The atom container that contains the atom to be modified.
atom

The atom to be modified.
dataSize

The length, in bytes, of the data pointed to by the atomData parameter.
atomData

A pointer to the new data for the atom.
Return Value

Only leaf atoms contain data; this function returns an error if you pass it to a nonleaf atom. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to replace a leaf atom's data with new data. The atom container specified by the container parameter should not be locked. The following code illustrates using this function to update an atom container that describes a sprite:// QTSetAtomData coding example
OSErr SetSpriteData (QTAtomContainer sprite, Point *location,
    short *visible, short *layer, short *imageIndex)
{
    OSErr err =noErr;
    QTAtom propertyAtom;
 
    // if the sprite's visible property has a new value
    if (visible)
    {
        // retrieve the atom for the visible property
        // -- if none exists, insert one
        if ((propertyAtom =QTFindChildByIndex (sprite,
            kParentAtomIsContainer, kSpritePropertyVisible, 1,
            NIL)) ==0)
            FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
                kSpritePropertyVisible, 1, 1, sizeof(short), visible,
                NIL))
 
        // if an atom does exist, update its data
        else
            FailOSErr (QTSetAtomData (sprite, propertyAtom,
                sizeof(short), visible));
    }

Special Considerations

This function may move memory; if the pointer specified by the atomData parameter is a dereferenced handle, you should lock the handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData ){};


/*DisposeSprite

Disposes of a sprite.

void DisposeSprite (
   Sprite    theSprite );
Parameters
theSprite

The sprite to be disposed of.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You call this function to dispose of a sprite created by NewSprite. The image description handle and image data pointer associated with the sprite are not disposed of by this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeSprite (
   Sprite    theSprite ){};



/*SetSpriteProperty

Sets the specified property of a sprite.

OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue );
Parameters
theSprite

The sprite for this operation.
propertyType

The property you want to modify (see below). See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpritePropertyCanBeHitTested
propertyValue

The new value of the property. Depending on the property type, you set the propertyValue parameter to either a pointer to the property value or the property value itself, cast as a void pointer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You animate a sprite by modifying its properties, using this function. It invalidates the sprite's sprite world as needed. Here is sample code that uses this function to modify a sprite's properties:// SetSpriteProperty coding example
// See "Discovering QuickTime," page 345
#define kNumSprites             4
#define kNumSpaceShipImages     24
Rect            gBounceBox;
Sprite          gSprites[kNumSprites];
Rect            gDestRects[kNumSprites];
Point           gDeltas[kNumSprites];
short           gCurrentImages[kNumSprites];
Handle          gCompressedPictures[kNumSpaceShipImages];
void MyMoveSprites (void)
{
    short           nIndex;
    MatrixRecord    matrix;
 
    SetIdentityMatrix(&matrix);
    // for each sprite
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        // modify the sprite's matrix
        OffsetRect(&gDestRects[nIndex], gDeltas[nIndex].h,
                    gDeltas[nIndex].v);
 
        if ((gDestRects[nIndex].right >
=gBounceBox.right) ||
            (gDestRects[nIndex].left <=gBounceBox.left))
            gDeltas[nIndex].h =-gDeltas[nIndex].h;
 
        if ((gDestRects[nIndex].bottom >
=gBounceBox.bottom) ||
            (gDestRects[nIndex].top <=gBounceBox.top))
            gDeltas[nIndex].v =-gDeltas[nIndex].v;
 
        matrix.matrix[2][0] =((long)gDestRects[nIndex].left << 16);
        matrix.matrix[2][1] =((long)gDestRects[nIndex].top << 16);
 
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyMatrix,
                            &matrix);
 
        // change the sprite's image
        gCurrentImages[nIndex]++;
        if (gCurrentImages[nIndex] >
=(kNumSpaceShipImages *
                                        (nIndex+1)))
            gCurrentImages[nIndex] =0;
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyImageDataPtr,
            *gCompressedPictures[gCurrentImages[nIndex] / (nIndex+1)]);
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue ){};





/*NewMovieRgnCoverUPP

Allocates a Universal Procedure Pointer for the MovieRgnCoverProc callback.

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieRgnCoverProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine ){};



/*SetMovieCoverProcs

Sets the callbacks invoked when a movie is covered or uncovered.

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
uncoverProc

Points to a MovieRgnCoverProc callback. This function is called whenever one of your movie's tracks is removed from the screen or resized, revealing a previously hidden screen region. If you want to remove this uncover function, set this parameter to NIL. When the uncoverProc parameter is NIL the function uses the default uncover function, which erases the uncovered area.
coverProc

Points to a MovieRgnCoverProc callback. The Movie Toolbox calls this function whenever one of your movies covers a portion of the screen. If you want to remove the cover function, set this parameter to NIL. When the coverProc parameter is NIL the function uses the default cover function, which does nothing.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If a movie with semi-transparent tracks has a movie uncover procedure, set with this function, the uncover procedure is called before each frame to fill or erase the background.
Version Notes

Before QuickTime 1.6.1, the Movie Toolbox performed the erase, which limited a cover procedure-aware application's options.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon ){};


/*FlattenMovieData

Creates a new movie and a file that contains all the movie data.

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. These flags affect how the toolbox adds movies to the new movie file later. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

This parameter usually contains a pointer to the file system specification for the movie file to be created. In place of a FSSpec pointer, QuickTime lets you pass a pointer to a data reference structure to receive the flattened movie data.
creator

The creator value for the new file.
scriptTag

Contains constants (see below) that specify the script in which the movie file should be created. See Inside Macintosh: Text for more information about scripts and script tags. See these constants: 
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets this returned identifier to NIL.
Discussion

This function will take any movie and optionally make it self-contained, interleaved, and Fast Start. Unlike FlattenMovie, this function does not add the new movie resource to the new movie file; instead, FlattenMovieData returns the new movie to your application. Your application must dispose of the returned movie. You can use this function to create a single-fork movie file, by setting the flattenAddMovieToDataFork flag in the movieFlattenFlags parameter to 1. The Movie Toolbox then places the movie into the data fork of the movie file. Instead of flattening to a file, you can specify a data reference to flatten a movie to. The following two code samples show flattening a movie to a data location and to a file:// FlattenMovieData used to flatten a movie to a data location
// create a 0-length handle
    myHandle =NewHandleClear(mySize);
    if (myHandle ==NIL)
        goto bail;
 
// fill in the data reference record
    myDataRefRec.dataRefType =HandleDataHandlerSubType;
    myDataRefRec.dataRef =NewHandle(sizeof(Handle));
    if (myDataRefRec.dataRef ==NIL)
        goto bail;
    *((Handle *)*(myDataRefRec.dataRef)) =myHandle;
    myFlags =flattenFSSpecPtrIsDataRefRecordPtr;
    myFile =(FSSpec *)&myDataRefRec;
    // flatten the source movie into the handle
    myMemMovie =FlattenMovieData(mySrcMovie, myFlags, myFile, 0L,
                                  smSystemScript, 0L);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork |
        flattenForceMovieResourceBeforeMovieData,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
// FlattenMovieData used to flatten a movie to a Fast Start file
// See "Discovering QuickTime," page 257
myErr =OpenMovieFile(&myTempSpec, &myTempResRefNum, fsRdPerm);
if (myErr !=noErr)
    goto bail;
myErr =NewMovieFromFile(&myTempMovie, myTempResRefNum, NIL, 0, 0, 0);
if (myErr !=noErr)
    goto bail;
SetMovieProgressProc(myTempMovie, (MovieProgressUPP)-1, 0L);
// flatten the temporary file into a new movie file; put the movie
// resource first so that progressive downloading is possible
myPanoMovie =FlattenMovieData(
                        myTempMovie,
                        flattenDontInterleaveFlatten
                        | flattenAddMovieToDataFork
                        | flattenForceMovieResourceBeforeMovieData,
                        &myDestSpec,
                        FOUR_CHAR_CODE('TVOD'),
                        smSystemScript,
                        createMovieFileDeleteCurFile
                        | createMovieFileDontCreateResFile);

Special Considerations

Through the SetTrackLoadSettings function, the Movie Toolbox allows you to set a movie's preloading guidelines when you create the movie. The preload information is preserved when you save or flatten the movie (using either FlattenMovie or FlattenMovieData). In flattened movies, the tracks that are to be preloaded are stored at the start of the movie, rather than being interleaved with the rest of the movie data. This greatly improves preload performance because it is not necessary for the device storing the movie data to seek during retrieval of the data to be preloaded. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags ){};




/*DeleteMovieFile

Deletes a movie file.

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by DeleteMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec ){};


/*MCSetUpEditMenu

Correctly highlights and names the items in your application's Edit menu.

ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
modifiers

The current modifiers from the mouse-down or key-down event to which you are responding.
mh

A menu handler for your current Edit menu. The first six items in your Edit menu should be the standard editing commands: Undo, a blank line, Cut, Copy, Paste, and Clear.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh ){};


/*QTCopyAtomDataToPtr

Copies the specified leaf atom's data to a buffer.

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
sizeOrLessOK

Specifies whether the function may copy fewer bytes than the number of bytes specified by the size parameter. The buffer may be larger than the amount of atom data if you set the value of this parameter to TRUE. You can determine the size of an atom's data by calling QTGetAtomDataPtr.
size

The length, in bytes, of the buffer pointed to by the targetPtr parameter.
targetPtr

A pointer to a buffer. On return, the buffer contains the atom data.
actualSize

A pointer to a long integer which, on return, contains the number of bytes copied to the buffer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing a data buffer, to retrieve a copy of a leaf atom's data. The buffer must be large enough to contain the atom's data.
Special Considerations

This function may move memory.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize ){};


/*QTDoTween

Runs a tween component.

OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon );
Parameters
tween

The tween to be run.
atTime

A value that defines the time to run the tween.
result

A handle to the result of the tweening operation.
resultSize

A pointer to the size of the result.
tweenDataProc

A Universal Procedure Pointer that accesses a TweenerDataProc callback.
tweenDataRefCon

A pointer to a reference constant to be passed to your callback. Use this constant to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon ){};



/*ExitMovies

Automatically called when an application quits.

void ExitMovies ( void );
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You only need to call this function if you finish with the Movie Toolbox long before your application is ready to quit. When you call ExitMovies, the Movie Toolbox releases the private storage (which may be significant) that was allocated when you called EnterMovies. As a general rule, your application seldom uses this function; the following code illustrates an exception:// ExitMovies coding example
// See "Discovering QuickTime," page 225
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HANDLE      hAccelTable;
 
    if  (!hPrevInstance)                   // Is there a previous instance?
        if (!(InitApplication(hInstance)))      // Register window class
            return FALSE;                       // Report failure
 
    if (InitializeQTML(0) !=0) {                       // Initialize QTML
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (InitializeQTML(0) !=0)
 
    if (EnterMovies() !=0) {                       // Initialize QuickTime
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (EnterMovies() !=0)
 
    if (!(InitInstance(hInstance, nCmdShow)))         // Create main window
        return FALSE;                                 // Report failure
 
    hAccelTable =LoadAccelerators(hInstance,     // Load accelerator table
                    MAKEINTRESOURCE(IDR_ACCELSIMPLESDI));
 
    //  Main message loop
 
    while (GetMessage(&msg, NIL, 0, 0))        // Retrieve next message
        if (!TranslateAccelerator(msg.hwnd,    // Check for kbd accelerator
                        hAccelTable, &msg)) {
            TranslateMessage(&msg);     // Convert virtual key to character
            DispatchMessage(&msg);      // Send message to window procedure
        }  // end if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
 
    ExitMovies();                                   // Terminate Toolbox
    TerminateQTML();                                // Terminate QuickTime
 
    return msg.wParam;
}  // end WinMain

Special Considerations

Before calling ExitMovies, be sure that you have closed your connections to any components that use the Movie Toolbox, such as movie controllers, sequence grabbers, and so on.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ExitMovies ( void ){};



/*GetTrackReferenceCount

Determines how many track references of a given type exist for a track.

long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References. The toolbox determines the number of track references of this type.
Return Value

A long integer that specifies the number of track references of the specified type in the track. If there are no references of the type you have specified, the function returns a value of 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType ){};

/*GetTrackReference

Retrieves the track identifier contained in an existing track reference.

Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References.
index

The index value of the reference found. You obtain this index value when you create the track reference.
Return Value

The track identifier for the specified track. If the toolbox cannot locate the track reference corresponding to your specifications, it returns a value of NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index ){};



/*DeleteTrackReference

Removes a track reference from a track.

OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference.
index

The index value of the reference to be deleted. You obtain this index value when you create the track reference.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function deletes a track reference from a track. If there are additional track references with higher index values, the toolbox automatically renumbers those references, decrementing their index values by 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index ){};

/*GetQuickTimePreference

Retrieves a particular preference from the QuickTime preferences.

OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom );
Parameters
preferenceType

A preference type to be retrieved (see below); see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A pointer to the returned preference atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following sample code shows how to retrieve the connection speed setting from the QuickTime preferences:struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;
. . .
OSErr                       err;
QTAtomContainer             prefs;
QTAtom                      prefsAtom;
long                        dataSize;
Ptr                         atomData;
ConnectionSpeedPrefsRecord  prefrec;
err =GetQuickTimePreference(ConnectionSpeedPrefsType, &amp;prefs);
if (err ==noErr) {
    prefsAtom =QTFindChildByID(prefs, kParentAtomIsContainer,
                                  ConnectionSpeedPrefsType, 1, nil);
    if (!prefsAtom) {
        // set the default setting to 28.8kpbs
        prefrec.connectionSpeed =kDataRate288ModemRate;
    } else {
        err =QTGetAtomDataPtr(prefs, prefsAtom, &dataSize,
                                                         &atomData);
        if (dataSize !=sizeof(ConnectionSpeedPrefsRecord)) {
            // the prefs record wasn't the right size,
            // so it must be corrupt -- set to the default
            prefrec.connectionSpeed =kDataRate288ModemRate;
        } else {
            // everything was fine -- read the connection speed
            prefrec =*(ConnectionSpeedPrefsRecord *)atomData;
        }
    }
    QTDisposeAtomContainer(prefs);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom ){};


/*QTNewAtomContainer

Creates a new atom container.

OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData );
Parameters
atomData

A pointer to an unallocated atom container data structure. On return, this parameter points to an allocated atom container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates a new, empty atom container structure. Once you have created an atom container, you can manipulate it using the atom container functions. The following example illustrates using this function to create a new QT atom container and add an atom:// QTNewAtomContainer coding example
QTAtom firstAtom;
QTAtomContainer container;
OSErr err
err =QTNewAtomContainer (&container);
if (!err)
    err =QTInsertChild (container, kParentAtomIsContainer, 'abcd',
        1000, 1, 0, NIL, &firstAtom);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData ){};

/*QTInsertChild

Creates a new child atom of the specified parent atom.

OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
atomType

The type of the new atom to be inserted.
id

The ID of the new atom to be inserted. This ID must be unique among atoms of the same type for the specified parent. If you set this parameter to 0, the function assigns a unique ID to the atom.
index

The index of the new atom among atoms with the same parent. To insert the first atom for the specified parent, you should set this parameter to 1. To insert an atom as the last atom in the child list, you should set this parameter to 0. Index values greater than the index of the last atom in the child list plus 1 are invalid.
dataSize

The size of the data for the new atom. If the new atom is to be a parent atom or if you want to add the atom's data later, you should pass 0 for this parameter. To create the new atom as a leaf atom that contains data, you should specify the data using the data parameter and and its size using the dataSize parameter.
data

A pointer to a buffer containing the data for the new atom. If you set the value of the dataSize parameter to 0, you should pass NIL for this parameter.
newAtom

A pointer to data of type QTAtom. On return, this parameter points to the newly created atom. You can pass NIL for this parameter if you don't need a reference to the newly created atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new child atom. The new child atom has the specified atom type and atom ID, and is inserted into its parent atom's child list at the specified index. Any existing atoms at the same index or greater are moved toward the end of the child list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom ){};


/*SetQuickTimePreference

Sets a particular preference in the QuickTime preferences.

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom );
Parameters
preferenceType

The type of preference to set (see below); also see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A QT atom containing the preference information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom ){};


/*AddUserDataText

Places language-tagged text into an item in a user data list.

OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A handle to the data to be added to the user data list.
udType

The type that is to be assigned to the new item.
index

The item to which the text is to be added. This parameter must specify an item in the user data list identified by theUserData.
itlRegionTag

The region code of the text to be added. If there is already text with this region code in the item, the function replaces the existing text with the data specified by the data parameter. See Inside Macintosh: Text for more information about language and region codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, the data to be added, the data's type value, and the language code of the data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag ){};


/*AddSoundDescriptionExtension

Adds an extension to a SoundDescription structure.

OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType );
Parameters
desc

A handle to the SoundDescription structure to add the extension to.
extension

The handle containing the extension data.
idType

A four-byte signature identifying the type of data being added to the SoundDescription.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Two extensions are defined to the SoundDescription record. The first is the slope, intercept, minClip, and maxClip parameters for audio, represented as an atom of type 'flap'. The second extension is the ability to store data specific to a given audio codec, using a SoundDescriptionV1 structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType ){};




/*GetSoundDescriptionExtension

Gets the current extension to a SoundDescription structure.

OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType );
Parameters
desc

A handle to a SoundDescription structure.
extension

A pointer to a handle that, on return, contains the extension.
idType

A four-byte signature that identifies the type of data in the extension.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType ){};


/*SetMovieDefaultDataRef

Sets a movie's default data reference and type.

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dataRef

A handle to the data reference. The type of information to be placed in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType ){};


/*LoadMovieIntoRam

Loads a movie's data into memory.

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to load.
duration

The length of the segment to load. Use GetMovieDuration to determine the length of the entire movie. Note that the Movie Toolbox may load more data than you specify due to the way the data is loaded.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags ){};


/*GetTrackLayer

Retrieves a track's layer.

short GetTrackLayer (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's layer number.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackLayer (
   Track    theTrack ){};


/*SetTrackLayer

Sets a track's layer.

void SetTrackLayer (
   Track    theTrack,
   short    layer );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
layer

The track's layer number. Layers are numbered from -32,768 through 32,767. When you create a new track, the Movie Toolbox sets its track number to 0.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackLayer (
   Track    theTrack,
   short    layer ){};


/*UpdateMovieResource

Replaces the contents of a movie resource in a specified movie file.

OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to place in the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file that contains the resource to be changed. Your application obtains this value from OpenMovieFile.
resId

The resource to be changed. This value is obtained from a previous call to NewMovieFromFile, NewMovieFromDataRef, or AddMovieResource. If you specify a single-fork movie file by passing the movieInDataForkResID constant, the Movie Toolbox places the movie resource into the file's data fork.
resName

Points to a new name for the resource. If you don't want to change the resource's name, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the movie that is to be placed into the resource. This function can accommodate single-fork movie files. After updating the movie file, this function clears the movie changed flag.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by UpdateMovieInStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName ){};


/*GetMoviesStickyError

Returns the contents of the sticky error value.

OSErr GetMoviesStickyError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the sticky error value.
Discussion

The sticky error value contains the first nonzero result code from any Movie Toolbox function that you called after having cleared the sticky error with ClearMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesStickyError ( void ){};

/*CopyTrackSettings

Copies many settings from one track to another, overwriting the destination settings.

OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. The CopyTrackSettings function uses the settings from the source track, which you specify with the srcTrack parameter, to replace the current settings of this track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function copies matrix information, track volume, the clipping region, user data, matte information, media language, quality, user data, and other media-specific settings (such as sound balance and video graphics mode). It does not copy any alternate group information pertaining to the track. This function does not copy the track's contents. To work with track contents, you should use segment-editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack ){};


/*AddMediaSample

Adds sample data and a description to a media.

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataIn

A handle to the sample data. The AddMediaSample function adds this data to the media specified by the parameter theMedia. You specify the number of bytes of sample data with the size parameter. You can use the inOffset parameter to specify a byte offset into the data referred to by this handle.
inOffset

Specifies an offset into the data referred to by the handle contained in the dataIn parameter. Set this parameter to 0 if there is no offset.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
durationPerSample

The duration of each sample to be added. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60 to add a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output (I/O). You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Contains flags (see below) that control the add operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the sample data to the media, the AddMediaSample function returns the time where the sample was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application specifies the sample and the media for the operation. AddMediaSample updates the media so that it contains the sample data. One call to this function can add several samples to a media; however, all the samples must be the same size. Samples are always appended to the end of the media. Furthermore, the media duration is extended each time a sample is added.// AddMediaSample coding example
// See "Discovering QuickTime," page 250
#define kSoundSampleDuration    1
#define kSyncSample             0
#define kTrackStart             0
#define kMediaStart             0
#define kFix1                   0x00010000
void CreateMySoundTrack (Movie movie)
{
    Track                       track;
    Media                       media;
    Handle                      hSound =NIL;
    SoundDescriptionHandle      hSoundDesc =NIL;
    long                        lDataOffset;
    long                        lDataSize;
    long                        lNumSamples;
    hSound =GetResource(soundListRsrc, 128);
    if (hSound ==NIL)
        return;
    hSoundDesc =(SoundDescriptionHandle)NewHandle(4);
 
    CreateMySoundDescription(hSound,
                            hSoundDesc,
                            &lDataOffset,
                            &lNumSamples,
                            &lDataSize);
 
    track =NewMovieTrack(movie, 0, 0, kFullVolume);
    media =NewTrackMedia(track, SoundMediaType,
                                FixRound((**hSoundDesc).sampleRate),
                                NIL, 0);
    BeginMediaEdits(media);
    AddMediaSample(media,
                    hSound,
                    lDataOffset,        // offset in data
                    lDataSize,
                    kSoundSampleDuration,   // duration of each sound
                                            //  sample
                    (SampleDescriptionHandle)hSoundDesc,
                    lNumSamples,
                    kSyncSample,        // self-contained samples
                    NIL);
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                            kTrackStart,    // track start time
                            kMediaStart,    // media start time
                            GetMediaDuration(media),
                            kFix1);
    if (hSoundDesc !=NIL)
        DisposeHandle((Handle)hSoundDesc);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime ){};



/*GetTrackDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world.

RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to the region the specified track occupies in a movie's graphics world.
Discussion

This function allocates the region and returns a handle to the region. If the track does not have a spatial representation at the current movie time, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Special Considerations

Your application must dispose of the returned region when you are done with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack ){};

/*SetMediaSampleDescription

Changes the contents of a particular SampleDescription structure of a specified media.

OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to be changed. This index corresponds to the SampleDescription structure itself, not the samples in the media. This long integer must be between 1 and the largest SampleDescription index.
descH

The handle to the SampleDescription structure. If there is no description for the specified index, the function returns this handle unchanged.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH ){};


/*GetMediaSample

Returns a sample from a movie data file.

OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOut

A handle. The GetMediaSample function returns the sample data into this handle. The function increases the size of this handle, if necessary. You can specify the handle's maximum size with the maxSizeToGrow parameter.
maxSizeToGrow

The maximum number of bytes of sample data to be returned. The GetMediaSample function does not increase the handle specified by the dataOut parameter to a size greater than you specify with this parameter. Set this value to 0 to enforce no limit on the number of bytes to be returned.
size

A pointer to a long integer. The GetMediaSample function updates the field referred to by the size parameter with the number of bytes of sample data returned in the handle specified by the dataOut parameter. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. The GetMediaSample function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The GetMediaSample function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The GetMediaSample function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The GetMediaSample function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSample returns flags (see below) that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags ){};

/*TrackTimeToMediaTime

Converts a track's time value to a time value that is appropriate to the track's media, using the track's edit list.

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack );
Parameters
value

The track's time value; must be expressed in the time scale of the movie that contains the track.
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The track's time value, but in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack ){};

/*GetTrackMatrix

Retrieves a track's transformation matrix.

void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure. The GetTrackMatrix function returns the track's matrix into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix ){};

/*MCSetControllerPort

Lets your application set the graphics port for a movie controller.

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
gp

A pointer to the new graphics port for the movie controller. Set this parameter to NIL to use the current graphics port.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Movie controller components use MCSetControllerPort each time you create a new movie controller. Hence, your component must be set to a valid port before creating a new movie controller. You can use this function to place a movie and its associated movie controller in different graphics ports. If you are using an attached controller, both the controller and the movie's graphics ports are changed. If you are using a detached controller, this function changes only the graphics port of the control portion of the controller. You must use SetMovieGWorld followed by MCMovieChanged to change other portions.pascal ComponentResult MCSetControllerPort (MovieController mc,
                                            CGrafPtr gp);

Special Considerations

The movie controller component may use the foreground and background colors from the graphics port at the time this function is called to colorize the movie controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp ){};




/*GetMovieMatrix

Retrieves a movie's transformation matrix.

void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to a MatrixRecord structure, where GetMovieMatrix returns the movie's matrix.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix ){};

/*GetMovieGWorld

Returns a movie's graphics world.

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

A pointer to a field that is to receive a pointer to a CGrafPort structure. Set this parameter to NIL if you don't want this information.
gdh

A pointer to a field that is to receive a handle to a GDevice structure. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh ){};


/*GetTrackSegmentDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world during a specified segment.

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to consider. This time value must be expressed in the movie's time coordinate system. The duration parameter specifies the length of the segment.
duration

The length of the segment to consider. Set this parameter to 0 to consider an instant in time.
Return Value

A handle to the region the specified track occupies in its movie's graphics world during a specified segment. If the track does not have a spatial representation during the specified segment, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

This function allocates the region and returns a handle to it. This region is valid for the specified segment.
Special Considerations

Your application must dispose of the returned region when you are done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration ){};

/*SetMovieTimeValue

Sets a movie's time value.

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
newtime

The new time value. You must ensure that the time value is in the movie's time scale.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime ){};


/*GetTrackOffset

Determines the time difference between the start of a track and the start of the movie that contains the track.

TimeValue GetTrackOffset (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The time difference between the start of the specified track and the start of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackOffset (
   Track    theTrack ){};

/*InsertTrackSegment

Copies data into a track.

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. This function places a copy of the segment, which is obtained from the source track, into this destination track. The media for the destination track must be opened for writing by calling BeginMediaEdits in order for the data to be copied. If the media is not opened for writing, the segment will be copied by reference. At the end of the editing session, your application must call EndMediaEdits if it has called BeginMediaEdits.
srcIn

The start of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
srcDuration

The duration of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the time scale of the movie that contains the destination track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are copying data between tracks, make sure that the two tracks are of the same type. For example, you cannot copy a segment from a sound track into a video track. If you have assigned a progress function to the movie that contains the destination track, the Movie Toolbox calls that progress function during long copy operations.
Special Considerations

If you copy a segment without calling BeginMediaEdits on the destination track's media, the data can be copied later by flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn ){};


/*GetMediaDataRef

Returns a copy of a specified data reference.

OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

The index value that corresponds to the data reference. It must be less than or equal to the value that is returned by GetMediaDataRefCount.
dataRef

A pointer to a field that is to receive a handle to the data reference. The media handler returns a handle to information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If the function cannot locate the specified data reference, the handler sets this returned value to NIL. Set the dataRef parameter to NIL if you are not interested in this information.
dataRefType

A pointer to a field that is to receive the type of data reference. If the data reference is an alias, the media handler sets this value to 'alis'. Set the dataRefType parameter to NIL if you are not interested in this information.
dataRefAttributes

A pointer to a field that is to receive the reference's attribute flags (see below). Unused flags are set to 0. See these constants: 
dataRefSelfReference
dataRefWasNotResolved
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to retrieve information about a data reference. For example, you might want to verify the condition of a movie's data references after loading the movie from its movie file. You could use this function to check each data reference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes ){};






/*MCGetIndMovie

Lets your application to retrieve the movie reference for a movie that is associated with a movie controller.

Movie MCGetIndMovie (
   MovieController    mc,
   short              index );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
index

Index for the movie. When set to 0, this call duplicates the action of the previous call to this function.
Return Value

The movie identifier for the movie that is assigned to the specified controller, or NIL if there is no movie assigned to the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCGetIndMovie (
   MovieController    mc,
   short              index ){};



/*MCGetControllerPort

Returns a movie controller's color graphics port.

CGrafPtr MCGetControllerPort (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A pointer to the movie controller's CGrafPort structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
CGrafPtr MCGetControllerPort (
   MovieController    mc ){};



/*MCGetWindowRgn

Determines the window region that is actually in use by a controller and its movie.

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
Return Value

A handle to the MacRegion structure for the window that is actually in use. Your application must dispose of this structure.
Discussion

The region returned by this function contains only the visible portions of the controller and its movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w ){};


/*GetTrackVolume

Returns a track's current volume setting.

short GetTrackVolume (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's current volume setting. The values returned in the high and low words range from 0x0000 (silence) to 0x0100 (full volume). You can use constants (see below) to test for full volume and no volume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackVolume (
   Track    theTrack ){};


/*ClearMoviesStickyError

Clears the sticky error value.

void ClearMoviesStickyError ( void );
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The Movie Toolbox saves the same result code in the sticky error value. Your application clears the sticky error value by calling ClearMoviesStickyError. The Movie Toolbox then places the first nonzero result code from any toolbox function used by your application into the sticky error value. The Movie Toolbox does not update the sticky error value until your application clears it again.
Special Considerations

Many Movie Toolbox functions don't return an error as a function result; you must use GetMoviesError to obtain the result code. Even if a function explicitly returns an error as a function result, that result is also available using GetMoviesError. The Movie Toolbox does not place a result code into the sticky error value until the field has been cleared. Your application is responsible for clearing the sticky error value to ensure that it does not contain a stale result code.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ClearMoviesStickyError ( void ){};



/*SetMovieBox

Sets a movie's boundary rectangle.

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle that contains the coordinates of the new boundary rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox changes the rectangle by modifying the translation and scale values of the movie's matrix to accommodate the new boundary rectangle.

The movie box might not have its upper-left corner set at (0,0) in its display window when the movie is first loaded. Consequently, your application may need to adjust the position of the movie box so that it appears in the appropriate location within your application's document window. If you don't reset the movie position, the movie might not be visible when it starts playing. The following sample code demonstrates how to do this://Zeroing the boundary rectangle with SetMovieBox
GetMovieBox (movie, &movieBox);
OffsetRect (&movieBox, -movieBox.left, -movieBox.top);
SetMovieBox (movie, &movieBox);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect ){};



/*AddMovieResource

Adds a movie resource to a specified resource file.

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to add to the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file to which the resource is to be added. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by resId is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. AddMovieResource assigns resource ID numbers sequentially, starting at 128. If resId is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value. Set resId to movieInDataForkResID to add the new resource to the movie file's data fork (see below). See these constants: 
movieInDataForkResID
resName

Points to a character string that contains the name of the movie resource. If you set resName to NIL, the toolbox creates an unnamed resource.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function adds the movie to the file, effectively saving any changes you have made to the movie. To use this function with single-fork movie files, pass movieInDataForkResID as the resId parameter. After updating the movie file, AddMovieResource clears the movie changed flag, indicating that the movie has not been changed.// AddMovieResource coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See next section
    CreateMySoundTrack(movie);      // See next section
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by AddMovieToStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName ){};

/*CreateMovieFile

Creates a movie file, creates an empty movie which references the file, and opens the movie file with write permission.

OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Controls movie file creation flags (see below). See these constants: 
createMovieFileDontCreateResFile
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. If you set this parameter to NIL, the Movie Toolbox creates the movie file but does not open the file.
newmovie

A pointer to a field that is to receive the identifier of the new movie. CreateMovieFile returns the identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you set this parameter to NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how CreateMovieFile may be used to create and open a QuickTime movie file.// CreateMovieFile coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);   // See "Discovering QuickTime," page 244
    CreateMySoundTrack(movie);   // See "Discovering QuickTime," page 250
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CreateMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie ){};


/*CloseMovieFile

Closes an open movie file.

OSErr CloseMovieFile (
   short    resRefNum );
Parameters
resRefNum

The movie file to close. Your application obtains this reference number from OpenMovieFile.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code shows a typical use of CloseMovieFile.// CloseMovieFile coding example
// See "Discovering QuickTime," page 50
void OpenMovie (HWND hwnd, char *szFileName)
{
    short   nFileRefNum =0;
    FSSpec  fss;
    // Convert path to FSSpec
    NativePathNameToFSSpec(szFileName, &fss, 0);
    // Set graphics port
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);   // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,    // Get movie from file
                        NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                   // Close movie file
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CloseMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CloseMovieFile (
   short    resRefNum ){};



/*NewMovieFromFile

Creates a new movie in memory from a movie file or from any type of file for which QuickTime provides an import component (AIFF, JPEG, MPEG-4, etc).

OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
resRefNum

The movie file from which the movie is to be loaded. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the resId parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The Movie Toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
resName

A pointer to a character string that is to receive the name of the movie resource that is loaded. If you set the resName parameter to NIL, the Movie Toolbox does not return the resource name.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromFile. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The Movie Toolbox sets the value to TRUE if any references were changed. Use UpdateMovieResource to preserve these changes. Set this parameter to NIL if you don't want to receive this information. See NewMovieTrack for more information about data references.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromFile. To change the graphics world for the new movie, your application should use SetMovieGWorld.

The following is an example of using this function:// NewMovieFromFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Special Considerations

This function works with some files that don't contain movie resources. When it encounters a file that does not contain a movie resource, it tries to find a movie import component that can understand the data and create a movie. It also works for MPEG, uLaw (.AU), and Wave (.WAV) file types. In some cases, the data in a file is already sufficiently well formatted for QuickTime or its components to understand. For example, the AIFF movie data import component can understand AIFF sound files and import the sound data into a QuickTime movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged ){};

/*SetTimeBaseMasterClock

Assigns a clock component to a time base.

void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
clockMeister

The clock component to be assigned to this time base. Your application can obtain this component identifier from FindNextComponent.
slaveZero

A pointer to the time, in the clock's time scale, that corresponds to a 0 time value for the slave time base. This parameter allows you to set an offset between the time base and the clock component. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or from another time base. Don't use this function to assign a clock to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero ){};




/*GetTimeBaseTime

Obtains the current time value from a time base.

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
s

The time scale in which to return the current time value. Set this parameter to 0 to retrieve the time in the preferred time scale of the time base.
tr

A pointer to a time structure that is to receive the current time value. This is an optional parameter. If you don't want the time value represented in a time structure, set this parameter to NIL.
Return Value

The time base's current time.
Discussion

This function returns a time value that contains the current time from the specified time base in the specified time scale. The function returns this value even if you specify a time structure with the tr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr ){};



/*GetMoviePosterPict

Creates a QuickDraw picture that contains a movie's poster.

PicHandle GetMoviePosterPict (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePosterPict (
   Movie    theMovie ){};


/*MCIsControllerAttached

Returns a value that indicates whether a movie controller is attached to its movie.

ComponentResult MCIsControllerAttached (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is attached, the returned value is set to 1. If the controller is not attached, the returned value is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsControllerAttached (
   MovieController    mc ){};



/*MCSetVisible

Lets your application control the visibility of a movie controller.

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
visible

Set to TRUE to cause the controller to be visible, or FALSE to make the controller invisible.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible ){};




/*CopyMovieSettings

Copies many settings from one movie to another, overwriting the destination settings in the process.

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dstMovie

The destination movie for this operation. The CopyMovieSettings function uses the settings from the source movie, which is specified by the srcMovie parameter, to replace the current settings of this movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to copy certain important settings from one movie to another. It copies the preferred rate and volume, source clipping region, matrix information, and user data; it does not copy the movie's contents. To work with movie contents, you should use segment editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie ){};



/*SetMovieMatrix

Sets a movie's transformation matrix.

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to the MatrixRecord structure for the movie. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox uses a movie's matrix to map a movie from its display coordinate system to its graphics world.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix ){};

/*TextMediaAddTextSample

Adds a single block of styled text to an existing media.

ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime );
Parameters
mh

The media handler for the text media obtained by GetMediaHandler.
text

A pointer to a block of text.
size

Indicates the size of the text block, in bytes.
fontNumber

The number for the font in which to display the text.
fontSize

Indicates the size of the font.
textFace

Indicates the typeface or style of the text (that is, bold, italic, and so on).
textColor

A pointer to an RGBColor structure specifying the color of the text. Passing NIL for this parameter in defaults to black.
backColor

A pointer to an RGBColor structure specifying the text background color. Passing NIL for this parameter in defaults to white.
textJustification

Indicates the justification of the text (see below). See these constants: 
textBox

A pointer to a Rect structure that defines the box within which the text is to be displayed. The box is relative to the track bounds.
displayFlags

Contains the text display flags (see below). See these constants: 
dfDontDisplay
dfDontAutoScale
dfClipToTextBox
dfShrinkTextBoxToFit
dfScrollIn
dfScrollOut
dfHorizScroll
dfReverseScroll
dfContinuousScroll
dfFlowHoriz
dfContinuousKaraoke
dfDropShadow
dfAntiAlias
dfKeyedText
dfInverseHilite
dfTextColorHilite
scrollDelay

Indicates the delay in scrolling associated with the setting of the dfScrollIn and dfScrollOut display flags. If the value of the scrollDelay parameter is greater than 0 and the dfScrollIn flag is set, the text pauses when it has scrolled all the way in for the amount of time specified by scrollDelay. If the dfScrollOut flag is set, the pause occurs first before the text scrolls out. If both these flags are set, the pause occurs at the midpoint between scrolling in and scrolling out.
hiliteStart

The beginning of the text to be highlighted.
hiliteEnd

The end of the text to be highlighted. If the hiliteEnd parameter is greater than the hiliteStart parameter, then the text is highlighted from the selection specified by hiliteStart to hiliteEnd. To specify additional highlighting, you can use TextMediaAddHiliteSample.
rgbHiliteColor

Contains a pointer to an RGBColor structure that defines the color for highlighting. If this parameter is not NIL, then the specified color is used when highlighting the text indicated by the hiliteStart and hiliteEnd parameters. Otherwise, the default system highlight color is used.
duration

A time value that specifies how long the text sample should last. This duration is expressed in the media's time base.
sampleTime

Contains a pointer to a time value. The actual media time at which the sample was added is returned here.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Special Considerations

Be sure to turn on the dfDropShadow display flag after you call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime ){};


/*GetMediaHandler

Obtains a reference to a media handler component.

MediaHandler GetMediaHandler (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A media handler component instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MediaHandler GetMediaHandler (
   Media    theMedia ){};




/*SetMovieClipRgn

Establishes a movie's clipping region.

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
theClip

A handle to the movie's clipping region. The Movie Toolbox makes a copy of this region. Your application must dispose of the region referred to by this parameter when you are done with it. Set this parameter to NIL to disable clipping for the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The clipping region is saved with the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip ){};

/*DeleteMovieSegment

Removes a specified segment from a movie.

OSErr DeleteMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
startTime

A time value specifying the starting point of the segment to be deleted.
duration

A time value that specifies the duration of the segment to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration. The following code snippet shows DeleteMovieSegment being used while adding a modifier track to a movie.// DeleteMovieSegment coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    duration ){};


/*NewTimeBase

Obtains a new time base.

TimeBase NewTimeBase ( void );
Return Value

The ID of the new time base.
Discussion

This function sets the rate of the time base to 0, the start time to its minimum value, the time value to 0, and the stop time to its maximum value. The function assigns the default clock component to the new time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase NewTimeBase ( void ){};

/*SetTimeBaseRate

Sets the rate of a time base.

void SetTimeBaseRate (
   TimeBase    tb,
   Fixed       r );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
r

The rate of the time base.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Rates may be set to negative values. Negative rates cause time to move backward for the time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseRate (
   TimeBase    tb,
   Fixed       r ){};


/*SpriteWorldIdle

Allows a sprite world to update its invalid areas.

OSErr SpriteWorldIdle (
   SpriteWorld    theSpriteWorld,
   long           flagsIn,
   long           *flagsOut );
Parameters
theSpriteWorld

The sprite world for this operation.
flagsIn

Contains flags (see below) describing actions that may take place during the idle. For the default behavior, set this parameter to 0. See these constants: 
kOnlyDrawToSpriteWorld
flagsOut

On return, a pointer to flags (see below) describing actions that took place during the idle period. This parameter is optional; if you do not need the information, set it to NIL. See these constants: 
kSpriteWorldDidDraw
kSpriteWorldNeedsToDraw
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This is the only sprite function that causes drawing to occur; you should call it as often as is necessary. Typically, you would make changes in perspective for a number of sprites and then call SpriteWorldIdle to redraw the changed sprites.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SpriteWorldIdle (
   SpriteWorld    theSpriteWorld,
   long           flagsIn,
   long           *flagsOut ){};




/*GetMoviePict

Creates a QuickDraw picture from a specified movie at a specified time.

PicHandle GetMoviePict (
   Movie        theMovie,
   TimeValue    time );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The movie time from which the image is to be taken.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Discussion

This function uses only those movie tracks that are currently enabled and would therefore be used in playback. Your application may call this function even if the movie is inactive.
Special Considerations

Your application must dispose of this picture handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePict (
   Movie        theMovie,
   TimeValue    time ){};





/*ConvertMovieToFile

Takes a specified movie (or a single track within that movie) and converts it into a specified file and type, supporting a Save As dialog box.

OSErr ConvertMovieToFile (
   Movie                theMovie,
   Track                onlyTrack,
   FSSpec               outputFile,
   OSType               fileType,
   OSType               creator,
   ScriptCode           scriptTag,
   short                resID,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The source movie for this conversion operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
onlyTrack

The track within the source movie for this conversion operation. To specify all tracks, set the value of this parameter to 0.
outputFile

A pointer to the file specification for the destination file.
fileType

The data type of the destination file for the movie specified in the parameter theMovie.
creator

The creator value for the output file if it is a new one.
scriptTag

The script into which the movie should be converted if the output file is a new one. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
resID

A pointer to a field that is to receive the resource ID of the open movie. If you don't want to receive this information, set the resID parameter to NIL.
flags

Contains flags (see below) that control whether and how the Save As dialog box appears. See these constants: 
showUserSettingsDialog
movieToFileOnlyExport
movieFileSpecValid
userComp

If you want a particular movie export component to perform the conversion, you may pass the component or an instance of that component in this parameter. Otherwise, set it to 0 to allow the Movie Toolbox to use the appropriate component. If you pass in a component instance, it is used by ConvertMovieToFile. This allows you to communicate directly with the component before making this call to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this call.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application controls whether a Save As dialog box appears by setting the value of the flags parameter. The dialog box lets the user specify the file name and type. Supported types include standard QuickTime movies, flattened movies, single-fork flattened movies, and any format that is supported by a movie data export component. The following code snippets show how to call ConvertMovieToFile to provide a simple export capability and how to save a sound-only QuickTime movie as a WAV file.// Providing an export capability with ConvertMovieToFile
err =ConvertMovieToFile (theMovie,     / identifies movie /
                    NIL,                / all tracks /
                    NIL,                / no output file /
                    0,                  / no file type /
                    0,                  / no creator /
                    -1,                 / script /
                    NIL,                / no resource ID /
                    createMovieFileDeleteCurFile |
                        showUserSettingsDialog |
                        movieToFileOnlyExport,
                    0);                 / no specific component /
// Saving a sound-only QuickTime movie as a WAVE file
// See "Discovering QuickTime," page 257
void SndSnip_SaveSoundMovieAsWAVEFile (Movie theMovie)
{
    StandardFileReply   myReply;
    // have the user select the name and location of the new WAVE file
    StandardPutFile("\pSave sound movie file as:",
                                           "\pUntitled.wav", &myReply);
    if (!myReply.sfGood)
        return;
    // use the default progress procedure, if any
    SetMovieProgressProc(theMovie, (MovieProgressUPP)-1L, 0);
    // export the movie into a file
    ConvertMovieToFile( theMovie,               // the movie to convert
                        NIL,                   // all tracks in the movie
                        &myReply.sfFile,        // the output file
                        kQTFileTypeWave,        // the output file type
                        FOUR_CHAR_CODE('TVOD'), // the output file creator
                        smSystemScript,         // the script
                        NIL,                   // no resource ID
                                                //   to be returned
                        0L,                     // no flags
                        NIL);                  // no specific component
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr ConvertMovieToFile (
   Movie                theMovie,
   Track                onlyTrack,
   FSSpec               *outputFile,
   OSType               fileType,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp ){};




/*PutMovieIntoTypedHandle

Takes a movie, or a single track from within that movie, and converts it into a handle of a specified type.

OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
targetTrack

The track to convert.
handleType

The type of the new data.
publicMovie

The actual handle in which to place the new data.
start

The start time of the segment of the movie or track to be converted.
dur

The duration of the segment of the movie or track to be converted.
flags

Condition of the conversion. Set this parameter to 0.
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, this function will use it. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp ){};


/*NewSpriteWorld

Creates a new sprite world.

OSErr NewSpriteWorld (
   SpriteWorld    *newSpriteWorld,
   GWorldPtr      destination,
   GWorldPtr      spriteLayer,
   RGBColor       *backgroundColor,
   GWorldPtr      background );
Parameters
newSpriteWorld

A pointer to a field that is to receive the new sprite world's identifier. On return, this field contains the identifier for the newly created sprite world.
destination

A pointer to a CGrafPort structure that defines the graphics world to be used as the destination.
spriteLayer

A pointer to a CGrafPort structure that defines the graphics world to be used as the sprite layer.
backgroundColor

A pointer to an RGBColor structure that defines the color to be used as the background color. If you pass a background graphics world to this function by setting the background parameter, you can set this parameter to NIL.
background

A pointer to a CGrafPort structure that defines the graphics world to be used as the background. If you pass a background color to this function by setting the backgroundColor parameter, you can set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new sprite world with associated destination and sprite layer graphics worlds, and either a background color or a background graphics world. Once created, you can manipulate the sprite world and add sprites to it using other sprite Movie Toolbox functions.

The newSpriteWorld, destination, and spriteLayer parameters are all required. You should specify a background color, a background graphics world, or both. You should not pass NIL for both parameters. If you specify both a background graphics world and a background color, the sprite world is filled with the background color before the background sprites are drawn. If no background color is specified, black is the default. If you specify a background graphics world, it should have the same dimensions and depth as the graphics world specified by spriteLayer. If you draw to the graphics worlds associated with a sprite world using standard QuickDraw and QuickTime functions, your drawing is erased by the sprite world's background color. The sprite world created by this function has an identity matrix and does not have a clip shape.

Here is an example of creating a sprite world:// NewSpriteWorld coding example
// See "Discovering QuickTime," page 166
GWorldPtr       pSpritePlane =NIL;
SpriteWorld     spriteWorld =NIL;
Rect            rectBounce;
RGBColor        rgbcBackground;
void CreateSpriteStuff (Rect *pWndRect, CGrafPtr pMacWnd)
{
    OSErr       nErr;
    Rect        rect;
    // calculate the size of the destination
    rect =*pWndRect;
    OffsetRect(&rect, -rect.left, -rect.top);
    rectBounce =rect;
    InsetRect(&rectBounce, 16, 16);
    // create a sprite graphics world with a bit depth of 16
    NewGWorld(&pSpritePlane, 16, &rect, NIL, NIL, useTempMem);
    if (pSpritePlane ==NIL)
        NewGWorld(&pSpritePlane, 16, &rect, NIL, NIL, 0);
    if (pSpritePlane !=NIL) {
        LockPixels(pSpritePlane->
portPixMap);
        rgbcBackground.red =
        rgbcBackground.green =
        rgbcBackground.blue =0;
        // create a sprite world
        nErr =NewSpriteWorld(&spriteWorld, (CGrafPtr)pMacWnd,
            pSpritePlane, &rgbcBackground, NIL);
    }
}

Special Considerations

Before calling this function, you should lock the pixel maps of the sprite layer and background graphics worlds. These graphics worlds must remain valid and locked for the lifetime of the sprite world. The sprite world does not own the graphics worlds that are associated with it; it is the caller's responsibility to dispose of the graphics worlds when they are no longer needed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewSpriteWorld (
   SpriteWorld    *newSpriteWorld,
   GWorldPtr      destination,
   GWorldPtr      spriteLayer,
   RGBColor       *backgroundColor,
   GWorldPtr      background ){};


/*NewSprite

Creates a new sprite in a specified sprite world.

OSErr NewSprite (
   Sprite                    *newSprite,
   SpriteWorld               itsSpriteWorld,
   ImageDescriptionHandle    idh,
   Ptr                       imageDataPtr,
   MatrixRecord              *matrix,
   Boolean                   visible,
   short                     layer );
Parameters
newSprite

A pointer to field that is to receive the new sprite's identifier. On return, this field contains the identifier of the newly created sprite.
itsSpriteWorld

The sprite world with which the new sprite should be associated.
idh

A handle to an ImageDescription structure of the sprite's image.
imageDataPtr

A pointer to the sprite's image data.
matrix

A pointer to the sprite's MatrixRecord structure. If you pass NIL, an identity matrix is assigned to the sprite.
visible

Specifies whether the sprite is visible.
layer

The sprite's layer. Sprites with lower layer values appear in front of sprites with higher layer values. If you want to create a sprite that is drawn to the background graphics world, you should specify the constant kBackgroundSpriteLayerNum for the layer parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The visible parameter, the layer parameter, and the newSprite and itsSpriteWorld parameters are required. You can defer assigning image data to the sprite by passing NIL for both the idh and imageDataPtr parameters. If you choose to defer assigning image data, you must call SetSpriteProperty to assign the image description handle and image data to the sprite before the next call to SpriteWorldIdle.
Special Considerations

The caller owns the image description handle and the image data pointer; it is the caller's responsibility to dispose of them after it disposes of a sprite.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewSprite (
   Sprite                    *newSprite,
   SpriteWorld               itsSpriteWorld,
   ImageDescriptionHandle    idh,
   Ptr                       imageDataPtr,
   MatrixRecord              *matrix,
   Boolean                   visible,
   short                     layer ){};


/*GetMovieDisplayBoundsRgn

Determines a movie's display boundary region.

RgnHandle GetMovieDisplayBoundsRgn (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a MacRegion structure that the function allocates. If the movie does not have a spatial representation at the current time, the function returns an empty region. If the function could not satisfy the request, it sets the returned handle to NIL.
Discussion

The display boundary region encloses all of a movie's enabled tracks after the track matrix, track clip, movie matrix, and movie clip have been applied to them. This region is in the display coordinate system of the movie's graphics world. The Movie Toolbox derives the display boundary region only from enabled tracks, and only from those tracks that are used in the current display mode (that is, movie, poster, or preview). The display boundary region is valid for the current movie time.
Special Considerations

Your application must dispose of the returned handle when it is done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetMovieDisplayBoundsRgn (
   Movie    theMovie ){};


/*DisposeMovieProgressUPP

Disposes of a MovieProgressUPP pointer.

void DisposeMovieProgressUPP (
   MovieProgressUPP    userUPP );
Parameters
userUPP

A MovieProgressUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieProgressUPP (
   MovieProgressUPP    userUPP ){};


/*InsertMovieSegment

Copies part of one movie to another.

OSErr InsertMovieSegment (
   Movie        srcMovie,
   Movie        dstMovie,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. This function obtains the movie segment from the source movie specified in this parameter.
dstMovie

The destination movie for this operation. The function places a copy of the segment, which it obtained from the source movie, into this destination movie.
srcIn

The start of the segment in the source movie. This time value must be expressed in the source movie's time scale.
srcDuration

The duration of the segment in the source movie. This time value must be expressed in the source movie's time scale.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the destination movie's time scale.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are not copying data from one location in a movie to a different point in the same movie, this function may create new tracks, as appropriate. Before adding a track to the destination movie, the Movie Toolbox looks in the destination movie for tracks that have the same characteristics as the tracks in the source movie. The toolbox considers several characteristics when searching for an appropriate track, including track spatial dimensions, track matrix, track clipping region, track matte, alternate group affiliation, media time scale, media type, media language, and data reference (that is, referring to the same file). If the Movie Toolbox cannot find an appropriate track in the destination movie, it creates a new track with the proper characteristics.
Special Considerations

If you have assigned a progress function to the destination movie, the Movie Toolbox calls that progress function during long copy operations. Some Movie Toolbox functions can take a long time to execute. For example, if you call FlattenMovie and specify a large movie, the Movie Toolbox must read and write all the sample data for the movie. During such operations you may wish to display some kind of progress indicator to the user.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMovieSegment (
   Movie        srcMovie,
   Movie        dstMovie,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn ){};

/*AddEmptyTrackToMovie

Duplicates a track from a movie into the same movie or into another movie.

OSErr AddEmptyTrackToMovie (
   Track     srcTrack,
   Movie     dstMovie,
   Handle    dataRef,
   OSType    dataRefType,
   Track     *dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstMovie

The destination movie for this operation. This can be the same movie as the source track or a different movie.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
dstTrack

The newly created track's identifier is returned in this parameter. If AddEmptyTrackToMovie fails, the resulting track identifier is set to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function returns a newly created, empty track. The newly created track has the same media type and track settings as the specified track. However, no data is copied from the source track to the new track. To copy data from the source track to the new track, use InsertTrackSegment after calling AddEmptyTrackToMovie.
Version Notes

This function has been available since QuickTime 2.0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddEmptyTrackToMovie (
   Track     srcTrack,
   Movie     dstMovie,
   Handle    dataRef,
   OSType    dataRefType,
   Track     *dstTrack ){};



/*PlayMoviePreview

Plays a movie's preview.

void PlayMoviePreview (
   Movie                     theMovie,
   MoviePreviewCallOutUPP    callOutProc,
   long                      refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
callOutProc

A pointer to a MoviePreviewCallOutProc callback in your application. The Movie Toolbox calls this function repeatedly while the movie preview is playing. You can use this function to stop the preview. If you don't want to assign a function, set this parameter to NIL.
refcon

A reference constant that the Movie Toolbox passes to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function sets the movie into preview mode, plays the movie preview, sets the movie back to normal playback mode, and returns to your application. The Movie Toolbox plays the preview in the movie's graphics world. Note that if you call the GetMovieActiveSegment function from within your movie callout function, the Movie Toolbox will have changed the active movie segment to be the preview segment of the movie. The Movie Toolbox restores the active segment when the preview is done playing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void PlayMoviePreview (
   Movie                     theMovie,
   MoviePreviewCallOutUPP    callOutProc,
   long                      refcon ){};


/*AddMovieSelection

Adds one or more tracks to a movie.

void AddMovieSelection (
   Movie    theMovie,
   Movie    src );
Parameters
theMovie

The destination movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
src

The source movie for this operation. AddMovieSelection adds the tracks from this movie to the destination movie. The function adds these tracks at the time specified by the current selection in the destination movie.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function scales the source movie so that it fits into the destination selection. If the current selection in the destination movie has a 0 duration, the Movie Toolbox adds the segment at the beginning of the current selection. The entire source movie is used regardless of the selection in the source movie. The Movie Toolbox removes any empty tracks from the destination movie after the add operation. If you have assigned a progress function to the destination movie, the Movie Toolbox calls that progress function during long add operations. Following is an example of using this function:// AddMovieSelection coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Special Considerations

Some Movie Toolbox functions can take a long time to execute. For example, if you call FlattenMovie and specify a large movie, the Movie Toolbox must read and write all the sample data for the movie. During such operations you may wish to display some kind of progress indicator to the user. A progress function is an application-defined function that you can create to track the progress of time-consuming activities and keep the user informed. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void AddMovieSelection (
   Movie    theMovie,
   Movie    src ){};



/*QTRemoveAtom

Removes an atom and its children from the specified atom container.

OSErr QTRemoveAtom (
   QTAtomContainer    container,
   QTAtom             atom );
Parameters
container

The atom container for this operation. The atom container must not be locked.
atom

The atom to be removed from the container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to remove a particular atom and its children from an atom container. To remove all the atoms in an atom container, you should use QTRemoveChildren.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTRemoveAtom (
   QTAtomContainer    container,
   QTAtom             atom ){};



/*GetMovieSelection

Returns information about a movie's current selection.

void GetMovieSelection (
   Movie        theMovie,
   TimeValue    *selectionTime,
   TimeValue    *selectionDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
selectionTime

A pointer to a time value. The GetMovieSelection function places the starting time of the current selection into the field referred to by this parameter. Set this parameter to NIL if you don't want this information.
selectionDuration

A pointer to a time value. The GetMovieSelection function places the duration of the current selection into the field referred to by this parameter. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieSelection (
   Movie        theMovie,
   TimeValue    *selectionTime,
   TimeValue    *selectionDuration ){};




/*ShowMovieInformation

Displays a movie's information.

void ShowMovieInformation (
   Movie             theMovie,
   ModalFilterUPP    filterProc,
   long              refCon );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
filterProc

A Universal Procedure Pointer that accesses a ModalFilterProc callback.
refCon

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ShowMovieInformation (
   Movie             theMovie,
   ModalFilterUPP    filterProc,
   long              refCon ){};



/*SetMoviePosterTime

Sets the poster time for the movie.

void SetMoviePosterTime (
   Movie        theMovie,
   TimeValue    posterTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
posterTime

The starting time for the movie frame that contains the poster image, expressed in the movie's time coordinate system.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Since a movie poster is a still frame, it is defined by a point in time within the movie. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePosterTime (
   Movie        theMovie,
   TimeValue    posterTime ){};

/*QTReplaceAtom

Replaces the contents of an atom and its children with a different atom and its children.

OSErr QTReplaceAtom (
   QTAtomContainer    targetContainer,
   QTAtom             targetAtom,
   QTAtomContainer    replacementContainer,
   QTAtom             replacementAtom );
Parameters
targetContainer

The atom container that contains the atom to be replaced. The atom container must not be locked.
targetAtom

The atom to be replaced.
replacementContainer

The atom container that contains the replacement atom.
replacementAtom

The replacement atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The target atom and the replacement atom must be of the same type. The target atom maintains its original atom ID. This function does not modify the replacement container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTReplaceAtom (
   QTAtomContainer    targetContainer,
   QTAtom             targetAtom,
   QTAtomContainer    replacementContainer,
   QTAtom             replacementAtom ){};


/*GetDataHandler

Retrieves the best data handler component to use with a given data reference.

Component GetDataHandler (
   Handle    dataRef,
   OSType    dataHandlerSubType,
   long      flags );
Parameters
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by the dataHandlerSubType parameter.
dataHandlerSubType

Identifies both the type of data reference and, by implication, the component subtype value assigned to the data handler components that operate on data references of that type.
flags

Contains flags (see below) that indicate the way in which you intend to use the data handler component. Note that not all data handlers necessarily support all services; for example, some data handler components may not support streaming writes. Set the appropriate flags to 1. See these constants: 
kDataHCanRead
kDataHCanWrite
kDataHCanStreamingWrite
Return Value

The best data handler component conforming to the parameters passed in.
Discussion

Once you have used this function to get information about the best data handler component for your data reference, you can open and use the component using Component Manager functions. If the function returns a value of NIL, the toolbox was unable to find an appropriate data handler component. For more information about the error that caused a return of NIL, call GetMoviesError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Component GetDataHandler (
   Handle    dataRef,
   OSType    dataHandlerSubType,
   long      flags ){};



/*GetMediaSampleReference

Obtains reference information about samples that are stored in a movie data file.

OSErr GetMediaSampleReference (
   Media                      theMedia,
   long                       *dataOffset,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOffset

A pointer to a long integer. GetMediaSampleReference updates the field referred to by this parameter with the offset to the sample data. This parameter is used differently by each media handler. For example, the hierarchical file system (HFS) media handler returns an offset into the file that contains the media data.
size

A pointer to a long integer. GetMediaSampleReference updates the field referred to by the size parameter with the number of bytes of sample data referred to by the reference. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample reference to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. GetMediaSampleReference updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. GetMediaSampleReference returns the structure corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want the SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. GetMediaSampleReference returns an index value to the SampleDescription structure that corresponds to the returned sample data. To retrieve the media sample description, pass this index in the descH parameter of GetMediaSampleDescription. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return a reference that refers to more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. GetMediaSampleReference updates the field referred to by this parameter with the number of samples referred to by the returned reference. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSampleReference returns flags (see below) that describe the samples referred to by the returned reference. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSampleReference (
   Media                      theMedia,
   long                       *dataOffset,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags ){};


/*ScaleMovieSegment

Changes the duration of a segment of a movie.

OSErr ScaleMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    oldDuration,
   TimeValue    newDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
startTime

The start of the segment. The oldDuration parameter specifies the segment's duration. This time value must be expressed in the movie's time scale.
oldDuration

The original duration of the segment in the source movie. This time value must be expressed in the movie's time scale.
newDuration

The new duration of the segment. This time value must be expressed in the movie's time scale. The function alters the segment to accommodate the new duration.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox scales the segment to accommodate the new duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr ScaleMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    oldDuration,
   TimeValue    newDuration ){};

/*HIMovieViewGetControllerBarSize

Returns the size of the visible movie controller bar.

HISize HIMovieViewGetControllerBarSize (
   HIViewRef inView );
Parameters
inView

The HIMovieView.
Return Value

Undocumented.
Discussion

The size of the visible movie controller bar is returned. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
HISize HIMovieViewGetControllerBarSize (
   HIViewRef inView ){};



/*HIMovieViewChangeAttributes

Changes the views attributes.

OSStatus HIMovieViewChangeAttributes (
   HIViewRef inView,
   OptionBits inAttributesToSet,
   OptionBits inAttributesToClear );
Parameters
inView

The HIMovieView.
inAttributesToSet

Attributes to set.
inAttributesToClear

Attributes to clear.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Setting an attribute takes precedence over clearing the attribute.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
OSStatus HIMovieViewChangeAttributes (
   HIViewRef inView,
   OptionBits inAttributesToSet,
   OptionBits inAttributesToClear ){};


/*HIMovieViewSetMovie

Sets the view's current movie.

OSStatus HIMovieViewSetMovie (
   HIViewRef inView,
   Movie inMovie );
Parameters
inView

The HIMovieView.
inMovie

The new movie to display.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine sets the view's current movie.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
OSStatus HIMovieViewSetMovie (
   HIViewRef inView,
   Movie inMovie ){};




/*NewQTCallBackUPP

Allocates a Universal Procedure Pointer for the QTCallBackProc callback.

QTCallBackUPP NewQTCallBackUPP (
   QTCallBackProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTCallBackProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTCallBackUPP NewQTCallBackUPP (
   QTCallBackProcPtr    userRoutine ){};

/*NewTrackTransferUPP

Allocates a Universal Procedure Pointer for the TrackTransferProc callback.

TrackTransferUPP NewTrackTransferUPP (
   TrackTransferProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewTrackTransferProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TrackTransferUPP NewTrackTransferUPP (
   TrackTransferProcPtr    userRoutine ){};

/*GetMoviePosterTime

Returns the poster's time in a movie.

TimeValue GetMoviePosterTime (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The time in the movie from which its poster is taken.
Discussion

Since a movie poster has no duration, it is defined by a point in time within the movie. The time value returned by GetMoviePosterTime is in the time coordinate system of the movie and represents the starting time for the movie frame that contains the poster image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMoviePosterTime (
   Movie    theMovie ){};

/*GetTrackPict

Creates a QuickDraw picture from a specified track at a specified time.

PicHandle GetTrackPict (
   Track        theTrack,
   TimeValue    time );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The time at which the image is taken.
Return Value

A handle to the specified picture. If the function could not create the picture, the returned handle is set to NIL.
Special Considerations

Your application must dispose of the returned picture handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetTrackPict (
   Track        theTrack,
   TimeValue    time ){};

/*AddMediaDataRef

Adds a data reference to a media.

OSErr AddMediaDataRef (
   Media     theMedia,
   short     *index,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

A pointer to a short integer. The Movie Toolbox returns the index value that is assigned to the new data reference. Your application can use this index to identify the reference to other Movie Toolbox functions, such as GetMediaDataRef. If the Movie Toolbox cannot add the data reference to the media, it sets the returned index value to 0.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter.
dataRefType

The type of data reference. If the data reference is an alias, you must set this parameter to rAliasType.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddMediaDataRef (
   Media     theMedia,
   short     *index,
   Handle    dataRef,
   OSType    dataRefType ){};


/*GetMediaPropertyAtom

Retrieves the property atom container of a media handler.

OSErr GetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    *propertyAtom );
Parameters
theMedia

A reference to the media handler for this operation.
propertyAtom

A pointer to a QT atom container. On return, the atom container contains the property atoms for the track associated with the media handler.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call GetMediaPropertyAtom to retrieve the properties of the track associated with the specified media handler. The contents of the returned QT atom container are defined by the media handler.
Special Considerations

The caller is responsible for disposing of the QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    *propertyAtom ){};


/*QTCopyAtom

Copies an atom and its children to a new atom container.

OSErr QTCopyAtom (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomContainer    *targetContainer );
Parameters
container

The atom container that contains the atom to be copied.
atom

The atom to be copied. To duplicate the entire container, pass a value of kParentAtomIsContainer for the atom parameter.
targetContainer

A pointer to an uninitialized atom container data structure. On return, this parameter points to an atom container that contains a copy of the atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The caller is responsible for disposing of the new atom container by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCopyAtom (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomContainer    *targetContainer ){};

/*GetMediaDataRefCount

Determines the number of data references in a media.

OSErr GetMediaDataRefCount (
   Media    theMedia,
   short    *count );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
count

A pointer to a field that is to receive the number of data references in the media.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRefCount (
   Media    theMedia,
   short    *count ){};



/*DisposeMovieTrack

Removes a track from a movie.

void DisposeMovieTrack (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The following code snippet illustrates the use of DisposeMovieTrack:// DisposeMovieTrack coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovieTrack (
   Track    theTrack ){};

/*NewMovieProgressUPP

Allocates a Universal Procedure Pointer for the MovieProgressProc callback.

MovieProgressUPP NewMovieProgressUPP (
   MovieProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieProgressUPP NewMovieProgressUPP (
   MovieProgressProcPtr    userRoutine ){};

/*SetMovieVideoOutput

Indicates to the ICM the video output component being used with a given movie.

void SetMovieVideoOutput (
   Movie                theMovie,
   ComponentInstance    vout );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
vout

The video output component. Applications obtain this reference from OpenComponent or OpenDefaultComponent. Call the function and pass NIL in this parameter as soon as the video output component is no longer in use.
Discussion

As soon as you turn on the echo port on any video output component, you should make this call so the ICM keeps track of the video output in use.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieVideoOutput (
   Movie                theMovie,
   ComponentInstance    vout ){
printf ("SetMovieVideoOutput",theMovie,vout);
};

/*SetMovieMasterClock

Assigns a clock component to a movie.

void SetMovieMasterClock (
   Movie               theMovie,
   Component           clockMeister,
   const TimeRecord    *slaveZero );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
clockMeister

The clock component to be assigned to this movie. Your application can obtain this component identifier from FindNextComponent.
slaveZero

A pointer to the time, in the clock's time scale, that corresponds to a 0 time value for the movie. This parameter allows you to set an offset between the clock component and the time base of the movie. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Don't use SetTimeBaseMasterClock to assign a clock component to a movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieMasterClock (
   Movie               theMovie,
   Component           clockMeister,
   const TimeRecord    *slaveZero ){
printf ("SetMovieMasterClock",theMovie,clockMeister,*slaveZero);
};


/*ChooseMovieClock

Searches media handlers to find the best clock for a movie.

void ChooseMovieClock (
   Movie    m,
   long     flags );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

Currently not used; set to 0.
Discussion

This function calls MediaGetClock and finds the first media handler that has a custom clock. It then calls SetMovieMasterClock to use the best clock as the movie's master timebase clock.

ChooseMovieClock can be used to tie the movie's master timebase to a sound clock if there is a sound track. If there is no sound track, the microseconds clock is used as the master timebase.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
void ChooseMovieClock (
   Movie    m,
   long     flags ){
printf ("ChooseMovieClock",m,flags);
};

/*OpenADataHandler

Opens a data handler component.

OSErr OpenADataHandler (
   Handle               dataRef,
   OSType               dataHandlerSubType,
   Handle               anchorDataRef,
   OSType               anchorDataRefType,
   TimeBase             tb,
   long                 flags,
   ComponentInstance    *dh );
Parameters
dataRef

A handle to a data reference. The type of information stored in the handle depends upon the data reference type specified by the dataHandlerSubType parameter.
dataHandlerSubType

Identifies both the type of data reference and, by implication, the component subtype value assigned to the data handler components that operate on data references of that type.
anchorDataRef

A handle to the anchor data reference.
anchorDataRefType

The type of the anchor data reference.
tb

The time base for the data handler. Your application obtains this time base identifier from NewTimeBase.
flags

Flags (see below) that indicate the way in which you intend to use the data handler component. Not all data handlers necessarily support all services; for example, some data handler components may not support streaming writes. Set the appropriate flags to 1. See these constants: 
kDataHCanRead
kDataHCanWrite
kDataHCanStreamingWrite
dh

A pointer to a field to receive the ComponentInstance value of the newly-opened data handler component.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr OpenADataHandler (
   Handle               dataRef,
   OSType               dataHandlerSubType,
   Handle               anchorDataRef,
   OSType               anchorDataRefType,
   TimeBase             tb,
   long                 flags,
   ComponentInstance    *dh ){};








/*QTNewDataReferenceFromFSSpec

Creates an alias data reference from a file specification of type FSSpec.

OSErr QTNewDataReferenceFromFSSpec (
   const FSSpec    *fsspec,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );
Parameters
fsspec

A pointer to an opaque file system reference.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You can use File Manager functions to construct an FSSpec structure to specify a file. Then you can pass the new alias data reference to other Movie Toolbox functions that take a data reference. Because of the limitations of its data structure, an FSSpec may not work for a file with long or Unicode file names. Generally, you should use either QTNewDataReferenceFromFSRef or QTNewDataReferenceFromFSRefCFString instead.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFSSpec (
   const FSSpec    *fsspec,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType ){};


/*DisposeTrackMedia

Removes a media from a track.

void DisposeTrackMedia (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function does not remove the track from its movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTrackMedia (
   Media    theMedia ){
printf ("DisposeTrackMedia",theMedia);
};


/*AddUserData

Adds an item to a user data list.

OSErr AddUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType );

Parameters
theUserData

The user data list for this operation. You obtain this item reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A handle to the data to be added to the user data list.
udType

The type that is to be assigned to the new item.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list, the data to be added, and the data's type value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType ){};

/*SetTrackClipRgn

Sets the clipping region of a track.

void SetTrackClipRgn (
   Track        theTrack,
   RgnHandle    theClip );

Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
theClip

A handle to the track's clipping region. The Movie Toolbox makes a copy of this region. Your application must dispose of the region referred to by this parameter when you are done with it. Set this parameter to NIL to disable clipping for the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackClipRgn (
   Track        theTrack,
   RgnHandle    theClip ){};



/*ConvertMovieToDataRef

Converts a specified movie (or a single track within a movie) into a specified file format and stores it in a specified storage location.

OSErr ConvertMovieToDataRef (
   Movie                theMovie,
   Track                onlyTrack,
   Handle               dataRef,
   OSType               dataRefType,
   OSType               fileType,
   OSType               creator,
   long                 flags,
   ComponentInstance    userComp );

Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
onlyTrack

The track in the source movie, if you want to convert only a single track.
dataRef

A data reference that specifies the storage location to receive the converted movie data.
dataRefType

The type of data reference. This function currently supports only alias data references.
fileType

The Mac OS file type of the storage location, which determines the export format.
creator

The creator type of the storage location.
flags

Flags (see below) that control the operation of the dialog box. See these constants: 
showUserSettingsDialog
movieToFileOnlyExport
movieFileSpecValid

userComp

An instance of the component to be used for converting the movie data.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Discussion

If the storage location is on a local file system, the file will have the specified file type and the creator. If specified as such in the flags, the function displays a dialog box that lets the user choose the output file and the export type. If an export component (or its instance) is specified in the userComp parameter, it will be used to perform the conversion operation.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr ConvertMovieToDataRef (
   Movie                theMovie,
   Track                onlyTrack,
   Handle               dataRef,
   OSType               dataRefType,
   OSType               fileType,
   OSType               creator,
   long                 flags,
   ComponentInstance    userComp ){};

/*GetMediaInputMap

Returns a copy of the input map associated with a specified media.

OSErr GetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    *inputMap );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
inputMap

The media input map for this operation. You must dispose of the map referred to by this parameter when you are done with it using QTDisposeAtomContainer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify the media you want to get so you can modify its input map, as illustrated below:// GetMediaInputMap coding example
// See "Discovering QuickTime," page 365
#define kImageIndexToOverride           1
Movie               movie1, movie2;
long                lReferenceIndex, lImageIndexToOverride;
Track               trackSprite;
QTAtomContainer     qtacInputMap;
QTAtom              lInputAtom;
OSType              dwInputType;
Media               mediaSprite;
// get the sprite media's input map
mediaSprite =GetTrackMedia(trackSprite);
GetMediaInputMap(mediaSprite, &qtacInputMap);
// add an atom for a modifier track
QTInsertChild(qtacInputMap, kParentAtomIsContainer, kTrackModifierInput,
                lReferenceIndex, 0, 0, NIL, &lInputAtom);
// add a child atom to specify the input type
dwInputType =kTrackModifierTypeImage;
QTInsertChild(qtacInputMap, lInputAtom, kTrackModifierType, 1, 0,
                sizeof(dwInputType), &dwInputType, NIL);
// add a second child atom to specify index of image to override
lImageIndexToOverride =EndianS16_NtoB(kImageIndexToOverride);
QTInsertChild(qtacInputMap, lInputAtom, kSpritePropertyImageIndex, 1, 0,
        sizeof(lImageIndexToOverride), &lImageIndexToOverride, NIL);
// update the sprite media's input map
SetMediaInputMap(mediaSprite, qtacInputMap);
QTDisposeAtomContainer(qtacInputMap);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    *inputMap ){};


/*DisposeMoviePrePrerollCompleteUPP

Disposes of a MoviePrePrerollCompleteUPP pointer.

void DisposeMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteUPP    userUPP );

Parameters
userUPP

A MoviePrePrerollCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteUPP    userUPP ){};


/*SetMoviePreviewTime

Defines the starting time and duration of the movie's preview.

void SetMoviePreviewTime (
   Movie        theMovie,
   TimeValue    previewTime,
   TimeValue    previewDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
previewTime

A time value that specifies the preview's starting time.
previewDuration

A time value that specifies the preview's duration.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePreviewTime (
   Movie        theMovie,
   TimeValue    previewTime,
   TimeValue    previewDuration ){};

OSErr
InvokeMovieProgressUPP(
  Movie             theMovie,
  short             message,
  short             whatOperation,
  Fixed             percentDone,
  long              refcon,
  MovieProgressUPP  userUPP){};


/*GetNextUserDataType

Retrieves the next user data type in a specified user data list.

long GetNextUserDataType (
   UserData    theUserData,
   OSType      udType );

Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
udType

Specifies a user data field; see User Data Identifiers. Set this parameter to 0 to retrieve the first user data field in the user data list. On subsequent requests, use the previous value returned by this function.
Return Value

The next user data type in the list. Returns 0 when there are no more user data types.
Discussion

Use this function to scan all the user data types in a user data list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetNextUserDataType (
   UserData    theUserData,
   OSType      udType ){};












