#include <QD/QD.h>

//work

/*ATSUDirectReleaseLayoutDataArrayPtr

Releases a pointer to a direct-data array.

extern OSStatus ATSUDirectReleaseLayoutDataArrayPtr(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   void *                   iLayoutDataArrayPtr[]
);
Parameters
iLineRef

An ATSULineRef value that specifies the line of text whose data is pointed to by the iLayoutDataArrayPtr parameter. Pass NULL if you did not obtain the layout data array pointer using a lineRef.
iDataSelector

A direct-data selector constant that specifies the data pointed to by the iLayoutDataArrayPtr parameter. You can pass any of the constants described in “Direct Data Selectors”.
iLayoutDataArrayPtr[]

A pointer to the layout data array of which you want to dispose.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

You must call the function ATSUDirectReleaseLayoutDataArrayPtr when you no longer need the direct-data pointer you obtained from the ATSUDirectGetLayoutDataArrayPtrFromLineRef or ATSUDirectGetLayoutDataArrayPtrFromTextLayout functions. You must dispose of the pointer to inform ATSUI you no longer need the data and to allow for ATSUI to make any internal adjustments prior to completing the layout process.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/
OSStatus ATSUDirectReleaseLayoutDataArrayPtr(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   void *                   iLayoutDataArrayPtr[]
){};

/*ATSUDirectGetLayoutDataArrayPtrFromTextLayout

Obtains a copy of the glyph data specified by a direct-data selector and for a specific line of text in a text layout object.

OSStatus ATSUDirectGetLayoutDataArrayPtrFromTextLayout(
   ATSUTextLayout           iTextLayout,
   UniCharArrayOffset       iLineOffset,
   ATSUDirectDataSelector   iDataSelector,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
);
Parameters
iTextLayout

An ATSUTextLayout value that specifies the text layout object whose data you want to obtain.
iLineOffset

The edge offset that corresponds to the beginning of the line of text whose data you want to obtain. 
iDataSelector

A direct-data selector constant that specifies the data you want to obtain. You can pass any of the constants described in “Direct Data Selectors”.
oLayoutDataArrayPtr[]

On return, points to an array that contains the data specified by the iDataSelector parameter. The data is for the line of text referenced by the iLineOffset parameter. If an array for the specified data does not exist, ATSUI returns NULL. You can pass NULL if you only want to obtain the number of entries in the array in the oLayoutDataArray array.
oLayoutDataCount

On return, the number of entries in the array oLayoutDataArray.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

The function ATSUDirectGetLayoutDataArrayPtrFromTextLayout returns a pointer to the data specified by iDataSelector and referenced by iTextLayout for the line starting at iLineOffset. You must not call this function from within an ATSUDirectLayoutOperationOverrideProcPtrcallback function. 

You should only release the data pointer by calling the function ATSUDirectReleaseLayoutDataArrayPtr. When you call this function, it signals ATSUI that you are done with the data and that ATSUI can merge your modifications with the font’s data. If you do not properly free the data by calling the function ATSUDirectReleaseLayoutDataArrayPtr, a memory leak may result. 

The data you obtain is a copy of the data ATSUI uses for its layout processes. This means the following: 
Obtaining data through a copy operation takes more time than obtaining the actual data. This function returns in order-n time instead of in a constant time.
Changing any of the data values has no effect on the layout.

Before you use this function, you should consider using the functionATSUDirectGetLayoutDataArrayPtrFromLineRef with the kATSULayoutOperationPostLayoutAdjustment selector.

If you use the function ATSUDirectGetLayoutDataArrayPtrFromTextLayout to obtain the ATSUStyleSettingRef array, the structures referenced by each element of the array are invalid after you call the function ATSUDirectReleaseLayoutDataArrayPtr to release the array. If want to retain one or more of the elements in the ATSUStyleSettingRef array for later use, you must not call the function ATSUDirectReleaseLayoutDataArrayPtr until all operations that use the elements in the ATSUStyleSettingRef in the array are complete. The elements in the ATSUStyleSettingRef array are valid only within the context of the callback from which they were obtained

Many of the requested data arrays are created by ATSUI only when necessary. This means that it's possible for the function ATSUDirectGetLayoutDataArrayPtrFromTextLayout to return a NULL pointer and a count of 0. If this is case and if the function does not return an error, the array doesn't exist. You should interpret this result to mean that all values in the array are 0.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/
OSStatus ATSUDirectGetLayoutDataArrayPtrFromTextLayout(
   ATSUTextLayout           iTextLayout,
   UniCharArrayOffset       iLineOffset,
   ATSUDirectDataSelector   iDataSelector,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
){};

/*ATSUDirectGetLayoutDataArrayPtrFromLineRef

Obtains the glyph data specified by a direct-data selector and for a specific line of text. 

OSStatus ATSUDirectGetLayoutDataArrayPtrFromLineRef(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   Boolean                  iCreate,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
);
Parameters
iLineRef

An ATSULineRef value that specifies the line of text whose data you want to obtain. You should pass the same ATSULineRef value passed to the ATSUDirectLayoutOperationOverrideProcPtr callback function from which you are calling this function.
iDataSelector

A direct-data selector constant that specifies the data you want to obtain. You can pass any of the constants described in “Direct Data Selectors”.
iCreate

A Boolean value that specifies whether to create an array if one does not already exist. Pass true if you want an array created. If the line referenced by the iLineRef parameter does not already have an array created that contains the data specified by the iDataSelector parameter, then ATSUI creates a zero-filled array and returns the array in the oLayoutDataArray parameter. The iCreate parameter has no effect for some data specified by the direct-data selector. See “Direct Data Selectors” for details.
oLayoutDataArrayPtr[]

On return, points to an array that contains the data specified by the iDataSelector parameter. The data is for the line of text referenced by the iLineRef parameter. If an array for the specified data does not exist, and if the iCreate is set to false, ATSUI returns NULL. If an array for the specified data does not exist, and if the iCreate is set to true, ATSUI creates a zero-filled array. You can pass NULL if you only want to obtain the number of entries in the array returned in the oLayoutDataArray array.
oLayoutDataCount

On return, the number of entries in the array returned in the oLayoutDataArray array.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

The function ATSUDirectGetLayoutDataArrayPtrFromLineRef returns the data pointer specified by the iDataSelector parameter and referenced by the iLineRef parameter. You must call this function from within an ATSUDirectLayoutOperationOverrideProcPtr callback function. You must only release the data pointer by calling the function ATSUDirectReleaseLayoutDataArrayPtr. When you call this function, it signals ATSUI that you are done with the data and that ATSUI can merge your modifications with the font’s data. If you do not properly free the data by calling the function ATSUDirectReleaseLayoutDataArrayPtr, a memory leak may result. 

The data you obtain is the actual data used by ATSUI in its layout process; it is not a copy. This function is very efficient because ATSUI does not need to allocate memory and copy data. Furthermore, because you obtain a pointer to the data that ATSUI uses for its layout, any modifications you make to the data effect the final layout. 

Many of the data arrays you can request are created by ATSUI only when necessary. If you plan to alter the data in an array, make sure you set the iCreate parameter to true. This ensures that the array is created. If an arrays are not created, ATSUI assumes all entries in the array are zero. 

The pointer returned by this function is only valid within the context of the ATSUDirectLayoutOperationOverrideProcPtr callback function. You must not retain it for later use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/

OSStatus ATSUDirectGetLayoutDataArrayPtrFromLineRef(
   ATSULineRef              iLineRef,
   ATSUDirectDataSelector   iDataSelector,
   Boolean                  iCreate,
   void *                   oLayoutDataArrayPtr[],
   ItemCount *              oLayoutDataCount
){};


/*ATSUDirectAddStyleSettingRef

Looks up, and if necessary, adds a style setting to a line of text.

extern OSStatus ATSUDirectAddStyleSettingRef(
   ATSULineRef           iLineRef,
   ATSUStyleSettingRef   iStyleSettingRef,
   UInt16 *              oStyleIndex
);
Parameters
iLineRef

An ATSULineRef value that specifies the line of text to which you want to add a style setting. You should pass the same reference provided as a parameter to your ATSUDirectLayoutOperationOverrideProcPtr callback function.
iStyleSettingRef

An ATSUStyleSettingRef value that specifies the style setting you want ATSUI to look up or add to the text layout object referenced by the line starting at the offset iLineOffset.
oStyleIndex

On return, points to the index of the ATSUStyleSettingRef passed in iStyleSettingRef for the line referenced by iLineRef. If the ATSUStyleSettingRef does not exist in that context, ATSUI adds it and returns the index value.
Return Value

A result code. See “ATSUI Result Codes”. 
Discussion

The function ATSUDirectAddStyleSettingRef checks to see if a line of text has a specified style setting reference associated with it. If the style setting reference is not associated with the line of text, ATSUI adds the style setting reference.

You must call this function from within an ATSUDirectLayoutOperationOverrideProcPtr callback function. You can use the function ATSUDirectAddStyleSettingRef to replace or substitute glyphs. For example, you can check a line of text for a specific character, such as a whitespace character. When your application finds a whitespace character, it can call the function ATSUDirectAddStyleSettingRef to set style attributes that achieve the desired effect. 

Do not call this function if you obtained an ATSUStyleSettingRef array for the line specified by iLineRef and have not yet disposed of the pointer to this array by calling the function ATSUDirectReleaseLayoutDataArrayPtr, as the pointer is not guaranteed to be valid after you call the function ATSUDirectAddStyleSettingRef.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDirectAccess.h*/
OSStatus ATSUDirectAddStyleSettingRef(
   ATSULineRef           iLineRef,
   ATSUStyleSettingRef   iStyleSettingRef,
   UInt16 *              oStyleIndex
){};

