#include <stdio.h>
#include <IOKit/IORegistryEntry.h>



/*init


Standard init method for all IORegistryEntry subclasses. 
public

virtual bool init(
    OSDictionary *dictionary = 0 ); 
Parameters
A
dictionary that will become the registry entry's property table (retaining it), or zero which will cause an empty property table to be created.
Return Value

true on success, or false on a resource failure. 
Discussion 

A registry entry must be initialized with this method before it can be used. A property dictionary may passed and will be retained by this method for use as the registry entry's property table, or an empty one will be created.*/
bool IORegistryEntry::init(
    OSDictionary *dictionary  ){
printf ("init",dictionary);
}; 

/*free


Standard free method for all IORegistryEntry subclasses. 
public

virtual void free(
    void ); 
Discussion 

This method will release any resources of the entry, in particular its property table. Note that the registry entry must always be detached from the registry before free may be called, and subclasses (namely IOService) will have additional protocols for removing registry entries. free should never need be called directly.*/
void IORegistryEntry::  free(
    void ){
printf ("free");
}; 

/*getName


Returns the name assigned to the registry entry as a C string. 
public

virtual const char * getName(
    const IORegistryPlane *plane = 0 ) const; 
Parameters
plane
The plane object, or zero for the global name.
Return Value

A C string name, valid while the entry is retained. 
Discussion 

Entries can be named in a particular plane, or globally. If the entry is named in plane and the plane is specified that name will be returned, otherwise the global name is returned. The global name defaults to the entry's meta class name if it has not been named.*/

 const char *IORegistryEntry:: getName(
    const IORegistryPlane *plane  ) const{
printf ("getName",plane);
}; 

/*setLocation


Sets a location string for the registry entry, in a particular plane, or globally. 
public

virtual void setLocation(
    const OSSymbol *location, 
    const IORegistryPlane *plane = 0 ); 
Parameters
location
A C string location string which will be copied, or an OSSymbol which will be retained.
plane
The plane object, or zero to set the global location string.
Discussion 

Entries can be given a location string in a particular plane, or globally. If the plane is specified the location applies only to that plane, otherwise the global location is set. The location string may be used during path lookups of registry entries, to distinguish between sibling entries with the same name. The default IORegistryEntry parsing of location strings expects a list of hex numbers separated by commas, though subclasses of IORegistryEntry might do their own parsing.*/
 void IORegistryEntry::    setLocation(
    const OSSymbol *location, 
    const IORegistryPlane *plane  ){
printf ("setLocation",location,plane);
};

/*setName(const char *, const IORegistryPlane *)


Sets a name for the registry entry, in a particular plane, or globally. 
public

virtual void setName(
    const char *name, 
    const IORegistryPlane *plane = 0 ); 
Parameters
name
A const C string name which will be copied.
plane
The plane object, or zero to set the global name.
Discussion 

Entries can be named in a particular plane, or globally. If the plane is specified the name applies only to that plane, otherwise the global name is set. The global name defaults to the entry's meta class name if it has not been named*/
void IORegistryEntry::setName(
    const char *name, 
    const IORegistryPlane *plane ){
printf ("setName",*name,plane);
};

/*setName(const OSSymbol *, const IORegistryPlane *)


Sets a name for the registry entry, in a particular plane, or globally. 
public

virtual void setName(
    const OSSymbol *name, 
    const IORegistryPlane *plane = 0 ); 
Parameters
name
An OSSymbol which will be retained.
plane
The plane object, or zero to set the global name.
Discussion 

Entries can be named in a particular plane, or globally. If the plane is specified the name applies only to that plane, otherwise the global name is set. The global name defaults to the entry's meta class name if it has not been named.*/
 void IORegistryEntry::setName(
  const OSSymbol *name,
   const IORegistryPlane *plane ){
printf ("setName",*name,plane);
};

/*setProperty


Synchronized method to construct and add an OSData property to a registry entry's property table. 
public

virtual bool setProperty(
    const char *aKey, 
    void *bytes, 
    unsigned int length); 
Parameters
aKey
The property's name as a C string.
bytes
The property's value as a pointer. OSData will copy this data.
length
The property's size in bytes, for OSData.
Return Value

true on success or false on a resource failure. 
Discussion 

This method will add or replace a property in a registry entry's property table, using the OSDictionary::setObject semantics. This method is synchronized with other IORegistryEntry accesses to the property table. The property is created as an OSData copied from the supplied date and length, set in the property table with the given name, and released.*/
 bool  IORegistryEntry::setProperty(
    const char *aKey, 
    void *bytes, 
    unsigned int length){
printf ("setProperty",*aKey,bytes,length);
}; 



