#include <HIToolbox/HIToolbox.h>


/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (
   ControlRef theControl){
printf ("GetControl32BitValue",theControl);
};


/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (
   ControlRef control){
printf ("GetControlPopupMenuHandle",control);
};

/*SizeControl

Changes the size of a control’s rectangle.

void SizeControl (
   ControlRef theControl,
   SInt16 w,
   SInt16 h
);
Parameters
theControl

A handle to the control you wish to resize. 
w

The new width, in pixels, of the resized control. 
h

The new height, in pixels, of the resized control.
Discussion

The SizeControl function changes the rectangle specified in the contrlRect field of the control structure. The lower-right corner of the rectangle is adjusted so that it has the width and height specified by the w and h parameters the position of the upper-left corner is not changed. If the control is currently visible, it’s first hidden and then redrawn in its new size. The SizeControl function will change the window’s update region. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SizeControl (
   ControlRef theControl,
   SInt16 w,
   SInt16 h
){
printf ("SizeControl",theControl,w,h);
};

/*GetSuperControl

Obtains a handle to an embedder control.

OSErr GetSuperControl (
   ControlRef inControl,
   ControlRef * outParent
);
Parameters
inControl

A handle to an embedded control. For a description of this data type, see “ControlRef”.
outParent

A pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the embedder control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The GetSuperControl function gets a handle to the parent control of the control passed in. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetSuperControl (
   ControlRef inControl,
   ControlRef * outParent){
printf ("GetSuperControl",inControl,*outParent);
};

/*SetControl32BitMinimum

Changes the minimum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMinimum (
   ControlRef theControl,
   SInt32 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

A value specifying the new minimum setting of the control. In general, to avoid unpredictable behavior, do not set the minimum control value higher than the current maximum value. 
Discussion

Your application may use the SetControl32BitMinimum function to set a 32-bit value as the minimum setting for a control.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMinimum (
   ControlRef theControl,
   SInt32 newMinimum
){
printf ("SetControl32BitMinimum",theControl,newMinimum);
};

/*GetBestControlRect

Obtains a control’s optimal size and text placement. 

OSErr GetBestControlRect (
   ControlRef inControl,
   Rect * outRect,
   SInt16 * outBaseLineOffset
);
Parameters
inControl

A handle to the control to be examined. 
outRect

On input, a pointer to an empty rectangle (0, 0, 0, 0). On return, the rectangle is set to the optimal size for the control. If the control doesn’t support getting an optimal size rectangle, the control’s bounding rectangle is passed back. 
outBaseLineOffset

On input, a pointer to a signed 16-bit integer value. On return, the value is set to the offset from the bottom of control to the base of the text (usually a negative value). If the control doesn’t support optimal sizing or has no text, 0 is passed back. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You can call the GetBestControlRect function to automatically position and size controls in accordance with human interface guidelines. This function is particularly helpful in determining the correct placement of control text whose length is not known until run-time. For example, the StandardAlert function uses GetBestControlRect to automatically size and position buttons in a newly created alert box. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetBestControlRect (
   ControlRef inControl,
   Rect * outRect,
   SInt16 * outBaseLineOffset
){
printf ("GetBestControlRect",inControl,*outRect,*outBaseLineOffset);
};

/*GetControlDataHandle

Obtains a handle to control-specific data. (Deprecated. Use custom HIViews instead of custom CDEFs. See HIView Programming Guide.)

Handle GetControlDataHandle (
   ControlRef control
);
Return Value

A handle to control-specific data.
Discussion

The control data handle is for control-specific data used by a control’s implementation. The control data handle is set by calling SetControlDataHandle.

In general, you should not attempt to interpret the contents of this handle if you did not implement the control yourself. For controls that are provided by the operating system, the format of the data handle may change from one release of the operating system to the next.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Handle GetControlDataHandle (
   ControlRef control
){
printf ("GetControlDataHandle",control);
};

/*SendControlMessage

Sends a message to a control definition function. (Deprecated. For custom controls, use a custom HIView instead of a control definition function. See HIView Programming Guide.)

Not recommended

SInt32 SendControlMessage (
   ControlRef inControl,
   SInt16 inMessage,
   void * inParam
);
Parameters
inControl

A handle to the control that is to receive a low-level message. For a description of this data type, see “ControlRef”.
inMessage

A bit field representing the message(s) you wish to send; see ControlDefProcPtr. 
inParam

The message-dependent data passed in the param parameter of the control definition function.
Return Value

Varying data, depending upon the message sent in the inMessage parameter. 
Discussion

Your application does not normally need to call the SendControlMessage function. If you have a special need to call a control definition function directly, call SendControlMessage to access and manipulate the control’s attributes.

Before calling SendControlMessage, you should determine whether the control supports the specific message you wish to send by calling GetControlFeatures and examining the feature bit field returned. If there are no feature bits returned that correspond to the message you wish to send (for messages 0 through 12), you can assume that all system controls support that message. 
Carbon Porting Notes

Don’t send messages to standard system control definitions.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 SendControlMessage (
   ControlRef inControl,
   SInt16 inMessage,
   void * inParam
){
printf ("SendControlMessage",inControl,inMessage,inParam);
};


/*SetControlCommandID

Sets the command ID for a control. 

OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID
);
Parameters
inControl

. For a description of this data type, see 
inCommandID

The command ID that is to be set.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID){
printf ("SetControlCommandID",inControl,inCommandID);
};

/*SetControlID

Sets a control’s ID. 

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID){
printf ("SetControlID",inControl,inID);
};



/*GetControl32BitMinimum

Obtains the minimum setting of a control.

SInt32 GetControl32BitMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The minimum setting of the control. 
Discussion

Your application may use the GetControl32BitMinimum function to obtain a 32-bit value previously set with the function SetControl32BitMinimum.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMinimum (
   ControlRef theControl){
printf ("GetControl32BitValue",theControl);
};

/*NewControlKeyFilterUPP

ControlKeyFilterUPP NewControlKeyFilterUPP (
   ControlKeyFilterProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlKeyFilterUPP NewControlKeyFilterUPP (
   ControlKeyFilterProcPtr userRoutine
){
printf ("NewControlKeyFilterUPP",userRoutine);
};


/*SetControlProperty

Associates data with a control.

OSStatus SetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
control

A handle to the control with which you wish to associate data. For a description of this data type, see “ControlRef”.
propertyCreator

Your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and should not be used. 
propertyTag

A value identifying the data. You define the tag your application uses to identify the data.
propertySize

A value specifying the size of the data. 
propertyData

On input, a pointer to data of any type. Pass a pointer to a buffer containing the data to be associated; this buffer should be at least as large as the value specified in the propertySize parameter.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Your application may use the SetControlProperty function to associate any type of data with a control. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
){
printf ("SetControlProperty",control,propertyCreator,propertyTag,propertySize,propertyData);
};


/*SetControlDragTrackingEnabled

Sets the drag tracking state for a control. 

OSStatus SetControlDragTrackingEnabled (
   ControlRef inControl,
   Boolean inTracks
);
Parameters
inControl

The control for which the drag tracking state is to be set. 
inTracks

A Boolean whose value is true if you want the control to track and receive drags or false if want to disable support for drag and drop.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Call this function to enable a control’s support for drag and drop. If you don’t enable drag and drop support, the control won’t track drags.

Some controls don’t support drag and drop; these controls won’t track or receive drags even if you call this function with the inTracks parameter set to true.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlDragTrackingEnabled (
   ControlRef inControl,
   Boolean inTracks
){
printf ("SetControlDragTrackingEnabled",inControl,inTracks);
};

/*GetControlProperty

Obtains a piece of data that has been previously associated with a control.

OSStatus GetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
control

A handle to the control whose associated data you wish to obtain. 
propertyCreator

Your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The ‘macs' property signature is reserved for the system and should not be used. 
propertyTag

The application-defined code identifying the data.
bufferSize

A value specifying the size of the data to be obtained. If the size of the data is unknown, use the function GetControlPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetControlProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You may use the function GetControlProperty to obtain a copy of data previously set by your application with the function SetControlProperty. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){
printf ("GetControlProperty",control,propertyCreator,propertyTag,bufferSize,*actualSize,propertyBuffer);
};

/*DeactivateControl

Deactivates a control and any latent embedded controls.

OSErr DeactivateControl (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to deactivate. If you pass a window’s root control, DeactivateControl deactivates all controls in that window. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The DeactivateControl function should be called instead of HiliteControl to deactivate a specified control and its latent embedded controls. 

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you activate a latent embedded control whose embedder is deactivated, the embedded control becomes latent until the embedder is activated. However, if you deactivate a latent embedded control, it will not be activated when its embedder is activated.

If a control definition function supports activate events, it will receive a kControlMsgActivate message before redrawing itself in its inactive state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr DeactivateControl (
   ControlRef inControl
){
printf ("DeactivateControl",inControl);
};

/*NewControlActionUPP

Creates a UPP for a control action callback function. 

ControlActionUPP NewControlActionUPP (
   ControlActionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your control action callback function. See ControlActionProcPtr for information about defining this function. 
Return Value

A UPP to your control action callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlActionUPP NewControlActionUPP (
   ControlActionProcPtr userRoutine
){
printf ("NewControlActionUPP",userRoutine);
};

/*SetKeyboardFocus

Sets the current keyboard focus to a specified control part for a window.

OSErr SetKeyboardFocus (
   WindowRef inWindow,
   ControlRef inControl,
   ControlFocusPart inPart
);
Parameters
inWindow

A pointer to the window containing the control that is to receive keyboard focus.
inControl

A handle to the control that is to receive keyboard focus. For a description of this data type, see 
inPart

A part code specifying the part of a control to receive keyboard focus. To clear a control’s keyboard focus, pass kControlFocusNoPart. For a description of this data type, see “ControlFocusPart”
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

A control with keyboard focus receives keyboard events. The Dialog Manager tests to see which control has keyboard focus when a keyboard event is processed and sends the event to that control. If no control has keyboard focus, the keyboard event is discarded. A control retains keyboard focus if it is hidden or deactivated.

Keyboard focus is only available if an embedding hierarchy has been established in the focusable control’s window. The default focusing order is based on the order in which controls are added to the window. For more details on embedding hierarchies, see EmbedControl.

The SetKeyboardFocus function sets the keyboard focus to a specified control part. The control to receive keyboard focus can be deactivated or invisible. This permits you to set the focus for an item in a dialog box before the dialog box is displayed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetKeyboardFocus (
   WindowRef inWindow,
   ControlRef inControl,
   ControlFocusPart inPart
){
printf ("SetKeyboardFocus",inWindow,inControl,inPart);
};




/*IsControlHilited

Indicates whether or not the control is highlighted.

Boolean IsControlHilited (
   ControlRef control
);
Parameters
control

The control that is to be queried. For a description of this data type, see 
Return Value

A Boolean whose value is true if the control is highlighted; otherwise, false.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

Boolean IsControlHilited (
   ControlRef control
){
printf ("IsControlHilited",control);
};


/*GetControlID

Gets the control ID for a control.

OSStatus GetControlID (
   ControlRef inControl,
   ControlID * outID
);
Parameters
inControl

The control to query. For a description of this data type, see “ControlRef”.
outID

A pointer to a value of type ControlID that, on return, contains the control ID of the control specified by inControl.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlID (
   ControlRef inControl,
   ControlID * outID
){
printf ("GetControlID",inControl,*outID);
};

/*DisposeControl

Decrements a control’s reference count and destroys it if the reference count becomes 0.

void DisposeControl (
   ControlRef theControl
);
Parameters
theControl

The control you want to dispose of. For a description of this data type, see “ControlRef”. 
Discussion

The DisposeControl function reduces the control’s reference count and, if the reference count becomes 0, releases the memory occupied by the control structure and any data structures associated with the control. Before destroying the control, DisposeControl removes the control (and any embedded controls it may possess) from the screen and deletes the control from the window’s control list.

To destroy all of the controls from a window you want to keep, use the function KillControls. If an embedding hierarchy is present, passing the root control to the DisposeControl function is the effectively the same as calling KillControls. In that situation, DisposeControl disposes of the controls embedded within a control before disposing of the container control.

You should use DisposeControl when you want to retain the window but remove one of its controls. The Window Manager functions CloseWindow and DisposeWindow automatically remove all controls associated with the window and release the memory the controls occupy. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void DisposeControl (
   ControlRef theControl
){
printf ("DisposeControl",theControl);
};



/*InvokeControlKeyFilterUPP

Invokes a control key filter UPP.

ControlKeyFilterResult InvokeControlKeyFilterUPP (
   ControlRef theControl,
   SInt16 * keyCode,
   SInt16 * charCode,
   EventModifiers * modifiers,
   ControlKeyFilterUPP userUPP
);
Parameters
theControl

The control. For a description of this data type, see “ControlRef”.
keyCode

The key code.
charCode

The character code.
modifiers

Information from the modifiers field of the event structure specifying the state of the modifier keys and the mouse button at the time the event was posted. .
userUPP

The UPP that is to be invoked.
Return Value

For a description of this data type, see “ControlKeyFilterResult”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlKeyFilterResult InvokeControlKeyFilterUPP (
   ControlRef theControl,
   SInt16 * keyCode,
   SInt16 * charCode,
   EventModifiers * modifiers,
   ControlKeyFilterUPP userUPP
){
printf ("InvokeControlKeyFilterUPP",theControl,*keyCode,*charCode,*modifiers,userUPP);
};

/*GetControlVariant

Returns the variation code specified in the control definition function for a particular control. (Deprecated. Use custom HIViews instead of custom CDEFs. See HIView Programming Guide.)

Not recommended

ControlVariant GetControlVariant (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose variation code you wish to determine. 
Return Value

The variation code for the specified control see the control definition IDs in the “Control Manager Constants” section for descriptions of control variation codes. For a description of this data type, see “ControlVariant”.
Discussion

A control definition function can use a variation code to describe variations of the same basic control. For example, all pop-up arrows share the same basic control definition function, which is stored in a resource of type 'CDEF' and has a resource ID of 12. The standard pop-up arrow is large and points to the right; it has a control definition ID of 192. A variation of this is a large, left-pointing arrow, which has a control definition ID of 193. Still another variation, in which the arrow points up, has a control definition ID of 194. 
Carbon Porting Notes

Use only if you are using message-based custom controls (CDEFs).
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlVariant GetControlVariant (
   ControlRef theControl
){
printf ("GetControlVariant",theControl);
};


/*GetControlCommandID

Gets the command ID for a control.

OSStatus GetControlCommandID (
   ControlRef inControl,
   UInt32 * outCommandID
);
Parameters
inControl
outCommandID

A pointer to the command ID.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlCommandID (
   ControlRef inControl,
   UInt32 * outCommandID
){
printf ("GetControlCommandID",inControl,*outCommandID);
};



/*GetControlOwner

Returns the window to which a control is bound.

WindowRef GetControlOwner (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value

The window reference to which the control is bound, or NULL if the control is not bound to a window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
WindowRef GetControlOwner (
   ControlRef control){
printf ("GetControlOwner",control);
};





/*SetControlAction

Sets the action function for a control.

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control whose action function is to be changed. For a description of this data type, see 
actionProc

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of an action function. 
Discussion

The SetControlAction function associates the action function specified by actionProc with the control specified by theControl. If the cursor is in the specified control, the HandleControlClick and TrackControl functions call the specified action function when the user holds down the mouse button. You must provide the action function, and it must define some action to perform repeatedly as long as the user holds down the mouse button. HandleControlUnderClick and TrackControl always highlight and drag the control as appropriate.

SetControlAction should be used to set the application-defined action function for providing live feedback for standard system scroll bar controls.

Note that the action function associated with a control is used by TrackControl only if you set the action function to TrackControl to Pointer(–1). Also, an action function can be specified in the actionProc parameter to TrackControl, so you don’t have to call SetControlAction to change it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc){
printf ("SetControlAction",theControl,actionProc);
};


/*GetRootControl

Obtains a handle to a window’s root control. 

OSErr GetRootControl (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window to be examined.
outControl

Pass a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the root control. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You can call GetRootControl to determine whether or not a root control (and therefore an embedding hierarchy) exists within a specified window. Once you have the root control’s handle, you can pass it to functions such as DisposeControl, ActivateControl,and DeactivateControl to apply specified actions to the entire embedding hierarchy.

Note that the minimum, maximum, and initial settings for a root control are reserved and should not be changed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr GetRootControl (
   WindowRef inWindow,
   ControlRef * outControl
){
printf ("GetRootControl",inWindow,*outControl);
};

/*CopyControlTitleAsCFString

Makes a copy of the control’s title as a Core Foundation string.

OSStatus CopyControlTitleAsCFString (
   ControlRef inControl,
   CFStringRef * outString
);
Parameters
inControl

The control whose title is to be copied. For a description of this data type, see “ControlRef”.
outString

A copy of the control’s title.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus CopyControlTitleAsCFString (
   ControlRef inControl,
   CFStringRef * outString
){
printf ("CopyControlTitleAsCFString",inControl,*outString);
};

/*IdleControls

Performs idle event processing. (Deprecated in Mac OS X v10.4. You should remove all calls to IdleControls because it uses unnecessary processor time. System-supplied controls do not respond to IdleControls in Mac OS X.)

Not recommended

void IdleControls (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to a window containing controls that support idle events.
Discussion

Your application should call the IdleControls function to give idle time to any controls that want the kControlMsgIdle message. IdleControls calls the control with an idle event so the control can do idle-time processing. You should call IdleControls at least once in your event loop. See ControlDefProcPtr for more details on how a control definition function should handle idle processing. 
Special Considerations

Idle events are not recommended. If you have a custom control that needs time to perform tasks (such as animation), use Carbon Event timers instead. See Carbon Event Manager Programming Guide for more details. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Controls.h*/

void IdleControls (
   WindowRef inWindow
){
printf ("IdleControls",inWindow);
};

/*SetControl32BitValue

Changes the current setting of a control and redraws it accordingly.

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

A value specifying the new setting of the control. If the specified value is less than the minimum setting for the control, SetControl32BitValue sets the current setting of the control to its minimum setting. If the specified value is greater than the maximum setting, SetControl32BitValue sets the control to its maximum.
Discussion

Your application may use the SetControl32BitValue function to set a 32-bit value as the current setting for a control.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue){
printf ("SetControl32BitValue",theControl,newValue);
};

/*Draw1Control

Draws a control and any embedded controls that are currently visible in the specified window. 

void Draw1Control (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to draw. For a description of this data type, see “ControlRef”.
Discussion

Although you should generally use the functionUpdateControls to update controls, you can use the DrawOneControl function to update a single control. If an embedding hierarchy exists and the control passed in has embedded controls, DrawOneControl draws the control and embedded controls. If the root control for a window is passed in, the result is the same as if DrawControls was called.

If you are using compositing mode, you generally do not need to call Draw1Control. If you call Draw1Control in compositing mode, keep in mind that it draws the specified control as well as all other controls that intersect the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void Draw1Control (
   ControlRef theControl){
printf ("Draw1Control",theControl);
};



/*GetControlValue

Obtains a control’s current setting. (Deprecated. Use GetControl32BitValue instead.)

Not recommended

SInt16 GetControlValue (
   ControlRef theControl
);
Parameters
theControl

On input, a handle to a control. 
Return Value

The current setting of the control. 
Discussion

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. You can change the setting by calling SetControlValue.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlValue (
   ControlRef theControl){
printf ("GetControlValue",theControl);
};

/*IsValidControlHandle

Reports whether a given handle is a control handle.

Boolean IsValidControlHandle (
   ControlRef theControl
);
Parameters
theControl

A value of type ControlHandle. Pass the handle to be examined. 
Return Value

true if the specified handle is a valid control handle; otherwise, false. 
Discussion

The IsValidControlHandle function confirms whether a given handle is a valid control handle, but it does not check the validity of the data contained in the control itself. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsValidControlHandle (
   ControlRef theControl
){
printf ("IsValidControlHandle",theControl);
};


/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu){
printf ("CountMenuItems",theMenu);
};



/*SetControlMinimum

Changes the minimum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMinimum instead.)

Not recommended

void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

The new minimum setting.
Discussion

The SetControlMinimum function changes the control’s minimum value to the value specified by the newMinimum parameter and redraws its indicator or scroll box to reflect its new range.

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the NewControl function. To obtain a control’s current minimum setting, use the function GetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum){
printf ("SetControlMinimum",theControl,newMinimum);
};

/*SetControlMaximum

Changes the maximum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMaximum instead.)

Not recommended

void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. 
newMaximum

The new maximum setting. 
Discussion

The SetControlMaximum function changes the maximum value of a control to the value specified by the newMaximum parameter and redraws its indicator or scroll box to reflect its new range.

When you set the maximum setting of a scroll bar equal to its minimum setting, the control definition function makes the scroll bar inactive. When you make the maximum setting exceed the minimum, the control definition function makes the scroll bar active again.

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. To determine a control’s current maximum setting, use the function GetControlMaximum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum){
printf ("SetControlMaximum",theControl,newMaximum);
};


/*AdvanceKeyboardFocus

Advances the keyboard focus to the next focusable control in a window.

OSErr AdvanceKeyboardFocus (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to the window for which to advance keyboard focus.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The AdvanceKeyboardFocus function skips over deactivated and hidden controls until it finds the next focusable control in the window. If it does not find a focusable item, it simply returns.

When AdvanceKeyboardFocus is called, the Control Manager calls your control definition function and passes kControlMsgFocus in its message parameter and kControlFocusNextPart in its param parameter. In response to this message, your control definition function should change keyboard focus to its next part, the entire control, or remove keyboard focus from the control, depending upon the circumstances. See ControlDefProcPtr for a discussion of possible responses to this message. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr AdvanceKeyboardFocus (
   WindowRef inWindow
){
printf ("AdvanceKeyboardFocus",inWindow);
};



/*GetKeyboardFocus

Obtains a handle to the control with the current keyboard focus for a specified window.

OSErr GetKeyboardFocus (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window for which to obtain keyboard focus.
outControl

On input, a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the control that currently has keyboard focus. Produces NULL if no control has focus. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The GetKeyboardFocus function returns the handle of the control with current keyboard focus within a specified window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetKeyboardFocus (
   WindowRef inWindow,
   ControlRef * outControl
){
printf ("GetKeyboardFocus",inWindow,*outControl);
};

/*GetControl32BitMaximum

Obtains the maximum setting of a control.

SInt32 GetControl32BitMaximum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose maximum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The maximum setting of the control. 
Discussion

Your application may use the GetControl32BitMaximum function to obtain a 32-bit value previously set with the function SetControl32BitMaximum.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMaximum (
   ControlRef theControl
){
printf ("GetControl32BitMaximum",theControl);
};


/*ClearKeyboardFocus

Removes the keyboard focus for the currently focused control in a window.

OSErr ClearKeyboardFocus (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to the window in which to clear keyboard focus.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

When the ClearKeyboardFocus function is called, the Control Manager calls your control definition function and passes kControlMsgFocus in its message parameter and kControlFocusNoPart in its param parameter. See ControlDefProcPtr for a discussion of possible responses to this message. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr ClearKeyboardFocus (
   WindowRef inWindow
){
printf ("ClearKeyboardFocus",inWindow);
};

/*IsControlVisible

Determines whether a control is visible.

Boolean IsControlVisible (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to be examined. For a description of this data type, see 
Return Value

If true, the control is visible. If false, the control is hidden. 
Discussion

If you want to determine whether a control is visible, call IsControlVisible. Note that this function indicates the actual user visibility; if the control is marked visible, but its owning window or view is hidden, isControlVisible returns false. (In compositing mode, if a window is hidden, its root view is also marked as hidden. Similarly, any subviews of a hidden view are considered hidden.) A control’s latent visibility (its visibility ignoring the visibility of its parents) can be determined by calling the HIView function HIViewIsLatentlyVisible.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsControlVisible (
   ControlRef inControl
){
printf ("IsControlVisible",inControl);
};


/*GetControlData

Obtains control-specific data.

OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize
);
Parameters
inControl

A handle to the control to be examined. 
inPart

The part code of the control part from which data is to be obtained; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. For a description of this data type, see “ControlPartCode”. 
inTagName

A constant representing the control-specific data you wish to obtain see the data tag constants in the “Control Manager Constants” section. 
inBufferSize

The size (in bytes) of the data pointed to by the inBuffer parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inBufferSize parameter. The number of bytes must match the actual data size. 
inBuffer

On input, a pointer to a buffer allocated by your application. On return, the buffer contains a copy of the control-specific data. If you pass NULL on input, it is equivalent to calling GetControlDataSize. The actual size of the control-specific data will be returned in the outActualSize parameter. For variable-length data, the number of bytes must match the actual data size.
outActualSize

On input, a pointer to a Size value. On return, the value is set to the actual size of the data. You can pass NULL if you don’t care about this value. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The GetControlData function will only copy the amount of data specified in the inBufferSize parameter, but will tell you the actual size of the buffer so you will know if the data was truncated. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize){
printf ("GetControlData",inControl,inPart,inTagName,inBufferSize,inBuffer,*outActualSize);
};

/*GetControlKind

Returns the kind of the given control.

OSStatus GetControlKind (
   ControlRef inControl,
   ControlKind * outControlKind
);
Parameters
inControl

The control to query. For a description of this data type, see “ControlRef”.
outControlKind

On successful exit, this will contain the control signature and kind. See ControlDefinitions.h for the kinds of each system control. For a description of this data type, see “ControlKind”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

GetControlKind allows you to query the kind of any control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlKind (
   ControlRef inControl,
   ControlKind * outControlKind
){
printf ("GetControlKind",inControl,*outControlKind);
};


/*ActivateControl

Activates a control and any latent embedded controls.

OSErr ActivateControl (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to activate. If you pass a window’s root control, ActivateControl activates all controls in that window. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The ActivateControl function should be called instead of HiliteControl to activate a specified control and its latent embedded controls.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you activate a latent embedded control whose embedder is deactivated, the embedded control becomes latent until the embedder is activated. However, if you deactivate a latent embedded control, it will not be activated when its embedder is activated.

If a control definition function supports activate events, it will receive a kControlMsgActivate message before redrawing itself in its active state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr ActivateControl (
   ControlRef inControl
){
printf ("ActivateControl",inControl);
};


/*GetControlTitle

Obtains the title of a control. (Deprecated. Use CopyControlTitleAsCFString instead.)

Not recommended

void GetControlTitle (
   ControlRef theControl,
   Str255 title
);
Parameters
theControl

A handle to the control whose title you want to determine. 
title

On input, a pascal string. On output, the title of the control. 
Discussion

The GetControlTitle function produces the title of the specified control, which is stored in the contrlTitle field of the control structure.

When you create a control, you specify an initial title either in the control resource or in the title parameter of the function NewControl. You can change the title by using SetControlTitle. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void GetControlTitle (
   ControlRef theControl,
   Str255 title
){
printf ("GetControlTitle",theControl,title);
};

/*ShowControl

Makes an invisible control, and any latent embedded controls, visible.

void ShowControl (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to make visible. For a description of this data type, see “ControlRef”.
Discussion

If the specified control is invisible, the ShowControl function makes it visible and immediately draws the control within its window without using your window’s standard updating mechanism. Note that the ShowControl function draws the control in its window, but the control can still be completely or partially obscured by overlapping windows or other objects. If the control is already visible, ShowControl has no effect.

When showing groups of controls, the state of an embedded control that is hidden or deactivated is preserved, so that when the embedder control is shown or activated, the embedded control appears in the same state as the embedder. If the specified control has embedded controls, ShowControl makes the embedded controls visible as well.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you call ShowControl on a latent embedded control whose embedder is disabled, the embedded control will remain invisible until its embedder control is enabled.

You can make a control invisible in several ways:
Specifying its invisibility in the control resource. 
Passing a value of false in the visible parameter of NewControl. 
Calling HideControl. 
Calling SetControlVisibility.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void ShowControl (
   ControlRef theControl
){
printf ("ShowControl",theControl);
};


/*AutoEmbedControl

Automatically embeds a control in the smallest appropriate embedder control.

OSErr AutoEmbedControl (
   ControlRef inControl,
   WindowRef inWindow
);
Parameters
inControl

A handle to the control to be embedded. 
inWindow

A pointer to the window in which to embed the control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The Dialog Manager uses AutoEmbedControl to position dialog items in an embedding hierarchy based on both visual containment and the item list resource order. As items are added to a dialog box during creation, controls that already exist in the window will be containers for new controls if they both visually contain the control and have set the kControlSupportsEmbedding feature bit. For this reason, you should place the largest embedder controls at the beginning of the item list resource. As an example, the Dialog Manager would embed radio buttons in a tab control if they visually “fit” inside the tab control, as long as the tab control was already created in a'DITL' resource and established as an embedder control. For more information on embedding hierarchies in dialog and alert boxes, see the function EmbedControl. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr AutoEmbedControl (
   ControlRef inControl,
   WindowRef inWindow
){
printf ("AutoEmbedControl",inControl,inWindow);
};



/*HideControl

Makes a control, and any latent embedded controls, invisible.

void HideControl (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to hide. For a description of this data type, see 
Discussion

The HideControl function makes the specified control invisible. This can be useful, for example, before adjusting a control’s size and location. It also adds the control’s rectangle to the window’s update region, so that anything else that was previously obscured by the control will reappear on the screen. If the control is already invisible, HideControl has no effect.

When hiding groups of controls, the state of an embedded control that is hidden or deactivated is preserved so that when the embedder control is shown or activated, the embedded control appears in the same state as the embedder. If the specified control has embedded controls, HideControl makes the embedded controls invisible as well.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you call HideControl on a latent embedded control, it would not be displayed the next time ShowControl was called on its embedder control.

To make the control visible again, call ShowControl.

You can also call SetControlVisibility to hide or show a control without causing it to redraw.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void HideControl (
   ControlRef theControl
){
printf ("HideControl",theControl);
};

/*IsControlActive

Returns whether a control is active.

Boolean IsControlActive (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to be examined. 
Return Value

A Boolean whose value is true if the control is active; otherwise, false.
Discussion

If you wish to determine whether a control is active, you should call IsControlActive instead of testing the contrlHilite field of the control structure. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsControlActive (
   ControlRef inControl
){
printf ("IsControlActive",inControl);
};

/*GetIndexedSubControl

Obtains a handle to a specified embedded control.

OSErr GetIndexedSubControl (
   ControlRef inControl,
   UInt16 inIndex,
   ControlRef * outSubControl
);
Parameters
inControl

The control from which an embedded control handle is to be obtained. For a description of this data type, see “ControlRef”.
inIndex

A one-based index—an integer between 1 and the value returned in the outNumChildren parameter of CountSubControls—specifying the control you wish to access.
outSubControl

On input, a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the embedded control. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”. If the index passed in is invalid, the paramErr result code is returned.
Discussion

The GetIndexedSubControl function is useful for iterating over the control hierarchy. Also, the value of a radio group control is the index of its currently selected embedded radio button control. So, passing the current value of a radio group control into GetIndexedSubControl will give you a handle to the currently selected radio button control. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetIndexedSubControl (
   ControlRef inControl,
   UInt16 inIndex,
   ControlRef * outSubControl
){
printf ("GetIndexedSubControl",inControl,inIndex,*outSubControl);
};



/*CountSubControls

Obtains the number of embedded controls within a control.

OSErr CountSubControls (
   ControlRef inControl,
   UInt16 * outNumChildren
);
Parameters
inControl

The control whose embedded controls are to be counted. For a description of this data type, see “ControlRef”. 
outNumChildren

On input, a pointer to an unsigned 16-bit integer value. On return, the value is set to the number of embedded subcontrols. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The CountSubControls function is useful for iterating over the control hierarchy. You can use the count produced to determine how many subcontrols there are and then call GetIndexedSubControl to get each. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr CountSubControls (
   ControlRef inControl,
   UInt16 * outNumChildren
){
printf ("CountSubControls",inControl,*outNumChildren);
};

//work

/*GetControlBounds

Gets the bounds of a control.

Rect * GetControlBounds (
   ControlRef control,
   Rect * bounds
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
bounds

On input, a pointer to a QuickDraw rectangle. On output, the rectangle contains the bounds of the control in local coordinates.
Return Value

A pointer to the rectangle passed in the bounds parameter.
Discussion

When called in a composited window, this function returns the view’s frame, which is equivalent to calling HIViewGetFrame.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Rect * GetControlBounds (
   ControlRef control,
   Rect * bounds
){};



/*DisableControl

Disables a control.

OSStatus DisableControl (
   ControlRef inControl
);
Parameters
inControl

The control to disable. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus DisableControl (
   ControlRef inControl
){};



/*SetControlValue

Changes the current setting of a control and redraws it accordingly. (Deprecated. Use SetControl32BitValue instead.)

Not recommended

void SetControlValue (
   ControlRef theControl,
   SInt16 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

The new setting for the control. 
Discussion

For controls whose values the user can set, you can use the SetControlValue function to change the value to the specified value and redraw the control to reflect the new setting. For checkboxes and radio buttons, the value 1 fills the control with the appropriate mark, and 0 removes the mark. For Mac OS 8 checkboxes and radio buttons, 2 represents a mixed state; see “Checkbox Value Constants” and “Radio Button Value Constants”. For scroll bars, SetControlValue redraws the scroll box where appropriate. 

If the specified value is less than the minimum setting for the control, SetControlValue sets the control to its minimum setting; if the value is greater than the maximum setting, SetControlValue sets the control to its maximum.

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. To determine a control’s current setting before changing it in response to a user’s click in that control, use the function GetControlValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlValue (
   ControlRef theControl,
   SInt16 newValue
){};

/*SetAutomaticControlDragTrackingEnabledForWindow

Enables or disables automatic drag tracking for a window. 

OSStatus SetAutomaticControlDragTrackingEnabledForWindow (
   WindowRef inWindow,
   Boolean inTracks
);
Parameters
inWindow
inTracks

A Boolean whose value is true to enable the Control Manager’s automatic drag tracking support or false to disable automatic drag tracking support.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

By default, your application is responsible for installing drag tracking and receive handlers on a given window. The Control Manager, however, has support for automatically tracking and receiving drags over controls that you can enable by calling this function with the inTracks parameter set to true.

The Control Manager automatic drag tracking detects the control the drag is over and calls HandleControlDragTracking and HandleControlDragReceive appropriately. By default, the Control Manager’s automatic drag tracking is disabled.

Earlier versions of system software enabled automatic drag tracking by default, but as of Mac OS X v10.1.3, Mac OS 9.2, and CarbonLib 1.4, you must call this function to enable automatic drag tracking.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetAutomaticControlDragTrackingEnabledForWindow (
   WindowRef inWindow,
   Boolean inTracks
){};



/*SetControlTitleWithCFString

Sets the title for a control to the specified Core Foundation string. 

OSStatus SetControlTitleWithCFString (
   ControlRef inControl,
   CFStringRef inString
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlTitleWithCFString (
   ControlRef inControl,
   CFStringRef inString
){};


/*EnableControl

Enables a control.

OSStatus EnableControl (
   ControlRef inControl
);
Parameters
theControl

The control that is to be enabled. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus EnableControl (
   ControlRef inControl
){};

/*SetControlReference

Changes a control’s current reference value. 

void SetControlReference (
   ControlRef theControl,
   SInt32 data
);
Parameters
theControl

A handle to the control whose reference value you want to change. For a description of this data type, see “ControlRef”.
data

The new reference value for the control.
Discussion

The SetControlReference function sets the control’s reference value to the value you specify in the data parameter.

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. Call GetControlReference to obtain the current value. You can use this value for any purpose.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlReference (
   ControlRef theControl,
   SInt32 data){};



/*GetControlReference

Obtains a control’s current reference value. 

SInt32 GetControlReference (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current reference value you wish to determine. 
Return Value

The current reference value for the specified control. 
Discussion

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. The reference value is stored in the contrlRfCon field of the control structure. You can use this field for any purpose, and you can use the function SetControlReference to change this value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControlReference (
   ControlRef theControl){};



/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum){
//TODO
};


/*SetControlPopupMenuID

Sets the menu ID for a pop-up control

void SetControlPopupMenuID (
   ControlRef control,
   short menuID
);
Parameters
control

The pop-up control.
menuID

The menu ID to set.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlPopupMenuID (
   ControlRef control,
   short menuID
){};




/*SetControlPopupMenuHandle

Sets the menu handle for a pop-up control.

void SetControlPopupMenuHandle (
   ControlRef control,
   MenuRef popupMenu
);
Parameters
control

The pop-up control.
popupMenu

The menu handle to set.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlPopupMenuHandle (
   ControlRef control,
   MenuRef popupMenu
){};


/*ReverseKeyboardFocus

Returns keyboard focus to the prior focusable control in a window.

OSErr ReverseKeyboardFocus (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to the window for which to reverse keyboard focus.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The ReverseKeyboardFocus function reverses the progression of keyboard focus, skipping over deactivated and hidden controls until it finds the previous control to receive keyboard focus in the window.

When ReverseKeyboardFocus is called, the Control Manager calls your control definition function and passes kControlMsgFocus in its message parameter and kControlFocusPrevPart in its param parameter. In response to this message, your control definition function should change keyboard focus to its previous part, the entire control, or remove keyboard focus from the control, depending upon the circumstances. See ControlDefProcPtr for a discussion of possible responses to this message.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr ReverseKeyboardFocus (
   WindowRef inWindow
){};


/*HandleControlSetCursor

Requests that a control set the cursor based on the mouse location.

OSStatus HandleControlSetCursor (
   ControlRef control,
   Point localPoint,
   EventModifiers modifiers,
   Boolean * cursorWasSet
);
Parameters
inControl

.
localPoint

The location of the mouse.
modifiers

Information from the modifiers field of the event structure specifying the state of the modifier keys and the mouse button at the time the event was posted. 
cursorWasSet

Out output, a pointer to a Boolean whose value is true if the cursor was set; otherwise, false.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus HandleControlSetCursor (
   ControlRef control,
   Point localPoint,
   EventModifiers modifiers,
   Boolean * cursorWasSet
){};


/*GetControlHilite

Gets the highlight status of a control.

UInt16 GetControlHilite (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

UInt16 GetControlHilite (
   ControlRef control
){};

/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the “Control Manager Constants” section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the “Control Manager Constants” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData){
//TODO
};




/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl){
//TODO
};


/*MoveControl

Moves a control within its window.

void MoveControl (
   ControlRef theControl,
   SInt16 h,
   SInt16 v
);
Parameters
theControl

A handle to the control you wish to move. For a description of this data type, see 
h

The horizontal coordinate (local to the control’s window) of the new location of the upper-left corner of the control’s rectangle. 
v

The vertical coordinate (local to the control’s window) of the new location of the upper-left corner of the control’s rectangle.
Discussion

The MoveControl function moves the control to the new location specified by the h and v parameters, using them to change the rectangle specified in the contrlRect field of the control structure. When the control is visible, MoveControl first hides it and then redraws it at its new location.

For example, if the user resizes a document window that contains a scroll bar, your application can use MoveControl to move the scroll bar to its new location. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void MoveControl (
   ControlRef theControl,
   SInt16 h,
   SInt16 v
){};

/*HiliteControl

Changes the highlighting of a control.

Not recommended

void HiliteControl (
   ControlRef theControl,
   ControlPartCode hiliteState
);
Parameters
theControl

A handle to the control. For a description of this data type, see “ControlRef”.
hiliteState

A value from 0 to 255 that specifies the highlighting state of the control. The value of 0 signifies an active control with no highlighting. A value from 1 through 253 signifies a part code designating the part of the (active) control to highlight. Values 254 and 255 signify that the control is to be made disabled or inactive, respectively, and drawn accordingly. For a description of part code constants, see “Control Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. 
Discussion

If the Appearance Manager is available, you should call the functions ActivateControl and DeactivateControl instead of HiliteControl to activate or deactivate a control. This is important if the control is in an embedding hierarchy, since calling these functions will ensure that any latent embedded controls will be activated and deactivated correctly.

If the Appearance Manager is not available, then when you need to make a control inactive (such as when its window is not frontmost) or in any other way change the highlighting of a control, you can use the HiliteControl function.

The HiliteControl function calls the control definition function to redraw the control with the highlighting specified in the hiliteState parameter. The HiliteControl function uses the value in this parameter to change the value of the contrlHilite field of the control structure.

Except for scroll bars, which you should hide using HideControl, you should use HiliteControl to make all controls inactive when their windows are not frontmost. The function TrackControl automatically uses the HiliteControl function as appropriate; when you use TrackControl, you don’t need to call HiliteControl. 
Carbon Porting Notes

If you are activating or deactivating a control, you should use ActivateControl or DeactivateControl instead. Otherwise okay to use. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void HiliteControl (
   ControlRef theControl,
   ControlPartCode hiliteState
){};



/*SetControlBounds

Sets the bounds of a control. 

void SetControlBounds (
   ControlRef control,
   const Rect * bounds
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlBounds (
   ControlRef control,
   const Rect * bounds
){};


/*GetControlRegion

Obtains the region corresponding to a given control part.

OSStatus GetControlRegion (
   ControlRef inControl,
   ControlPartCode inPart,
   RgnHandle outRegion
);
Parameters
inControl

A handle to the control containing the part for which a region is to be obtained. For a description of this data type, see 
inPart

A constant identifying the control part for which a region is to obtained; you may specify the kControlStructureMetaPart and kControlContentMetaPart control part codes, as well as the standard control part codes. See “Control Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants” for descriptions of possible values. For a description of this data type, 
outRegion

On input, a value of type RgnHandle. On return, GetControlRegion sets the region to contain the actual dimensions and position of the control part, in local coordinates.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlRegion (
   ControlRef inControl,
   ControlPartCode inPart,
   RgnHandle outRegion
){};

/*FindControlUnderMouse

Obtains the location of a mouse-down event in a control.

ControlRef FindControlUnderMouse (
   Point inWhere,
   WindowRef inWindow,
   ControlPartCode * outPart
);
Parameters
inWhere

A point, specified in coordinates local to the window, where the mouse-down event occurred. Before calling FindControlUnderMouse, use the QuickDraw GlobalToLocal function to convert the point stored in the where field of the event structure (which describes the location of the mouse-down event) to coordinates local to the window.
inWindow

A pointer to the window in which the mouse-down event occurred.
outPart

On input, a pointer to a signed 16-bit integer value. On return, the value is set to the part code of the control part that was selected; see “Control Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. 
Return Value

A handle to the control that was selected. If the mouse-down event did not occur over a control part, FindControlUnderMouse returns NULL. For a description of this data type, see “ControlRef”.
Discussion

You should call the FindControlUnderMouse function instead of FindControl to determine whether a mouse-down event occurred in a control, particularly if an embedding hierarchy is present. FindControlUnderMouse will return a handle to the control even if no part was hit and can determine whether a mouse-down event has occurred even if the control is deactivated, while FindControl does not. 

When a mouse-down event occurs, your application should call FindControlUnderMouse after using the Window Manager function FindWindow to ascertain that a mouse-down event has occurred in the content region of a window containing controls. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlRef FindControlUnderMouse (
   Point inWhere,
   WindowRef inWindow,
   ControlPartCode * outPart
){};



/*GetControlMinimum

Obtains a control’s minimum setting. (Deprecated. Use GetControl32BitMinimum instead.)

Not recommended

SInt16 GetControlMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum value you wish to determine. 
Return Value

The specified control’s minimum setting.
Discussion

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the function NewControl. You can change the minimum setting by using the function SetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt16 GetControlMinimum (
   ControlRef theControl
){};

/*GetControlMaximum

Obtains a control’s maximum setting. (Deprecated. Use GetControl32BitMaximum instead.)

Not recommended

SInt16 GetControlMaximum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose maximum value you wish to determine. For a description of this data type, see “ControlRef”.
Return Value

The specified control’s maximum setting. 
Discussion

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. You can change the maximum setting by using the function SetControlMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlMaximum (
   ControlRef theControl
){};

/*SetControlViewSize

Informs the Control Manager of the size of the content to which a control’s size is proportioned.

void SetControlViewSize (
   ControlRef theControl,
   SInt32 newViewSize
);
Parameters
theControl

A handle to the control whose view size is to be set. For a description of this data type, see “ControlRef”.
newViewSize

A value specifying the size of the content being displayed. This value should be expressed in terms of the same units of measurement as are used for the minimum, maximum, and current settings of the control. 
Discussion

Your application should call the SetControlViewSize function to support proportional scroll boxes. If the user selects the systemwide Appearance preference for proportional scroll boxes and your application doesn’t call SetControlViewSize, it will still have the traditional square scroll boxes.

To support a proportional scroll box, simply pass the size of the view area—in terms of whatever units the scroll bar uses—to SetControlViewSize. The system automatically handles resizing the scroll box, once your application supplies this information. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlViewSize (
   ControlRef theControl,
   SInt32 newViewSize
){};


/*CreateRootControl

Creates the root control for a specified window.

OSErr CreateRootControl (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window in which you wish to create a root control.
outControl

On input, a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the root control. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Establishing an embedding hierarchy can be accomplished in two steps: creating a root control and embedding controls within it.

To embed controls in a window, you must create a root control for that window. The root control is the container for all other window controls. You create the root control in one of two ways—by calling the CreateRootControl function or by setting the appropriate dialog flag. The root control can be retrieved by calling the function GetRootControl.

The CreateRootControl function creates the root control for a window if no other controls are present. If there are any controls in the window prior to calling CreateRootControl, an error is returned and the root control is not created. Note that the minimum, maximum, and initial settings for a root control are reserved and should not be changed. 

The root control is implemented as a user pane control. You can attach any application-defined user pane functions to the root control to perform actions such as hit testing, drawing, handling keyboard focus, erasing to the correct background, and processing idle and keyboard events.

Once you have created a root control, newly created controls will automatically be embedded in the root control when you call NewControl or GetNewControl. You can specify that a specific control be embedded into another by calling EmbedControl.

By acting on an embedder control, you can move, disable, or hide groups of items. For example, you can use a blank user pane control as the embedder control for all items in a particular “page” of a tab control. After creating as many user panes as you have tabs, you can hide one and show the next when a tab is clicked. All the controls embedded in the user pane will be hidden and shown automatically when the user pane is hidden and shown. 

In addition to calling CreateRootControl, you can establish an embedding hierarchy in a dialog box by either setting the feature bit kDialogFlagsUseControlHierarchy in the extended dialog resource or passing it in the inFlags parameter of the Dialog Manager function NewFeaturesDialog. An embedding hierarchy can be created in an alert box by setting the kAlertFlagsUseControlHierarchy bit in the extended alert resource. It is important to note that a preexisting alert or dialog item will become a control if it is in an alert or dialog box that now uses an embedding hierarchy.

The embedding hierarchy enforces drawing order by drawing the embedding control before its embedded controls. Using an embedding hierarchy also enforces orderly hit-testing, since it performs an “inside-out” hit test to determine the most deeply nested control that is hit by the mouse. An embedding hierarchy is also necessary for controls to make use of keyboard focus, the default focusing order for which is a linear progression that uses the order the controls were added to the window. For more details on keyboard focus, see “Handling Keyboard Focus”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr CreateRootControl (
   WindowRef inWindow,
   ControlRef * outControl
){};


/*SetControlFontStyle

Sets the font style for a control.

OSErr SetControlFontStyle (
   ControlRef inControl,
   const ControlFontStyleRec * inStyle
);
Parameters
inControl

A handle to the control whose font style is to be set. For a description of this data type, see “ControlRef”.
inStyle

A pointer to a ControlFontStyleRec structure. If the flags field is cleared, the control uses the system font unless the control variant kControlUsesOwningWindowsFontVariant has been specified (control uses window font). 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The SetControlFontStyle function sets the font style for a given control. To specify the font for controls in a dialog box, it is generally easier to use the dialog font table resource. SetControlFontStyle allows you to override a control’s default font (system or window font, depending upon whether the control variant kControlUsesOwningWindowsFontVariant has been specified). Once you have set a control’s font with this function, you can cause the control to revert to its default font by passing a control font style structure with a cleared flags field in the inStyle parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlFontStyle (
   ControlRef inControl,
   const ControlFontStyleRec * inStyle
){};


/*SetControlVisibility

Sets the visibility of a control, and any embedded controls, and specifies whether it should be drawn.

OSErr SetControlVisibility (
   ControlRef inControl,
   Boolean inIsVisible,
   Boolean inDoDraw
);
Parameters
inControl

A handle to the control whose visibility is to be set. 
inIsVisible

A Boolean value indicating whether the control is visible or invisible. If you set this value to true, the control will be visible. If false, the control will be invisible. If you wish to show a control (and latent embedded subcontrols) but do not want to cause screen drawing, pass true for this parameter and false in the inDoDraw parameter. 
inDoDraw

A Boolean value indicating whether the control should be drawn or erased. If true, the control’s display on the screen should be updated (drawn or erased) based on the value passed in the inIsVisible parameter. If false, the display will not be updated.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You should call the SetControlVisibility function instead of setting the contrlVis field of the control structure to set the visibility of a control and specify whether it will be drawn. If the control has embedded controls, SetControlVisibility allows you to set their visibility and specify whether or not they will be drawn. If you wish to show a control but do not want it to be drawn onscreen, pass true in the inIsVisible parameter and false in the inDoDraw parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
//
OSErr SetControlVisibility (
   ControlRef inControl,
   Boolean inIsVisible,
   Boolean inDoDraw
){};




/*EmbedControl

Embeds one control inside another.

OSErr EmbedControl (
   ControlRef inControl,
   ControlRef inContainer
);
Parameters
inControl

The control that is to be embedded. For a description of this data type, see “ControlRef”.
inContainer

The control in which the control specified by inControl is to be is to embedded. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Establishing an embedding hierarchy can be accomplished in two steps: creating a root control and embedding controls within it. 

To embed controls in a window, you must create a root control for that window. The root control is the container for all other window controls. You create the root control in one of two ways—by calling the CreateRootControl function or by setting the appropriate dialog flag. The root control can be retrieved by calling GetRootControl.

The root control is implemented as a user pane control. You can attach any application-defined user pane functions to the root control to perform actions such as hit testing, drawing, handling keyboard focus, erasing to the correct background, and processing idle and keyboard events.

Once you have created a root control, newly created controls will automatically be embedded in the root control when you call NewControl or GetNewControl. You can specify that a specific control be embedded into another by calling EmbedControl.

Note that an embedding hierarchy must be established before your application calls the EmbedControl function. If the specified control does not support embedding or there is no root control in the owning window, an error is returned. Prior to Mac OS X, if the control you wish to embed is in a different window from the embedder control, an error is returned. On Mac OS X, however, you can use EmbedControl to move a control from one window to another. On Mac OS X v.10.0 and v.10.1, you can move all controls except for the edit text and unicode edit text controls. Support for the edit text controls is available in Mac OS X v.10.2 and later. 

By acting on an embedder control, you can move, disable, or hide groups of items. For example, you can use a blank user pane control as the embedder control for all items in a particular “page” of a tab control. After creating as many user panes as you have tabs, you can hide one and show the next when a tab is clicked. All the controls embedded in the user pane will be hidden and shown automatically when the user pane is hidden and shown. 

In addition to calling CreateRootControl, you can establish an embedding hierarchy in a dialog box by either setting the feature bit kDialogFlagsUseControlHierarchy in the extended dialog resource or passing it in the inFlags parameter of the Dialog Manager function NewFeaturesDialog. An embedding hierarchy can be created in an alert box by setting the kAlertFlagsUseControlHierarchy bit in the extended alert resource. It is important to note that a preexisting alert or dialog item will become a control if it is in an alert or dialog box that now uses an embedding hierarchy.

The embedding hierarchy enforces drawing order by drawing the embedding control before its embedded controls. Using an embedding hierarchy also enforces orderly hit-testing, since it performs an “inside-out” hit test to determine the most deeply nested control that is hit by the mouse. An embedding hierarchy is also necessary for controls to make use of keyboard focus, the default focusing order for which is a linear progression that uses the order the controls were added to the window. For more details on keyboard focus, see “Handling Keyboard Focus”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr EmbedControl (
   ControlRef inControl,
   ControlRef inContainer
){};

/*DrawControls

Draws all controls currently visible in the specified window. 

void DrawControls (
   WindowRef theWindow
);
Parameters
theWindow

A pointer to a window whose controls you want to display.
Discussion

Because the UpdateControls function redraws only those controls that need updating, your application should generally use it instead of DrawControls when you receive an update event for a window that contains controls. You should typically call either DrawControls or UpdateControls after calling the Window Manager function BeginUpdate and before calling EndUpdate.

While the Dialog Manager automatically draws and updates controls in alert boxes and dialog boxes, Window Manager functions such as SelectWindow, ShowWindow, and BringToFront do not automatically update the window’s controls.

When the Appearance Manager is not available, the DrawControls function draws all controls currently visible in the specified window in reverse order of creation; thus, in case of overlapping controls, the control created first appears frontmost in the window. If you only wish to draw controls in need of update, call UpdateControls instead.

Note that DrawControls generally should not be called if you are using compositing mode.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void DrawControls (
   WindowRef theWindow
){};


/*HandleControlClick

Responds to cursor movements in a control while the mouse button is down and returns the location of the next mouse-up event.

ControlPartCode HandleControlClick (
   ControlRef inControl,
   Point inWhere,
   EventModifiers inModifiers,
   ControlActionUPP inAction
);
Parameters
inControl

A handle to the control in which the mouse-down event occurred. Pass the control handle returned by FindControl or FindControlUnderMouse. 
inWhere

A point, specified in local coordinates, where the mouse-down event occurred. Supply the same point you passed to FindControl or FindControlUnderMouse. 
inModifiers

Information from the modifiers field of the event structure specifying the state of the modifier keys and the mouse button at the time the event was posted. 
inAction

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of such an action function. The value of the inAction parameter can be a valid procPtr, NULL, or -1. A value of -1 indicates that the control should either perform auto tracking, or if it is incapable of doing so, do nothing (like NULL). For custom controls, what you pass in this parameter depends on how you define the control. If the part index is greater than 128, the pointer must be of type DragGrayRegionUPP unless the control supports live feedback, in which case it should be a ControlActionUPP. 
Return Value

Returns a value of type ControlPartCode identifying the control’s part see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. For a description of this data type, see “ControlPartCode”.
Discussion

Call the HandleControlClick function after a call to FindControl or FindControlUnderMouse. The HandleControlClick function should be called instead of TrackControl to follow the user’s cursor movements in a control and provide visual feedback until the user releases the mouse button. Unlike TrackControl, HandleControlClick allows modifier keys to be passed in so that the control may use these if the control (such as a list box or editable text field) is set up to handle its own tracking.

The visual feedback given by HandleControlClick depends on the control part in which the mouse-down event occurs. When highlighting is appropriate, for example, HandleControlClick highlights the control part (and removes the highlighting when the user releases the mouse button). When the user holds down the mouse button while the cursor is in an indicator (such as the scroll box of a scroll bar) and moves the mouse, HandleControlClick responds by dragging a dotted outline or a ghost image of the indicator. If the user releases the mouse button when the cursor is in an indicator such as the scroll box, HandleControlClick calls the control definition function to reposition the indicator. 

While the user holds down the mouse button with the cursor in one of the standard controls, HandleControlClick performs the following actions, depending on the value you pass in the parameter inAction.
If you pass NULL in the inAction parameter, HandleControlClick uses no action function and therefore performs no additional actions beyond highlighting the control or dragging the indicator. This is appropriate for push buttons, checkboxes, radio buttons, and the scroll box of a scroll bar.
If you pass a pointer to an action function in the inAction parameter, it must define some action that your application repeats as long as the user holds down the mouse button. This is appropriate for the scroll arrows and gray areas of a scroll bar. 
If you pass (ControlActionUPP)-1L in the inAction parameter, HandleControlClick calls the control action function associated with the control. This is appropriate when you are tracking the cursor in a pop-up menu. You can call GetControlAction to get a pointer to the control action function that is associated with the control, and you can call SetControlAction to set the control action function that is associated with the control.

For 'CDEF' resources that implement custom dragging, you usually call HandleControlClick, which returns 0 regardless of the user’s changes of the control setting. To avoid this, you should use another method to determine whether the user has changed the control setting, for instance, comparing the control’s value before and after your call to HandleControlClick.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h.*/
ControlPartCode HandleControlClick (
   ControlRef inControl,
   Point inWhere,
   EventModifiers inModifiers,
   ControlActionUPP inAction
){};

/*SetControlTitle

Changes the title of a control and redraws the control accordingly. (Deprecated. Use SetControlTitleWithCFString instead.)

Not recommended

void SetControlTitle (
   ControlRef theControl,
   ConstStr255Param title
);
Parameters
theControl

A handle to a control, the title of which you want to change. 
title

The new title for the control. 
Discussion

The SetControlTitle function changes the contrlTitle field of the control structure to the given string and redraws the control, using the system font for the control title.

The Control Manager allows multiple lines of text in the titles of buttons, checkboxes, and radio buttons. When specifying a multiple-line title, separate the lines with the ASCII character code 0x0D (carriage return). If the control is a button, each line is horizontally centered, and the font leading is inserted between lines. (The height of each line is equal to the distance from the ascent line to the descent line plus the leading of the font used. Be sure to make the total height of the rectangle greater than the number of lines times this height.) If the control is a checkbox or a radio button, the text is justified as appropriate for the user’s current script system, and the checkbox or button is vertically centered within its rectangle.

When you create a control, you specify an initial title either in the control resource or in the title parameter of the function NewControl. To determine a control’s current title, use the function GetControlTitle. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlTitle (
   ControlRef theControl,
   ConstStr255Param title
){};

/*GetNewControl

Creates a control from a control resource.

ControlRef GetNewControl (
   SInt16 resourceID,
   WindowRef owningWindow
);
Parameters
resourceID

The resource ID of the control you wish to create. 
owningWindow

A pointer to the window in which to place the control.
Return Value

A handle to the control created from the specified control resource. If GetNewControl can’t read the control resource from the resource file, it returns NULL. For a description of this data type, see “ControlRef”.
Discussion

The GetNewControl function creates a control structure from the information in the specified control resource, adds the control structure to the control list for the specified window, and returns as its function result a handle to the control. You use this handle when referring to the control in most other Control Manager functions. After making a copy of the control resource, GetNewControl releases the memory occupied by the original control resource before returning.

The control resource specifies the rectangle for the control, its initial setting, its visibility state, its maximum and minimum settings, its control definition ID, a reference value, and its title (if any). After you use GetNewControl to create the control, you can change the control characteristics with other Control Manager functions.

If the control resource specifies that the control should be visible, the Control Manager draws the control. If the control resource specifies that the control should initially be invisible, you can use the function ShowControl to make the control visible.

When an embedding hierarchy is established within a window, GetNewControl automatically embeds the newly created control in the root control of the owning window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlRef GetNewControl (
   SInt16 resourceID,
   WindowRef owningWindow
){};

/*FindControl

Obtains the location of a mouse-down event in a control.

ControlPartCode FindControl (
   Point testPoint,
   WindowRef theWindow,
   ControlRef * theControl
);
Parameters
testPoint

A point, specified in coordinates local to the window, where the mouse-down event occurred. Before calling FindControl, use the GlobalToLocal function to convert the point stored in the where field of the event structure (which describes the location of the mouse-down event) to coordinates local to the window. 
theWindow

A pointer to the window in which the mouse-down event occurred. Pass the window pointer returned by the FindWindow function.
theControl

A pointer to a control handle. On output, FindControl returns a handle to the control in which the mouse-down event occurred or NULL if the point was not over a control. For a description of this data type, see “ControlRef”.
Return Value

The control part code of the control in which the mouse-down event occurred; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. For a description of this data type, see “ControlPartCode”.
Discussion

The FindControl function is not recommended when the Appearance Manager is available. When the Appearance Manager is available, you should call FindControlUnderMouse to determine the location of a mouse-down event in a control. FindControlUnderMouse will return a handle to the control even if no part was hit and can determine whether a mouse-down event has occurred even if the control is deactivated, while FindControl does not.

If the Appearance Manager is not available, then, when a mouse-down event occurs, your application can call FindControl after using the Window Manager function FindWindow to ascertain that a mouse-down event has occurred in the content region of a window containing controls.

When the user presses the mouse button while the cursor is in a visible, active control, FindControl returns as its function result a part code identifying the control’s part the function also returns a handle to the control in the parameter theControl.

If the mouse-down event occurs in an invisible or inactive control, or if it occurs outside a control, FindControl sets the value referenced through theControl to NULL and returns 0 as its function result.

The FindControl function also returns NULL in the value referenced through the parameter theControl and 0 as its function result if the window is invisible or if it doesn’t contain the given point. (However, FindWindow won’t return a window pointer to an invisible window or to one that doesn’t contain the point where the mouse-down event occurred. As long as you call FindWindow before FindControl, this situation won’t arise.)

After using FindControl to determine that a mouse-down event has occurred in a control, you typically call the function TrackControl to follow and respond to the cursor movements in that control, and then to determine in which part of the control the mouse-up event occurs.

The pop-up control definition function does not define part codes for pop-up menus. Instead, your application should store the handles for your pop-up menus when you create them. Your application should then test the handles you store against the handles returned by FindControl before responding to users’ choices in pop-up menus.

The Dialog Manager automatically calls FindControl and TrackControl for mouse-down events inside controls of alert boxes and dialog boxes. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlPartCode FindControl (
   Point testPoint,
   WindowRef theWindow,
   ControlRef * theControl
){};



/*UpdateControls

Draws controls in the specified update region of a window. 

void UpdateControls (
   WindowRef inWindow,
   RgnHandle inUpdateRegion
);
Parameters
theWindow

On input, a pointer to the window containing the controls to update.
updateRegion

On input, a handle to the update region of the specified window.
Discussion

The UpdateControls function, which should not be called in a compositing window, draws only those controls in the specified window that need updating. This function is faster than the DrawControls function, which draws all of the controls in a window. By contrast, UpdateControls draws only those controls in the update region.

Your application should call UpdateControls upon receiving an update event for a window that contains controls. While the Dialog Manager handles update events for controls in alert boxes and dialog boxes, Window Manager functions such as SelectWindow, ShowWindow, and BringToFront do not automatically call UpdateControls to display the window’s controls. 

In response to an update event, you normally call UpdateControls after using the Window Manager function BeginUpdate and before using the Window Manager function EndUpdate. You should set the updateRegion parameter to the visible region of the window’s port, as specified in the port’s visRgn field. Note that if your application draws parts of a control outside of its rectangle, UpdateControls might not redraw it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void UpdateControls (
   WindowRef inWindow,
   RgnHandle inUpdateRegion
){};

/*TrackControl

Responds to cursor movements in a control while the mouse button is down. (Deprecated. Use HandleControlClick instead.)

Not recommended

ControlPartCode TrackControl (
   ControlRef theControl,
   Point startPoint,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control in which a mouse-down event occurred. For a description of this data type, see “ControlRef”.
startPoint

A point, specified in coordinates local to the window, where the mouse-down event occurred. 
actionProc

A pointer to an action function defining the action your application takes while the user holds down the mouse button. The value of the actionProc parameter can be a valid procPtr, NULL, or -1. A value of -1 indicates that the control should either perform auto tracking, or if it is incapable of doing so, do nothing (like NULL). See ControlActionProcPtr for information about an action function to specify in this parameter.
Return Value

If the user releases the mouse button while the cursor is inside a control part, TrackControl returns a value of type ControlPartCodeidentifying the control part in which the mouse-up event occurs; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. TrackControl returns 0 if the user releases the mouse button while the cursor is outside the control part. If the user releases the mouse button when the cursor is in an indicator such as a scroll box, TrackControl calls the control’s control definition function to reposition the indicator. For a description of this data type, see “ControlPartCode”.
Discussion

When the Appearance Manager is available, you should typically call HandleControlClick instead of TrackControl to follow the user’s cursor movements in a control and provide visual feedback until the user releases the mouse button. Unlike the TrackControl function, HandleControlClick also accepts modifier key information so that the control may take into account the current modifier key state if the control is set up to handle its own tracking.

If the Appearance Manager is not available, you can use the TrackControl function to follow the user’s cursor movements in a control and provide visual feedback until the user releases the mouse button. The visual feedback given by TrackControl depends on the control part in which the mouse-down event occurs. When highlighting is appropriate, for example, TrackControl highlights the control part (and removes the highlighting when the user releases the mouse button). When the user holds down the mouse button while the cursor is in an indicator (such as the scroll box of a scroll bar) and moves the mouse, TrackControl responds by dragging a dotted outline of the indicator. 

While the user holds down the mouse button with the cursor in one of the standard controls, TrackControl performs the following actions, depending on the value you pass in the parameter actionProc. (For other controls, what you pass in this parameter depends on how you define the control.)
If you pass NULL in the actionProc parameter, TrackControl uses no action function and therefore performs no additional actions beyond highlighting the control or dragging the indicator. This is appropriate for buttons, checkboxes, radio buttons, and the scroll box of a scroll bar. 
If you pass a pointer to an action function in the actionProc parameter, you must provide the function, and it must define some action that your application repeats as long as the user holds down the mouse button. This is appropriate for the scroll arrows and gray areas of a scroll bar. 
If you pass Pointer(–1) in the actionProc parameter, TrackControl looks in the contrlAction field of the control structure for a pointer to the control’s action function. This is appropriate when you are tracking the cursor in a pop-up menu. (You can use the GetControlAction function to determine the value of this field, and you can use the SetControlAction function to change this value.) If the contrlAction field of the control structure contains a function pointer, TrackControl uses the action function it points to; if the field of the control structure also contains the value Pointer(–1), TrackControl calls the control’s control definition function to perform the necessary action you may wish to do this if you define your own control definition function for a custom control. If the field of the control structure contains the value NULL, TrackControl performs no action. 

Note that when you need to handle events in alert and dialog boxes, Dialog Manager functions automatically call FindControl and TrackControl. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlPartCode TrackControl (
   ControlRef theControl,
   Point startPoint,
   ControlActionUPP actionProc
){};

/*GetControlFeatures

Obtains the features a control supports. 

Not recommended

OSErr GetControlFeatures (
   ControlRef inControl,
   UInt32 * outFeatures
);
Parameters
inControl

A handle to the control to be examined. For a description of this data type, see “ControlRef”.
outFeatures

On input, a pointer to an unsigned 32-bit integer value. On return, the value contains a bit field specifying the features the control supports. For a list of the features a control may support, see ControlDefProcPtr. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errMsgNotSupported indicates that the control does not support Appearance-compliant features.
Discussion

The GetControlFeatures function obtains the Appearance-compliant features a control definition function supports, in response to a kControlMsgGetFeatures message. 
Carbon Porting Notes

Some feature bits may not be relevant when using Carbon event-based messages.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr GetControlFeatures (
   ControlRef inControl,
   UInt32 * outFeatures
){};


/*NewControl

Creates a control based on parameter data. (Deprecated. Use the specific control creation function instead (for example, CreateCheckBoxControl).)

Not recommended

ControlRef NewControl (
   WindowRef owningWindow,
   const Rect * boundsRect,
   ConstStr255Param controlTitle,
   Boolean initiallyVisible,
   SInt16 initialValue,
   SInt16 minimumValue,
   SInt16 maximumValue,
   SInt16 procID,
   SInt32 controlReference
);
Parameters
owningWindow

A pointer to the window in which you want to place the control. All coordinates pertaining to the control are interpreted in this window’s local coordinate system.
boundsRect

A pointer to a rectangle, specified in the given window’s local coordinates, that encloses the control and thus determines its size and location. When specifying this rectangle, you should follow the guidelines presented in “Dialog Box Layout”, in Mac OS 8 Human Interface Guidelines, for control placement and alignment. 
controlTitle

The title string, used for push buttons, checkboxes, radio buttons, and pop-up menus. When specifying a multiple-line title, separate the lines with the ASCII character code 0x0D (carriage return). For controls that don’t use titles, pass an empty string. 
initiallyVisible

A Boolean value specifying the visible/invisible state for the control. If you pass true in this parameter, NewControl draws the control immediately, without using your window’s standard updating mechanism. If you pass false, you must later use ShowControl to display the control. 
initialValue

The initial setting for the control. For sliders and scrollbars, pass the appropriate integer value. For checkboxes and radio buttons, pass the constant indicating the current setting (as defined in “Checkbox Value Constants” and “Radio Button Value Constants”. For plain buttons that do not retain a setting, pass 0. 
minimumValue

The minimum setting for the control. For sliders and scrollbars, pass the appropriate minimum integer value. For checkboxes and radio buttons, pass 0 (or the equivalent constant from “Checkbox Value Constants” or “Radio Button Value Constants”). For plain buttons that do not retain a setting, pass 0. 
maximumValue

The maximum setting for the control. For sliders and scrollbars, pass the appropriate maximum integer value. For scroll bars, if the maximum value is equal to the minimum value, the control definition function automatically disables the scroll bar. For checkboxes and radio buttons, pass 1 (or the equivalent constant defined in “Checkbox Value Constants” or “Radio Button Value Constants”). For plain buttons that do not retain a setting, pass 0. 
procID

The control definition ID. If the control definition function isn’t in memory, it is read in. On Mac OS X, if you do not pass a valid procID (that is, if it does not correspond to a CDEF resource), NewControl will not create a control and will simply return NULL. On Mac OS 9 and earlier, passing an invalid procID will cause NewControl to create a pushbutton control.
controlReference

The control’s reference value, which is set and used only by your application. 
Return Value

A handle to the control described in its parameters. If NewControl runs out of memory or fails, it returns NULL. For a description of this data type, see “ControlRef”.
Discussion

The NewControl function creates a control structure from the information you specify in its parameters, adds the control structure to the control list for the specified window, and returns as its function result a handle to the control. You use this handle when referring to the control in most other Control Manager functions. Generally, you should use the function GetNewControl instead of NewControl, because GetNewControl is a resource-based control-creation function that allows you to localize your application without recompiling. 

When an embedding hierarchy is established within a window, NewControl automatically embeds the newly created control in the root control of the owning window. 
Carbon Porting Notes

Carbon does not support custom control definitions stored in'CDEF' resources. If you want to specify a custom control definition for NewControl, you must compile your definition function directly in your application and then register the function by calling RegisterControlDefinition. When NewControl gets a procID value that doesn’t recognize, it checks a special mapping table to find the pointer that is registered for the resource ID embedded in the procID parameter. It then calls that function to implement your control. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

ControlRef NewControl (
   WindowRef owningWindow,
   const Rect * boundsRect,
   ConstStr255Param controlTitle,
   Boolean initiallyVisible,
   SInt16 initialValue,
   SInt16 minimumValue,
   SInt16 maximumValue,
   SInt16 procID,
   SInt32 controlReference
){};


/*IsControlEnabled

Indicates whether a control is enabled. 

Boolean IsControlEnabled (
   ControlRef inControl
);
Parameters
inControl

The control that is to be queried. For a description of this data type, see 
Return Value

A Boolean whose value is true if the control is enabled; otherwise, false.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsControlEnabled (
   ControlRef inControl
){};

/*TestControl

Obtains the control part in which a mouse-down event occurred.

ControlPartCode TestControl (
   ControlRef theControl,
   Point testPoint
);
Parameters
theControl

A handle to the control in which the mouse-down event occurred. For a description of this data type, see 
testPoint

The point, in a window’s local coordinates, where the mouse-down event occurred. 
Return Value

The part code of the control part, or 0 if the point is outside the control; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and“Control State Part Code Constants”. If the control is invisible or inactive, TestControl returns 0. For a description of this data type, see “ControlPartCode”.
Discussion

The TestControl function is called by the FindControl and TrackControl functions; your application does not normally call it.

When the control specified by the parameter theControl is visible and active, TestControl tests which part of the control contains the point specified by the parameter testPoint. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlPartCode TestControl (
   ControlRef theControl,
   Point testPoint
){
printf ("TestControl",theControl,testPoint);
};


