#include <DirectoryService/DirectoryService.h>

//work

/*dsFindDirNodes

Finds the registered node names that match a pattern.

tDirStatus dsFindDirNodes(
tDirReference inDirReference,
tDataBufferPtr inOutDataBufferPtr,
tDataListPtr inNodeNamePattern,
tDirPatternMatch inPatternMatchType,
unsigned long *outDirNodeCount,
tContextData *inOutContinueData);
Parameters
inDirReference

On input, a value of type tDirReference obtained by calling dsOpenDirService.
inOutDataBufferPtr

On input, a value of type tDataBufferPtr created by calling dsDataBufferAllocate that points to a tDataBuffer structure in which the results are to be returned. On output, call dsGetDirNodeName to extract the results from the data buffer pointed to by inOutDataBufferPtr.
inNodeNamePattern

On input, a value of type tDataListPtr pointing to a tDataList structure containing the pattern that is to be matched. Set this parameter to NULL and inPatternMatchType to the appropriate constant to get the contacts search node (eDSContactsSearchNodeName), network search node (eDSNetworkSearchNodeName), authentication search node (eDSAuthenticationSearchNodeName), the node for the local NetInfo domain (eDSLocalNodeNames), or locally hosted nodes (eDSLocalHostedNodes).
inPatternMatchType

On input, a value of type tDirPatternMatch specifying a pattern type that controls the way in which the pattern specified by inNodeNamePattern is compared with registered node names. See Pattern Matching Constants for possible values.
outDirNodeCount

On output, a pointer to a value of type unsigned long in which this function has stored the number of registered node names in the data buffer pointed to by inOutDataBufferPtr.
inOutContinueData

On input, a pointer to a value of type tContextData and set to NULL. On output, if inOutContinueData points to a value that is NULL, there is no more response data to get. If inOutContinueData points to a value that is not NULL, there is more response data, which you can get by calling this function again and passing the context data pointed to by inOutContinueData. If inOutContinueData points to a value that is not NULL and you do not want to get the remaining response data, you must call dsReleaseContinueData to deallocate the memory associated with inOutContinueData.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function searches the list of nodes that have been registered by Open Directory plug-ins for the directory service represented by inDirReference for names that match a pattern. It places the names that match the pattern in the data buffer pointed to by inOutDataBufferPtr. Use the inNodeNamePattern parameter to specify pattern to match and the inPatternMatchType parameter to specify how the pattern is to be matched or to specify that a search node is to be found.

On output, outDirNodeCount contains the number of matching registered node names that this function has found. Call dsGetDirNodeName to extract the names from the data buffer.

On output, if inOutContinueData points to a value that is not NULL, there are more matching registered node names for this function to find even if outDirNodeCount points to a zero value. To get another buffer of matching registered node names, call this function again and pass to it the context data pointed to by inOutContinueData. If you do not want to get another buffer of matching node names, you must call dsReleaseContinueData to deallocate the context data pointed to by inOutContinueData.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsFindDirNodes(
tDirReference inDirReference,
tDataBufferPtr inOutDataBufferPtr,
tDataListPtr inNodeNamePattern,
tDirPatternMatch inPatternMatchType,
unsigned long *outDirNodeCount,
tContextData *inOutContinueData){};

/*dsReleaseContinueData

Releases memory allocated for continuation data.

tDirStatus dsReleaseContinueData(
tDirReference inDirReference,
tContextData inContinueData);
Parameters
inDirReference

On input, a value of type tDirReference if the inContinueData parameter was generated by, for example, dsGetRecordList, dsGetDirNodeInfo, dsDoAttributeValueSearch, or dsDoAttributeValueSearchWithData. This parameter is a value of type tDirReference if the inContinueData parameter was generated by, for example, dsGetDirNodeList or dsFindDirNodes.
inContinueData

On input, a value of type tContextData that is to be released.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function releases the memory allocated for continuation data. Continuation data is returned when any Open Directory function cannot return all of the requested information in one call, such as dsDoDirNodeAuth, dsFindDirNodes, dsGetDirNodeInfo, dsGetDirNodeList, dsGetRecordList, dsDoAttributeValueSearch, or dsDoAttributeValueSearchWithData.

If your application does not call again the function that returned the continuation data and provide to it the continuation data, your application should call dsReleaseContinueData to free the memory allocated to the continuation data.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsReleaseContinueData(
tDirReference inDirReference,
tContextData inContinueData){};


/*dsGetDirNodeName

Gets node names from a buffer.

tDirStatus dsGetDirNodeName(
tDirReference inDirReference,
tDataBufferPtr inOutDataBuffer,
unsigned long inDirNodeIndex,
tDataListPtr *inOutDataList);
Parameters
inDirReference

On input, a value of type tDirReference obtained by previously calling dsOpenDirService or dsOpenDirServiceProxy.
inOutDataBuffer

On input, a value of type tDataBufferPtr that points to a tDataBuffer structure containing the results of calling dsFindDirNodes or dsGetDirNodeList.
inDirNodeIndex

On input, a value of type unsigned long. Set inDirNodeIndex to 1 to get the first name. Set inDirNodeIndex to 2 to get the second name, and so on.
inOutDataList

On input, a value of type tDataListPtr pointing to a value that is NULL or that can be overwritten. On output, the data list contains the full pathname of the node specified by inDirNodeIndex. You can reuse the data list for other purposes, but when you no longer need the data list, call dsDataListDeallocate to deallocate it. The data list is heap-based, you also need to call free().
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function parses a buffer of node names obtained by calling dsFindDirNodes or dsGetDirNodeList.

The inOutDataBuffer parameter points to the data buffer that contains node names. The inDirNodeIndex parameter specifies which node name to get, and the inOutDataList parameter specifies the address of the application-defined tDataList structure in which this function is to place the node name.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsGetDirNodeName(
tDirReference inDirReference,
tDataBufferPtr inOutDataBuffer,
unsigned long inDirNodeIndex,
tDataListPtr *inOutDataList){};

/*dsBuildListFromStrings

Builds a data list from strings.

tDataListPtr dsBuildListFromStrings(
tDirReference inDirReference,
char *in1stCString,
...);
Parameters
inDirReference

On input, a value of type tDirReference obtained by calling dsOpenDirService or dsOpenDirServiceProxy representing the Open Directory session for which the data list is being built, or zero.
in1stCString

On input, a pointer to a null-terminated string containing data in UTF-8 format that is to be added to the data list. The in1stCString parameter may be followed by one or more parameters of type char *, each pointing to a C string containing data in UTF-8 format that is to be added to the data list.
function result

A value of type tDataListPtr that points to the tDataList structure that has been created.
Discussion

This utility function uses one or more null-terminated strings to build a data list and returns a pointer to it.

When you no longer need the data list, call dsDataListDeallocate t o release the memory associated with it. If the data list is a heap-based data list, you also need to call free().
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDataListPtr dsBuildListFromStrings(
tDirReference inDirReference,
char *in1stCString,
...){};


/*dsCloseDirService

Closes an Open Directory session.

tDirStatus dsCloseDirService(tDirReference inDirReference);
Parameters
inDirReference

A value of type tDirReference obtained by previously calling dsOpenDirService or dsOpenDirServiceProxy that identifies the Open Directory session that is to be closed.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function closes the Open Directory session represented by inDirReference. Continuation data and child references, such as node, record, attribute list, and attribute value list references, that were created using inDirReference become invalid when the session is closed and are released implicitly when this function is called. You must deallocate data lists, data nodes, and data buffers yourself by calling dsDataListDeallocate, dsDataNodeDeAllocate, and dsDataBufferDeAllocate respectively.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsCloseDirService(tDirReference inDirReference){};


/*dsBuildFromPath

Builds a data list from a pathname.

tDataListPtr dsBuildFromPath(
tDirReference inDirReference,
const char *inPathCString,
const char *inPathSeparatorCString);
Parameters
inDirReference

On input, a value of type tDirReference obtained by calling dsOpenDirService or dsOpenDirServiceProxy that represents the Open Directory session for which the data list is to be built, or zero.
inPathCString

On input, a pointer to a null-terminated string containing a pathname in UTF-8 format.
inPathSeparatorCString

On input, a pointer to a null-terminated string containing the character that delimits the components of the pathname pointed to by inPathCString.
function result

A value of type tDataListPtr that points to the new data list.
Discussion

This utility function uses a pathname to build a null-terminated data list and returns a pointer to it. Many Open Directory functions take a pointer to a data list as a parameter. For example, you can pass the resulting data list pointer as a parameter to dsOpenDirNode.

When you no longer need the data list, call dsDataListDeallocate to release the memory associated with it. If the data list is a heap-based data list, you also need to call free().
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDataListPtr dsBuildFromPath(
tDirReference inDirReference,
const char *inPathCString,
const char *inPathSeparatorCString){};

/*dsGetRecordEntry

Gets the next record from a data buffer.

tDirStatus dsGetRecordEntry(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
unsigned long inRecordEntryIndex,
tAttributeListRef *outAttributeListRef,
tRecordEntryPtr *outRecordEntryPtr);
Parameters
inDirNodeReference

On input, a value of type tDirNodeReference, obtained by calling dsOpenDirNode, that identifies the node in which the record specified by inRecordEntryIndex resides.
inOutDataBuffer

On input, a value of type tDataBufferPtr that points to a tDataBuffer structure containing data obtained by previously calling dsGetRecordList, dsDoAttributeValueSearch, dsDoAttributeValueSearchWithData, dsDoMultipleAttributeValueSearch, or dsDoMultipleAttributeValueSearchWithData.
inRecordEntryIndex

On input, a value of type unsigned long that specifies the next record to get. Set inRecordEntryIndex to 1 to get the first record. Set inRecordEntryIndex to 2 to get the second record, and so on.
outAttributeListRef

On input, a pointer to a value of type tAttributeListRef. On output, to get information about the record’s attributes, pass the value pointed to by outAttributeListRef as a parameter when calling dsGetAttributeEntry.
outRecordEntryPtr

On output, outRecordEntryPtr points to a tRecordEntry structure that contains the record entry specified by the inRecordEntryIndex. When you no longer need the record entry structure, call dsDeallocRecordEntry.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function gets the name, type and number of attribute types for a record from the data buffer pointed to by inOutDataBuffer and puts it in the tRecordEntry structure pointed to by outRecordEntryPtr.

This function also returns a pointer to an attribute list reference that can be used to get information about a record’s attributes by calling dsGetAttributeEntry. Calling dsGetAttributeEntry returns an attribute value list reference that can be used to call dsGetAttributeValue to get the value of an attribute.

You should call dsCloseAttributeList when you no longer need the attribute list reference pointed to by outAttributeListRef. You should call dsDeallocRecordEntry when you no longer need the record entry structure pointed to by outRecordEntryPtr.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsGetRecordEntry(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
unsigned long inRecordEntryIndex,
tAttributeListRef *outAttributeListRef,
tRecordEntryPtr *outRecordEntryPtr){};

/*dsGetAttributeEntry

Gets an attribute entry from a data buffer.

tDirStatus dsGetAttributeEntry(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
tAttributeListRef inAttributeListRef,
unsigned long inAttributeInfoIndex,
tAttributeValueListRef *outAttributeValueListRef,
tAttributeEntryPtr *outAttributeInfoPtr);
Parameters
inDirNodeReference

On input, a value of type tDirNodeReference obtained by calling dsOpenDirNode representing the node associated with the data in the buffer pointed to by inOutDataBuffer.
inOutDataBuffer

On input, a value of type tDataBufferPtr pointing to a tDataBuffer structure containing data returned, for example, by a previous call to dsGetDirNodeInfo or dsGetRecordList.
inAttributeListRef

On input, a value of type tAttributeListRef obtained by previously calling dsGetDirNodeInfo or dsGetRecordEntry.
inAttributeInfoIndex

On input, a value of type unsigned long. Set inAttributeInfoIndex to 1 to get the first attribute entry. Set inAttributeInfoIndex to 2 to get the second attribute entry, and so on.
outAttributeValueListRef

On output, a pointer to a value of type tAttributeValueListRef. Pass the pointer to outAttributeValueListRef to dsGetAttributeValue to get the value of the attribute.
outAttributeInfoPtr

On output, a pointer to a value of type tAttributeEntryPtr that points to a tAttributeEntry structure in which this function stores information about the attribute specified by inAttributeInfoIndex. The information includes the number of attribute values, the maximum size of the attribute’s value, and the attribute’s signature.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function uses an attribute list reference to extract an attribute entry from a data buffer previously obtained by calling dsGetDirNodeInfo or dsGetRecordEntry. The function stores the information in the tAttributeEntry structure pointed to by outAttributeInfoPtr.

To get the value(s) of the attribute, call dsGetAttributeValue and pass to it the data buffer pointed to by inOutDataBuffer and the attribute value list reference pointed to by outAttributeValueListRef.

When you no longer need the attribute value list pointed to by outAttributeValueListRef, call dsCloseAttributeValueList.

When you no longer need the outAttributeInfoPtr parameter, call dsDeallocAttributeEntry to deallocate the tAttributeEntry structure and its pointer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsGetAttributeEntry(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
tAttributeListRef inAttributeListRef,
unsigned long inAttributeInfoIndex,
tAttributeValueListRef *outAttributeValueListRef,
tAttributeEntryPtr *outAttributeInfoPtr){};


/*dsOpenDirNode

Opens a session with a node.

tDirStatus dsOpenDirNode(
tDirReference inDirReference,
tDataListPtr inDirNodeName,
tDirNodeReference *outDirNodeReference);
Parameters
inDirReference

On input, a value of type tDirReference obtained by previously calling dsOpenDirService or dsOpenDirServiceProxy.
inDirNodeName

On input, a value of type tDataListPtr that points to a tDataList structure containing the name of the node to open. You can get the name of the node by calling dsGetDirNodeList or by calling, for example, dsBuildListFromStrings to construct the name yourself.
outDirNodeReference

On input, a pointer to a value of type tDirNodeReference. On output, the value pointed to by outDirNodeReference is a node reference that represents the session context for the contents of the opened node. Provide it as a parameter to Open Directory functions that manipulate nodes, such as dsGetDirNodeInfo, dsDoDirNodeAuth, dsGetRecordList, dsGetRecordEntry, dsOpenRecord, and dsGetAttributeEntry.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function opens a session with the node whose name is specified in the tDataList structure pointed to by the inDirNodeName parameter. Opening a session with a node allows you to perform operations on the opened node, such as creating, listing, and deleting records.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsOpenDirNode(
tDirReference inDirReference,
tDataListPtr inDirNodeName,
tDirNodeReference *outDirNodeReference){};

/*dsDataNodeDeAllocate

Deallocates a data node.

tDirStatus dsDataNodeDeAllocate(
tDirReference inDirReference,
tDataNodePtr inDataNodePtr);
Parameters
inDirReference

On input, a value of type tDirReference obtained by calling dsOpenDirService or dsOpenDirServiceProxy, or zero.
inDataNodePtr

On input, a value of type tDataNodePtr that points to the tDataBuffer structure that is to be deallocated.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This utility function deallocates an Open Directory data node that was created by previously calling dsDataNodeAllocateBlock or dsDataNodeAllocateString.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsDataNodeDeAllocate(
tDirReference inDirReference,
tDataNodePtr inDataNodePtr){};

/*dsGetAttributeValue

Gets the value of an attribute from a data buffer.

tDirStatus dsGetAttributeValue(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
unsigned long inAttributeValueIndex,
tAttributeValueListRef inAttributeValueListRef,
tAttributeValueEntryPtr *outAttributeValue);
Parameters
inDirNodeReference

On input, a value of type tDirNodeReference obtained by calling dsOpenDirNode that represents the node for which the search was conducted.
inOutDataBuffer

On input, a value of type tDataBufferPtr pointing to a tDataBuffer structure that was previously filled in, for example, by calling dsDoAttributeValueSearch, dsGetDirNodeInfo, or dsGetRecordList.
inAttributeValueIndex

On input, a value of type unsigned long. Set inAttributeValueIndex to 1 to get the first attribute value. Set inAttributeValueIndex to 2 to get the second attribute value, and so on.
inAttributeValueListRef

On input, a value of type tAttributeValueListRef obtained by calling dsGetAttributeEntry that represents a tAttributeValueEntry structure containing an attribute value ID and the value of the attribute represented by the attribute value ID.
outAttributeValue

On output, a pointer to a value of type tAttributeValueEntryPtr that points to an application-allocated tAttributeValueEntry structure containing the attribute value ID and the value of the attribute.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function obtains the value of an attribute from a data buffer previously filled in, for example, by calling dsDoAttributeValueSearch or dsGetRecordList, and stores the value in a tAttributeValueEntry structure.

When you no longer need the attribute value list pointed to by inAttributeValueListRef, call dsCloseAttributeValueList. When you no longer need outAttributeValue, call dsDeallocAttributeValueEntry.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsGetAttributeValue(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
unsigned long inAttributeValueIndex,
tAttributeValueListRef inAttributeValueListRef,
tAttributeValueEntryPtr *outAttributeValue){};

/*dsDeallocRecordEntry

Deallocates a record entry structure.

tDirStatus dsDeallocRecordEntry(
tDirReference inDirRef,
tRecordEntryPtr inRecEntry);
Parameters
inDirRef

A value of type tDirReference obtained by previously calling dsOpenDirService that identifies the Open Directory session for the record entry structure that is to be deallocated, or zero.
inRecEntry

On input, a value of type tRecordEntryPtr that points to the tRecordEntry structure that is to be deallocated.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This utility function deallocates the specified record entry structure that was allocated by a previous call to dsGetRecordEntry or dsGetRecordReferenceInfo.

You should always deallocate record entry structures when you no longer need them.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsDeallocRecordEntry(
tDirReference inDirRef,
tRecordEntryPtr inRecEntry){};

/*dsDeallocAttributeValueEntry

Deallocates an attribute value entry structure.

tDirStatus dsDeallocAttributeValueEntry(
tDirReference inDirRef,
tAttributeValueEntryPtr inAttrValueEntry);
Parameters
inDirRef

On input, a value of type tDirReference obtained by calling dsOpenDirService representing the Open Directory session associated with the attribute value entry structure that is to be deallocated, or zero.
inAttrValueEntry

On input, a value of type tAttributeValueEntryPtr that points to the tAttributeValueEntry structure that is to be deallocated.
function result

A value of type tDirStatus indicating success or failure.
Discussion

This utility function deallocates an attribute value entry structure that was previously allocated by calling dsGetAttributeValue, dsGetRecordAttributeValueByID, dsGetRecordAttributeValueByIndex, or dsGetRecordAttributeValueByValue.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsDeallocAttributeValueEntry(
tDirReference inDirRef,
tAttributeValueEntryPtr inAttrValueEntry){};


/*dsOpenDirService

Opens an Open Directory session.

tDirStatus dsOpenDirService(
tDirReference *outDirReference);
Parameters
outDirReference

On input, a pointer to a value of type tDirReference. On output, the value pointed to by outDirReference identifies this session and is passed as a parameter to many Open Directory functions.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

When this function returns, use the value pointed to by outDirReference when calling Open Directory functions that require an Open Directory reference as a parameter.

With Mac OS X 10.2, Open Directory starts up when the system starts up and is always running. Prior to Mac OS X 10.2, the DirectoryService daemon was not started until an application called this function for the first time. Applications that run on Mac OS X 10.0 and Mac OS X 10.1 should call dsIsDirServiceRunning to learn whether Open Directory is running. If it’s not running, you can display a progress indicator while Open Directory starts up and then call this function.
Special Considerations

You can establish multiple Open Directory sessions by calling this function multiple times.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsOpenDirService(
tDirReference *outDirReference){};

/*dsCloseAttributeValueList

Disposes of an attribute value list reference.

tDirStatus dsCloseAttributeValueList(
tAttributeValueListRef inAttributeValueListRef);
Parameters
inAttributeValueListRef

On input, a value of type tAttributeValueListRef that was obtained by a previous call to dsGetAttributeEntry.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function disposes of an attribute value list reference that was obtained by a previous call to dsGetAttributeEntry. You should dispose of an attribute value list reference when it is no longer needed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsCloseAttributeValueList(
tAttributeValueListRef inAttributeValueListRef){};


/*dsDataNodeAllocateString

Allocates an Open Directory data node using a string.

tDataNodePtr dsDataNodeAllocateString(
tDirReference inDirReference,
const char *inCString);
Parameters
inDirReference

On input, a value of type tDirReference obtained by calling dsOpenDirService or dsOpenDirServiceProxy representing the Open Directory session for which the data node is to be allocated. The value of this parameter is actually ignored in Mac OS X.
inCString

A pointer to a value of type char that specifies the value the data node is to contain.
function result

A value of type tDataNodePtr that points to the allocated data node and that can be passed as a parameter to Open Directory functions that require such a value as a parameter. If this function cannot allocate the data node, it returns NULL.
Discussion

This utility function uses a C string to allocate an Open Directory data node and returns a pointer to the allocated data node. Use the data node as a convenient way to pass data, such as record names and authentication types, to Open Directory functions.

To release the memory associated with a data node, call dsDataNodeDeAllocate.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDataNodePtr dsDataNodeAllocateString(
tDirReference inDirReference,
const char *inCString){};

/*dsDoDirNodeAuth

Performs authentication with a node.

tDirStatus dsDoDirNodeAuth(
tDirNodeReference inDirNodeReference,
tDataNodePtr inDirNodeAuthName,
dsBool inDirNodeAuthOnlyFlag,
tDataBufferPtr inAuthStepData,
tDataBufferPtr outAuthStepDataResponse,
tContextData *inOutContinueData);
Parameters
inDirNodeReference

On input, a value of type tDirNodeReference obtained by previously calling dsOpenDirNode that representing the node that is to be authenticated.
inDirNodeAuthName

On input, a value of type tDataNodePtr pointing to a tDataNode structure allocated by calling dsDataNodeAllocateBlock or dsDataNodeAllocateString containing the authentication method to use. Authentication methods vary from user to user. Examples include kDSStdAuthSetPasswd, kDSStdAuthSetPasswdAsRoot, and kDSStdAuthChangePasswd to set or change a password and kDSStdAuthNodeNativeNoClearText to authenticate a user. If changes will be made to the node after authentication, the value of the inDirNodeAuthOnlyFlag parameter should be FALSE. For other possible values, see Authentication Constants.
inDirNodeAuthOnlyFlag

On input, a value of type dsBool that indicates whether the result of authentication will be used in the future. A file server that is only authenticating a user should set this parameter to TRUE to indicate that once the user is authenticated, the result will not be used in the future. An application that might make changes to the node after authentication would set this parameter to FALSE to indicate that the result may be used in the future.
inAuthStepData

On input, this parameter contains the data necessary for this step in the authentication process. This parameter is a value of type tDataBufferPtr created by calling dsDataBufferAllocate that points to a tDataBuffer structure.
outAuthStepDataResponse

On output, this parameter contains the plug-in’s response. If the authentication was not successful, the buffer contains a plug-in–defined value. If there are more steps in the authentication process, the buffer contains a plug-in–defined value that is used in the next step of the authentication process. This parameter is a value of type tDataBufferPtr created by calling dsDataBufferAllocate pointing to a tDataBuffer structure.
inOutContinueData

On input, a pointer to a value of type tContextData and set to NULL. On output, if the value pointed to by inOutContinueData is NULL, there are no more steps in the authentication process. If inOutContinueData is not NULL on output, there are more steps to complete. Call this function again and pass to it the value pointed to by inOutContinueData. Call dsReleaseContinueData if the value pointed to by inOutContinueData is not NULL and you do not want to complete the authentication process.
function result

A value of type tDirStatus indicating successful authentication (eDSNoErr) or an error, such as eDSAuthFailed. Other authentication result codes include eDSAuthMethodNotSupported, eDSAuthInBuffFormatError, eDSAuthNoSuchEntity, eDSAuthBadPassword, eDSAuthContinueDataBad, eDSAuthUnknownUser, eDSAuthCannotRecoverPasswd, eDSAuthFailedClearTextOnly, eDSAuthNoAuthServerFound, eDSAuthServerError, eDSAuthNewPasswordRequired, eDSAuthPasswordExpired, eDSAuthPasswordQualityCheckFailed, eDSAuthAccountDisabled, eDSAuthAccountExpired, and eDSAuthAccountInactive. For an explanation of these result codes, see “Result Codes”.
Discussion

This function performs a variety of authentication tasks, such as authenticating a user, setting a password, and changing a password, depending on the value of the inDirNodeAuthName parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsDoDirNodeAuth(
tDirNodeReference inDirNodeReference,
tDataNodePtr inDirNodeAuthName,
dsBool inDirNodeAuthOnlyFlag,
tDataBufferPtr inAuthStepData,
tDataBufferPtr outAuthStepDataResponse,
tContextData *inOutContinueData){};

/*dsCloseDirNode

Closes a session with a node.

tDirStatus dsCloseDirNode(
tDirNodeReference inDirNodeReference);
Parameters
inDirNodeReference

On input, a value of type tDirNodeReference obtained by previously calling dsOpenDirNode or dsOpenDirServiceProxy that identifies the node session that is to be closed.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. such as eDSInvalidReference if the tDirNodeReference is invalid. For a list of other possible result codes, see “Result Codes”.
Discussion

This function closes a session with the node represented by inDirNodeReference.

When the session with the node is closed, inDirNodeReference becomes invalid and cannot be used with any other Open Directory function that takes a node reference as a parameter. Any references that were created with inDirNodeReference as a parameter, such as record references, attribute list references, and attribute value references become invalid when the session represented by inDirNodeReference is closed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/
tDirStatus dsCloseDirNode(
tDirNodeReference inDirNodeReference){};

/*dsCloseAttributeList

Disposes of an attribute list reference.

tDirStatus dsCloseAttributeList(
tAttributeListRef inAttributeListRef);
Parameters
inAttributeListRef

On input, a value of type tAttributeListRef obtained by a previous call to dsGetDirNodeInfo or dsGetRecordEntry.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. For a list of possible result codes, see “Result Codes”.
Discussion

This function disposes of an attribute list reference that was obtained by a previous call to dsGetDirNodeInfo or dsGetRecordList. You should dispose of an attribute list reference when it is no longer needed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsCloseAttributeList(
tAttributeListRef inAttributeListRef){};


/*dsDeallocAttributeEntry

Deallocates an attribute entry structure.

tDirStatus dsDeallocAttributeEntry(
tDirReference inDirRef,
tAttributeEntryPtr inAttrEntry);
Parameters
inDirRef

On input, a value of type tDirReference obtained by calling dsOpenDirService representing the Open Directory session associated with the attribute entry structure that is to be deallocated, or zero.
inAttrEntry

On input, a value of type tAttributeEntryPtr that points to the tAttributeValueEntry structure that is to be deallocated.
function result

A value of type tDirStatus indicating success or failure.
Discussion

This utility function deallocates an attribute entry structure and the pointer to it that were allocated in order to call dsGetAttributeEntry or dsGetRecordAttributeInfo.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsDeallocAttributeEntry(
tDirReference inDirRef,
tAttributeEntryPtr inAttrEntry){};

/*dsGetRecordList

Gets a list of records and puts it in a data buffer.

tDirStatus dsGetRecordList(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
tDataListPtr inRecordNameList,
tDirPatternMatch inPatternMatchType,
tDataListPtr inRecordTypeList,
tDataListPtr inAttributeTypeList,
dsBool inAttributeInfoOnly,
unsigned long *inOutRecordEntryCount,
tContextData *inOutContinueData;
Parameters
inDirNodeReference

On input, a value of type tDirNodeReference obtained by calling dsOpenDirNode.
inOutDataBuffer

On input, a value of type tDataBufferPtr created by calling dsDataBufferAllocate that points to a tDataBuffer structure into which this function is to place the requested list of records. If inOutRecordEntryCount points to a positive value greater than zero when this function returns, parse the records in the buffer pointed to by inOutDataBuffer by calling dsGetRecordEntry.
inRecordNameList

On input, a value of type tDataListPtr specifying the record names to get.
inPatternMatchType

On input, a value of type tDirPatternMatch specifying a pattern type that controls the way in which the pattern specified by inRecordNameList is compared with record names. See Pattern Matching Constants for possible values. The pattern type may also be defined by the Open Directory plug-in that handles the directory service represented by inDirNodeReference. The inPatternMatchType parameter is ignored if inRecordNameList is set to get all records.
inRecordTypeList

On input, a value of type tDataListPtr pointing to an tDataList structure containing the types of records to get. One way to allocate the data list is to call dsDataListAllocate.
inAttributeTypeList

On input, a value of type tDataListPtr pointing to a tDataList structure that contains the attribute types of the records that are to be obtained. If you want all attribute types, create the data list using kDSAttributesAll. To get all standard attribute types, create the data list using kDSAttributesStandardAll. To get all native attribute types, create the data list using kDSAttributesNativeAll.
inAttributeInfoOnly

On input, a value of type dsBool. Set inAttributeInfoOnly to TRUE if you only want attribute type information. To get attribute type information as well as attribute values, set inAttributeInfoOnly to FALSE.
inOutRecordEntryCount

On input, a pointer to a value of type unsigned long that specifies the total number of records to get across what may be multiple calls to this function in order to get the complete list of records, or zero if you want to get all matching records. On output, inOutRecordEntryCount points to the number of records this function has stored in the data buffer pointed to by inOutDataBufferPtr. Once you start a series of dsGetRecordList calls, inOutMatchRecordCount is ignored as an input parameter.
inOutContinueData

On input, a pointer to a value of type tContextData and set to NULL. On output, if the value pointed to by inOutContinueData is NULL, there are no more records to get. On output, if the value pointed to by inOutContinueData is not NULL, fill the data buffer pointed to by inOutDataBuffer with the next records by calling this function again and passing the context data pointed to by inOutContinueData. If you don’t want to get the remaining records, you must call dsReleaseContinueData to deallocate the memory pointed to by inOutContinueData.
function result

A value of type tDirStatus indicating success (eDSNoErr) or an error. An result code of eDSBufferTooSmall occurs if the buffer is too small to fit the first record to be returned. In this case, call this function again after allocating a larger buffer. For a list of other possible result codes, see “Result Codes”.
Discussion

This function stores in the data buffer pointed to by inOutDataBuffer a list of records having the specified data types and values. Call dsGetRecordEntry to parse the records in the buffer.

Set inOutRecordEntryCount to point to a positive integer value that represents the number of records that are to be returned. You cannot change the value pointed to by inOutRecordEntryCount if you call this function with inOutContinueData pointing to context data returned by a previous call to this function.

If there are too many records to fit in the data buffer pointed to by inOutDataBuffer, inOutContinueData points to a non-null value when this function returns. To get more records, call this function again, passing the pointer to the inOutContinueData parameter that was returned by the previous call to this function. To get all records, continue calling this function until inOutContinueData points to a null value.

If the value pointed to by inOutContinueData is not NULL and you do not want to get more records, call dsReleaseContinueData to release the memory associated with inOutContinueData.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServices.h*/

tDirStatus dsGetRecordList(
tDirNodeReference inDirNodeReference,
tDataBufferPtr inOutDataBuffer,
tDataListPtr inRecordNameList,
tDirPatternMatch inPatternMatchType,
tDataListPtr inRecordTypeList,
tDataListPtr inAttributeTypeList,
dsBool inAttributeInfoOnly,
unsigned long *inOutRecordEntryCount,
tContextData *inOutContinueData){};

