#include <CoreMIDI/MIDIServices.h>

/*MIDIPacketNext


Advances a MIDIPacket pointer to the MIDIPacket which immediately follows it in memory if it is part of a MIDIPacketList.
extern MIDIPacket * MIDIPacketNext(
    MIDIPacket *pkt );  
Parameters
pkt
A pointer to a MIDIPacket in a MIDIPacketList. 

Return Value

The subsequent packet in the MIDIPacketList. 

Discussion 

This is implemented as a macro for efficiency and to avoid const problems.*/
MIDIPacket * MIDIPacketNext(
    MIDIPacket *pkt ){
printf ("MIDIPacketNext",*pkt);
}; 

/*MIDIClientCreate


Creates a MIDIClient object.
extern OSStatus MIDIClientCreate(
    CFStringRef name, 
    MIDINotifyProc notifyProc, 
    void *notifyRefCon, 
    MIDIClientRef *outClient );  
Parameters
name
The client's name.
notifyProc
An optional (may be NULL) callback function through which the client will receive notifications of changes to the system.
notifyRefCon
A refCon passed back to notifyRefCon
outClient
On successful return, points to the newly-created MIDIClientRef.
Return Value

An OSStatus result code. 

Discussion 

Note that notifyProc will always be called on the run loop which was current when MIDIClientCreate was first called. 

Availability
Introduced in Mac OS X v10.0.*/
OSStatus MIDIClientCreate(
    CFStringRef name, 
    MIDINotifyProc notifyProc, 
    void *notifyRefCon, 
    MIDIClientRef *outClient ){
printf ("MIDIClientCreate",name,notifyProc,notifyRefCon,*outClient);
};  

/*MIDIObjectGetStringProperty


Gets an object's string-type property.
extern OSStatus MIDIObjectGetStringProperty(
    MIDIObjectRef obj, 
    CFStringRef propertyID, 
    CFStringRef *str );  
Parameters
obj
The object whose property is to be returned.
propertyID
Name of the property to return.
str
On successful return, the value of the property.
Return Value

An OSStatus result code. 

Discussion 

(See the MIDIObjectRef documentation for information about properties.) 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus MIDIObjectGetStringProperty(
    MIDIObjectRef obj, 
    CFStringRef propertyID, 
    CFStringRef *str ){
printf ("MIDIObjectGetStringProperty",obj,propertyID,*str);
}; 


/*kMIDIPropertyName

extern const CFStringRef kMIDIPropertyName;  
Discussion 

device/entity/endpoint property, string 

Devices, entities, and endpoints may all have names. The recommended way to display an endpoint's name is to ask for the endpoint name, and display only that name if it is unique. If it is non-unique, prepend the device name. 

A setup editor may allow the user to set the names of both driver-owned and external devices.*/
const CFStringRef kMIDIPropertyName;  

/*MIDIPacketListInit


Prepares a MIDIPacketList to be built up dynamically.
extern MIDIPacket * MIDIPacketListInit(
    MIDIPacketList *pktlist );  
Parameters
pktlist
The packet list to be initialized. 

Return Value

A pointer to the first MIDIPacket in the packet list. 
Availability
Introduced in Mac OS X v10.0.*/
MIDIPacket * MIDIPacketListInit(
    MIDIPacketList *pktlist ){
printf ("MIDIPacketListInit",*pktlist);
}; 


/*MIDISend


Sends MIDI to a destination.
extern OSStatus MIDISend(
    MIDIPortRef port, 
    MIDIEndpointRef dest, 
    const MIDIPacketList *pktlist );  
Parameters
port
The output port through which the MIDI is to be sent.
dest
The destination to receive the events.
pktlist
The MIDI events to be sent.
Return Value

An OSStatus result code. 

Discussion 

Events with future timestamps are scheduled for future delivery. CoreMIDI performs any needed MIDI merging. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus MIDISend(
    MIDIPortRef port, 
    MIDIEndpointRef dest, 
    const MIDIPacketList *pktlist ){
printf ("MIDISend",port,dest,*pktlist);
};  


/*MIDIPacketListAdd


Adds a MIDI event to a MIDIPacketList.
extern MIDIPacket * MIDIPacketListAdd(
    MIDIPacketList *pktlist, 
    ByteCount listSize, 
    MIDIPacket *curPacket, 
    MIDITimeStamp time, 
    ByteCount nData, 
    const Byte *data);  
Parameters
pktlist
The packet list to which the event is to be added.
listSize
The size, in bytes, of the packet list.
curPacket
A packet pointer returned by a previous call to MIDIPacketListInit or MIDIPacketListAdd for this packet list.
time
The new event's time.
nData
The length of the new event, in bytes.
data
The new event. May be a single MIDI event, or a partial sys-ex event. Running status is not permitted.
Return Value

Returns null if there was not room in the packet for the event; otherwise returns a packet pointer which should be passed as curPacket in a subsequent call to this function. 

Discussion 

The maximum size of a packet list is 65536 bytes. Large sysex messages must be sent in smaller packet lists. 
Availability
Introduced in Mac OS X v10.0.*/
MIDIPacket * MIDIPacketListAdd(
    MIDIPacketList *pktlist, 
    ByteCount listSize, 
    MIDIPacket *curPacket, 
    MIDITimeStamp time, 
    ByteCount nData, 
    const Byte *data){
printf ("MIDIPacketListAdd",*pktlist,listSize,*curPacket,time,nData,*data);
};  

/*MIDIClientDispose


Disposes a MIDIClient object.
extern OSStatus MIDIClientDispose(
    MIDIClientRef client );  
Parameters
client
The client to dispose.
Return Value

An OSStatus result code. 

Discussion 

It is not essential to call this function; the CoreMIDI framework will automatically dispose all MIDIClients when an application terminates. 
Availability
Introduced in Mac OS X v10.0.*/

 OSStatus MIDIClientDispose(
    MIDIClientRef client ){
printf ("MIDIClientDispose",client);
};  


/*MIDIInputPortCreate


Creates an input port through which the client may receive incoming MIDI messages from any MIDI source.
extern OSStatus MIDIInputPortCreate(
    MIDIClientRef client, 
    CFStringRef portName, 
    MIDIReadProc readProc, 
    void *refCon, 
    MIDIPortRef *outPort );  
Parameters
client
The client to own the newly-created port.
portName
The name of the port.
readProc
The MIDIReadProc which will be called with incoming MIDI, from sources connected to this port.
refCon
The refCon passed to readHook.
outPort
On successful return, points to the newly-created MIDIPort.
Return Value

An OSStatus result code. 

Discussion 

After creating a port, use MIDIPortConnectSource to establish an input connection from any number of sources to your port. 

readProc will be called on a separate high-priority thread owned by CoreMIDI. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus MIDIInputPortCreate(
    MIDIClientRef client, 
    CFStringRef portName, 
    MIDIReadProc readProc, 
    void *refCon, 
    MIDIPortRef *outPort ){
printf ("MIDIInputPortCreate",client,portName,readProc,refCon,*outPort);
};  

/*MIDIGetDestination


Returns one of the destinations in the system.
extern MIDIEndpointRef MIDIGetDestination(
    ItemCount destIndex0 );  
Parameters
destIndex0
The index (0...MIDIGetNumberOfDestinations()-1) of the destination to return
Return Value

A reference to a destination, or NULL if an error occurred. 
Availability
Introduced in Mac OS X v10.0.*/
 MIDIEndpointRef MIDIGetDestination(
    ItemCount destIndex0 ){
printf ("MIDIGetDestination",destIndex0);
};  


/*MIDIPortConnectSource


Establishes a connection from a source to a client's input port.
extern OSStatus MIDIPortConnectSource(
    MIDIPortRef port, 
    MIDIEndpointRef source, 
    void *connRefCon );  
Parameters
port
The port to which to create the connection. This port's readProc is called with incoming MIDI from the source.
source
The source from which to create the connection.
connRefCon
This refCon is passed to the MIDIReadProc, as a way to identify the source.
Return Value

An OSStatus result code. 

Availability
Introduced in Mac OS X v10.0.*/
 OSStatus MIDIPortConnectSource(
    MIDIPortRef port, 
    MIDIEndpointRef source, 
    void *connRefCon ){
printf ("MIDIPortConnectSource",port,source,connRefCon);
};  


/*MIDIGetSource


Returns one of the sources in the system.
extern MIDIEndpointRef MIDIGetSource(
    ItemCount sourceIndex0 );  
Parameters
sourceIndex0
The index (0...MIDIGetNumberOfSources()-1) of the source to return
Return Value

A reference to a source, or NULL if an error occurred. 
Availability
Introduced in Mac OS X v10.0.*/
MIDIEndpointRef MIDIGetSource(
    ItemCount sourceIndex0 ){
printf ("MIDIGetSource",sourceIndex0);
};


/*MIDIOutputPortCreate


Creates an output port through which the client may send outgoing MIDI messages to any MIDI destination.
extern OSStatus MIDIOutputPortCreate(
    MIDIClientRef client, 
    CFStringRef portName, 
    MIDIPortRef *outPort );  
Parameters
client
The client to own the newly-created port
portName
The name of the port.
outPort
On successful return, points to the newly-created MIDIPort.
Return Value

An OSStatus result code. 

Discussion 

Output ports provide a mechanism for MIDI merging. CoreMIDI assumes that each output port will be responsible for sending only a single MIDI stream to each destination, although a single port may address all of the destinations in the system. 

Multiple output ports are only necessary when an application is capable of directing multiple simultaneous MIDI streams to the same destination. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus MIDIOutputPortCreate(
    MIDIClientRef client, 
    CFStringRef portName, 
    MIDIPortRef *outPort ){
printf ("MIDIOutputPortCreate",client,portName,*outPort);
}  ;

/*MIDIGetNumberOfSources


Returns the number of sources in the system.
extern ItemCount MIDIGetNumberOfSources();  
Return Value

The number of sources in the system, or 0 if an error occurred. 
Availability
Introduced in Mac OS X v10.0.*/
 ItemCount MIDIGetNumberOfSources(){
printf ("MIDIGetNumberOfSources");
};  

/*MIDIGetNumberOfDestinations


Returns the number of destinations in the system.
extern ItemCount MIDIGetNumberOfDestinations();  
Return Value

The number of destinations in the system, or 0 if an error occurred. 
Availability
Introduced in Mac OS X v10.0.*/
 ItemCount MIDIGetNumberOfDestinations(){
printf ("MIDIGetNumberOfDestinations");
};  

