#include <CoreGraphics/CoreGraphics.h>

//work

/*CGImageRelease

Decrements the retain count of a Quartz image.

void CGImageRelease (
   CGImageRef image
);
Parameters
image

The image to release. 
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
void CGImageRelease (
   CGImageRef image
){};

/*CGImageRetain

Increments the retain count of a Quartz image.

CGImageRef CGImageRetain (
   CGImageRef image
);
Parameters
image

The image to retain. 
Return Value

The same image you passed in as the image parameter.
Discussion

This function is equivalent to CFRetain, except that it does not cause an error if the image parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGImageRef CGImageRetain (
   CGImageRef image
){};

/*CGImageCreate

Creates a Quartz bitmap image.

CGImageRef CGImageCreate (
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bitsPerPixel,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo,
   CGDataProviderRef provider,
   const float decode[],
   int shouldInterpolate,
   CGColorRenderingIntent intent
);
Parameters
width

The width, in pixels, of the required image.
height

The height, in pixels, of the required image
bitsPerComponent

The number of bits for each component in a source pixel. For example, if the source image uses the RGBA-32 format, you would specify 8 bits per component.
bitsPerPixel

The total number of bits in a source pixel. This value must be at least bitsPerComponent times the number of components per pixel.
bytesPerRow

The number of bytes of memory for each horizontal row of the bitmap.
colorspace

The color space for the image. Quartz retains the color space you pass in; on return, you may safely release it.
bitmapInfo

A CGBitmapInfo constant that specifies whether the bitmap should contain an alpha channel and its relative location in a pixel, along with whether the components are floating-point or integer values. 
provider

The source of data for the bitmap. For information about supported data formats, see the discussion below. Quartz retains this object; on return, you may safely release it.
decode

The decode array for the image. If you do not want to allow remapping of the image’s color values, pass NULL for the decode array.
shouldInterpolate

A Boolean value that specifies whether interpolation should occur. The interpolation setting specifies whether Quartz should apply a pixel-smoothing algorithm to the image.
intent

A CGColorRenderingIntent constant that specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context.
Return Value

A new Quartz bitmap image. You are responsible for releasing this object by calling CGImageRelease.
Discussion

The data provider should provide raw data that matches the format specified by the other input parameters. To use encoded data (for example, from a file specified by a URL-based data provider), see CGImageCreateWithJPEGDataProvider and CGImageCreateWithPNGDataProvider. In Mac OS X version 10.3 and later, you can also use the QuickTime function GraphicsImportCreateCGImage to decode an image file in any supported format and create a CGImage, in a single operation.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGImageRef CGImageCreate (
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bitsPerPixel,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo,
   CGDataProviderRef provider,
   const float decode[],
   int shouldInterpolate,
   CGColorRenderingIntent intent
){};

/*CGImageGetWidth

Returns the width of a bitmap image.

size_t CGImageGetWidth (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The width, in pixels, of the specified bitmap image (or image mask).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
size_t CGImageGetWidth (
   CGImageRef image
){};

/*CGImageGetHeight

Returns the height of a bitmap image.

size_t CGImageGetHeight (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The height in pixels of the bitmap image (or image mask).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
size_t CGImageGetHeight (
   CGImageRef image
){};

/*CGImageGetColorSpace

Return the color space for a bitmap image.

CGColorSpaceRef CGImageGetColorSpace (
   CGImageRef image
);
Parameters
image

The image to examine. 
Return Value

The source color space for the specified bitmap image, or NULL if the image is an image mask. You are responsible for retaining and releasing the color space as necessary.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGImage.h*/
CGColorSpaceRef CGImageGetColorSpace (
   CGImageRef image
){};

/*CGImageCreateWithPNGDataProvider

Creates a Quartz bitmap image using PNG-encoded data.

CGImageRef CGImageCreateWithPNGDataProvider (
   CGDataProviderRef source,
   const float decode[],
   bool shouldInterpolate,
   CGColorRenderingIntent intent
);
Parameters
source

A data provider supplying PNG-encoded data.
decode

The decode array for the image. Typically a decode array is unnecessary, and you should pass NULL.
shouldInterpolate

A Boolean value that specifies whether interpolation should occur. The interpolation setting specifies whether Quartz should apply a pixel-smoothing algorithm to the image.
intent

A CGColorRenderingIntent constant that specifies how Quartz should handle colors that are not located within the gamut of the destination color space of a graphics context.
Return Value

A new Quartz bitmap image. You are responsible for releasing this object by calling CGImageRelease.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGImage.h*/

CGImageRef CGImageCreateWithPNGDataProvider (
   CGDataProviderRef source,
   const float decode[],
   bool shouldInterpolate,
   CGColorRenderingIntent intent
){};

/*CGImageCreateCopyWithColorSpace

Create a copy of an image, replacing its colorspace.

CGImageRef CGImageCreateCopyWithColorSpace (
   CGImageRef image,
   CGColorSpaceRef colorspace
);
Parameters
image

The graphics image to copy.
colorspace

The destination color space. The number of components in this color space must be the same as the number in the specified image.
Return Value

A new Quartz image that is a copy of the image passed as the image parameter but with its color space replaced by that specified by the colorspace parameter. Returns NULL if image is an image mask, or if the number of components of colorspace is not the same as the number of components of the colorspace of image. You are responsible for releasing this object using CGImageRelease.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGImage.h*/
CGImageRef CGImageCreateCopyWithColorSpace (
   CGImageRef image,
   CGColorSpaceRef colorspace
){};

/*CGImageCreateWithMask

Creates a new image from an image and a mask.

CGImageRef CGImageCreateWithMask(
   CGImageRef image,
   CGImageRef mask
);
Parameters
image

The image to apply the mask parameter to. This image must not be an image mask and may not have an image mask or masking color associated with it.
mask

A mask. If the mask is an image, it must be in the DeviceGray color space, must not have an alpha component, and may not itself be masked by an image mask or a masking color. If the mask is not the same size as the image specified by the image parameter, then Quartz scales the mask to fit the image.
Return Value

An image created by masking image with mask. You are responsible for releasing this object by calling CGImageRelease.
Discussion

The resulting image depends on whether the mask parameter is an image mask or an image. If the mask parameter is an image mask, then the source samples of the image mask act as an inverse alpha value. That is, if the value of a source sample in the image mask is S, then the corresponding region in image is blended with the destination using an alpha value of (1-S). For example, if S is 1, then the region is not painted, while if S is 0, the region is fully painted.

If the mask parameter is an image, then it serves as an alpha mask for blending the image onto the destination. The source samples of mask' act as an alpha value. If the value of the source sample in mask is S, then the corresponding region in image is blended with the destination with an alpha of S. For example, if S is 0, then the region is not painted, while if S is 1, the region is fully painted.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGImage.h*/

CGImageRef CGImageCreateWithMask(
   CGImageRef image,
   CGImageRef mask
){};


