#include <CoreFoundation/CoreFoundation.h>

/*Predefined Allocators

CFAllocator provides the following predefined allocators. In general, you should use kCFAllocatorDefault unless one of the special circumstances exist below.

const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;
Constants
kCFAllocatorDefault

This is a synonym for NULL. 

Available in Mac OS X v10.0 and later.
extern  const CFAllocatorRef kCFAllocatorDefault;extern  const CFAllocatorRef kCFAllocatorDefault;kCFAllocatorSystemDefault

Default system allocator.

You rarely need to use this.

Available in Mac OS X v10.0 and later.
kCFAllocatorMalloc

This allocator uses malloc(), realloc(), and free(). 

Typically you should not use this allocator, use kCFAllocatorDefault instead. This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory was obtained as a result of malloc type functions.

Available in Mac OS X v10.0 and later.
kCFAllocatorMallocZone

This allocator explicitly uses the default malloc zone, returned by malloc_default_zone().

You should only use this when an object is safe to be allocated in non-scanned memory.

Available in Mac OS X v10.4 and later.
kCFAllocatorNull

This allocator does nothing—it allocates no memory. 

This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory should not be freed.

Available in Mac OS X v10.0 and later.
kCFAllocatorUseContext

Special allocator argument to CFAllocatorCreate—it uses the functions given in the context to allocate the allocator.

Available in Mac OS X v10.0 and later.
Declared In
CFBase.h*/

 const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
 const CFAllocatorRef kCFAllocatorNull;
 const CFAllocatorRef kCFAllocatorUseContext;

//work

/*CFGetTypeID

Returns the unique identifier of an opaque type to which a Core Foundation object belongs.

CFTypeID CFGetTypeID (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A value of type CFTypeID that identifies the opaque type of cf. 
Discussion

This function returns a value that uniquely identifies the opaque type of any Core Foundation object. You can compare this value with the known CFTypeID identifier obtained with a “GetTypeID” function specific to a type, for example CFDateGetTypeID. These values might change from release to release or platform to platform.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeID CFGetTypeID (
   CFTypeRef cf
){};

/*CFRelease

Releases a Core Foundation object.

void CFRelease (
   CFTypeRef cf
);
Parameters
cf

A CFType object to release. This value must not be NULL. 
Discussion

If the retain count of cf becomes zero the memory allocated to the object is deallocated and the object is destroyed. If you create, copy, or explicitly retain (see the CFRetain function) a Core Foundation object, you are responsible for releasing it when you no longer need it (see Memory Management Programming Guide for Core Foundation).
Special Considerations

If cf is NULL, this will cause a runtime error and your application will crash. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFRelease (
   CFTypeRef cf
){};

/*CFRetain

Retains a Core Foundation object.

CFTypeRef CFRetain (
   CFTypeRef cf
);
Parameters
cf

The CFType object to retain. This value must not be NULL
Return Value

The input value, cf. 
Discussion

You should retain a Core Foundation object when you receive it from elsewhere (that is, you did not create or copy it) and you want it to persist. If you retain a Core Foundation object you are responsible for releasing it (see Memory Management Programming Guide for Core Foundation). 
Special Considerations

If cf is NULL, this will cause a runtime error and your application will crash. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeRef CFRetain (
   CFTypeRef cf
){};

/*CFCopyDescription

Returns a textual description of a Core Foundation object.

CFStringRef CFCopyDescription (
   CFTypeRef cf
);
Parameters
cf

The CFType object (a generic reference of type CFTypeRef) from which to derive a description.
Return Value

A string that contains a description of cf. Ownership follows the Create Rule.
Discussion

The nature of the description differs by object. For example, a description of a CFArray object would include descriptions of each of the elements in the collection.

You can use this function for debugging Core Foundation objects in your code. Note, however, that the description for a given object may be different in different releases of the operating system. Do not create dependencies in your code on the content or format of the information returned by this function. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFCopyDescription (
   CFTypeRef cf
){};

/*CFRangeMake

Declares and initializes a CFRange structure.

CFRange CFRangeMake (
   CFIndex loc,
   CFIndex len
);
Parameters
loc

The starting location of the range. 
len

The length of the range.
Return Value

An initialized structure of type CFRange. 
Discussion

This is an in-line convenience function for creating initialized CFRange structures. 
Availability
Available in Mac OS X v10.0 and later.*/

CFRange CFRangeMake (
   CFIndex loc,
   CFIndex len
){};

/*CFEqual

Determines whether two Core Foundation objects are considered equal.

Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);
Parameters
cf1

A CFType object to compare to cf2.
cf2

A CFType object to compare to cf1.
Return Value

true if cf1 and cf2 are of the same type and considered equal, otherwise false. 
Discussion

Equality is something specific to each Core Foundation opaque type. For example, two CFNumber objects are equal if the numeric values they represent are equal. Two CFString objects are equal if they represent identical sequences of characters, regardless of encoding. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
){};

/*CFGetRetainCount

Returns the reference count of a Core Foundation object.

CFIndex CFGetRetainCount (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A number representing the reference count of cf. 
Discussion

You increment the reference count using the CFRetain function, and decrement the reference count using the CFRelease function.

This function may useful for debugging memory leaks. You normally do not use this function, otherwise.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFGetRetainCount (
   CFTypeRef cf
){};

/*CFAllocatorAllocate

Allocates memory using the specified allocator.

void *CFAllocatorAllocate (
   CFAllocatorRef allocator,
   CFIndex size,
   CFOptionFlags hint
);
Parameters
allocator

The allocator to use to allocate the memory. Pass NULL or kCFAllocatorDefault to use the current default allocator.
size

The size of the memory to allocate. 
hint

A bitfield containing flags that suggest how memory is to be allocated. 0 indicates no hints. No hints are currently defined, so only 0 should be passed for this value.
Return Value

A pointer to the newly allocated memory. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void *CFAllocatorAllocate (
   CFAllocatorRef allocator,
   CFIndex size,
   CFOptionFlags hint
){};

/*CFAllocatorDeallocate

Deallocates a block of memory with a given allocator.

void CFAllocatorDeallocate (
   CFAllocatorRef allocator,
   void *ptr
);
Parameters
allocator

The allocator that was used to allocate the block of memory pointed to by ptr. 
ptr

An untyped pointer to a block of memory to deallocate using allocator.
Discussion

If the allocator does not specify a deallocate callback function, the memory is not deallocated. 
Special Considerations

You must use the same allocator to deallocate memory as was used to allocate it.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFAllocatorDeallocate (
   CFAllocatorRef allocator,
   void *ptr
){};


/*CFAllocatorGetDefault

Gets the default allocator object for the current thread.

CFAllocatorRef CFAllocatorGetDefault ();

Return Value

A reference to the default allocator for the current thread. If none has been explicitly set, returns the generic system allocator, kCFAllocatorSystemDefault. Ownership follows the Get Rule.
Discussion

See the discussion for CFAllocatorSetDefault for more detail on the default allocator and for advice on how and when to set a custom allocator as the default. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFAllocatorRef CFAllocatorGetDefault (){};


