#include <CoreFoundation/CoreFoundation.h>


/*Predefined Callback Structures

CFArray provides some predefined callbacks for your convenience.

const CFArrayCallBacks kCFTypeArrayCallBacks;
Constants
kCFTypeArrayCallBacks

Predefined CFArrayCallBacks structure containing a set of callbacks appropriate for use when the values in a CFArray are all CFType-derived objects. The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, and the equal callback is CFEqual. Therefore, if you use this constant when creating the collection, items are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.*/
 const CFArrayCallBacks kCFTypeArrayCallBacks;
//work

/*CFArrayGetValueAtIndex

Retrieves a value at a given index.

const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx
);
Parameters
theArray

The array to examine. 
idx

The index of the value to retrieve. If the index is outside the index space of theArray (0 to N-1 inclusive (where N is the count of theArray), the behavior is undefined. 
Return Value

The value at the idx index in theArray. If the return value is a Core Foundation Object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx
){};

/*CFArrayAppendValue

Adds a value to an array giving it the new largest index.

void CFArrayAppendValue (
   CFMutableArrayRef theArray,
   const void *value
);
Parameters
theArray

The array to which value is to be added. If theArray is a limited-capacity array and it is full before this operation, the behavior is undefined. 
value

A CFType object or a pointer value to add to theArray. 
Discussion

The value parameter is retained by theArray using the retain callback provided when theArray was created. If value is not of the type expected by the retain callback, the behavior is undefined. The value parameter is assigned to the index one larger than the previous largest index and the count of theArray is increased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayAppendValue (
   CFMutableArrayRef theArray,
   const void *value
){};

/*CFArrayGetCount

Returns the number of values currently in an array.

CFIndex CFArrayGetCount (
   CFArrayRef theArray
);
Parameters
theArray

The array to examine. 
Return Value

The number of values in theArray. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later*/
CFIndex CFArrayGetCount (
   CFArrayRef theArray
){};

/*CFArrayCreateMutable

Creates a new empty mutable array.

CFMutableArrayRef CFArrayCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFArrayCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of values that can be contained by the new array. The array starts empty and can grow to this number of values (and it can have less). If this parameter is 0, the array’s maximum capacity is not limited. The value must not be negative. 
callBacks

A pointer to a CFArrayCallBacks structure initialized with the callbacks for the array to use on each value in the array. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple array creations. This parameter may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. 

If any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFArrayCallBacks structure, the behavior is undefined. If any value put into the array is not one understood by one of the callback functions, the behavior when that callback function is used is undefined. If the array contains CFType objects only, then pass kCFTypeArrayCallBacks as this parameter to use the default callback functions.
Return Value

A new mutable array, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableArrayRef CFArrayCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFArrayCallBacks *callBacks
){};

/*CFArrayGetTypeID

Returns the type identifier for the CFArray opaque type.

CFTypeID CFArrayGetTypeID();
Return Value

The type identifier for the CFArray opaque type.
Discussion

CFMutableArray objects have the same type identifier as CFArray objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFArrayGetTypeID(){};

/*CFArrayRemoveValueAtIndex

Removes the value at a given index from an array.

void CFArrayRemoveValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx
);
Parameters
theArray

The array from which the value is to be removed. 
idx

The index of the value to remove. The value not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of theArray before the operation).
Discussion

All values in theArray with indices larger than idx have their indices decreased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayRemoveValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx
){};

/*CFArrayCreate

Creates a new immutable array with the given values.

CFArrayRef CFArrayCreate (
   CFAllocatorRef allocator,
   const void **values,
   CFIndex numValues,
   const CFArrayCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
values

A C array of the pointer-sized values to be in the new array. The values in the new array are ordered in the same order in which they appear in this C array. This value may be NULL if numValues is 0. This C array is not changed or freed by this function. If values is not a valid pointer to a C array of at least numValues elements, the behavior is undefined. 
numValues

The number of values to copy from the values C array into the new array. This number will be the count of the new array—it must not be negative or greater than the number of elements in values. 
callBacks

A pointer to a CFArrayCallBacks structure initialized with the callbacks for the array to use on each value in the collection. The retain callback is used within this function, for example, to retain all of the new values from the values C array. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFArrayCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the collection contains only CFType objects, then pass kCFTypeArrayCallBacks to use the default callback functions.
Return Value

A new immutable array containing numValues from values, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFArrayRef CFArrayCreate (
   CFAllocatorRef allocator,
   const void **values,
   CFIndex numValues,
   const CFArrayCallBacks *callBacks
){};

/*CFArrayInsertValueAtIndex

Inserts a value into an array at a given index.

void CFArrayInsertValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
);
Parameters
theArray

The array into which value is inserted. If theArray is a fixed-capacity array and it is full before this operation, the behavior is undefined. 
idx

The index at which to insert value. The index must not exceed the index space of theArray (0 to N-1 inclusive, where N is the count of theArray before the operation. If the index is the same as the count of theArray, this function has the same effect as CFArrayAppendValue. 
value

The value to insert into theArray. The value is retained by theArray using the retain callback provided when theArray was created. If value is not of the type expected by the retain callback, the behavior is undefined. 
Discussion

The value parameter is assigned to the index idx, and all values in theArray with equal and larger indices have their indices increased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayInsertValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
){};

/*CFArrayCreateMutableCopy

Creates a new mutable array with the values from another array.

CFMutableArrayRef CFArrayCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFArrayRef theArray
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of values that can be contained by the new array. The array starts with the same count as theArray and can grow to this number of values (and it can have less). If this parameter is 0, the array’s maximum capacity is not limited. The capacity must not be negative, and must be greater than or equal to the count of theArray.
theArray

The array to copy. The pointer values from the array are copied into the new array. However, the values are also retained by the new array.
Return Value

A new mutable array that contains the same values as theArray. The new array has the same count as the theArray and uses the same callbacks. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableArrayRef CFArrayCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFArrayRef theArray
){};

/*CFArrayGetFirstIndexOfValue

Searches an array forward for a value.

CFIndex CFArrayGetFirstIndexOfValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
);
Parameters
theArray

The array to examine. 
range

The range within theArray to search. The range must lie within the bounds of theArray. The range may be empty (length 0). The search progresses from the lowest index defined by the range to the highest. 
value

The value for which to find a match in theArray. The equal callback provided when theArray was created is used to compare. If the equal callback was NULL, pointer equality (in C, ==) is used. If value, or any other value in theArray, is not understood by the equal callback, the behavior is undefined. 
Return Value

The lowest index of the matching values in the range, or -1 if no value in the range matched.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFArrayGetFirstIndexOfValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
){};

/*CFArrayReplaceValues

Replaces a range of values in an array.

void CFArrayReplaceValues (
   CFMutableArrayRef theArray,
   CFRange range,
   void **newValues,
   CFIndex newCount
);
Parameters
theArray

The array in which some values are to be replaced. If this parameter is not a valid CFMutableArray object, the behavior is undefined. 
range

The range of values within theArray to replace. The range location or end point (defined by the location plus length minus 1) must not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of theArray). The range length must not be negative. The range may be empty (length 0), in which case the new values are merely inserted at the range location. 
newValues

A C array of the pointer-sized values to be placed into theArray. The new values in theArray are ordered in the same order in which they appear in this C array. This parameter may be NULL if the newCount parameter is 0. This C array is not changed or freed by this function. If this parameter is not a valid pointer to a C array of at least newCount pointers, the behavior is undefined.
newCount

The number of values to copy from the newValues C array into theArray. If this parameter is different from the range length, the excess newCount values are inserted after the range or the excess range values are deleted. This parameter may be 0, in which case no new values are replaced into theArray and the values in the range are simply removed. If this parameter is negative or greater than the number of values actually in the newValues C array, the behavior is undefined. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayReplaceValues (
   CFMutableArrayRef theArray,
   CFRange range,
   void **newValues,
   CFIndex newCount
){};

/*CFArraySortValues

Sorts the values in an array using a given comparison function.

void CFArraySortValues (
   CFMutableArrayRef theArray,
   CFRange range,
   CFComparatorFunction comparator,
   void *context
);
Parameters
theArray

The array whose values are sorted. 
range

The range of values within theArray to sort. The range location or end point (defined by the location plus length minus 1) must not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of theArray). The range length must not be negative. The range may be empty (length 0). 
comparator

The function with the comparator function type signature that is used in the sort operation to compare the values in theArray. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. If there are values in theArray that the comparator function does not expect or cannot properly compare, the behavior is undefined. The values in the range are sorted from least to greatest according to this function. 
context

A pointer-sized program-defined value, which is passed as the third parameter to the comparator function, but is otherwise unused by this function. If the context is not what is expected by the comparator function, the behavior is undefined. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArraySortValues (
   CFMutableArrayRef theArray,
   CFRange range,
   CFComparatorFunction comparator,
   void *context
){};

/*CFArrayContainsValue

Reports whether or not a value is in an array.

Boolean CFArrayContainsValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
);
Parameters
theArray

The array to search. 
range

The range within theArray to search. The range must not exceed the bounds of theArray). The range may be empty (length 0). 
value

The value to match in theArray. The equal callback provided when theArray was created is used to compare. If the equal callback was NULL, pointer equality (in C, ==) is used. If value, or any other value in theArray, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if value is in the specified range of theArray, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFArrayContainsValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
){};

/*CFArraySetValueAtIndex

Changes the value at a given index in an array.

void CFArraySetValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
);
Parameters
theArray

The array in which the value is to be changed. 
idx

The index at which to set the new value. The value must not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of the array before the operation). 
value

The value to set in theArray. The value is retained by theArray using the retain callback provided when theArray was created and the previous value at idx is released. If the value is not of the type expected by the retain callback, the behavior is undefined. The indices of other values are not affected. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArraySetValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
){};

/*CFArrayRemoveAllValues

Removes all the values from an array, making it empty.

void CFArrayRemoveAllValues (
   CFMutableArrayRef theArray
);
Parameters
theArray

The array from which all of the values are removed. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayRemoveAllValues (
   CFMutableArrayRef theArray
){};

/*CFArrayGetValues

Fills a buffer with values from an array.

void CFArrayGetValues (
   CFArrayRef theArray,
   CFRange range,
   const void **values
);
Parameters
theArray

The array to examine. 
range

The range of values within theArray to retrieve. The range must lie within the bounds of theArray. The range may be empty (length 0), in which case no values are put into the buffer values.
values

A C array of pointer-sized values to be filled with values from theArray. The values in the C array are in the same order as they appear in theArray. If this value is not a valid pointer to a C array of at least range.length pointers, the behavior is undefined. If the values are Core Foundation objects, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayGetValues (
   CFArrayRef theArray,
   CFRange range,
   const void **values
){};

/*CFArrayAppendArray

Adds the values from one array to another array.

void CFArrayAppendArray (
   CFMutableArrayRef theArray,
   CFArrayRef otherArray,
   CFRange otherRange
);
Parameters
theArray

The array to which values from otherArray are added. If theArray is a limited-capacity array, adding otherRange.length values from otherArray must not cause the capacity limit of theArray to be exceeded.
otherArray

An array providing the values to be added to theArray.
otherRange

The range within otherArray from which to add the values to theArray. The range must not exceed the index space of otherArray.
Discussion

The new values are retained by theArray using the retain callback provided when theArray was created. If the values are not of the type expected by the retain callback, the behavior is undefined. The values are assigned to the indices one larger than the previous largest index in theArray, and beyond, and the count of theArray is increased by otherRange.length. The values are assigned new indices in theArray from smallest to largest index in the order in which they appear in otherArray.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayAppendArray (
   CFMutableArrayRef theArray,
   CFArrayRef otherArray,
   CFRange otherRange
){};


/*CFArrayApplyFunction

Calls a function once for each element in range in an array.

void CFArrayApplyFunction (
   CFArrayRef theArray,
   CFRange range,
   CFArrayApplierFunction applier,
   void *context
);

Parameters
theArray

The array to whose elements to apply the function. 
range

The range of values within theArray to which to apply the applier function. The range must not exceed the bounds of theArray. The range may be empty (length 0).
applier

The callback function to call once for each value in the given range in theArray. If there are values in the range that the applier function does not expect or cannot properly apply to, the behavior is undefined. 
context

A pointer-sized program-defined value, which is passed as the second argument to the applier function, but is otherwise unused by this function. If the context is not what is expected by the applier function, the behavior is undefined. 
Discussion

While this function iterates over a mutable collection, it is unsafe for the applier function to change the contents of the collection. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFArrayApplyFunction (
   CFArrayRef theArray,
   CFRange range,
   CFArrayApplierFunction applier,
   void *context
){};


