#import <AddressBook/ABRecord.h>

@implementation ABRecord 

/*setValue:forProperty:

- (BOOL)setValue:(id)value forProperty:(NSString *)property
Discussion

Sets the value of a given property for a record. The type of the value must match the property’s type (see “Constants” for a list of possible property types). If property is nil or if value is not of the correct type, this method raises an exception. If property is a multi-value list property, this method checks to see if the values in the multi-value list are the same type. If the multi-value list contains mixed types, this method returns NO. This method returns YES if the value was set successfully, and NO otherwise.
Availability
Available in Mac OS X v10.2 and later.*/
- (BOOL)setValue:(id)value forProperty:(NSString *)property{
printf ("setValue",value,property);
}


/*valueForProperty:

- (id)valueForProperty:(NSString *)property
Discussion

Returns the value of the given property. The type of the value depends on the property type (see “Constants” for a list of possible property types). Note that the retuned value is always of an immutable type (for example, an NSString not an NSMutableString is returned). 

If property is nil, this method raises an exception. 
Availability
Available in Mac OS X v10.2 and later.*/
- (id)valueForProperty:(NSString *)property{}

@end



@implementation ABRecord(ABRecord_Convenience)
/*uniqueId

- (NSString *)uniqueId
Discussion

Returns the unique ID of the receiver. This method is equivalent to invoking valueForProperty: passing kABUIDProperty as the argument. 
Availability
Available in Mac OS X v10.2 and later.
See Also
– recordForUniqueId: (ABAddressBook)*/
- (NSString *)uniqueId{
printf ("uniqueId");
}

@end

