#include <AddressBook/ABMultiValue.h>


@implementation ABMultiValue

/*valueAtIndex:

- (id)valueAtIndex:(int)index
Discussion

Returns the value for the given index. If the index argument is out of bounds, this method raises an exception.
Availability
Available in Mac OS X v10.2 and later.
See Also
– labelAtIndex:

 Show TOC*/
- (id)valueAtIndex:(int)index{}

/*count

- (unsigned int)count
Discussion

Returns the number of entries in a multi-value list. 
Availability
Available in Mac OS X v10.2 and later.*/
- (unsigned int)count{}

/*labelAtIndex:

- (NSString *)labelAtIndex:(int)index
Discussion

Returns the label for the given index. If the index argument is out of bounds, this method raises an exception.
Availability
Available in Mac OS X v10.2 and later.
See Also
– valueAtIndex:*/
- (NSString *)labelAtIndex:(int)index{}

@end

@implementation  ABMutableMultiValue 

/*addValue:withLabel:

- (NSString *)addValue:(id)value withLabel:(NSString *)label
Discussion

Adds a value and its label to a multi-value list. The value argument must be of the correct type. For example, if the receiver is the value for a property of type kABMultiStringProperty, then value needs to be an NSString object. See “Constants” for a list of supported types in a multi-value list (see descriptions of the kABMulti... constants). If value is added successfully, this method returns the new identifier, nil otherwise. If either the value or the label arguments are nil, this method raises an exception.

This method performs no type checking and will let you add a value whose type does not match the types of the other values in the list. However, if you try to use a multi-value list whose values are not all of the same type, other methods, such as the ABRecord setValue:forProperty: method, will return NO or kABErrorInProperty.
Availability
Available in Mac OS X v10.2 and later.
See Also
– insertValue:withLabel:atIndex:*/
- (NSString *)addValue:(id)value withLabel:(NSString *)label{
printf ("addValue",value,label);
}

@end
