#ifndef VIMAGE_TYPES_H
#define VIMAGE_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>  
#include <stdbool.h> 
#include <stdint.h>
#include <stddef.h>
#include <AvailabilityMacros.h>

/*vImage Flags


enum
{
   kvImageNoFlags                  =   0,
   kvImageLeaveAlphaUnchanged      =   1,
   kvImageCopyInPlace              =   2,
   kvImageBackgroundColorFill      =   4,
   kvImageEdgeExtend               =   8,
   kvImageDoNotTile                =   16,
   kvImageHighQualityResampling    =   32,
   kvImageTruncateKernel           =   64,
   kvImageGetTempBufferSize        =   128
};
Constants
kvImageNoFlags

No flags set.

Available in Mac OS X v10.3 and later.
kvImageLeaveAlphaUnchanged

Operate on red, green, and blue channels only. Copy alpha channel unchanged from source to destination.

Available in Mac OS X v10.3 and later.
kvImageCopyInPlace

Use the Copy In Place technique for handling pixels out the image buffer.

Available in Mac OS X v10.3 and later.
kvImageBackgroundColorFill

Use the Background Color Fill technique for handling pixels out the image buffer.

Available in Mac OS X v10.3 and later.
kvImageEdgeExtend

Use the Edge Extend technique for handling pixels out the image buffer.

Available in Mac OS X v10.3 and later.
kvImageDoNotTile

Do not use vImage internal tiling routines.

Available in Mac OS X v10.3 and later.
kvImageHighQualityResampling

Use a higher quality, slower filter for resampling.

Available in Mac OS X v10.3 and later.
kvImageTruncateKernel

Use only the part of the kernel that overlaps the image being processed.

Available in Mac OS X v10.4 and later.
kvImageGetTempBufferSize

Return the minimum temporary buffer size for the operation, given the parameters provided.

Available in Mac OS X v10.4 and later.*/
enum
{
   kvImageNoFlags                  =   0,
   kvImageLeaveAlphaUnchanged      =   1,
   kvImageCopyInPlace              =   2,
   kvImageBackgroundColorFill      =   4,
   kvImageEdgeExtend               =   8,
   kvImageDoNotTile                =   16,
   kvImageHighQualityResampling    =   32,
   kvImageTruncateKernel           =   64,
   kvImageGetTempBufferSize        =   128
};


/*Pixel_8

8 bit planar pixel value

typedef uint8_t Pixel_8;
Availability
Available in Mac OS X v10.3 and later.*/
typedef uint8_t Pixel_8;

/*vImage_Error

Error codes generated by vImage

typedef int32_tvImage_Error;*/
typedef int32_t vImage_Error;

/*vImage_Buffer

This data structure contains an image, which can be in Planar8, PlanarF, ARGB8888, or ARGBFFFF format.

typedef struct vImage_Buffer
{
void        *data;
uint32_t    height;
uint32_t    width;
uint32_t    rowBytes;
}vImage_Buffer;
Fields
data

A pointer to the top left pixel of the image. If the vImage_Buffer is being used as a destination buffer, so that the pixel data will be filled in by some function call, the pixel data may not exist. But the data pointer must be valid and point to an area of memory that is an appropriate size for the vImage_Buffer. Specifically, it must be at least height * rowBytes bytes.
height

The number of rows in the image.
width

The number of pixels in one row of the image.
rowBytes

The number of bytes in a pixel row. This is the distance, in bytes, between the start of one row of the image and the start of the next. This must be at least width * pixel size, where pixel size depends on the image format. It can be more, in which case extra bytes extend beyond the end of each row of pixels. This is a convenient way to pad the row length for improved performance, or to describe an image within a larger image without copying the data. The extra bytes are not considered part of the image represented by the vImage_Buffer.
Discussion

This is the basic data structure used by vImage. Given a vImage_Buffer as an input, vImage functions will not attempt to read pixel data outside the area described by the height and width fields. They will also not write data outside that area.*/
typedef struct vImage_Buffer
{
void        *data;
uint32_t    height;
uint32_t    width;
uint32_t    rowBytes;
}vImage_Buffer;

/*vImage_Flags

Flags used by vImage

typedef uint32_t vImage_Flags;
Availability
Available in Mac OS X v10.3 and later.*/
typedef uint32_t vImage_Flags;

#ifdef __cplusplus
}
#endif


#endif 