#ifndef  SYS_ATTR_H
#define SYS_ATTR_H

//#include <attr/attributes.h>

#include <sys/appleapiopts.h>

#include <sys/types.h>
#include <sys/ucred.h>
#include <sys/time.h>
#include <sys/cdefs.h>
//#include <HYS/sys/attr.h>
#include <APPLE/sys/attr.h>



 /*typedef u_int32_t attrgroup_t;

     struct attrlist {
         u_short     bitmapcount; /number of attr. bit sets in list *
         u_int16_t   reserved;    / (to maintain 4-byte alignment) *
         attrgroup_t commonattr;  / common attribute group *
         attrgroup_t volattr;     / volume attribute group *
         attrgroup_t dirattr;     / directory attribute group *
         attrgroup_t fileattr;    / file attribute group *
         attrgroup_t forkattr;    / fork attribute group *
     };
     #define ATTR_BIT_MAP_COUNT 5

     The fields of the attrlist structure are defined as follows.

     bitmapcount     Number of attribute bit sets in the structure.  In cur-current
                     rent systems you must set this to ATTR_BIT_MAP_COUNT.

     reserved        Reserved.  You must set this to 0.

     commonattr      A bit set that specifies the common attributes that you
                     require.  Common attributes relate to all types of file
                     system objects.  See below for a description of these
                     attributes.

     volattr         A bit set that specifies the volume attributes that you
                     require.  Volume attributes relate to volumes (that is,
                     mounted file systems).  See below for a description of
                     these attributes.  If you request volume attributes, path
                     must reference the root of a volume.  In addition, you
                     can't request volume attributes if you also request file
                     or directory attributes.

     dirattr         A bit set that specifies the directory attributes that
                     you require.  See below for a description of these
                     attributes.

     fileattr        A bit set that specifies the file attributes that you
                     require.  See below for a description of these
                     attributes.

     forkattr        A bit set that specifies the fork attributes that you
                     require.  Fork attributes relate to the actual data in
                     the file, which can be held in multiple named contiguous
                     ranges, or forks.  See below for a description of these
                     attributes.

     Unless otherwise noted in the lists below, attributes are read-only.
     Attributes labelled as read/write can be set using setattrlist(2).

     The attrBuf and attrBufSize parameters specify a buffer into which the
     function places attribute values.  The format of this buffer is suffi-sufficiently
     ciently complex that its description requires a separate section (see
     below).  The initial contents of this buffer are ignored.

     The options parameter is a bit set that controls the behaviour of
     getattrlist().  The following option bits are defined.

     FSOPT_NOFOLLOW  If this bit is set, getattrlist() will not follow a sym-symlink
                     link if it occurs as the last component of path.
*/
typedef u_int32_t attrgroup_t;

     struct attrlist {
         u_short     bitmapcount; /* number of attr. bit sets in list */
         u_int16_t   reserved;    /* (to maintain 4-byte alignment) */
         attrgroup_t commonattr;  /* common attribute group */
         attrgroup_t volattr;     /* volume attribute group */
         attrgroup_t dirattr;     /* directory attribute group */
         attrgroup_t fileattr;    /* file attribute group */
         attrgroup_t forkattr;    /* fork attribute group */
     };
     #define ATTR_BIT_MAP_COUNT 5



/*GETATTRLIST(2)              BSD System Calls Manual             GETATTRLIST(2)

NAME
     getattrlist -- get file system attributes

SYNOPSIS
     #include <sys/attr.h>
     #include <unistd.h>

     int
     getattrlist(const char* path, struct attrlist * attrList, void * attrBuf,
         size_t attrBufSize, unsigned long options);

DESCRIPTION
     The getattrlist() function returns attributes (that is, metadata) of file
     system objects.  You can think of getattrlist() as a seriously enhanced
     version of stat(2).  The function returns attributes about the file sys-system
     tem object specified by path in the buffer specified by attrBuf and
     attrBufSize.  The attrList parameter determines what attributes are
     returned.  The options parameter lets you control specific aspects of the
     function's behaviour.

     The getattrlist() function is only supported by certain volume format
     implementations.  For maximum compatibility, client programs should use
     high-level APIs (such as the Carbon File Manager) to access file system
     attributes.  These high-level APIs include logic to emulate file system
     attributes on volumes that don't support getattrlist().

     Not all volumes support all attributes.  See the discussion of
     ATTR_VOL_ATTRIBUTES for a discussion of how to determine whether a par-particular
     ticular volume supports a particular attribute.

     Furthermore, you should only request the attributes that you need.  Some
     attributes are expensive to calculate on some volume formats.  For exam-example,
     ple, ATTR_DIR_ENTRYCOUNT is usually expensive to calculate on non-HFS
     [Plus] volumes.  If you don't need a particular attribute, you should not
     ask for it.

     The path parameter must reference a valid file system object.  Read,
     write or execute permission of the object itself is not required, but all
     directories listed in the path name leading to the object must be search-searchable.
     able.

     The attrList parameter is a pointer to an attrlist structure, as defined
     by <sys/attr.h> (shown below).  It determines what attributes are
     returned by the function.  You are responsible for filling out all fields
     of this structure before calling the function.

     #define ATTR_BIT_MAP_COUNT 5

     The fields of the attrlist structure are defined as follows.

     bitmapcount     Number of attribute bit sets in the structure.  In cur-current
                     rent systems you must set this to ATTR_BIT_MAP_COUNT.

     reserved        Reserved.  You must set this to 0.

     commonattr      A bit set that specifies the common attributes that you
                     require.  Common attributes relate to all types of file

   The attributes are placed into the attribute buffer in the order
          that they are described below.

     If the attribute is of variable length, it is represented in the list by
     an attrreference structure, as defined by <sys/attr.h> (shown below).

     typedef struct attrreference {
         long        attr_dataoffset;
         size_t      attr_length;
     } attrreference_t;

     This structure contains a 'pointer' to the variable length attribute
     data.  The attr_length field is the length of the attribute data (in
     bytes).  The attr_dataoffset field is the offset in bytes from the
     attrreference structure to the attribute data.  This offset will always
     be a multiple of sizeof(unsigned long) bytes, so you can safely access
     common data types without fear of alignment exceptions.

     The getattrlist() function will silently truncate attribute data if
     attrBufSize is too small.  The length field at the front of the attribute
     list always represents the length of the data actually copied into the
     attribute buffer.  If the data is truncated, there is n*/
    typedef struct attrreference {
         long        attr_dataoffset;
         size_t      attr_length;
     } attrreference_t;

int      getattrlist(const char* path, struct attrlist * attrList, void * attrBuf,
      size_t attrBufSize, unsigned long options);




/*GETATTRLIST(2)              BSD System Calls Manual             GETATTRLIST(2)

VOLUME CAPABILITIES
     Not all volumes support all features.  The ATTR_VOL_CAPABILITIES
     attribute returns a vol_capabilities_attr_t structure (shown below) that
     indicates which features are supported by the volume.

     typedef u_int32_t vol_capabilities_set_t[4];

     #define VOL_CAPABILITIES_FORMAT     0
     #define VOL_CAPABILITIES_INTERFACES 1
     #define VOL_CAPABILITIES_RESERVED1  2
     #define VOL_CAPABILITIES_RESERVED2  3

     typedef struct vol_capabilities_attr {
         vol_capabilities_set_t capabilities;
         vol_capabilities_set_t valid;
     } vol_capabilities_attr_t;

     The structure contains two fields, capabilities and valid.  Each consists
     of an array of four elements.  The arrays are indexed by the following
     values.

     VOL_CAPABILITIES_FORMAT          This element contains information about
                                      the volume format.  See
                                      VOL_CAP_FMT_PERSISTENTOBJECTIDS and so
                                      on, below.

     VOL_CAPABILITIES_INTERFACES      This element contains information about
                                      which optional functions are supported
                                      by the volume format implementation.
                                      See VOL_CAP_INT_SEARCHFS and so on,
                                      below.

     VOL_CAPABILITIES_RESERVED1       Reserved.  A file system implementation
                                      should set this element to zero.  A
                                      client program should ignore this ele-element.
                                      ment.

     VOL_CAPABILITIES_RESERVED2       Reserved.  A file system implementation
                                      should set this element to zero.  A
                                      client program should ignore this ele-element.
                                      ment.

     The valid field contains bit sets that indicate which flags are known to
     the volume format implementation.  Each bit indicates whether the con-contents
     tents of the corresponding bit in the capabilities field is valid.

     The capabilities field contains bit sets that indicate whether a particu-particular
     lar feature is implemented by this volume format.

     The following bits are defined in the first element (indexed by
     VOL_CAPABILITIES_FORMAT) of the capabilities and valid fields of the
     vol_capabilities_attr_t structure.

     VOL_CAP_FMT_PERSISTENTOBJECTIDS  If this bit is set the volume format
                                      supports persistent object identifiers
                                      and can look up file system objects by
                                      their IDs.  See ATTR_CMN_OBJPERMANENTID
                                      for details about how to obtain these
                                      identifiers.

     VOL_CAP_FMT_SYMBOLICLINKS        If this bit is set the volume format
                                      supports symbolic links.

     VOL_CAP_FMT_HARDLINKS            If this bit is set the volume format
                                      supports hard links.

     VOL_CAP_FMT_JOURNAL              If this bit is set the volume format
                                      supports a journal used to speed recov-recovery
                                      ery in case of unplanned restart (such
                                      as a power outage or crash).  This does
                                      not necessarily mean the volume is
                                      actively using a journal.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_JOURNAL_ACTIVE       If this bit is set the volume is cur-currently
                                      rently using a journal for speedy recov-recovery
                                      ery after an unplanned restart.  This
                                      bit can be set only if
                                      VOL_CAP_FMT_JOURNAL is also set.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_NO_ROOT_TIMES        If this bit is set the volume format
                                      does not store reliable times for the
                                      root directory, so you should not depend
                                      on them to detect changes, identify vol-volumes
                                      umes across unmount/mount, and so on.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_SPARSE_FILES         If this bit is set the volume format
                                      supports sparse files, that is, files
                                      which can have 'holes' that have never
                                      been written to, and thus do not consume
                                      space on disk.  A sparse file may have
                                      an allocated size on disk that is less
                                      than its logical length (that is,
                                      ATTR_FILE_ALLOCSIZE <
                                      ATTR_FILE_TOTALSIZE ).

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_ZERO_RUNS            For security reasons, parts of a file
                                      (runs) that have never been written to
                                      must appear to contain zeroes.  When
                                      this bit is set, the volume keeps track
                                      of allocated but unwritten runs of a
                                      file so that it can substitute zeroes
                                      without actually writing zeroes to the
                                      media.  This provides performance simi-
                                      lar to sparse files, but not the space
                                      savings.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_CASE_SENSITIVE       If this bit is set the volume format
                                      treats upper and lower case characters
                                      in file and directory names as differ-different.
                                      ent.  Otherwise an upper case character
                                      is equivalent to a lower case character,
                                      and you can't have two names that differ
                                      solely in the case of the characters.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_CASE_PRESERVING      If this bit is set the volume format
                                      preserves the case of file and directory
                                      names.  Otherwise the volume may change
                                      the case of some characters (typically
                                      making them all upper or all lower
                                      case).  A volume that sets
                                      VOL_CAP_FMT_CASE_SENSITIVE must also set
                                      VOL_CAP_FMT_CASE_PRESERVING.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_FAST_STATFS          This bit is used as a hint to upper lay-layers
                                      ers (specifically the Carbon File Man-Manager)
                                      ager) to indicate that statfs(2) is fast
                                      enough that its results need not be
                                      cached by the caller.  A volume format
                                      implementation that caches the statfs(2)
                                      information in memory should set this
                                      bit.  An implementation that must always
                                      read from disk or always perform a net-network
                                      work transaction to satisfy statfs(2)
                                      should not set this bit.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_FMT_2TB_FILESIZE         If this bit is set the volume format
                                      supports file sizes upto 2TB.  This bit
                                      does not necessarily mean that the file
                                      system does not support file size more
                                      than 2TB.   This bit does not mean that
                                      the currently available space on the
                                      volume is 2TB.

                                      Introduced with Darwin 8.0 (Mac OS X
                                      version 10.4).

     The following bits are defined in the second element (indexed by
     VOL_CAPABILITIES_INTERFACES) of the capabilities and valid fields of the
     vol_capabilities_attr_t structure.

     VOL_CAP_INT_SEARCHFS             If this bit is set the volume format
                                      implementation supports searchfs(2).

     VOL_CAP_INT_ATTRLIST             If this bit is set the volume format
                                      implementation supports getattrlist()
                                      and setattrlist(2).

     VOL_CAP_INT_NFSEXPORT            If this bit is set the volume format
                                      implementation allows this volume to be
                                      exported via NFS.

     VOL_CAP_INT_READDIRATTR          If this bit is set the volume format
                                      implementation supports
                                      getdirentriesattr(2).

     VOL_CAP_INT_EXCHANGEDATA         If this bit is set the volume format
                                      implementation supports exchangedata(2).

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_INT_COPYFILE             If this bit is set the volume format
                                      implementation supports the (private and
                                      undocumented) copyfile() function.

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_INT_ALLOCATE             If this bit is set the volume format
                                      implementation supports the
                                      F_PREALLOCATE selector of fcntl(2).

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_INT_VOL_RENAME           If this bit is set the volume format
                                      implementation allows you to modify the
                                      volume name using setattrlist(2).

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_INT_ADVLOCK              If this bit is set the volume format
                                      implementation supports advisory lock-locking,
                                      ing, that is, the F_GETLK, F_SETLK, and
                                      F_SETLKW selectors to fcntl(2).

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).

     VOL_CAP_INT_FLOCK                If this bit is set the volume format
                                      implementation supports whole file
                                      locks.  This includes flock(2) and the
                                      O_EXLOCK and O_SHLOCK flags to open(2).

                                      Introduced with Darwin 7.0 (Mac OS X
                                      version 10.3).*/

     typedef u_int32_t vol_capabilities_set_t[4];

     #define VOL_CAPABILITIES_FORMAT     0
     #define VOL_CAPABILITIES_INTERFACES 1
     #define VOL_CAPABILITIES_RESERVED1  2
     #define VOL_CAPABILITIES_RESERVED2  3

     struct vol_capabilities_attr {
         vol_capabilities_set_t capabilities;
         vol_capabilities_set_t valid;
     };
typedef struct vol_capabilities_attr vol_capabilities_attr;
typedef vol_capabilities_attr vol_capabilities_attr_t;

/* A volume can also report which attributes it supports.  This information
     is returned by the ATTR_VOL_ATTRIBUTES attribute, which returns a
     vol_attributes_attr_t structure (shown below).

     typedef struct attribute_set {
         attrgroup_t commonattr; *common attribute group *
         attrgroup_t volattr;    / volume attribute group *
         attrgroup_t dirattr;    / directory attribute group *
         attrgroup_t fileattr;   / file attribute group *
         attrgroup_t forkattr;   / fork attribute group *
     } attribute_set_t;

     typedef struct vol_attributes_attr {
         attribute_set_t validattr;
         attribute_set_t nativeattr;
     } vol_attributes_attr_t;*/

     typedef struct attribute_set {
         attrgroup_t commonattr; /* common attribute group */
         attrgroup_t volattr;    /* volume attribute group */
         attrgroup_t dirattr;    /* directory attribute group */
         attrgroup_t fileattr;   /* file attribute group */
         attrgroup_t forkattr;   /* fork attribute group */
     } attribute_set_t;

     typedef struct vol_attributes_attr {
         attribute_set_t validattr;
         attribute_set_t nativeattr;
     } vol_attributes_attr_t;

#endif


