#ifndef  SOUNDSPROCKET_H
#define SOUNDSPROCKET_H

#ifndef  MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef  EVENTS_H
#include <HIToolbar/Events.h>
#endif

#ifndef  QD3D_H
#include <QD3D.h>
#endif

#ifndef  QD3DCAMERA_H
#include <QD3DCamera.h>
#endif

#ifndef  MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif



#include <APPLE/SoundSprocket.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Data Types
typedef struct SSpSourcePrivate        *SSpSourceReference;
typedef struct SSpListenerPrivate      *SSpListenerReference;*/

typedef struct SSpSourcePrivate        *SSpSourceReference;
typedef struct SSpListenerPrivate      *SSpListenerReference;

/*Source Modes
enum {
   kSSpSourceMode_Unfiltered           = 0,
   kSSpSourceMode_Localized            = 1,
   kSSpSourceMode_Ambient              = 2,
   kSSpSourceMode_Binaural             = 3
};*/
enum {
   kSSpSourceMode_Unfiltered           = 0,
   kSSpSourceMode_Localized            = 1,
   kSSpSourceMode_Ambient              = 2,
   kSSpSourceMode_Binaural             = 3
};

/*Sound Component Link Structure
struct SoundComponentLink {
   ComponentDescription       description;
   SoundSource                mixerID;
   SoundSource *              linkID;
};
typedef struct SoundComponentLink SoundComponentLink;
typedef SoundComponentLink *SoundComponentLinkPtr;*/
struct SoundComponentLink {
   ComponentDescription       description;
   SoundSource                mixerID;
   SoundSource *              linkID;
};
typedef struct SoundComponentLink SoundComponentLink;
typedef SoundComponentLink *SoundComponentLinkPtr;

/*Constants
Component Types and Subtypes
enum {
   kSoundEffectsType                   = 'snfx'
};
enum {
   kReverbSubType                      = 'revb',
   kSSpLocalizationSubType             = 'snd3'
};*/
enum {
   kSoundEffectsType                   = 'snfx'
};
enum {
   kReverbSubType                      = 'revb',
   kSSpLocalizationSubType             = 'snd3'
};

/*Sound Channel Information Selectors
enum {
   siPreMixerSoundComponent            = 'prmx',
   siSSpCPULoadLimit                   = '3dll',
   siSSpSetup                          = '3dst',
   siSSpLocalization                   = '3dif',
   siSSpFilterVersion                  = '3dfv'
};*/
enum {
   siPreMixerSoundComponent            = 'prmx',
   siSSpCPULoadLimit                   = '3dll',
   siSSpSetup                          = '3dst',
   siSSpLocalization                   = '3dif',
   siSSpFilterVersion                  = '3dfv'
};

#ifdef __cplusplus
}
#endif

#endif 

