#ifndef PPCTOOLBOX_H
#define PPCTOOLBOX_H


#ifndef  MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef APPLETALK_H
#include <AppleTalk.h>
#endif


#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Data Types
typedef unsigned char PPCServiceType;        /service type/
typedef short PPCLocationKind;               /look-up type/
typedef short PPCPortKinds;                  /port type/
typedef unsigned char PPCSessionOrigin;      /local or remote/
typedef short PPCPortRefNum;                 /port reference number/
typedef long PPCSessRefNum;                  /session reference number/

struct PPCPortRec {
   ScriptCode nameScript;                    /script identifier/
   Str32 name;                               /port name shown in program /
                                             / linking dialog box/
   PPCPortKinds portKindSelector;            /general category of /
                                             / application/
   union
      Str32 portTypeStr;                     /32 characters/
      struct
         OSType creator;                     /4-character creator and /
         OSType type;                        / type/
         } port;
      } u;
};
typedef struct PPCPortRec PPCPortRec;
typedef PPCPortRec PPCPortPtr;

struct LocationNameRec {
   PPCLocationKind locationKindSelector;     /which variant/
   union {                                
      EntityName  nbpEntity;                 /NBP name entity/
      Str32       nbpType;                   /just the NBP type string /
                                             / for the PPCOpen function/
      } u;
};

typedef struct LocationNameRec LocationNameRec;
typedef LocationNameRec LocationNamePtr;

struct PortInfoRec {
   unsigned char  filler1;                   /space holder/
   Boolean        authRequired;              /authentication required/
   PPCPortRec     name;                      /port name/
};
typedef struct PortInfoRec PortInfoRec;
typedef PortInfoRec PortInfoPtr;

typedef PortInfoRec PortInfoArrayPtr;
typedef pascal Boolean (PPCFilterProcPtr) (LocationNamePtr, PortInfoPtr);
/procedures you need to write/
/ex: void MyCompletionRoutine(PPCParamBlkPtr pb)/
/ex: pascal Boolean MyPortFilter(LocationNamePtr, PortInfoPtr)/
typedef ProcPtr PPCCompProcPtr;

#define PPCHeader \
   Ptr               qLink;                  /private/
   unsigned short    csCode;                 /private/
   unsigned short    intUse;                 /private/
   Ptr               intUsePtr;              /private/
   PPCCompProcPtr    ioCompletion;           /address of a /
                                             / completion routine/
   OSErr             ioResult;               /completion of operation/
   unsigned long     Reserved[5];            /private/

struct PPCOpenPBRec {
   PPCHeader
   PPCPortRefNum  portRefNum;                /PPC port identifier/
   long           filler1;                   /space holder/
   PPCServiceType serviceType;               /real time only/
   unsigned char  resFlag;                   /reserved field/
   PPCPortPtr     portName;                  /name of port to be opened/
   LocationNamePtr locationName;             /location of port to be /
                                             / opened/
   Boolean        networkVisible;            /port is visible for /
                                             / browsing/
   Boolean        nbpRegistered;             /location name registered /
                                             / on network/
};

typedef struct PPCOpenPBRec PPCOpenPBRec;
typedef PPCOpenPBRec PPCOpenPBPtr;

struct PPCInformPBRec {
   PPCHeader
   PPCPortRefNum     portRefNum;             /port identifier/
   PPCSessRefNum     sessRefNum;             /session identifier/
   PPCServiceType    serviceType;            /real time only/
   Boolean           autoAccept;             /automatic session acceptance/
   PPCPortPtr        portName;               /name of port that /
                                             / initiated a session/
   LocationNamePtr   locationName;           /location of port that /
                                             / initiated a session/
   StringPtr         userName;               /name of user that / 
                                             / initiated a session/
   unsigned long     userData;               /application-defined/
   PPCSessionOrigin  requestType;            /local or remote/
};

typdef struct PPCInformPBRec PPCInformPBPtr;

struct PPCStartPBRec {
   PPCHeader
   PPCPortRefNum     portRefNum;          /identifier for requested /
                                          / port/
   PPCSessRefNum     sessRefNum;          /session identifier/
   PPCServiceType    serviceType;         /real time only/
   unsigned char     resFlag;             /reserved field/
   PPCPortPtr        portName;            /name of port to be opened/
   LocationNamePtr   locationName;        /location of port to be opened/
   unsigned long     rejectInfo;          /rejection of session/
   unsigned long     userData;            /application-specific/
   unsigned long     userRefNum;          /specifies an authenticated user/
};

typedef struct PPCStartPBRec PPCStartPBRec;
typedef PPCStartPBRec PPCStartPBPtr;

struct PPCAcceptPBRec {
      PPCHeader
      short          filler1;             /space holder/
      PPCSessRefNum  sessRefNum;          /session identifier/
};

typedef struct PPCAcceptPBRec PPCAcceptPBRec;
typedef PPCAcceptPBRec PPCAcceptPBPtr;

struct PPCRejectPBRec {
      PPCHeader
      short          filler1;             /space holder/
      PPCSessRefNum  sessRefNum;          /session identifier/
      short          filler2;             /space holder/
      long           filler3;             /space holder/
      long           filler4;             /space holder/
      unsigned long  rejectInfo;          /rejection of session/
};

typedef struct PPCRejectPBRec PPCRejectPBRec;
typedef PPCRejectPBRec PPCRejectPBPtr;

struct PPCWritePBRec {
   PPCHeader
   short          filler1;                /space holder/
   PPCSessRefNum  sessRefNum;             /session identifier/
   Size           bufferLength;           /length of buffer to be written/
   Size           actualLength;           /actual size of data written/
   Ptr            bufferPtr;              /location of buffer to be /
                                          / written/
   Boolean        more;                   /additional data to be written/
   unsigned char  filler2;                /space holder/
   unsigned long  userData;               /application-specific/
   OSType         blockCreator;           /creator of block to be written/
   OSType         blockType;              /type of block to be written/
};

typedef struct PPCWritePBRec PPCWritePBRec;
typedef PPCWritePBRec PPCWritePBPtr;

struct PPCReadPBRec {
   PPCHeader
   short          filler1;                /space holder/
   PPCSessRefNum  sessRefNum;             /session identifier/
   Size           bufferLength;           /length of buffer to be read/
   Size           actualLength;           /actual size of the data read/
   Ptr            bufferPtr;              /location of buffer to be read/
   Boolean        more;                   /additional data to be read/
   unsigned char  filler2;                /space holder/
   unsigned long  userData;               /application-specific/
   OSType         blockCreator;           /creator of block to be read/
   OSType         blockType;              /type of block to be read/
};

typedef struct PPCReadPBRec PPCReadPBRec;
typdef PPCReadPBRec PPCReadPBPtr;
struct PPCEndPBRec {
   PPCHeader
   short          filler1;                /space holder/
   PPCSessRefNum  sessRefNum;             /identifier of session to /
                                          / be terminated/
};

typedef struct PPCEndPBRec PPCEndPBRec;
typedef PPCEndPBRec PPCEndPBPtr;

struct PPCClosePBRec {
   PPCHeader
   PPCPortRefNum  portRefNum;             /identifier of port to / 
                                          / be closed/
};

typedef struct PPCClosePBRec PPCClosePBRec;
typedef PPCClosePBRec PPCClosePBPtr;

struct IPCListPortsPBRec {
   PPCHeader
   short             filler1;             /space holder/
   unsigned short    startIndex;          /index to the port entry list/ 
   unsigned short    requestCount;        /number of entries to /
                                          / be returned/
   unsigned short    actualCount;         /actual number of port names/
   PPCPortPtr        portName;            /list of port names/ 
   LocationNamePtr   locationName;        /location of port names/
   PortInfoArrayPtr  bufferPtr;           /pointer to a buffer/
};
typedef struct IPCListPortsPBRec IPCListPortsPBRec;
typedef IPCListPortsPBRec IPCListPortsPBPtr;

union PPCParamBlockRec {
   PPCOpenPBRec      openParam;           /PPCOpen params/
   PPCInformPBRec    informParam;         /PPCInform params/
   PPCStartPBRec     startParam;          /PPCStart params/
   PPCAcceptPBRec    acceptParam;         /PPCAccept params/
   PPCRejectPBRec    rejectParam;         /PPCReject params/
   PPCWritePBRec     writeParam;          /PPCWrite params/
   PPCReadPBRec      readParam;           /PPCRead params/
   PPCEndPBRec       endParam;            /PPCEnd params/
   PPCClosePBRec     closeParam;          /PPCClose params/
   IPCListPortsPBRec listPortsParam;      /IPCListPorts params/
};

typdef union PPCParamBlockRec PPCParamBlockRec;
typdef PPCParamBlockRec *PPCParamBlockPtr;
PPC Toolbox Routines*/

typedef short PPCLocationKind;               //ook-up type
typedef short PPCPortKinds;                  //port type

struct PPCPortRec {
   ScriptCode nameScript;                    //script identifier
   Str32 name;                               //port name shown in program 
                                             //linking dialog box
   PPCPortKinds portKindSelector;            //general category of 
                                             // application
   union{
      Str32 portTypeStr;                     //32 characters
      struct{
         OSType creator;                     //4-character creator and 
         OSType type;                        //type/
         } port;
      } u;
};
typedef struct PPCPortRec PPCPortRec;
typedef PPCPortRec PPCPortPtr;


struct PortInfoRec {
   unsigned char  filler1;                   //space holder
   Boolean        authRequired;              //authentication required
   PPCPortRec     name;                      //port name
};
typedef struct PortInfoRec PortInfoRec;
typedef PortInfoRec PortInfoPtr;

struct LocationNameRec {
   PPCLocationKind locationKindSelector;     //which variant
   union {                                
      EntityName  nbpEntity;                 //NBP name entity
      Str32       nbpType;                   //just the NBP type string 
                                             // for the PPCOpen function
      } u;
};

typedef struct LocationNameRec LocationNameRec;
typedef LocationNameRec LocationNamePtr;

typedef pascal Boolean (PPCFilterProcPtr) (LocationNamePtr, PortInfoPtr);

//function

/*Using the Program Linking Dialog Box
pascal OSErr PPCBrowser(ConstStr255Param prompt, 
ConstStr255Param applListLabel, 
Boolean defaultSpecified, 
LocationNameRec *theLocation, 
PortInfoRec *thePortInfo, 
PPCFilterProcPtr portFilter, 
ConstStr32Param theLocNBPType);*/
pascal OSErr PPCBrowser(ConstStr255Param prompt, 
ConstStr255Param applListLabel, 
Boolean defaultSpecified, 
LocationNameRec *theLocation, 
PortInfoRec *thePortInfo, 
PPCFilterProcPtr portFilter, 
ConstStr32Param theLocNBPType);

#ifdef __cplusplus
}
#endif

#endif 

