#ifndef CGIMAGEPROPERTIES_H
#define CGIMAGEPROPERTIES_H

#include <CoreFoundation/CoreFoundation.h>

/*kCGImagePropertyTIFFDictionary Keys

Define possible keys for kCGImagePropertyTIFFDictionary.

const CFStringRef kCGImagePropertyTIFFCompression
const CFStringRef kCGImagePropertyTIFFPhotometricInterpretation
const CFStringRef kCGImagePropertyTIFFDocumentName
const CFStringRef kCGImagePropertyTIFFImageDescription
const CFStringRef kCGImagePropertyTIFFMake
const CFStringRef kCGImagePropertyTIFFModel
const CFStringRef kCGImagePropertyTIFFOrientation
const CFStringRef kCGImagePropertyTIFFXResolution
const CFStringRef kCGImagePropertyTIFFYResolution
const CFStringRef kCGImagePropertyTIFFResolutionUnit
const CFStringRef kCGImagePropertyTIFFSoftware
const CFStringRef kCGImagePropertyTIFFTransferFunction
const CFStringRef kCGImagePropertyTIFFDateTime
const CFStringRef kCGImagePropertyTIFFArtist
const CFStringRef kCGImagePropertyTIFFHostComputer
const CFStringRef kCGImagePropertyTIFFCopyright
const CFStringRef kCGImagePropertyTIFFWhitePoint
const CFStringRef kCGImagePropertyTIFFPrimaryChromaticities
Constants
kCGImagePropertyTIFFCompression

Specifies TIFF compression.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFPhotometricInterpretation

Specifies TIFF photometric interpretation.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFDocumentName

Specifies the TIFF document name.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFImageDescription

Specifies a TIFF image description.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFMake

Specifies a TIFF make.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFModel

Specifies a TIFF model.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFOrientation

Specifies TIFF orientation.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFXResolution

Specifies the x resolution of the TIFF.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFYResolution

Specifies the y resolution of the TIFF. 

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFResolutionUnit

Specifies the units of resolution.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFSoftware

Specifies the TIFF software.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFTransferFunction

Specifies the TIFF transfer function.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFDateTime

Specifies the TIFF date and time.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFArtist

Specifies the artist.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFHostComputer

Specifies the host computer.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFCopyright

Specifies copyright information.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFWhitePoint

Specifies the white point.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFPrimaryChromaticities

Specifies the primary chromaticities.

Available in Mac OS X v10.4 and later.*/

extern const CFStringRef kCGImagePropertyTIFFCompression;
extern const CFStringRef kCGImagePropertyTIFFPhotometricInterpretation;
extern const CFStringRef kCGImagePropertyTIFFDocumentName;
extern const CFStringRef kCGImagePropertyTIFFImageDescription;
extern const CFStringRef kCGImagePropertyTIFFMake;
extern const CFStringRef kCGImagePropertyTIFFModel;
extern const CFStringRef kCGImagePropertyTIFFOrientation;
extern const CFStringRef kCGImagePropertyTIFFXResolution;
extern const CFStringRef kCGImagePropertyTIFFYResolution;
extern const CFStringRef kCGImagePropertyTIFFResolutionUnit;
extern const CFStringRef kCGImagePropertyTIFFSoftware;
extern const CFStringRef kCGImagePropertyTIFFTransferFunction;
extern const CFStringRef kCGImagePropertyTIFFDateTime;
extern const CFStringRef kCGImagePropertyTIFFArtist;
extern const CFStringRef kCGImagePropertyTIFFHostComputer;
extern const CFStringRef kCGImagePropertyTIFFCopyright;
extern const CFStringRef kCGImagePropertyTIFFWhitePoint;
extern const CFStringRef kCGImagePropertyTIFFPrimaryChromaticities;


/*Format-Specific Dictionaries

Specifies keys for dictionaries that contain a dictionary of file-format or metadata-format specific key-values.

CFStringRef kCGImagePropertyTIFFDictionary
CFStringRef kCGImagePropertyGIFDictionary
CFStringRef kCGImagePropertyJFIFDictionary
CFStringRef kCGImagePropertyExifDictionary
CFStringRef kCGImagePropertyPNGDictionary
CFStringRef kCGImagePropertyIPTCDictionary
CFStringRef kCGImagePropertyGPSDictionary
CFStringRef kCGImagePropertyRawDictionary
CFStringRef kCGImagePropertyCIFFDictionary
CFStringRef kCGImageProperty8BIMDictionary
Constants
kCGImagePropertyTIFFDictionary

Specifies a dictionary of key-value pairs for a TIFF image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyGIFDictionary

Specifies a dictionary of key-value pairs for a GIF image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyJFIFDictionary

Specifies a dictionary of key-value pairs for a JFIF image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyExifDictionary

Specifies a dictionary of key-value pairs for a Exif image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPNGDictionary

Specifies a dictionary of key-value pairs for a PNG image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyIPTCDictionary

Specifies a dictionary of key-value pairs for a IPTC image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyGPSDictionary

Specifies a dictionary of key-value pairs for a GPS image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyRawDictionary

Specifies a dictionary of key-value pairs for a Raw image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyCIFFDictionary

Specifies a dictionary of key-value pairs for a CIFF image.

Available in Mac OS X v10.4 and later.
kCGImageProperty8BIMDictionary

Specifies a dictionary of key-value pairs for an 8BIM image.

Available in Mac OS X v10.4 and later.
Discussion

Format-specific are returned by the functions CGImageSourceCopyPropertiesor CGImageSourceCopyPropertiesAtIndex and contain key-value pairs that describe file-format or metadata-format information.*/

extern const CFStringRef kCGImagePropertyTIFFDictionary;
extern const  CFStringRef kCGImagePropertyGIFDictionary;
extern const  CFStringRef kCGImagePropertyJFIFDictionary;
extern const  CFStringRef kCGImagePropertyExifDictionary;
extern const CFStringRef kCGImagePropertyPNGDictionary;
extern const CFStringRef kCGImagePropertyIPTCDictionary;
extern const CFStringRef kCGImagePropertyGPSDictionary;
extern const CFStringRef kCGImagePropertyRawDictionary;
extern const CFStringRef kCGImagePropertyCIFFDictionary;
extern const CFStringRef kCGImageProperty8BIMDictionary;


/*Image Source Container Properties

Define properties that apply to the container in general but not necessarily to any individual image in the container.

CFStringRef kCGImagePropertyFileSize;
Constants
kCGImagePropertyFileSize

The size of the image file in bytes, if known. If present, this key is a CFNumber value. 

Available in Mac OS X v10.4 and later.
Discussion

These properties can be returned by the function CGImageSourceCopyProperties.*/
extern const CFStringRef kCGImagePropertyFileSize;

#endif