#ifndef IOMEDIA_H
#define IOMEDIA_H

#include <IOKit/IOTypes.h>
#include <APPLE/IOKit/storage/IOMedia.h>

/*kIOMediaEjectableKey


A property of IOMedia objects.
#define kIOMediaEjectableKey "Ejectable" 
Discussion 

The kIOMediaEjectableKey property has an OSBoolean value and describes whether the media is ejectable from the drive mechanism under software control. Implies IOMediaRemovable is also true.*/
#define kIOMediaEjectableKey "Ejectable" 

/*kIOMediaClass


The name of the IOMedia class. 
#define kIOMediaClass "IOMedia" */
#define kIOMediaClass "IOMedia"

/*kIOMediaWholeKey


A property of IOMedia objects.
#define kIOMediaWholeKey "Whole" 
Discussion 

The kIOMediaWholeKey property has an OSBoolean value and describes whether the media is whole, that is, it represents the whole disk (the physical disk, or a virtual replica thereof).*/
#define kIOMediaWholeKey "Whole" 

#ifdef __cplusplus
#include <IOKit/storage/IOStorage.h>

class IOMedia : public IOStorage
{
   OSDeclareDefaultStructors(IOMedia)

public:
/*getSize

public

virtual UInt64 getSize() const; 
Return Value

Media size, in bytes. 
Discussion 

Ask the media object for its total length in bytes.*/
virtual UInt64 getSize() const; 

/*isEjectable

public

virtual bool isEjectable() const; 
Return Value

Returns true if the media is ejectable, false otherwise. 
Discussion 

Ask the media object whether it is ejectable.*/
virtual bool isEjectable() const; 

/*isWritable

public

virtual bool isWritable() const; 
Return Value

Returns true if the media is writable, false otherwise. 
Discussion 

Ask the media object whether it is writable.*/
virtual bool isWritable() const; 

/*write

public

virtual void write(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion); 
Parameters
client
Client requesting the write.
byteStart
Starting byte offset for the data transfer.
buffer
Buffer for the data transfer. The size of the buffer implies the size of the data transfer.
completion
Completion routine to call once the data transfer is complete.
Discussion 

Write data into the storage object at the specified byte offset from the specified buffer, asynchronously. When the write completes, the caller will be notified via the specified completion action.
The buffer will be retained for the duration of the write.*/
virtual void write(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion); 

/*read

public

virtual void read(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion); 
Parameters
client
Client requesting the read.
byteStart
Starting byte offset for the data transfer.
buffer
Buffer for the data transfer. The size of the buffer implies the size of the data transfer.
completion
Completion routine to call once the data transfer is complete.
Discussion 

Read data from the storage object at the specified byte offset into the specified buffer, asynchronously. When the read completes, the caller will be notified via the specified completion action.
The buffer will be retained for the duration of the read.*/
virtual void read(
    IOService *client, 
    UInt64 byteStart, 
    IOMemoryDescriptor *buffer, 
    IOStorageCompletion completion); 

/*synchronizeCache

public

virtual IOReturn synchronizeCache(
    IOService *client); 
Parameters
client
Client requesting the cache synchronization.
Return Value

Returns the status of the cache synchronization. 
Discussion 

Flush the cached data in the storage object, if any, synchronously.*/
virtual IOReturn synchronizeCache(
    IOService *client); 

/*getPreferredBlockSize

public

virtual UInt64 getPreferredBlockSize() const; 
Return Value

Natural block size, in bytes. 
Discussion 

Ask the media object for its natural block size. This information is useful to clients that want to optimize access to the media.*/
virtual UInt64 getPreferredBlockSize() const; 

/*init

public

virtual bool init(
    UInt64 base, 
    UInt64 size, 
    UInt64 preferredBlockSize, 
    IOMediaAttributeMask attributes, 
    bool isWhole, 
    bool isWritable, 
    const char *contentHint = 0, 
    OSDictionary *properties = 0); 
Parameters
base
Media offset, in bytes.
size
Media size, in bytes.
preferredBlockSize
Natural block size, in bytes.
attributes
Media attributes, such as ejectability and removability. See IOMediaAttributeMask.
isWhole
Indicates whether the media represents the whole disk.
isWritable
Indicates whether the media is writable.
contentHint
Hint of media's contents (optional). See getContentHint().
properties
Substitute property table for this object (optional).
Return Value

Returns true on success, false otherwise. 
Discussion 

Initialize this object's minimal state.*/
virtual bool init(
    UInt64 base, 
    UInt64 size, 
    UInt64 preferredBlockSize, 
    IOMediaAttributeMask attributes, 
    bool isWhole, 
    bool isWritable, 
    const char *contentHint = 0, 
    OSDictionary *properties = 0); 

};

#endif
#endif