
#ifndef _IOKIT_IODATAQUEUE_H
#define _IOKIT_IODATAQUEUE_H

#include <libkern/c++/OSObject.h>
#include <libkern/OSTypes.h>
#include <mach/port.h>
#include <mach/message.h>


class IOMemoryDescriptor;
class IODataQueue : public OSObject
{
public:

/*enqueue


Enqueues a new entry on the queue. 
public

virtual Boolean enqueue(
    void *data,
    UInt32 dataSize); 
Parameters
data
Pointer to the data to be added to the queue.
dataSize
Size of the data pointed to by data.
Return Value

Returns true on success and false on failure. Typically failure means that the queue is full. 
Discussion 

This method adds a new data entry of dataSize to the queue. It sets the size parameter of the entry pointed to by the tail value and copies the memory pointed to by the data parameter in place in the queue. Once that is done, it moves the tail to the next available location. When attempting to add a new entry towards the end of the queue and there isn't enough space at the end, it wraps back to the beginning.
If the queue is empty when a new entry is added, sendDataAvailableNotification() is called to send a message to the user process that data is now available.*/
virtual Boolean enqueue(
    void *data,
    UInt32 dataSize); 

/*setNotificationPort


Creates a simple mach message targeting the mach port specified in port. 
public

virtual void setNotificationPort(
    mach_port_t port); 
Parameters
port
The mach port to target with the notification message.
Discussion 

This message is sent when data is added to an empty queue. It is to notify a user process that new data has become available.*/
virtual void setNotificationPort(
    mach_port_t port);

/*getMemoryDescriptor


Returns a memory descriptor covering the IODataQueueMemory region. 
public

virtual IOMemoryDescriptor *getMemoryDescriptor(); 
Return Value

Returns a newly allocated IOMemoryDescriptor for the IODataQueueMemory region. Returns zero on failure. 
Discussion 

The IOMemoryDescriptor instance returned by this method is intended to be mapped into a user process. This is the memory region that the IODataQueueClient code operates on.*/
virtual IOMemoryDescriptor *getMemoryDescriptor(); 

/*withCapacity


Static method that creates a new IODataQueue instance with the capacity specified in the size parameter. 
public

static IODataQueue *withCapacity(
    UInt32 size); 
Parameters
size
The size of the data queue memory region.
Return Value

Returns the newly allocated IODataQueue instance. Zero is returned on failure. 
Discussion 

The actual size of the entire data queue memory region (to be shared into a user process) is equal to the capacity plus the IODataQueueMemory overhead. This overhead value can be determined from the DATA_QUEUE_MEMORY_HEADER_SIZE macro in . The size of the data queue memory region must include space for the overhead of each IODataQueueEntry. This entry overhead can be determined from the DATA_QUEUE_ENTRY_HEADER_SIZE macro in .
This method allocates a new IODataQueue instance and then calls initWithCapacity() with the given size parameter. If the initWithCapacity() fails, the new instance is released and zero is returned.*/
static IODataQueue *withCapacity(
    UInt32 size); 

};

#endif 
