#ifndef  DRCOREBURN_H
#define DRCOREBURN_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef DRCOREOBJECT_H
#include <DiscRecordingEngine/DRCoreObject.h>
#endif

#ifndef DRCORETRACK_H
#include <DiscRecordingEngine/DRCoreTrack.h>
#endif

#ifndef DRCOREDEVICE_H
#include <DiscRecordingEngine/DRCoreDevice.h>
#endif

#ifndef AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DRBurnRef

typedef struct __DRBurn* DRBurnRef;  
Discussion 

A reference to DRBurn instances.*/
typedef struct __DRBurn* DRBurnRef;  

/*kDRBurnStatusChangedNotification

extern const CFStringRef kDRBurnStatusChangedNotification ;  
Discussion 

The notification sent when a DRBurn object has updated status. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRBurnStatusChangedNotification ;  

//func

/*DRBurnWriteLayout


Writes the specified track layout to disc. 
extern OSStatus DRBurnWriteLayout(
    DRBurnRef burn,
    CFTypeRef layout) ;  
Parameters
burn
The burn that should be started. If this parameter is not a valid DRBurn object, the behavior is undefined.
layout
An object describing the layout of the data on disc. The most common layout consists of a CFArray object whose elements are DRTrack objects. The other layout options are a lone DRTrack object, and a CFArray of homogeneous CFArrays of DRTracks. If the layout is not one of these kinds, or if any of the objects is not valid, this function's behavior is undefined.
Return Value

An error code indicating if the burn could begin. 
Discussion 

The object passed into this function describes the layout of the disc. There are three possible layout configurations: 
For a multisession burn, the layout must be a valid CFArray object containing multiple CFArrays, each of which contains one or more valid DRTrack objects.
For a single-session, multitrack burn, the layout must be a valid CFArray object containing one or more valid DRTrack objects.
For a single-session, single-track burn, the layout must be a valid DRTrack object.
If either of these configurations are not met or the values contained in the array(s) are not valid DRTrack objects, the behavior is undefined. 
Availability
Introduced in Mac OS X v10.2*/
extern OSStatus DRBurnWriteLayout(
    DRBurnRef burn,
    CFTypeRef layout) ;  

/*DRBurnCreate


Creates a new burn. 
extern DRBurnRef DRBurnCreate(
    DRDeviceRef device) ;  
Parameters
device
A reference to the device to burn to. If this parameter is not a valid DRDevice, the behavior is undefined.
Return Value

Returns reference to a new DRBurn instance. 
Availability
Introduced in Mac OS X v10.2*/
extern DRBurnRef DRBurnCreate(
    DRDeviceRef device) ;  


#ifdef __cplusplus
}
#endif

#endif 
