#ifndef ATSTYPES_H
#define ATSTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Invalid Values

Specify an invalid value.

enum {
   kInvalidGeneration = 0,
   kInvalidFontFamily = -1,
   kInvalidFont = 0
};

Constants
kInvalidGeneration

Indicates an invalid generation value.

Available in Mac OS X v10.0 and later.
kInvalidFontFamily

Indicates the font family reference is invalid.

Available in Mac OS X v10.0 and later.
kInvalidFont

Indicates the font reference is invalid.

Available in Mac OS X v10.0 and later.
Discussion

The kInvalidGeneration, kInvalidFontFamily, and kInvalidFont constants may be used to indicate invalid values for generation count, font family, and font data types*/
enum {
   kInvalidGeneration = 0,
   kInvalidFontFamily = -1,
   kInvalidFont = 0
};


/*Convenience Constants

Represent numerical values that are commonly used in font calculations.

enum {
   kATSItalicQDSkew = (1 << 16) / 4,
   kATSBoldQDStretch = (1 << 16) * 3 / 2,
   kATSRadiansFactor = 1144
};
Constants
kATSItalicQDSkew

A Fixed value of 0.25 that represents the skew used by QuickDraw to draw italicized glyphs.

Available in Mac OS X v10.0 and later.
kATSBoldQDStretch

A Fixed value that represents the stretch-factor used by QuickDraw to draw bold-faced glyphs. 

Available in Mac OS X v10.0 and later.
kATSRadiansFactor

A Fixed value of approximately pi/180(0.0174560546875) that represents an angle of 1 radian. This is a convenience constant you can use when you draw rotated text.

Available in Mac OS X v10.0 and later.
Discussion

These constants are provided for convenience. Your application can use them when it needs to perform font calculations.
Version Notes

Available beginning with ATSUI 1.0.*/
enum {
   kATSItalicQDSkew = (1 << 16) / 4,
   kATSBoldQDStretch = (1 << 16) * 3 / 2,
   kATSRadiansFactor = 1144
};

/*Deleted Glyph Code

Specifies that a glyph is deleted.

enum {
   kATSDeletedGlyphcode = 0xFFFF
};
Constants
kATSDeletedGlyphcode

Indicates that a glyph is deleted. That is, the glyph is set to no longer appear in a text layout.

Available in Mac OS X v10.2 and later.
Discussion

This constant is used by ATSUI. When a glyph is deleted, ATSUI sets the corresponding ATSGlyphRef to kATSDeletedGlyphcode. For more information, see Inside Mac OS X: ATSUI Reference.*/
enum {
   kATSDeletedGlyphcode = 0xFFFF
};


/*ATSGlyphRef

Represents a glyph reference.

typedef UInt16 ATSGlyphRef;
Discussion

This data type is used in the ATSUI data structure ATSLayoutRecord. For information, see Inside Mac OS X: ATSUI Reference.
Availability
Available in Mac OS X v10.0 and later.*/

typedef UInt16 ATSGlyphRef;

/*FMFont

An opaque data type that specifies a font registered with the font database. 

typedef UInt32 FMFont;
Discussion

You should not modify this value. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FMFont;

/*FMFontFamily

A reference to a collection of fonts with the same design characteristics.

typedef SInt16 FMFontFamily;
Discussion

The font family reference replaces the QuickDraw font ID and can be used with all QuickDraw functions including GetFontName and TextFont. Unlike the QuickDraw font identifier, the font family reference cannot be passed to the Resource Manager to access information from a 'FOND' resource. A font family reference does not imply a script system, nor is the character encoding of a font family determined by an arithmetic mapping of the font family reference. 

The fonts associated with a font family consist of individual outline fonts that may be used with the font access functions of the Font Manager and ATSUI. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FMFontFamily;

/*FMFontStyle

Represents a font style.

typedef SInt16 FMFontStyle;
Discussion

The low 8 bits of a Font Manager font style correspond to a QuickDraw style. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FMFontStyle;

/*Curve Types

Specify a curve type used to draw a font.

typedef UInt16 ATSCurveType;
enum {
   kATSCubicCurveType = 0x0001,
   kATSQuadCurveType = 0x0002,
   kATSOtherCurveType = 0x0003
};
Constants
kATSCubicCurveType

Specifies a cubic curve.

Available in Mac OS X v10.0 and later.
kATSQuadCurveType

Specifies a quadratic curve.

Available in Mac OS X v10.0 and later.
kATSOtherCurveType

Specifies a curve other than cubic or quadratic. 

Available in Mac OS X v10.0 and later.
Discussion

These are used in the ATSUI function ATSUGetNativeCurveType. See Inside Mac OS X: ATSUI Reference for more information.*/
typedef UInt16 ATSCurveType;
enum {
   kATSCubicCurveType = 0x0001,
   kATSQuadCurveType = 0x0002,
   kATSOtherCurveType = 0x0003
};

/*GlyphID

Represents a reference to a glyph.

typedef ATSGlyphRef GlyphID;

Discussion

The GlyphID data type is used by ATSUI. For more information, see Inside Mac OS X: ATSUI Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef ATSGlyphRef GlyphID;

#ifdef __cplusplus
}
#endif

#endif