#ifndef ATSLAYOUTTYPES_H
#define ATSLAYOUTTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef SFNTLAYOUTTYPES_H
#include <ATS/SFNTLayoutTypes.h>
#endif

#ifndef ATSTYPES_H
#include <ATS/ATSTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Line Layout Attribute Tags

Specify line layout attributes to be applied at the line level.

typedef UInt32 ATSLineLayoutOptions;
enum {
   kATSLineNoLayoutOptions       = 0x00000000,
   kATSLineIsDisplayOnly         = 0x00000001,
   kATSLineHasNoHangers          = 0x00000002,
   kATSLineHasNoOpticalAlignment = 0x00000004,
   kATSLineKeepSpacesOutOfMargin = 0x00000008,
   kATSLineNoSpecialJustification = 0x00000010,
   kATSLineLastNoJustification   = 0x00000020,
   kATSLineFractDisable          = 0x00000040,
   kATSLineImposeNoAngleForEnds  = 0x00000080,
   kATSLineFillOutToWidth        = 0x00000100,
   kATSLineTabAdjustEnabled      = 0x00000200,
   kATSLineIgnoreFontLeading     = 0x00000400,
   kATSLineApplyAntiAliasing     = 0x00000800,
   kATSLineNoAntiAliasing        = 0x00001000,
   kATSLineDisableNegativeJustification = 0x00002000,
   kATSLineDisableAutoAdjustDisplayPos = 0x00004000,
   kATSLineUseQDRendering        = 0x00008000,
   kATSLineDisableAllJustification = 0x00010000,
   kATSLineDisableAllGlyphMorphing = 0x00020000,
   kATSLineDisableAllKerningAdjustments = 0x00040000,
   kATSLineDisableAllBaselineAdjustments = 0x00080000,
   kATSLineDisableAllTrackingAdjustments = 0x00100000,
   kATSLineDisableAllLayoutOperations = kATSLineDisableAllJustification
|
   kATSLineDisableAllGlyphMorphing |
   kATSLineDisableAllKerningAdjustments |
   kATSLineDisableAllBaselineAdjustments |
   kATSLineDisableAllTrackingAdjustments,
   kATSLineUseDeviceMetrics      = 0x01000000,
   kATSLineBreakToNearestCharacter = 0x02000000,
   kATSLineAppleReserved         = (unsigned long)xFCE00000};
Constants
kATSLineNoLayoutOptions

Specifies not to apply any options.

Available i n ATSUI 1.0 and later.
kATSLineIsDisplayOnly

This line option is no longer used. Instead use kATSLineUseDeviceMetrics.

Available in Mac OS X v10.0 and later.
kATSLineHasNoHangers

Specifies not to form hanging punctuation on the line. If the bit specified by this mask is set, the automatic hanging punctuation in the text layout object is overridden. The value in this bit overrides any adjustment to hanging punctuation set for a style run inside the text layout object using the style run attribute tags kATSUForceHangingTag or kATSUHangingInhibitFactorTag.

Available in ATSUI 1.0 and later.
kATSLineHasNoOpticalAlignment

Specifies not to perform optical alignment on the line. Optical alignment adjusts characters at the text margin so that they appear to be properly aligned; strict alignment can often cause the illusion of a ragged edge. The value in this bit overrides any adjustment to optical alignment set for a style run inside the text layout object using the style run attribute tag kATSUNoOpticalAlignmentTag.

Available in ATSUI 1.0 and later.
kATSLineKeepSpacesOutOfMargin

Specifies that the trailing white spaces at the end of a line of justified text should be placed outside the margin.

Available in ATSUI 1.0 and later.
kATSLineNoSpecialJustification

Specifies not to perform post-compensation justification on the line, even if such processing is necessary. This flag cannot be set for a single line of a text layout object. The value in this bit overrides any adjustment to the postcompensation actions set for a style run using the style run attribute tag kATSUNoSpecialJustificationTag.

Available in ATSUI 1.0 and later.
kATSLineLastNoJustification

Specifies not to justify a line if it is the last line of a justified text layout object. This flag is meaningless when setting a line’s text layout attributes.

Available in ATSUI 1.0 and later.
kATSLineFractDisable

Specifies to position of the text in the line or text layout object relative to fractional absolute positions, which are uncorrected for device display. This provides the ideal position of laid-out text and is useful for scaling text onscreen. This origin is also used to get the width of the typographic bounding rectangle when you call the function ATSUGetUnjustifiedBounds.

Available in ATSUI 1.1 and later.
kATSLineImposeNoAngleForEnds

Specifies to draw the carets on the far right and left sides of an unrotated line as vertical, no matter what the angle of text.

Available in ATSUI 1.1 and later.
kATSLineFillOutToWidth

Specifies to extend highlighting to both ends of a line, regardless of caret locations. This option does not effect the caret locations. This is provided for your convenience to extend your highlighting to the full width of the line.

Available in ATSUI 1.1 and later.
kATSLineTabAdjustEnabled

Specifies to automatically adjust the tab character width so that it fits the specified line width. If you are using ATSUI’s tab functions—ATSUSetTabArray and ATSUGetTabArray to define a tab rule you do not need to use this selector. The selector is useful if you are handling your own tabs and only applies if the tab is at the end of a line (backing store). You must set this bit to ensure that highlighting is done correctly across tab stops. To ensure this, you should also set the bit specified by the kATSLineImposeNoAngleForEnds mask constant.

Available in ATSUI 1.2 and later.
kATSLineIgnoreFontLeading

Specifies to ignore any leading value specified by a font.

Available in ATSUI 2.3 and later.
kATSLineApplyAntiAliasing

Specifies that Apple Type Services should produce antialiased glyph images even if system preferences or Quartz settings indicate otherwise.

Available in Mac OS X v10.2 and later.
kATSLineNoAntiAliasing

Specifies that Apple Type Services should turn-off antialiasing glyph imaging even if system preferences or Quartz settings indicate otherwise. This option negates the kATSLineApplyAntiAliasing bit if it is set.

Available in Mac OS X v10.2 and later.
kATSLineDisableNegativeJustification

Specifies to allow glyph positions to extend beyond the line's assigned width if the line width is not sufficient to hold all its glyphs. This ensures that negative justification is not used.

Available in Mac OS X v10.2 and later.
kATSLineDisableAutoAdjustDisplayPos

Specifies not to automatically adjust individual character positions when rendering lines that have any integer glyph positioning, whether the integer glyph positioning is due to non-antialiased characters or though the use of the selector kATSLineFractDisable.

Available in Mac OS X v10.2 and later.
kATSLineUseQDRendering

Specifies to use QuickDraw to render a line of text instead of the default ATSUI rendering. With Mac OS X version 10.2, ATSUI renders text through Quartz, even if you do not attach a CGContext to a text layout object. In the default case, ATSUI retrieves the internal canonical CGContext of the current port, and renders to that port using Quartz at an antialiasing setting that simulates QuickDraw rendering. That is, a 4-bit pixel-aligned antialiasing. Because the default setting gives you simulated QuickDraw rendering, you should use the tag kATSLineUseQDRendering only if you must have backward compatibility. With Mac OS X version 10.3, this option no longer does anything different from not declaring a CGContext.

Available in Mac OS X v10.2 and later.
kATSLineDisableAllJustification

Specifies not to perform any justification operations on the line.

Available in Mac OS X v10.2 and later.
kATSLineDisableAllGlyphMorphing

Specifies not to perform any glyph-morphing operations on the line.

Available in Mac OS X v10.2 and later.
kATSLineDisableAllKerningAdjustments

Specifies not to perform any kerning-adjustment operations on the line.

Available in Mac OS X v10.2 and later.
kATSLineDisableAllBaselineAdjustments

Specifies not to perform any baseline-adjustment operations on the line.

Available in Mac OS X v10.2 and later.
kATSLineDisableAllTrackingAdjustments

Specifies not to perform any tracking-adjustment operations on the line.

Available in Mac OS X v10.2 and later.
kATSLineDisableAllLayoutOperations

Specifies to turn off all layout adjustments for this line.

Available in Mac OS X v10.2 and later.
kATSLineUseDeviceMetrics

Specifies to used rounded device metrics instead of fractional path metrics. This optimizes display of text and should be used only in cases in which the text is displayed onscreen as opposed to printed or output to PDF. If you use this option to display text onscreen as well as to print or create a PDF, you will get different results between the two types of output. This attribute is not recommended for Quartz anit-aliased text.

Available in Mac OS X v10.2 and later.
kATSLineBreakToNearestCharacter

Specifies that line breaking should occur at the nearest character, not word. This could cause a word to be split over multiple lines.

Available in Mac OS X version 10.3 and later.
kATSLineAppleReserved

This selector is reserved by Apple. If you try to use it, ATSUI returns the kATSUInvalidAttributeValueEr result code.

Available in ATSUI 1.1 and later.
Discussion

You can use a constant of type ATSLineLayoutOptions to set or obtain the line layout options in a line of text or for an entire text layout object; see the functions ATSUSetLineControls and ATSUSetLayoutControls, respectively.*/
typedef UInt32 ATSLineLayoutOptions;
enum {
   kATSLineNoLayoutOptions       = 0x00000000,
   kATSLineIsDisplayOnly         = 0x00000001,
   kATSLineHasNoHangers          = 0x00000002,
   kATSLineHasNoOpticalAlignment = 0x00000004,
   kATSLineKeepSpacesOutOfMargin = 0x00000008,
   kATSLineNoSpecialJustification = 0x00000010,
   kATSLineLastNoJustification   = 0x00000020,
   kATSLineFractDisable          = 0x00000040,
   kATSLineImposeNoAngleForEnds  = 0x00000080,
   kATSLineFillOutToWidth        = 0x00000100,
   kATSLineTabAdjustEnabled      = 0x00000200,
   kATSLineIgnoreFontLeading     = 0x00000400,
   kATSLineApplyAntiAliasing     = 0x00000800,
   kATSLineNoAntiAliasing        = 0x00001000,
   kATSLineDisableNegativeJustification = 0x00002000,
   kATSLineDisableAutoAdjustDisplayPos = 0x00004000,
   kATSLineUseQDRendering        = 0x00008000,
   kATSLineDisableAllJustification = 0x00010000,
   kATSLineDisableAllGlyphMorphing = 0x00020000,
   kATSLineDisableAllKerningAdjustments = 0x00040000,
   kATSLineDisableAllBaselineAdjustments = 0x00080000,
   kATSLineDisableAllTrackingAdjustments = 0x00100000,
   kATSLineDisableAllLayoutOperations = kATSLineDisableAllJustification
|
   kATSLineDisableAllGlyphMorphing |
   kATSLineDisableAllKerningAdjustments |
   kATSLineDisableAllBaselineAdjustments |
   kATSLineDisableAllTrackingAdjustments,
   kATSLineUseDeviceMetrics      = 0x01000000,
   kATSLineBreakToNearestCharacter = 0x02000000,
   kATSLineAppleReserved         = (unsigned long)0xFCE00000
};


/*Glyph Origin Selectors

Specify which glyph origin to use to determine the width of the typographic glyph bounds.

enum {
   kATSUseCaretOrigins           = 0,
   kATSUseDeviceOrigins          = 1,
   kATSUseFractionalOrigins      = 2,
   kATSUseOriginFlags            = 3
};
Constants
kATSUseCaretOrigins

Specifies to use the caret origin to determine the width of the typographic glyph bounds. The caret origin is halfway between two characters. 

Available in Mac OS X v10.0 and later.
kATSUseDeviceOrigins

Specifies to use the glyph origin in device space to determine the width of the typographic glyph bounds. This is useful if you need to adjust text on the screen.

Available in Mac OS X v10.0 and later.
kATSUseFractionalOrigins

Specifies to use the glyph origin in fractional absolute positions (which are uncorrected for display device) to determine the width of the typographic glyph bounds. This provides the ideal position of laid-out text and is useful if you need to scale text on the screen. The glyph origin is also used to obtain the width of the typographic bounding rectangle when you call the function ATSUMeasureText.

Available in Mac OS X v10.0 and later.
kATSUseOriginFlags

The number of glyph origin selectors.

Available in Mac OS X v10.0 and later.
Discussion

You can pass a glyph bounds selector in the iTypeOfBounds parameter of the function ATSUGetGlyphBounds to indicate whether the width of the resulting typographic glyph bounds is determined using the caret origin, glyph origin in device space, or glyph origin in fractional absolute positions.*/

enum {
   kATSUseCaretOrigins           = 0,
   kATSUseDeviceOrigins          = 1,
   kATSUseFractionalOrigins      = 2,
   kATSUseOriginFlags            = 3
};


/*ATSTrapezoid

Contains the coordinates of the typographic bounding trapezoid for the final layout of a line a text.

struct ATSTrapezoid {
   FixedPoint upperLeft;
   FixedPoint upperRight;
   FixedPoint lowerRight;
   FixedPoint lowerLeft;
};
Fields
upperLeft

A structure of type FixedPoint that contains the upper left coordinates (assuming a horizontal line of text) of the typographic glyph bounds. 
upperRight

A structure of type FixedPoint that contains the upper right coordinates (assuming a horizontal line of text) of the typographic glyph bounds.
lowerRight

A structure of type FixedPoint that identifies the lower right coordinates (assuming a horizontal line of text) of the typographic glyph bounds.
lowerLeft

A structure of type FixedPoint that identifies the lower left coordinates (assuming a horizontal line of text) of the typographic glyph bounds.
Discussion

The dimensions of the resulting trapezoid are relative to the coordinates specified in the iTextBasePointX and iTextBasePointY parameters. The width of the glyph bounds is determined based on the value passed in the iTypeOfBounds parameter. 

The function ATSUGetGlyphBounds passes back an array of structures of type ATSTrapezoid to specify the enclosing trapezoid(s) of a final laid-out line of text. If the range of text spans directional boundaries, ATSUGetGlyphBounds produces multiple trapezoids defining these regions.
Version Notes

In ATSUI 1.1, the function ATSUGetGlyphBounds can pass back a maximum of 31 bounding trapezoids. In ATSUI 1.2, ATSUGetGlyphBounds can pass back as many as 127 bounding trapezoids.*/

typedef struct ATSTrapezoid {
   FixedPoint upperLeft;
   FixedPoint upperRight;
   FixedPoint lowerRight;
   FixedPoint lowerLeft;
}ATSTrapezoid;


/*Glyph Property Flags

Specify properties for a glyph.

typedef UInt32 ATSGlyphInfoFlags;
enum {
   kATSGlyphInfoAppleReserved    = 0x1FFBFFE8,
   kATSGlyphInfoIsAttachment     = (unsigned long)x80000000,
   kATSGlyphInfoIsLTHanger       = 0x40000000,
   kATSGlyphInfoIsRBHanger       = 0x20000000,
   kATSGlyphInfoTerminatorGlyph  = 0x00080000,
   kATSGlyphInfoIsWhiteSpace     = 0x00040000,
   kATSGlyphInfoHasImposedWidth  = 0x00000010,
   kATSGlyphInfoByteSizeMask     = 0x00000007
};
Constants
kATSGlyphInfoAppleReserved

This flag is reserved by Apple. If you try to use it you may get an invalid value error.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsAttachment

Specifies that the glyph attaches to another glyph.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsLTHanger

Specifies that the glyph can hang off the left or top edge of a line.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsRBHanger

Specifies that the glyph can hang off the right or bottom edge of a line.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoTerminatorGlyph

Specifies that the glyph is not truly a glyph, but an end-marker to allow the calculation of the previous glyph's advance.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoIsWhiteSpace

Specifies that the glyph is a whitespace glyph.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoHasImposedWidth

Specifies that the glyph has an imposed width (that is, an advance width) specified by the style.

Available in Mac OS X v10.2 and later.
kATSGlyphInfoByteSizeMask

Specifies the size of the character that spawned the glyph. This is a three-bit mask that you can use to obtain the size of the original character that spawned a glyph. If you perform a logical and operation between this mask and an ATSGlyphInfoFlags flag, you obtain the size in bytes of the original character (0 - 7 bytes).

Available in Mac OS X v10.2 and later.
Discussion

Glyph information flags are set in the individual ATSLayoutRecord structure and apply only to the ATSGlyphRef reference in that structure. The flags are used by the ATSUI to tag a glyph with one or more specific properties.*/

typedef UInt32 ATSGlyphInfoFlags;
enum {
   kATSGlyphInfoAppleReserved    = 0x1FFBFFE8,
   kATSGlyphInfoIsAttachment     = (unsigned long)0x80000000,
   kATSGlyphInfoIsLTHanger       = 0x40000000,
   kATSGlyphInfoIsRBHanger       = 0x20000000,
   kATSGlyphInfoTerminatorGlyph  = 0x00080000,
   kATSGlyphInfoIsWhiteSpace     = 0x00040000,
   kATSGlyphInfoHasImposedWidth  = 0x00000010,
   kATSGlyphInfoByteSizeMask     = 0x00000007
};



/*ATSULineRef

Represents a reference to a structure that specifies a line of text. 

typedef struct ATSGlyphVector *ATSULineRef;
Discussion

You get an ATSUI line reference from ATSUI when your layout operation override callback is invoked. The line reference refers to the line that ATSUI is in the process of laying out.

From within your callback, you pass an ATSUI line reference to the function ATSUDirectGetLayoutDataArrayPtrFromLineRef to obtain layout data for that line. The only way you can obtain an ATSUI line reference is from inside your layout operation override callback. An ATSUI line reference is not valid is outside of the callback.
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct ATSGlyphVector *ATSULineRef;



/*Layout Operation Selectors

Specify a layout operation. 

typedef UInt32 ATSULayoutOperationSelector;
enum {
   kATSULayoutOperationNone      = 0x00000000,
   kATSULayoutOperationJustification = 0x00000001,
   kATSULayoutOperationMorph     = 0x00000002,
   kATSULayoutOperationKerningAdjustment = 0x00000004,
   kATSULayoutOperationBaselineAdjustment = 0x00000008,
   kATSULayoutOperationTrackingAdjustment = 0x00000010,
   kATSULayoutOperationPostLayoutAdjustment = 0x00000020,
   kATSULayoutOperationAppleReserved = (unsigned long)xFFFFFFC0
};
Constants
kATSULayoutOperationNone

Specifies that no layout operation is currently selected.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationJustification

Specifies the justification operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationMorph

Specifies the character-morphing operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationKerningAdjustment

Specifies the kerning-adjustment operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationBaselineAdjustment

Specifies the baseline-adjustment operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationTrackingAdjustment

Specifies the tracking-adjustment operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationPostLayoutAdjustment

Specifies the period of time after ATSUI has completed its layout operations.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationAppleReserved

This selector is reserved for future use.

Available in Mac OS X v10.2 and later.
Discussion

You can use layout operation selectors to specify to ATSUI which operations to override. These selectors can also be passed from ATSUI to your application to indicate which operation is currently in progress.*/

typedef UInt32 ATSULayoutOperationSelector;
enum {
   kATSULayoutOperationNone      = 0x00000000,
   kATSULayoutOperationJustification = 0x00000001,
   kATSULayoutOperationMorph     = 0x00000002,
   kATSULayoutOperationKerningAdjustment = 0x00000004,
   kATSULayoutOperationBaselineAdjustment = 0x00000008,
   kATSULayoutOperationTrackingAdjustment = 0x00000010,
   kATSULayoutOperationPostLayoutAdjustment = 0x00000020,
   kATSULayoutOperationAppleReserved = (unsigned long)0xFFFFFFC0
};

/*Layout Callback Status Values

Specify the status of a layout operation override callback.

typedef UInt32 ATSULayoutOperationCallbackStatus;
enum {
   kATSULayoutOperationCallbackStatusHandled = 0x00000000,
   kATSULayoutOperationCallbackStatusContinue = 0x00000001
};
Constants
kATSULayoutOperationCallbackStatusHandled

Specifies that your callback function has handled the operation which triggered the callback. This indicates to ATSUI that it does not need to perform any further processing for the layout operation.

Available in Mac OS X v10.2 and later.
kATSULayoutOperationCallbackStatusContinue

Specifies that your callback function has not handled the operation which triggered the callback. This indicates to ATSUI that needs to perform its own processing for the layout operation.

Available in Mac OS X v10.2 and later.
Discussion

You must return one of these status values from your ATSUDirectLayoutOperationOverrideProcPtr callback function to indicate to ATSUI whether or not your callback handled the layout operation.*/

typedef UInt32 ATSULayoutOperationCallbackStatus;
enum {
   kATSULayoutOperationCallbackStatusHandled = 0x00000000,
   kATSULayoutOperationCallbackStatusContinue = 0x00000001
};


/*ATSUDirectLayoutOperationOverrideProcPtr

Defines a pointer to a layout operation callback that overrides an ATSUI layout operation.

typedef CALLBACK_API_C (OSStatus, ATSUDirectLayoutOperationOverrideProcPtr
)
   ATSULayoutOperationSelector iCurrentOperation,
   ATSULineRef iLineRef,
   UInt32 iRefCon,
   void *iOperationCallbackParameterPtr,
   ATSULayoutOperationCallbackStatus *oCallbackStatus
);

If you name your function MyLayoutOperationOverrideCallback, you would declare it like this:

OSStatus MyLayoutOperationOverrideCallback
(
   ATSULayoutOperationSelector iCurrentOperation,
   ATSULineRef iLineRef,
   UInt32 iRefCon,
   void *iOperationCallbackParameterPtr,
   ATSULayoutOperationCallbackStatus *oCallbackStatus
);
Parameters
iCurrentOperation

The operation that triggered the callback. This value is passed to your callback by ATSUI. If you write a callback that handles more than one layout operation, you can use this value to determine which operation you should handle.
iLineRef

An ATSULineRef value that specifies the line of text on which your callback will operation. Your callback gets called for each line of text associated with the text layout object on which you installed the callback.
iRefCon

An unsigned 32-bit integer. This is an optional value. You can use this value to specify any data your application needs, such as user preference data. 
iOperationCallbackParameterPtr

A pointer. This is currently unused and should be set to NULL.
oCallbackStatus

A layout callback status value. On output, you must supply a status value to indicate to ATSUI whether or not your callback handled the operation. See “Layout Callback Status Values” for a list of the constants you can supply.
Discussion

ATSUI calls your layout operation override function each time the layout operation you specify is invoked. You associate a universal procedure pointer with a text layout object by treating the callback as a layout attribute. That is, you set up a triple (tag, size, value) to specify the layout operation your callback handles, then you call the function ATSUSetLayoutControls to associate the triple with the text layout object whose layout operation you want to override. The attribute tag you specify is kATSULayoutOperationOverrideTag. The attribute value you specify is an ATSULayoutOperationOverrideSpecifier structure that contains a selector for a layout operation and a pointer to your callback function.

To provide a pointer to your layout operation override callback, you create a universal procedure pointer (UPP) of type ATSUDirectLayoutOperationOverrideUPP, using the function NewATSUDirectLayoutOperationOverrideUPP. You can do so with code similar to the following:ATSUDirectLayoutOperationOverrideUPP MyLayoutOperationOverrideUPP;
MyLayoutOperationOverrideUPP = NewATSUDirectLayoutOperationOverrideUPP
                                (&MyLayoutOperationOverrideCallback);


When your layout operation is completed, you should use the function DisposeATSUDirectLayoutOperationOverrideUPP to dispose of the universal procedure pointer associated with your layout operation override function. However, if you plan to use the same layout operation override function in subsequent layout operations, you can reuse the same UPP, rather than dispose of it and later create a new UPP.

You are limited to the ATSUI functions you can call from within your callback. You can call only those functions that have do not trigger ATSUI to perform the layout operation again. Otherwise, you run the risk of causing infinite recursion. Most functions that use “create”, “get”, or “copy” semantics are safe to use within your callback. If you call one of the restricted functions, the function returns immediately with the error kATSUInvalidCallInsideCallbackErr.*/
typedef CALLBACK_API_C (OSStatus, ATSUDirectLayoutOperationOverrideProcPtr)(
   ATSULayoutOperationSelector iCurrentOperation,
   ATSULineRef iLineRef,
   UInt32 iRefCon,
   void *iOperationCallbackParameterPtr,
   ATSULayoutOperationCallbackStatus *oCallbackStatus
);




/*ATSUDirectLayoutOperationOverrideUPP

Defines a universal procedure pointer to a layout operation callback.

typedef ATSUDirectLayoutOperationOverrideProcPtr ATSUDirectLayoutOperationOverrideUPP;
Discussion

For more information, see the description of the ATSUDirectLayoutOperationOverrideProcPtr callback function.*/
typedef ATSUDirectLayoutOperationOverrideProcPtr ATSUDirectLayoutOperationOverrideUPP;


/*ATSULayoutOperationOverrideSpecifier

Contains an layout operation selector and a pointer to a layout operation override callback.

struct ATSULayoutOperationOverrideSpecifier {
   ATSULayoutOperationSelector  operationSelector;
   ATSUDirectLayoutOperationOverrideUPP  overrideUPP;
};
typedef struct ATSULayoutOperationOverrideSpecifier ATSULayoutOperationOverrideSpecifier;
Fields
operationSelector

A layout operation selector that specifies the operation for which the callback should be invoked. See “Layout Operation Selectors” for the selectors you can specify.
overrideUPP

A universal procedure pointer to a layout operation override callback.
Discussion

You can pass this structure as an attribute value for the layout attribute tag kATSULayoutOperationOverrideTag.
Availability
Available in Mac OS X v10.2 and later.*/

struct ATSULayoutOperationOverrideSpecifier {
   ATSULayoutOperationSelector  operationSelector;
   ATSUDirectLayoutOperationOverrideUPP  overrideUPP;
};
typedef struct ATSULayoutOperationOverrideSpecifier ATSULayoutOperationOverrideSpecifier;


/*ATSLayoutRecord

Contains basic layout information for a single glyph. 

struct ATSLayoutRecord {
   ATSGlyphRef         glyphID;
   ATSGlyphInfoFlags   flags;
   ByteCount           originalOffset;
   Fixed               realPos;
};
typedef struct ATSLayoutRecord ATSLayoutRecord;
Fields
glyphID

A reference to a glyph ID.
flags

A flag that specifies the glyph’s properties. See “Glyph Property Flags” for the constants you can use. 
originalOffset

The byte offset of the character with which this glyph is associated.
realPos

A Fixed value that specifies the real position of the glyph. This is the x-coordinate of the glyph.
Availability
Available in Mac OS X v10.2 and later.*/
struct ATSLayoutRecord {
   ATSGlyphRef         glyphID;
   ATSGlyphInfoFlags   flags;
   ByteCount           originalOffset;
   Fixed               realPos;
};
typedef struct ATSLayoutRecord ATSLayoutRecord;

/*ATSJustWidthDeltaEntryOverride

Contains values that specify the amount of space that can be added to or removed from the right and left sides of each of the glyphs of a given justification priority.

struct ATSJustWidthDeltaEntryOverride {
   Fixed beforeGrowLimit;
   Fixed beforeShrinkLimit;
   Fixed afterGrowLimit;
   Fixed afterShrinkLimit;
   JustificationFlags growFlags;
   JustificationFlags shrinkFlags;
};
typedef struct ATSJustWidthDeltaEntryOverride ATSJustWidthDeltaEntryOverride;
Fields
beforeGrowLimit

The proportion by which a glyph can expand on the left side (top side for vertical text). For example, a value of 0.2 means that a 24-point glyph can have by no more than 4.8 points (0.2 x 24 = 4.8) of extra space added on the left side (top side for vertical text). 
beforeShrinkLimit

The proportion by which a glyph can shrink on the left side (top side for vertical text). If specified, this value should be negative.
afterGrowLimit

The proportion by which a glyph can expand on the right side (bottom side for vertical text).
afterShrinkLimit

The proportion by which a glyph can shrink on the right side (bottom side for vertical text). If specified, this value should be negative.
growFlags

Mask constants that indicate whether ATSUI should apply the limits defined in the beforeGrowLimit and afterGrowLimit fields. See “Justification Override Mask Constants” in the Font Manager for a description of possible values. These mask constants also control whether unlimited gap absorption should be applied to the priority of glyphs specified in the given width delta override structure. You can use these mask constants to selectively override the grow case only, while retaining default behavior for other cases. 
shrinkFlags

Mask constants that indicate whether ATSUI should apply the limits defined in the beforeShrinkLimit and afterShrinkLimit fields. See “Justification Override Mask Constants” in the Font Manager for a description of possible values. These mask constants also control whether unlimited gap absorption should be applied to the priority of glyphs specified in the given width delta override structure. You can use these mask constants to selectively override the shrink case only, while retaining default behavior for other cases.
Discussion

The JustWidthDeltaEntryOverride structure specifies proportions for justification growth and shrinkage, both on the left and the right sides. The growth and shrinkage values override the font-specified widths, such as those specified by the font for kashidas.

It also contains justification flags. The ATSJustWidthDeltaEntryOverride data type can be used to set and get justification behavior and priority override weighting; see “Attribute Tags”. 

If you need to access other 'just' table constants and structures from the 'sfnt' resource, see the header file SFNTLayoutTypes.h.
Availability
Available in Mac OS X v10.0 and later.*/
struct ATSJustWidthDeltaEntryOverride {
   Fixed beforeGrowLimit;
   Fixed beforeShrinkLimit;
   Fixed afterGrowLimit;
   Fixed afterShrinkLimit;
   JustificationFlags growFlags;
   JustificationFlags shrinkFlags;
};
typedef struct ATSJustWidthDeltaEntryOverride ATSJustWidthDeltaEntryOverride;

/*ATSJustPriorityWidthDeltaOverrides

Contains justification width delta override structures, one for each priority-level override.

typedef ATSJustWidthDeltaEntryOverride ATSJustPriorityWidthDeltaOverrides[4];
Discussion

For more information see ATSJustWidthDeltaEntryOverride.
Availability
Available in Mac OS X v10.0 and later.*/
typedef ATSJustWidthDeltaEntryOverride ATSJustPriorityWidthDeltaOverrides[4];

#ifdef __cplusplus
}
#endif

#endif