#import <AppKit/NSOpenGL.h>

/*NSOpenGLPixelFormatAttribute

The following attribute names are used by initWithAttributes: and getValues:forAttribute:forVirtualScreen::

typedef enum {
   NSOpenGLPFAAllRenderers = 1,
   NSOpenGLPFADoubleBuffer = 5,
   NSOpenGLPFAStereo = 6,
   NSOpenGLPFAAuxBuffers = 7,
   NSOpenGLPFAColorSize = 8,
   NSOpenGLPFAAlphaSize = 11,
   NSOpenGLPFADepthSize = 12,
   NSOpenGLPFAStencilSize = 13,
   NSOpenGLPFAAccumSize = 14,
   NSOpenGLPFAMinimumPolicy = 51,
   NSOpenGLPFAMaximumPolicy = 52,
   NSOpenGLPFAOffScreen = 53,
   NSOpenGLPFAFullScreen = 54,
   NSOpenGLPFASampleBuffers = 55,
   NSOpenGLPFASamples = 56,
   NSOpenGLPFAAuxDepthStencil = 57,
   NSOpenGLPFARendererID = 70,
   NSOpenGLPFASingleRenderer = 71,
   NSOpenGLPFANoRecovery = 72,
   NSOpenGLPFAAccelerated = 73,
   NSOpenGLPFAClosestPolicy = 74,
   NSOpenGLPFARobust = 75,
   NSOpenGLPFABackingStore = 76,
   NSOpenGLPFAMPSafe = 78,
   NSOpenGLPFAWindow = 80,
   NSOpenGLPFAMultiScreen = 81,
   NSOpenGLPFACompliant = 83,
   NSOpenGLPFAScreenMask = 84,
   NSOpenGLPFAPixelBuffer = 90,
   NSOpenGLPFAVirtualScreenCount = 128
} NSOpenGLPixelFormatAttribute;
Constants
NSOpenGLPFAAllRenderers

If YES, pixel format selection is open to all available renderers, including debug and special-purpose renderers that are not OpenGL compliant.

Available in Mac OS X v10.0 and later.
NSOpenGLPFADoubleBuffer

If YES, only double-buffered pixel formats are considered. Otherwise, only single-buffered pixel formats are considered.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAStereo

If YES, only stereo pixel formats are considered. Otherwise, only monoscopic pixel formats are considered.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAAuxBuffers

Value is a nonnegative integer that indicates the desired number of auxiliary buffers. Pixel formats with the smallest number of auxiliary buffers that meets or exceeds the specified number are preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAColorSize

Value is a nonnegative buffer size specification. A color buffer that most closely matches the specified size is preferred. If unspecified, OpenGL chooses a color size that matches the screen.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAAlphaSize

Value is a nonnegative buffer size specification. An alpha buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFADepthSize

Value is a nonnegative depth buffer size specification. A depth buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAStencilSize

Value is a nonnegative integer that indicates the desired number of stencil bitplanes. The smallest stencil buffer of at least the specified size is preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAAccumSize

Value is a nonnegative buffer size specification. An accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAMinimumPolicy

If YES, the pixel format choosing policy is altered for the color, depth, and accumulation buffers such that only buffers of size greater than or equal to the desired size are considered.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAMaximumPolicy

If YES, the pixel format choosing policy is altered for the color, depth, and accumulation buffers such that, if a nonzero buffer size is requested, the largest available buffer is preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAOffScreen

If YES, only renderers that are capable of rendering to an offscreen memory area and have buffer depth exactly equal to the desired buffer depth are considered. The NSOpenGLPFAClosestPolicy attribute is implied.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAFullScreen

If YES, only renderers that are capable of rendering to a full-screen drawable are considered. The NSOpenGLPFASingleRenderer attribute is implied.

Available in Mac OS X v10.0 and later.
NSOpenGLPFASampleBuffers

Value is a nonnegative number indicating the number of multisample buffers.

Available in Mac OS X v10.2 and later.
NSOpenGLPFASamples

Value is a nonnegative indicating the number of samples per multisample buffer.

Available in Mac OS X v10.2 and later.
NSOpenGLPFAAuxDepthStencil

Each auxiliary buffer has its own depth stencil.

Available in Mac OS X v10.2 and later.
NSOpenGLPFAColorFloat

If YES, only renderers that are capable using buffers storing floating point pixels are considered. This should be accompanied by a NSOpenGLPFAColorSize of 64 (for half float pixel components) or 128 (for full float pixel components). Note, not all hardware supports floating point color buffers thus the returned pixel format could be NULL.

Available for Mac OS X 10.4 and later.
NSOpenGLPFAMultisample

If YES and used with NSOpenGLPFASampleBuffers and NSOpenGLPFASamples, hints to OpenGL to prefer multi-sampling. Multi-sampling will sample textures at the back buffer dimensions vice the multi-sample buffer dimensions and use that single sample for all fragments with coverage on the back buffer location. This means less total texture samples than with super-sampling (by a factor of the number of samples requested) and will likely be faster though less accurate (texture sample wise) than super-sampling. If the underlying video card does not have enough VRAM to support this feature, this hint does nothing. If the pixel format is not requesting anti-aliasing then this hint does nothing.

Available in Mac OS X v10.4 and later.
NSOpenGLPFASupersample

If YES and used with NSOpenGLPFASampleBuffers and NSOpenGLPFASamples, this constant hints to OpenGL to prefer super-sampling. Super-sampling will process fragments with a texture sample per fragment and would likely be slower than multi-sampling. If the pixel format is not requesting anti-aliasing, this hint does nothing.

Available in Mac OS X v10.4 and later.
NSOpenGLPFASampleAlpha

If YES and used with NSOpenGLPFASampleBuffers and NSOpenGLPFASampleBuffers hints to OpenGL to update multi-sample alpha values to ensure the most accurate rendering. If pixel format is not requesting anti-aliasing then this hint does nothing.

Available in Mac OS X v10.4 and later.
NSOpenGLPFARendererID

Value is a nonnegative renderer ID number. OpenGL renderers that match the specified ID are preferred. Constants to select specific renderers are provided in the CGLRenderers.h header of the OpenGL framework. Of note is kCGLRendererGenericID which selects the Apple software renderer. The other constants select renderers for specific hardware vendors.

Available in Mac OS X v10.0 and later.
NSOpenGLPFASingleRenderer

If YES, a single rendering engine is chosen. On systems with multiple screens, this disables OpenGL’s ability to drive different monitors through different graphics accelerator cards with a single context. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
NSOpenGLPFANoRecovery

If YES, OpenGL’s failure recovery mechanisms are disabled. Normally, if an accelerated renderer fails due to lack of resources, OpenGL automatically switches to another renderer. This attribute disables these features so that rendering is always performed by the chosen renderer. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAAccelerated

If YES, only hardware-accelerated renderers are considered. If NO, accelerated renderers are still preferred.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAClosestPolicy

If YES, the pixel format choosing policy is altered for the color buffer such that the buffer closest to the requested size is preferred, regardless of the actual color buffer depth of the supported graphics device.

Available in Mac OS X v10.0 and later.
NSOpenGLPFARobust

If YES, only renderers that do not have any failure modes associated with a lack of video card resources are considered. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
NSOpenGLPFABackingStore

If YES, OpenGL only considers renderers that have a back color buffer the full size of the drawable (regardless of window visibility) and that guarantee the back buffer contents to be valid after a call to NSOpenGLContext object’s flushBuffer.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAMPSafe

If YES, renderer is multi-processor safe.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAWindow

If YES, only renderers that are capable of rendering to a window are considered. This attribute is implied if neither NSOpenGLPFAFullScreen nor NSOpenGLPFAOffScreen is specified.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAMultiScreen

If YES, only renderers capable of driving multiple screens are considered. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
NSOpenGLPFACompliant

If YES, pixel format selection is only open to OpenGL-compliant renderers. This attribute is implied unless NSOpenGLPFAAllRenderers is specified. This attribute is not useful in the attribute array.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAScreenMask

Value is a bit mask of supported physical screens. All screens specified in the bit mask are guaranteed to be supported by the pixel format. Screens not specified in the bit mask may still be supported. The bit mask is managed by the CoreGraphics’s DirectDisplay, available in the CGDirectDisplay.h header of the ApplicationServices umbrella framework. A CGDirectDisplayID must be converted to an OpenGL display mask using the function CGDisplayIDToOpenGLDisplayMask. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
NSOpenGLPFAPixelBuffer

If YES, rendering to a pixel buffer is enabled.

Available in Mac OS X v10.3 and later.
NSOpenGLPFAVirtualScreenCount

Number of virtual screens in this format.

Available in Mac OS X v10.2 and later.
Availability
Available in Mac OS X v10.0 and later.
Declared In
NSOpenGL.h*/

 enum {
//   NSOpenGLPFAAllRenderers = 1,
//   NSOpenGLPFADoubleBuffer = 5,
   //NSOpenGLPFAStereo = 6,
   //NSOpenGLPFAAuxBuffers = 7,
   //NSOpenGLPFAColorSize = 8,
   //NSOpenGLPFAAlphaSize = 11,
   //NSOpenGLPFADepthSize = 12,
   //NSOpenGLPFAStencilSize = 13,
   //NSOpenGLPFAAccumSize = 14,
   //NSOpenGLPFAMinimumPolicy = 51,
   //NSOpenGLPFAMaximumPolicy = 52,
   //NSOpenGLPFAOffScreen = 53,
   //NSOpenGLPFAFullScreen = 54,
   //NSOpenGLPFASampleBuffers = 55,
//   NSOpenGLPFASamples = 56,
   //NSOpenGLPFAAuxDepthStencil = 57,
   //NSOpenGLPFARendererID = 70,
   //NSOpenGLPFASingleRenderer = 71,
   //NSOpenGLPFANoRecovery = 72,
   //NSOpenGLPFAAccelerated = 73,
   //NSOpenGLPFAClosestPolicy = 74,
   //NSOpenGLPFARobust = 75,
   //NSOpenGLPFABackingStore = 76,
   //NSOpenGLPFAMPSafe = 78,
   //NSOpenGLPFAWindow = 80,
//   //NSOpenGLPFAMultiScreen = 81,
   //NSOpenGLPFACompliant = 83,
   //NSOpenGLPFAScreenMask = 84,
   NSOpenGLPFAPixelBuffer = 90
   //NSOpenGLPFAVirtualScreenCount = 128
};


@interface NSOpenGLPixelBuffer : NSObject

/*pixelsWide

Returns the width of the receiver’s texture (in pixels).

- (int)pixelsWide
Return Value

The width of the texture (in pixels).
Availability
Available in Mac OS X v10.3 and later.
See Also
– pixelsHigh*/
- (int)pixelsWide;

/*pixelsHigh

Returns the height of the receiver’s texture (in pixels).

- (int)pixelsHigh
Return Value

The height of the texture (in pixels). 
Availability
Available in Mac OS X v10.3 and later.
See Also
– pixelsWide
pixelsWide*/
- (int)pixelsHigh;

/*initWithTextureTarget:textureInternalFormat:textureMaxMipMapLevel:pixelsWide:pixelsHigh:

Returns an NSOpenGLPixelBuffer object initialized with the specified parameters. 

- (id)initWithTextureTarget:(unsigned long)target textureInternalFormat:(unsigned long)format textureMaxMipMapLevel:(long)maxLevel pixelsWide:(int)pixelsWide pixelsHigh:(int)pixelsHigh
Parameters
target

The texture object. This value should be one of the following: GL_TEXTURE_2D,GL_TEXTURE_CUBE_MAP, or GL_TEXTURE_RECTANGLE_EXT. 
format

The base internal format of the texture. This value should be GL_RGB, GL_RGBA, or GL_DEPTH_COMPONENT. 
maxLevel

The desired maximum mipmap level of the structure, starting with zero.
pixelsWide

The width of the texture (in pixels) in the pixel buffer.
pixelsHigh

The height of the texture (in pixels) in the pixel buffer.
Return Value

An initialized NSOpenGLPixelBuffer object or nil if the initialization failed. Initialization can fail if there is inconsistency among the parameter values. See the OpenGL documentation for glTexImage2D for more information. 
Discussion

The value you pass to the target parameter defines several other constraints that are then applied to the remaining parameters. The list below gives the values you can pass to target and the additional constraints. 
GL_TEXTURE_2D - the values in pixelsWide and pixelsHigh must be powers of two. 
GL_TEXTURE_CUBE_MAP - the values in pixelsWide and pixelsHigh must be powers of two and they must be equal.
GL_TEXTURE_RECTANGLE_EXT - maxLevel must be zero. 
Availability
Available in Mac OS X v10.3 and later.*/
- (id)initWithTextureTarget:(unsigned long)target textureInternalFormat:(unsigned long)format textureMaxMipMapLevel:(long)maxLevel pixelsWide:(int)pixelsWide pixelsHigh:(int)pixelsHigh;

@end


@interface NSOpenGLContext (hys)

/*CGLContextObj

Returns the low-level, platform-specific Core OpenGL (CGL) context object represented by the receiver.

- (void *)CGLContextObj
Return Value

A pointer to the CGLContextObj data type represented by the receiver. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void *)CGLContextObj;

/*setTextureImageToPixelBuffer:colorBuffer:

Attaches the image data in the specified pixel buffer to the texture object currently bound by the receiver.

- (void)setTextureImageToPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer colorBuffer:(unsigned long)source
Parameters
pixelBuffer

The pixel buffer to attach.
source

An OpenGL constant indicating which of the pixel buffer's color buffers to use. Potential values for this parameter include GL_FRONT, GL_BACK, and GL_AUX0. 
Discussion

This method corresponds to the Core OpenGL method CGLTexImagePBuffer. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setTextureImageToPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer colorBuffer:(unsigned long)source;

/*setPixelBuffer:cubeMapFace:mipMapLevel:currentVirtualScreen:

Attaches the specified pixel buffer to the receiver.

- (void)setPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer cubeMapFace:(unsigned long)face mipMapLevel:(long)level currentVirtualScreen:(int)screen
Parameters
pixelBuffer

The pixel buffer to attach.
face

For pixel buffers with a texture target of GL_CUBE_MAP, this parameter should be zero or one of the following values:
GL_TEXTURE_CUBE_MAP_POSITIVE_X
GL_TEXTURE_CUBE_MAP_POSITIVE_Y
GL_TEXTURE_CUBE_MAP_POSITIVE_Z
GL_TEXTURE_CUBE_MAP_NEGATIVE_X
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
level

The desired mipmap level for rendering. This value must be less than or equal to the maximum texture mipmap level of pixelBuffer (accessible through an NSOpenGLPixelBuffer object’s textureMaxMipMapLevel method). 
screen

The virtual screen of the receiver (if applicable) should be set to the same value as the current virtual screen you are using for rendering onscreen
Discussion

The NSOpenGLPixelBuffer object gives the receiver access to accelerated offscreen rendering in the pixel buffer, which is primarily used for textures. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– pixelBufferCubeMapFace
– pixelBufferMipMapLevel
– setCurrentVirtualScreen:
– initWithTextureTarget:textureInternalFormat:textureMaxMipMapLevel:pixelsWide:pixelsHigh: (NSOpenGLPixelBuffer)*/

- (void)setPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer cubeMapFace:(unsigned long)face mipMapLevel:(long)level currentVirtualScreen:(int)screen;


@end


@interface NSOpenGLPixelFormat (hys)

/*CGLPixelFormatObj

Returns the low-level, platform-specific Core OpenGL (CGL) pixel format object represented by the receiver.

- (void *)CGLPixelFormatObj
Return Value

A pointer to the underlying CGLPixelFormatObj object. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void *)CGLPixelFormatObj;

@end