#include <sys/acl.h>

int	acl_get_flag_np(acl_flagset_t flagset_d, acl_flag_t flag){
printf ("acl_get_flag_np",flagset_d,flag);
};

/*ACL_INIT(3)              BSD Library Functions Manual              ACL_INIT(3)

NAME
     acl_init -- initialize ACL working storage

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     acl_t
     acl_init(int count);

DESCRIPTION
     The acl_init() function allocates and initializes the working storage for
     an ACL of at least count ACL entries.  A pointer to the working storage
     is returned.  The working storage allocated to contain the ACL is freed
     by a call to acl_free(3).  When the area is first allocated, it shall
     contain an ACL that contains no ACL entries.

     This function may cause memory to be allocated.  The caller should free
     any releasable memory, when the new ACL is no longer required, by calling
     acl_free(3) with the (void*)acl_t as an argument.

RETURN VALUES
     Upon successful completion, this function shall return a pointer to the
     working storage.  Otherwise, a value of (acl_t)NULL shall be returned,
     and errno shall be set to indicate the error.

ERRORS
     If any of the following conditions occur, the acl_init() function shall
     return a value of (acl_t)NULL and set errno to the corresponding value:

     [EINVAL]           The value of count is less than zero.

     [ENOMEM]           The acl_t to be returned requires more memory than is
                        allowed by the hardware or system-imposed memory man-agement management
                        agement constraints.

SEE ALSO

     acl(3), acl_free(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Robert N M Watson*/
   acl_t acl_init(int count){};


/*ACL_SET_QUALIFIER(3)     BSD Library Functions Manual     ACL_SET_QUALIFIER(3)

NAME
     acl_set_qualifier -- set ACL tag qualifier

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_set_qualifier(acl_entry_t entry_d, const void *tag_qualifier_p);

DESCRIPTION
     The acl_set_qualifier() function is a POSIX.1e call that sets the quali-fier qualifier
     fier of the tag for the ACL entry entry_d to the value referred to by
     tag_qualifier_p.

RETURN VALUES
     The acl_set_qualifier() function returns the value 0 if successful; oth-erwise otherwise
     erwise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_set_qualifier() function fails if:

     [EINVAL]           Argument entry_d is not a valid descriptor for an ACL
                        entry.  The tag type of the ACL entry entry_d is not
                        ACL_EXTENDED_ALLOW or ACL_EXTENDED_DENY.  The value
                        pointed to by tag_qualifier_p is not valid.

     [ENOMEM]           The value to be returned requires more memory than is
                        allowed by the hardware or system-imposed memory man-agement management
                        agement constraints.

SEE ALSO
     acl(3), acl_get_qualifier(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D. Faulhaber

BSD                             March 10, 2001                             BSD*/

     int
     acl_set_qualifier(acl_entry_t entry_d, const void *tag_qualifier_p){};


/*ACL_GET_PERMSET(3)       BSD Library Functions Manual       ACL_GET_PERMSET(3)

NAME
     acl_get_permset -- retrieve permission set from an ACL entry

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_get_permset(acl_entry_t entry_d, acl_permset_t *permset_p);

DESCRIPTION
     The acl_get_permset() function is a POSIX.1e call that returns via
     permset_p a descriptor to the permission set in the ACL entry entry_d.
     Subsequent operations using the returned permission set operate on the
     permission set within the ACL entry.

RETURN VALUES
     The acl_get_permset() function returns the value 0 if successful; other-wise otherwise
     wise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_get_permset() function fails if:

     [EINVAL]           Argument entry_d is not a valid descriptor for an ACL
                        entry.

SEE ALSO
     acl(3), acl_add_perm(3), acl_clear_perms(3), acl_delete_perm(3),
     acl_set_permset(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D. Faulhaber

BSD                             March 10, 2001                             BSD*/
   int
     acl_get_permset(acl_entry_t entry_d, acl_permset_t *permset_p){};


/*ACL_SET_PERMSET(3)       BSD Library Functions Manual       ACL_SET_PERMSET(3)

NAME
     acl_set_permset -- set the permissions of an ACL entry

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_set_permset(acl_entry_t entry_d, acl_permset_t permset_d);

DESCRIPTION
     The acl_set_permset() function is a POSIX.1e call that sets the permis-sions permissions
     sions of ACL entry entry_d with the permissions contained in permset_d.

RETURN VALUES
     The acl_set_permset() function returns the value 0 if successful; other-wise otherwise
     wise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_set_permset() function fails if:

     [EINVAL]           Argument entry_d is not a valid descriptor for an ACL
                        entry.

SEE ALSO
     acl(3), acl_add_perm(3), acl_clear_perms(3), acl_delete_perm(3),
     acl_get_permset(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D. Faulhaber

BSD                             March 10, 2001                             BSD*/
 int
     acl_set_permset(acl_entry_t entry_d, acl_permset_t permset_d){};

/*ACL_FREE(3)              BSD Library Functions Manual              ACL_FREE(3)

NAME
     acl_free -- free ACL working state

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_free(void *obj_p);

DESCRIPTION
     The acl_free() call allows the freeing of ACL working space, such as is
     allocated by acl_dup(3), or acl_from_text(3).

RETURN VALUES
     The acl_free() function returns the value 0 if successful; otherwise the
     value -1 is returned and the global variable errno is set to indicate the
     error.

ERRORS
     If any of the following conditions occur, the acl_free() function shall
     return -1 and set errno to the corresponding value:

     [EINVAL]           The value of the obj_p argument is invalid.

SEE ALSO
     acl(3), acl_dup(3), acl_from_text(3), acl_get(3), acl_init(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Robert N M Watson

BSD                            January 28, 2000                            BSD*/
 int
     acl_free(void *obj_p){};



/*ACL_ADD_PERM(3)          BSD Library Functions Manual          ACL_ADD_PERM(3)

NAME
     acl_add_perm -- add permissions to a permission set

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_add_perm(acl_permset_t permset_d, acl_perm_t perm);

DESCRIPTION
     The acl_add_perm() function is a POSIX.1e call that adds the permission
     contained in perm to the permission set permset_d.

     Note: it is not considered an error to attempt to add permissions that
     already exist in the permission set.

RETURN VALUES
     The acl_add_perm() function returns the value 0 if successful; otherwise
     the value -1 is returned and the global variable errno is set to indicate
     the error.

ERRORS
     The acl_add_perm() function fails if:

     [EINVAL]           Argument permset_d is not a valid descriptor for a
                        permission set within an ACL entry.  Argument perm
                        does not contain a valid acl_perm_t value.

SEE ALSO
     acl(3), acl_clear_perms(3), acl_delete_perm(3), acl_get_permset(3),
     acl_set_permset(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D Fulhaber

BSD                             March 10, 2001                             BSD*/
int
     acl_add_perm(acl_permset_t permset_d, acl_perm_t perm){};

/*ACL_CREATE_ENTRY(3)      BSD Library Functions Manual      ACL_CREATE_ENTRY(3)

NAME
     acl_create_entry, acl_create_entry_np -- create a new ACL entry

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_create_entry(acl_t *acl_p, acl_entry_t *entry_p);

     int
     acl_create_entry_np(acl_t *acl_p, acl_entry_t *entry_p, int entry_index);

DESCRIPTION
     The acl_create_entry() function is a POSIX.1e call that creates a new ACL
     entry in the ACL pointed to by acl_p.

     The acl_create_entry_np() function is a non-portable extension which
     allows the caller to specify the position of the created entry within the
     ACL.  If entry_index is ACL_FIRST_ENTRY the entry will be created at the
     head of the ACL.  If entry_index is ACL_LAST_ENTRY the entry will be cre-ated created
     ated at the end of the ACL.  After inserting an ACL entry with an
     entry_index other than ACL_LAST_ENTRY the behaviour of any acl_entry_t's
     previously obtained from the ACL by acl_create_entry() or acl_get_entry()
     is undefined.

RETURN VALUES
     The acl_create_entry() function returns the value 0 if successful; other-wise otherwise
     wise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_create_entry() and acl_create_entry_np() functions fail if:

     [EINVAL]           Argument acl_p does not point to a pointer to a valid
                        ACL.

     [ENOMEM]           The ACL working storage requires more memory than is
                        allowed by the hardware or system-imposed memory man-agement management
                        agement constraints.

     [ERANGE]           The entry_index argument to acl_create_entry_np() is
                        greater than the number of entries in the ACL.

SEE ALSO
     acl(3), acl_delete_entry(3), acl_get_entry(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D Fulhaber

BSD                             March 16, 2001                             BSD*/
int
     acl_create_entry(acl_t *acl_p, acl_entry_t *entry_p){};

     int
     acl_create_entry_np(acl_t *acl_p, acl_entry_t *entry_p, int entry_index){};



/*ACL_SET_TAG_TYPE(3)      BSD Library Functions Manual      ACL_SET_TAG_TYPE(3)

NAME
     acl_set_tag_type -- set the tag type of an ACL entry

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_set_tag_type(acl_entry_t entry_d, acl_tag_t tag_type);

DESCRIPTION
     The acl_set_tag_type() function is a POSIX.1e call that sets the ACL tag
     type of ACL entry entry_d to the value of tag_type.

RETURN VALUES
     The acl_set_tag_type() function returns the value 0 if successful; other-wise otherwise
     wise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_set_tag_type() function fails if:

     [EINVAL]           Argument entry_d is not a valid descriptor for an ACL
                        entry.  Argument tag_type is not a valid ACL tag type.

SEE ALSO
     acl(3), acl_get_tag_type(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D. Faulhaber

BSD                             March 10, 2001                             BSD*/

     int
     acl_set_tag_type(acl_entry_t entry_d, acl_tag_t tag_type){};



/*ACL_GET_ENTRY(3)         BSD Library Functions Manual         ACL_GET_ENTRY(3)

NAME
     acl_get_entry -- retrieve an ACL entry from an ACL

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_get_entry(acl_t acl, int entry_id, acl_entry_t *entry_p);

DESCRIPTION
     The acl_get_entry() function is a POSIX.1e call that retrieves a descrip-tor descriptor
     tor for an ACL entry specified by the argument entry_d within the ACL
     indicated by the argument acl.

     If the value of entry_id is ACL_FIRST_ENTRY, then the function will
     return in entry_p a descriptor for the first ACL entry within acl.  If a
     call is made to acl_get_entry() with entry_id set to ACL_NEXT_ENTRY when
     there has not been either an initial successful call to acl_get_entry(),
     or a previous successfull call to acl_create_entry(), acl_delete_entry(),
     acl_dup(), acl_from_text(), acl_get_fd(), acl_get_file(), acl_set_fd(),
     acl_set_file(), or acl_valid(), then the result is unspecified.

     The caller may also set entry_id to the index of the desired entry within
     the ACL.  This is a non-portable extension.  A subsequent call with
     entry_id set to ACL_NEXT_ENTRY will return the entry following the previ-ously previously
     ously nominated entry and so forth.

RETURN VALUES
     If the acl_get_entry() function successfully obtains an ACL entry, a
     value of 1 is returned.  If the ACL has no ACL entries, the
     acl_get_entry() returns a value of 0.  If the value of entry_id is
     ACL_NEXT_ENTRY and the last ACL entry in the ACL has already been
     returned by a previous call to acl_get_entry(), a value of 0 will be
     returned until a successful call with entry_id of ACL_FIRST_ENTRY is
     made.  Otherwise, a value of -1 will be returned and the global variable
     errno will be set to indicate the error.

ERRORS
     The acl_get_entry() fails if:

     [EINVAL]           Argument acl does not point to a valid ACL.  Argument
                        entry_id is neither ACL_FIRST_ENTRY, ACL_NEXT_ENTRY or
                        a valid entry index.

SEE ALSO
     acl(3), acl_calc_mask(3), acl_create_entry(3), acl_delete_entry(3),
     acl_dup(3), acl_from_text(3), acl_get_fd(3), acl_get_file(3),
     acl_init(3), acl_set_fd(3), acl_set_file(3), acl_valid(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D. Faulhaber*/
   int
     acl_get_entry(acl_t acl, int entry_id, acl_entry_t *entry_p){};


/*ACL_GET_FLAGSET_NP(3)    BSD Library Functions Manual    ACL_GET_FLAGSET_NP(3)

NAME
     acl_get_flagset_np -- retrieve flag set from an ACL or ACL entry

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_get_flagset_np(void *obj, acl_flagset_t *flagset_p);

DESCRIPTION
     The acl_get_flagset_np() function is a nonstandard extension that returns
     via flagset_p a descriptor to the flag set in the ACL or ACL entry obj.
     Subsequent operations using the returned flag set operate on the permis-sion permission
     sion set within the ACL or ACL entry.

RETURN VALUES
     The acl_get_flagset() function returns the value 0 if successful; other-wise otherwise
     wise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_get_flagset() function fails if:

     [EINVAL]           Argument obj is not a valid descriptor for an ACL or
                        ACL entry.

SEE ALSO
     acl(3), acl_add_flag(3), acl_clear_flagss(3), acl_delete_flag(3),
     acl_set_flagset(3),

AUTHORS
     Michael Smith
     Chris D. Faulhaber

BSD                             March 10, 2001                             BSD*/
 int
     acl_get_flagset_np(void *obj, acl_flagset_t *flagset_p){};


/*ACL_DELETE_ENTRY(3)      BSD Library Functions Manual      ACL_DELETE_ENTRY(3)

NAME
     acl_delete_entry -- delete an ACL entry from an ACL

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <sys/types.h>
     #include <sys/acl.h>

     int
     acl_delete_entry(acl_t acl, acl_entry_t entry_d);

DESCRIPTION
     The acl_delete_entry() function is a POSIX.1e call that removes the ACL
     entry entry_d from ACL acl.

RETURN VALUES
     The acl_delete_entry() function returns the value 0 if successful; other-wise otherwise
     wise the value -1 is returned and the global variable errno is set to
     indicate the error.

ERRORS
     The acl_delete_entry() function fails if:

     [EINVAL]           Argument acl does not point to a valid ACL.  Argument
                        entry_d is not a valid descriptor for an ACL entry in
                        acl.

SEE ALSO
     acl(3), acl_copy_entry(3), acl_get_entry(3), posix1e(3)

STANDARDS
     POSIX.1e is described in IEEE POSIX.1e draft 17.

AUTHORS
     Michael Smith
     Chris D Fulhaber

BSD                             March 10, 2001                             BSD*/
   int
     acl_delete_entry(acl_t acl, acl_entry_t entry_d){};








