#include <QuickTime/QuickTime.h>

/*QTVRGetTiltAngle

Obtains the tilt angle of a QuickTime VR movie.

float QTVRGetTiltAngle (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

A floating-point value that represents the current tilt angle of the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetTiltAngle (
   QTVRInstance    qtvr ){
printf ("QTVRGetTiltAngle ",qtvr);
};


/*QTVRGetPanAngle

Obtains the pan angle of a QuickTime VR movie.

float QTVRGetPanAngle (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

A floating-point value that represents the current pan angle of the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

float QTVRGetPanAngle (
   QTVRInstance    qtvr ){
printf ("QTVRGetPanAngle",qtvr);
};

/*QTVRWrapAndConstrain

Preflights a change in the viewing or control characteristics of a QTVR object or panoramic node.

OSErr QTVRWrapAndConstrain (
   QTVRInstance    qtvr,
   short           kind,
   float           value,
   float           *result );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
kind

A constraint type (see below). See these constants: 
kQTVRPan
kQTVRTilt
kQTVRFieldOfView
kQTVRViewCenterH
kQTVRViewCenterV
value

The desired value of the specified viewing characteristic.
result

On return, the value to which the specified viewing characteristic would be set if it were changed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the result parameter, the constrained or wrapped value that would result from setting the viewing or control characteristic specified by the kind parameter to the value specified by the value parameter. For example, if the kind parameter is set to kQTVRPan, then this function returns the value that would result from calling QTVRSetPanAngle with its panAngle parameter set to the value parameter. Similarly, you can use this function to find the current bounds of the view center. It takes into account the current constraints and wrapping modes of the node specified by the qtvr parameter. This function does not change the current view or other settings of the specified object or panorama.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRWrapAndConstrain (
   QTVRInstance    qtvr,
   short           kind,
   float           value,
   float           *result ){
printf ("QTVRWrapAndConstrain",qtvr,kind,value,*result);
};

