#include <QuickTime/QuickTime.h>


/*TuneQueue

Places a sequence of music events into a queue to be played.

ComponentResult TuneQueue (
   TunePlayer         tp,
   unsigned long      *tune,
   Fixed              tuneRate,
   unsigned long      tuneStartPosition,
   unsigned long      tuneStopPosition,
   unsigned long      queueFlags,
   TuneCallBackUPP    callBackProc,
   long               refCon );
Parameters
tp

A tune player identifier, obtained from OpenComponent or OpenDefaultComponent.
tune

A pointer to an array of events, terminated by a marker event of subtype kMarkerEventEnd. See QTMA Events.
tuneRate

Speed at which to play the sequence. "Normal" speed is 0x00010000.
tuneStartPosition

Sequence starting time.
tuneStopPosition

Sequence stopping time. The tuneStartPosition and tuneStopPosition parameters specify, in time units numbered from 0 for the beginning of the sequence, which part of the queued sequence to play. To play all of it, pass 0 and 0xFFFFFFFF, respectively.
queueFlags

Flags (see below) with details about how to play the queued tunes. See these constants: 
kTuneStartNow
kTuneDontClipNotes
kTuneExcludeEdgeNotes
kTuneQuickStart
kTuneLoopUntil
kTuneStartNewMaster
callBackProc

A pointer to a TuneCallBackProc callback.
refCon

A reference constant to be passed to your TuneCallBackProc callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/

ComponentResult TuneQueue (
   TunePlayer         tp,
   unsigned long      *tune,
   Fixed              tuneRate,
   unsigned long      tuneStartPosition,
   unsigned long      tuneStopPosition,
   unsigned long      queueFlags,
   TuneCallBackUPP    callBackProc,
   long               refCon ){
printf ("TuneQueue",tp,*tune,tuneRate,tuneStartPosition,tuneStopPosition,queueFlags,callBackProc,refCon);
};


/*NASetNoteChannelVolume

Sets the volume on the specified note channel.

ComponentResult NASetNoteChannelVolume (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   Fixed            volume );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
noteChannel

The note channel to reset. You obtain the note channel identifier from the NANewNoteChannel or the NANewNoteChannelFromAtomicInstrument function.
volume

A fixed 16.16 number. NASetNoteChannelVolume sets the volume for the note channel, which is different from a kControllerVolume setting. Both volume settings allow fractional values of 0.0 to 1.0. Each value modifies the other. For example, a kControllerVolume value of 0.5 and a NASetNoteChannelVolume value of 0.5 result in a 0.25 volume level.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/

ComponentResult NASetNoteChannelVolume (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   Fixed            volume ){
printf ("NASetNoteChannelVolume ",na,noteChannel,volume);
};


