#include <QuickTime/QuickTime.h>



/*ImageCodecDismissStandardParameterDialog

Retrieves values from a standard parameter dialog box created by the low-level ImageCodecCreateStandardParameterDialog function, then closes the dialog box.

ComponentResult ImageCodecDismissStandardParameterDialog (
   ComponentInstance    ci,
   QTParameterDialog    createdDialog );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent. This must be the instance passed to ImageCodecCreateStandardParameterDialog to create the dialog box.
createdDialog

A reference to the dialog box created by the call to ImageCodecCreateStandardParameterDialog.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function should be called after the ImageCodecIsStandardParameterDialogEvent function returns codecParameterDialogConfirm or userCanceledErr, which indicate that the user has dismissed the dialog box. The function dismisses the dialog box, deallocating any memory allocated during the call to ImageCodecCreateStandardParameterDialog.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecDismissStandardParameterDialog (
   ComponentInstance    ci,
   QTParameterDialog    createdDialog ){
printf ("ImageCodecDismissStandardParameterDialog",ci,createdDialog);
};

/*ImageCodecIsStandardParameterDialogEvent

Processes events related to a standard parameters dialog box created by ImageCodecCreateStandardParameterDialog.

ComponentResult ImageCodecIsStandardParameterDialogEvent (
   ComponentInstance    ci,
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent. This must be the instance that was passed to ImageCodecCreateStandardParameterDialog to create the dialog box.
pEvent

A pointer to an EventRecord structure.
createdDialog

A reference to the dialog box created by the call to ImageCodecCreateStandardParameterDialog.
Return Value

If the error code returned is featureUnsupported, your application should process the event in the normal way. If it is noErr, the event was processed. If this function returns any other value, an error occurred. See Error Codes.
Discussion

This function returns an error code that indicates whether the event pointed to by pEvent was processed or not. After you call ImageCodecCreateStandardParameterDialog to create a standard parameter dialog box, you must pass every non-null event to this function. It processes events related to the standard parameter dialog box, passing other events to your application for processing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult ImageCodecIsStandardParameterDialogEvent (
   ComponentInstance    ci,
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog ){
printf ("CodecIsStandardParameterDialogEvent",ci,*pEvent,createdDialog);
};

/*ImageCodecStandardParameterDialogDoAction

Allows you to control the behavior of a standard parameter dialog box created by ImageCodecCreateStandardParameterDialog.

ComponentResult ImageCodecStandardParameterDialogDoAction (
   ComponentInstance    ci,
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent. This must be the same instance as was passed to ImageCodecCreateStandardParameterDialog to create the dialog box.
createdDialog

A reference to the dialog box created by the call to ImageCodecCreateStandardParameterDialog.
action

The action selector (see below), which determines which of the available actions you want the function to perform. See these constants: 
pdActionConfirmDialog
pdActionSetAppleMenu
pdActionSetEditMenu
pdActionGetDialogValues
pdActionSetPreviewUserItem
pdActionSetPreviewPicture
pdActionSetColorPickerEventProc
pdActionSetDialogTitle
pdActionGetSubPanelMenu
pdActionActivateSubPanel
pdActionConductStopAlert
params

The (optional) parameter to the action. The type passed in this parameter depends on the value of the action parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to change the default behavior of the standard parameter dialog box, and provides a mechanism for your application to communicate with controls that were incorporated into an application dialog box. It also allows you to retrieve parameter values from the dialog box at any time. You specify which function will be performed by passing an action selector in the action parameter and, optionally, a single parameter in the params parameter. Some of the actions you can specify through this function are only appropriate if you have incorporated standard parameter dialog box controls within a dialog box created by your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult ImageCodecStandardParameterDialogDoAction (
   ComponentInstance    ci,
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params ){
printf ("ImageCodecStandardParameterDialogDoAction",ci,createdDialog,action,params);
};


/*ImageCodecCreateStandardParameterDialog

Creates a parameters dialog box for a specified effect.

ComponentResult ImageCodecCreateStandardParameterDialog (
   ComponentInstance           ci,
   QTAtomContainer             parameterDescription,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   DialogPtr                   existingDialog,
   short                       existingUserItem,
   QTParameterDialog           *createdDialog );
Parameters
ci

An effects component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent. The dialog box that is created will allow the user to specify the parameters of this effect.
parameterDescription

The parameter description atom container for this effect. You can obtain a valid parameter description by calling ImageCodecGetParameterList. A parameter is optionally tweenable if defined as kAtomInterpolateIsOptional in its parameter description atom.
parameters

The atom container that will receive the user's chosen parameter values once the dialog has been dismissed.
dialogOptions

Controls how parameters containing tween data are presented in the created dialog box. If dialogOptions contains 0, two values are collected for each parameter that can be tweened, and the usual tweening operation will be performed for the duration of the effect being controlled. For other values,. See these constants: 
pdOptionsCollectOneValue
pdOptionsAllowOptionalInterpolations
existingDialog

An existing dialog box that will have the controls from the standard parameters dialog box added to it. Set this parameter to NIL if you want this function to create a stand-alone dialog box.
existingUserItem

The number of the user item in the existing dialog box that should be replaced with controls from the standard parameter dialog box. You should only pass a value to this parameter if the existingDialog parameter is not NIL.
createdDialog

On return, a reference to the dialog created and displayed by the function. This reference is required by several other low-level effects functions. It will contain a valid dialog identifier even if you requested that the controls from the standard parameter dialog box be incorporated into an existing dialog box.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a low-level function that can be used to create a standard parameter dialog box for a specified effect, allowing the user to set the parameter values for the effect. You can optionally request that the controls from the dialog box be included within a dialog box of the calling application. The following sample code shows how to create a standard parameter dialog box and add effects controls:// ImageCodecCreateStandardParameterDialog coding example
// See "Discovering QuickTime," page 303
pMovableModalDialog =GetNewDialog(kExtraDialogID, NIL, (WindowRef)-1);
if (pMovableModalDialog !=NIL) {
    ImageCodecCreateStandardParameterDialog(
        compInstance,
        qtacParameterDescription,
        qtacEffectSample,
        pdOptionsModelDialogBox,
        pMovableModalDialog,
        kExtraUserItemID,
        &lCreatedDialogID);
    ShowWindow(pMovableModalDialog);
    SelectWindow(pMovableModalDialog);
    SetPort(pMovableModalDialog);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult ImageCodecCreateStandardParameterDialog (
   ComponentInstance           ci,
   QTAtomContainer             parameterDescription,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   DialogPtr                   existingDialog,
   short                       existingUserItem,
   QTParameterDialog           *createdDialog ){
printf ("ImageCodecCreateStandardParameterDialog",ci,parameterDescription,parameters,dialogOptions,existingDialog,existingUserItem,*createdDialog);
};



/*CurveInsertPointIntoPath

Adds a new point to a path.

ComponentResult CurveInsertPointIntoPath (
   ComponentInstance    effect,
   gxPoint              *aPoint,
   Handle               thePath,
   unsigned long        contourIndex,
   unsigned long        pointIndex,
   Boolean              ptIsOnPath );
Parameters
effect

The instance of the QuickTime vector codec component for the request. Your software obtains this reference when calling the Component Manager's OpenComponent or OpenDefaultComponent function.
aPoint

A pointer to the point to add to the path.
thePath

A handle to the path to which to add the point.
contourIndex

The index of the path contour to which to add the point.
pointIndex

The index of the point to add.
ptIsOnPath

If TRUE, specifies that the new point is to be on the path.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is best for adding a single point to a path rather than large numbers of points.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult CurveInsertPointIntoPath (
   ComponentInstance    effect,
   gxPoint              *aPoint,
   Handle               thePath,
   unsigned long        contourIndex,
   unsigned long        pointIndex,
   Boolean              ptIsOnPath ){
printf ("CurveInsertPointIntoPath",effect,*aPoint,thePath,contourIndex,pointIndex,ptIsOnPath);
};


/*CurveAddPathAtomToVectorStream

Adds a path to a vector data stream.

ComponentResult CurveAddPathAtomToVectorStream (
   ComponentInstance    effect,
   Handle               pathData,
   Handle               vectorStream );
Parameters
effect

The instance of the QuickTime vector codec component for the request. Your software obtains this reference when calling the Component Manager's OpenComponent or OpenDefaultComponent function.
pathData

A handle to the data for the path.
vectorStream

A handle to the vector data stream to which to add the path.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function adds the path to the end of the specified vector data stream and resizes the vector data stream handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult CurveAddPathAtomToVectorStream (
   ComponentInstance    effect,
   Handle               pathData,
   Handle               vectorStream ){
printf ("CurveAddPathAtomToVectorStream",effect,pathData,vectorStream);
};



/*CurveAddZeroAtomToVectorStream

Adds a kCurveEndAtom to a vector data stream; this atom marks the end of the vector data stream,

ComponentResult CurveAddZeroAtomToVectorStream (
   ComponentInstance    effect,
   Handle               vectorStream );
Parameters
effect

The instance of the QuickTime vector codec component for the request. Your software obtains this reference when calling the Component Manager's OpenComponent or OpenDefaultComponent function.
vectorStream

A handle to the vector data stream to which to add the kCurveEndAtom atom.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function adds a kCurveEndAtom atom to the end of the specified vector data stream and resizes the vector data stream handle. The kCurveEndAtom atom is required at the end of a vector data stream, and there may be only one kCurveEndAtom atom in the stream.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult CurveAddZeroAtomToVectorStream (
   ComponentInstance    effect,
   Handle               vectorStream ){
printf ("CurveAddZeroAtomToVectorStream",effect,vectorStream);
};

/*CurveNewPath

Creates a new path.

ComponentResult CurveNewPath (
   ComponentInstance    effect,
   Handle               *pPath );
Parameters
effect

The instance of the QuickTime vector codec component for the request. Your software obtains this reference when calling the Component Manager's OpenComponent or OpenDefaultComponent function.
pPath

A pointer to a handle that is to receive the new path.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The path created by this function contains one contour and no points. The caller must dispose of the handle when it is finished with it (with Macintosh, by calling DisposeHandle).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult CurveNewPath (
   ComponentInstance    effect,
   Handle               *pPath ){
printf ("CurveNewPath",effect,pPath);
};


/*CurveCreateVectorStream

Creates a new, empty vector data stream.

ComponentResult CurveCreateVectorStream (
   ComponentInstance    effect,
   Handle               *pStream );
Parameters
effect

The instance of the QuickTime vector codec component for the request. Your software obtains this reference when calling the Component Manager's OpenComponent or OpenDefaultComponent function.
pStream

A pointer to the handle that is to receive the newly created vector data stream.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the stream when finished with it. This can be done by calling DisposeHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult CurveCreateVectorStream (
   ComponentInstance    effect,
   Handle               *pStream ){
printf ("CurveCreateVectorStream",effect,*pStream);
};





