#include <Foundation/NSScriptObjectSpecifiers.h>


@implementation NSScriptObjectSpecifier

/*key

Returns the key of the receiver.

- (NSString *)key
Return Value

The key of the receiver.
Availability
Available in Mac OS X v10.0 and later.
See Also
– keyClassDescription
– setKey:*/
- (NSString *)key{}

/*objectsByEvaluatingSpecifier

Returns the actual object represented by the nested series of object specifiers.

- (id)objectsByEvaluatingSpecifier
Return Value

The actual object represented by the nested series of object specifiers.
Discussion

Recursively obtains the next container in a nested series of object specifiers until it reaches the top-level container specifier (which is either an NSWhoseSpecifier or the application object), after which it begins evaluating each object specifier (objectsByEvaluatingWithContainers:) going in the opposite direction (top-level to innermost) as it unwinds from the stack. Returns the actual object represented by the nested series of object specifiers. Returns nil if a container specifier could not be evaluated or if no top-level container specifier could be found. Thus nil can be a valid value or can indicate an error; you can use evaluationErrorNumber to determine if and which error occurred and evaluationErrorSpecifier to find the container specifier responsible for the error. In the normal course of command processing, this method is invoked by an NSScriptCommand object’s evaluatedArguments and evaluatedReceivers methods, which take as message receiver the innermost object specifier.
Availability
Available in Mac OS X v10.0 and later.
See Also
– indicesOfObjectsByEvaluatingWithContainer:count:*/
- (id)objectsByEvaluatingSpecifier{}

/*objectsByEvaluatingWithContainers:

Returns the actual object or objects specified by the receiver as evaluated in the context of given container object. 

- (id)objectsByEvaluatingWithContainers:(id)containers
Return Value

The actual object or objects specified by the receiver as evaluated in the context of its container object or objects (containers).
Discussion

Invokes indicesOfObjectsByEvaluatingWithContainer:count: on self to get an array of pointers to indices of elements in containers that have values paired with the message receiver’s key. This method then uses key-value coding to obtain the object or objects associated with the key; it returns these objects or nil if there are no matching values in containers. If there are multiple matching values, they are returned in an NSArray; if matching values are nil, NSNull objects are substituted. If containers is an NSArray, the method recursively evaluates each element in the array and returns an NSArray with evaluated objects (including NSNulls) in their corresponding slots.
Availability
Available in Mac OS X v10.0 and later.
See Also
– objectsByEvaluatingSpecifier*/
- (id)objectsByEvaluatingWithContainers:(id)containers{}
/*keyClassDescription

Returns the class description of the objects specified by the receiver.

- (NSScriptClassDescription *)keyClassDescription
Return Value

The class description of the objects specified by the receiver.
Availability
Available in Mac OS X v10.0 and later.
See Also
– key
– setKey:*/
- (NSScriptClassDescription *)keyClassDescription{}


@end

 @implementation NSIndexSpecifier

/*initWithContainerClassDescription:containerSpecifier:key:index:

Initializes an allocated NSIndexSpecifier object with a class description, container specifier, collection key, and object index.

- (id)initWithContainerClassDescription:(NSScriptClassDescription *)classDescription containerSpecifier:(NSScriptObjectSpecifier *)containerSpecifier key:(NSString *)collectionKey index:(int)objectIndex
Parameters
classDescription

Description for the container of the collection.
containerSpecifier

Container of the collection.
collectionKey

Name of the collection.
objectIndex

The object within the key collection the index specifier is to identify.
Return Value

Initialized NSIndexSpecifier object with its index property set to objectIndex.
Discussion

Invokes the super class’s initWithContainerClassDescription:containerSpecifier:key: method and sets the index property of the index specifier to objectIndex.
Availability
Available in Mac OS X v10.0 and later.*/
- (id)initWithContainerClassDescription:(NSScriptClassDescription *)classDescription containerSpecifier:(NSScriptObjectSpecifier *)containerSpecifier key:(NSString *)collectionKey{}

@end

@implementation  NSMiddleSpecifier
@end

@implementation NSNameSpecifier 
@end


@implementation NSPositionalSpecifier
@end

 @implementation NSPropertySpecifier
@end


@implementation NSRandomSpecifier

@end



@implementation  NSRangeSpecifier 

/*startSpecifier

Returns the object specifier representing the first object of the range.

- (NSScriptObjectSpecifier *)startSpecifier
Return Value

The object specifier representing the first object of the range.
Availability
Available in Mac OS X v10.0 and later.*/
- (NSScriptObjectSpecifier *)startSpecifier{}

/*endSpecifier

Returns the object specifier representing the last object of the range.

- (NSScriptObjectSpecifier *)endSpecifier
Return Value

The object specifier representing the last object of the range.
Availability
Available in Mac OS X v10.0 and later.*/
- (NSScriptObjectSpecifier *)endSpecifier{}


@end


@implementation  NSRelativeSpecifier 
/*baseSpecifier

Returns a specifier for the base object.

- (NSScriptObjectSpecifier *)baseSpecifier
Return Value

A specifier for the base object—the object to which the relative specifier is related.
Availability
Available in Mac OS X v10.0 and later.*/
- (NSScriptObjectSpecifier *)baseSpecifier{}

/*relativePosition

Returns the relative position encapsulated by the receiver.

- (NSRelativePosition)relativePosition
Return Value

The relative position encapsulated by the receiver.
Availability
Available in Mac OS X v10.0 and later.*/
- (NSRelativePosition)relativePosition{}





@end

 @implementation NSUniqueIDSpecifier
/*initWithContainerClassDescription:containerSpecifier:key:uniqueID:

Returns an NSUniqueIDSpecifier object, initialized with the given arguments.

- (id)initWithContainerClassDescription:(NSScriptClassDescription *)classDesc containerSpecifier:(NSScriptObjectSpecifier *)container key:(NSString *)property uniqueID:(id)uniqueID
Parameters
classDesc

The class description for the new object.
container

The container for the new object.
property

The property for the new object.
uniqueID

The unique ID for the new object.

uniqueID must be an instance of NSNumber or NSString. The type should match the declared type of the attribute of the specified scriptable class whose four-character code is 'ID '.
Return Value

An NSUniqueIDSpecifier object, initialized with the given arguments. 
Discussion

Invokes the super class’s initWithContainerClassDescription:containerSpecifier:key: method and sets the ID to uniqueID.
Availability
Available in Mac OS X v10.2 and later.*/
- (id)initWithContainerClassDescription:(NSScriptClassDescription *)classDesc containerSpecifier:(NSScriptObjectSpecifier *)container key:(NSString *)property uniqueID:(id)uniqueID{}

@end

 @implementation NSWhoseSpecifier 
@end