#define C_LANG

#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif


/*CFBundleCopyResourceURL

Returns the location of a resource contained in the specified bundle.

CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName
);
Parameters
bundle

The bundle to examine. 
resourceName

The name of the requested resource. 
resourceType

The abstract type of the requested resource. The type is expressed as a filename extension, such as jpg. Pass NULL if you dont need to search by type.
subDirName

The name of the subdirectory of the bundles resources directory to search. Pass NULL to search the standard CFBundle resource locations.
Return Value

A CFURL object describing the location of the requested resource, or NULL if the resource cannot be found. Ownership follows the Create Rule.
Discussion

For example, if a bundle contains a subdirectory WaterSounds that includes a file Water1.aiff, you can retrieve the URL for the file using:CFBundleCopyResourceURL(bundle, CFSTR("Water1"), CFSTR("aiff"), CFSTR("WaterSounds"));

Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName){
//TODO
};

/*CFBundleCopyResourcesDirectoryURL

Returns the location of a bundles Resources directory.

CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundles resources directory, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

In general, you should never need to use this function. Use CFBundleCopyResourceURL and similar functions instead. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle){
//TODO
};

/*CFBundleCreate

Creates a CFBundle object.

CFBundleRef CFBundleCreate (
   CFAllocatorRef allocator,
   CFURLRef bundleURL
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
bundleURL

The location of the bundle for which to create a CFBundle object.
Return Value

A CFBundle object created from the bundle at bundleURL. Ownership follows the Create Rule.

Returns NULL if there was a memory allocation problem. May return an existing CFBundle object with the reference count incremented. May return NULL if the bundle doesn’t exist at bundleURL (see Discussion). 
Discussion

Once a bundle has been created, it is cached; the bundle cache is flushed only periodically. CFBundleCreate does not check that a cached bundle still exists in the filesystem. If a bundle is deleted from the filesystem, it is therefore possible for CFBundleCreate to return a cached bundle that has actually been deleted.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleCreate (
   CFAllocatorRef allocator,
   CFURLRef bundleURL){
//TODO
};

/*CFBundleGetFunctionPointerForName

Returns a pointer to a function in a bundle’s executable code using the function name as the search key.

void *CFBundleGetFunctionPointerForName (
   CFBundleRef bundle,
   CFStringRef functionName
);
Parameters
bundle

The bundle to examine. 
functionName

The name of the function to locate. 
Return Value

A pointer to a function in a bundle’s executable code, or NULL if functionName cannot be found. Ownership follows the Get Rule.
Discussion

Calling this function will cause the bundle’s code to be loaded if necessary. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void *CFBundleGetFunctionPointerForName (
   CFBundleRef bundle,
   CFStringRef functionName){
//TODO
};

/*CFBundleCopyExecutableURL

Returns the location of a bundle’s main executable code.

CFURLRef CFBundleCopyExecutableURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundle’s executable code, or NULL if none is found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyExecutableURL (
   CFBundleRef bundle){
///TODO
};

/*CFBundleGetMainBundle

Returns an application’s main bundle.

CFBundleRef CFBundleGetMainBundle ();
Return Value

A CFBundle object representing the application’s main bundle, or NULL if it is not possible to create a bundle. Ownership follows the Get Rule.
Discussion

CFBundle creates a main bundle whenever it possibly can, even for unbundled apps. There are a few situations in which it is not possible, so you should check the return value against NULL, but this happens only in exceptional circumstances.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetMainBundle (){
//TODO
};

/*CFSTR

Creates an immutable string from a constant compile-time string.

CFStringRef CFSTR (
   const char *cStr
);
Parameters
cStr

A C string (that is, text enclosed in double-quotation marks) from which the string is to be created. The characters enclosed by the quotation marks must be ASCII characters, otherwise the behavior is undefined.
Return Value

An immutable string, or NULL if there was a problem creating the object. The returned object is a constant. You may retain and release it, similar to other immutable CFString objects, but are not required to do so—it will remain valid until the program terminates.
Discussion

The CFSTR macro is a convenient way to create CFString representations of constant compile-time strings.

A value returned by CFSTR has the following semantics:
Values returned from CFSTR are not released by CFString—they are guaranteed to be valid until the program terminates. 
Values returned from CFSTR can be retained and released in a balanced fashion, like any other CFString, but you are not required to do so. 

Non-ASCII characters (that is, character codes greater than 127) are not supported. If you use them, the result is undefined. Even if using them works for you in testing, it might not work if the user selects a different language preference. 

Note that when using this macro as an initializer, you must compile using the flag -fconstant-cfstrings (see Options Controlling C Dialect).
Availability
Available in Mac OS X v10.0 and later.*/

CFStringRef CFSTR (
 const char *cStr){
//TODO
};

/*CFShow

Prints a description of a Core Foundation object.

void CFShow (
   CFTypeRef obj
);
Parameters
obj

A Core Foundation object derived from CFType. If obj is not a Core Foundation object, an assertion is raised. 
Discussion

This function is useful as a debugging aid for Core Foundation objects. Because these objects are based on opaque types, it is difficult to examine their contents directly. However, the opaque types implement description function callbacks that return descriptions of their objects. This function invokes these callbacks. 
Special Considerations

You can use CFShow in one of two general ways. If your debugger supports function calls (such as gdb does), call CFShow in the debugger:(gdb) call (void) CFShow(string)
Hello World


You can also incorporate calls to CFShow in a test version of your code to print out "snapshots" of Core Foundation objects to the console.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFString.h*/
void CFShow (
   CFTypeRef obj){
//TODO
};


/*CFURLCreateFromFSRef

Creates a URL from a given directory or file.

CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
fsRef

The file or directory representing the URL. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef){
//TODO
};


/*CFURLGetFSRef

Converts a given URL to a file or directory object.

Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef
);
Parameters
url

The CFURL object to convert to a file or directory object.
fsRef

Upon return, contains the file or directory object representing url.
Return Value

true if the conversion was successful, otherwise false.
Special Considerations

The function cannot create an FSRef object if the path specified by url contains an alias. The function can, however, traverse symbolic links.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef){
//TODO
};


/*CFURLCreateCopyAppendingPathComponent

Creates a copy of a given URL and appends a path component.

CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The CFURL object to which to append a path component. 
pathComponent

The path component to append to url. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components. Pass true if the new component indicates a directory, false otherwise. 
Return Value

A copy of url appended with pathComponent. Ownership follows the Create Rule.
Discussion

The isDirectory argument specifies whether or not the new path component points to a file or a to directory. Note that the URL syntax for a directory and for a file at otherwise the same location are slightly different—directory URLs must end in “/”. If you have the URL http://www.apple.com/foo/ and you append the path component bar, then if isDirectory is YES then the resulting URL is http://www.apple.com/foo/bar/, whereas if isDirectory is NO then the resulting URL is http://www.apple.com/foo/bar. This difference is particularly important if you resolve another URL against this new URL. file.html relative to http://www.apple.com/foo/bar is http://www.apple.com/foo/file.html, whereas file.html relative to http://www.apple.com/foo/bar/ is http://www.apple.com/foo/bar/file.html.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory){
//TODO
};


/*CFStringHasPrefix

Determines if the character data of a string begin with a specified sequence of characters.

Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix
);
Parameters
theString

The string to search. 
prefix

The prefix to search for.
Return Value

true if theString begins with prefix, false if otherwise. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringHasPrefix (
   CFStringRef theString,
   CFStringRef prefix){
//TODO
};


/*CFStringGetBytes

Fetches a range of the characters from a string into a byte buffer after converting the characters to a specified encoding.

CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen
);
Parameters
theString

The string upon which to operate. 
range

The range of characters in theString to process. The specified range must not exceed the length of the string.
encoding

The string encoding of the characters to copy to the byte buffer. 
lossByte

A character (for example, '?') that should be substituted for characters that cannot be converted to the specified encoding. Pass 0 if you do not want lossy conversion to occur. 
isExternalRepresentation

true if you want the result to be in an “external representation” format. In such a format, it may contain a byte order marker (BOM) specifying endianness and this function might have to perform byte swapping. 
buffer

The byte buffer into which the converted characters are written. The buffer can be allocated on the heap or stack. Pass NULL if you do not want conversion to take place but instead want to know if conversion will succeed (the function result is greater than 0) and, if so, how many bytes are required (usedBufLen).
maxBufLen

The size of buffer and the maximum number of bytes that can be written to it. 
usedBufLen

On return, the number of converted bytes actually in buffer. You may pass NULL if you are not interested in this information.
Return Value

The number of characters converted. 
Discussion

This function is the basic encoding-conversion function for CFString objects. As with the other functions that get the character contents of CFString objects, it allows conversion to a supported 8-bit encoding. Unlike most of those other functions, it also allows “lossy conversion.” The function permits the specification of a “loss byte” in a parameter; if a character cannot be converted this character is substituted and conversion proceeds. (With the other functions, conversion stops at the first error and the operation fails.)

Because this function takes a range and returns the number of characters converted, it can be called repeatedly with a small fixed size buffer and different ranges of the string to do the conversion incrementally.

This function also handles any necessary manipulation of character data in an “external representation” format. This format makes the data portable and persistent (disk-writable); in Unicode it often includes a BOM (byte order marker) that specifies the endianness of the data.

The CFStringCreateExternalRepresentation function also handles external representations and performs lossy conversions. The complementary function CFStringCreateWithBytes creates a string from the characters in a byte buffer.
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetBytes (
   CFStringRef theString,
   CFRange range,
   CFStringEncoding encoding,
   UInt8 lossByte,
   Boolean isExternalRepresentation,
   UInt8 *buffer,
   CFIndex maxBufLen,
   CFIndex *usedBufLen){
//TODO
};

/*CFStringGetLength

Returns the number (in terms of UTF-16 code pairs) of characters in a string.

CFIndex CFStringGetLength (
   CFStringRef theString
);
Parameters
theString

The string to examine. 
Return Value

The number (in terms of UTF-16 code pairs) of characters stored in theString. 
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetLength (
   CFStringRef theString){
//TODO
};


/*CFDictionarySetValue

Sets the value corresponding to a given key.

void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If this parameter is a fixed-capacity dictionary and it is full before this operation, and the key does not exist in the dictionary, the behavior is undefined. 
key

The key of the value to set in theDict. If a key which matches key is already present in the dictionary, only the value for the key is changed ("add if absent, replace if present"). If no key matches key, the key-value pair is added to the dictionary.

If a key-value pair is added, both key and value are retained by the dictionary, using the retain callback provided when theDict was created. key must be of the type expected by the key retain callback. 
value

The value to add to or replace in theDict. value is retained using the value retain callback provided when theDict was created, and the previous value if any is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionarySetValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value){
//TODO
};

/*CFStringGetCString

Copies the character contents of a string to a local C string buffer after converting the characters to a given encoding.

Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
buffer

The C string buffer into which to copy the string. The buffer must be at least bufferSize bytes in length. On return, the buffer contains the converted characters. If there is an error in conversion, the buffer contains only partial results.
bufferSize

The length of the local buffer in bytes (accounting for the NULL-terminator byte). 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

true upon success or false if the conversion fails or the provided buffer is too small. 
Discussion

This function is useful when you need your own copy of a strings character data as a C string. You also typically call it as a backup when a prior call to the CFStringGetCStringPtr function fails. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringGetCString (
   CFStringRef theString,
   char *buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding){
//TODO
};


/*CFStringCreateWithCString

Creates an immutable string from a C string.

CFStringRef CFStringCreateWithCString (
   CFAllocatorRef alloc,
   const char *cStr,
   CFStringEncoding encoding
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator.
cStr

The NULL-terminated C string to be used to create the CFString object.
encoding

The encoding of the characters in the C string. 
Return Value

An immutable string containing cStr (after stripping off the NULL terminating character), or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

A C string is a string of 8-bit characters terminated with an 8-bit NULL. Unichar and Unichar32 are not considered C strings.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithCString (
   CFAllocatorRef alloc,
   const char *cStr,
   CFStringEncoding encoding){
//TODO
};

/*CFBundleGetVersionNumber

Returns a bundle’s version number.

UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. The bundle’s version number can be number or a string of the standard form “2.5.3d5”. 
Return Value

A Mac OS vers resource style version number. If the bundle’s version number is a number, it is interpreted as the unsigned long integer format defined by the vers resource on Mac OS 9. If it is a string, it is automatically converted to the numeric representation, where the major version number is restricted to 2 BCD digits (in other words, it must be in the range 0-99) and the minor and bug fix version numbers are each restricted to a single BCD digit (0-9). See Technical Note TN1132 for more details.
Discussion

This function is only supported for the Mac OS vers resource style version numbers. Where other version number styles—namely X, or X.Y, or X.Y.Z—are used, you can use CFBundleGetValueForInfoDictionaryKey with the key kCFBundleVersionKey to extract the version number as a string from the bundle’s information dictionary.

Some version numbers of the form X, X.Y, and X.Y.Z may work with this function, if X <= 99, Y <= 9, and Z <= 9. Thus a version number 76.5.4 will work, but 76.12 will not work.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle){
//TODO
};

/*CFStringCreateArrayBySeparatingStrings

Creates an array of CFString objects from a single CFString object.

CFArrayRef CFStringCreateArrayBySeparatingStrings (
   CFAllocatorRef alloc,
   CFStringRef theString,
   CFStringRef separatorString
);
Parameters
alloc

The allocator to use to allocate memory for the new CFArray object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
theString

The string to be divided into substrings. The substrings should be separated by separatorString. 
separatorString

A string containing the character or characters used to separate the substrings in theString.
Return Value



/*CFDataGetBytes

Copies the byte contents of a CFData object to an external buffer.

void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer
);
Parameters
theData

The CFData object to examine. 
range

The range of bytes in theData to get. To get all of the contents, pass CFRangeMake(0,CFDataGetLength(theData)). 
buffer

A pointer to the byte buffer of length range.length that is allocated on the stack or heap. On return, the buffer contains the requested range of bytes. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDataGetBytes (
   CFDataRef theData,
   CFRange range,
   UInt8 *buffer){
//TODO
};

/*A new array that contains CFString objects that represent substrings of theString, or NULL if there was a problem creating the object. The order of elements in the array is identical to the order of the substrings in theString. If separatorString does not occur in theString, the result is an array containing theString. If separatorString is equal to theString, then the result is an array containing two empty strings. Ownership follows the Create Rule.
Discussion

This function provides a convenient way to convert units of data captured in a single string to a form (an array) suitable for iterative processing. One or more delimiter characters (or “separator string”) separates the substrings in the source string—these characters are frequently whitespace characters such as tabs and newlines (carriage returns). For example, you might have a file containing a localized list of place names with each name separated by a tab character. You could create a CFString object from this file and call this function on the string to obtain a CFArray object whose elements are these place names.

See also CFStringCreateByCombiningStrings. 
Availability
Available in Mac OS X v10.0 and later.*/

CFArrayRef CFStringCreateArrayBySeparatingStrings (
   CFAllocatorRef alloc,
   CFStringRef theString,
   CFStringRef separatorString){
//TODO
};



/*CFArrayGetValueAtIndex

Retrieves a value at a given index.

const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx
);
Parameters
theArray

The array to examine. 
idx

The index of the value to retrieve. If the index is outside the index space of theArray (0 to N-1 inclusive (where N is the count of theArray), the behavior is undefined. 
Return Value

The value at the idx index in theArray. If the return value is a Core Foundation Object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFArrayGetValueAtIndex (
   CFArrayRef theArray,
   CFIndex idx){
//TODO
};

/*CFDataGetLength

Returns the number of bytes contained by a CFData object.

CFIndex CFDataGetLength (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

An index that specifies the number of bytes in theData. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDataGetLength (
   CFDataRef theData){
//TODO
};

/*CFPreferencesCopyAppValue

Obtains a preference value for the specified key and application.

CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value to obtain. 
applicationID

The identifier of the application whose preferences to search, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

The preference data for the specified key and application. The data is returned as a Core Foundation Property List data type. Use the function CFGetTypeID to determine the values type. If no value was located, returns NULL. Ownership follows the Create Rule.
Discussion

Note that values returned from this function are immutable, even if you have recently set the value using a mutable object.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFPropertyListRef CFPreferencesCopyAppValue (
   CFStringRef key,
   CFStringRef applicationID){
//TODO
};


/*CFPreferencesAppSynchronize

Writes to permanent storage all pending changes to the preference data for the application, and reads the latest preference data from permanent storage.

Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID
);
Parameters
applicationID

The ID of the application whose preferences to write to storage, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Return Value

true if synchronization was successful, otherwise false. 
Discussion

Calling the function CFPreferencesSetAppValue is not in itself sufficient for storing preferences. The CFPreferencesAppSynchronize function writes to permanent storage all pending preference changes for the application. Typically you would call this function after multiple calls to CFPreferencesSetAppValue. Conversely, preference data is cached after it is first read. Changes made externally are not automatically incorporated. The CFPreferencesAppSynchronize function reads the latest preferences from permanent storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFPreferencesAppSynchronize (
   CFStringRef applicationID){
//TODO
};


/*CFPreferencesSetAppValue

Adds, modifies, or removes a preference.

void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID
);
Parameters
key

The preference key whose value you wish to set. 
value

The value to set for the specified key and application. Pass NULL to remove the specified key from the applications preferences. 
applicationID

The ID of the application whose preferences you wish to create or modify, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, com.foosoft.
Discussion

New preference values are stored in the standard application preference location, ~/Library/Preferences/. When called with kCFPreferencesCurrentApplication, modifications are performed in the preference domain Current User, Current Application, Any Host. If you need to create preferences in some other domain, use the low-level function CFPreferencesSetValue.

You must call the CFPreferencesAppSynchronize function in order for your changes to be saved to permanent storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFPreferencesSetAppValue (
   CFStringRef key,
   CFPropertyListRef value,
   CFStringRef applicationID){
//TODO
};

/*CFStringAppend

Appends the characters of a string to those of a CFMutableString object.

void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString
);
Parameters
theString

The string to which appendedString is appended. If theString is not a CFMutableString object, an assertion is raised.
appendedString

The string to append. 
Discussion

This function reallocates the backing store of theString to accommodate the new length.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppend (
   CFMutableStringRef theString,
   CFStringRef appendedString){
//TODO
};


/*CFStringReplaceAll

Replaces all characters of a CFMutableString object with other characters.

void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement
);
Parameters
theString

The string to modify. If this value is not a CFMutableString object, an assertion is raised. 
replacement

The replacement string to put into theString.
Discussion

The character buffer of theString is resized according to the length of the new characters.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringReplaceAll (
   CFMutableStringRef theString,
   CFStringRef replacement){
//TODO
};


/*CFStringCreateMutable

Creates an empty CFMutableString object.

CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned string. Pass 0 if there should be no character limit. Note that initially the string still has a length of 0; this parameter simply specifies what the maximum size is. CFMutableString might try to optimize its internal storage by paying attention to this value. 
Return Value

A new empty CFMutableString object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an empty (that is, content-less) CFMutableString object. You can add character data to this object with any of the CFStringAppend... functions, and thereafter you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableStringRef CFStringCreateMutable (
   CFAllocatorRef alloc,
   CFIndex maxLength){
//TODO
};


/*CFStringCompare

Compares one string with another string.

CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions
);
Parameters
theString1

The first string to use in the comparison. 
theString2

The second string to use in the comparison.
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See String Comparison Flags for the available flags.
Return Value

A CFComparisonResult value that indicates whether theString1 is equal to, less than, or greater than theString2. 
Discussion

You can affect how the comparison proceeds by specifying one or more option flags in compareOptions. Not all comparison options are currently implemented. 
Availability
Available in Mac OS X v10.0 and later.*/
CFComparisonResult CFStringCompare (
   CFStringRef theString1,
   CFStringRef theString2,
   CFOptionFlags compareOptions){
//TODO
};


/*CFStringGetSystemEncoding

Returns the default encoding used by the operating system when it creates strings.

CFStringEncoding CFStringGetSystemEncoding ();
Return Value

The default string encoding. 
Discussion

This function returns the default text encoding used by the OS when it creates strings. In Mac OS X, this encoding is determined by the user's preferred language setting. The preferred language is the first language listed in the International pane of the System Preferences.

In most situations you will not want to use this function, however, because your primary interest will be your application's default text encoding. The application encoding is required when you create a CFStringRef from strings stored in Resource Manager resources, which typically use one of the Mac encodings such as MacRoman or MacJapanese.

To get your application's default text encoding, call the GetApplicationTextEncoding Carbon function.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringEncoding CFStringGetSystemEncoding (){
//TODO
};

/*CFStringCreateMutableCopy

Creates a mutable copy of a string.

CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
maxLength

The maximum number of Unicode characters that can be stored by the returned object. Pass 0 if there should be no character limit. Note that initially the returned object still has the same length as the string argument; this parameter simply specifies what the maximum size is. CFString might try to optimize its internal storage by paying attention to this value. 
theString

A string to copy. 
Return Value

A string that has the same contents as theString. Returns NULL if there was a problem copying the object. Ownership follows the Create Rule.
Discussion

The returned mutable string is identical to the original string except for (perhaps) the mutability attribute. You can add character data to the returned string with any of the CFStringAppend... functions, and you can insert, delete, replace, pad, and trim characters with the appropriate CFString functions. If the maxLength parameter is greater than 0, any attempt to add characters beyond this limit results in a run-time error. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/CFMutableStringRef CFStringCreateMutableCopy (
   CFAllocatorRef alloc,
   CFIndex maxLength,
   CFStringRef theString){
//TODO
};


/*CFStringInsert

Inserts a string at a specified location in the character buffer of a CFMutableString object.

void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr
);
Parameters
str

The string to be modified. If this value is not a CFMutableString object, an assertion is raised. 
index

The index of the character in str after which the new characters are to be inserted. If the index is out of bounds, an assertion is raised. 
insertedStr

The string to insert into str. 
Discussion

To accommodate the new characters, this function moves any existing characters to the right of the inserted characters the appropriate number of positions. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringInsert (
   CFMutableStringRef str,
   CFIndex index,
   CFStringRef insertedStr){
//TODO
};

/*CFDataCreate

Creates an immutable CFData object using data copied from a specified byte buffer.

CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
bytes

A pointer to the byte buffer that contains the raw data to be copied into theData. 
length

The number of bytes in the buffer (bytes). 
Return Value

A new CFData object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You must supply a count of the bytes in the buffer. This function always copies the bytes in the provided buffer into internal storage. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFDataCreate (
   CFAllocatorRef allocator,
   const UInt8 *bytes,
   CFIndex length){
//TODO
};

/*CFStringGetCStringPtr

Quickly obtains a pointer to a C-string buffer containing the characters of a string in a given encoding.

const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
);
Parameters
theString

The string whose contents you wish to access. 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

A pointer to a C string or NULL if the internal storage of theString does not allow this to be returned efficiently. 
Discussion

This function either returns the requested pointer immediately, with no memory allocations and no copying, in constant time, or returns NULL. If the latter is the result, call an alternative function such as the CFStringGetCString function to extract the characters.

Whether or not this function returns a valid pointer or NULL depends on many factors, all of which depend on how the string was created and its properties. In addition, the function result might change between different releases and on different platforms. So do not count on receiving a non-NULL result from this function under any circumstances. 
Availability
Available in Mac OS X v10.0 and later.*/
const char *CFStringGetCStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding){
//TODO
};

/*CFURLCopyPath

Returns the path portion of a given URL.

CFStringRef CFURLCopyPath (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The path of anURL, or NULL if the URL cannot be decomposed (doesn't conform to RFC 1808). Ownership follows the Create Rule.
Discussion

This function does not resolve the URL against its base and replaces all percent escape sequences. This function's return value includes any leading slash (giving the path the normal POSIX appearance), if present. If this behavior is not appropriate, use CFURLCopyStrictPath whose return value omits any leading slash. You may also want to use the function CFURLCopyFileSystemPath, which returns the URL's path as a file system path for the given path style. If the path is to be passed to file system calls, you may also want to use the function CFURLGetFileSystemRepresentation, which returns a C string.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyPath (
   CFURLRef anURL){
//TODO
};


/*CFArrayAppendValue

Adds a value to an array giving it the new largest index.

void CFArrayAppendValue (
   CFMutableArrayRef theArray,
   const void *value
);
Parameters
theArray

The array to which value is to be added. If theArray is a limited-capacity array and it is full before this operation, the behavior is undefined. 
value

A CFType object or a pointer value to add to theArray. 
Discussion

The value parameter is retained by theArray using the retain callback provided when theArray was created. If value is not of the type expected by the retain callback, the behavior is undefined. The value parameter is assigned to the index one larger than the previous largest index and the count of theArray is increased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayAppendValue (CFMutableArrayRef theArray,const void *value){
//TODO
};

/*CFArrayGetCount

Returns the number of values currently in an array.

CFIndex CFArrayGetCount (
   CFArrayRef theArray
);
Parameters
theArray

The array to examine. 
Return Value

The number of values in theArray. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later*/
CFIndex CFArrayGetCount ( CFArrayRef theArray){
//TODO
};

/*CFArrayCreateMutable

Creates a new empty mutable array.

CFMutableArrayRef CFArrayCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFArrayCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of values that can be contained by the new array. The array starts empty and can grow to this number of values (and it can have less). If this parameter is 0, the array’s maximum capacity is not limited. The value must not be negative. 
callBacks

A pointer to a CFArrayCallBacks structure initialized with the callbacks for the array to use on each value in the array. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple array creations. This parameter may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. 

If any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFArrayCallBacks structure, the behavior is undefined. If any value put into the array is not one understood by one of the callback functions, the behavior when that callback function is used is undefined. If the array contains CFType objects only, then pass kCFTypeArrayCallBacks as this parameter to use the default callback functions.
Return Value

A new mutable array, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableArrayRef CFArrayCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFArrayCallBacks *callBacks){
//TODO
};

/*CFStringGetMaximumSizeForEncoding

Returns the maximum number of bytes a string of a specified length (in Unicode characters) will take up if encoded in a specified encoding.

CFIndex CFStringGetMaximumSizeForEncoding (
   CFIndex length,
   CFStringEncoding encoding
);
Parameters
length

The number of Unicode characters to evaluate. 
encoding

The string encoding for the number of characters specified by length. 
Return Value

The maximum number of bytes that could be required to represent length number of Unicode characters with the string encoding encoding. The number of bytes that the encoding actually ends up requiring when converting any particular string could be less than this, but never more.
Availability
Available in Mac OS X v10.0 and later.*/
CFIndex CFStringGetMaximumSizeForEncoding (
   CFIndex length,
   CFStringEncoding encoding){
//TODO
};

/*CFStringAppendCString

Appends a C string to the character contents of a CFMutableString object.

void CFStringAppendCString (
   CFMutableStringRef theString,
   const char *cStr,
   CFStringEncoding encoding
);
Parameters
theString

The string to which the characters from cStr are appended. If this value is not a CFMutableString object, an assertion is raised. 
cStr

A pointer to a C string buffer.
encoding

The encoding of the characters in cStr. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppendCString (
   CFMutableStringRef theString,
   const char *cStr,
   CFStringEncoding encoding){
//TODO
};

/*CFStringFindAndReplace

Replaces all occurrences of a substring within a given range.

CFIndex CFStringFindAndReplace (
   CFMutableStringRef theString,
   CFStringRef stringToFind,
   CFStringRef replacementString,
   CFRange rangeToSearch,
   CFOptionFlags compareOptions
);
Parameters
theString

The string to modify. 
stringToFind

The substring to search for in theString.
replacementString

The replacement string for stringToFind. 
rangeToSearch

The range within which to search in theString. 
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See “String Comparison Flags” for the available flags.
Return Value

The number of instances of stringToFind that were replaced. 
Discussion

The possible values of compareOptions are combinations of the kCFCompareCaseInsensitive, kCFCompareBackwards, kCFCompareNonliteral, and kCFCompareAnchored constants. 

The kCFCompareBackwards option can be used to replace a substring starting from the end, which could produce different results. For example, if the parameter theString is “AAAAA”, stringToFind is “AA”, and replacementString is “B”, then the result is normally “BBA”. However, if the kCFCompareBackwards constant is used, the result is “ABB.” 

The kCFCompareAnchored option assures that only anchored but multiple instances are found (the instances must be consecutive at start or end). For example, if the parameter theString is “AAXAA”, stringToFind is “A”, and replacementString is “B”, then the result is normally “BBXBB.” However, if the kCFCompareAnchored constant is used, the result is “BBXAA.”
Availability
Available in Mac OS X v10.2 and later.*/
CFIndex CFStringFindAndReplace (
   CFMutableStringRef theString,
   CFStringRef stringToFind,
   CFStringRef replacementString,
   CFRange rangeToSearch,
   CFOptionFlags compareOptions){
//TODO
};

/*CFRunLoopRun

Runs the current thread’s CFRunLoop object in its default mode indefinitely.

void CFRunLoopRun ();
Discussion

The current thread’s run loop runs in the default mode (see "Default Run Loop Mode") until the run loop is stopped with CFRunLoopStop or all the sources and timers are removed from the default run loop mode.

Run loops can be run recursively. You can call CFRunLoopRun from within any run loop callout and create nested run loop activations on the current thread’s call stack.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopRun (){
//TODO
};

/*CFRunLoopAddSource

Adds a CFRunLoopSource object to a run loop mode.

void CFRunLoopAddSource (
   CFRunLoopRef rl,
   CFRunLoopSourceRef source,
   CFStringRef mode
);
Parameters
rl

The run loop to modify. 
source

The run loop source to add. 
mode

The run loop mode to which to add source. Use the constant kCFRunLoopCommonModes to add source to the set of objects monitored by all the common modes. 
Discussion

If source is a version 0 source, this function calls the schedule callback function specified in the context structure for source. See CFRunLoopSourceContext for more details.

A run loop source can be registered in multiple run loops and run loop modes at the same time. When the source is signaled, whichever run loop that happens to detect the signal first will fire the source.

If rl already contains source in mode, this function does nothing.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopAddSource (
   CFRunLoopRef rl,
   CFRunLoopSourceRef source,
   CFStringRef mode){
//TODO
};

/*CFRunLoopGetCurrent

Returns the CFRunLoop object for the current thread.

CFRunLoopRef CFRunLoopGetCurrent ();
Return Value

Current thread’s run loop. Ownership follows the Get Rule.
Discussion

Each thread has exactly one run loop associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopRef CFRunLoopGetCurrent (){
//TODO
};
/*CFRunLoopSourceCreate

Creates a CFRunLoopSource object.

CFRunLoopSourceRef CFRunLoopSourceCreate (
   CFAllocatorRef allocator,
   CFIndex order,
   CFRunLoopSourceContext *context
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
order

A priority index indicating the order in which run loop sources are processed. When multiple run loop sources are firing in a single pass through the run loop, the sources are processed in increasing order of this parameter. If the run loop is set to process only one source per loop, only the highest priority source, the one with the lowest order value, is processed. This value is ignored for version 1 sources. Pass 0 unless there is a reason to do otherwise.
context

A structure holding contextual information for the run loop source. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call.
Return Value

The new CFRunLoopSource object. You are responsible for releasing this object.
Discussion

The run loop source is not automatically added to a run loop. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopSourceRef CFRunLoopSourceCreate (
   CFAllocatorRef allocator,
   CFIndex order,
   CFRunLoopSourceContext *context){
//TODO
};

/*CFURLGetFileSystemRepresentation

Fills a buffer with the file system's native string representation of a given URL's path.

Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen
);
Parameters
url

The CFURL object whose native file system representation you want to obtain. 
resolveAgainstBase

Pass true to return an absolute path name. 
buffer

A pointer to a character buffer. On return, the buffer holds the native file system's representation of url. The buffer is null-terminated. This parameter must be at least maxBufLen in size for the file system in question to avoid failures for insufficiently large buffers.
maxBufLen

The maximum number of characters that can be written to buffer.
Return Value

true if successful, false if an error occurred. 
Discussion

No more than maxBufLen bytes are written to buffer. If url requires more than maxBufLen bytes to represent itself, including the terminating null byte, this function returns false. To avoid this possible failure, you should pass a buffer with size of at least the maximum path length for the file system in question.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen){
//TODO
};

/*CFBundleCopyBundleURL

Returns the location of a bundle.

CFURLRef CFBundleCopyBundleURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundle, or NULL if the specified bundle does not exist. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyBundleURL (
   CFBundleRef bundle){
//TODO
};

/*CFBundleGetBundleWithIdentifier

Locate a bundle given its program-defined identifier.

CFBundleRef CFBundleGetBundleWithIdentifier (
   CFStringRef bundleID
);
Parameters
bundleID

The identifier of the bundle to locate. Note that identifier names are case-sensitive.
Return Value

A CFBundle object, or NULL if the bundle was not found. Ownership follows the Get Rule.
Discussion

For a bundle to be located using its identifier, the bundle object must have already been created. The principal intended purpose for locating bundles by identifier is so that code (in frameworks, plugins, etc.) can find its own bundle. If a bundle is created, then the bundle deleted from the filesystem and this function invoked afterwards, it will still return the original bundle.

Bundle identifiers are created by entering a value for the key CFBundleIdentifier in the bundle’s Info.plist file. 

To guarantee uniqueness, bundle identifiers take the form of Java style package names, such as com.myCompany.foo.bar.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetBundleWithIdentifier (
   CFStringRef bundleID){
//TODO
};


/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect){
//TODO
};


/*CFBooleanGetValue

Returns the value of a CFBoolean object as a standard C type Boolean.

Boolean CFBooleanGetValue (
   CFBooleanRef boolean
);
Parameters
boolean

The boolean to examine. 
Return Value

The value of boolean. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBooleanGetValue (
   CFBooleanRef boolean){
//TODO
};


/*CFStringCreateWithCharacters

Creates a string from a buffer of Unicode characters.

CFStringRef CFStringCreateWithCharacters (
   CFAllocatorRef alloc,
   const UniChar *chars,
   CFIndex numChars
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
chars

The buffer of Unicode characters to copy into the new string. 
numChars

The number of characters in the buffer pointed to by chars. Only this number of characters will be copied to internal storage. 
Return Value

An immutable string containing chars, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an immutable string from a client-supplied Unicode buffer. You must supply a count of the characters in the buffer. This function always copies the characters in the provided buffer into internal storage.

To save memory, this function might choose to store the characters internally in a 8-bit backing store. That is, just because a buffer of UniChar characters was used to initialize the object does not mean you will get back a non-NULL result from CFStringGetCharactersPtr. 
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithCharacters (
   CFAllocatorRef alloc,
   const UniChar *chars,
   CFIndex numChars){
//TODO
};


/*CFUUIDGetUUIDBytes

Returns the value of a UUID object as raw bytes.

CFUUIDBytes CFUUIDGetUUIDBytes (
   CFUUIDRef uuid
);
Parameters
uuid

The CFUUID object to examine. 
Return Value

The value of uuid represented as raw bytes. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDBytes CFUUIDGetUUIDBytes (
   CFUUIDRef uuid){
//TODO
};


/*CFNumberCreate

Creates a CFNumber object using a specified value.

CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the default allocator.
theType

A constant that specifies the data type of the value to convert. See Number Types for a list of possible values. 
valuePtr

A pointer to the value for the returned number object.
Return Value

A new number with the value specified by valuePtr. Ownership follows the Create Rule.
Discussion

The theType parameter is not necessarily preserved when creating a new CFNumber object. The CFNumber object will be created using whatever internal storage type the creation function deems appropriate. Use the function CFNumberGetType to find out what type the CFNumber object used to store your value. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr){
//TODO
};


/*CFUUIDGetConstantUUIDWithBytes

Returns a CFUUID object from raw UUID bytes.

CFUUIDRef CFUUIDGetConstantUUIDWithBytes (
   CFAllocatorRef alloc,
   UInt8 byte0,
   UInt8 byte1,
   UInt8 byte2,
   UInt8 byte3,
   UInt8 byte4,
   UInt8 byte5,
   UInt8 byte6,
   UInt8 byte7,
   UInt8 byte8,
   UInt8 byte9,
   UInt8 byte10,
   UInt8 byte11,
   UInt8 byte12,
   UInt8 byte13,
   UInt8 byte14,
   UInt8 byte15
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
byte0

Raw byte number 0.
byte1

Raw byte number 1.
byte2

Raw byte number 2.
byte3

Raw byte number 3.
byte4

Raw byte number 4.
byte5

Raw byte number 5.
byte6

Raw byte number 6.
byte7

Raw byte number 7.
byte8

Raw byte number 8.
byte9

Raw byte number 9.
byte10

Raw byte number 10.
byte11

Raw byte number 11.
byte12

Raw byte number 12.
byte13

Raw byte number 13.
byte14

Raw byte number 14.
byte15

Raw byte number 15.
Return Value

A CFUUID object. Ownership follows the Get Rule.
Discussion

This function can be used in headers to declare a UUID constant with #define. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDGetConstantUUIDWithBytes (
   CFAllocatorRef alloc,
   UInt8 byte0,
   UInt8 byte1,
   UInt8 byte2,
   UInt8 byte3,
   UInt8 byte4,
   UInt8 byte5,
   UInt8 byte6,
   UInt8 byte7,
   UInt8 byte8,
   UInt8 byte9,
   UInt8 byte10,
   UInt8 byte11,
   UInt8 byte12,
   UInt8 byte13,
   UInt8 byte14,
   UInt8 byte15){
//TODO
};



/*CFStringAppendFormat

Appends a formatted string to the character contents of a CFMutableString object.

void CFStringAppendFormat (
   CFMutableStringRef theString,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...
);
Parameters
theString

The string to which the formatted characters from format are appended. If this value is not a CFMutableString object, an assertion is raised.
formatOptions

A dictionary containing formatting options for the string (such as the thousand-separator character, which is dependent on locale). Currently, these options are an unimplemented feature. 
format

A formatted string with printf-style specifiers. 
...

Variable list of the values to be inserted in format.
Discussion

A formatted string is one with printf-style format specifiers embedded in the text such as %d (decimal), %f (double), and %@ (Core Foundation object). The subsequent arguments, in order, are substituted for the specifiers in the character data appended to theString. You can also reorder the arguments in the string by using modifiers of the form "n$" with the format specifiers (for example, %2$d).

For more information on supported specifiers, see the relevant section in “Strings”. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppendFormat (
   CFMutableStringRef theString,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...
){
//TODO
};


/*CFStringCreateWithFormat

Creates an immutable string from a formatted string and a variable number of arguments.

CFStringRef CFStringCreateWithFormat (
   CFAllocatorRef alloc,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatOptions

A CFDictionary object containing formatting options for the string (such as the thousand-separator character, which is dependent on locale). Currently, these options are an unimplemented feature. 
format

The formatted string with printf-style specifiers. For information on supported specifiers, see String Format Specifiers.
...

Variable list of the values to be inserted in format.
Return Value

An immutable string, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/

CFStringRef CFStringCreateWithFormat (
   CFAllocatorRef alloc,
   CFDictionaryRef formatOptions,
   CFStringRef format,
   ...){
//TODO
};


/*CFSwapInt32BigToHost

Converts a 32-bit integer from big-endian format to the host’s native byte order.

uint32_t CFSwapInt32BigToHost (
   uint32_t arg
);
Parameters
arg

The integer whose bytes should be swapped.
Return Value

The integer with its bytes swapped. If the host is big-endian, this function returns arg unchanged.
Availability
Available in Mac OS X v10.0 and later.*/
uint32_t CFSwapInt32BigToHost (
   uint32_t arg){
//TODO
};


/*CFSwapInt32HostToBig

Converts a 32-bit integer from the host’s native byte order to big-endian format.

uint32_t CFSwapInt32HostToBig (
   uint32_t arg
);
Parameters
arg

The integer whose bytes should be swapped.
Return Value

The integer with its bytes swapped. If the host is big-endian, this function returns arg unchanged.
Availability
Available in Mac OS X v10.0 and later.*/

uint32_t CFSwapInt32HostToBig (
   uint32_t arg){
//TODO
};


/*CFURLCreateFromFileSystemRepresentation

Creates a new CFURL object for a file system entity using the native representation.

CFURLRef CFURLCreateFromFileSystemRepresentation (
   CFAllocatorRef allocator,
   const UInt8 *buffer,
   CFIndex bufLen,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
buffer

The character bytes to convert into a CFURL object. This should be the path as you would use in POSIX function calls.
bufLen

The number of bytes in the buffer. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components—true if the pathname indicates a directory, false otherwise. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateFromFileSystemRepresentation (
   CFAllocatorRef allocator,
   const UInt8 *buffer,
   CFIndex bufLen,
   Boolean isDirectory){
//TODO
};


/*CFNotificationCenterAddObserver

Registers an observer to receive notifications.

void CFNotificationCenterAddObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFNotificationCallback callBack,
   CFStringRef name,
   const void *object,
   CFNotificationSuspensionBehavior suspensionBehavior
);
Parameters
center

The notification center to which to add the observer. 
observer

The observer. In Mac OS X v10.3 and later, this parameter may be NULL.

If the notification center is a Darwin notification center, this value must not be NULL.
callBack

The callback function to call when object posts the notification named name. 
name

The name of the notification to observe. If NULL, callback is called for any notification posted by object. 
object

The object to observe. For distributed notifications, object must be a CFString object. If NULL, callback is called when a notification named name is posted by any object.

If the notification center is a Darwin notification center, this value is ignored.
suspensionBehavior

Flag indicating how notifications should be handled when the application is in the background. See “Notification Delivery Suspension Behavior” for the list of available values.

If the notification center is a Darwin notification center, this value is ignored.
Discussion

The first time an observer is registered with a distributed notification center, the notification center creates a connection with the system-wide notification server and places a listening port into the common modes of the current thread’s run loop. When a notification is delivered, it is processed on this initial thread, even if the observer that is receiving the notification registered for the notification on a different thread.

Because loaded frameworks may potentially spawn threads and add their own observers before your code executes, you cannot know for certain which thread will receive distributed notifications. If you need to control which thread processes a notification, your callback function must be able to forward the notification to the proper thread. You can use a CFMessagePort object or a custom CFRunLoopSource object to send notifications to the correct thread’s run loop.
Availability
Available in Mac OS X v10.0 and later.*/

void CFNotificationCenterAddObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFNotificationCallback callBack,
   CFStringRef name,
   const void *object,
   CFNotificationSuspensionBehavior suspensionBehavior){
//TODO
};


/*CFNotificationCenterGetDistributedCenter

Returns the application’s distributed notification center.

CFNotificationCenterRef CFNotificationCenterGetDistributedCenter();
Return Value

The application’s distributed notification center. An application has only one distributed notification center, so this function returns the same value each time it is called. 
Discussion

A distributed notification center delivers notifications between applications. A notification object used with a distributed notification center must always be a CFString object and the notification dictionary must contain only property list values.
Availability
Available in Mac OS X v10.0 and later.*/
CFNotificationCenterRef CFNotificationCenterGetDistributedCenter(){
//TODO
};


/*CFNotificationCenterRemoveObserver

Stops an observer from receiving certain notifications.

void CFNotificationCenterRemoveObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFStringRef name,
   const void *object
);
Parameters
center

The notification center to modify. 
observer

The observer. This value must not be NULL.
name

The name of the notification to stop observing. If NULL, observer stops receiving callbacks for all notifications posted by object. 
object

The object to stop observing. For distributed notifications, object must be a CFString object. If NULL, observer stops receiving callbacks for all objects posting notifications named name.

If the notification center is a Darwin notification center, this value is ignored.
Discussion

If both name and object are NULL, this function unregisters observer from all the notifications for which it had previously registered with center.
Availability
Available in Mac OS X v10.0 and later.*/
void CFNotificationCenterRemoveObserver (
   CFNotificationCenterRef center,
   const void *observer,
   CFStringRef name,
   const void *object){
//TODO
};


/*CFArrayGetTypeID

Returns the type identifier for the CFArray opaque type.

CFTypeID CFArrayGetTypeID();
Return Value

The type identifier for the CFArray opaque type.
Discussion

CFMutableArray objects have the same type identifier as CFArray objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFArrayGetTypeID(){
//TODO
};


/*CFEqual

Determines whether two Core Foundation objects are considered equal.

Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2
);
Parameters
cf1

A CFType object to compare to cf2.
cf2

A CFType object to compare to cf1.
Return Value

true if cf1 and cf2 are of the same type and considered equal, otherwise false. 
Discussion

Equality is something specific to each Core Foundation opaque type. For example, two CFNumber objects are equal if the numeric values they represent are equal. Two CFString objects are equal if they represent identical sequences of characters, regardless of encoding. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFEqual (
   CFTypeRef cf1,
   CFTypeRef cf2){
//TODO
};


/*CFDictionaryGetTypeID

Returns the type identifier of all CFDictionary objects.

CFTypeID CFDictionaryGetTypeID ();
Return Value

The type identifier for the CFDictionary opaque type. 
Discussion

CFMutableDictionary objects have the same type identifier as CFDictionary objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDictionaryGetTypeID (){
//TODO
};


/*CFGetTypeID

Returns the unique identifier of an opaque type to which a Core Foundation object belongs.

CFTypeID CFGetTypeID (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A value of type CFTypeID that identifies the opaque type of cf. 
Discussion

This function returns a value that uniquely identifies the opaque type of any Core Foundation object. You can compare this value with the known CFTypeID identifier obtained with a “GetTypeID” function specific to a type, for example CFDateGetTypeID. These values might change from release to release or platform to platform.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFGetTypeID (
   CFTypeRef cf){
//TODO
};

/*CFBundleLoadExecutable

Loads a bundle’s main executable code into memory and dynamically links it into the running application.

Boolean CFBundleLoadExecutable (
   CFBundleRef bundle
);
Parameters
bundle

The bundle whose main executable you want to load. 
Return Value

true if the executable was successfully loaded, otherwise false. 
Discussion

You should typically try to avoid using this function, but instead use CFBundleGetFunctionPointerForName and related functions since these make memory management of the bundle easier.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBundleLoadExecutable (
   CFBundleRef bundle){
//TODO
};

/*CFURLCreateDataAndPropertiesFromResource

Loads the data and properties referred to by a given URL.

Boolean CFURLCreateDataAndPropertiesFromResource (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFDataRef *resourceData,
   CFDictionaryRef *properties,
   CFArrayRef desiredProperties,
   SInt32 *errorCode
);
Parameters
allocator

The allocator to use to allocate memory for the new CFData and CFDictionary objects returned in resourceData and properties. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The URL referring to the data and/or properties you wish to load.
resourceData

On return, contains a CFData object containing the data referred to by url. Ownership follows the Create Rule.
properties

On return, a pointer to a CFDictionary object containing the resource properties referred to by url. Ownership follows the Create Rule. 
desiredProperties

A list of the properties you wish to obtain and return in properties. See “File URL Properties” and “HTTP URL Properties” for the list of available properties.
errorCode

0 if successful, otherwise an error code indicating the nature of the problem. See “Error Codes” for a list of possible error codes.
Return Value

true if successful, false otherwise. 
Discussion

If you are interested in loading only the resource data or the resource's properties, pass NULL for the one you don't want. If properties is non-NULL and desiredProperties is NULL then all properties are fetched. Note that as much work as possible is done even if false is returned. For instance, if one property is not available, the others are fetched anyway. This function is intended for convenience, not performance.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFURLAccess.h*/
Boolean CFURLCreateDataAndPropertiesFromResource (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFDataRef *resourceData,
   CFDictionaryRef *properties,
   CFArrayRef desiredProperties,
   SInt32 *errorCode){
//TODO
};

/*CFURLCreateWithString

Creates a CFURL object using a given CFString object.

CFURLRef CFURLCreateWithString (
   CFAllocatorRef allocator,
   CFStringRef URLString,
   CFURLRef baseURL
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
URLString

The CFString object containing the URL string. 
baseURL

The URL to which URLString is relative. Pass NULL if URLString contains an absolute URL or if you want to create a relative URL. If URLString contains an absolute URL, baseURL is ignored. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Discussion

Any escape sequences in URLString will be interpreted using UTF-8. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateWithString (
   CFAllocatorRef allocator,
   CFStringRef URLString,
   CFURLRef baseURL){
//TODO
};

/*CFStringCreateWithSubstring

Creates an immutable string from a segment (substring) of an existing string.

CFStringRef CFStringCreateWithSubstring (
   CFAllocatorRef alloc,
   CFStringRef str,
   CFRange range
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
str

The string from which to create the new string. 
range

The range of characters in str to copy. The specified range must not exceed the length of the string.
Return Value

An immutable string, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithSubstring (
   CFAllocatorRef alloc,
   CFStringRef str,
   CFRange range){
//TODO
};

/*CFStringGetCharacterAtIndex

Returns the Unicode character at a specified location in a string.

UniChar CFStringGetCharacterAtIndex (
   CFStringRef theString,
   CFIndex idx
);
Parameters
theString

The string from which the Unicode character is obtained. 
idx

The position of the Unicode character in the CFString. 
Return Value

A Unicode character. 
Discussion

This function is typically called in a loop to fetch the Unicode characters of a string in sequence or to fetch a character at a known position (first or last, for example). Using it in a loop can be inefficient, especially with longer strings, so consider the CFStringGetCharacters function or the in-line buffer functions (CFStringInitInlineBuffer and CFStringGetCharacterFromInlineBuffer) as alternatives.
Availability
Available in Mac OS X v10.0 and later.*/
UniChar CFStringGetCharacterAtIndex (
   CFStringRef theString,
   CFIndex idx){
//TODO
};

/*CFDictionaryContainsKey

Reports whether or not a key is in a dictionary.

Boolean CFDictionaryContainsKey (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary to examine. 
key

The key for which to find matches in the dictionary. The key hash and equal callbacks provided when the dictionary was created, are used to compare. If the hash callback is NULL, key is treated as a pointer and converted to an integer. If the equal callback is NULL, pointer equality (in C, ==) is used. If key, or any of the keys in the dictionary, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if key is in the dictionary, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFDictionaryContainsKey (
   CFDictionaryRef theDict,
   const void *key){
//TODO
};

/*CFPropertyListCreateFromXMLData

Creates a property list using the specified XML or binary property list data.

CFPropertyListRef CFPropertyListCreateFromXMLData (
   CFAllocatorRef allocator,
   CFDataRef data,
   CFOptionFlags mutabilityOption,
   CFStringRef *errorString
);
Parameters
allocator

The allocator to use to allocate memory for the new property list. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
data

The raw bytes to convert into a property list. The bytes may be the content of an XML file or of a binary property list (see Property List Formats).
mutabilityOption

A constant that specifies the degree of mutability for the returned property list. See Property List Mutability Options for descriptions of possible values. 
errorString

On return, NULL if the conversion is successful, otherwise a string that describes the nature of the error. Error messages are not localized, but may be in the future, so they are not currently suitable for comparison.

Pass NULL if you do not wish to receive an error string. Ownership follows the Create Rule.
Return Value

A new property list if the conversion is successful, otherwise NULL. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFPropertyListRef CFPropertyListCreateFromXMLData (
   CFAllocatorRef allocator,
   CFDataRef data,
   CFOptionFlags mutabilityOption,
   CFStringRef *errorString){
//TODO
};


/*CFDictionaryCreate

Creates an immutable dictionary containing the specified key-value pairs.

CFDictionaryRef CFDictionaryCreate (
   CFAllocatorRef allocator,
   const void **keys,
   const void **values,
   CFIndex numValues,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
keys

A C array of the pointer-sized keys to be in the new dictionary. This value may be NULL if the numValues parameter is 0. This C array is not changed or freed by this function. The value must be a valid pointer to a C array of at least numValues pointers. 
values

A C array of the pointer-sized values to be in the new dictionary. This value may be NULL if the numValues parameter is 0. This C array is not changed or freed by this function. The value must be a valid pointer to a C array of at least numValues elements.
numValues

The number of key-value pairs to copy from the keys and values C arrays into the new dictionary. This number will be the count of the dictionary; it must be non-negative and less than or equal to the actual number of keys or values. 
keyCallBacks

A pointer to a CFDictionaryKeyCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare keys in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFDictionaryKeyCallBacks structure, the behavior is undefined. If any of the keys put into the collection is not one understood by one of the callback functions the behavior when that callback function is used is undefined.

If the collection will contain CFType objects only, then pass a pointer to kCFTypeDictionaryKeyCallBacks as this parameter to use the default callback functions.
valueCallBacks

A pointer to a CFDictionaryValueCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFDictionaryValueCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions the behavior when that callback function is used is undefined.

If the collection will contain CFType objects only, then pass a pointer to kCFTypeDictionaryValueCallBacks as this parameter to use the default callback functions.
Return Value

A new dictionary, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDictionaryRef CFDictionaryCreate (
   CFAllocatorRef allocator,
   const void **keys,
   const void **values,
   CFIndex numValues,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks){
//TODO
};


/*CFDictionaryGetValue

Returns the value associated with a key.

const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary examine.
key

The key for which to find a match in theDict. The key hash and equal callbacks provided when the dictionary was created are used to compare. If the hash callback was NULL, the key is treated as a pointer and converted to an integer. If the equal callback was NULL, pointer equality (in C, ==) is used. If key, or any of the keys in theDict, is not understood by the equal callback, the behavior is undefined. 
Return Value

The value associated with key in theDict, or NULL if no key-value pair matching key exists. Since NULL is also a valid value in some dictionaries, use CFDictionaryGetValueIfPresent to distinguish between a value that is not found, and a NULL value. If the value is a Core Foundation object, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const void *CFDictionaryGetValue (
   CFDictionaryRef theDict,
   const void *key){
//TODO
};

/*CFBooleanGetTypeID

Returns the Core Foundation type identifier for the CFBoolean opaque type.

CFTypeID CFBooleanGetTypeID ();
Return Value

The Core Foundation type identifier for CFBoolean opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFBooleanGetTypeID (){
//TODO
};


/*CFURLGetTypeID

Returns the type identifier for the CFURL opaque type.

CFTypeID CFURLGetTypeID ();
Return Value

The type identifier for the CFURL opaque type.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFTypeID CFURLGetTypeID (){
//TODO
};

/*CFURLGetString

Returns the URL as a CFString object.

CFStringRef CFURLGetString (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to convert into a CFString object. 
Return Value

A string representation of anURL. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLGetString (
   CFURLRef anURL){
//TODO
};

/*CFURLCreateWithFileSystemPath

Creates a CFURL object using a local file system path string.

CFURLRef CFURLCreateWithFileSystemPath (
   CFAllocatorRef allocator,
   CFStringRef filePath,
   CFURLPathStyle pathStyle,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
filePath

The path string to convert to a CFURL object. 
pathStyle

The operating system path style used in filePath. See Path Style for a list of possible values. 
isDirectory

A Boolean value that specifies whether filePath is treated as a directory path when resolving against relative path components. Pass true if the pathname indicates a directory, false otherwise.
Return Value

A new CFURL object. Ownership follows the Create Rule.
Discussion

If filePath is not absolute, the resulting URL will be considered relative to the current working directory (evaluated when this function is being invoked). 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateWithFileSystemPath (
   CFAllocatorRef allocator,
   CFStringRef filePath,
   CFURLPathStyle pathStyle,
   Boolean isDirectory){
//TODO
};


/*CFStringCreateWithPascalString

Creates an immutable CFString object from a Pascal string.

CFStringRef CFStringCreateWithPascalString (
   CFAllocatorRef alloc,
   ConstStr255Param pStr,
   CFStringEncoding encoding
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
pStr

The Pascal string to be used to create the string. 
encoding

The encoding of the characters in the Pascal string. 
Return Value

An immutable string containing pStr, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an immutable CFString objects from the character contents of a Pascal string (after stripping off the initial length byte). 
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithPascalString (
   CFAllocatorRef alloc,
   ConstStr255Param pStr,
   CFStringEncoding encoding){
//TODO
};


/*CFNumberGetValue

Obtains the value of a CFNumber object cast to a specified type.

Boolean CFNumberGetValue (
   CFNumberRef number,
   CFNumberType theType,
   void *valuePtr
);
Parameters
number

The CFNumber object to examine. 
theType

A constant that specifies the data type to return. See Number Types for a list of possible values. 
valuePtr

On return, contains the value of number.
Return Value

true if the operation was successful, otherwise false. 
Discussion

If the argument type differs from the return type, and the conversion is lossy or the return value is out of range, then this function passes back an approximate value in valuePtr and returns false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFNumberGetValue (
   CFNumberRef number,
   CFNumberType theType,
   void *valuePtr){
//TODO
};


/*CFCopyLocalizedString

Searches the default strings file Localizable.strings for the string associated with the specified key.

CFStringRef CFCopyLocalizedString (
   CFStringRef key,
   const char *comment
);
Parameters
key

The development language version of the string. This string is used as the search key to locate the localized version of the string. 
comment

A comment to provide the translators with contextual information necessary for proper translation.
Return Value

The localized version of the requested string. Returns key if no value corresponding to key is found. Ownership follows the Create Rule.
Discussion

This is a macro variant of CFBundleCopyLocalizedString for use with the genstrings tool. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFCopyLocalizedString (
   CFStringRef key,
   const char *comment){};


/*CFDictionaryAddValue

Adds a key-value pair to a dictionary if the specified key is not already present.

void CFDictionaryAddValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. If the dictionary is a fixed-capacity dictionary and it is full before this operation, the behavior is undefined. 
key

The key for the value to add to the dictionary—a CFType object or a pointer value. The key is retained by the dictionary using the retain callback provided when the dictionary was created, so must be of the type expected by the callback. If a key which matches key is already present in the dictionary, this function does nothing ("add if absent"). 
value

A CFType object or a pointer value to add to the dictionary. The value is retained by the dictionary using the retain callback provided when the dictionary was created, so must be of the type expected by the callback.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryAddValue (CFMutableDictionaryRef theDict, const void *key,const void *value){
//TODO
};


/*CFDictionaryCreateMutable

Creates a new mutable dictionary.

CFMutableDictionaryRef CFDictionaryCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary and its storage for key-value pairs. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
capacity

The maximum number of key-value pairs that can be contained by the dictionary. The dictionary starts empty and can grow to this number of key-value pairs (and it can have less). Pass 0 to specify no limit. The value must not be negative.
keyCallBacks

A pointer to a CFDictionaryKeyCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare keys in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as a valid structure of version 0 with all fields NULL. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFDictionaryKeyCallBacks structure, the behavior is undefined. If any of the keys put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the dictionary will contain only CFType objects, then pass a pointer to kCFTypeDictionaryKeyCallBacks as this parameter to use the default callback functions. 
valueCallBacks

A pointer to a CFDictionaryValueCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the dictionary. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as a valid structure of version 0 with all fields NULL. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFDictionaryValueCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the dictionary will contain CFType objects only, then pass a pointer to kCFTypeDictionaryValueCallBacks as this parameter to use the default callback functions. 
Return Value

A new dictionary, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableDictionaryRef CFDictionaryCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFDictionaryKeyCallBacks *keyCallBacks,
   const CFDictionaryValueCallBacks *valueCallBacks
){};


/*CFReadStreamUnscheduleFromRunLoop

Removes a read stream from a given run loop.

void CFReadStreamUnscheduleFromRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to unschedule.
runLoop

The run loop from which to remove stream.
runLoopMode

The run loop mode of runLoop from which to remove stream.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
void CFReadStreamUnscheduleFromRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
){};


/*CFReadStreamSetClient

Assigns a client to a stream, which receives callbacks when certain events occur.

Boolean CFReadStreamSetClient (
   CFReadStreamRef stream,
   CFOptionFlags streamEvents,
   CFReadStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
);
Parameters
stream

The stream to modify.
streamEvents

The set of events for which the client should receive callbacks. The events are listed in CFStreamEventType. If you pass kCFStreamEventNone, the current client for stream is removed.
clientCB

The client callback function to be called when one of the events requested in streamEvents occurs. If NULL, the current client for stream is removed.
clientContext

A structure holding contextual information for the stream client. The function copies the information out of the structure, so the memory pointed to by clientContext does not need to persist beyond the function call. If NULL, the current client for stream is removed.
Return Value

TRUE if the stream supports asynchronous notification, otherwise FALSE.
Discussion

To avoid polling and blocking, you can register a client to hear about interesting events that occur on a stream. Only one client per stream is allowed; registering a new client replaces the previous one.

Once you have set a client, you need to schedule the stream in a run loop using CFReadStreamScheduleWithRunLoop so that the client can receive the asynchronous notifications. You can schedule each stream in multiple run loops (for example, if you are using a thread pool). It is the caller's responsibility to ensure that at least one of the scheduled run loops is being run, otherwise the callback cannot be called.

Although all Core Foundation streams currently support asynchronous notification, future stream types may not. If a stream does not support asynchronous notification, this function returns false. Typically, such streams never block for device I/O (for example, a stream reading memory) and don’t benefit from asynchronous notification.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
Boolean CFReadStreamSetClient (
   CFReadStreamRef stream,
   CFOptionFlags streamEvents,
   CFReadStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
){};


/*CFReadStreamClose

Closes a readable stream.

void CFReadStreamClose (
   CFReadStreamRef stream
);
Parameters
stream

The stream to close.
Discussion

This function terminates the flow of bytes and releases any system resources required by the stream. The stream is removed from any run loops in which it was scheduled. Once closed, the stream cannot be reopened.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/

void CFReadStreamClose (
   CFReadStreamRef stream
){};

/*CFWriteStreamUnscheduleFromRunLoop

Removes a stream from a particular run loop.

void CFWriteStreamUnscheduleFromRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to remove.
runLoop

The run loop from which to remove stream.
runLoopMode

The run loop mode of runLoop from which to remove stream.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFWriteStreamUnscheduleFromRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
){};

/*CFWriteStreamSetClient

Assigns a client to a stream, which receives callbacks when certain events occur.

Boolean CFWriteStreamSetClient (
   CFWriteStreamRef stream,
   CFOptionFlags streamEvents,
   CFWriteStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
);
Parameters
stream

The stream to modify.
streamEvents

The set of events for which the client should receive callbacks. The events are listed in CFStreamEventType. If you pass kCFStreamEventNone, the current client for stream is removed.
clientCB

The client callback function to call when one of the events requested in streamEvents occurs. If NULL, the current client for stream is removed.
clientContext

A structure holding contextual information for the stream client. The function copies the information out of the structure, so the memory pointed to by clientContext does not need to persist beyond the function call. If NULL, the current client for stream is removed.
Return Value

true if the stream supports asynchronous notification, false otherwise.
Discussion

To avoid polling and blocking, you can register a client to hear about interesting events that occur on a stream. Only one client per stream is allowed; registering a new client replaces the previous one.

Once you have set a client, you need to schedule the stream in a run loop using CFWriteStreamScheduleWithRunLoop so that the client can receive the asynchronous notifications. You can schedule each stream in multiple run loops (for example, if you are using a thread pool). It is the caller's responsibility to ensure that at least one of the scheduled run loops is being run, otherwise the callback cannot be called.

Although all Core Foundation streams currently support asynchronous notification, future stream types may not. If a stream does not support asynchronous notification, this function returns false. Typically, such streams never block for device I/O (for example, a stream writing to memory) and don’t benefit from asynchronous notification.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
Boolean CFWriteStreamSetClient (
   CFWriteStreamRef stream,
   CFOptionFlags streamEvents,
   CFWriteStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
){};


/*CFWriteStreamClose

Closes a writable stream.

void CFWriteStreamClose (
   CFWriteStreamRef stream
);
Parameters
stream

The stream to close.
Discussion

This function terminates the flow of bytes and releases any system resources required by the stream. The stream is removed from any run loops in which it was scheduled. Once closed, the stream cannot be reopened.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFWriteStreamClose (
   CFWriteStreamRef stream
){};



/*CFReadStreamGetTypeID

Returns the type identifier the CFReadStream opaque type.

CFTypeID CFReadStreamGetTypeID ();
Return Value

The type identifier for the CFReadStream opaque type.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFTypeID CFReadStreamGetTypeID (){};



/*CFWriteStreamGetTypeID

Returns the type identifier of all CFWriteStream objects.

CFTypeID CFWriteStreamGetTypeID ();
Return Value

The type identifier for the CFWriteStream opaque type.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
CFTypeID CFWriteStreamGetTypeID (){};

/*CFWriteStreamSetProperty

Sets the value of a property for a stream.

Boolean CFWriteStreamSetProperty (
   CFWriteStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
);
Parameters
stream

The stream to modify.
propertyName

The name of the property to set. The available properties for standard Core Foundation streams are listed in “Stream Properties.”
propertyValue

The value to which to set the property propertyName for stream. The allowed data type of the value depends on the property being set.
Return Value

true if stream recognizes and accepts the given property-value pair, false otherwise.
Discussion

Each type of stream can define a set of properties that either describe or configure individual streams. A property can be any interesting information about a stream. Examples include the headers from an HTTP transmission, the expected number of bytes, file permission information, and so on. Properties that can be set configure the behavior of the stream and may be modifiable only at particular times, such as before the stream has been opened. (In fact, you should assume that you can set properties only before opening the stream, unless otherwise noted.) To read the value of a property use CFWriteStreamCopyProperty, although some properties are write-only.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
CoreFoundation/CFStream.h*/
Boolean CFWriteStreamSetProperty (
   CFWriteStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
){};


/*CFNumberGetTypeID

Returns the type identifier for the CFNumber opaque type.

CFTypeID CFNumberGetTypeID ();
Return Value

The type identifier for the CFNumber opaque type.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeID CFNumberGetTypeID (){};


/*CFWriteStreamCreateWithFile

Creates a writable stream for a file.

CFWriteStreamRef CFWriteStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
fileURL

The URL of the file to which to write. The URL must use a file scheme.
Return Value

The new write stream, or NULL on failure. Ownership follows the Create Rule.
Discussion

The stream overwrites an existing file unless you set the kCFStreamPropertyAppendToFile to kCFBooleanTrue with CFWriteStreamSetProperty, in which case the stream appends data to the file.

You must open the stream, using CFWriteStreamOpen, before writing to it.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
CFWriteStreamRef CFWriteStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
){};


/*CFURLHasDirectoryPath

Determines if a given URL's path represents a directory.

Boolean CFURLHasDirectoryPath (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

true if anURL represents a directory, false otherwise. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLHasDirectoryPath (
   CFURLRef anURL
){};



/*CFReadStreamCopyProperty

Returns the value of a property for a stream.

CFTypeRef CFReadStreamCopyProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName
);
Parameters
stream

The stream to examine.
propertyName

The name of the stream property to obtain. The available properties for standard Core Foundation streams are listed in CFStream Reference.
Return Value

The value of the property propertyName. Ownership follows the Create Rule.
Discussion

Each type of stream can define a set of properties that either describe or configure individual streams. A property can be any information about a stream, other than the actual data the stream handles. Examples include the headers from an HTTP transmission, the expected number of bytes, file permission information, and so on. Use CFReadStreamSetProperty to modify the value of a property, although some properties are read-only.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFTypeRef CFReadStreamCopyProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName
){};


/*CFReadStreamSetProperty

Sets the value of a property for a stream.

Boolean CFReadStreamSetProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
);
Parameters
stream

The stream to modify.
propertyName

The name of the property to set. The available properties for standard Core Foundation streams are listed in CFStream Reference.
propertyValue

The value to which to set the property propertyName for stream. The allowed data type of the value depends on the property being set.
Return Value

TRUE if stream recognizes and accepts the given property-value pair, otherwiseFALSE.
Discussion

Each type of stream can define a set of properties that either describe or configure individual streams. A property can be any interesting information about a stream. Examples include the headers from an HTTP transmission, the expected number of bytes, file permission information, and so on. Properties that can be set configure the behavior of the stream and may be modifiable only at particular times, such as before the stream has been opened. (In fact, you should assume that you can set properties only before opening the stream, unless otherwise noted.) To read the value of a property use CFReadStreamCopyProperty, although some properties are write-only.
Availability
Available in Mac OS X v10.2 and later.
Declared In
CoreFoundation/CFStream.h*/
Boolean CFReadStreamSetProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
){};


/*CFReadStreamRead

Reads data from a readable stream.

CFIndex CFReadStreamRead (
   CFReadStreamRef stream,
   UInt8 *buffer,
   CFIndex bufferLength
);
Parameters
stream

The stream from which to read.
buffer

The buffer into which to place the data.
bufferLength

The size of buffer and the maximum number of bytes to read.
Return Value

The number of bytes read; 0 if the stream has reached its end; or -1 if either the stream is not open or an error occurs.
Discussion

If stream is in the process of opening, this function waits until it has completed. This function blocks until at least one byte is available; it does not block until buffer is filled. To avoid blocking, call this function only if CFReadStreamHasBytesAvailable returns TRUE or after the stream’s client (set with CFReadStreamSetClient) is notified of a kCFStreamEventHasBytesAvailable event.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFIndex CFReadStreamRead (
   CFReadStreamRef stream,
   UInt8 *buffer,
   CFIndex bufferLength
){};

/*CFWriteStreamWrite

Writes data to a writable stream.

CFIndex CFWriteStreamWrite (
   CFWriteStreamRef stream,
   const UInt8 *buffer,
   CFIndex bufferLength
);
Parameters
stream

The stream to which to write.
buffer

The buffer holding the data to write.
bufferLength

The number of bytes from buffer to write.
Return Value

The number of bytes successfully written, 0 if the stream has been filled to capacity (for fixed-length streams), or -1 if either the stream is not open or an error occurs.
Discussion

If stream is in the process of opening, this function waits until it has completed. If the stream is not full, this call blocks until at least one byte is written; it does not block until all the bytes in buffer is written. To avoid blocking, call this function only if CFWriteStreamCanAcceptBytes returns true or after the stream’s client (set with CFWriteStreamSetClient) is notified of a kCFStreamEventCanAcceptBytes event.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
CFIndex CFWriteStreamWrite (
   CFWriteStreamRef stream,
   const UInt8 *buffer,
   CFIndex bufferLength
){};


/*CFReadStreamGetError

Returns the error status of a stream.

CFStreamError CFReadStreamGetError (
   CFReadStreamRef stream
);
Parameters
stream

The stream to examine.
Return Value

The error status of stream returned in a CFStreamError structure.

The error field is 0 if no error has occurred. If the error field is not 0, the domain field contains a code that identifies the domain in which the value of the error field should be interpreted.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFStreamError CFReadStreamGetError (
   CFReadStreamRef stream
){};

/*CFRunLoopStop

Forces a CFRunLoop object to stop running.

void CFRunLoopStop (
   CFRunLoopRef rl
);
Parameters
rl

The run loop to stop.
Discussion

This function forces rl to stop running and return control to the function that called CFRunLoopRun or CFRunLoopRunInMode for the current run loop activation. If the run loop is nested with a callout from one activation starting another activation running, only the innermost activation is exited.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopStop (
   CFRunLoopRef rl
){};

/*CFURLCopyLastPathComponent

Returns the last path component of a given URL.

CFStringRef CFURLCopyLastPathComponent (
   CFURLRef url
);
Parameters
url

The CFURL object to examine. 
Return Value

The last path component of url. Ownership follows the Create Rule. 
Discussion

Note that if there is no last path component, this function returns an empty string. In the code sample shown in Listing 1, lastPathComponent is an empty string. 

Listing 1  Code sample illustrating CFURLCopyLastPathComponentCFStringRef urlString = CFSTR("http://www.apple.com");
CFURLRef url = CFURLCreateWithString(NULL, urlString, NULL);
CFStringRef lastPathComponent = CFURLCopyLastPathComponent (url);


If urlString were created with CFSTR("http://www.apple.com/"), then lastPathComponent would be a CFString object containing the character “/“.

See also CFURLCopyPathExtension.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyLastPathComponent (
   CFURLRef url
){};




/*CFWriteStreamOpen

Opens a stream for writing.

Boolean CFWriteStreamOpen (
   CFWriteStreamRef stream
);
Parameters
stream

The stream to open.
Return Value

true if stream was successfully opened, false otherwise. If stream is not in the kCFStreamStatusNotOpen state, this function returns false.
Discussion

Opening a stream causes it to reserve all the system resources it requires. If the stream can open in the background without blocking, this function always returns true. To learn when a background open operation completes, you can either schedule the stream into a run loop with CFWriteStreamScheduleWithRunLoop and wait for the stream’s client (set with CFWriteStreamSetClient) to be notified or you can poll the stream using CFWriteStreamGetStatus, waiting for a status of kCFStreamStatusOpen or kCFStreamStatusError. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
Boolean CFWriteStreamOpen (
   CFWriteStreamRef stream
){};

/*CFReadStreamScheduleWithRunLoop

Schedules a stream into a run loop.

void CFReadStreamScheduleWithRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to schedule.
runLoop

The run loop with which to schedule stream.
runLoopMode

The run loop mode of runLoop in which to schedule stream.
Discussion

After scheduling stream with a run loop, its client (set with CFReadStreamSetClient) is notified when various events happen with the stream, such as when it finishes opening, when it has bytes available, and when an error occurs. A stream can be scheduled with multiple run loops and run loop modes. Use CFReadStreamUnscheduleFromRunLoop to later remove stream from the run loop.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
void CFReadStreamScheduleWithRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
){};


/*CFReadStreamOpen

Opens a stream for reading.

Boolean CFReadStreamOpen (
   CFReadStreamRef stream
);
Parameters
stream

The stream to open.
Return Value

TRUE if stream was successfully opened, FALSE otherwise. If stream is not in the kCFStreamStatusNotOpen state, this function returns FALSE.
Discussion

Opening a stream causes it to reserve all the system resources it requires. If the stream can open in the background without blocking, this function always returns true. To learn when a background open operation completes, you can either schedule the stream into a run loop with CFReadStreamScheduleWithRunLoop and wait for the stream’s client (set with CFReadStreamSetClient) to be notified or you can poll the stream using CFReadStreamGetStatus, waiting for a status of kCFStreamStatusOpen or kCFStreamStatusError.

You do not need to wait until a stream has finished opening in the background before calling the CFReadStreamRead function. The read operation will simply block until the open has completed.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
Boolean CFReadStreamOpen (
   CFReadStreamRef stream
){};

/*CFWriteStreamGetError

Returns the error status of a stream.

CFStreamError CFWriteStreamGetError (
   CFWriteStreamRef stream
);
Parameters
stream

The stream to examine.
Return Value

The error status of stream returned in a CFStreamError structure.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/

CFStreamError CFWriteStreamGetError (
   CFWriteStreamRef stream
){};


/*CFReadStreamCreateWithFile

Creates a readable stream for a file.

CFReadStreamRef CFReadStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
fileURL

The URL of the file to read. The URL must use the file scheme.
Return Value

The new readable stream object, or NULL on failure. Ownership follows the Create Rule.
Discussion

You must open the stream, using CFReadStreamOpen, before reading from it.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFReadStreamRef CFReadStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
){};


/*CFWriteStreamScheduleWithRunLoop

Schedules a stream into a run loop.

void CFWriteStreamScheduleWithRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to schedule.
runLoop

The run loop in which to schedule stream.
runLoopMode

The run loop mode of runLoop in which to schedule stream.
Discussion

After scheduling stream into a run loop, its client (set with CFWriteStreamSetClient) is notified when various events happen with the stream, such as when it finishes opening, when it can accept new bytes, and when an error occurs. A stream can be scheduled into multiple run loops and run loop modes. Use CFWriteStreamUnscheduleFromRunLoop to later remove stream from the run loop.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFWriteStreamScheduleWithRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
){};


/*CFDateGetTypeID

Returns the type identifier for the CFDate opaque type.

CFTypeID CFDateGetTypeID ();
Return Value

The type identifier for the CFDate opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDateGetTypeID (){};


/*CFLocaleCopyCurrent

Returns a copy of the logical locale for the current user.

CFLocaleRef CFLocaleCopyCurrent();
Return Value

The logical locale for the current user that is formed from the settings for the current user’s chosen system locale overlaid with any custom settings the user has specified in System Preferences. May return a retained cached object, not a new object. Ownership follows the Create Rule.
Discussion

Settings you get from this locale do not change as a user's preferences are changed so that your operations are consistent. Typically you perform some operations on the returned object and then release it. Since the returned object may be cached, you do not need to hold on to it indefinitely.

Note that locale settings are independent of the user’s language setting. The language of the current locale may not correspond to the language at the first index in the AppleLanguages array from user defaults. For more details, see Locale Concepts in Locales.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CFLocale.h*/
CFLocaleRef CFLocaleCopyCurrent(){};


/*CFDateFormatterCreate

Creates a new CFDateFormatter object, localized to the given locale, which will format dates to the given date and time styles.

CFDateFormatterRef CFDateFormatterCreate(
   CFAllocatorRef alloc,
   CFLocaleRef locale,
   CFDateFormatterStyle dateStyle,
   CFDateFormatterStyle timeStyle
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
locale

The locale to use for localization. If NULL uses the default system local. Use CFLocaleCopyCurrent to specify the locale of the current user.
dateStyle

The date style to use when formatting dates. See Date Formatter Styles for possible values.
timeStyle

The time style to use when formatting times. See Date Formatter Styles for possible values.
Return Value

A new date formatter, localized to the given locale, which will format dates to the given date and time styles. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You can use kCFDateFormatterNoStyle to suppress output for the date or time. The following code fragment illustrates the creation and use of a date formatter that only outputs the date information (memory management is omitted for clarity).CFLocaleRef locale = CFLocaleCreate(kCFAllocatorDefault, CFSTR("en_GB"));
 
CFDateFormatterRef formatter = CFDateFormatterCreate(
        kCFAllocatorDefault, locale, kCFDateFormatterMediumStyle, kCFDateFormatterNoStyle);
 
CFDateRef date = CFDateCreate(kCFAllocatorDefault, 123456);
CFStringRef dateAsString = CFDateFormatterCreateStringWithDate (
        kCFAllocatorDefault, formatter, date);
 
CFShow(dateAsString);
// outputs "2 Jan 2001"

Availability
Available in Mac OS X v10.3 and later.*/
CFDateFormatterRef CFDateFormatterCreate(
   CFAllocatorRef alloc,
   CFLocaleRef locale,
   CFDateFormatterStyle dateStyle,
   CFDateFormatterStyle timeStyle
){};


/*CFDateFormatterCreateStringWithDate

Returns a string representation of the given date using the specified date formatter.

CFStringRef CFDateFormatterCreateStringWithDate(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFDateRef date
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatter

The date formatter object that specifies the format of the returned string. 
date

The date object for which to create a string representation. 
Return Value

A new string that represents date in the specified format. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.3 and later.*/

CFStringRef CFDateFormatterCreateStringWithDate(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFDateRef date
){};


/*CFStringGetTypeID

Returns the type identifier for the CFString opaque type.

CFTypeID CFStringGetTypeID ();
Return Value

The type identifier for the CFString opaque type. 
Discussion

CFMutableString objects have the same type identifier as CFString objects.
Availability
Available in Mac OS X v10.0 and later.*/
CFTypeID CFStringGetTypeID (){};

/*CFSetCreateMutable

Creates an empty CFMutableSet object.

CFMutableSetRef CFSetCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFSetCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new set and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
capacity

The maximum number of values that can be contained by new set. The set starts empty and can grow to this number of values (and it can have less). If this parameter is 0, the set’s maximum capacity is not limited. The value must not be negative.
callBacks

A pointer to a CFSetCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the set. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations. This parameter may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in.

If any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFSetCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the collection contains CFType objects only, then pass kCFTypeSetCallBacks as this parameter to use the default callback functions. 
Return Value

A new mutable set, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableSetRef CFSetCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFSetCallBacks *callBacks
){};

/*CFSetGetCount

Returns the number of values currently in a set.

CFIndex CFSetGetCount (
   CFSetRef theSet
);
Parameters
theSet

The set to examine. 
Return Value

The number of values in theSet. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFSetGetCount (
   CFSetRef theSet
){};

/*CFSetGetValues

Obtains all values in a set.

void CFSetGetValues (
   CFSetRef theSet,
   const void **values
);
Parameters
theSet

The set to examine. 
values

A C array of pointer-sized values to be filled with values from theSet. The value must be a valid C array of the appropriate type and of a size at least equal to the count of theSet). If the values are Core Foundation objects, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetGetValues (
   CFSetRef theSet,
   const void **values
){};



/*CFDataCreateMutable

Creates an empty CFMutableData object.

CFMutableDataRef CFDataCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of bytes that the CFData object can contain. If 0, the object can grow to a size only limited by the constraints of available memory and address space. 
Return Value

A CFMutableData object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an empty (that is, content-less) CFMutableData object. You can add raw data to this object with the CFDataAppendBytes function, and thereafter you can replace and delete characters with the appropriate CFMutableData functions. If the capacity parameter is greater than 0, any attempt to add characters beyond this limit can result in undefined behavior. 
Availability
Available in Mac OS X v10.0 and later.*/
CFMutableDataRef CFDataCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity
){};

/*CFSocketCreateWithNative

Creates a CFSocket object for a pre-existing native socket.

CFSocketRef CFSocketCreateWithNative (
   CFAllocatorRef allocator,
   CFSocketNativeHandle sock,
   CFOptionFlags callBackTypes,
   CFSocketCallBack callout,
   const CFSocketContext *context
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
sock

The native socket for which to create a CFSocket object. 
callBackTypes

A bitwise-OR combination of the types of socket activity that should cause callout to be called. See Callback Types for the possible activity values. 
callout

The function to call when one of the activities indicated by callBackTypes occurs. 
context

A structure holding contextual information for the CFSocket object. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. Can be NULL. 
Return Value

The new CFSocket object, or NULL if an error occurred. If a CFSocket object already exists for sock, the function returns the pre-existing object instead of creating a new object; the context, callout, and callBackTypes parameters are ignored in this case. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFSocketRef CFSocketCreateWithNative (
   CFAllocatorRef allocator,
   CFSocketNativeHandle sock,
   CFOptionFlags callBackTypes,
   CFSocketCallBack callout,
   const CFSocketContext *context
){};


/*CFSocketCreateRunLoopSource

Creates a CFRunLoopSource object for a CFSocket object.

CFRunLoopSourceRef CFSocketCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFSocketRef s,
   CFIndex order
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
s

The CFSocket object for which to create a run loop source. 
order

A priority index indicating the order in which run loop sources are processed. When multiple run loop sources are firing in a single pass through the run loop, the sources are processed in increasing order of this parameter. If the run loop is set to process only one source per loop, only the highest priority source, the one with the lowest order value, is processed.
Return Value

The new CFRunLoopSource object for s. Ownership follows the Create Rule.
Discussion

The run loop source is not automatically added to a run loop. To add the source to a run loop, use CFRunLoopAddSource.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopSourceRef CFSocketCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFSocketRef s,
   CFIndex order
){};

/*CFSetContainsValue

Returns a Boolean that indicates whether a set contains a given value.

Boolean CFSetContainsValue (
   CFSetRef theSet,
   const void *value
);
Parameters
theSet

The set to search. 
value

The value to match in theSet. Comparisons are made using the equal callback provided when theSet was created. If the equal callback was NULL, pointer equality (in C, ==) is used. 
Return Value

true if value is contained in theSet, otherwise false. 
Discussion

This function uses the equal callback. value and all elements in the set must be understood by the equal callback.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFSetContainsValue (
   CFSetRef theSet,
   const void *value
){};


/*CFSetAddValue

Adds a value to a CFMutableSet object.

void CFSetAddValue (
   CFMutableSetRef theSet,
   const void *value
);
Parameters
theSet

The set to modify.
value

A CFType object or a pointer value to add to theSet (or the value itself, if it fits into the size of a pointer). 

value is retained by theSet using the retain callback provided when theSet was created. If value is not of the type expected by the retain callback, the behavior is undefined. If value already exists in the collection, this function returns without doing anything. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetAddValue (
   CFMutableSetRef theSet,
   const void *value
){};

/*CFSetRemoveValue

Removes a value from a CFMutableSet object.

void CFSetRemoveValue (
   CFMutableSetRef theSet,
   const void *value
);
Parameters
theSet

The set to modify.
value

The value to remove from theSet.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetRemoveValue (
   CFMutableSetRef theSet,
   const void *value
){};

/*CFRunLoopSourceInvalidate

Invalidates a CFRunLoopSource object, stopping it from ever firing again.

void CFRunLoopSourceInvalidate (
   CFRunLoopSourceRef source
);
Parameters
source

The run loop source to invalidate.
Discussion

Once invalidated, source will never fire and call its perform callback function again. This function automatically removes source from all the run loop modes in which it was registered. If source is a version 0 source, this function calls its cancel callback function as it is removed from each run loop mode. The memory for source is not deallocated unless the run loop held the only reference to source.
Availability
Available in Mac OS X v10.0 and later.*/

void CFRunLoopSourceInvalidate (
   CFRunLoopSourceRef source
){};


/*CFSocketInvalidate

Invalidates a CFSocket object, stopping it from sending or receiving any more messages.

void CFSocketInvalidate (
   CFSocketRef s
);
Parameters
s

The CFSocket object to invalidate. 
Discussion

Invalidating a CFSocket object prevents the port from ever sending or receiving any more messages. The CFSocket object is not deallocated, though. The CFSocketContext info information, which was provided when s was created, is released, if a release callback was specified in its context structure. Also, if a run loop source was created for s, the run loop source is invalidated, as well.

You should always invalidate a socket when you are done using it. If you have requested, using CFSocketSetSocketFlags, that the underlying socket not automatically close when invalidating the wrapping CFSocket object, you must invalidate the CFSocket object before closing the socket yourself.
Availability
Available in Mac OS X v10.0 and later*/

void CFSocketInvalidate (
   CFSocketRef s
){};


/*CFArrayRemoveValueAtIndex

Removes the value at a given index from an array.

void CFArrayRemoveValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx
);
Parameters
theArray

The array from which the value is to be removed. 
idx

The index of the value to remove. The value not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of theArray before the operation).
Discussion

All values in theArray with indices larger than idx have their indices decreased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayRemoveValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx
){};


/*CFSocketEnableCallBacks

Enables the callback function of a CFSocket object for certain types of socket activity.

void CFSocket (
   CFSocketRef s,
   CFOptionFlags callBackTypes
);
Parameters
s

The CFSocket object to modify. 
callBackTypes

A bitwise-OR combination of CFSocket activity types that should cause the callback function of s to be called. See Callback Types for a list of callback types.
Discussion

If a callback type is not automatically reenabled, you can use this function to enable the callback. A callback type that is not automatically reenabled still does not get reenabled after enabling it with this function; use CFSocketSetSocketFlags to have the callback type reenabled automatically.

Be sure to enable only callback types that your CFSocket object actually possess and requested when creating the CFSocket object; the result of enabling other callback types is undefined.
Availability
Available in Mac OS X v10.2 and later.*/

void CFSocket (
   CFSocketRef s,
   CFOptionFlags callBackTypes
){};

/*CFDataGetTypeID

Returns the type identifier for the CFData opaque type.

CFTypeID CFDataGetTypeID ();
Return Value

The type identifier for the CFData opaque type. 
Discussion

CFMutableData objects have the same type identifier as CFData objects.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDataGetTypeID (){};



/*CFDataAppendBytes

Appends the bytes from a byte buffer to the contents of a CFData object.

void CFDataAppendBytes (
   CFMutableDataRef theData,
   const UInt8 *bytes,
   CFIndex length
);
Parameters
theData

A CFMutableData object. If you pass an immutable CFData object, the behavior is not defined. 
bytes

A pointer to the buffer of bytes to be added to theData. 
length

The number of bytes in the byte buffer bytes. 
Availability
Available in Mac OS X v10.0 and later.*/
void CFDataAppendBytes (
   CFMutableDataRef theData,
   const UInt8 *bytes,
   CFIndex length
){};


/*CFDataGetBytePtr

Returns a read-only pointer to the bytes of a CFData object.

const UInt8 *CFDataGetBytePtr (
   CFDataRef theData
);
Parameters
theData

The CFData object to examine. 
Return Value

A read-only pointer to the bytes associated with theData.
Discussion

This function is guaranteed to return a pointer to a CFData object's internal bytes. CFData, unlike CFString, does not hide its internal storage.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
const UInt8 *CFDataGetBytePtr (
   CFDataRef theData
){};


/*CFDataDeleteBytes

Deletes the bytes in a CFMutableData object within a specified range.

void CFDataDeleteBytes (
   CFMutableDataRef theData,
   CFRange range
);
Parameters
theData

A CFMutableData object. If you pass an immutable CFData object, the behavior is not defined. 
range

The range of bytes (that is, the starting byte and the number of bytes from that point) to delete from theData's byte buffer. 
Availability
Available in Mac OS X v10.0 and later.*/
void CFDataDeleteBytes (
   CFMutableDataRef theData,
   CFRange range
){};


/*CFSetApplyFunction

Calls a function once for each value in a set.

void CFSetApplyFunction (
   CFSetRef theSet,
   CFSetApplierFunction applier,
   void *context
);
Parameters
theSet

The set to operate upon. 
applier

The callback function to call once for each value in the theSet. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. The applier function must be able to work with all values in theSet.
context

A pointer-sized program-defined value, which is passed as the second parameter to the applier function, but is otherwise unused by this function.
Discussion

If theSet is mutable, it is unsafe for the applier function to change the contents of the collection.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetApplyFunction (
   CFSetRef theSet,
   CFSetApplierFunction applier,
   void *context
){};

/*CFSocketEnableCallBacks

Enables the callback function of a CFSocket object for certain types of socket activity.

void CFSocket (
   CFSocketRef s,
   CFOptionFlags callBackTypes
);
Parameters
s

The CFSocket object to modify. 
callBackTypes

A bitwise-OR combination of CFSocket activity types that should cause the callback function of s to be called. See Callback Types for a list of callback types.
Discussion

If a callback type is not automatically reenabled, you can use this function to enable the callback. A callback type that is not automatically reenabled still does not get reenabled after enabling it with this function; use CFSocketSetSocketFlags to have the callback type reenabled automatically.

Be sure to enable only callback types that your CFSocket object actually possess and requested when creating the CFSocket object; the result of enabling other callback types is undefined.
Availability
Available in Mac OS X v10.2 and later.*/
void CFSocketEnableCallBacks (
   CFSocketRef s,
   CFOptionFlags callBackTypes
){};



/*CFSocketGetNative

Returns the native socket associated with a CFSocket object.

CFSocketNativeHandle CFSocketGetNative (
   CFSocketRef s
);
Parameters
s

The CFSocket object to examine. 
Return Value

The native socket associated with s. If s has been invalidated, returns -1, INVALID_SOCKET.
Availability
Available in Mac OS X v10.0 and later.*/
CFSocketNativeHandle CFSocketGetNative (
   CFSocketRef s
){};



/*CFRunLoopGetTypeID

Returns the type identifier for the CFRunLoop opaque type.

CFTypeID CFRunLoopGetTypeID ();
Return Value

The type identifier for the CFRunLoop opaque type.
Availability
Available in Mac OS X v10.0 and later.*/

CFTypeID CFRunLoopGetTypeID (){};


/*CFURLCreateStringByReplacingPercentEscapes

Creates a new string by replacing any percent escape sequences with their character equivalent.

CFStringRef CFURLCreateStringByReplacingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveEscaped
);
Parameters
allocator

The allocator to use to allocate memory for the new CFString object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
originalString

The CFString object to be copied and modified.
charactersToLeaveEscaped

Characters whose percent escape sequences, such as %20 for a space character, you want to leave intact. Pass NULL to specify that no percent escapes be replaced, or the empty string (CFSTR("")) to specify that all be replaced.
Return Value

A new CFString object, or NULL if the percent escapes cannot be converted to characters, assuming UTF-8 encoding. If no characters need to be replaced, this function returns the original string with its reference count incremented. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCreateStringByReplacingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveEscaped
){};

/*CFURLCreateStringByAddingPercentEscapes

Creates a copy of a string, replacing certain characters with the equivalent percent escape sequence based on the specified encoding.

CFStringRef CFURLCreateStringByAddingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveUnescaped,
   CFStringRef legalURLCharactersToBeEscaped,
   CFStringEncoding encoding
);
Parameters
allocator

The allocator to use to allocate memory for the new CFString object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
originalString

The CFString object to copy. 
charactersToLeaveUnescaped

Characters whose percent escape sequencesyou want to leave intact. Pass NULL to specify that all escape sequences be replaced.
legalURLCharactersToBeEscaped

Legal characters to be escaped. Pass NULL to specify that all legal characters be replaced.
encoding

The encoding to use for the translation. If you are uncertain of the correct encoding, you should use UTF-8, which is the encoding designated by RFC 2396 as the correct encoding for use in URLs. 
Return Value

A copy of originalString replacing certain characters. If it does not need to be modified (no percent escape sequences are missing), this function may merely return originalString with its reference count incremented. Ownership follows the Create Rule.
Discussion

The characters escaped are all characters that are not legal URL characters (based on RFC 2396), plus any characters in legalURLCharactersToBeEscaped, less any characters in charactersToLeaveUnescaped. To simply correct any non-URL characters in an otherwise correct URL string, pass NULL for the allocator, charactersToLeaveEscaped, and legalURLCharactersToBeEscaped parameters, and kCFStringEncodingUTF8 as the encoding parameter.

It may be difficult to use this function to "clean up" unescaped or partially escaped URL strings where sequences are unpredictable and you cannot specify charactersToLeaveUnescaped. Instead, you can "pre-process" an URL string using CFURLCreateStringByReplacingPercentEscapesUsingEncoding then add the escape characters using CFURLCreateStringByAddingPercentEscapes, as shown in the following code fragment. CFStringRef originalURLString = CFSTR("http://online.store.com/storefront/?request=get-document&doi=10.1175%2F1520-0426(2005)014%3C1157:DODADSS%3E2.0.CO%3B2");
CFStringRef preprocessedString =
    CFURLCreateStringByReplacingPercentEscapesUsingEncoding(kCFAllocatorDefault, originalURLString, CFSTR(""), kCFStringEncodingUTF8);
CFStringRef urlString =
    CFURLCreateStringByAddingPercentEscapes(kCFAllocatorDefault, preprocessedString, NULL, NULL, kCFStringEncodingUTF8);
url = CFURLCreateWithString(kCFAllocatorDefault, urlString, NULL);

Availability
Available in CarbonLib v1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCreateStringByAddingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveUnescaped,
   CFStringRef legalURLCharactersToBeEscaped,
   CFStringEncoding encoding
){};


/*CFAbsoluteTimeGetCurrent

Returns the current system absolute time.

CFAbsoluteTime CFAbsoluteTimeGetCurrent ();
Return Value

The current absolute time. 
Discussion

Absolute time is measured in seconds relative to the absolute reference date of Jan 1 2001 00:00:00 GMT. A positive value represents a date after the reference date, a negative value represents a date before it. For example, the absolute time -32940326 is equivalent to December 16th, 1999 at 17:54:34. Repeated calls to this function do not guarantee monotonically increasing results. The system time may decrease due to synchronization with external time references or due to an explicit user change of the clock.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFAbsoluteTime CFAbsoluteTimeGetCurrent (){};



/*CFArrayCreate

Creates a new immutable array with the given values.

CFArrayRef CFArrayCreate (
   CFAllocatorRef allocator,
   const void **values,
   CFIndex numValues,
   const CFArrayCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
values

A C array of the pointer-sized values to be in the new array. The values in the new array are ordered in the same order in which they appear in this C array. This value may be NULL if numValues is 0. This C array is not changed or freed by this function. If values is not a valid pointer to a C array of at least numValues elements, the behavior is undefined. 
numValues

The number of values to copy from the values C array into the new array. This number will be the count of the new array—it must not be negative or greater than the number of elements in values. 
callBacks

A pointer to a CFArrayCallBacks structure initialized with the callbacks for the array to use on each value in the collection. The retain callback is used within this function, for example, to retain all of the new values from the values C array. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations.

This value may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in. Otherwise, if any of the fields are not valid pointers to functions of the correct type, or this value is not a valid pointer to a CFArrayCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the collection contains only CFType objects, then pass kCFTypeArrayCallBacks to use the default callback functions.
Return Value

A new immutable array containing numValues from values, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFArrayRef CFArrayCreate (
   CFAllocatorRef allocator,
   const void **values,
   CFIndex numValues,
   const CFArrayCallBacks *callBacks
){};


/*CFDateCreate

Creates a CFDate object given an absolute time.

CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
at

The absolute time to converted to a CFDate object. 
Return Value

A date object that represents the absolute time at. Ownership follows the Create Rule.
Discussion

CFDate objects must always be created using absolute time. Time intervals are not supported. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
){};
/*CFArrayInsertValueAtIndex

Inserts a value into an array at a given index.

void CFArrayInsertValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
);
Parameters
theArray

The array into which value is inserted. If theArray is a fixed-capacity array and it is full before this operation, the behavior is undefined. 
idx

The index at which to insert value. The index must not exceed the index space of theArray (0 to N-1 inclusive, where N is the count of theArray before the operation. If the index is the same as the count of theArray, this function has the same effect as CFArrayAppendValue. 
value

The value to insert into theArray. The value is retained by theArray using the retain callback provided when theArray was created. If value is not of the type expected by the retain callback, the behavior is undefined. 
Discussion

The value parameter is assigned to the index idx, and all values in theArray with equal and larger indices have their indices increased by one.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayInsertValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
){};



/*CFArrayCreateMutableCopy

Creates a new mutable array with the values from another array.

CFMutableArrayRef CFArrayCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFArrayRef theArray
);
Parameters
allocator

The allocator to use to allocate memory for the new array and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of values that can be contained by the new array. The array starts with the same count as theArray and can grow to this number of values (and it can have less). If this parameter is 0, the array’s maximum capacity is not limited. The capacity must not be negative, and must be greater than or equal to the count of theArray.
theArray

The array to copy. The pointer values from the array are copied into the new array. However, the values are also retained by the new array.
Return Value

A new mutable array that contains the same values as theArray. The new array has the same count as the theArray and uses the same callbacks. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableArrayRef CFArrayCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFArrayRef theArray
){};


/*CFDictionaryGetValueIfPresent

Reports whether or not a value for a key is in a dictionary, and returns that value indirectly if it exists.

Boolean CFDictionaryGetValueIfPresent (
   CFDictionaryRef theDict,
   const void *key,
   const void **value
);
Parameters
theDict

The dictionary to examine. 
key

The key for which to find a match in the dictionary. The key hash and equal callbacks provided when the dictionary was created are used to compare. If the hash callback was NULL, key is treated as a pointer and converted to an integer. If the equal callback was NULL, pointer equality (in C, ==) is used. If key, or any of the keys in theDict, is not understood by the equal callback, the behavior is undefined. 
value

A pointer to memory which, on return, is filled with the pointer-sized value if a matching key is found. If no key match is found, the contents of the storage pointed to by this parameter are undefined. This value may be NULL, in which case the value from the dictionary is not returned (but the return value of this function still indicates whether or not the key-value pair was present). If the value is a Core Foundation object, ownership follows the Get Rule.
Return Value

true, if a matching key was found, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

Boolean CFDictionaryGetValueIfPresent (
   CFDictionaryRef theDict,
   const void *key,
   const void **value
){};



/*CFDictionaryRemoveValue

Removes a key-value pair.

void CFDictionaryRemoveValue (
   CFMutableDictionaryRef theDict,
   const void *key
);
Parameters
theDict

The dictionary to modify. 
key

The key of the value to remove from theDict. If a key which matches key is present in theDict, the key-value pair is removed from the dictionary, otherwise this function does nothing ("remove if present"). 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryRemoveValue (
   CFMutableDictionaryRef theDict,
   const void *key
){};


/*CFBundleGetIdentifier

Returns the bundle identifier from a bundle’s information property list.

CFStringRef CFBundleGetIdentifier (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFString object containing the bundle’s identifier, or NULL if none was specified in the information property list. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFStringRef CFBundleGetIdentifier (
   CFBundleRef bundle
){};


/*CFPropertyListCreateXMLData

Creates an XML representation of the specified property list.

CFDataRef CFPropertyListCreateXMLData (
   CFAllocatorRef allocator,
   CFPropertyListRef propertyList
);
Parameters
allocator

The allocator to use to allocate memory for the new data object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
propertyList

The property list to convert. This may be any of the standard property list objects, for example a CFArray or a CFDictionary object. 
Return Value

A CFData object containing the XML data. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFPropertyListCreateXMLData (
   CFAllocatorRef allocator,
   CFPropertyListRef propertyList
){};

/*CFURLWriteDataAndPropertiesToResource

Writes the given data and properties to a given URL.

Boolean CFURLWriteDataAndPropertiesToResource (
   CFURLRef url,
   CFDataRef dataToWrite,
   CFDictionaryRef propertiesToWrite,
   SInt32 *errorCode
);
Parameters
url

The resource to write. 
dataToWrite

The data to write. Pass NULL to write only properties. 
propertiesToWrite

The properties to write. Pass NULL to write only data. See “File URL Properties” and “HTTP URL Properties” for the list of available properties.
errorCode

Upon return, 0 if successful, otherwise contains an error code indicating the nature of the problem. See “Error Codes” for a list of possible error codes.
Return Value

true if successful, false otherwise. 
Discussion

Properties not present in propertiesToWrite are left unchanged, hence if propertiesToWrite is NULL or empty, the URL's properties are not changed at all. 

If url uses a file scheme and it references a file, the contents of dataToWrite are written to the referenced file, overwriting any preexisting data, and the file’s properties are modified according to propertiesToWrite. If the file does not exist, but all intermediate directories along the path do already exist, the file is created (otherwise it is not).

If url uses a file scheme and it references a directory (the last path character is "/"), the contents of dataToWrite are ignored, but if the parameter value is not NULL—and all intermediate directories along the path do already exist—a new directory is created (otherwise it is not).

If url uses an http scheme, an http PUT request is sent to the resource with propertiesToWrite as the header fields and dataToWrite as the data.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFURLAccess.h*/
Boolean CFURLWriteDataAndPropertiesToResource (
   CFURLRef url,
   CFDataRef dataToWrite,
   CFDictionaryRef propertiesToWrite,
   SInt32 *errorCode
){};




/*CFDictionaryCreateMutableCopy

Creates a new mutable dictionary with the key-value pairs from another dictionary.

CFMutableDictionaryRef CFDictionaryCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFDictionaryRef theDict
);
Parameters
allocator

The allocator to use to allocate memory for the new dictionary and its storage for key-value pairs. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of key-value pairs that can be contained by the returned dictionary. The dictionary starts empty, and can grow to this number of key-value pairs (and it can have less). The value must be greater than or equal to the count of theDict, or 0 to specify no limit
theDict

The dictionary to copy. The keys and values from the dictionary are copied as pointers into the new dictionary, not that which the values point to (if anything). The keys and values are also retained by the new dictionary. The count of the new dictionary is the same as the count of theDict. The new dictionary uses the same callbacks as theDict. 
Return Value

A new dictionary that contains the same values as theDict. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableDictionaryRef CFDictionaryCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFDictionaryRef theDict
){};



/*CFArrayGetFirstIndexOfValue

Searches an array forward for a value.

CFIndex CFArrayGetFirstIndexOfValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
);
Parameters
theArray

The array to examine. 
range

The range within theArray to search. The range must lie within the bounds of theArray. The range may be empty (length 0). The search progresses from the lowest index defined by the range to the highest. 
value

The value for which to find a match in theArray. The equal callback provided when theArray was created is used to compare. If the equal callback was NULL, pointer equality (in C, ==) is used. If value, or any other value in theArray, is not understood by the equal callback, the behavior is undefined. 
Return Value

The lowest index of the matching values in the range, or -1 if no value in the range matched.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFArrayGetFirstIndexOfValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
){};


/*CFURLCreateWithBytes

Creates a CFURL object using a given character bytes.

CFURLRef CFURLCreateWithBytes (
   CFAllocatorRef allocator,
   const UInt8 *URLBytes,
   CFIndex length,
   CFStringEncoding encoding,
   CFURLRef baseURL
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
URLBytes

The character bytes to convert into a CFURL object. 
length

The number of bytes in URLBytes. 
encoding

The string encoding of the URLBytes string. This encoding is also used to interpret percent escape sequences. 
baseURL

The URL to which URLBytes is relative. Pass NULL if URLBytes contains an absolute URL or if you want to create a relative URL. If URLBytes contains an absolute URL, this parameter is ignored.
Return Value

A new CFURL object. Ownership follows the Create Rule.
Discussion

The specified string encoding will be used both to interpret URLBytes, and to interpret any percent-escapes within the string. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

CFURLRef CFURLCreateWithBytes (
   CFAllocatorRef allocator,
   const UInt8 *URLBytes,
   CFIndex length,
   CFStringEncoding encoding,
   CFURLRef baseURL
){};




/*CFStringGetCharacters

Copies a range of the Unicode characters from a string to a user-provided buffer.

void CFStringGetCharacters (
   CFStringRef theString,
   CFRange range,
   UniChar *buffer
);
Parameters
theString

The string from which the characters are to be obtained. 
range

The range of characters to copy. The specified range must not exceed the length of the string.
buffer

The UniChar buffer of length range.length that you have allocated on the stack or heap. On return, the buffer contains the requested Unicode characters. 
Discussion

Use this function to obtain some or all of the Unicode characters represented by a CFString object. If this operation involves a large number of characters, the function call can be expensive in terms of memory. Instead you might want to consider using the in-line buffer functions CFStringInitInlineBuffer and CFStringGetCharacterFromInlineBuffer to extract the characters incrementally. 
Availability
Available in Mac OS X v10.0 and later.*/
void CFStringGetCharacters (
   CFStringRef theString,
   CFRange range,
   UniChar *buffer
){};

/*CFStringReplace

Replaces part of the character contents of a CFMutableString object with another string.

void CFStringReplace (
   CFMutableStringRef theString,
   CFRange range,
   CFStringRef replacement
);
Parameters
theString

The string to modify. The characters are adjusted left or right (depending on the length of the substituted string) and the character buffer of the object is resized accordingly. If this value is not a CFMutableString object, an assertion is raised. 
range

The range of characters in theString to replace. 
replacement

The replacement string to put into theString. 
Discussion

Although you can use this function to replace all characters in a CFMutableString object (by specifying a range of (0, CFStringGetLength(theString)) ), it is more convenient to use the CFStringReplaceAll function for that purpose. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringReplace (
   CFMutableStringRef theString,
   CFRange range,
   CFStringRef replacement
){};

/*CFPreferencesGetAppBooleanValue

Convenience function that directly obtains a boolean preference value for the specified key.

Boolean CFPreferencesGetAppBooleanValue (
   CFStringRef key,
   CFStringRef applicationID,
   Boolean *keyExistsAndHasValidFormat
);
Parameters
key

The preference key whose value to obtain. The key must specify a preference whose value is of type Boolean. 
applicationID

The identifier of the application whose preferences are searched, typically kCFPreferencesCurrentApplication. Do not pass NULL or kCFPreferencesAnyApplication. Takes the form of a Java package name, such as com.foosoft.
keyExistsAndHasValidFormat

On return, true if the preference value for the specified key was located and found to be of type Boolean, otherwise false. 
Return Value

The preference data for the specified key and application, or if no value was located, false. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFPreferencesGetAppBooleanValue (
   CFStringRef key,
   CFStringRef applicationID,
   Boolean *keyExistsAndHasValidFormat
){};



/*CFURLGetByteRangeForComponent

Returns the range of the specified component in the bytes of a URL.

CFRange CFURLGetByteRangeForComponent (
   CFURLRef anURL
   CFURLComponentType component,
   CFRange *rangeIncludingSeparators
);
Parameters
anURL

The URL containing component.
component

The type of component in anURL whose range you want to obtain. See Component Type for possible values.
rangeIncludingSeparators

Specifies the range of component including the sequences that separate component from the previous and next components. If there is no previous or next components, this function will match the range of the component itself. If anURL does not contain component, rangeIncludingSeparators is set to the location where the component would be inserted.
Return Value

The range of bytes for component in the buffer returned by the CFURLGetBytes function. If anURL does not contain component, the first part of the returned range is set to kCFNotFound.
Discussion

This function is intended to be used in conjunction with the CFURLGetBytes function, since the range returned is only applicable to the bytes returned by CFURLGetBytes.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
CFURL.h*/
CFRange CFURLGetByteRangeForComponent (
   CFURLRef anURL,
   CFURLComponentType component,
   CFRange *rangeIncludingSeparators
){};




/*CFURLGetBytes

Returns by reference the byte representation of a URL object.

CFIndex CFURLGetBytes (
   CFURLRef anURL
   const UInt8 *buffer,
   CFIndex bufferLength,
);
Parameters
anURL

The URL object to convert to a byte representation.
buffer

The buffer where you want the bytes to be placed. If NULL the needed length is computed and returned. The returned bytes are the original bytes from which the URL was created. If the URL was created from a string, the bytes will be the bytes of the string encoded via UTF-8.
bufferLength

The number of bytes in buffer.
Return Value

Returns the number of bytes in buffer that were filled.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
CFURL.h*/
CFIndex CFURLGetBytes (
   CFURLRef anURL,
   const UInt8 *buffer,
   CFIndex bufferLength
){};



/*CFStringDelete

Deletes a range of characters in a string.

void CFStringDelete (
   CFMutableStringRef theString,
   CFRange range
);
Parameters
theString

A string from which characters are to be deleted.
range

The range of characters in theString to delete. 
Discussion

The characters after the deleted range are adjusted to “fill in” the gap. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringDelete (
   CFMutableStringRef theString,
   CFRange range
){};

/*CFDictionaryGetCount

Returns the number of key-value pairs in a dictionary.

CFIndex CFDictionaryGetCount (
   CFDictionaryRef theDict
);
Parameters
dict

The dictionary to examine. 
Return Value

The number of number of key-value pairs in dict. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFDictionaryGetCount (
   CFDictionaryRef theDict
){};


/*CFDictionaryRemoveAllValues

Removes all the key-value pairs from a dictionary, making it empty.

void CFDictionaryRemoveAllValues (
   CFMutableDictionaryRef theDict
);
Parameters
theDict

The dictionary to modify. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryRemoveAllValues (
   CFMutableDictionaryRef theDict
){};

/*CFStringCreateCopy

Creates an immutable copy of a string.

CFStringRef CFStringCreateCopy (
   CFAllocatorRef alloc,
   CFStringRef theString
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
theString

The string to copy. 
Return Value

An immutable string whose contents are identical to theString. Returns NULL if there was a problem copying the object. Ownership follows the Create Rule.
Discussion

The resulting object has the same Unicode contents as the original object, but it is always immutable. It might also have different storage characteristics, and hence might reply differently to functions such as CFStringGetCStringPtr. Also, if the specified allocator and the allocator of the original object are the same, and the string is already immutable, this function may simply increment the retention count without making a true copy. However, the resulting object is a true immutable copy, except the operation was a lot more efficient.

You should use this function in situations where a string is or could be mutable, and you need to take a snapshot of its current value. For example, you might decide to pass a copy of a string to a function that stores its current value in a list for later use.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateCopy (
   CFAllocatorRef alloc,
   CFStringRef theString
){};
/*CFDictionaryGetKeysAndValues

Fills two buffers with the keys and values from a dictionary.

void CFDictionaryGetKeysAndValues (
   CFDictionaryRef theDict,
   const void **keys,
   const void **values
);
Parameters
theDict

The dictionary to examine. 
keys

A C array of pointer-sized values that, on return, is filled with keys from the theDict. The keys and values C arrays are parallel to each other (that is, the items at the same indices form a key-value pair from the dictionary). This value must be a valid pointer to a C array of the appropriate type and size (that is, a size equal to the count of theDict), or NULL if the keys are not required. If the keys are Core Foundation objects, ownership follows the Get Rule.
values

A C array of pointer-sized values that, on return, is filled with values from the theDict. The keys and values C arrays are parallel to each other (that is, the items at the same indices form a key-value pair from the dictionary). This value must be a valid pointer to a C array of the appropriate type and size (that is, a size equal to the count of theDict), or NULL if the values are not required. If the values are Core Foundation objects, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFDictionaryGetKeysAndValues (
   CFDictionaryRef theDict,
   const void **keys,
   const void **values
){};


/*CFArrayReplaceValues

Replaces a range of values in an array.

void CFArrayReplaceValues (
   CFMutableArrayRef theArray,
   CFRange range,
   void **newValues,
   CFIndex newCount
);
Parameters
theArray

The array in which some values are to be replaced. If this parameter is not a valid CFMutableArray object, the behavior is undefined. 
range

The range of values within theArray to replace. The range location or end point (defined by the location plus length minus 1) must not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of theArray). The range length must not be negative. The range may be empty (length 0), in which case the new values are merely inserted at the range location. 
newValues

A C array of the pointer-sized values to be placed into theArray. The new values in theArray are ordered in the same order in which they appear in this C array. This parameter may be NULL if the newCount parameter is 0. This C array is not changed or freed by this function. If this parameter is not a valid pointer to a C array of at least newCount pointers, the behavior is undefined.
newCount

The number of values to copy from the newValues C array into theArray. If this parameter is different from the range length, the excess newCount values are inserted after the range or the excess range values are deleted. This parameter may be 0, in which case no new values are replaced into theArray and the values in the range are simply removed. If this parameter is negative or greater than the number of values actually in the newValues C array, the behavior is undefined. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayReplaceValues (
   CFMutableArrayRef theArray,
   CFRange range,
   void **newValues,
   CFIndex newCount
){};





/*CFArraySortValues

Sorts the values in an array using a given comparison function.

void CFArraySortValues (
   CFMutableArrayRef theArray,
   CFRange range,
   CFComparatorFunction comparator,
   void *context
);
Parameters
theArray

The array whose values are sorted. 
range

The range of values within theArray to sort. The range location or end point (defined by the location plus length minus 1) must not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of theArray). The range length must not be negative. The range may be empty (length 0). 
comparator

The function with the comparator function type signature that is used in the sort operation to compare the values in theArray. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. If there are values in theArray that the comparator function does not expect or cannot properly compare, the behavior is undefined. The values in the range are sorted from least to greatest according to this function. 
context

A pointer-sized program-defined value, which is passed as the third parameter to the comparator function, but is otherwise unused by this function. If the context is not what is expected by the comparator function, the behavior is undefined. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArraySortValues (
   CFMutableArrayRef theArray,
   CFRange range,
   CFComparatorFunction comparator,
   void *context
){};


/*CFStringFindWithOptions

Searches for a substring within a range of the characters represented by a string and, if the substring is found, returns its range within the object's characters.

Boolean CFStringFindWithOptions (
   CFStringRef theString,
   CFStringRef stringToFind,
   CFRange rangeToSearch,
   CFOptionFlags searchOptions,
   CFRange *result
);
Parameters
theString

The string in which to to search for stringToFind. 
stringToFind

The substring to search for in theString.
rangeToSearch

A range of the characters to search in theString. The specified range must not exceed the length of the string.
searchOptions

The option flags to control the search behavior. The supported options are kCFCompareBackwards, kCFCompareAnchored, kCFCompareCaseInsensitive, and kCFCompareNonliteral (available in Mac OS X v10.0 and later). If other option flags are specified, the behavior is undefined. 
result

On return, if the function result is true, contains the starting location and length of the found substring. You may pass NULL if you only want to know if the substring exists in the larger string.
Return Value

true if the substring was found, false otherwise. 
Discussion

This function allows you to search only part of the characters of a string for a substring. It returns the found range indirectly, in the final result parameter. If you want to know if the entire range of characters represented by a string contains a particular substring, you can use the convenience function CFStringFind. Both of these functions return upon finding the first occurrence of the substring, so if you want to find out about multiple occurrences, call the CFStringCreateArrayWithFindResults function.

Depending on the comparison-option flags specified, the length of the resulting range might be different than the length of the search string. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringFindWithOptions (
   CFStringRef theString,
   CFStringRef stringToFind,
   CFRange rangeToSearch,
   CFOptionFlags searchOptions,
   CFRange *result
){};


/*CFURLCopyFileSystemPath

Returns the path portion of a given URL.

CFStringRef CFURLCopyFileSystemPath (
   CFURLRef anURL,
   CFURLPathStyle pathStyle
);
Parameters
anURL

The CFURL object whose path you want to obtain. 
pathStyle

The operating system path style to be used to create the path. See Path Style for a list of possible values. 
Return Value

The URL's path in the format specified by pathStyle. Ownership follows the Create Rule.
Discussion

This function returns the URL's path as a file system path for a given path style. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

CFStringRef CFURLCopyFileSystemPath (
   CFURLRef anURL,
   CFURLPathStyle pathStyle
){};


/*CFRelease

Releases a Core Foundation object.

void CFRelease (
   CFTypeRef cf
);
Parameters
cf

A CFType object to release. This value must not be NULL. 
Discussion

If the retain count of cf becomes zero the memory allocated to the object is deallocated and the object is destroyed. If you create, copy, or explicitly retain (see the CFRetain function) a Core Foundation object, you are responsible for releasing it when you no longer need it (see Memory Management Programming Guide for Core Foundation).
Special Considerations

If cf is NULL, this will cause a runtime error and your application will crash. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFRelease (
   CFTypeRef cf
){};


/*CFDictionaryReplaceValue

Replaces a value corresponding to a given key.

void CFDictionaryReplaceValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
);
Parameters
theDict

The dictionary to modify. 
key

The key of the value to replace in theDict. If a key which matches key is present in the dictionary, the value is changed to the value, otherwise this function does nothing ("replace if present"). 
value

The new value for key. The value object is retained by theDict using the retain callback provided when theDict was created, and the old value is released. value must be of the type expected by the retain and release callbacks.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFDictionaryReplaceValue (
   CFMutableDictionaryRef theDict,
   const void *key,
   const void *value
){};


/*CFRangeMake

Declares and initializes a CFRange structure.

CFRange CFRangeMake (
   CFIndex loc,
   CFIndex len
);
Parameters
loc

The starting location of the range. 
len

The length of the range.
Return Value

An initialized structure of type CFRange. 
Discussion

This is an in-line convenience function for creating initialized CFRange structures. 
Availability
Available in Mac OS X v10.0 and later.*/

CFRange CFRangeMake (
   CFIndex loc,
   CFIndex len
){};

/*CFArrayContainsValue

Reports whether or not a value is in an array.

Boolean CFArrayContainsValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
);
Parameters
theArray

The array to search. 
range

The range within theArray to search. The range must not exceed the bounds of theArray). The range may be empty (length 0). 
value

The value to match in theArray. The equal callback provided when theArray was created is used to compare. If the equal callback was NULL, pointer equality (in C, ==) is used. If value, or any other value in theArray, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if value is in the specified range of theArray, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFArrayContainsValue (
   CFArrayRef theArray,
   CFRange range,
   const void *value
){};



/*CFArraySetValueAtIndex

Changes the value at a given index in an array.

void CFArraySetValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
);
Parameters
theArray

The array in which the value is to be changed. 
idx

The index at which to set the new value. The value must not lie outside the index space of theArray (0 to N-1 inclusive, where N is the count of the array before the operation). 
value

The value to set in theArray. The value is retained by theArray using the retain callback provided when theArray was created and the previous value at idx is released. If the value is not of the type expected by the retain callback, the behavior is undefined. The indices of other values are not affected. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArraySetValueAtIndex (
   CFMutableArrayRef theArray,
   CFIndex idx,
   const void *value
){};


/*CFStringGetPascalString

Copies the character contents of a CFString object to a local Pascal string buffer after converting the characters to a requested encoding.

Boolean CFStringGetPascalString (
   CFStringRef theString,
   StringPtr buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
);
Parameters
theString

The string to examine. 
buffer

The Pascal string buffer into which to copy the theString. The buffer must be at least bufferSize bytes in length. On return, contains the converted characters. If there is an error in conversion, the buffer contains only partial results. 
bufferSize

The length of the local buffer in bytes (accounting for the length byte). 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

true if the operation succeeds or false if the conversion fails or the provided buffer is too small. 
Discussion

This function is useful when you need your own copy of a CFString object's character data as a Pascal string. You can also call it as a “backup” operation when a prior call to the CFStringGetPascalStringPtr function fails. 
Availability
Available in Mac OS X v10.0 and later.*/
Boolean CFStringGetPascalString (
   CFStringRef theString,
   StringPtr buffer,
   CFIndex bufferSize,
   CFStringEncoding encoding
){};



/*CFBundleGetInfoDictionary

Returns a bundle’s information dictionary.

CFDictionaryRef CFBundleGetInfoDictionary (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFDictionary object containing the data stored in the bundle’s information property list. This is a global information dictionary. CFBundle may add extra keys to this dictionary for its own use. Ownership follows the Get Rule.
Discussion

You should typically use CFBundleGetValueForInfoDictionaryKey rather than retrieving values directly from the info dictionary because the function will return localized values if any are available. UseCFBundleGetInfoDictionary only if you know that the key you are interested in will not be localized.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDictionaryRef CFBundleGetInfoDictionary (
   CFBundleRef bundle
){};

/*CFMessagePortCreateRemote

Returns a CFMessagePort object connected to a remote port.

CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator,
   CFStringRef name
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name of the remote message port to which to connect. 
Return Value

The new CFMessagePort object, or NULL on failure. If a message port has already been created for the remote port, the pre-existing object is returned. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator,
   CFStringRef name
){};


/*CFMessagePortSendRequest

Sends a message to a remote CFMessagePort object.

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote,
   SInt32 msgid,
   CFDataRef data,
   CFTimeInterval sendTimeout,
   CFTimeInterval rcvTimeout,
   CFStringRef replyMode,
   CFDataRef *returnData
);
Parameters
remote

The message port to which data should be sent.
msgid

An arbitrary integer value that you can send with the message.
data

The data to send to remote.
sendTimeout

The time to wait for data to be sent.
rcvTimeout

The time to wait for a reply to be returned.
replyMode

The run loop mode in which the function should wait for a reply. If the message is a oneway (so no response is expected), then replyMode should be NULL. If replyMode is non-NULL, the function runs the run loop waiting for a reply, in that mode. replyMode can be any string name of a run loop mode, but it should be one with input sources installed. You should use the kCFRunLoopDefaultMode constant unless you have a specific reason to use a different mode.
returnData

Upon return, contains a CFData object containing the reply data. Ownership follows the Create Rule. 
Return Value

Error code indicating success or failure. See “CFMessagePortSendRequest Error Codes” for the possible return values.
Availability
Available in Mac OS X v10.0 and later.*/

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote,
   SInt32 msgid,
   CFDataRef data,
   CFTimeInterval sendTimeout,
   CFTimeInterval rcvTimeout,
   CFStringRef replyMode,
   CFDataRef *returnData
){};


/*CFMessagePortCreateLocal

Returns a local CFMessagePort object.

CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator,
   CFStringRef name,
   CFMessagePortCallBack callout,
   CFMessagePortContext *context,
   Boolean *shouldFreeInfo
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name with which to register the port. name can be NULL. 
callout

The callback function invoked when a message is received on the message port. 
context

A structure holding contextual information for the message port. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. 
shouldFreeInfo

A flag set by the function to indicate whether the info member of context should be freed. The flag is set to true on failure or if a local port named name already exists, false otherwise. shouldFreeInfo can be NULL. 
Return Value

The new CFMessagePort object, or NULL on failure. If a local port is already named name, the function returns that port instead of creating a new object; the context and callout parameters are ignored in this case. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator,
   CFStringRef name,
   CFMessagePortCallBack callout,
   CFMessagePortContext *context,
   Boolean *shouldFreeInfo
){};


/*CFMessagePortCreateRunLoopSource

Creates a CFRunLoopSource object for a CFMessagePort object.

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFMessagePortRef ms,
   CFIndex order
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
ms

The message port for which to create a run loop source. 
order

A priority index indicating the order in which run loop sources are processed. order is currently ignored by CFMessagePort object run loop sources. Pass 0 for this value. 
Return Value

The new CFRunLoopSource object for ms. Ownership follows the Create Rule.
Discussion

The run loop source is not automatically added to a run loop. To add the source to a run loop, use CFRunLoopAddSource.
Availability
Available in Mac OS X v10.0 and later.*/

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFMessagePortRef ms,
   CFIndex order
){};

/*CFBundleCopyAuxiliaryExecutableURL

Returns the location of a bundle’s auxiliary executable code.

CFURLRef CFBundleCopyAuxiliaryExecutableURL (
   CFBundleRef bundle,
   CFStringRef executableName
);
Parameters
bundle

The bundle to examine. 
executableName

The name of bundle’s auxiliary executable code. 
Return Value

The URL location of the specified bundle’s auxiliary executable code, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

This function can be used to find executables other than your main executable. This is useful, for instance, for applications that have some command line tool that is packaged with and used by the application. The tool can be packaged in the various platform executable directories in the bundle and can be located with this function. This allows an application to ship versions of the tool for each platform as it does for the main application executable. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyAuxiliaryExecutableURL (
   CFBundleRef bundle,
   CFStringRef executableName
){};


/*CFBundleCopySharedSupportURL

Returns the location of a bundle’s shared support files directory.

CFURLRef CFBundleCopySharedSupportURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object containing the location of bundle’s shared support files directory, or NULL if it could not be found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/

CFURLRef CFBundleCopySharedSupportURL (
   CFBundleRef bundle
){};


/*CFUUIDCreateFromUUIDBytes

Creates a CFUUID object from raw UUID bytes.

CFUUIDRef CFUUIDCreateFromUUIDBytes (
   CFAllocatorRef alloc,
   CFUUIDBytes bytes
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
bytes

Raw UUID bytes to use to create the CFUUID object. 
Return Value

A new CFUUID object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDCreateFromUUIDBytes (
   CFAllocatorRef alloc,
   CFUUIDBytes bytes
){};

/*CFPlugInRemoveInstanceForFactory

Unregisters an instance of a type with CFPlugIn.

void CFPlugInRemoveInstanceForFactory (
   CFUUIDRef factoryID
);
Parameters
factoryID

The CFUUID object representing the plug-in factory.
Discussion

If the instance counts of every factory in a plug-in are zero, the plug-in can be unloaded.]
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/

void CFPlugInRemoveInstanceForFactory (
   CFUUIDRef factoryID
){};

/*CFRetain

Retains a Core Foundation object.

CFTypeRef CFRetain (
   CFTypeRef cf
);
Parameters
cf

The CFType object to retain. This value must not be NULL
Return Value

The input value, cf. 
Discussion

You should retain a Core Foundation object when you receive it from elsewhere (that is, you did not create or copy it) and you want it to persist. If you retain a Core Foundation object you are responsible for releasing it (see Memory Management Programming Guide for Core Foundation). 
Special Considerations

If cf is NULL, this will cause a runtime error and your application will crash. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/


CFTypeRef CFRetain (
   CFTypeRef cf
){};

/*CFBundleCopyBuiltInPlugInsURL

Returns the location of a bundle’s built in plug-in.

CFURLRef CFBundleCopyBuiltInPlugInsURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine.
Return Value

A CFURL object describing the location of bundle’s built in plug-ins, or NULL if it could not be found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/

CFURLRef CFBundleCopyBuiltInPlugInsURL (
   CFBundleRef bundle
){};


/*CFPlugInCreate

Creates a CFPlugIn given its URL.

CFPlugInRef CFPlugInCreate (
   CFAllocatorRef allocator,
   CFURLRef plugInURL
);
Parameters
allocator

The allocator to use to allocate memory for the new plug-in. Pass NULL or kCFAllocatorDefault to use the default allocator. 
plugInURL

The location of the plug-in.
Return Value

A new plug-in. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/

CFPlugInRef CFPlugInCreate (
   CFAllocatorRef allocator,
   CFURLRef plugInURL
){};

/*CFPlugInFindFactoriesForPlugInTypeInPlugIn

Searches the given plug-in for factory functions capable of creating an instance of the given type.

CFArrayRef CFPlugInFindFactoriesForPlugInTypeInPlugIn (
   CFUUIDRef typeUUID,
   CFPlugInRef plugIn
);
Parameters
typeUUID

A UUID type.
plugIn

The plug-in to search.
Return Value

An array of UUIDs for factory functions capable of creating an instance of the given type. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/
CFArrayRef CFPlugInFindFactoriesForPlugInTypeInPlugIn (
   CFUUIDRef typeUUID,
   CFPlugInRef plugIn
){};


/*CFPlugInInstanceCreate

Creates a CFPlugIn instance of a given type using a given factory.

void *CFPlugInInstanceCreate (
   CFAllocatorRef allocator,
   CFUUIDRef factoryUUID,
   CFUUIDRef typeUUID
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the default allocator. 
factoryUUID

The UUID representing the factory function to use to create a plug-in of the given type. 
typeUUID

The UUID type.
Return Value

Returns the IUnknown interface for the new plug-in.
Discussion

The plug-in host uses this function to create an instance of the given type. Unless the plug-in is using dynamic registration, this function causes the plug-in's code to be loaded into memory. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/

void *CFPlugInInstanceCreate (
   CFAllocatorRef allocator,
   CFUUIDRef factoryUUID,
   CFUUIDRef typeUUID
){};



/*CFArrayRemoveAllValues

Removes all the values from an array, making it empty.

void CFArrayRemoveAllValues (
   CFMutableArrayRef theArray
);
Parameters
theArray

The array from which all of the values are removed. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayRemoveAllValues (
   CFMutableArrayRef theArray
){};


/*CFBundleUnloadExecutable

Unloads the main executable for the specified bundle.

void CFBundleUnloadExecutable (
   CFBundleRef bundle
);
Parameters
bundle

The bundle whose main executable you want to unload. 
Discussion

You should typically try to avoid using this function, but instead use CFBundleGetFunctionPointerForName and related functions since these make management of the bundle easier (when the last reference to the CFBundle object is released, and it is finally deallocated, then the code will be unloaded if it is still loaded, and if the executable is of a type that supports unloading).
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFBundleUnloadExecutable (
   CFBundleRef bundle
){};


/*CFBundleGetValueForInfoDictionaryKey

Returns a value in a bundle’s information dictionary.

CFTypeRef CFBundleGetValueForInfoDictionaryKey (
   CFBundleRef bundle,
   CFStringRef key
);
Parameters
bundle

The bundle to examine. 
key

The key for the value to return. 
Return Value

A value corresponding to key in bundle’s information dictionary. If available, a localized value is returned, otherwise the global value is returned. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeRef CFBundleGetValueForInfoDictionaryKey (
   CFBundleRef bundle,
   CFStringRef key
){};



/*CFPreferencesCopyApplicationList

Constructs and returns the list of all applications that have preferences in the scope of the specified user and host.

CFArrayRef CFPreferencesCopyApplicationList (
   CFStringRef userName,
   CFStringRef hostName
);
Parameters
userName

kCFPreferencesCurrentUser to search the current-user domain, otherwise kCFPreferencesAnyUser to search the any-user domain. 
hostName

kCFPreferencesCurrentHost to search the current-host domain, otherwise kCFPreferencesAnyHost to search the any-host domain.
Return Value

The list of application IDs. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFArrayRef CFPreferencesCopyApplicationList (
   CFStringRef userName,
   CFStringRef hostName
){};


/*(CFGregorianDateGetAbsoluteTime

Converts a Gregorian date value into an absolute time value.

CFAbsoluteTime CFGregorianDateGetAbsoluteTime (
   CFGregorianDate gdate,
   CFTimeZoneRef tz
);
Parameters
gdate

The Gregorian date to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

The absolute time equivalent of gdate. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

CFAbsoluteTime CFGregorianDateGetAbsoluteTime (
   CFGregorianDate gdate,
   CFTimeZoneRef tz
){};



/*CFAbsoluteTimeGetDayOfWeek

Returns an integer representing the day of the week indicated by the specified absolute time.

SInt32 CFAbsoluteTimeGetDayOfWeek (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);
Parameters
at

The absolute time to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

An integer (1-7) representing the day of the week specified by at. Per ISO-8601, Monday is represented by 1, Tuesday by 2, and so on.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

SInt32 CFAbsoluteTimeGetDayOfWeek (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
){};


/*CFAbsoluteTimeAddGregorianUnits

Adds a time interval, expressed as Gregorian units, to a given absolute time.

CFAbsoluteTime CFAbsoluteTimeAddGregorianUnits (
   CFAbsoluteTime at,
   CFTimeZoneRef tz,
   CFGregorianUnits units
);
Parameters
at

The absolute time to which the interval is added. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
units

The time interval to add to at. 
Return Value

An absolute time value equal to the sum of at and units. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

CFAbsoluteTime CFAbsoluteTimeAddGregorianUnits (
   CFAbsoluteTime at,
   CFTimeZoneRef tz,
   CFGregorianUnits units
){};



/*CFAbsoluteTimeGetGregorianDate

Converts an absolute time value into a Gregorian date.

CFGregorianDate CFAbsoluteTimeGetGregorianDate (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);
Parameters
at

The absolute time value to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

The Gregorian date equivalent for at. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFGregorianDate CFAbsoluteTimeGetGregorianDate (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
){};

/*CFTimeZoneCopySystem

Returns the time zone currently used by the system.

CFTimeZoneRef CFTimeZoneCopySystem ();
Return Value

A time zone representing the time zone currently used by the system, or the GMT time zone if the current zone cannot be determined. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFTimeZoneRef CFTimeZoneCopySystem (){};


/*CFStringGetDoubleValue

Returns the primary double value represented by a string.

double CFStringGetDoubleValue (
   CFStringRef str
);
Parameters
str

The string that represents a double value. If the object includes characters other than ASCII numbers or a valid decimal character, a scanning error results when the function is called and 0.0 is returned. 
Return Value

The double value represented by str. The result is 0.0 if there is a scanning error. 
Discussion

Consider the following example: double val = CFStringGetDoubleValue(CFSTR("0.123"));


The variable val in this example would contain the value 0.123 after the function is called.

The characters in the evaluated string must be either ASCII numbers or a valid non-localized decimal character; otherwise a scanning error results. 
Availability
Available in Mac OS X v10.0 and later.*/

double CFStringGetDoubleValue (
   CFStringRef str
){};

/*CFStringCreateWithBytes

Creates a string from a buffer containing characters in a specified encoding.

CFStringRef CFStringCreateWithBytes (
   CFAllocatorRef alloc,
   const UInt8 *bytes,
   CFIndex numBytes,
   CFStringEncoding encoding,
   Boolean isExternalRepresentation
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
bytes

The buffer containing the characters in the specified encoding. 
numBytes

The number of bytes in bytes. 
encoding

The string encoding of the characters in bytes. 
isExternalRepresentation

true if the characters in the byte buffer are in an “external representation” format—that is, whether the buffer contains a BOM (byte order marker) and so whether byte swapping must take place. This is usually the case for bytes that are read in from a text file or received over the network. Otherwise, pass false. 
Return Value

An immutable string, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function creates an immutable CFString object from a “raw” byte buffer—that is, a buffer containing characters but no length byte (as in Pascal buffers) and no terminating NULL character (as in C buffers). The number of bytes in the buffer is provided in a parameter. This function handles character data in an “external representation” format by interpreting any BOM (byte order marker) character and performing any necessary byte swapping. 
Availability
Available in Mac OS X v10.0 and later.*/
CFStringRef CFStringCreateWithBytes (
   CFAllocatorRef alloc,
   const UInt8 *bytes,
   CFIndex numBytes,
   CFStringEncoding encoding,
   Boolean isExternalRepresentation
){};


/*CFStreamCreatePairWithSocket

Creates readable and writable streams connected to a socket.

void CFStreamCreatePairWithSocket (
   CFAllocatorRef alloc,
   CFSocketNativeHandle sock,
   CFReadStreamRef *readStream,
   CFWriteStreamRef *writeStream
);
Parameters
alloc

The allocator to use to allocate memory for the new objects. Pass NULL or kCFAllocatorDefault to use the current default allocator.
sock

The pre-existing (and already connected) socket which the socket streams should use.
readStream

Upon return, a readable stream connected to the socket address in signature. If you pass NULL, this function will not create a readable stream. Ownership follows the Create Rule.
writeStream

Upon return, a writable stream connected to the socket address in signature. If you pass NULL, this function will not create a writable stream. Ownership follows the Create Rule.
Discussion

Most properties are shared by both streams. Setting the property for one stream automatically sets the property for the other.
Availability
Available in Mac OS X v10.1 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFStreamCreatePairWithSocket (
   CFAllocatorRef alloc,
   CFSocketNativeHandle sock,
   CFReadStreamRef *readStream,
   CFWriteStreamRef *writeStream
){};

/*CFSocketCreate

Creates a CFSocket object of a specified protocol and type.

CFSocketRef CFSocketCreate (
   CFAllocatorRef allocator,
   SInt32 protocolFamily,
   SInt32 socketType,
   SInt32 protocol,
   CFOptionFlags callBackTypes,
   CFSocketCallBack callout,
   const CFSocketContext *context
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
protocolFamily

The protocol family for the socket. If negative or 0 is passed, the socket defaults to PF_INET.
socketType

The socket type to create. If protocolFamily is PF_INET and socketType is negative or 0, the socket type defaults to SOCK_STREAM.
protocol

The protocol for the socket. If protocolFamily is PF_INET and protocol is negative or 0, the socket protocol defaults to IPPROTO_TCP if socketType is SOCK_STREAM or IPPROTO_UDP if socketType is SOCK_DGRAM.
callBackTypes

A bitwise-OR combination of the types of socket activity that should cause callout to be called. See Callback Types for the possible activity values. 
callout

The function to call when one of the activities indicated by callBackTypes occurs. 
context

A structure holding contextual information for the CFSocket object. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. Can be NULL. 
Return Value

The new CFSocket object, or NULL if an error occurred. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/

CFSocketRef CFSocketCreate (
   CFAllocatorRef allocator,
   SInt32 protocolFamily,
   SInt32 socketType,
   SInt32 protocol,
   CFOptionFlags callBackTypes,
   CFSocketCallBack callout,
   const CFSocketContext *context
){};

/*CFSocketSetAddress

Binds a local address to a CFSocket object.

CFSocketError CFSocketSetAddress (
   CFSocketRef s,
   CFDataRef address
);
Parameters
s

The CFSocket object to modify. 
address

A CFData object containing a struct sockaddr appropriate for the protocol family of s. 
Return Value

An error code indicating success or failure. 
Discussion

Once s is bound to address, depending on the socket’s protocol, other processes and computers can connect to s.
Availability
Available in Mac OS X v10.0 and later.*/

CFSocketError CFSocketSetAddress (
   CFSocketRef s,
   CFDataRef address
){};

/*CFSocketCopyAddress

Returns the local address of a CFSocket object.

CFDataRef CFSocketCopyAddress (
   CFSocketRef s
);
Parameters
s

The CFSocket object to examine. 
Return Value

The local address, stored as a struct sockaddr in a CFData object, of s. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/

CFDataRef CFSocketCopyAddress (
   CFSocketRef s
){};



/*CFRunLoopRunInMode

Runs the current thread’s CFRunLoop object in a particular mode.

SInt32 CFRunLoopRunInMode (
   CFStringRef mode,
   CFTimeInterval seconds,
   Boolean returnAfterSourceHandled
);
Parameters
mode

The run loop mode to run. mode can be any arbitrary CFString. You do not need to explicitly create a run loop mode, although a run loop mode needs to contain at least one source or timer to run.
seconds

The length of time to run the run loop. If 0, only one pass is made through the run loop before returning; if multiple sources or timers are ready to fire immediately, only one (possibly two if one is a version 0 source) will be fired, regardless of the value of returnAfterSourceHandled.
returnAfterSourceHandled

A flag indicating whether the run loop should exit after processing one source. If false, the run loop continues processing events until seconds has passed.
Return Value

A value indicating the reason the run loop exited. Possible values are described below.
Discussion

Run loops can be run recursively. You can call CFRunLoopRunInMode from within any run loop callout and create nested run loop activations on the current thread’s call stack. You are not restricted in which modes you can run from within a callout. You can create another run loop activation running in any available run loop mode, including any modes already running higher in the call stack.

The run loop exits with the following return values under the indicated conditions:
kCFRunLoopRunFinished. The run loop mode mode has no sources or timers.
kCFRunLoopRunStopped. The run loop was stopped with CFRunLoopStop.
kCFRunLoopRunTimedOut. The time interval seconds passed.
kCFRunLoopRunHandledSource. A source was processed. This exit condition only applies when returnAfterSourceHandled is true.
Availability
Available in Mac OS X v10.0 and later.*/
SInt32 CFRunLoopRunInMode (
   CFStringRef mode,
   CFTimeInterval seconds,
   Boolean returnAfterSourceHandled
){};



/*CFDictionaryApplyFunction

Calls a function once for each key-value pair in a dictionary.

void CFDictionaryApplyFunction (
   CFDictionaryRef theDict,
   CFDictionaryApplierFunction applier,
   void *context
);
Parameters
theDict

The dictionary to operate upon. 
applier

The callback function to call once for each key-value pair in the dictionary. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. If there are keys or values which the applier function does not expect or cannot properly apply to, the behavior is undefined. 
context

A pointer-sized program-defined value, which is passed as the third parameter to the applier function, but is otherwise unused by this function. The value must be appropriate for the applier function.
Discussion

If this function iterates over a mutable collection, it is unsafe for the applier function to change the contents of the collection. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFDictionaryApplyFunction (
   CFDictionaryRef theDict,
   CFDictionaryApplierFunction applier,
   void *context
){};



/*CFUUIDCreateFromString

Creates a CFUUID object for a specified string.

CFUUIDRef CFUUIDCreateFromString (
   CFAllocatorRef alloc,
   CFStringRef uuidStr
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
uuidStr

A string containing a UUID. The standard format for UUIDs represented in ASCII is a string punctuated by hyphens, for example 68753A44-4D6F-1226-9C60-0050E4C00067.
Return Value

A new CFUUID object, or if a CFUUID object of the same value already exists, the existing instance with its reference count incremented. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDCreateFromString (
   CFAllocatorRef alloc,
   CFStringRef uuidStr
){};



/*CFPlugInAddInstanceForFactory

Registers a new instance of a type with CFPlugIn. .

void CFPlugInAddInstanceForFactory (
   CFUUIDRef factoryID
);
Parameters
factoryID

The CFUUID object representing the plug-in factory.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/
void CFPlugInAddInstanceForFactory (
   CFUUIDRef factoryID
){};


/*CFRunLoopRemoveSource

Removes a CFRunLoopSource object from a run loop mode.

void CFRunLoopRemoveSource (
   CFRunLoopRef rl,
   CFRunLoopSourceRef source,
   CFStringRef mode
);
Parameters
rl

The run loop to modify. 
source

The run loop source to remove. 
mode

The run loop mode of rl from which to remove source. Use the constant kCFRunLoopCommonModes to remove source from the set of objects monitored by all the common modes. 
Discussion

If source is a version 0 source, this function calls the cancel callback function specified in the context structure for source. See CFRunLoopSourceContext and CFRunLoopSourceContext1for more details.

If rl does not contain source in mode, this function does nothing.
Availability
Available in Mac OS X v10.0 and later.*/

void CFRunLoopRemoveSource (
   CFRunLoopRef rl,
   CFRunLoopSourceRef source,
   CFStringRef mode
){}


/*CFSocketGetSocketFlags

Returns flags that control certain behaviors of a CFSocket object.

CFOptionFlags CFSocket (
   CFSocketRef s
);
Parameters
s

The CFSocket to examine. 
Return Value

A bitwise-OR combination of flags controlling the behavior of s. See CFSocket Flags for the list of available flags.
Discussion

See CFSocketSetSocketFlags for details on what the flags of a CFSocket mean.
Availability
Available in Mac OS X v10.2 and later.*/
CFOptionFlags CFSocketGetSocketFlags (
   CFSocketRef s
){};

/*CFSocketSetSocketFlags

Sets flags that control certain behaviors of a CFSocket object.

void CFSocket (
   CFSocketRef s,
   CFOptionFlags flags
);
Parameters
s

The CFSocket object to modify. 
flags

A bitwise-OR combination of flags controlling the behavior of s. See CFSocket Flags for the list of available flags.
Discussion

The flags argument controls whether callbacks of a given type are automatically reenabled after they are triggered, and whether the underlying native socket is closed when s is invalidated.

By default kCFSocketReadCallBack, kCFSocketAcceptCallBack, and kCFSocketDataCallBack callbacks are automatically reenabled, whereas kCFSocketWriteCallBack callbacks are not; kCFSocketConnectCallBack callbacks can only occur once, so they cannot be reenabled. Be careful about automatically reenabling read and write callbacks, because this implies that the callbacks will be sent repeatedly if the socket remains readable or writable respectively. Be sure to set these flags only for callback types that your CFSocket object actually possesses; the result of setting them for other callback types is undefined.

By default the underlying native socket will be closed when s is invalidated, but it will not be if the kCFSocketCloseOnInvalidate flag is turned off. This can be useful when you want to destroy a CFSocket object but continue to use the underlying native socket. The CFSocket object must still be invalidated when it will no longer be used. Do not in either case close the underlying native socket without invalidating the CFSocket object.
Availability
Available in Mac OS X v10.2 and later.*/

void CFSocketSetSocketFlags (
   CFSocketRef s,
   CFOptionFlags flags
){};

/*CFDateFormatterCreateStringWithAbsoluteTime

Returns a string representation of the given absolute time using the specified date formatter.

CFStringRef CFDateFormatterCreateStringWithAbsoluteTime(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFAbsoluteTime at
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatter

The date formatter object that specifies the format of the returned string. 
at

The absolute time for which to generate a string representation.
Return Value

A new string that represents at in the specified format. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.3 and later.*/

CFStringRef CFDateFormatterCreateStringWithAbsoluteTime(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFAbsoluteTime at
){};


/*CFStringConvertEncodingToNSStringEncoding

Returns the Cocoa encoding constant that maps most closely to a given Core Foundation encoding constant.

UInt32 CFStringConvertEncodingToNSStringEncoding (
   CFStringEncoding encoding
);
Parameters
encoding

The Core Foundation string encoding to use. 
Return Value

The Cocoa encoding (of type NSStringEncoding) that is closest to the Core Foundation encoding encoding. The behavior is undefined if an invalid string encoding is passed. 
Discussion

The CFStringConvertNSStringEncodingToEncoding function is complementary to this function. 
Availability
Available in Mac OS X v10.0 and later.*/

UInt32 CFStringConvertEncodingToNSStringEncoding (
   CFStringEncoding encoding
){};

/*CFCopyDescription

Returns a textual description of a Core Foundation object.

CFStringRef CFCopyDescription (
   CFTypeRef cf
);
Parameters
cf

The CFType object (a generic reference of type CFTypeRef) from which to derive a description.
Return Value

A string that contains a description of cf. Ownership follows the Create Rule.
Discussion

The nature of the description differs by object. For example, a description of a CFArray object would include descriptions of each of the elements in the collection.

You can use this function for debugging Core Foundation objects in your code. Note, however, that the description for a given object may be different in different releases of the operating system. Do not create dependencies in your code on the content or format of the information returned by this function. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFCopyDescription (
   CFTypeRef cf
){};


/*CFStringGetPascalStringPtr

Quickly obtains a pointer to a Pascal buffer containing the characters of a string in a given encoding.

ConstStringPtr CFStringGetPascalStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
);
Parameters
theString

The string to examine. 
encoding

The string encoding to which the character contents of theString should be converted. 
Return Value

A pointer to a Pascal string buffer or NULL if the internal storage of theString does not allow this to be returned efficiently. 
Discussion

This function either returns the requested pointer immediately, with no memory allocations and no copying, in constant time, or returns NULL. If the latter is returned, call an alternative function such as the CFStringGetPascalString function to extract the characters.

Whether or not this function returns a valid pointer or NULL depends on many factors, all of which depend on how the string was created and its properties. In addition, the function result might change between different releases and on different platforms. So do not count on receiving a non-NULL result from this function under any circumstances. 
Availability
Available in Mac OS X v10.0 and later.*/

ConstStringPtr CFStringGetPascalStringPtr (
   CFStringRef theString,
   CFStringEncoding encoding
){};


/*CFArrayGetValues

Fills a buffer with values from an array.

void CFArrayGetValues (
   CFArrayRef theArray,
   CFRange range,
   const void **values
);
Parameters
theArray

The array to examine. 
range

The range of values within theArray to retrieve. The range must lie within the bounds of theArray. The range may be empty (length 0), in which case no values are put into the buffer values.
values

A C array of pointer-sized values to be filled with values from theArray. The values in the C array are in the same order as they appear in theArray. If this value is not a valid pointer to a C array of at least range.length pointers, the behavior is undefined. If the values are Core Foundation objects, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayGetValues (
   CFArrayRef theArray,
   CFRange range,
   const void **values
){};


/*CFURLCopyAbsoluteURL

Creates a new CFURL object by resolving the relative portion of a URL against its base.

CFURLRef CFURLCopyAbsoluteURL (
   CFURLRef relativeURL
);
Parameters
relativeURL

The CFURL object to resolve. 
Return Value

A new CFURL object, or NULL if relativeURL cannot be made absolute. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCopyAbsoluteURL (
   CFURLRef relativeURL
){};

/*CFURLCopyScheme

Returns the scheme portion of a given URL.

CFStringRef CFURLCopyScheme (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The scheme of anURL. Ownership follows the Create Rule.
Discussion

The URL scheme is the portion of the URL specifying the transport type. For example http, ftp, and rtsp are schemes. This function leaves any percent escape sequences intact. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyScheme (
   CFURLRef anURL
){};


/*CFURLGetPortNumber

Returns the port number from a given URL.

SInt32 CFURLGetPortNumber (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The port number of anURL, or -1 if no port number exists. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

SInt32 CFURLGetPortNumber (
   CFURLRef anURL
){};


/*CFURLCopyHostName

Returns the host name of a given URL.

CFStringRef CFURLCopyHostName (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The host name of anURL. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyHostName (
   CFURLRef anURL
){};


/*CFURLCreateCopyDeletingLastPathComponent

Creates a copy of a given URL with the last path component deleted.

CFURLRef CFURLCreateCopyDeletingLastPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The CFURL object whose last path component you want to delete. 
Return Value

A copy of url with the last path component deleted. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateCopyDeletingLastPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url
){};


/*CFGetRetainCount

Returns the reference count of a Core Foundation object.

CFIndex CFGetRetainCount (
   CFTypeRef cf
);
Parameters
cf

The CFType object to examine. 
Return Value

A number representing the reference count of cf. 
Discussion

You increment the reference count using the CFRetain function, and decrement the reference count using the CFRelease function.

This function may useful for debugging memory leaks. You normally do not use this function, otherwise.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFGetRetainCount (
   CFTypeRef cf
){};

/*CFStringLowercase

Changes all uppercase alphabetical characters in a CFMutableString to lowercase.

void CFStringLowercase (
   CFMutableStringRef theString,
   CFLocaleRef locale
);
Parameters
theString

The string to be lowercased. If this value is not a CFMutableString object, an assertion is raised. 
locale

The locale to use when the lowercasing operation is performed. Prior to Mac OS X v10.3 this parameter was an untyped pointer and not used.
Special Considerations

The locale parameter type changed from void * to CFLocaleRef in Mac OS X v10.3.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFStringLowercase (
   CFMutableStringRef theString,
   CFLocaleRef locale
){};

/*CFUUIDCreateString

Returns the string representation of a specified CFUUID object.

CFStringRef CFUUIDCreateString (
   CFAllocatorRef alloc,
   CFUUIDRef uuid
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
uuid

The CFUUID object whose string representation to obtain. 
Return Value

The string representation of uuid. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFUUIDCreateString (
   CFAllocatorRef alloc,
   CFUUIDRef uuid
){};


/*CFCopyLocalizedStringFromTableInBundle

Returns a localized version of the specified string.

CFStringRef CFCopyLocalizedStringFromTableInBundle (
   CFStringRef key,
   CFStringRef tableName,
   CFBundleRef bundle,
   const char *comment
);
Parameters
key

The development language version of the string. This string is used as the search key to locate the localized version of the string. 
tableName

The name of the strings file to search. The name should not include the strings filename extension. The case of the string must match that of the file name, even on file systems (such as HFS+) that are not case sensitive with regards to file names
bundle

The bundle to examine. 
comment

A comment to provide the translators with contextual information necessary for proper translation.
Return Value

The localized version of the requested string, or key if no value corresponding to key is found. Ownership follows the Create Rule.
Discussion

This is a macro variant of CFBundleCopyLocalizedString for use with the genstrings tool. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFCopyLocalizedStringFromTableInBundle (
   CFStringRef key,
   CFStringRef tableName,
   CFBundleRef bundle,
   const char *comment
){};

/*CFUUIDCreate

Creates a Universally Unique Identifier (UUID) object.

CFUUIDRef CFUUIDCreate (
   CFAllocatorRef alloc
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
Return Value

A new CFUUID object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDCreate (
   CFAllocatorRef alloc
){};

/*CFDictionaryContainsValue

Reports whether or not a value is in a dictionary.

Boolean CFDictionaryContainsValue (
   CFDictionaryRef theDict,
   const void *value
);
Parameters
theDict

The dictionary to examine. 
value

The value for which to find matches in the dictionary. The value equal callback provided when the dictionary was created is used to compare. If the equal callback was NULL, pointer equality (in C, ==) is used. If value, or any other value in the dictionary, is not understood by the equal callback, the behavior is undefined. 
Return Value

true, if value is in the dictionary, otherwise false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

Boolean CFDictionaryContainsValue (
   CFDictionaryRef theDict,
   const void *value
){};

/*CFStringGetMostCompatibleMacStringEncoding

Returns the most compatible Mac OS script value for the given input encoding.

CFStringEncoding CFStringGetMostCompatibleMacStringEncoding (
   CFStringEncoding encoding
);
Parameters
encoding

The encoding for which you wish to find a compatible Mac OS script value.
Return Value

The most compatible Mac OS script value for encoding.
Availability
Available in Mac OS X v10.0 and later.*/
CFStringEncoding CFStringGetMostCompatibleMacStringEncoding (
   CFStringEncoding encoding
){};




/*CFStringGetListOfAvailableEncodings

Returns a pointer to a list of string encodings supported by the current system.

const CFStringEncoding *CFStringGetListOfAvailableEncodings ();
Return Value

A pointer to a kCFStringEncodingInvalidId-terminated list of enum constants, each of type CFStringEncoding. 
Availability
Available in Mac OS X v10.0 and later.*/

const CFStringEncoding *CFStringGetListOfAvailableEncodings (){};

/*CFBundleOpenBundleResourceMap

Opens the non-localized and localized resource files (if any) for a bundle in a single resource map. 

short CFBundleOpenBundleResourceMap (
   CFBundleRef bundle
);
Parameters
bundle

The bundle whose resource map you want to open.
Return Value

A distinct reference number for the resource map.
Discussion

Creates and makes current a single read-only resource map containing the non-localized and localized resource files. If this function is called multiple times, it opens the files multiple times and returns distinct reference numbers for each. Use CFBundleCloseBundleResourceMap to close a resource map.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
short CFBundleOpenBundleResourceMap (
   CFBundleRef bundle
){};

/*CFBundleCopyPrivateFrameworksURL

Returns the location of a bundle’s private Frameworks directory.

CFURLRef CFBundleCopyPrivateFrameworksURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine.
Return Value

A CFURL object describing the location of bundle’s private frameworks directory, or NULL if it could not be found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyPrivateFrameworksURL (
   CFBundleRef bundle
){};


/*CFBundleGetLocalInfoDictionary

Returns a bundle’s localized information dictionary.

CFDictionaryRef CFBundleGetLocalInfoDictionary (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A dictionary containing the key-value pairs in bundle’s localized information dictionary. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFDictionaryRef CFBundleGetLocalInfoDictionary (
   CFBundleRef bundle
){};

/*CFRunLoopTimerInvalidate

Invalidates a CFRunLoopTimer object, stopping it from ever firing again.

void CFRunLoopTimerInvalidate (
   CFRunLoopTimerRef timer
);
Parameters
timer

The run loop timer to invalidate. 
Discussion

Once invalidated, timer will never fire and call its callback function again. This function automatically removes timer from all run loop modes in which it had been added. The memory is not deallocated unless the run loop held the only reference to timer.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopTimerInvalidate (
   CFRunLoopTimerRef timer
){};





/*CFRunLoopAddTimer

Adds a CFRunLoopTimer object to a run loop mode.

void CFRunLoopAddTimer (
   CFRunLoopRef rl,
   CFRunLoopTimerRef timer,
   CFStringRef mode
);
Parameters
rl

The run loop to modify. 
timer

The run loop timer to add. 
mode

The run loop mode of rl to which to add timer. Use the constant kCFRunLoopCommonModes to add timer to the set of objects monitored by all the common modes. 
Discussion

A run loop timer can be registered in only one run loop at a time, although it can be added to multiple run loop modes within that run loop.

If rl already contains timer in mode, this function does nothing.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopAddTimer (
   CFRunLoopRef rl,
   CFRunLoopTimerRef timer,
   CFStringRef mode
){};

/*CFRunLoopTimerCreate

Creates a new CFRunLoopTimer object.

CFRunLoopTimerRef CFRunLoopTimerCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime fireDate,
   CFTimeInterval interval,
   CFOptionFlags flags,
   CFIndex order,
   CFRunLoopTimerCallBack callout,
   CFRunLoopTimerContext *context
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
fireDate

The time at which the timer should first fire. The fine precision (sub-millisecond at most) of the fire date may be adjusted slightly by the timer if there are implementation reasons to do.
interval

The firing interval of the timer. If 0 or negative, the timer fires once and then is automatically invalidated. The fine precision (sub-millisecond at most) of the interval may be adjusted slightly by the timer if implementation reasons to do so exist.
flags

Currently ignored. Pass 0 for future compatibility.
order

A priority index indicating the order in which run loop timers are processed. Run loop timers currently ignore this parameter. Pass 0.
callout

The callback function that is called when the timer fires. 
context

A structure holding contextual information for the run loop timer. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. Can be NULL if the callback function does not need the context’s info pointer to keep track of state. 
Return Value

The new CFRunLoopTimer object. Ownership follows the Create Rule.
Discussion

A timer needs to be added to a run loop mode before it will fire. To add the timer to a run loop, use CFRunLoopAddTimer. A timer can be registered to only one run loop at a time, although it can be in multiple modes within that run loop.
Availability
Available in Mac OS X v10.0 and later.*/
CFRunLoopTimerRef CFRunLoopTimerCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime fireDate,
   CFTimeInterval interval,
   CFOptionFlags flags,
   CFIndex order,
   CFRunLoopTimerCallBack callout,
   CFRunLoopTimerContext *context
){};


/*CFRunLoopTimerSetNextFireDate

Sets the next firing date for a CFRunLoopTimer object .

void CFRunLoopTimerSetNextFireDate (
   CFRunLoopTimerRef timer,
   CFAbsoluteTime fireDate
);
Parameters
timer

The run loop timer to modify. 
fireDate

The new firing time for timer. 
Discussion

Resetting a timer’s next firing time is a relatively expensive operation and should not be done if it can be avoided; letting timers autorepeat is more efficient. In some cases, however, manually-adjusted, repeating timers are useful. For example, if you have an action that will be performed multiple times in the future, but at irregular time intervals, it would be very expensive to create, add to run loop modes, and then destroy a timer for each firing event. Instead, you can create a repeating timer with an initial firing time in the distant future (or the initial firing time) and a very large repeat interval—on the order of decades or more—and add it to all the necessary run loop modes. Then, when you know when the timer should fire next, you reset the firing time with CFRunLoopTimerSetNextFireDate, perhaps from the timer’s own callback function. This technique effectively produces a reusable, asynchronous timer.
Availability
Available in Mac OS X v10.0 and later.*/
void CFRunLoopTimerSetNextFireDate (
   CFRunLoopTimerRef timer,
   CFAbsoluteTime fireDate
){};


/*CFRunLoopTimerGetInterval

Returns the firing interval of a repeating CFRunLoopTimer object.

CFTimeInterval CFRunLoopTimerGetInterval (
   CFRunLoopTimerRef timer
);
Parameters
timer

The run loop timer to examine. 
Return Value

The firing interval of timer. Returns 0 if timer does not repeat. 
Availability
Available in Mac OS X v10.0 and later.*/
CFTimeInterval CFRunLoopTimerGetInterval (
   CFRunLoopTimerRef timer
){};

/*CFUserNotificationDisplayNotice

Displays a user notification dialog that does not need a user response.

SInt32 CFUserNotificationDisplayNotice (
   CFTimeInterval timeout,
   CFOptionFlags flags,
   CFURLRef iconURL,
   CFURLRef soundURL,
   CFURLRef localizationURL,
   CFStringRef alertHeader,
   CFStringRef alertMessage,
   CFStringRef defaultButtonTitle
);
Parameters
timeout

The amount of time to wait for the user to dismiss the notification dialog before the dialog dismisses itself. Pass 0 to have the dialog never time out.
flags

A set of flags describing the type of notification dialog to display. The value is normally just the alert level from Alert Levels. If you don’t want a default button displayed, perform a bitwise-OR operation with the alert level and the constant kCFUserNotificationNoDefaultButtonFlag.
iconURL

A file URL pointing to the icon to display in the dialog. If NULL, a default icon is used based on the notification’s alert level specified in flags.
soundURL

Not used.
localizationURL

A file URL pointing to a bundle that contains localized versions of the strings displayed in the dialog. Can be NULL.
alertHeader

The title of the notification dialog. Cannot be NULL.
alertMessage

The message string to display in the dialog. Can be NULL.
defaultButtonTitle

The title of the default button. If NULL, the string OK is used.
Return Value

0 if the cancel was successful; a non-0 value otherwise.
Discussion

This function returns immediately. It does not wait for a user response after displaying the dialog.
Availability
Available in Mac OS X v10.0 and later.*/
SInt32 CFUserNotificationDisplayNotice (
   CFTimeInterval timeout,
   CFOptionFlags flags,
   CFURLRef iconURL,
   CFURLRef soundURL,
   CFURLRef localizationURL,
   CFStringRef alertHeader,
   CFStringRef alertMessage,
   CFStringRef defaultButtonTitle
){};


/*CFNotificationCenterRemoveEveryObserver

Stops an observer from receiving any notifications from any object.

void CFNotificationCenterRemoveEveryObserver (
   CFNotificationCenterRef center,
   const void *observer
);
Parameters
center

The notification center from which to remove observers. 
observer

The observer. This value must not be NULL.
Discussion

If you no longer want an observer to receive any notifications, perhaps because the observer is being deallocated, you can call this function to unregister the observer from all the notifications for which it had previously registered.
Availability
Available in Mac OS X v10.0 and later.*/
void CFNotificationCenterRemoveEveryObserver (
   CFNotificationCenterRef center,
   const void *observer
){};

/*CFNotificationCenterPostNotification

Posts a notification for an object.

void CFNotificationCenterPostNotification (
   CFNotificationCenterRef center,
   CFStringRef name,
   const void *object,
   CFDictionaryRef userInfo,
   Boolean deliverImmediately
);
Parameters
center

The notification center to post the notification. 
name

The name of the notification to post. This value must not be NULL. 
object

The object posting the notification. If NULL, the notification is sent only to observers that are observing all objects. In other words, only observers that registered for the notification with a NULL value for object will receive the notification.

If you want to allow your clients to register for notifications using Cocoa APIs (see NSNotificationCenter Class Reference), then object must be a Core Foundation or Cocoa object.

For distributed notifications, object must be a CFString object. 

If the notification center is a Darwin notification center, this value is ignored.
userInfo

A dictionary passed to observers. You populate this dictionary with additional information describing the notification. For distributed notifications, the dictionary must contain only property list objects. This value may be NULL. 

If the notification center is a Darwin notification center, this value is ignored.
deliverImmediately

If true, the notification is delivered to all observers immediately, even if some observers are in suspended (background) applications and they requested different suspension behavior when registering for the notification. If false, each observer’s requested suspension behavior is respected. 

If the notification center is a Darwin notification center, this value is ignored.
Availability
Available in Mac OS X v10.0 and later.*/
void CFNotificationCenterPostNotification (
   CFNotificationCenterRef center,
   CFStringRef name,
   const void *object,
   CFDictionaryRef userInfo,
   Boolean deliverImmediately
){};

/*CFStringFind

Searches for a substring within a string and, if it is found, yields the range of the substring within the object's characters.

CFRange CFStringFind (
   CFStringRef theString,
   CFStringRef stringToFind,
   CFOptionFlags compareOptions
);
Parameters
theString

The string in which to search for stringToFind. 
stringToFind

The string to search for in theString.
compareOptions

Flags that select different types of comparisons, such as localized comparison, case-insensitive comparison, and non-literal comparison. If you want the default comparison behavior, pass 0. See “String Comparison Flags” for the available flags.
Return Value

The range of the located substring within theString. If a match is not located, the returned CFRange structure will have a location of kCFNotFound and a length of 0 (either of which is enough to indicate failure). 
Discussion

This function is a convenience when you want to know if the entire range of characters represented by a string contains a particular substring. If you want to search only part of the characters of a string, use the CFStringFindWithOptions function. Both of these functions return upon finding the first occurrence of the substring, so if you want to find out about multiple occurrences, call the CFStringCreateArrayWithFindResults function.

Depending on the comparison-option flags specified, the length of the resulting range might be different than the length of the search string. 
Availability
Available in Mac OS X v10.0 and later.*/
CFRange CFStringFind (
   CFStringRef theString,
   CFStringRef stringToFind,
   CFOptionFlags compareOptions
){};

/*Predefined Allocators

CFAllocator provides the following predefined allocators. In general, you should use kCFAllocatorDefault unless one of the special circumstances exist below.

const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
const CFAllocatorRef kCFAllocatorMalloc;
const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;
Constants
kCFAllocatorDefault

This is a synonym for NULL. 

Available in Mac OS X v10.0 and later.
extern  const CFAllocatorRef kCFAllocatorDefault;extern  const CFAllocatorRef kCFAllocatorDefault;kCFAllocatorSystemDefault

Default system allocator.

You rarely need to use this.

Available in Mac OS X v10.0 and later.
kCFAllocatorMalloc

This allocator uses malloc(), realloc(), and free(). 

Typically you should not use this allocator, use kCFAllocatorDefault instead. This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory was obtained as a result of malloc type functions.

Available in Mac OS X v10.0 and later.
kCFAllocatorMallocZone

This allocator explicitly uses the default malloc zone, returned by malloc_default_zone().

You should only use this when an object is safe to be allocated in non-scanned memory.

Available in Mac OS X v10.4 and later.
kCFAllocatorNull

This allocator does nothing—it allocates no memory. 

This allocator is useful as the bytesDeallocator in CFData or contentsDeallocator in CFString where the memory should not be freed.

Available in Mac OS X v10.0 and later.
kCFAllocatorUseContext

Special allocator argument to CFAllocatorCreate—it uses the functions given in the context to allocate the allocator.

Available in Mac OS X v10.0 and later.
Declared In
CFBase.h*/

const CFAllocatorRef kCFAllocatorDefault;
const CFAllocatorRef kCFAllocatorSystemDefault;
 const CFAllocatorRef kCFAllocatorMalloc;
 const CFAllocatorRef kCFAllocatorMallocZone;
const CFAllocatorRef kCFAllocatorNull;
const CFAllocatorRef kCFAllocatorUseContext;


/*Application, Host, and User Keys

Keys used to specify the common preference domains.

const CFStringRef kCFPreferencesAnyApplication;
const CFStringRef kCFPreferencesAnyHost;
const CFStringRef kCFPreferencesAnyUser;
const CFStringRef kCFPreferencesCurrentApplication;
const CFStringRef kCFPreferencesCurrentHost;
const CFStringRef kCFPreferencesCurrentUser;
Constants
kCFPreferencesAnyApplication

Indicates a preference that applies to any application.

Available in Mac OS X v10.0 and later.
kCFPreferencesAnyHost

Indicates a preference that applies to any host.

Available in Mac OS X v10.0 and later.
kCFPreferencesAnyUser

Indicates a preference that applies to any user.

Available in Mac OS X v10.0 and later.
kCFPreferencesCurrentApplication

Indicates a preference that applies only to the current application.

Available in Mac OS X v10.0 and later.
kCFPreferencesCurrentHost

Indicates a preference that applies only to the current host.

Available in Mac OS X v10.0 and later.
kCFPreferencesCurrentUser

Indicates a preference that applies only to the current user.

Available in Mac OS X v10.0 and later.*/

 const CFStringRef CFPreferencesAppValue;
 const CFStringRef kCFPreferencesAnyHost;
 const CFStringRef kCFPreferencesAnyUser;
 const CFStringRef kCFPreferencesCurrentApplication;
const CFStringRef kCFPreferencesCurrentHost;
const CFStringRef kCFPreferencesCurrentUser;

/*CFStream Error Domain Constants

Defines constants for values returned in the domain field of the CFStreamError structure. 

typedef enum {
   kCFStreamErrorDomainCustom = -1,
   kCFStreamErrorDomainPOSIX = 1,
   kCFStreamErrorDomainMacOSStatus,
} CFStreamErrorDomain;
const SInt32 kCFStreamErrorDomainNetDB;
const SInt32 kCFStreamErrorDomainNetServices;
const SInt32 kCFstreamErrorDomainMach;
const SInt32 kCFStreamErrorDomainFTP;
const SInt32 kCFStreamErrorDomainHTTP;
const int kCFStreamErrorDomainSOCKS;
const SInt32 kCFStreamErrorDomainSystemConfiguration;
const int kCFStreamErrorDomainSSL;
Constants
kCFStreamErrorDomainCustom

The error code is a custom error code.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainPOSIX

The error code is an error code defined in errno.h.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainMacOSStatus

The error is an OSStatus value defined in MacErrors.h.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainNetDB

The error code is an error code defined in netdb.h.

Available in Mac OS X v10.3 and later.
kCFStreamErrorDomainNetServices

The error code is a CFNetService error code. For details, see the CFNetServicesError enumeration.

Available in Mac OS X v10.2 and later.
kCFStreamErrorDomainMach

The error code is a Mach error code defined in mach/error.h.

Available in Mac OS X v10.2 and later.
kCFStreamErrorDomainFTP

The error code is an FTP error code.

Available in Mac OS X v10.3 and later.
kCFStreamErrorDomainHTTP

The error code is an HTTP error code.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainSOCKS

The error code is a SOCKS proxy error.

Available in Mac OS X v10.2 and later.
kCFStreamErrorDomainSystemConfiguration

The error code is a system configuration error code as defined in System/ConfigurationSystemConfiguration.h.

Available in Mac OS X v10.3 and later.
kCFStreamErrorDomainSSL

The error code is an SSL error code as defined in Security/SecureTransport.h.

Available in Mac OS X v10.1 and later.
Discussion

These constants indicate how the error code in the error field in the CFStreamError structure should be interpreted.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CoreFoundation/CFStream.h*/

 const SInt32 kCFStreamErrorDomainNetDB;
 const SInt32 kCFStreamErrorDomainNetServices;
const SInt32 kCFstreamErrorDomainMach;
const SInt32 kCFStreamErrorDomainFTP;
 const SInt32 kCFStreamErrorDomainHTTP;
 const int kCFStreamErrorDomainSOCKS;
const  SInt32 kCFStreamErrorDomainSystemConfiguration;
 const int kCFStreamErrorDomainSSL;



/*Information Property List Keys

Standard keys found in a bundle’s information property list file. 

const CFStringRef kCFBundleInfoDictionaryVersionKey;
const CFStringRef kCFBundleExecutableKey;
const CFStringRef kCFBundleIdentifierKey;
const CFStringRef kCFBundleVersionKey;
const CFStringRef kCFBundleDevelopmentRegionKey;
const CFStringRef kCFBundleNameKey;
const CFStringRef kCFBundleLocalizationsKey;
Constants
kCFBundleInfoDictionaryVersionKey

The version of the information property list format.

Available in Mac OS X v10.0 and later.
kCFBundleExecutableKey

The name of the executable in this bundle (if any).

Available in Mac OS X v10.0 and later.
kCFBundleIdentifierKey

The bundle identifier.

Available in Mac OS X v10.0 and later.
kCFBundleVersionKey

The version number of the bundle.

For Mac OS 9 style version numbers (for example “2.5.3d5”), clients can use CFBundleGetVersionNumber instead of accessing this key directly since that function will properly convert the version string into its compact integer representation.

Available in Mac OS X v10.0 and later.
kCFBundleDevelopmentRegionKey

The name of the development language of the bundle.

When CFBundle looks for resources, the fallback is to look in the lproj whose name is given by the kCFBundleDevelopmentRegionKey in the Info.plist file. You must, therefore, ensure that a bundle contains an lproj with that exact name containing a copy of every localized resource, otherwise CFBundle cannot guarantee the fallback mechanism will work.

Available in Mac OS X v10.0 and later.
kCFBundleNameKey

The human-readable name of the bundle. 

This key is often found in the InfoPlist.strings since it is usually localized.

Available in Mac OS X v10.0 and later.
kCFBundleLocalizationsKey

Allows an unbundled application that handles localization itself to specify which localizations it has available.

Available in Mac OS X v10.2 and later.*/

 const CFStringRef kCFBundleInfoDictionaryVersionKey;
 const CFStringRef kCFBundleExecutableKey;
 const CFStringRef kCFBundleIdentifierKey;
 const CFStringRef kCFBundleVersionKey;
const CFStringRef kCFBundleDevelopmentRegionKey;
 const CFStringRef kCFBundleNameKey;
 const CFStringRef kCFBundleLocalizationsKey;


/*Predefined Callback Structures

CFArray provides some predefined callbacks for your convenience.

const CFArrayCallBacks kCFTypeArrayCallBacks;
Constants
kCFTypeArrayCallBacks

Predefined CFArrayCallBacks structure containing a set of callbacks appropriate for use when the values in a CFArray are all CFType-derived objects. The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, and the equal callback is CFEqual. Therefore, if you use this constant when creating the collection, items are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.*/
 const CFArrayCallBacks kCFTypeArrayCallBacks;

/*Predefined Callback Structures

CFDictionary provides some predefined callbacks for your convenience.

const CFDictionaryKeyCallBacks kCFCopyStringDictionaryKeyCallBacks;
const CFDictionaryKeyCallBacks kCFTypeDictionaryKeyCallBacks;
const CFDictionaryValueCallBacks kCFTypeDictionaryValueCallBacks;
Constants
kCFCopyStringDictionaryKeyCallBacks

Predefined CFDictionaryKeyCallBacks structure containing a set of callbacks appropriate for use when the keys of a CFDictionary are all CFString objects, which may be mutable and need to be copied in order to serve as constant keys for the values in the dictionary.

You typically use a pointer to this constant when creating a new dictionary.

Important: For performance reasons, the default kCFCopyStringDictionaryKeyCallBacks behavior uses CFEqual which does not normalize the strings. This means that, for example, it does not consider CFStrings to be equal when they are the same but one is in pre-composed form (say, originating from a UTF-16 text file) and the other in decomposed form (say, originating from a file name). In cases where you use strings from different sources, you may want to pre-normalize the keys or else use a different set of functions to perform the comparison.


Available in Mac OS X v10.0 and later.
kCFTypeDictionaryKeyCallBacks

Predefined CFDictionaryKeyCallBacks structure containing a set of callbacks appropriate for use when the keys of a CFDictionary are all CFType-derived objects.

The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, the equal callback is CFEqual. Therefore, if you use a pointer to this constant when creating the dictionary, keys are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.
kCFTypeDictionaryValueCallBacks

Predefined CFDictionaryValueCallBacks structure containing a set of callbacks appropriate for use when the values in a CFDictionary are all CFType-derived objects.

The retain callback is CFRetain, the release callback is CFRelease, the copy callback is CFCopyDescription, and the equal callback is CFEqual. Therefore, if you use a pointer to this constant when creating the dictionary, values are automatically retained when added to the collection, and released when removed from the collection.

Available in Mac OS X v10.0 and later.*/
const CFDictionaryKeyCallBacks kCFCopyStringDictionaryKeyCallBacks;
 const CFDictionaryKeyCallBacks kCFTypeDictionaryKeyCallBacks;
 const CFDictionaryValueCallBacks kCFTypeDictionaryValueCallBacks;



/*Boolean Values

CFBoolean evaluates to either true or false values where kCFBooleanTrue is the true, and kCFBooleanFalse is the false value. 

const CFBooleanRef kCFBooleanTrue;
const CFBooleanRef kCFBooleanFalse;
Constants
kCFBooleanTrue

Boolean true value.

Available in Mac OS X v10.0 and later.
kCFBooleanFalse

Boolean false value.

Available in Mac OS X v10.0 and later.*/
const CFBooleanRef kCFBooleanTrue;
const CFBooleanRef kCFBooleanFalse;


/*Default Run Loop Mode

Default run loop mode.

const CFStringRef kCFRunLoopDefaultMode;
Constants
kCFRunLoopDefaultMode

Run loop mode that should be used when a thread is in its default, or idle, state, waiting for an event. This mode is used when the run loop is started with CFRunLoopRun.

Available in Mac OS X v10.0 and later.*/
const CFStringRef kCFRunLoopDefaultMode;

/*Common Mode Flag

A run loop pseudo-mode that manages objects monitored in the “common” modes.

const CFStringRef kCFRunLoopCommonModes;
Constants
kCFRunLoopCommonModes

Objects added to a run loop using this value as the mode are monitored by all run loop modes that have been declared as a member of the set of “common” modes with CFRunLoopAddCommonMode.

Available in Mac OS X v10.0 and later.
Discussion

Run loops never run in this mode. This pseudo-mode is used only as a special set of sources, timers, and observers that is shared by other modes. See “Managing Objects in a Run Loop” for more details.*/
const CFStringRef kCFRunLoopCommonModes;

/*CFStringAppendCharacters

Appends a buffer of Unicode characters to the character contents of a CFMutableString object.

void CFStringAppendCharacters (
   CFMutableStringRef theString,
   const UniChar *chars,
   CFIndex numChars
);
Parameters
theString

The string to which the characters in chars are appended.
chars

A pointer to a buffer of Unicode characters. 
numChars

The number of Unicode characters in chars. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFStringAppendCharacters (
   CFMutableStringRef theString,
   const UniChar *chars,
   CFIndex numChars
){};

/*CFDataReplaceBytes

Replaces those bytes in a CFMutableData object that fall within a specified range with other bytes.

void CFDataReplaceBytes (
   CFMutableDataRef theData,
   CFRange range,
   const UInt8 *newBytes,
   CFIndex newLength
);
Parameters
theData

A CFMutableData object. If you pass an immutable CFData object, the behavior is not defined. 
range

The range of bytes (that is, the starting byte and the number of bytes from that point) to delete from theData's byte buffer. 
newBytes

A pointer to the buffer containing the replacement bytes. 
newLength

The number of bytes in the byte buffer newBytes. 
Availability
Available in Mac OS X v10.0 and later.*/
void CFDataReplaceBytes (
   CFMutableDataRef theData,
   CFRange range,
   const UInt8 *newBytes,
   CFIndex newLength
){};


/*CFDataCreateCopy

Creates an immutable copy of a CFData object.

CFDataRef CFDataCreateCopy (
   CFAllocatorRef allocator,
   CFDataRef theData
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
theData

The CFData object to copy.
Return Value

An immutable copy of theData, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

The resulting object has the same byte contents as the original object, but it is always immutable. If the specified allocator and the allocator of the original object are the same, and the string is already immutable, this function may simply increment the retain count without making a true copy. To the caller, however, the resulting object is a true immutable copy, except the operation was more efficient. 

Use this function when you need to pass a CFData object into another function by value (not reference).
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFDataCreateCopy (
   CFAllocatorRef allocator,
   CFDataRef theData
){};

/*CFDataCreateMutableCopy

Creates a CFMutableData object by copying another CFData object.

CFMutableDataRef CFDataCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFDataRef theData
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
capacity

The maximum number of bytes the object should contain. If 0, the object can grow to a size only limited by the constraints of available memory and address space. Note that initially the created CFData object still has the same length as the original object; this parameter simply specifies what the maximum size is. CFData might try to optimize its internal storage by paying attention to this value. 
theData

The CFData object to be copied. 
Return Value

A CFMutableData object that has the same contents as the original object. Returns NULL if there was a problem copying the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMutableDataRef CFDataCreateMutableCopy (
   CFAllocatorRef allocator,
   CFIndex capacity,
   CFDataRef theData
){};

/*CFArrayAppendArray

Adds the values from one array to another array.

void CFArrayAppendArray (
   CFMutableArrayRef theArray,
   CFArrayRef otherArray,
   CFRange otherRange
);
Parameters
theArray

The array to which values from otherArray are added. If theArray is a limited-capacity array, adding otherRange.length values from otherArray must not cause the capacity limit of theArray to be exceeded.
otherArray

An array providing the values to be added to theArray.
otherRange

The range within otherArray from which to add the values to theArray. The range must not exceed the index space of otherArray.
Discussion

The new values are retained by theArray using the retain callback provided when theArray was created. If the values are not of the type expected by the retain callback, the behavior is undefined. The values are assigned to the indices one larger than the previous largest index in theArray, and beyond, and the count of theArray is increased by otherRange.length. The values are assigned new indices in theArray from smallest to largest index in the order in which they appear in otherArray.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
void CFArrayAppendArray (
   CFMutableArrayRef theArray,
   CFArrayRef otherArray,
   CFRange otherRange
){};

/*CFBundleCopyLocalizedString

Returns a localized string from a bundle’s strings file.

CFStringRef CFBundleCopyLocalizedString (
   CFBundleRef bundle,
   CFStringRef key,
   CFStringRef value,
   CFStringRef tableName
);
Parameters
bundle

The bundle to examine. 
key

The key for the localized string to retrieve. This key will be used to look up the localized string in the strings file. Typically the key is identical to the value of the localized string in the development language. 
value

A default value to return if no value exists for key. 
tableName

The name of the strings file to search. The name should not include the strings filename extension. The case of the string must match that of the file name, even on file systems (such as HFS+) that are not case sensitive with regards to file names
Return Value

A CFString object that contains the localized string. If no value exists for key, returns value unless value is NULL or an empty string, in which case key is returned instead. Ownership follows the Create Rule.
Discussion

This is the base function from which the other localized string macros are derived. In general you should not use this function because the genstrings development tool only recognizes the macro version of this call when generating strings files. See CFCopyLocalizedString for details on how to use these macros. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFBundleCopyLocalizedString (
   CFBundleRef bundle,
   CFStringRef key,
   CFStringRef value,
   CFStringRef tableName
){};

/*CFStringGetCharactersPtr

Quickly obtains a pointer to the contents of a string as a buffer of Unicode characters.

const UniChar *CFStringGetCharactersPtr (
   CFStringRef theString
);
Parameters
theString

The string whose contents you wish to access. 
Return Value

A pointer to a buffer of Unicode character, or NULL if the internal storage of theString does not allow this to be returned efficiently. 
Discussion

This function either returns the requested pointer immediately, with no memory allocations and no copying, or it returns NULL. If the latter is the result, call an alternative function such as CFStringGetCharacters function to extract the characters.

Whether or not this function returns a valid pointer or NULL depends on many factors, all of which depend on how the string was created and its properties. In addition, the function result might change between different releases and on different platforms. So do not count on receiving a non-NULL result from this function under any circumstances (except when the object is created with CFStringCreateMutableWithExternalCharactersNoCopy).
Availability
Available in Mac OS X v10.0 and later.*/
const UniChar *CFStringGetCharactersPtr (
   CFStringRef theString
){};

/*CFAllocatorAllocate

Allocates memory using the specified allocator.

void *CFAllocatorAllocate (
   CFAllocatorRef allocator,
   CFIndex size,
   CFOptionFlags hint
);
Parameters
allocator

The allocator to use to allocate the memory. Pass NULL or kCFAllocatorDefault to use the current default allocator.
size

The size of the memory to allocate. 
hint

A bitfield containing flags that suggest how memory is to be allocated. 0 indicates no hints. No hints are currently defined, so only 0 should be passed for this value.
Return Value

A pointer to the newly allocated memory. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void *CFAllocatorAllocate (
   CFAllocatorRef allocator,
   CFIndex size,
   CFOptionFlags hint
){};

/*CFAllocatorDeallocate

Deallocates a block of memory with a given allocator.

void CFAllocatorDeallocate (
   CFAllocatorRef allocator,
   void *ptr
);
Parameters
allocator

The allocator that was used to allocate the block of memory pointed to by ptr. 
ptr

An untyped pointer to a block of memory to deallocate using allocator.
Discussion

If the allocator does not specify a deallocate callback function, the memory is not deallocated. 
Special Considerations

You must use the same allocator to deallocate memory as was used to allocate it.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

void CFAllocatorDeallocate (
   CFAllocatorRef allocator,
   void *ptr
){};




















































































