#define C_LANG

#ifndef CARBONCORE_H
#include <CarbonCore/CarbonCore.h>
#endif
















/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount){
//TODO
};


/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h){
//TODO
};


/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (
   Handle h){
//TODO
};


/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum){
//TODO
};

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount){
//TODO
};

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum){
//TODO
};

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef){
//TODO
};


/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (
   Size byteCount){
//TODO
};

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission){
//TODO
};

/*CloseResFile

Closes a resource fork before your application terminates.

void CloseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork to close. If this parameter does not contain a file reference number for a file whose resource fork is open, the function does nothing, and the ResError function returns the result code resFNotFound. If the value of this parameter is 0, it represents the System file and is ignored. You cannot close the System file’s resource fork. 
Discussion

This function performs four tasks. First, it updates the file by calling the UpdateResFile function. Second, it releases the memory occupied by each resource in the resource fork by calling the DisposeHandle function. Third, it releases the memory occupied by the resource map. The fourth task is to close the resource fork.

When your application terminates, the Resource Manager automatically closes every resource fork open to your application except the System file’s resource fork. You need to call this function only if you want to close a resource fork before your application terminates.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void CloseResFile (
   short refNum){
//TODO
};

/*Get1IndResource

Returns a handle to a resource of a given type in the current resource file.

Handle Get1IndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type.
index

An integer ranging from 1 to the number of resources of a given type returned by the Count1Resources function, which is the number of resources of that type in the current resource file.
Return Value

A handle to a resource of the given type. If you call Get1IndResource repeatedly over the entire range of the index, it returns handles to all resources of the given type in the current resource file. If you provide an index that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by Count1Resources, Get1IndResource returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code.
Discussion

The function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE. If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, Get1IndResource returns an empty handle (that is, a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the Get1IndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1IndResource (
   ResType theType,
   short index){
//TODO
};

/*DetachResource

Sets the value of a resource’s handle in the resource map in memory to NULL while keeping the resource data in memory.

void DetachResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If this parameter doesn’t contain a handle to a resource or if the resource’s resChanged attribute is set, the function does nothing. To determine whether either of these errors occurred, call the ResError function. 
Discussion

After this call, the Resource Manager no longer recognizes the handle as a handle to a resource. However, this function does not release the memory used for the resource data, and the master pointer is still valid. Thus, you can access the resource data directly by using the handle.

If your application subsequently calls a Resource Manager function to get the released resource, the Resource Manager assigns a new handle.You can use DetachResource if you want to access the resource data directly without using Resource Manager functions. You can also use the DetachResource function to keep resource data in memory after closing a resource fork.

To copy a resource and install an entry for the duplicate in the resource map, call DetachResource, then call the AddResource function using a different resource ID. 
Special Considerations

Do not use this function to detach a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void DetachResource (
   Handle theResource){
//TODO
};


/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/


OSErr CloseComponent (
   ComponentInstance aComponentInstance){
//TODO
};


/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType){
//TODO
};


/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (
   OSType selector,
   long * response){
//TODO
};

/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator){
//TODO
};

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names){
//TODO
};

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef){
//TODO
};

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator){
//TODO
};

/*GetDateTime

Obtains the current date-time information, expressed as the number of seconds elapsed since midnight, January 1, 1904. (Deprecated in Mac OS X v10.4. Use CFAbsoluteTimeGetCurrent instead.)

void GetDateTime (
   unsigned long * secs
);
Parameters
secs

On return, the number of seconds elapsed since midnight, January 1, 1904. 
Discussion

The low-memory copy of the date and time information is also accessible through the global variable Time.

If an application disables interrupts for longer than a second, the date-time information returned by the GetDateTime function might not be exact. The GetDateTime function is intended to provide fairly accurate time information, but not scientifically precise data. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void GetDateTime (
   unsigned long * secs){
//TODO
};

/*SecondsToDate

Converts a number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);
Parameters
secs

The number of seconds elapsed since midnight, January 1, 1904. 
d

On return, the fields of the date-time structure that contain the date and time corresponding to the value indicated in the s parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d){
//TODO
};


/*OpenADefaultComponent


OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);
Parameters
componentType
componentSubType
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci){
//TODO
};

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory){
//TODO
};

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory){
//TODO
};


/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock){
//TODO
};

/*OpenComponent

Opens a connection to the component with the component identifier specified by your application.

ComponentInstance OpenComponent (
   Component aComponent
);
Parameters
aComponent

The component you wish to open. Your application obtains this identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent function or the RegisterComponentResource function. 
Return Value

A component instance which identifies your application’s connection to the component. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If it cannot open the specified component, the function returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. To use this function, you must already have obtained a component identifier. Alternatively, you can use the OpenDefaultComponent function to open a component without calling FindNextComponent. 

Note that your application may maintain several connections to a single component, or it may have connections to several components at the same time. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

ComponentInstance OpenComponent (
   Component aComponent){
//TODO
};


/*FindNextComponent

Returns the component identifier for the next registered component that meets the selection criteria specified by your application. 

Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);
Parameters
aComponent

The starting point for the search. Set this field to 0 to start the search at the beginning of the component list. If you are continuing a search, you can specify a component identifier previously returned by this function. The function then searches the remaining components. 
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, all components meet the search criteria. In this case, your application can retrieve information about all of the components that are registered in the system by repeatedly calling FindNextComponent and GetComponentInfo until the search is complete. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager searches all registered components for a component supplied by the manufacturer you specify. Note that this function does not modify the contents of the component description structure you supply. To retrieve detailed information about a component, you need to use the GetComponentInfo function to get the component description structure for each returned component.

Return Value

The component identifier of a component that meets the search criteria or 0 when there are no more matching components. Your application can use the component identifier returned by this function to get more information about the component, using GetComponentInfo, or to open the component, using either the OpenDefaultComponent function or the OpenComponent function. See the description of the Component data type.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking){
//TODO
};
/*GetComponentInfo

Returns to your application the registration information for a component. 

OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
aComponent

The component about which you wish to obtain information. Your application obtains a component identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent or RegisterComponentResource function.

You may supply a component instance rather than a component identifier to this function, but you must coerce the data type appropriately. Your application can obtain a component instance from the OpenComponent or OpenDefaultComponent functions.

cd

A pointer to a ComponentDescription structure. The function returns information about the specified component in this structure. 
componentName

On return, a handle to the component’s name. If the component does not have a name, an empty handle. Set this field to NULL if you do not want to receive the component’s name. 
componentInfo

On return, a handle to the component’s information string. If the component does not have an information string, an empty handle. Set this field to NULL if you do not want to receive the component’s information string.
componentIcon

On return, a handle to the component’s icon. If the component does not have an icon, an empty handle. Set this field to NULL if you do not want to receive the component’s icon. To get a handle to the component’s icon suite, if it provides one, use the GetComponentIconSuite function.
Return Value

A result code. See “Component Manager Result Codes”.
Discussion

For information on registering components, see “Registering Components”. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon){
//TODO
};


/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec){
//TODO
};

/*BlockMove

Copies a sequence of bytes from one location in memory to another.

void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr

The address of the first byte to copy. 
destPtr

The destination address.
byteCount

The number of bytes to copy. If the value of byteCount is 0, BlockMove does nothing. 
Discussion

The BlockMove function copies the specified number of bytes from the address designated by srcPtr to that designated by destPtr. It updates no pointers.

The BlockMove function works correctly even if the source and destination blocks overlap.

You can safely call BlockMove at interrupt time. Even though it moves memory, BlockMove does not move relocatable blocks, but simply copies bytes.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

The BlockMove function currently flushes the processor caches whenever it moves more than 12 bytes. This behavior can adversely affect your application’s performance. You might want to avoid calling BlockMove to move small amounts of data in memory if there is no possibility of moving stale data or instructions. For more information about stale data and instructions, see the discussion of the processor caches in the chapter “Memory Management Utilities” in Inside Macintosh: Memory. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMove function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount){
//TODO
};


/*BlockMoveData


void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr
destPtr
byteCount
Discussion

You should not make any assumptions about the state of the destination memory while BlockMoveData is executing. In the intermediate state, values may be present that are neither the original nor the final ones. For example, this function may use the 'dcbz' instruction. If the underlying memory is not cacheable, if the memory is write-through instead of copy-back, or if the cache block is flushed for some reason, the 'dcbz' instruction will write zeros to the destination. You can avoid the use of the 'dcbz' instruction by calling BlockMoveDataUncached, but even that function makes no other guarantees about the memory block's intermediate state. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMoveData function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount){
//TODO
};


/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock){
//TODO
};


/*Munger

Searches text for a specified string pattern and replaces it with another string.

long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2
);
Parameters
h

A handle to the text string that is being manipulated. 
offset

The byte offset in the destination string at which Munger begins its operation. 
ptr1

A pointer to the first character in the string for which Munger is searching. 
len1

The number of bytes in the string for which Munger is searching.
ptr2

A pointer to the first character in the substitution string.
len2

The number of bytes in the substitution string.
Return Value

A negative value if Munger cannot find the designated string. 
Discussion

Munger manipulates bytes in a string to which you specify a handle in the h parameter. The manipulation begins at a byte offset, specified in offset, in the string. Munger searches for the string specified by ptr1 and len1; when it finds an instance of that string, it replaces it with the substitution string, which is specified by ptr2 and len2.

Munger operates on a byte-by-byte basis, which can produce inappropriate results for 2-byte script systems. The ReplaceText function works properly for all languages. You are encouraged to use ReplaceText instead of Munger whenever possible.

Munger takes special action if either of the specified pointer values is NULL or if either of the length values is 0.
If ptr1 is NULL, Munger replaces characters without searching. It replaces len1 characters starting at the offset location with the substitution string. 
If ptr1 is NULL and len1 is negative, Munger replaces all of the characters from the offset location to the end of the string with the substitution string. 
If len1 is 0, Munger inserts the substitution string without replacing anything. Munger inserts the string at the offset location and returns the offset of the first byte past where the insertion occurred. 
If ptr2 is NULL, Munger searches but does not replace. In this case, Munger returns the offset at which the string was found. 
If len2 is 0 and ptr2 is not NULL, Munger searches and deletes. In this case, Munger returns the offset at which it deleted. 
If the portion of the string from the offset location to its end matches the beginning of the string that Munger is searching for, Munger replaces that portion with the substitution string. 

Be careful not to specify an offset with a value that is greater than the length of the destination string. Unpredictable results may occur.

Munger calls the GetHandleSize and SetHandleSize functions to access or modify the length of the string it is manipulating. 
Special Considerations

Munger may move memory; your application should not call this function at interrupt time.

The destination string must be in a relocatable block that was allocated by the Memory Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
TextUtils.h*/
long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2){
//TODO
};


/*MemError

Determines if an application’s last direct call to a Memory Manager function executed successfully.

OSErr MemError (void);
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

For each thread, MemError yields the result code produced by the last Memory Manager function your application called directly.

MemError is useful during application debugging. You might also use MemError as one part of a memory-management scheme to identify instances in which the Memory Manager rejects overly large memory requests by returning the error code memFullErr.

To view the result codes that MemError can produce, see “Memory Manager Result Codes”.

Do not rely on MemError as the only component of a memory-management scheme. For example, suppose you call NewHandle or NewPtr and receive the result code noErr, indicating that the Memory Manager was able to allocate sufficient memory. In this case, you have no guarantee that the allocation did not deplete your application’s memory reserves to levels so low that simple operations might cause your application to crash. Instead of relying on MemError, check before making a memory request that there is enough memory both to fulfill the request and to support essential operations. 
Version Notes

Starting with Mac OS X v10.3, the MemError function provides error codes on a per-thread basis.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr MemError (void){
//TODO
};


/*NewAliasMinimalFromFullPath

Creates an alias record that contains only the full pathname of the target. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.)

Not recommended

OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
);
Parameters
fullPathLength

The number of characters in the full pathname of the target.
fullPath

A pointer to a buffer that contains the full pathname of the target. The full pathname starts with the name of the volume, includes all of the directory names in the path to the target, and ends with the target name. (For a description of pathnames, see the documentation for the File Manager.)
zoneName

The AppleTalk zone name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
serverName

The AppleTalk server name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimalFromFullPath function creates an alias record that identifies the target by full pathname. You can call NewAliasMinimalFromFullPath to create an alias record for a file that doesn’t exist or that resides on an unmounted volume.

The NewAliasMinimalFromFullPath function uses the standard alias record data structure, but it fills in only the information provided in the input parameters. You can therefore use NewAliasMinimalFromFullPath to create alias records for targets on unmounted volumes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.
Declared In
Aliases.h*/
OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias){
//TODO
};

/*ResolveAlias

Identifies the single most likely target of an alias record. (Deprecated in Mac OS X v10.4. Use FSResolveAlias instead.)

Not recommended

OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you pass a fromFile parameter of NULL, ResolveAlias performs only an absolute search. If you pass a pointer to a valid FSSpec structure in the fromFile parameter, ResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the MatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to the target of the alias record. This parameter must be a valid FSSpec structure.
wasChanged

A pointer to a Boolean value indicating whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, ResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (ResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The ResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, ResolveAlias returns (in the target parameter) the FSSpec structure for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, ResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, ResolveAlias asks the user to insert the volume. The ResolveAlias function exits after it finds one acceptable target.

After it identifies a target, ResolveAlias compares some key information about the target with the information in the alias record. (The description of the MatchAlias function lists the key information.) If the information differs, ResolveAlias updates the record to match the target.

When it finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAlias returns a result code of fnfErr and fills in the target parameter with a complete FSSpec structure describing the target (that is, the volume reference number, parent directory ID, and filename or folder name). The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, pass the FSSpec structure to the File Manager function FSpCreate to create a replacement for a missing file.

The ResolveAlias function displays the standard dialog boxes when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialog boxes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAlias instead.
Declared In
Aliases.h*/
OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged){
//TODO
};



/*NewHandleClear

Allocates a relocatable block of memory of a specified size with all its bytes set to 0.

Handle NewHandleClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the relocatable block. The NewHandleClear function sets each of these bytes to 0. 
Return Value

A handle to the new block. If NewHandleClear cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandleClear function works like the NewHandle function, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandleClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandleClear (
   Size byteCount){
//TODO
};


/*PtrToHand

Copies data referenced by a pointer to a new relocatable block.

OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);
Parameters
srcPtr

The address of the first byte to copy. 
dstHndl

A handle for which you have not yet allocated any memory. The PtrToHand function allocates memory for the handle and copies the specified number of bytes beginning at srcPtr into it. The dstHndl parameter is an output parameter that will hold the result. Its value on entry is ignored. If no error occurs, on exit it points to an unlocked, non-purgeable Handle of the requested size. 
size

The number of bytes to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

If you dereference and lock a handle, the PtrToHand function can copy its data to a new handle. However, for copying data from one handle to another, the HandToHand function is more efficient.

Because PtrToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size){
//TODO
};


/*MPCreateSemaphore

Creates a semaphore.

OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore
);
Parameters
maximumValue

The maximum allowed value of the semaphore. 
initialValue

The initial value of the semaphore.
semaphore

On return, semaphore contains the ID of the newly–created semaphore. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If you want to create a binary semaphore, you can call the macro MPCreateBinarySemaphore (MPSemaphoreID *semaphore) instead, which simply calls MPCreateSemaphore with both maximumValue and initialValue set to 1.

Also see the function MPDeleteSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore){
//TODO
};


/*Byte Operations

The Driver Services Library provides several 32-, 16-, and 8-bit atomic memory operations for use by device drivers. These routines take logical address pointers and ensure that the operations are atomic with respect to all devices (for example, other processors and DMA engines) that participate in the coherency architecture of the Power Macintosh system.

IMPORTANT

Memory locations used by these operations must be long word aligned; if they are stored in a structure, you should use the compiler directive #pragma options align=power. 
Boolean
CompareAndSwap (long oldValue, long newValue, long *Value); 

SInt32      IncrementAtomic     (SInt32 *value);
SInt32      DecrementAtomic     (SInt32 *value); 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value); 

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value);
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value);
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value); 

SInt16      IncrementAtomic16   (SInt16 *value);
SInt16      DecrementAtomic16   (SInt16 *value);
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value);
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value);
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value);
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value); 

SInt8       IncrementAtomic8    (SInt8 *value);
SInt8       DecrementAtomic8    (SInt8 *value);
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value);
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value);
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value);
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value); 
DESCRIPTION

The atomic routines perform various operations on the memory address specified by value : 
The CompareAndSwap routine compares the value at the specified address with oldValue. The value of newValue is written to the specified address only if oldValue and the value at the specified address are equal. CompareAndSwap returns true if newValue is written to the specified address; otherwise, it returns false. A false return value does not imply that oldValue and the value at the specified address are not equal; it only implies that CompareAndSwap did not write newValue to the specified address.
IncrementAtomic increments the value by 1 and DecrementAtomic decrements it by 1. These functions return the value as it was before the change.
AddAtomic adds the specified amount to the value at the specified address and returns the result. 
BitAndAtomic performs a logical and operation between the bits of the specified mask and the value at the specified address, returning the result. Similarly, BitOrAtomic performs a logical OR operation and BitXorAtomic performs a logical XOR operation.
EXECUTION CONTEXT

The atomic operation routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean CompareAndSwap (long oldValue, long newValue, long *Value){};

SInt32      IncrementAtomic     (SInt32 *value){};
SInt32      DecrementAtomic     (SInt32 *value){}; 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value){};

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value){};
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value){};
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value){};
SInt16      IncrementAtomic16   (SInt16 *value){};
SInt16      DecrementAtomic16   (SInt16 *value){};
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value){};
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value){};
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value){};
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value){};
SInt8       IncrementAtomic8    (SInt8 *value){};
SInt8       DecrementAtomic8    (SInt8 *value){};
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value){};
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value){};
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value){};
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value){};


/*MPSignalSemaphore

Signals a semaphore. 

OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to signal. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the value of the semaphore was already at the maximum, MPSignalSemaphore returns kInsufficientResourcesErr.
Discussion

If tasks are waiting on the semaphore, the oldest (first queued) task is unblocked so that the corresponding MPWaitOnSemaphore call for that task completes. Otherwise, if the value of the semaphore is not already equal to its maximum value, it is incremented by one.

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore){
//TODO
};


/*Dequeue

Removes a queue element directly from an operating-system queue or from a queue that you have created.

OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to a queue element to remove from a queue. 
qHeader

A pointer to a queue header. 
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Discussion

The Dequeue function attempts to find the queue element specified by the qElement parameter in the queue specified by the qHeader parameter. If Dequeue finds the element, it removes the element from the queue, adjusts the other elements in the queue accordingly, and returns noErr. Otherwise, it returns qErr, indicating that it could not find the element in the queue. The Dequeue function does not deallocate the memory occupied by the queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

The Dequeue function disables interrupts as it searches through the queue for the element to be removed. The time during which interrupts are disabled depends on the length of the queue and the position of the entry in the queue. The Dequeue function can be called at interrupt time. However, the Dequeue function is ordinarily used only by system software and, whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose removal functions. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Dequeue:
SlotVRemove

Removes a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VRemove

Removes a system-based VBL task. This function is available with the Vertical Retrace Manager.
WaitNextEvent

Removes an Event. This function is available with the Event manager.
SIntRemove

Removes a slot interrupt task. This function is available with the Slot Manager.
NMRemove

Removes a Notification request. This function is available with the Notification Manager.
SleepQRemove

Removes a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader){
//TODO
};


/*Enqueue

Adds elements directly to an operating-system queue or a queue that you create.

void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to the queue element to add to a queue. 
qHeader

A pointer to a queue header. 
Discussion

The Enqueue function adds the queue element specified by the qElement parameter to the end of the queue specified by the qHeader parameter. The specified queue header is updated to reflect the new queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

Because interrupt functions are likely to manipulate operating-system queues, interrupts are disabled for a short time while the specified queue is updated. You can call the Enqueue function at interrupt time. However, the Enqueue function is ordinarily used only by system software. Whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose functions whenever possible, instead of the Enqueue function. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Enqueue:
SlotVInstall

Installs a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VInstall

Installs a system-based VBL task. This function is available with the Vertical Retrace Manager.
AddDrive

Adds a disk drive. This function is available with the Device Manager.
PPostEvent and PostEvent

Installs an Event. This function is available with the Event manager.
DTInstall

Installs a deferred task. This function is available with the Memory Management Utilities.
SIntInstall

Installs a slot interrupt task. This function is available with the Slot Manager.
NMInstall

Installs a Notification request. This function is available with the Notification Manager.
SleepQInstall

Installs a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader){
//TODO
};


/*Bit Operations
Boolean TestAndSet(
                     UInt32 bit
                     UInt8 *startAddress); Boolean TestAndClear(
                     UInt32 bit
                     UInt8 *startAddress); 
--> bit 
The bit number in the range 0 through 7.
--> startAddress 
The address of the byte in which the bit is located.
DESCRIPTION

TestAndSet sets and TestAndClear clears a single bit in a byte at a specified address. They return true if the bit was already set or cleared respectively and false otherwise.
EXECUTION CONTEXT

TestAndSet and TestAndClear may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean TestAndSet(
                     UInt32 bit,
                     UInt8 *startAddress){}; 
Boolean TestAndClear(
                     UInt32 bit,
                     UInt8 *startAddress){}; 
/*MPWaitOnSemaphore

Waits on a semaphore

OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout
);
Parameters
semaphore

The ID of the semaphore you want to wait on. 
timeout

The maximum time the function should wait before timing out. See Timer Duration Constants for a list of constants you can use to specify the wait interval. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If the value of the semaphore is greater than zero, the value is decremented and the function returns with noErr. Otherwise, the task is blocked awaiting a signal until the specified timeout is exceeded.

If you call this function from a cooperative task, you should specify only kDurationImmediate for the timeout length; other waits will cause the task to block. 

Also see the function MPSignalSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout){
//TODO
};


/*MPDeleteSemaphore

Removes a semaphore. 

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to remove. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

Calling this function unblocks all tasks waiting on the semaphore and the tasks’ respective MPWaitOnSemaphore calls will return with the result code kMPDeletedErr.

Also see the function MPCreateSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore){
//TODO
};

/*Microseconds

Determines the number of microseconds that have elapsed since system startup time.

void Microseconds (
   UnsignedWide * microTickCount
);
Parameters
microTickCount

The number of microseconds elapsed since system startup.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Timer.h*/
void Microseconds (
   UnsignedWide * microTickCount){
//TODO
};



/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum){
//TODO
};

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF){
//TODO
};

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr){
//TODO
};

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum){
//TODO
};

/*PtrAndHand

Concatenates part or all of a memory block to the end of a relocatable block.

OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);
Parameters
ptr1

A pointer to the beginning of the data that the Memory Manager is to concatenate onto the end of the relocatable block. 
hand2

A handle to the relocatable block, whose size the Memory Manager expands so that it can concatenate the information from ptr1 onto the end of this block. 
size

The number of bytes of the block referenced by ptr1 to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The PtrAndHand function takes the number of bytes specified by the size parameter, beginning at the location specified by ptr1, and concatenates them onto the end of the relocatable block to which hand2 is a handle. The contents of the source block remain unchanged.

Because PtrAndHand allocates memory, you should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size){
//TODO
};

/*HLock

Prevents a relocatable block from moving within its heap zone.

void HLock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

If you plan to dereference a handle and then allocate, move, or purge memory (or call a function that does so), then you should lock the handle before using the dereferenced handle.

If the block is already locked, HLock does nothing.

If you plan to lock a relocatable block for long periods of time, you can prevent fragmentation by ensuring that the block is as low as possible in the heap zone. To do this, see the description of the ReserveMem function.

If you plan to lock a relocatable block for short periods of time, you can prevent heap fragmentation by moving the block to the top of the heap zone before locking. For more information, see the description of the MoveHHi function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void HLock (Handle h){
//TODO
};

/*OpenAComponent


OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci
);
Parameters
aComponent
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci){
//TODO
};

/*NumToString

Converts a long integer value into a Pascal string. (Deprecated in Mac OS X v10.4. Use CFStringCreateWithFormat instead.)

void NumToString (
   long theNum,
   Str255 theString
);
Parameters
theNum

A long integer value. If the value of the number in the parameter theNum is negative, the string begins with a minus sign; otherwise, the sign is omitted. 
theString

On output, contains the Pascal string representation of the number. Leading zeros are suppressed, except that a value of 0 produces the string “0”. NumToString does not include thousand separators or decimal points in its formatted output. 
Discussion

NumToString creates a string representation of theNum as a base-10 value and returns the result in theString.

Unless patched by a script system with different rules, this function assumes that you are using standard numeric token processing, meaning that the Roman script system number processing rules are used.

For functions that make use of the token-processing information that is found in the tokens ('itl4') resource of script systems for converting numbers, see the sections “Using Number Format Specification Strings for International Number Formatting” and “Converting Between Strings and Floating-Point Numbers”. 
Special Considerations

NumToString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
void NumToString (
   long theNum,
   Str255 theString){
//TODO
};


/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef){
//TODO
};

/*X2Fix

Converts an Extended number to a Fixed number.

Fixed X2Fix (
   double x
);
Parameters
x

The Extended number to be converted to a Fixed number. 
Return Value

The best Fixed approximation of the Extended number x. If x is greater than the maximum representable Fixed number, the X2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, X2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed X2Fix (
   double x){
//TODO
};

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize){
//TODO
};

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName){
//TODO
};


/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize){
//TODO
};

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter){
//TODO
};

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock){
//TODO
};


/*Fix2X

Converts a Fixed number to an Extended number.

double Fix2X (
   Fixed x
);
Parameters
x

The Fixed number to be converted to an Extended number. 
Return Value

The Extended equivalent of the Fixed number x. 
Special Considerations

Fix2X does not move memory; you can call it at interrupt time.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
double Fix2X (
   Fixed x){};


/*DisposePtr

Releases memory occupied by a nonrelocatable block.

void DisposePtr (
   Ptr p
);
Parameters
p

A pointer to the nonrelocatable block you want to dispose of. 
Discussion

When you no longer need a nonrelocatable block, call the DisposePtr function to free it for other uses.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

After a call to DisposePtr, all pointers to the released block become invalid and should not be used again. Any subsequent use of a pointer to the released block might cause a system error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposePtr (
   Ptr p
){};


/*NewPtrClear

Allocates a nonrelocatable block of memory of a specified size with all its bytes set to 0.

Ptr NewPtrClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the nonrelocatable block. 
Return Value

A pointer to the new block. If NewPtrClear fails to allocate a block of the requested size, it returns NULL. 
Discussion

The NewPtrClear function works much as the NewPtr function does, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewPtrClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Ptr NewPtrClear (
   Size byteCount
){};


/*FSResolveAlias

Returns an FSRef to the single most likely target of an alias record.

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to an FSRef specifying the starting point for a relative search. If you pass NULL in this parameter, FSResolveAlias performs only an absolute search. If you pass a pointer to a valid FSRef in the fromFile parameter, FSResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the FSMatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to an FSRef. On successful return, this FSRef describes the target of the alias record. This parameter must point to a valid FSRef structure.
wasChanged

A pointer to a Boolean value indicating, on return, whether the alias record in the alias parameter was updated because it contained some outdated information about the target. If it updates the alias record, FSResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (FSResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. When it finds the specified volume and parent directory but fails to find the target file or directory in that location, FSResolveAlias returns fnfErr. Note that the FSRef in the alias parameter is not valid in this case.
Discussion

The FSResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, FSResolveAlias returns (in the target parameter) the FSRef for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, FSResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, FSResolveAlias asks the user to insert the volume. The FSResolveAlias function exits after it finds one acceptable target.

After it identifies a target, FSResolveAlias compares some key information about the target with the information in the alias record. If the information differs, FSResolveAlias updates the record to match the target.

The FSResolveAlias function displays the standard dialogs when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialogs. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
){};


/*FSNewAlias

Creates a new alias record, given a file system reference (FSRef) to the target file or directory.

OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
);
Parameters
fromFile

A pointer to a file system reference specifying the starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the structure, pass a fromFile value of NULL. If you want FSNewAlias to record relative path information, pass a pointer to a valid FSRef in this parameter. The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
target

A pointer to an FSRef for the target of the alias record.
inAlias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets inAlias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The FSNewAlias function creates an alias record that describes the specified target. It allocates the storage, fills in the record, and puts a record handle to that storage in the inAlias parameter. FSNewAlias records the full pathname of the target and a collection of other information relevant to locating the target, verifying the target, and mounting the target’s volume, if necessary. You can have FSNewAlias store relative path information as well by supplying a starting point for a relative path. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
){};

/*FSIsAliasFile

Determines whether a file system object is an alias file, a data file, or a folder.

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
);
Parameters
fileRef

A pointer to a file system object. 
aliasFileFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is an alias file. A value of FALSE indicates that the object is not an alias file. 
folderFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is a folder. A value of FALSE indicates that the object is a file. 
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

Table 1 summarizes the information that this function provides about the object specified in the fileRef parameter: 
Table 1  Information about a file system object
Alias flag	
Folder flag	
Object kind 

T	
F	
Alias file

F	
F	
Data file

F	
T	
Folder


Note that if fileRef is an alias file, this function does not provide any information about the object to which the alias refers. To find out whether this object is a file or a folder, you can use FSResolveAliasFile.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
){};


/*Creates a new file with a Unicode name. 

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);
Parameters
parentRef

A pointer to an FSRef for the directory where the file is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the file's name. 
name

A pointer to the Unicode name for the new file. 
whichInfo

A bitmap specifying which catalog information fields to set for the new file. You specify the values for these fields in the catalogInfo parameter. If you do not wish to set catalog information for the new file, pass the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values of the new file’s catalog information. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new file.

newRef

On return, a pointer to the FSRef for the new file. If you do not want the FSRef returned, specify NULL.
newSpec

On return, a pointer to the FSSpec for the new file. If you do not want the FSSpec returned, specify NULL. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new file using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the file. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateFileUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBHCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode filenames, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
){};

/*FSSetCatalogInfo

Sets catalog information about a file or directory.

OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);
Parameters
ref

A pointer to an FSRef specifying the file or directory whose information is to be changed. See FSRef for a description of the FSRef data type.
whichInfo

A bitmap specifying which catalog information fields to set. Only some of the catalog information fields may be set. These fields are given by the constant kFSCatInfoSettableInfo; no other bits may be set in the whichInfo parameter. See Catalog Information Bitmap Constants for a description of the bits in this parameter.

To set the user ID (UID) and group ID (GID) on Mac OS X, specify the kFSCatInfoSetOwnership flag in this parameter. The File Manager attempts to set the user and group ID to the values specified in the permissions field of the catalog information structure. If FSSetCatalogInfo cannot set the user and group IDs, it returns an error.
catalogInfo

A pointer to the structure containing the new catalog information. Only some of the catalog information fields may be set. The fields which may be set are:
createDate
contentModDate
attributeModDate
accessDate
backupDate
permissions
finderInfo
extFinderInfo
textEncodingHint

On Mac OS 9, you may also set the kFSNodeLockedBit bit in the nodeFlags field if you are changing catalog information for a file.

Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
){};

/*FSDeleteObject

Deletes a file or an empty directory. 

OSErr FSDeleteObject (
   const FSRef * ref
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to be deleted. If the object to be deleted is a directory, it must be empty (it must contain no files or folders). See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”. On Mac OS 8 and 9, if you attempt to delete a folder for which there is an open catalog iterator, FSDeleteObject returns the error fBsyErr. On Mac OS X, a similar attempt to delete a folder while another process has an open iterator will succeed and FSDeleteObject returns noErr. Iteration, however, will continue to work until the iterator is closed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSDeleteObject (
   const FSRef * ref
){};


/*Get1Resource

Gets resource data for a resource in the current resource file.

Handle Get1Resource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data.
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds an entry for the resource in the current resource file’s resource map and the entry contains a valid handle, it returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, Get1Resource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and ResError returns the result code resNotFound. The Get1Resource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code.

If you call this function with a resource type that can’t be found in the resource map of the current resource file, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the current resource file’s resource map in memory for the specified resource.

You can change the resource map search order by calling the UseResFile function before Get1Resource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps for open resource forks, use the RGetResource function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1Resource (
   ResType theType,
   short theID
){};


/*ResError

Determines what error occurred, if any, after calling a Resource Manager function. 

OSErr ResError ();
Return Value

A result code. See “Resource Manager Result Codes”. If no error occurred, the function returns noErr. If an error occurs at the Resource Manager level, the function returns one of the result codes specific to the Resource Manager. If an error occurs at the Operating System level, the function returns an Operating System result code. In certain cases, the ResError function returns noErr even though a Resource Manager function was unable to perform the requested operation. See the individual function descriptions for details about the circumstances under which this happens.
Discussion

Resource Manager functions do not report error information directly. Instead, after calling a Resource Manager function, your application should call this function to determine whether an error occurred. You also can use this function to check for an error after application startup (system software opens the resource fork of your application during application startup).

Resource Manager functions usually return NULL or –1 as the function result when there’s an error. For Resource Manager functions that return –1, your application can call the ResError function to determine the specific error that occurred. For Resource Manager functions that return handles, your application should always check whether the value of the returned handle is NULL. If it is, your application can use this function to obtain specific information about the nature of the error. Note, however, that in some cases ResError returns noErr even though the value of the returned handle is NULL.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
OSErr ResError (){};

/*HUnlock

Allows a relocatable block to move in its heap zone.

void HUnlock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HUnlock function unlocks the relocatable block to which h is a handle, allowing the block to move within its heap zone. If the block is already unlocked, HUnlock does nothing.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HUnlock (
   Handle h
){};


/*SetComponentInstanceStorage

Allows your component to associate memory with a connection. 

void SetComponentInstanceStorage (
   ComponentInstance aComponentInstance,
   Handle theStorage
);
Parameters
aComponentInstance

The connection to associate with the allocated memory. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
theStorage

A handle to the memory that your component has allocated for the connection. Your component must allocate this memory in the current heap. The Component Manager saves this handle and provides it to your component, along with other parameters, in subsequent requests to this connection. 
Discussion

When an application or component opens a connection to your component, the Component Manager sends your component an open request. In response to this open request, your component should set up an environment to service the connection. Typically, your component should allocate some memory for the connection. Your component can then use that memory to maintain state information appropriate to the connection.

Your component should dispose of any allocated memory for the connection only in response to the close request. Note that whenever an open request fails, the Component Manager always issues the close request. Furthermore, the value stored with this function is always passed to the close request, so it must be valid or NULL. If the open request tries to dispose of its allocated memory before returning, it should call this function again with a NULL handle to keep the Component Manager from passing an invalid handle to the close request. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
void SetComponentInstanceStorage (
   ComponentInstance aComponentInstance,
   Handle theStorage
){};





/*ComponentSetTarget

Calls a component’s target request function and informs a component that it has been targeted by another component. 

long ComponentSetTarget (
   ComponentInstance ci,
   ComponentInstance target
);
Parameters
ci

The component instance to which to send a target request (the component that has been targeted). You can use a component identifier here, but you must coerce the data type appropriately. 
target

The component instance issuing the target request.
Return Value

The value that the targeted component instance returns in response to the target request, or badComponentSelector if the targeted component does not support the target request. 
Discussion

Your component can target a component instance without capturing the component or your component can first capture the component and then target a specific instance of the component. 

You should not target a component instance if the component does not support the target request. Before calling this function, you should issue a can do request to the component instance you want to target to verify that the component supports the target request. After receiving a target request, the targeted component instance should call the component instance that targeted it whenever the targeted component instance would normally call one of its defined functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long ComponentSetTarget (
   ComponentInstance ci,
   ComponentInstance target
){};


/*RegisterComponent

Registers a component stored in memory.

Component RegisterComponent (
   ComponentDescription * cd,
   ComponentRoutineUPP componentEntryPoint,
   short global,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
cd

A pointer to a ComponentDescription structure that describes the component to be registered. You must correctly fill in the fields of this structure before calling this function. When applications search for components using the FindNextComponent function, the Component Manager compares the attributes you specify here with those specified by the application. If the attributes match, the Component Manager returns the component identifier to the application. 
componentEntryPoint

A universal procedure pointer (UPP) to your component’s main entry point. The function referred to by this parameter receives all requests for the component. See the ComponentRoutineProcPtr callback for more information on creating a component function. 
global

A set of flags that control the scope of component registration. See “Register Component Resource flags” for a description of the flags. 
componentName

A handle to the component’s name. Set this parameter to NULL if you do not want to assign a name to the component. 
componentInfo

A handle to the component’s information string. Set this parameter to NULL if you do not want to assign an information string to the component.
componentIcon

A handle to the component’s icon (a 32-by-32 pixel black-and-white icon). Set this parameter to NULL if you do not want to supply an icon for this component. Note that this icon is not used by the Finder you supply an icon only so that other components or applications can display your component’s icon if needed.
Return Value

The unique component identifier assigned to the component by the Component Manager or, if it cannot register the component, NULL. See the description of the Component data type.
Discussion

Before a component can be used by an application, the component must be registered with the Component Manager. Applications can then find and open the component using the standard Component Manager functions. 

Components you register with the RegisterComponent function must be in memory when you call this function. If you want to register a component that is stored in the resource fork of a file, use the RegisterComponentResource function. Use the RegisterComponentResourceFile function to register all components in the resource fork of a file. The Component Manager automatically registers component resources stored in files with file types of 'thng' that are stored in the Extensions folder. See “Resources” for more information on component resource files.

Note that a component residing in your application heap remains registered until your application unregisters it or quits. When an application quits, the Component Manager automatically closes any component connections to that application. In addition, if the application has registered components that reside in its heap space, the Component Manager automatically unregisters those components. A component residing in the system heap and registered by your application remains registered until your application unregisters it or until the computer is shut down. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component RegisterComponent (
   ComponentDescription * cd,
   ComponentRoutineUPP componentEntryPoint,
   short global,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
){};


/*NewComponentRoutineUPP

Creates a new universal procedure pointer (UPP) to a component routine callback function.

ComponentRoutineUPP NewComponentRoutineUPP (
   ComponentRoutineProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ComponentRoutineUPP data type.
Discussion

See the ComponentRoutineProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

ComponentRoutineUPP NewComponentRoutineUPP (
   ComponentRoutineProcPtr userRoutine
){};



/*FSDisposeVolumeOperation

Releases the memory associated with a volume operation. 

OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);
Parameters
volumeOp

The FSVolumeOperation to release. 
Return Value

A result code. See “File Manager Result Codes”. This function will return paramErr if the FSVolumeOperation is in use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
){};


/*FSMountServerVolumeAsync

Mounts a server volume asynchronously.

OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);
Parameters
url

The server to mount. 
mountDir

The directory to mount the server to. If this parameter is NULL, the default location is used. 
user

A string to pass as the user for authentication. This parameter can be NULL. 
password

A string to pass as the password for authenticated log in. This parameter can be NULL. 
volumeOp

An FSVolumeOperation returned by the FSCreateVolumeOperation function. 
clientData

A pointer to client data associated with the operation. This parameter can be NULL.
flags

Options for future use.
callback

A function to call when the mount is complete. This parameter can be NULL. 
runloop

The runloop to run on. 
runloopMode

The mode for the runloop. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function will start the process to mount the server specified by the url parameter at the location specified by the mountDir parameter. If mountDir is NULL, the default location is used. An optional user and password can be passed in for authentication. If no user or password is provided then the underlying file system will handle authentication if required. If a callback function is provided, that function will be called when the mount operation is complete. Once this function returns noErr the status of the operation can be found using the FSGetAsyncMountStatus function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
){};



/*NewFSVolumeMountUPP


FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the FSVolumeMountUPP data type.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
){};

/*FSCreateVolumeOperation

Returns an FSVolumeOperation which can be used for an asynchronous volume operation. 

OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);
Parameters
volumeOp

The new FSVolumeOperation. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

When the operation is completed the FSVolumeOperation should be disposed of to free the memory associated with the operation using FSDisposeVolumeOperation.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
){};


/*FSpMakeFSRef

Creates an FSRef for a file or directory, given an FSSpec.

OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);
Parameters
source

A pointer to the FSSpec for the file or directory. This parameter must point to a valid FSSpec for an existing file or directory; if it does not, the call will return fnfErr. See FSSpec for a description of the FSSpec data type.
newRef

On input, a pointer to an FSRef structure. On return, a pointer to the FSRef for the file or directory specified in the FSSpec pointed to in the source parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To obtain an FSSpec from an FSRef, use the FSGetCatalogInfo function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
){};

/*GetComponentResource


OSErr GetComponentResource (
   Component aComponent,
   OSType resType,
   short resID,
   Handle * theResource
);
Parameters
aComponent
resType
theResource
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 3.0 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

OSErr GetComponentResource (
   Component aComponent,
   OSType resType,
   short resID,
   Handle * theResource
){};




/*EndianU32_NtoB

Converts an unsigned 32-bit value in the computer’s native format to the equivalent big-endian value.

UInt32 EndianU32_NtoB (
   UInt32    value
);
Parameters
value

An unsigned 32-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_NtoB (
   UInt32    value
){};


/*CountComponents

Returns the number of registered components that meet the selection criteria specified by your application. 

long CountComponents (
   ComponentDescription * looking
);
Parameters
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, the Component Manager returns the number of components registered in the system. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager returns the number of registered components supplied by the manufacturer you specify.

Return Value

The number of components that meet the specified search criteria. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long CountComponents (
   ComponentDescription * looking
){};


/*GetComponentVersion

Returns the version number of a component to your application. 

long GetComponentVersion (
   ComponentInstance ci
);
Parameters
ci

The component instance from which you want to retrieve version information. Your application obtains the component instance from the OpenDefaultComponent function or the OpenComponent function. 
Return Value

The version number of the component you specify. The high-order 16 bits represent the major version, and the low-order 16 bits represent the minor version. The major version specifies the component specification level the minor version specifies a particular implementation’s version number. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long GetComponentVersion (
   ComponentInstance ci
){};



/*NewPtr

Allocates a nonrelocatable block of memory of a specified size.

Ptr NewPtr (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the nonrelocatable block. In Mac OS X, if you pass a value of zero, this function returns NULL, and MemError is set to paramErr. In Mac OS 9 and earlier, if you pass a value of zero, this function returns a valid zero length pointer. 
Return Value

A pointer to the new block. If NewPtr fails to allocate a block of the requested size, it returns NULL. 
Discussion

The NewPtr function attempts to reserve space as low in the heap zone as possible for the new block. If it is able to reserve the requested amount of space, NewPtr allocates the nonrelocatable block in the gap ReserveMem creates. Otherwise, NewPtr returns NULL and generates a memFullErr error.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewPtr allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Ptr NewPtr (
   Size byteCount
){};


/*TickCount

Obtains the current number of ticks (a tick is approximately 1/60 of a second) since the system last started up.

UInt32 TickCount ();
Discussion

The TickCount function returns an unsigned 32-bit integer that indicates the current number of ticks since the system last started up. You can use this value to compare the number of ticks that have elapsed since a given event or other action occurred. For example, you could compare the current value returned by TickCount with the value of the when field of an event structure.

The tick count is incremented during the vertical retrace interrupt, but this interrupt can be disabled. Your application should not rely on the tick count to increment with absolute precision. Your application also should not assume that the tick count always increments by 1 an interrupt task might keep control for more than one tick. If your application keeps track of the previous tick count and then compares this value with the current tick count, your application should compare the two values by checking for a “greater than or equal” condition rather than “equal to previous tick count plus 1.”

Do not rely on the tick count being exact; it is usually accurate to within one tick, but this level of accuracy is not guaranteed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
UInt32 TickCount (){};


/*_MPIsFullyInitialized

Indicates whether Multiprocessing Services is available for use.

Boolean _MPIsFullyInitialized ();
Parameters
Return Value
Discussion

Checking for the availability of the MP API is rather ugly. This is a historical problem, caused by the original implementation letting itself get prepared when it really wasn't usable and complicated by some important clients then depending on weak linking to "work". (And further complicated by CFM not supporting "deferred" imports, which is how many programmers think weak imports work.)

The end result is that the MP API library may get prepared by CFM but be totally unusable. This means that if you import from the MP API library, you cannot simply check for a resolved import to decide if MP services are available. Worse, if you explicitly prepare the MP API library you cannot assume that a noErr result from GetSharedLibrary means that MP services are available.
If you import from the MP API library you must do the following:

Use the MPLibraryIsLoaded macro (or equivalent code in languages other than C) to tell if the MP API services are available. It is not sufficient to simply check that an imported symbol is resolved as is commonly done for other libraries. The macro expands to the expression: ( ( (UInt32)_MPIsFullyInitialized != (UInt32)kUnresolvedCFragSymbolAddress  )  &&
              ( _MPIsFullyInitialized () ) )

This code checks if the imported symbol _MPIsFullyInitialized is resolved and, if resolved, calls it. Both parts must succeed for the MP API services to be available.
If you explicitly prepare the MP API library you must use code similar to the following example to tell if the MP API services are available. It is not sufficient to depend on just a noErr result from GetSharedLibrary. OSErr err;
Boolean mpIsAvailable = false;
CFragConnectionID connID = kInvalidID;
MPIsFullyInitializedProc    mpIsFullyInitialized    = NULL;
 
err = GetSharedLibrary  ( "\pMPLibrary", kCompiledCFragArch,                             kReferenceCFrag, &connID, NULL,  NULL );
 
if ( err == noErr ) {
err = FindSymbol ( connID, "\p_MPIsFullyInitialized",
                    (Ptr *) &mpIsFullyInitialized, NULL );
}
 
if ( err == noErr ) {mpIsAvailable = (* mpIsFullyInitialized) ();
    }

Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
Boolean _MPIsFullyInitialized (){};

/*MPCreateTask

Creates a preemptive task.

Modified

OSStatus MPCreateTask (
   TaskProc entryPoint,
   void * parameter,
   ByteCount stackSize,
   MPQueueID notifyQueue,
   void * terminationParameter1,
   void * terminationParameter2,
   MPTaskOptions options,
   MPTaskID * task
);
Parameters
entryPoint

A pointer to the task function. The task function should take a single 32-bit parameter and return a value of type OSStatus. 
parameter

The parameter to pass to the task function. 
stackSize

The size of the stack assigned to the task. Note that you should be careful not to exceed the bounds of the stack, since stack overflows may not be detected. Specifying zero for the size will result in a default stack size of 4KB. 

Note that in Mac OS X prior to version 10.1, this parameter is ignored, and all stacks have the default size of 512 KB. Versions 10.1 and later do not have this limitation.

notifyQueue

The ID of the message queue to which the system will send a message when the task terminates. You specify the first 64-bits of the message in the parameters terminationParameter1 and terminationParameter2 respectively. The last 32-bits contain the result code of the task function. 
terminationParameter1

A 32-bit value that is sent to the message queue specified by the parameter notifyQueue when the task terminates.
terminationParameter2

A 32-bit value that is sent to the message queue specified by the parameter notifyQueue when the task terminates.
options

Optional attributes of the preemptive task. See Task Creation Options for a list of possible values. 
task

On return, task points to the ID of the newly created task. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If MPCreateTask could not create the task because some critical resource was not available, the function returns kMPInsufficientResourcesErr. Usually this is due to lack of memory to allocate the internal data structures associated with the task or the stack. The function also returns kMPInsufficientResourcesErr if any reserved option bits are set.
Discussion

Tasks are created in the unblocked state, ready for execution. A task can terminate in the following ways:
By returning from its entry point 
By calling MPExit
When specified as the target of an MPTerminateTask call 
If a hardware-detected exception or programming exception occurs and no exception handler is installed 
If the application calls ExitToShell 

Task resources (its stack, active timers, internal structures related to the task, and so on) are reclaimed by the system when the task terminates. The task's address space is inherited from the process address space. All existing tasks are terminated when the owning process terminates.

To set the relative processor weight to be assigned to a task, use the function MPSetTaskWeight.

See also the function MPTerminateTask. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

In Mac OS X prior to version 10.1, the stackSize parameter is ignored, and all stacks have the default size of 512 KB. Versions 10.1 and later do not have this limitation. 
Declared In
Multiprocessing.h*/
OSStatus MPCreateTask (
   TaskProc entryPoint,
   void * parameter,
   ByteCount stackSize,
   MPQueueID notifyQueue,
   void * terminationParameter1,
   void * terminationParameter2,
   MPTaskOptions options,
   MPTaskID * task
){};


/*LongSecondsToDate

Converts the number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void LongSecondsToDate (
   const LongDateTime * lSecs,
   LongDateRec * lDate
);
Parameters
lSecs

The number of seconds elapsed since midnight, January 1, 1904. 
lDate

On return, the fields of the long date-time structure that contain the date and time corresponding to the value indicated in the lSecs parameter. For example, specifying the number of seconds 41580 results in the date and time 11:33 A.M. on January 1, 1904 being returned in this parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void LongSecondsToDate (
   const LongDateTime * lSecs,
   LongDateRec * lDate
){};




/*UpTime
AbsoluteTime UpTime (void); 
DESCRIPTION

UpTime returns the time since OS initialization in AbsoluteTime units.
EXECUTION CONTEXT

UpTime may be called from task level, secondary interrupt level, or hardware interrupt level.*/
AbsoluteTime UpTime (void){}; 





/*MPTerminateTask

Terminates an existing task.

OSStatus MPTerminateTask (
   MPTaskID task,
   OSStatus terminationStatus
);
Parameters
task

The ID of the task you wish to terminate. 
terminationStatus

A 32-bit value of type OSStatus indicating termination status. This value is sent to the termination status message queue you specified in MPCreateTask in place of the task function’s result code. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the task to be terminated is already in the process of termination, MPTerminateTask returns kMPInsufficientResourcesErr. You do not need to take any additional action if this occurs.
Discussion

You should be very careful when calling MPTerminateTask. As defined, this call will asynchronously and abruptly terminate a task, potentially leaving whatever structures or resources it was operating upon in an indeterminate state. Mac OS X exacerbates this problem, as MP tasks can use many more system services that are not expecting client threads to asynchronously terminate, and these services do not take the rather complicated steps necessary to protect against, or recover from, such a situation.

However, there are situations in which calling MPTerminateTask is useful and relatively safe. One such situation is when your application or service is quitting and you know that the task you wish to terminate is waiting on an MP synchonization construct (queue, event, semaphore or critical region). While you could do this more cleanly by waking the task and causing it to exit on its own, doing so may not always be practical.

For example, suppose you have several service tasks performing background processing for your application. These service tasks wait on a queue, onto which the applicaton places requests for processing. When the task is done with a request, it notifies another queue, which the application polls. Since the main application task is placing items on the shared queue, and receiving notifications when the requests are done, it can track whether or not there are outstanding requests being processed. If all outstanding requests have, in fact, been processed, it is relatively safe to terminate a task (or all tasks) waiting on the request queue.

You should not assume that the task has completed termination when this call returns; the proper way to synchronize with task termination is to wait on the termination queue (specified in MPCreateTask ) until a message appears. Because task termination is a multistage activity, it is possible for a preemptive task to attempt to terminate a task that is already undergoing termination. In such cases, MPTerminateTask returns kMPInsufficientResourcesErr.

Note that Multiprocessing Services resources (event groups, queues, semaphores, and critical regions) owned by a preemptive task are not released when that task terminates. If a task has a critical region locked when it terminates, the critical region remains in the locked state. Multiprocessing Services resources no longer needed should be explicitly deleted by the task that handles the termination message. All Multiprocessing Services resources created by tasks are released when their owning process (that is, the host application) terminates. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPTerminateTask (
   MPTaskID task,
   OSStatus terminationStatus
){};


/*S64Compare


SInt32 S64Compare (
   SInt64 left,
   SInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt32 S64Compare (
   SInt64 left,
   SInt64 right
){};


/*Time Conversion Routines

The Driver Services Library provides the following conversion routines to convert between Nanoseconds, Duration, and AbsoluteTime units:
Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime); 

Nanoseconds DurationToNanoseconds (Duration duration); 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime); 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds); 

AbsoluteTime DurationToAbsolute (Duration duration); 

Duration NanosecondsToDuration (Nanoseconds nanoseconds); 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2); 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Note

The value of rightAbsoluteTime is usually larger than that of leftAbsoluteTime. However, if you subtract a rightAbsoluteTime value from a leftAbsoluteTime value, the result is 0, not a negative number. 
EXECUTION CONTEXT

The time conversion routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/

Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime){}; 

Nanoseconds DurationToNanoseconds (Duration duration){}; 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime){}; 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds){}; 

AbsoluteTime DurationToAbsolute (Duration duration){}; 

Duration NanosecondsToDuration (Nanoseconds nanoseconds){}; 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2){}; 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime){}; 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime){}; 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime){}; 

/*Long2Fix

Converts a LongInt number to a Fixed number.

Fixed Long2Fix (
   long x
);
Parameters
x

The long integer to be converted to a Fixed number. 
Return Value

The Fixed number equivalent to the long integer x. If x is greater than the maximum representable fixed-point number, the Long2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, Long2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed Long2Fix (
   long x
){};

/*FSResolveAliasFileWithMountFlags

Resolves an alias contained in an alias file.

OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
);
Parameters
theRef

A pointer to a file system reference (FSRef) for the alias file you plan to open. If the function completes successfully, this FSRef describes the file or the directory referred to by the alias file.
resolveAliasChains

A Boolean value. Set this parameter to TRUE if you want FSResolveAliasFileWithMountFlags to resolve all aliases in a chain (for example, an alias file that refers to an alias file and so on), stopping only when it reaches the target file. Set this parameter to FALSE if you want to resolve only one alias file, even if the target is another alias file. 
targetIsFolder

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to a directory or a volume; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
wasAliased

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to an alias; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
mountFlags

Options controlling how the alias file is resolved. See “Volume Mount Options” for a description of the values you can use here. Set this parameter to kResolveAliasFileNoUI to prevent any user interaction, including disk switch alerts, while the alias is being resolved.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The function FSResolveAliasFileWithMountFlags is identical to FSResolveAliasFile with the exception that it provides the mountFlags parameter, allowing callers additional control over how the alias file is resolved.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/
OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
){};





/*FSCompareFSRefs

Determines whether two FSRef structures refer to the same file or directory.

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);
Parameters
ref1

A pointer to the first FSRef to compare. For a description of the FSRef data type, see FSRef.
ref2

A pointer to the second FSRef to compare.
Return Value

A result code. See “File Manager Result Codes”. If the two FSRef structures refer to the same file or directory, then noErr is returned. If they refer to objects on different volumes, then diffVolErr is returned. If they refer to different files or directories on the same volume, then errFSRefsDifferent is returned. This function may return other errors, including nsvErr, fnfErr, dirNFErr, and volOffLinErr.
Discussion

You must use FSCompareFSRefs, or one of the corresponding parameter block functions, PBCompareFSRefsSync and PBCompareFSRefsAsync , to compare FSRef structures. It is not possible to compare the FSRef structures directly since some bytes may be uninitialized, case-insensitive text, or contain hint information.

Some volume formats may be able to tell that two FSRef structures would refer to two different files or directories, without having to actually find those objects. In this case, the volume format may return errFSRefsDifferent even if one or both objects no longer exist. Similarly, if the FSRef structures are for objects on different volumes, the File Manager will return diffVolErr even if one or both volumes are no longer mounted. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
){};


/*FSCreateDirectoryUnicode

Creates a new directory (folder) with a Unicode name. 

OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);
Parameters
parentRef

A pointer to an FSRef specifying the parent directory where the new directory is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the new directory's Unicode name. 
name

A pointer to the Unicode name of the new directory. 
whichInfo

A bitmap specifying which catalog information fields to set for the new directory. Specify the values for these fields in the catalogInfo parameter. 

If you do not wish to set catalog information for the new directory, specify the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values for the catalog information fields for the new directory. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new directory.

See FSCatalogInfo for a description of the FSCatalogInfo data type.
newRef

On return, a pointer to the FSRef for the new directory. This parameter is optional; specify NULL if you do not want the FSRef returned.
newSpec

On return, a pointer to the FSSpec for the new directory. This parameter is optional; specify NULL if you do not want the FSSpec returned. See FSSpec for a description of the FSSpec data type.
newDirID

On return, a pointer to the directory ID of the directory. This parameter is optional; specify NULL if you do not want the directory ID returned. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new directory using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the directory. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateDirectoryUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBDirCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode directory names, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
){};



/*FSWrite

Writes any number of bytes to an open file. (Deprecated in Mac OS X v10.4. Use FSWriteFork instead.)

OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);
Parameters
refNum

The file reference number of the open file to which to write. 
count

On input, a pointer to the number of bytes to write to the file. In Carbon on Mac OS 9 and X, passing 0 in this parameter will return a paramErr error.

On output, a pointer to the number of bytes actually written.

buffPtr

A pointer to the data buffer containing the data to write. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSWrite function takes the specified number of bytes from the data buffer and attempts to write them to the file. Because the write operation begins at the current mark, you might want to set the mark first by calling the SetFPos function.

If the write operation completes successfully, FSWrite moves the file mark to the byte following the last byte written and returns noErr. If you try to write past the logical end-of-file, FSWrite moves the logical end-of-file. If you try to write past the physical end-of-file, FSWrite adds one or more clumps to the file and moves the physical end-of-file accordingly.

The low-level functions PBWriteSync and PBWriteAsync let you set the mark without having to call SetFPos. For a description of the PBWriteSync and PBWriteAsync functions, see the Device Manager Reference .

If you wish to write to named forks other than the data or resource forks, or grow files larger than 2GB, you must use the FSWriteFork function, or one of its corresponding parameter block calls, PBWriteForkSync and PBWriteForkAsync. If you attempt to use FSWrite to write to a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
){};


/*FSpCreate

Creates a new file. (Deprecated in Mac OS X v10.4. Use FSCreateFileUnicode instead.)

OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to be created. See FSSpec for a description of the FSSpec data type.
creator

The creator of the new file. See the documentation for the Finder Interface for more information on file creators. 
fileType

The file type of the new file. See the documentation for the Finder Interface for more information on file types.
scriptTag

The code of the script system in which the filename is to be displayed. If you have established the name and location of the new file using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information about the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. See the Script Manager Reference for a description of the smSystemScript constant.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCreate function creates a new file (both data and resource forks) with the specified type, creator, and script code. The new file is unlocked and empty. The date and time of creation and last modification are set to the current date and time.

Files created using FSpCreate are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager functions HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpCreate is not available, you can use the function HCreate instead. To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
){};


/*FSpDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr FSpDelete (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to delete. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, FSpDelete returns the result code fBsyErr. FSpDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both forks of the file are deleted. The file ID reference, if any, is removed. A file must be closed before you can delete it. Similarly, a directory must be empty before you can delete it. 

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDelete is not available, you can use the function HDelete instead. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpDelete (
   const FSSpec * spec
){};


/*NewAliasMinimal

Creates a short alias record quickly. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal instead.)

Not recommended

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
);
Parameters
target

A pointer to an FSSpec structure for the target of the alias record.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimal function creates an alias record that contains only the minimum information necessary to describe the target: the target name, the parent directory ID, the volume name and creation date, and the volume mounting information. The NewAliasMinimal function uses the standard alias record data structure, but it fills in only parts of the record.

The ResolveAlias function never updates a minimal alias record. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal instead.
Declared In
Aliases.h*/

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
){};


/*AddResource

Adds a resource to the current resource file’s resource map in memory.

void AddResource (
   Handle theData,
   ResType theType,
   short theID,
   ConstStr255Param name
);
Parameters
theData

A handle to data in memory to be added as a resource to the current resource file (not a handle to an existing resource). If the value of this parameter is an empty handle (that is, a handle whose master pointer is set to NULL), the Resource Manager writes zero-length resource data to disk when it updates the resource. If its value is either NULL or a handle to an existing resource, the function does nothing, and the ResError function returns the result code addResFailed. If the resource map becomes too large to fit in memory, the function does nothing, and ResError returns an appropriate result code. The same is true if the resource data in memory can’t be written to the resource fork (for example, because the disk is full).
theType

The resource type of the resource to be added.
theID

The resource ID of the resource to be added.
name

The name of the resource to be added.
Discussion

This function sets the resChanged attribute to 1 it does not set any of the resource’s other attributes—that is, all other attributes are set to 0. If the resChanged attribute of a resource has been set and your application calls the UpdateResFile function or quits, the Resource Manager writes both the resource map and the resource data for that resource to the resource fork of the corresponding file on disk. If the resChanged attribute for a resource has been set and your application calls the WriteResource function, the Resource Manager writes only the resource data for that resource to disk.

If you add a resource to the current resource file, the Resource Manager writes the entire resource map to disk when it updates the file. If you want any of your changes to the resource map or resource data to be temporary, you must restore the original information before the Resource Manager updates the file on disk.

The function doesn’t verify whether the resource ID you pass in the parameter theID is already assigned to another resource of the same type. You should call the UniqueID or Unique1ID function to get a unique resource ID before adding a resource with this function.

When your application calls this function, the Resource Manager attempts to reserve disk space for the new resource. If the new resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call UpdateResFile or WriteResource, the Resource Manager won’t know that resource data has been added. Thus, the function won’t write the new resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to AddResource. 

To copy an existing resource, get a handle to the resource you want to copy, call the DetachResource function, then call AddResource. To add the same resource data to several different resource forks, call the Memory Manager function HandToHand to duplicate the handle for each resource. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void AddResource (
   Handle theData,
   ResType theType,
   short theID,
   ConstStr255Param name
){};


/*RemoveResource

Removes a resource’s entry from the current resource file’s resource map in memory. 

void RemoveResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If the resProtected attribute for the resource is set or if this parameter doesn’t contain a handle to a resource, the function does nothing, and the ResError function returns the result code rmvResFailed. 
Discussion

The RemoveResource function does not dispose of the handle you pass into it; to do so you must call the Memory Manager function DisposeHandle after calling RemoveResource. You should dispose the handle if you want to release the memory before updating or closing the resource fork.

If you’ve removed a resource, the Resource Manager writes the entire resource map when it updates the resource fork, and all changes made to the resource map become permanent. If you want any of the changes to be temporary, you should restore the original information before the Resource Manager updates the resource fork.

The RemoveResource function is also available as the RmveResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void RemoveResource (
   Handle theResource
){};

/*UseResFile

Sets the current resource file.

void UseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork which you wish to set as the current resource fork.
Return Value

The function searches the list of files whose resource forks have been opened for the file specified here. If the specified file is found, the Resource Manager sets the current resource file to the specified file. If there’s no resource fork open for a file with that reference number, the function does nothing. To set the current resource file to the System file, use 0 here.
Discussion

Open resource forks are arranged as a linked list with the most recently opened resource fork at the beginning. When searching open resource forks, the Resource Manager starts with the most recently opened file. You can call this function to set the current resource file to a file opened earlier, and thereby start subsequent searches with the specified file. In this way, you can cause any files higher in the resource chain to be left out of subsequent searches.

When a new resource fork is opened, this action overrides previous calls to this function and the entire list is searched. For example, if five resource forks are opened in the order R0, R1, R2, R3, and R4, the search order is R4-R3-R2-R1-R0. Calling UseResFile(R2) changes the search order to R2-R1-R0; R4 and R3 are not searched. When the resource fork of a new file (R5) is opened, the search order becomes R5-R4-R3-R2-R1-R0.

You typically call the CurResFile function to get and save the current resource file, UseResFile to set the current resource file to the desired file, then (after you are finished using the resource) UseResFile to restore the current resource file to its previous value. Calling UseResFile(0) causes the Resource Manager to search only the System file’s resource map. This is useful if you no longer wish to override a system resource with one by the same name in your application’s resource fork.

Most of the Resource Manager functions assume that the current resource file is the file on whose resource fork they should operate or, in the case of a search, the file where they should begin. In general, the current resource file is the last one whose resource fork your application opened unless you specify otherwise.

The FSpOpenResFile, HOpenResFile, and OpenResFile functions, which also set the current resource file, override previous calls to UseResFile.

To check for errors, call the ResError function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void UseResFile (
   short refNum
){};



/*PBSetCatInfoSync

Modifies catalog information for a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBSetCatInfoSync function sets information about a file or directory. When used to set information about a file, it works much as PBHSetFInfoSync does, but lets you set some additional information.

If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFlFndrInfo 

On input, Finder information for the file. 
ioDirID 

On input, the parent directory ID of the file. 
ioFlCrDat 

On input, the date and time of the file’s creation. 
ioFlMdDat 

On input, the date and time of the file’s last modification. 
ioFlBkDat 

On input, the date and time of the file’s last backup. 
ioFlXFndrInfo 

On input, extended Finder information. 

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDrUsrWds 

On input, information used by the Finder. 
ioDrDirID 

On input, the directory ID. 
ioDrCrDat 

On input, the date and time of the directory’s creation. 
ioDrMdDat 

On input, the date and time of the directory’s last modification. 
ioDrBkDat 

On input, the date and time of the directory’s last backup. 
ioDrFndrInfo 

On input, additional information used by the Finder. 

To modify the catalog information for a named fork other than the data and resource fork, or to modify other catalog information maintained on HFS Plus volumes that is not modifiable through PBSetCatInfoSync, use one of the functions, FSSetCatalogInfo , PBSetCatalogInfoSync , or PBSetCatalogInfoAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
){};


/*FSpOpenResFile

Opens a file’s resource fork using a file system specification (FSSpec) record.

short FSpOpenResFile (
   const FSSpec * spec,
   SignedByte permission
);
Parameters
spec

A pointer to a file system specification record specifying the name and location of the file whose resource fork is to be opened. The file system specification record for files and directories is defined by the FSSpec data type and is a standard format in System 7 and later versions for identifying a file or directory.

This function also makes this file the current resource file.

See the File Manager documentation for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the resource fork. For a description of the types of access you can request, see the section File Access Permission Constants in File Manager Reference.
Return Value

The file reference number for the resource fork. If the file reference number returned is greater than 0, you can use this number to refer to the resource fork in some other Resource Manager functions.

If you attempt to use this function to open a resource fork that is already open, it returns the existing file reference number or a new one, depending on the access permission for the existing access path. For example, your application receives a new file reference number after a successful request for read-only access to a file previously opened with write access, whereas it receives the same file reference number in response to a second request for write access to the same file. In this case, the function doesn’t make that file the current resource file.

If the function fails to open the specified file’s resource fork (for instance, because there’s no file with the given file system specification record or because there are permission problems), it returns –1 as the file reference number. Use the ResError function to determine what kind of error occurred. 

If an application attempts to open a second access path with write access and the application is different from the one that originally opened the resource fork, FSpOpenResFile returns –1, and the ResError function returns the result code opWrErr.
Discussion

This function is available only in System 7 and later versions of system software. You can determine whether FSpOpenResFile is available by calling the Gestalt function with the gestaltFSAttr selector code. If this function is not available to your application, you can use HOpenResFile, OpenRFPerm, or OpenResFile instead. The HOpenResFile function is preferred if FSpOpenResFile is not available. The OpenRFPerm and OpenResFile functions are earlier versions of HOpenResFile that are still supported but are more restricted in their capabilities.

The Resource Manager reads the resource map from the specified file’s resource fork into memory. It also reads into memory every resource in the resource fork whose resPreload attribute is set.

You don’t have to call this function to open the System file’s resource fork or an application file’s resource fork. These resource forks are opened automatically when the system and the application start up, respectively. To get the file reference number for your application, call the CurResFile function after your application starts up and before you open any other resource forks.

The FSpOpenResFile function checks that the information in the resource map is internally consistent. If it isn’t, ResError returns the result code mapReadErr.

It’s possible to create multiple, unique, read-only access paths to a resource fork using this function however, you should avoid doing so. If a resource fork is opened twice—once with read/write permission and once with read-only permission—two copies of the resource map exist in memory. If you change one of the resources in memory using one of the resource maps, the two resource maps become inconsistent and the file will appear damaged to the second resource map. 

If you must use this technique for read-only access, call this function immediately before your application reads information from the file and close the file immediately afterward. Otherwise, your application may get unexpected results.

If you want to open the resource fork for another application (or any resource fork other than your application’s that includes 'CODE' resources), you must bracket your calls to this function with calls to the SetResLoad function with the load parameter set to FALSE and then to TRUE. You must also avoid making intersegment calls while the other application’s resource fork is open. If you don’t do this, the Segment Loader Manager treats any preloaded 'CODE' resources as your code resources when you make an intersegment call that triggers a call to the LoadSeg function while the other application is first in the resource chain. In this case, your application can begin executing the other application’s code, and severe problems will ensue. If you need to get 'CODE' resources from the other application’s resource fork, you can still prevent the Segment Loader Manager problem by calling the UseResFile function with your application’s file reference number to make your application the current resource file.

To open a resource fork just for block-level operations, such as copying files without reading the resource map into memory, use the File Manager function OpenRF. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSpOpenResFile (
   const FSSpec * spec,
   SignedByte permission
){};


/*HCreateResFile

Creates an empty resource fork, when the FSpCreateResFile function is not available.

void HCreateResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

The volume reference number of the volume on which the file is located.
dirID

The directory ID of the directory where the file is located.
fileName

The name of the file whose resource fork is to be created. If no other file with the given name exists in the specified directory, the function creates a resource file—that is, a resource fork, including a resource map. In this case the file has a zero-length data fork. 

If a file with the specified name already exists and includes a resource fork with a resource map, the function does nothing. If the data fork of the specified file already exists but the file has a zero-length resource fork, the function creates an empty resource fork and resource map for the file.
Discussion

Don’t use the resource fork of a file for data that is not in resource format. The Resource Manager assumes that any information in a resource fork can be interpreted according to the standard resource format described in this chapter.

The File Manager assumes that the first block of a file’s resource fork is part of the resource header and puts information there that it uses during scavenging—for example, after the user presses the Reset switch. For this reason, if you copy a resource file, the duplicate may not be exactly like the original.

Before you can work with the newly created file’s resource fork, you must first use the HOpenResFile function or a related function to open it.

To check for errors, call the ResError function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void HCreateResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
){};

/*WriteResource

Writes resource data in memory immediately to a file’s resource fork. 

void WriteResource (
   Handle theResource
);
Parameters
theResource

A handle to a resource. The function checks the resChanged attribute of this resource. If the resChanged attribute is set to 1, such as after a successful call to the ChangedResource or AddResource function, WriteResource writes the resource data in memory to the resource fork, then clears the resChanged attribute in the resource’s resource map in memory.

If the resource is purgeable and has been purged, the function writes zero-length resource data to the resource fork. If the resource’s resProtected attribute is set to 1, the function does nothing, and the ResError function returns the result code noErr. The same is true if the resChanged attribute is not set (that is, set to 0). If the given handle isn’t a handle to a resource, WriteResource does nothing, and ResError returns the result code resNotFound.
Discussion

Note that this function does not write the resource’s resource map entry to disk.

When your application calls ChangedResource or AddResource, the Resource Manager attempts to reserve disk space for the changed resource. If the modified resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call WriteResource, the Resource Manager won’t know that the resource data has been changed. Thus, the function won’t write the modified resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to ChangedResource or AddResource.

The resource fork is updated automatically when your application quits, when you call the UpdateResFile function, or when you call the CloseResFile function. Thus, you should call WriteResource only if you want to write just one or a few resources immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void WriteResource (
   Handle theResource
){};

/*HiWord

Obtains the high-order word of a long word. 

SInt16 HiWord (
   SInt32 x
);
Parameters
x

The long word whose high word is to be returned. 
Return Value

The high-order word of the long word specified by the x parameter. 
Discussion

One use of this function is to obtain the integral part of a fixed-point number.

To copy a range of bytes from one memory location to another, you should ordinarily use the Memory Manager function, BlockMove. 
Availability
Declared In
ToolUtils.h*/

SInt16 HiWord (
   SInt32 x
){};






/*LoWord

Obtains the low-order word of a long word. 

SInt16 LoWord (
   SInt32 x
);
Parameters
x

The long word whose low word is to be returned. 
Return Value

The low-order word of the long word specified by the x parameter. 
Discussion

One use of this function is to obtain the fractional part of a fixed-point number.

To copy a range of bytes from one memory location to another, you should ordinarily use the Memory Manager function, BlockMove. 
Availability
Declared In
ToolUtils.h*/

SInt16 LoWord (
   SInt32 x
){};



/*PBWriteSync

Writes any number of bytes to an open file.

OSErr PBWriteSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for the open file to which to write. 
ioBuffer On input, a pointer to a data buffer containing the bytes to write. 
ioReqCount On input, the number of bytes requested. 
ioActCount On output, the number of bytes actually written. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

The PBWriteSync function takes ioReqCount bytes from the buffer pointed to by ioBuffer and attempts to write them to the open file whose access path is specified by ioRefNum. The position of the mark is specified by ioPosMode and ioPosOffset. If the write operation completes successfully, PBWriteSync moves the file mark to the byte following the last byte written and returns noErr.

If you try to write past the logical end-of-file, PBWriteSync moves the logical end-of-file. If you try to write past the physical end-of-file, PBWriteSync adds one or more clumps to the file and moves the physical end-of-file accordingly. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for writing to open files.
Declared In
Devices.h*/

OSErr PBWriteSync (
   ParmBlkPtr paramBlock
){};


/*SetFPos

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use FSSetForkPosition instead.)

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);
Parameters
refNum

The file reference number of an open file. 
posMode

A constant specifying how to position the file mark; this parameter must contain one of the values described in Position Mode Constants.
posOff

The offset from the base location specified by the posMode parameter for the new file mark position. If you specify fsFromLEOF in the posMode parameter, the value in the posOff parameter must be less than or equal to 0. If you specify fsAtMark, the value in the posOff parameter is ignored. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you may want to call SetFPos to reposition the file mark before reading from or writing to the file.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
){};


/*SetEOF

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSSetForkSize instead.)

OSErr SetEOF (
   short refNum,
   long logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

The new logical size (the logical end-of-file) of the given file. If you set the logEOF parameter to 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you attempt to set the logical end-of-file beyond the physical end-of-file, the physical end-of-file is set 1 byte beyond the end of the next free allocation block if there isn’t enough space on the volume, no change is made, and SetEOF returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr SetEOF (
   short refNum,
   long logEOF
){};

/*GetFPos

Returns the current position of the file mark. (Deprecated in Mac OS X v10.4. Use FSGetForkPosition instead.)

OSErr GetFPos (
   short refNum,
   long * filePos
);
Parameters
refNum

The file reference number of an open file. 
filePos

On return, a pointer to the current position of the mark. The position value is zero-based; that is, the value of filePos is 0 if the file mark is positioned at the beginning of the file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you should call GetFPos, or one of the parameter block functions, PBGetFPosSync and PBGetFPosAsync , to determine the current position of the file mark before reading from or writing to the file.

To determine the current position of a named fork, or of a fork larger than 2GB, use the FSGetForkPosition function, or one of the corresponding parameter block calls, PBGetForkPositionSync and PBGetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetFPos (
   short refNum,
   long * filePos
){};


/*GetComponentRefcon

Retrieves the value of the reference constant for your component. 

long GetComponentRefcon (
   Component aComponent
);
Parameters
aComponent

The component whose reference constant you wish to get. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

The reference constant for the specified component. 
Discussion

There is one reference constant for each component, regardless of the number of connections to that component. When your component is registered, the Component Manager sets this reference constant to 0.

The reference constant is a 4-byte value that your component can use in any way you decide. For example, you might use the reference constant to store the address of a data structure that is shared by all connections maintained by your component. You should allocate shared structures in the system heap. Your component should deallocate the structure when its last connection is closed or when it is unregistered. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long GetComponentRefcon (
   Component aComponent
){};


/*SetComponentRefcon

Sets the reference constant for your component.

void SetComponentRefcon (
   Component aComponent,
   long theRefcon
);
Parameters
aComponent

The component whose reference constant you wish to set. You can use a component instance here, but you must coerce the data type appropriately. 
theRefcon

The reference constant value that you want to set for your component. Your component can retrieve the reference constant using the GetComponentRefcon function. 
Discussion

There is one reference constant for each component, regardless of the number of connections to that component. When your component is registered, the Component Manager sets this reference constant to 0.

The reference constant is a 4-byte value that your component can use in any way you decide. For example, you might use the reference constant to store the address of a data structure that is shared by all connections maintained by your component. You should allocate shared structures in the system heap. Your component should deallocate the structure when its last connection is closed or when it is unregistered. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
void SetComponentRefcon (
   Component aComponent,
   long theRefcon
){};


/*GetComponentInstanceA5

Retrieves the value of the A5 register for a specified connection.

Unsupported

SInt32 GetComponentInstanceA5 (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection for which to retrieve the A5 value. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

The value of the A5 register for the connection. 
Discussion

Your component sets the A5 register by calling the SetComponentInstanceA5 function. 
Carbon Porting Notes

Because there is no A5 world in Carbon, you cannot use the functions GetComponentInstanceA5 and SetComponentInstanceA5 to access A5 information.
Declared In
Components.h*/
SInt32 GetComponentInstanceA5 (
   ComponentInstance aComponentInstance
){};


/*FSpSetFInfo

Sets the Finder information about a file. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file for which to set the Finder information. See FSSpec for a description of the FSSpec data type.
fndrInfo

A pointer to the new Finder information. For a description of the FInfo data type, see the Finder Interface Reference.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpSetFInfo function changes the Finder information in the volume catalog entry for the specified file. FSpSetFInfo allows you to set only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
){};


/*PrimeTime

Activates a task in the Time Manager queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void PrimeTime (
QElemPtr tmTaskPtr,
long count
);
Discussion

This function is deprecated. You should use the function PrimeTimeTask instead.
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/

void PrimeTime (
QElemPtr tmTaskPtr,
long count
){};


/*PBWriteAsync

Writes any number of bytes to an open file.

OSErr PBWriteAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for the open file to which to write. 
ioBuffer On input, a pointer to a data buffer containing the bytes to write. 
ioReqCount On input, the number of bytes requested. 
ioActCount On output, the number of bytes actually written. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

The PBWriteAsync function takes ioReqCount bytes from the buffer pointed to by ioBuffer and attempts to write them to the open file whose access path is specified by ioRefNum. The position of the mark is specified by ioPosMode and ioPosOffset. If the write operation completes successfully, PBWriteAsync moves the file mark to the byte following the last byte written and returns noErr.

If you try to write past the logical end-of-file, PBWriteAsync moves the logical end-of-file. If you try to write past the physical end-of-file, PBWriteAsync adds one or more clumps to the file and moves the physical end-of-file accordingly. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for writing to open files.
Declared In
Devices.h*/
OSErr PBWriteAsync (
   ParmBlkPtr paramBlock
){};


/*PBReadAsync

Reads any number of bytes from an open file.

OSErr PBReadAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for an open file to be read. 
ioBuffer On input, a pointer to a data buffer into which the bytes are read. 
ioReqCount On input, the number of bytes requested. The value that you pass in this field should be greater than zero. 
ioActCount On output, the number of bytes actually read. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

This function attempts to read ioReqCount bytes from the open file whose access path is specified in the ioRefNum field and transfer them to the data buffer pointed to by the ioBuffer field. The position of the mark is specified by ioPosMode and ioPosOffset. If your application tries to read past the logical end-of-file, PBReadAsync reads the data, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, PBReadAsync moves the file mark to the byte following the last byte read and returns noErr.

You can specify that PBReadAsync read the file data 1 byte at a time until the requested number of bytes have been read or until the end-of-file is reached. To do so, set bit 7 of the ioPosMode field. Similarly, you can specify that PBReadAsync should stop reading data when it reaches an application-defined newline character. To do so, place the ASCII code of that character into the high-order byte of the ioPosMode field; you must also set bit 7 of that field to enable newline mode.

When reading data in newline mode, PBReadAsync returns the newline character as part of the data read and sets ioActCount to the actual number of bytes placed into the buffer (which includes the newline character). 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadAsync with a value of 0 in the ioReqCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadAsync returns a paramErr error if the value in the ioReqCount field is 0.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Devices.h*/

OSErr PBReadAsync (
   ParmBlkPtr paramBlock
){};


/*PBSetFPosAsync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionAsync instead.)

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. 
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosAsync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosAsync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
){};


/*RmvTime

Remove a task from the Time Manager queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void RmvTime (
QElemPtr tmTaskPtr
);
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/
void RmvTime (
QElemPtr tmTaskPtr
){};


/*InsTime

Installs a task record into the Time Manager task queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void InsTime (
QElemPrt tmTaskPtr
);
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/
void InsTime (
QElemPrt tmTaskPtr
){};



/*PBWriteForkAsync

Writes data to an open fork.

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned. 
forkRefNum 

On input, the reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching. 
positionOffset 

On input, the offset from the base location for the start of the write. 
requestCount 

On input, the number of bytes to write. 
buffer 

A pointer to a buffer containing the data to write. 
actualCount 

On output, the number of bytes actually written. The value in the actualCount field will be equal to the value in the requestCount field unless there was an error during the write operation. 

PBWriteForkAsync writes data starting at the position specified by the positionMode and positionOffset fields. The function attempts to write requestCount bytes from the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
){};


/*PBReadForkAsync

Reads data from an open fork.

void PBReadForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam data type.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned. 
forkRefNum 

On input, the reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read. 
positionOffset 

On input, the offset from the base location for the start of the read. 
requestCount 

On input, the number of bytes to read. The value that you pass in this field should be greater than zero. 
buffer 

A pointer to the buffer where the data will be returned. 
actualCount 

On output, the number of bytes actually read. The value in this field should be equal to the value in the requestCount field unless there was an error during the read operation. 

PBReadForkAsync reads data starting at the position specified by the positionMode and positionOffset fields. The function reads up to requestCount bytes into the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode field and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadForkAsync with a value of 0 in the requestCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadForkAsync returns a paramErr error if the value in the requestCount field is 0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBReadForkAsync (
   FSForkIOParam * paramBlock){};


/*NewIOCompletionUPP

Creates a new universal procedure pointer (UPP) to your completion function.

IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a completion callback function. See IOCompletionProcPtr for a description of the IOCompletionProcPtr data type.
Return Value

A universal procedure pointer to your completion function. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
){};



/*FixRatio

Obtains the Fixed equivalent of a fraction.

Fixed FixRatio (
   short numer,
   short denom
);
Parameters
numer

The numerator of the fraction. 
denom

The denominator of the fraction.
Return Value

The Fixed equivalent of the fraction numer/denom. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed FixRatio (
   short numer,
   short denom
){};


/*OpenComponentResFile

Allows your component to gain access to its resource file. 

short OpenComponentResFile (
   Component aComponent
);
Parameters
aComponent

The component whose resource file you wish to open. Applications that register components may obtain this identifier from the RegisterComponentResource function. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

A reference number that your component can use to read data from the appropriate resource file. If the specified component does not have an associated resource file or if the Component Manager cannot open the resource file, the function returns 0 or a negative number. 
Discussion

This function opens the resource file with read-only permission. The Component Manager adds the resource file to the current resource chain. Your component must close the resource file with the CloseComponentResFile function before returning to the calling application. Note that there is only one resource file associated with a component.

Your component can use FSpOpenResFile or equivalent Resource Manager functions to open other resource files, but you must use this function to open your component’s resource file.

If you store your component in a component resource but register the component with the RegisterComponent function, rather than with the RegisterComponentResource or RegisterComponentResourceFile function, your component cannot access its resource file with this function.

Note that when working with resources, your component should always first save the current resource file, perform any resource operations, then restore the current resource file to its previous value before returning. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
short OpenComponentResFile (
   Component aComponent
){};


/*GetResource

Gets resource data for a resource specified by resource type and resource ID.

Handle GetResource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data. 
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds the specified resource entry in one of the resource maps and the entry contains a valid handle, it returns that handle. If the entry contains a a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, GetResource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and the ResError function returns the result code resNotFound. The GetResource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code. If you call GetResource with a resource type that can’t be found in any of the resource maps of the open resource forks, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the resource maps in memory for the specified resource. The resource maps in memory, which represent all the open resource forks, are arranged as a linked list. When searching this list, the function starts with the current resource file and progresses through the list (that is, searching the resource maps in reverse order of opening) until it finds the resource’s entry in one of the resource maps. 

Before reading the resource data into memory, the Resource Manager calls the Memory Manager to allocate a relocatable block for the resource data. The Memory Manager allocates the block, assigns a master pointer to the block, and returns to the Resource Manager a pointer to the master pointer. The Resource Manager then installs this handle in the resource map. 

You can change the resource map search order by calling the UseResFile function before calling GetResource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps of open resource forks, use the RGetResource function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/


Handle GetResource (
   ResType theType,
   short theID
){};

/*CloseComponentResFile

Closes the resource file that your component opened previously with the OpenComponentResFile function. 

OSErr CloseComponentResFile (
   short refnum
);
Parameters
refnum

The reference number that identifies the resource file to be closed. Your component obtains this value from the OpenComponentResFile function. Your component must close any open resource files before returning to the calling application. 
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

OSErr CloseComponentResFile (
   short refnum
){};

/*GetIndString

Loads a string from a string list ('STR#') resource into memory, given the resource ID of the string list and the index of the individual string. (Deprecated in Mac OS X v10.4. Use CFBundleCopyLocalizedString instead.)

void GetIndString (
   Str255 theString,
   short strListID,
   short index
);
Parameters
theString

On output, the Pascal string result; specifically, a copy of the string from a string list that has the resource ID provided in the strListID parameter. If the resource that you specify cannot be read or the index that you specify is out of range for the string list, GetIndString sets theString to an empty string. 
strListID

The resource ID of the 'STR#' resource that contains the string list. 
index

The index of the string in the list. This is a value from 1 to the number of strings in the list that is referenced by the strListID parameter.
Discussion

If necessary, GetIndString reads the string list from the resource file by calling the Resource Manager function GetResource. GetIndString accesses the string specified by the index parameter and copies it into theString. 
Special Considerations

GetIndString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/
void GetIndString (
   Str255 theString,
   short strListID,
   short index
){};


/*GetComponentInstanceStorage

Allows your component to retrieve a handle to the memory associated with a connection. 

Handle GetComponentInstanceStorage (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection for which to retrieve the associated memory. The Component Manager provides a component instance to your component when the connection is opened. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A handle to the memory associated with the specified connection. 
Discussion

Typically, your component does not need to use this function, because the Component Manager provides this handle to your component each time the client application requests service from this connection.

Your component tells the Component Manager about the memory associated with a connection by calling the SetComponentInstanceStorage function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

Handle GetComponentInstanceStorage (
   ComponentInstance aComponentInstance
){};

/*SetHandleSize

Changes the logical size of the relocatable block corresponding to the specified handle.

void SetHandleSize (
   Handle h,
   Size newSize
);
Parameters
h

A handle to a relocatable block. 
newSize

The desired new logical size, in bytes, of the relocatable block. 
Discussion

SetHandleSize might need to move the relocatable block to obtain enough space for the resized block. Thus, for best results you should unlock a block before resizing it.

An attempt to increase the size of a locked block might fail, because of blocks above and below it that are either nonrelocatable or locked. You should be prepared for this possibility.

Instead of using the SetHandleSize function to set the size of a handle to 0, you can use the EmptyHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because SetHandleSize allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void SetHandleSize (
   Handle h,
   Size newSize
){};



/*NewComponentFunctionUPP


ComponentFunctionUPP NewComponentFunctionUPP (
   ProcPtr userRoutine,
   ProcInfoType procInfo
);
Parameters
procInfo
Return Value

See the description of the ComponentFunctionUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

ComponentFunctionUPP NewComponentFunctionUPP (
   ProcPtr userRoutine,
   ProcInfoType procInfo
){};


/*CallComponentFunction

Invokes the specified function of your component.

long CallComponentFunction (
   ComponentParameters * params,
   ComponentFunctionUPP func
);
Parameters
params

A pointer to the ComponentDescription structure that your component received from the Component Manager. These are the parameters originally provided by the application that called your component. 
func

A universal procedure pointer to the component function that is to handle the request. The Component Manager calls the function referred to by the func parameter, using Pascal calling conventions, with the parameters that were originally provided by the application that called your component. The function referred to by this parameter must return a function result of type ComponentResult indicating the success or failure of the operation. See the ComponentRoutineProcPtr callback for more information on component functions. 
Return Value

The value that is returned by the function referred to by the func parameter. Your component should use this value to set the current error for this connection. You can use the SetComponentInstanceError function to set the current error. 
Discussion

When an application requests service from your component, your component receives a component parameters structure containing the parameters that the application provided when it called your component. Your component can use this structure to access the parameters directly. Alternatively, you can use either this function or CallComponentFunctionWithStorage to extract those parameters and pass them to a subroutine of your component. By taking advantage of these functions, you can simplify the structure of your component code. 

If your component subroutine does not need global data, your component should use this function. If your component subroutine requires memory in which to store global data for the component, your component must use CallComponentFunctionWithStorage. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

long CallComponentFunction (
   ComponentParameters * params,
   ComponentFunctionUPP func
){};

/*DisposeComponentFunctionUPP


void DisposeComponentFunctionUPP (
   ComponentFunctionUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/

void DisposeComponentFunctionUPP (
   ComponentFunctionUPP userUPP
){};


/*CallComponentFunctionWithStorage

Invokes the specified function of your component. 

long CallComponentFunctionWithStorage (
   Handle storage,
   ComponentParameters * params,
   ComponentFunctionUPP func
);
Parameters
storage

A handle to the memory associated with the current connection. The Component Manager provides this handle to your component along with the request. 
params

A pointer to the ComponentParameters structure that your component received from the Component Manager. These are the parameters originally provided by the application that called your component. 
func

A universal procedure pointer to the component function that is to handle the request. The Component Manager calls the function referred to by the func parameter, using Pascal calling conventions, with the parameters that were originally provided by the application that called your component. These parameters are preceded by a handle to the memory associated with the current connection. The function referred to by the func parameter must return a function result of type ComponentResult indicating the success or failure of the operation. See the ComponentRoutineProcPtr callback for more information on component functions. 
Return Value

The value that is returned by the function referred to by the func parameter. Your component should use this value to set the current error for this connection. Use the SetComponentInstanceError function to set the current error for a connection. 
Discussion

When an application requests service from your component, your component receives a component parameters structure containing the parameters that the application provided when it called your component. Your component can use this structure to access the parameters directly. Alternatively, you can use either the CallComponentFunction function or this function to extract those parameters and pass them to a subroutine of your component. By taking advantage of these functions, you can simplify the structure of your component code. 

If your component subroutine requires a handle to the memory associated with the connection, you must use this function. You allocate the memory for a given connection each time your component is opened. You inform the Component Manager that a connection has memory associated with it by calling the SetComponentInstanceError function.

Subroutines of a component that don’t need global data should use CallComponentFunction instead. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long CallComponentFunctionWithStorage (
   Handle storage,
   ComponentParameters * params,
   ComponentFunctionUPP func
){};


/*FSpGetFInfo

Obtains the Finder information for a file. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file. See FSSpec for a description of the FSSpec data type.
fndrInfo

On return, a pointer to information used by the Finder. The FSpGetFInfo function returns the Finder information from the volume catalog entry for the specified file. The function provides only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. For a description of the FInfo structure, see the Finder Interface Reference.
Return Value

A result code. If the specified object is a folder, this function returns fnfErr. For other possible return values, see “File Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
){};

/*CopyCStringToPascal

Converts a C string to a Pascal string. (Deprecated in Mac OS X v10.4. You should store strings as Core Foundation CFStrings instead. See CFString Reference.)

void CopyCStringToPascal (
   const char * src,
   Str255 dst
);
Parameters
src

The C string you want to convert.
dst

On output, the Pascal string.
Discussion

This function allows in-place conversion. That is, the src and dst parameters can point to the memory location.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/

void CopyCStringToPascal (
   const char * src,
   Str255 dst
){};



/*EqualString

Compares two Pascal strings for equality, using the comparison rules of the Macintosh file system. (Deprecated in Mac OS X v10.4. Use CFStringCompare instead.)

Boolean EqualString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
);
Parameters
str1

One of the Pascal strings to be compared. 
str2

The other Pascal string to be compared.
caseSensitive

A flag that indicates how to handle case-sensitive information during the comparison. If the value of caseSens is TRUE, uppercase characters are distinguished from the corresponding lowercase characters. If it is FALSE, case information is ignored. 
diacSensitive

A flag that indicates how to handle information about diacritical marks during the string comparison. If the value of diacSens is TRUE, characters with diacritical marks are distinguished from the corresponding characters without diacritical marks during the comparison. If it is FALSE, diacritical marks are ignored.
Return Value

TRUE if the two strings are equal and FALSE if they are not equal. If its value is TRUE, EqualString distinguishes uppercase characters from the corresponding lowercase characters. If its value is FALSE, EqualString ignores diacritical marks during the comparison. 
Discussion

The comparison is a simple, character-by-character value comparison. This function does not make use of any script or language information (i.e., is not localizable); it assumes the use of a Roman script system. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
StringCompare.h*/

Boolean EqualString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
){};

/*MakeDataExecutable

Notifies the system that the specified data is subject to execution.

void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);
Parameters
baseAddress

The starting address of the data to be flushed.
length

The length of the data pointed to by the baseAddress parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
){};

/*PBReadSync

Reads any number of bytes from an open file.

OSErr PBReadSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a basic File Manager parameter block. 
Return Value

A result code. See “Device Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion On input, a pointer to a completion routine. 
ioResult On output, the result code of the function. 
ioRefNum On input, a file reference number for an open file to be read. 
ioBuffer On input, a pointer to a data buffer into which the bytes are read. 
ioReqCount On input, the number of bytes requested. The value that you pass in this field should be greater than zero. 
ioActCount On output, the number of bytes actually read. 
ioPosMode On input, the positioning mode. 
ioPosOffset On input, the positioning offset. On output, the new position of the mark. 

This function attempts to read ioReqCount bytes from the open file whose access path is specified in the ioRefNum field and transfer them to the data buffer pointed to by the ioBuffer field. The position of the mark is specified by ioPosMode and ioPosOffset. If your application tries to read past the logical end-of-file, PBReadSync reads the data, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, PBReadSync moves the file mark to the byte following the last byte read and returns noErr.

You can specify that PBReadSync read the file data 1 byte at a time until the requested number of bytes have been read or until the end-of-file is reached. To do so, set bit 7 of the ioPosMode field. Similarly, you can specify that PBReadSync should stop reading data when it reaches an application-defined newline character. To do so, place the ASCII code of that character into the high-order byte of the ioPosMode field; you must also set bit 7 of that field to enable newline mode.

When reading data in newline mode, PBReadSync returns the newline character as part of the data read and sets ioActCount to the actual number of bytes placed into the buffer (which includes the newline character). 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadSync with a value of 0 in the ioReqCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadSync returns a paramErr error if the value in the ioReqCount field is 0.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is only supported for reading from open files.
Declared In
Devices.h*/

OSErr PBReadSync (
   ParmBlkPtr paramBlock
){};


/*GetPtrSize

Returns the logical size of the nonrelocatable block corresponding to a pointer.

Size GetPtrSize (
   Ptr p
);
Parameters
p

A pointer to a nonrelocatable block. 
Return Value

The logical size, in bytes, of the nonrelocatable block pointed to by p. In case of error, the function returns 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Size GetPtrSize (
   Ptr p
){};


/*FindSymbol

Searches for a specific exported symbol.

OSErr FindSymbol (
   CFragConnectionID connID,
   ConstStr255Param symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
);
Parameters
connID

A connection ID. 
symName

A symbol name. 
symAddr

On return, a pointer to the address of the symbol whose name is symName. 
symClass

On return, a pointer to the class of the symbol whose name is symName. The currently recognized symbol classes are defined by the “Load Flag, Symbol Class, and Fragment Locator Constants”. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The FindSymbol function searches the code fragment identified by the connID parameter for the symbol whose name is specified by the symName parameter. If that symbol is found, FindSymbol returns the address of the symbol in the symAddr parameter and the class of the symbol in the symClass parameter.

Because a fragment’s code is normally exported through transition vectors to that code, the value kCodeSymbol is not returned in the PowerPC environment. You can use the other two constants to distinguish exports that represent code (of class kTVectSymbol) from those that represent general data (of class kDataSymbol). 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr FindSymbol (
   CFragConnectionID connID,
   ConstStr255Param symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
){};



/*MPTaskIsPreemptive

Determines whether a task is preemptively scheduled. 

Boolean MPTaskIsPreemptive (
   MPTaskID taskID
);
Parameters
taskID

The task you want to check. Pass kMPNoID or kInvalidID if you want to specify the current task. 
Return Value

If true, the task is preemptively scheduled. If false, the task is cooperatively scheduled. 
Discussion

If you have code that may be called from either cooperative or preemptive tasks, that code can call MPTaskIsPreemptive if its actions should differ depending on its execution environment. 

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

Boolean MPTaskIsPreemptive (
   MPTaskID taskID
){};




/*MPCurrentTaskID

Obtains the task ID of the currently-executing preemptive task

MPTaskID MPCurrentTaskID ();
Parameters
Return Value

The task ID of the current preemptive task. See the description of the MPTaskID data type.
Discussion

Returns the ID of the current preemptive task. If called from a cooperative task, this function returns an ID which is different than the ID of any preemptive task. Nonpreemptive processes may or may not have different task IDs for each application; future implementations of this API may behave differently in this regard.

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
MPTaskID MPCurrentTaskID (){};


/*Delay

Delays execture for the specified amount of time.

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);
Parameters
numTicks
finalTicks
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
){};

/*NewCollection

Creates a new, empty collection object.

Collection NewCollection ();
Return Value

A reference to the newly created collection object. The new collection contains no items and has an owner count of 1. The NewCollection function does not return an error code; it returns NULL if it cannot create a new collection object. See the description of the Collection data type.
Discussion

The NewCollection function allocates memory for a new collection object, initializes it, and returns a reference to it. 

To create a copy of an existing collection object, use the CopyCollection function. 
Special Considerations

You are responsible for disposing of collection objects that you create with this function when you no longer need them. To dispose of a collection object, use the DisposeCollection function.
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
Collection NewCollection (){};


/*GetCollectionItem

Obtains a copy of the variable-length data associated with a collection item given the item’s collection tag and collection ID.

OSErr GetCollectionItem (
   Collection c,
   CollectionTag tag,
   SInt32 id,
   SInt32 * itemSize,
   void * itemData
);
Parameters
c

A reference to the collection object containing the item whose data you want to retrieve. The behavior of this function is undefined if you do not provide a reference to a valid collection object. 
tag

The collection tag associated with the item whose data you want to retrieve. 
id

The collection ID associated with the item whose data you want to retrieve. 
itemSize

A pointer to an SInt32 value indicating the number of bytes of data you want returned in the itemData parameter. On return, this value indicates the size in bytes of the variable-length data associated with the specified item. You may specify the constant dontWantSize for this parameter to indicate that you want to copy all the specified item’s variable-length data and you do not want to determine the size of this data. You may specify a value for the itemSize parameter that is greater than the actual number of bytes in the specified item’s variable-length data however, this function never returns in the itemData parameter more data than contained in the specified item’s variable-length data.
itemData

A pointer to a block of memory to contain the item’s data. On return, this memory contains a copy of the data associated with the specified item. You may specify the constant dontWantData for this parameter if you do not want a copy of the item’s data. 
Return Value

A result code. See “Result Codes”.
Discussion

If you do not know the size of the item you want to retrieve, you typically call this function twice. The first time you provide a pointer in the itemSize parameter to determine the size of the specified item’s data and you specify dontWantData for the itemData parameter. Then you allocate a memory block large enough to hold a copy of the item’s data. Then you call the function a second time. This time you specify the constant dontWantSize for the itemSize parameter and provide a pointer to the allocated memory block for the itemData parameter. The function then copies the data into the allocated block of memory.

To retrieve the data associated with a collection item given its collection index (rather than its collection tag and ID), use the GetIndexedCollectionItem function. 
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
OSErr GetCollectionItem (
   Collection c,
   CollectionTag tag,
   SInt32 id,
   SInt32 * itemSize,
   void * itemData
){};

/*DisposeCollection

Disposes of a collection object.

void DisposeCollection (
   Collection c
);
Parameters
c

A reference to the collection object you want to dispose of. The behavior of this function is undefined if you do not provide a reference to a valid collection object. 
Discussion

The DisposeCollection function decrements the owner count of the collection object referenced by the c parameter. If the resulting owner count is 0, this function releases the memory occupied by the collection object, and the collection object reference contained in the c parameter becomes invalid.

To create a new collection object, use the NewCollection function.

To increment the owner count of a collection object, use the CloneCollection function. To determine the owner count of an existing collection object, use the CountCollectionOwners function 
Availability
Available in CarbonLib 1.0 and later when Collections 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Collections.h*/
void DisposeCollection (
   Collection c
){};


/*PBHGetFInfoSync

Obtains information about a file. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a pathname. If the value of the ioFDirIndex field is negative or 0, PBHGetFInfoSync returns information about the file in the volume specified by the reference number in the ioVRefNum field and having the name given here.On output, a pointer to the name of the file, if the file is open. If you do not wish the name returned, pass NULL here. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file, or 0 for the default volume. 
ioFRefNum 

On output, the reference number of the first access path found, if the file is open and if the ioFDirIndex field is negative or 0; if the ioFDirIndex field is positive... 
ioFDirIndex 

On input, a directory index. If this value is positive, the function returns information about the file having the directory index specified here, on the volume specified in the ioVRefNum field and in the directory specified in the ioDirID field.If this value is negative or 0, the function returns information about the file on the specified volume, having the name pointed to in the ioNamePtr field. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for a description of the file attributes. 
ioFlFndrInfo 

On output, Finder information about the file. For a description of the FInfo data type, see the Finder Interface Reference . 
ioDirID 

On input, the parent directory ID of the file. On output, the file’s file ID. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 
ioFlStBlk 

On ouput, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the file’s data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the file’s data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 

You should call PBHGetFInfoSync just before PBHSetFInfoSync , so that the current information is present in the parameter block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
){};


/*HGetState

Returns a signed byte representing the current properties of a relocatable block.

SInt8 HGetState (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

A signed byte (char) containing the flags of the master pointer for the given handle. In case of error, the value returned is meaningless. 
Discussion

The HGetState function returns a signed byte (char) containing the flags of the master pointer for the given handle. You can save this byte, change the state of any of the flags using the functions described in this section, and then restore their original states by passing the byte to the HSetState function.

You can use bit-manipulation functions on the returned signed byte to determine the value of a given attribute. Currently the following bits are used:

If an error occurs during an attempt to get the state flags of the specified relocatable block, HGetState returns the low-order byte of the result code as its function result. For example, if the handle h points to a master pointer whose value is NULL, then the signed byte returned by HGetState will contain the value –109.

You may also call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

SInt8 HGetState (
   Handle h
){};



/*HSetState

Restores the properties of a relocatable block.

void HSetState (
   Handle h,
   SInt8 flags
);
Parameters
h

A handle to a relocatable block. 
flags

A signed byte (char) specifying the properties to which you want to set the relocatable block. 
Discussion

You can use HSetState to restore properties of a block after a call to HGetState. See the description of the HGetState function for a list of the currently used bits in the flags byte. Because additional bits of the flags byte could become significant in future versions of system software, use HSetState only with a byte returned by HGetState. If you need to set two or three properties of a relocatable block at once, it is better to use the functions that set individual properties than to manipulate the bits returned by HGetState and then call HSetState.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HSetState (
   Handle h,
   SInt8 flags
){};


/*FindFolder

Obtains location information for system-related directories.

OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType) on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Directories inside the System Folder are created only if the System Folder directory exists. The FindFolder function will not create a System Folder directory even if you specify the kCreateFolder constant in the createFolder parameter. Passing kCreateFolder will also not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundVRefNum

A pointer to a value of type short. On return, the value specifies the volume reference number for the volume containing the directory specified in the folderType parameter.
foundDirID

A pointer to a value of type long. On return, the value specifies the directory ID number for the directory specified in the folderType parameter. 
Return Value

A result code. See "Folder Manager Result Codes". The result code fnfErr indicates that the type has not been found in the 'fld#' resource, or the disk doesn’t have System Folder support, or the disk does not have desktop database support for Desktop Folder—in all cases, the folder has not been found. The result code dupFNErr indicates that a file has been found instead of a folder.
Discussion

As of Mac OS 8 and later, your application can add folders to the System Folder—or nest folders within other folders—and locate the folders via the FindFolder function. Prior to Mac OS 8, your application could only use FindFolder to find folders that were immediately inside of the System Folder, and a few other special folders such as the Trash folder and the System Folder itself. Now, once a folder (and any folders that it is nested within) is described in a folder descriptor—that is, registered using the function AddFolderDescriptor —your application can use FindFolder to find the folder no matter where it is located.

Those folders you’re most likely to want to access are Preferences and Trash. For example, you might wish to check for the existence of a user’s configuration file in Preferences or, if your application runs out of disk storage when trying to save a file, check how much disk storage is taken by items in the Trash directory and report this to the user.

The specified folder used for a given volume might be located on a different volume; therefore, do not assume the volume that you specify in vRefNum and the volume returned through foundVRefNum will be the same. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
){};


/*MoreMasters

Allocates a block of master pointers in the current heap zone. (Deprecated in Mac OS X v10.4. There is no replacement function; master pointers do not need to be pre-allocated in Mac OS X.)

void MoreMasters ();
Discussion

In the application heap, a block of master pointers consists of 64 master pointers, and in the system heap, a block consists of 32 master pointers. (These values are likely to increase in future versions of system software.) When you initialize additional heap zones, you can specify the number of master pointers you want to have in a block of master pointers.

The Memory Manager automatically calls the MoreMasters function once for every new heap zone, including the application heap zone.

Call MoreMasters several times at the beginning of your program to prevent the Memory Manager from running out of master pointers in the middle of application execution. If it does run out, it allocates more, possibly causing heap fragmentation.

You should call MoreMasters at the beginning of your program enough times to ensure that the Memory Manager never needs to call it for you. For example, if your application never allocates more than 300 relocatable blocks in its heap zone, then five calls to the MoreMasters should be enough. It’s better to call MoreMasters too many times than too few. For instance, if your application usually allocates about 100 relocatable blocks but might allocate 1000 in a particularly busy session, call MoreMasters enough times to accommodate the largest amount.

If you initialize a new zone, you can specify the number of master pointers that a master pointer block should contain.

Call the MemError function to get the result code. See “Memory Manager Result Codes”.

Because MoreMasters allocates memory, you should not call it at interrupt time.

The calls to MoreMasters at the beginning of your application should be in the main code segment of your application or in a segment that the main segment never unloads. 
Carbon Porting Notes

You should instead use MoreMasterPointers.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void MoreMasters (){};


/*TempNewHandle

Allocates a new relocatable block of temporary memory.

Handle TempNewHandle (
   Size logicalSize,
   OSErr * resultCode
);
Parameters
logicalSize

The requested logical size, in bytes, of the new temporary block of memory. 
resultCode

On return, the result code from the function call. See “Memory Manager Result Codes”. 
Return Value

A handle to a block of size logicalSize. If it cannot allocate a block of that size, the function returns NULL. 
Discussion

Before calling TempNewHandle, you should call TempFreeMem or TempMaxMem to make sure that there is enough free space to satisfy the request.

Because TempNewHandle might allocate memory, you should not call it at interrupt time. 
Carbon Porting Notes

Temporary memory allocations will actually come from the applications’s address space in Mac OS X. However, Carbon applications running under Mac OS 8.x will be able to get true temporary memory.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle TempNewHandle (
   Size logicalSize,
   OSErr * resultCode
){};


/*StringToFormatRec

Creates a number format specification string structure from a number format specification string that you supply in a Pascal string. (Deprecated in Mac OS X v10.4. Use CFNumberFormatterSetFormat instead.)

FormatStatus StringToFormatRec (
   ConstStr255Param inString,
   const NumberParts * partsTable,
   NumFormatString * outString
);
Parameters
inString

A Pascal string that contains the number formatting specification.

The inString parameter contains a number format specification string that specifies how numbers appear. This string contains up to three specifications, separated by semicolons. The positive number format is specified first, the negative number format is second, and the zero number format is last. If the string contains only one part, that is the format of all three types of numbers. If the string contains two parts, the first part is the format for positive and zero number values, and the second part is the format for negative numbers.

partsTable

A pointer to a structure, usually obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
outString

On output, a pointer to a NumFormatStringRec structure that contains the values that form the internal representation of the format specification. The format of the data in this structure is private. 
Return Value

A value that denotes the confidence level for the conversion that was performed. The low byte of the value is of type FormatResultType. Be sure to cast the result of StringToFormatRec to a type FormatResultType before working with it. See the description of the FormatStatus data type.
Discussion

StringToFormatRec converts a number format specification string into the internal representation contained in a number format string structure. It uses information in the current script’s tokens resource to determine the components of the number. StringToFormatRec checks the validity both of the input format string and of the number parts table (since this table can be programmed by the application). StringToFormatRec ignores spurious characters.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Special Considerations

StringToFormatRec may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/

FormatStatus StringToFormatRec (
   ConstStr255Param inString,
   const NumberParts * partsTable,
   NumFormatString * outString
){};

/*x80tod


double x80tod (
   const extended80 * x80
);
Parameters
x80
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
double x80tod (
   const extended80 * x80
){};

/*ReleaseResource

Releases the memory a resource occupies when you have finished using it.

void ReleaseResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to release.The function sets the master pointer of the resource’s handle in the resource map in memory to NULL. If your application previously obtained a handle to that resource, the handle is no longer valid. If your application subsequently calls the Resource Manager to get the released resource, the Resource Manager assigns a new handle. 

If the given resource isn’t a handle to a resource, the function does nothing, and the ResError function returns the result code resNotFound. Be aware that ReleaseResource won’t release a resource whose resChanged attribute has been set, but ResError still returns the result code noErr.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Do not use this function to release a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void ReleaseResource (
   Handle theResource
){};

/*GetIntlResourceTable

Obtains a specific word-selection, line-break, number-parts, untoken, or whitespace table from the appropriate international resource. (Deprecated in Mac OS X v10.4. There is no replacement because this function is no longer needed in Mac OS X.)

void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);
Parameters
script

A script code, the value that specifies a particular script system. Constants for all defined script codes are listed in “Meta Script Codes”. 
tableCode

A number that specifies which table is requested. The constants for tableCode are detailed in “Table Selectors”. 
itlHandle

On return, a handle to the string-manipulation ('itl2') or tokens ('itl4') resource containing the table specified in the tableCode parameter. If the script system whose table is requested is not available, GetIntlResourceTable returns a NULL handle. 
offset

On return, a pointer to the offset (in bytes) to the specified table from the beginning of the resource. 
length

On return, a pointer to the size of the table (in bytes).
Discussion

When you provide a script code in the script parameter, and a table code in the tableCode parameter, GetIntlResourceTable returns a handle to the string-manipulation resource or tokens resource containing that table, the offset of the specified table from the beginning of the resource, and the length of the table. 

If you wish to manipulate the contents of the table you have requested, use the size returned in the length parameter to allocate a buffer, and perform a block move of the table’s contents into that buffer. 
Special Considerations

GetIntlResourceTable may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
){};


/*StringToExtended

Converts a string representation of a number into a floating-point number, using a NumFormatStringRec structure to specify how the input number string is formatted. (Deprecated in Mac OS X v10.4. Use CFNumberFormatterCreateStringWithNumber instead.)

FormatStatus StringToExtended (
   ConstStr255Param source,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   extended80 * x
);
Parameters
source

A Pascal string that contains the string representation of a number. 
myCanonical

A pointer to the internal representation of the formatting information for numbers, as produced by the StringToFormatRec function. 
partsTable

A pointer to a structure, obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
x

On output, contains a pointer to the 80-bit SANE representation of the floating-point number. 
Return Value

A value that denotes the confidence level for the conversion that it performed. The low byte of the FormatStatus value is of type FormatResultType. Be sure to cast the result of StringToExtended to a type FormatResultType before working with it. StringToExtended returns an 80-bit, not a 96-bit, representation. See the description of the FormatStatus data type.
Discussion

StringToExtended uses the internal representation of number formatting information that was created by a prior call to StringToFormatRec to parse the input number string. It uses the number parts table to determine the components of the number string that is being converted. StringToExtended parses the string and then converts the string to a simple form, stripping nondigits and replacing the decimal point before converting it into a floating-point number. If the input string does not match any of the patterns, then StringToExtended parses the string as well as it can and returns a confidence level result that indicates the parsing difficulties.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/

FormatStatus StringToExtended (
   ConstStr255Param source,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   extended80 * x
){};


/*ExtendedToString

Converts an internal floating-point representation of a number into a string that can be presented to the user, using a NumFormatStringRec structure to specify how the output number string is formatted (Deprecated in Mac OS X v10.4. Use CFNumberFormatterCreateNumberFromString instead.)

FormatStatus ExtendedToString (
   const extended80 * x,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   Str255 outString
);
Parameters
x

A pointer to a floating-point value in 80-bit SANE representation. 
myCanonical

A pointer to the internal representation of the formatting information for numbers, as produced by the StringToFormatRec function. 
partsTable

A pointer to a structure, obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
outString

On output, contains the number formatted according to the information in myFormatRec. 
Return Value

A value that denotes the confidence level for the conversion that it performed. The low byte of the FormatStatus value is of type FormatResultType. Be sure to cast the result of ExtendedToString to a type FormatResultType before working with it. See the description of the FormatStatus data type.
Discussion

ExtendedToString creates a string representation of a floating-point number, using the formatting information in the myFormatRec parameter (which was created by a previous call to StringToFormatRec) to determine how the number should be formatted for output. It uses the number parts table to determine the component parts of the number string.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
FormatStatus ExtendedToString (
   const extended80 * x,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   Str255 outString
){};

/*dtox80


void dtox80 (
   const double * x,
   extended80 * x80
);
Parameters
x
x80
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
void dtox80 (
   const double * x,
   extended80 * x80
){};


/*FSpCreateResFile

Creates an empty resource fork using a file system specification (FSSpec) record. 

void FSpCreateResFile (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to a file system specification structure that indicates the name and location of the file whose resource fork is to be created. The file system specification record for files and directories is defined by the FSSpec data type.

Certain File Manager functions—those that open a file’s data fork—also take a file system specification record as a parameter. You can use the same FSSpec record in Resource Manager functions that create or open the file’s resource fork. 

If the file specified by the file system specification record doesn’t already exist (that is, if it has neither a data fork nor a resource fork), the function creates a resource file—that is, a resource fork, including a resource map. In this case the file has a zero-length data fork. The function also sets the creator, type, and script code fields of the file’s catalog information record to the specified values. 

If the file specified by the file system specification record already exists and includes a resource fork with a resource map, the function does nothing. If the data fork of the file specified by the file system specification record already exists but the file has a zero-length resource fork, the function creates an empty resource fork and resource map for the file; it also changes the creator, type, and script code fields of the catalog information record of the file to the specified values.

If your application uses Standard File Package functions, note that the StandardPutFile function returns a standard file reply record that contains a file system specification record in the sfFile field.

See the File Manager documentation for a description of the FSSpec data type.
creator

The signature of the application creating the file. Whenever your application creates a document, it assigns a creator and a file type to that document. Typically your application sets its signature as the document’s creator. 
fileType

The file type of the new file. You can set the file type to a type especially defined for your application or one of the existing general types, such as 'TEXT' for text (a stream of ASCII characters), or 'pref' for a preferences file.

The file type should be as descriptive of the file’s data format as possible. You should not use 'TEXT' as a file type unless the document contains plain ASCII characters.
scriptTag

The script code of the script system in which the Finder and standard file dialog boxes display the file’s name. For example, to specify the Roman script system, specify the constant smRoman in the scriptTag parameter. 
Discussion

Don’t use the resource fork of a file for data that is not in resource format. The Resource Manager assumes that any information in a resource fork can be interpreted according to the standard resource format described in this chapter. 

The File Manager assumes that the first block of a file’s resource fork is part of the resource header and puts information there that it uses during scavenging—for example, after the user presses the Reset switch. For this reason, if you copy a resource file, the duplicate may not be exactly like the original. 

This function is available only in System 7 and later versions of system software. If FSpCreateResFile is not available to your application, you can use the CreateResFile function or the HCreateResFile function. The HCreateResFile function is preferred over CreateResFile, which is an earlier version of HCreateResFile that is still supported but has more restricted capabilities.

Before you can work with the newly created file’s resource fork, you must use the FSpOpenResFile function to open it.

To check for errors, call the ResError function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void FSpCreateResFile (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
){};

/*GetScriptManagerVariable

Retrieves the value of the specified Script Manager variable.

long GetScriptManagerVariable (
   short selector
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you need, use one of the selector constants listed in “Script Manager Selectors”. 
Return Value

The current value of the specified Script Manager variable or 0 if the selector is invalid. For some valid selectors, 0 may also be a valid return value. For example, when you call GetScriptManagerVariable with a selector value of smRegionCode on a version of Macintosh system software that has been localized for the United States, it returns 0. Although GetScriptManagerVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptManagerVariable; the remaining bytes are set to 0.
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/


long GetScriptManagerVariable (
   short selector
){};



/*PBCreateFileIDRefSync

Establishes a file ID reference for a file.

OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.PBCreateFileIDRefSync returns the result code fidExists if a file ID reference already exists for the file.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

Given a volume reference number, filename, and parent directory ID, the PBCreateFileIDRefSync function creates a structure to hold the name and parent directory ID of the specified file. The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the file’s name. 
ioVRefNum 

On input, a volume reference number for the volume containing the file. 
ioSrcDirID 

On input, the file’s parent directory ID. 
ioFileID 

On output, a file ID. If a file ID reference already exists for the file, PBCreateFileIDRefSync supplies the file ID but returns the result code fidExists. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
){};

/*MoveHHi

Moves a relocatable block as high in memory as possible. (Deprecated in Mac OS X v10.4. There is no replacement function; there is no benefit to moving handles high in memory in Mac OS X.)

void MoveHHi (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

This function moves a relocatable block as high in memory as possible to help prevent heap fragmentation. The MoveHHi function attempts to move the relocatable block referenced by the handle h upward until it reaches a nonrelocatable block, a locked relocatable block, or the top of the heap.

If you plan to lock a relocatable block for a short period of time, use the MoveHHi function, which moves the block to the top of the heap and thus helps prevent heap fragmentation.

If you call MoveHHi to move a handle to a resource that has its resChanged bit set, the Resource Manager updates the resource by using the WriteResource function to write the contents of the block to disk. If you want to avoid this behavior, call the Resource Manager function SetResPurge(FALSE) before you call MoveHHi, and then call SetResPurge(TRUE) to restore the default setting.

By using the MoveHHi function on relocatable blocks you plan to allocate for short periods of time, you help prevent islands of immovable memory from accumulating in (and thus fragmenting) the heap.

Do not use the MoveHHi function to move blocks you plan to lock for long periods of time. The MoveHHi function moves such blocks to the top of the heap, perhaps preventing other blocks already at the top of the heap from moving down once they are unlocked. Instead, use the ReserveMem function before allocating such blocks, thus keeping them in the bottom partition of the heap, where they do not prevent relocatable blocks from moving.

If you frequently lock a block for short periods of time and find that calling MoveHHi each time slows down your application, you might consider leaving the block always locked and calling the ReserveMem function before allocating it.

Once you move a block to the top of the heap, be sure to lock it if you do not want the Memory Manager to move it back to the middle partition as soon as it can. (The MoveHHi function cannot move locked blocks; be sure to lock blocks after, not before, calling MoveHHi.)

Using the MoveHHi function without taking other precautionary measures to prevent heap fragmentation is useless, because even one small nonrelocatable or locked relocatable block in the middle of the heap might prevent MoveHHi from moving blocks to the top of the heap.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void MoveHHi (
   Handle h
){};


/*Fix2Long

Converts a Fixed number to a LongInt number.

long Fix2Long (
   Fixed x
);
Parameters
x

The Fixed number to be converted to a long integer. 
Return Value

The long integer nearest to the Fixed number x. If x is halfway between two integers (0.5), it is rounded to the integer with the higher absolute value. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

long Fix2Long (
   Fixed x
){};


/*FSpRename

Renames a file or directory. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to rename. See FSSpec for a description of the FSSpec data type.
newName

The new name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If a file ID reference for the specified file exists, it remains with the renamed file.

If you want to change the name of a new copy of an existing file, you should use the FSpExchangeFiles function instead. To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
){};


/*HLockHi

Sets the lock bit on the block.

void HLockHi (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HLockHi function is an alternative to using the two functions MoveHHi (deprecated in Mac OS X) and HLock. Because the MoveHHi function does not move memory in Mac OS X, there is no benefit to using this function.

This function will not return a meaningful error code. If you call HLockHi on a locked handle, it will return noErr (not memLockedErr) because it is not an error to call HLock on a locked handle. 

Do not call HLockHi on blocks in the system heap. Do not call HLockHi from a desk accessory. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HLockHi (
   Handle h
){};



/*EndianU32_BtoN

Converts an unsigned 32-bit big-endian value to the equivalent value in the computer’s native format.

UInt32 EndianU32_BtoN (
   UInt32    value
);
Parameters
value

An unsigned 32-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_BtoN (
   UInt32    value
){};



/*EndianS16_BtoN

Converts a signed 16-bit big-endian value to the equivalent value in the computer’s native format.

SInt16 EndianS16_BtoN (
   SInt16    value
);
Parameters
value

A signed 16-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt16 EndianS16_BtoN (
   SInt16    value
){};

/*EndianS32_BtoN

Converts a signed 32-bit big-endian value to the equivalent value in the computer’s native format.

SInt32 EndianS32_BtoN (
   SInt32    value
);
Parameters
value

A signed 32-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

SInt32 EndianS32_BtoN (
   SInt32    value
){};


/*SetPtrSize

Changes the logical size of the nonrelocatable block corresponding to a pointer.

void SetPtrSize (
   Ptr p,
   Size newSize
);
Parameters
p

A pointer to a nonrelocatable block. 
newSize

The desired new logical size, in bytes, of the nonrelocatable block. 
Discussion

An attempt to increase the size of a nonrelocatable block might fail because of a block above it that is either nonrelocatable or locked. You should be prepared for this possibility.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because SetPtrSize allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void SetPtrSize (
   Ptr p,
   Size newSize
){};

/*CurResFile

Gets the file reference number of the current resource file.

short CurResFile ();
Return Value

The file reference number associated with the current resource file. You can call this function when your application starts up (before opening the resource fork of any other file) to get the file reference number of your application’s resource fork. If the current resource file is the System file, the function returns the actual file reference number. You can use this number or 0 with functions that take a file reference number for the System file. All Resource Manager functions recognize both 0 and the actual file reference number as referring to the System file.
Discussion

Most of the Resource Manager functions assume that the current resource file is the file on whose resource fork they should operate or, in the case of a search, the file where they should begin. In general, the current resource file is the last one whose resource fork your application opened unless you specify otherwise.

To check for errors, call the ResError function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short CurResFile (){};


/*HGetVol

Determines the current default volume and default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);
Parameters
volName

On return, a pointer to the name of the default volume. If you do not want the name of the default volume returned, set this parameter to NULL. 
vRefNum

On return, a pointer to the volume reference number of the default volume. 
dirID

On return, a pointer to the directory ID of the default directory. 
Return Value

A result code. See “File Manager Result Codes”.
Version Notes

When CarbonLib is not present, the HGetVol function returns a working directory reference number in the vRefNum parameter if the previous call to HSetVol (or one of the corresponding parameter block calls) passed in a working directory reference number.
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
){};



/*SetCurrentA5

Sets the value in register A5 to the value of the low-memory global variable CurrentA5. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetCurrentA5 ();
Return Value

The value in the A5 register before SetCurrentA5 changes it to the value of the low-memory global variable CurrentA5. 
Discussion

The CurrentA5 variable points to the boundary between the parameters and global variables of the current application.

You cannot reliably call SetCurrentA5 in code that executes at interrupt time unless you first guarantee that your application is the current process (for example, by calling the Process Manager function GetCurrentProcess). In general, you should call SetCurrentA5 at noninterrupt time and then pass the returned value to the interrupt code. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
long SetCurrentA5 (){};


/*GZSaveHnd

Returns a relocatable block to be protected during grow-zone operations. (Deprecated in Mac OS X v10.4. There is no replacement; this function does nothing in Mac OS X.)

Handle GZSaveHnd ();
Return Value

A handle to a block of memory that the Memory Manager reserves during grow-zone operations. Your grow-zone function must not move, purge, or delete this block. This function returns NULL if there is no such block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
Handle GZSaveHnd (){};


/*EmptyHandle

Purges a relocatable block and sets the corresponding handle’s master pointer to NULL.

void EmptyHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The EmptyHandle function purges the relocatable block whose handle is h and sets the handle’s master pointer to NULL. The EmptyHandle function allows you to free memory taken by a relocatable block without freeing the relocatable block’s master pointer for other uses. The block whose handle is h must be unlocked but need not be purgeable.

Note that if there are multiple handles to the relocatable block, then calling the EmptyHandle function empties them all, because all of the handles share a common master pointer. When you later use ReallocateHandle to reallocate space for the block, the master pointer is updated, and all of the handles reference the new block correctly.

To purge all of the blocks in a heap zone that are marked purgeable, use the PurgeMem function.

To free the memory taken up by a relocatable block and release the block’s master pointer for other uses, use the DisposeHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void EmptyHandle (
   Handle h
){};


/*SetA5

Sets the A5 register to the address specified. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetA5 (
   long newA5
);
Parameters
newA5

The value to which the A5 register is to be changed. 
Return Value

The value in the A5 register before SetA5 changes it to newA5. 
Discussion

In interrupt code that accesses application global variables, use the SetA5 function first to restore a value previously saved using SetCurrentA5, and then, at the end of the code, to restore the A5 register to the value it had before the first call to SetA5. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/

long SetA5 (
   long newA5
){};



/*DisposeGrowZoneUPP

(Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

void DisposeGrowZoneUPP (
   GrowZoneUPP userUPP
);
Parameters
userUPP
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void DisposeGrowZoneUPP (
   GrowZoneUPP userUPP
){};


/*FixMul

Multiplies a variable of type Fixed with another variable of type Fixed or with a variable of type Fract or LongInt.

Fixed FixMul (
   Fixed a,
   Fixed b
);
Parameters
a

The first operand, which can be a variable of type Fixed or a variable of type Fract or LongInt. 
b

The second operand, which can be a variable of type Fixed or a variable of type Fract or LongInt.
Return Value

The product of the numbers in a and b. At least one of a and b should be a variable of type Fixed. 

The returned value is in the format of a LongInt if one of a or b is a LongInt. It is a Fract number if one of a or b is Fract. It is a Fixed number if both a and b are Fixed numbers.

Overflows are set to the maximum representable value with the correct sign ($80000000 for negative results and $7FFFFFFF for positive results).

Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed FixMul (
   Fixed a,
   Fixed b
){};



/*EndianU16_BtoN

Converts an unsigned 16-bit big-endian value to the equivalent value in the computer’s native format.

UInt16 EndianU16_BtoN (
   UInt16    value
);
Parameters
value

An unsigned 16-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt16 EndianU16_BtoN (
   UInt16    value
){};


/*EndianU16_NtoB

Converts an unsigned 16-bit value in the computer’s native format to the equivalent big-endian value.

UInt16 EndianU16_NtoB (
   UInt16    value
);
Parameters
value

An unsigned 16-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt16 EndianU16_NtoB (
   UInt16    value
){};



/*FSpOpenRF

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose resource fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s resource fork. For a description of the types of access you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open resource fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSpOpenRF will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenRF is not available, you can use the function HOpenRF instead. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenRF function, you will receive an error message. 
Special Considerations

Generally, your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The FSpOpenRF function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork. 

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
){};


/*HandToHand

Copies all of the data from one relocatable block to a new relocatable block.

OSErr HandToHand (
   Handle * theHndl
);
Parameters
theHndl

A handle to the relocatable block whose data HandToHand will copy. On return, theHndl contains a handle to a new relocatable block whose data duplicates the original. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The HandToHand function attempts to copy the information in the relocatable block to which theHndl is a handle; if successful, HandToHand sets theHndl to a handle pointing to the new relocatable block.

If successful in creating a new relocatable block, the HandToHand function does not duplicate the properties of the original block. The new block is unlocked, unpurgeable, and not a resource. Call HLock, HPurge, or HSetRBit (or the combination of HGetState and HSetState) to adjust the properties of the new block.

To copy only part of a relocatable block into a new relocatable block, use the PtrToHand function. Before calling PtrToHand, lock and dereference the handle pointing to the relocatable block you want to copy.

Because HandToHand replaces its parameter with the new handle, you should retain the original parameter value somewhere else, otherwise you will not be able to access it. Here is an example:Handle original, copy;
OSErr myErr;
...
copy = original;
        /both handles access same block*
myErr = HandToHand(copy);
        /copy now points to copy of block*


Because HandToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr HandToHand (
   Handle * theHndl
){};


/*FixRound

Rounds a fixed-point number to the nearest integer.

short FixRound (
   Fixed x
);
Parameters
x

The Fixed number to be rounded. 
Return Value

The Integer number nearest the Fixed number x. If the value is halfway between two integers (0.5), it is rounded up. Thus, 4.5 is rounded to 5, and –3.5 is rounded to –3. 
Discussion

To round a negative Fixed number so that values halfway between two integers are rounded to the number with the higher absolute value, negate the number, round it, and then negate it again. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
short FixRound (
   Fixed x
){};


/*FlushVol

Writes the contents of the volume buffer and update information about the volume.

OSErr FlushVol (
   ConstStr63Param volName,
   short vRefNum
);
Parameters
volName

The name of the mounted volume to flush. 
vRefNum

The volume reference number, drive number, or 0 for the default volume. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the specified volume, the FlushVol function writes the contents of the associated volume buffer and descriptive information about the volume. Information which has changed since the last time FlushVol was called is written to the volume. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FlushVol (
   ConstStr63Param volName,
   short vRefNum
){};

/*HPurge

Marks a relocatable block as purgeable. (Deprecated in Mac OS X v10.4. There is no replacement function; heaps are never purged in Mac OS X.)

void HPurge (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HPurge function marks the relocatable block, to which h is a handle, as purgeable. If the block is already purgeable, HPurge does nothing.

The Memory Manager might purge the block when it needs to purge the heap zone containing the block to satisfy a memory request. A direct call to the MaxMem function would also purge blocks marked as purgeable.

Once you mark a relocatable block as purgeable, you should make sure that handles to the block are not empty before you access the block. If they are empty, you must reallocate space for the block and recopy the block’s data from another source, such as a resource file, before using the information in the block.

If the block to which h is a handle is locked, HPurge does not unlock the block but does mark it as purgeable. If you later call HUnlock on h, the block is subject to purging.

If the Memory Manager has purged a block, you can reallocate space for it by using the ReallocateHandle function.

You can immediately free the space taken by a handle without disposing of it by calling the function EmptyHandle. This function does not require that the block be purgeable.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void HPurge (
   Handle h
){};


/*HNoPurge

Marks a relocatable block as unpurgeable. (Deprecated in Mac OS X v10.4. There is no replacement function; heaps are never purged in Mac OS X.)

void HNoPurge (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HNoPurge function marks the relocatable block, to which h is a handle, as unpurgeable. If the block is already unpurgeable, HNoPurge does nothing.

The HNoPurge function does not reallocate memory for a handle if it has already been purged.

If you want to reallocate memory for a relocatable block that has already been purged, you can use the ReallocateHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void HNoPurge (
   Handle h
){};



/*UCConvertUTCDateTimeToCFAbsoluteTime

Converts a value of type UTCDateTime time to CFAbsoluteTime.

OSStatus UCConvertUTCDateTimeToCFAbsoluteTime (
   const UTCDateTime * iUTCDate,
   CFAbsoluteTime * oCFTime
);
Parameters
iUTCDate

A pointer to a UTCDateTime structure that represents the time from which you wish to convert. 
oCFTime

A pointer to a CFAbsoluteTime. On successful return, this contains the converted time from the input time type. 
Return Value

A result code. See “Date, Time, and Measurement Utilities Result Codes”.
Discussion

Use UCConvertUTCDateTimeToCFAbsoluteTime to convert from a UTCDDateTime to a CFAbsoluteTime. Remember that the epoch for UTCDateTime is January 1, 1904 while the epoch for CFAbsoluteTime is January 1, 2001.
Availability
Available in Mac OS X v10.2 and later.
Declared In
DateTimeUtils.h*/
OSStatus UCConvertUTCDateTimeToCFAbsoluteTime (
   const UTCDateTime * iUTCDate,
   CFAbsoluteTime * oCFTime
){};

/*FSCopyAliasInfo

Returns information from an alias handle.

OSStatus FSCopyAliasInfo (
   AliasHandle inAlias,
   HFSUniStr255 * targetName,
   HFSUniStr255 * volumeName,
   CFStringRef * pathString,
   FSAliasInfoBitmap * whichInfo,
   FSAliasInfo * info
);
Parameters
inAlias

A handle to the alias record to get information from.
targetName

A pointer to a string that, on return, contains the name of the target item. Pass NULL if you do not want this information returned.
volumeName

A pointer to a string that, on return, contains the name of the volume the target resides on. Pass NULL if you do not want this information returned.
pathString

A pointer a CFString that, on return, contains the POSIX path to the target. Pass NULL if you do not want this information returned.
whichInfo

A pointer to a variable of type FSAliasInfoBitmap. On return, this field indicates which fields in the alias information block, specified in the info parameter, contain valid data. See “Alias Information Masks” for a description of the values that may be returned here. This parameter may be NULL.
info

A pointer to a structure of type FSAliasInfo. On return, this structure contains information about the alias. Pass NULL if you do not want this information returned.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

This function returns the requested information from the alias handle passed in the inAlias parameter. The information is gathered only from the alias record, so it may not match what is on disk. No disk i/o is performed.

The FSCopyAliasInfo function adds support for unicode filenames and filenames longer than 32 bytes. It replaces the GetAliasInfo function. 
Availability
Not available in CarbonLib.
Available in Mac OS X version 10.2 and later.
Declared In
Aliases.h*/

OSStatus FSCopyAliasInfo (
   AliasHandle inAlias,
   HFSUniStr255 * targetName,
   HFSUniStr255 * volumeName,
   CFStringRef * pathString,
   FSAliasInfoBitmap * whichInfo,
   FSAliasInfo * info
){};

/*GetAliasInfo

Gets information from an alias record without actually resolving the record. (Deprecated in Mac OS X v10.3. Use FSCopyAliasInfo instead.)

Not Recommended

OSErr GetAliasInfo (
   AliasHandle alias,
   AliasInfoType index,
   Str63 theString
);
Parameters
alias

A handle to the alias record to be read.
index

The kind of information to be retrieved. If the value of index is a positive integer, GetAliasInfo retrieves the parent directory that has the same hierarchical level above the target as the index parameter (for example, an index value of 2 returns the name of the parent directory of the target’s parent directory). You can therefore assemble the names of the target and all of its parent directories by making repeated calls to GetAliasInfo with incrementing index values, starting with a value of 0. When the value of index is greater than the number of levels between the target and the root, GetAliasInfo returns an empty string. You can also set the index parameter to one of the values described in “Information Type Constants”.
theString

A string that, on return, holds the requested information.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The GetAliasInfo function returns the information stored in the alias record, which might not be current. To ensure that the information is current, you can resolve and update the alias record before calling GetAliasInfo.

The GetAliasInfo function cannot provide all kinds of information about a minimal alias. 
Special Considerations

Use the FSCopyAliasInfo function instead of GetAliasInfo. GetAliasInfo does not reliably return information for aliases to items on POSIX file systems. In addition, GetAliasInfo does not support unicode names or names longer than 32 bytes. If the name of the alias target is longer than 32 bytes, the name is truncated and the file ID and extension (if any) are appended before the name is returned by GetAliasInfo.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
Aliases.h*/

OSErr GetAliasInfo (
   AliasHandle alias,
   AliasInfoType index,
   Str63 theString
){};


/*PBGetVolMountInfoSize

Determines how much space to allocate for a volume mounting information structure.

OSErr PBGetVolMountInfoSize (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname 
ioVRefNum 

On input, a volume specification. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to storage for the size information, which is of type Integer (2 bytes). If PBGetVolMountInfoSize returns noErr, that integer contains the size of the volume mounting information structure on output. 

You should call this function before you call PBGetVolMountInfo , to obtain the size of the volume mounting information for which you must allocate storage. Then call PBGetVolMountInfo to retrieve the actual volume mounting information. 
Special Considerations

This function executes synchronously. You should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBGetVolMountInfoSize (
   ParmBlkPtr paramBlock
){};


/*PBGetVolMountInfo

Retrieves a record containing all the information needed to mount a volume, except for passwords.

OSErr PBGetVolMountInfo (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname 
ioVRefNum 

On input, a volume specification. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a buffer to hold the mounting information. The length of the buffer is specified by the value pointed to by the ioBuffer field in a previous call to PBGetVolMountInfoSize. On output, the mounting information for the specified volume. You can later pass this structure to the PBVolumeMount function to mount the volume.The mounting information for an AppleShare volume is stored as an AFP mounting record. The PBGetVolMountInfo function does not return the user password or volume password in the AFPVolMountInfo structure. Your application should solicit these passwords from the user and fill in the structure before attempting to mount the remote volume. 

This function allows your application to record the mounting information for a volume and then to mount the volume later. This programmatic mounting function stores the mounting information in a structure called the AFPVolMountInfo structure. 
Special Considerations

This function executes synchronously. You should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBGetVolMountInfo (
   ParmBlkPtr paramBlock
){};


/*FSCopyDiskIDForVolume

Returns a copy of the disk ID for a volume.

OSStatus FSCopyDiskIDForVolume (
   FSVolumeRefNum vRefNum,
   CFStringRef * diskID
);
Parameters
vRefNum

The volume reference number of the target volume. 
diskID

On return, a pointer to the disk ID string associated with the target volume. 
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCopyDiskIDForVolume (
   FSVolumeRefNum vRefNum,
   CFStringRef * diskID
){};

/*NewGrowZoneUPP

(Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

GrowZoneUPP NewGrowZoneUPP (
   GrowZoneProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the GrowZoneUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

GrowZoneUPP NewGrowZoneUPP (
   GrowZoneProcPtr userRoutine
){};

/*SetGrowZone

Specifies the current heap zone’s grow-zone function. (Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

void SetGrowZone (
   GrowZoneUPP growZone
);
Parameters
growZone

A pointer to the grow-zone function. A NULL value removes any previous grow-zone function from the zone. 
Discussion

To specify a grow-zone function for the current heap zone, pass a pointer to that function to the SetGrowZone function. Usually you call this function early in the execution of your application.

If you initialize your own heap zones besides the application and system zones, you can alternatively specify a grow-zone function as a parameter to the InitZone function.

The Memory Manager calls the grow-zone function only after exhausting all other avenues of satisfying a memory request, including compacting the zone, increasing its size (if it is the original application zone and is not yet at its maximum size), and purging blocks from it.

See “Grow-Zone Operations” for a complete description of a grow-zone function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void SetGrowZone (
   GrowZoneUPP growZone
){};


/*ReallocateHandle

Allocates a new relocatable block of a specified size and sets a handle’s master pointer to point to the new block.

void ReallocateHandle (
   Handle h,
   Size byteCount
);
Parameters
h

A handle to a relocatable block. 
byteCount

The desired new logical size (in bytes) of the relocatable block. The new block is unlocked and unpurgeable. 
Discussion

Usually you use ReallocateHandle to reallocate space for a block that you have emptied or the Memory Manager has purged. If the handle references an existing block, ReallocateHandle releases that block before creating a new one.

If many handles reference a single purged, relocatable block, you need to call ReallocateHandle on just one of them.

To reallocate space for a resource that has been purged, you should call LoadResource, not ReallocateHandle. To resize relocatable blocks, you should call the SetHandleSize function.

Currently in Mac OS 8 and 9, the ReallocateHandle function releases any existing relocatable block referenced by the handle h before allocating a new one. This behavior means that if an error occurs when calling ReallocateHandle, the handle h will be set to NULL. This behavior does not occur in the Mac OS X implementation. 

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because ReallocateHandle might purge and allocate memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void ReallocateHandle (
   Handle h,
   Size byteCount
){};


/*Accessing Heap Zones
pascal THz GetZone		(void);
pascal void SetZone		(THz hz);
#define ApplicationZone() 	(* (THz*) 0x02AA)
#define SystemZone() 		(* (THz*) 0x02A6)
pascal THz HandleZone		(Handle h);
pascal THz PtrZone		(Ptr p);*/
pascal THz GetZone		(void){};
pascal void SetZone		(THz hz){};
pascal THz HandleZone		(Handle h){};
pascal THz PtrZone		(Ptr p){};



/*Allocating and Releasing Relocatable Blocks of Memory
pascal Handle NewHandle		(Size byteCount);
pascal Handle NewHandleSys	(Size byteCount);
pascal Handle NewHandleClear	(Size byteCount);
pascal Handle NewHandleSysClear
   				(Size byteCount);
pascal Handle NewEmptyHandle	(void);
pascal Handle NewEmptyHandleSys
   				(void);
pascal void DisposeHandle	(Handle h);*/
pascal Handle NewHandleSys	(Size byteCount){};
pascal Handle NewEmptyHandleSys
   				(void){};



/*MacLoadResource

Gets resource data after you’ve called the SetResLoad function with the load parameter set to FALSE or when the resource is purgeable.

void MacLoadResource (
   Handle theResource
);
Parameters
theResource

A handle to a resource. Given this handle, the function reads the resource data into memory. If the resource is already in memory, or if the this parameter doesn’t contain a handle to a resource, then the function does nothing. To determine whether either of these situations occurred, call the ResError function. If the resource is already in memory, ResError returns noErr; if the handle is not a handle to a resource, ResError returns resNotFound.
Discussion

If you’ve changed the resource data for a purgeable resource and the resource is purged before being written to the file, the changes will be lost. In this case, this function rereads the original resource from the file’s resource fork. You should use the ChangedResource or SetResPurge function before calling LoadResource to ensure that changes made to purgeable resources are written to the resource fork.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void MacLoadResource (
   Handle theResource
){};


/*CountComponentInstances

Determines the number of open connections being managed by a specified component. 

long CountComponentInstances (
   Component aComponent
);
Parameters
aComponent

The component for which you want a count of open connections. You can use a component instance here, but you must coerce the data type appropriately. 
Return Value

The number of open connections for the specified component. 
Discussion

This function can be useful if you want to restrict the number of connections for your component or if your component needs to perform special processing based on the number of open connections. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
long CountComponentInstances (
   Component aComponent
){};

/*Changing the Addressing Mode
pascal char GetMMUMode		(void);
pascal void SwapMMUMode		(char *mode);*/
pascal char GetMMUMode		(void){};
pascal void SwapMMUMode		(char *mode){};


/*FixDiv

Divides two variables of the same type (Fixed, Fract, or LongInt) or to divide a LongInt or Fract number by a Fixed number.

Fixed FixDiv (
   Fixed x,
   Fixed y
);
Parameters
x

The first operand, which can be a variable of type Fixed or a variable of type Fract or LongInt. 
y

The second operand, which can be a variable of type Fixed or it can be a variable of the same type as the variable in parameter x.
Return Value

The quotient of the numbers in x and y. If the y parameter is in the format of a Fixed number, then the x parameter can be in the format of a Fixed, Fract, or LongInt number. If the y parameter is in the format of a Fract or LongInt number, then the x parameter must be in the same format. 

The returned value is in the format of a Fixed number if both x and y are both Fixed numbers, both Fract numbers, or both LongInt numbers. Otherwise, the returned value is the same type as the number in the x parameter.

Division by zero results in $8000000 if x is negative, and $7FFFFFFF otherwise; thus the special case 0/0 yields $7FFFFFFF.

Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed FixDiv (
   Fixed x,
   Fixed y
){};

/*FSRenameUnicode

Renames a file or folder.

OSErr FSRenameUnicode (
   const FSRef * ref,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
ref

A pointer to an FSRef for the file or directory to rename. See FSRef for a description of the FSRef data type.
nameLength

The length of the new name in Unicode characters. 
name

A pointer to the new Unicode name of the file or directory. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, a pointer to the new FSRef for the file or directory. This parameter is optional; if you do not wish the FSRef returned, pass NULL.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because renaming an object may change its FSRef, you should pass a non- NULL pointer in the newRef parameter and use the FSRef returned there to access the object after the renaming, if you wish to continue to refer to the object. The FSRef passed in the ref parameter may or may not be usable after the object is renamed. The FSRef returned in the newRef parameter may point to the same storage as the FSRef passed in ref. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSRenameUnicode (
   const FSRef * ref,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
){};


/*FSIterateForks

Determines the name and size of every named fork belonging to a file or directory.

OSErr FSIterateForks (
   const FSRef * ref,
   CatPositionRec * forkIterator,
   HFSUniStr255 * forkName,
   SInt64 * forkSize,
   UInt64 * forkPhysicalSize
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to iterate. See FSRef for a description of the FSRef data type.
forkIterator

A pointer to a structure which maintains state between calls to FSIterateForks. Before the first call, set the initialize field of the structure to 0. The fork iterator will be updated after the call completes; the updated iterator should be passed into the next call. See CatPositionRec for a description of the CatPositionRec data type.
forkName

On return, a pointer to the Unicode name of the fork. This parameter is optional; if you do not wish the name returned, pass a NULL pointer. See HFSUniStr255 for a description of the HFSUniStr255 data type.
forkSize

On return, a pointer to the logical size of the fork, in bytes. This parameter is optional; if you do not wish to retrieve the logical fork size, pass a NULL pointer. 
forkPhysicalSize

On return, a pointer to the physical size of the fork (that is, to the amount of space allocated on disk), in bytes. This parameter is optional; if you do not wish to retrieve the physical fork size, pass a NULL pointer. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Since information is returned about one fork at a time, several calls may be required to iterate through all the forks. There is no guarantee about the order in which forks are returned; the order may vary between iterations. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSIterateForks (
   const FSRef * ref,
   CatPositionRec * forkIterator,
   HFSUniStr255 * forkName,
   SInt64 * forkSize,
   UInt64 * forkPhysicalSize
){};

/*PBHCopyFileSync

Duplicates a file and optionally renames it.

OSErr PBHCopyFileSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a CopyParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the source file. 
ioVRefNum 

On input, the volume reference number or drive number for the volume containing the source file. Pass 0 for the default volume. 
ioDstVRefNum 

On input, the reference number or drive number of the destination volume. Pass 0 for the default volume. 
ioNewName 

On input, a pointer to the partial pathname for the destination directory. If ioNewName is NULL, the destination directory is the directory having the ID specified in the ioNewDirID field. 
ioCopyName 

On input, a pointer to the file’s new name. The string pointed to by this field must be a filename, not a partial pathname. If you do not wish to rename the file, pass NULL in this field. 
ioNewDirID 

On input, if the ioNewName field is NULL, the directory ID of the destination directory. If ioNewName is not NULL, the parent directory ID of the destination directory. 
ioDirID 

On input, the directory ID of the source directory. 

This function is especially useful when you want to copy or move files located on a remote volume, because it allows you to forgo transmitting large amounts of data across a network. This function is used internally by the Finder; most applications do not need to use it. 
Special Considerations

This is an optional call for AppleShare file servers. Your application should examine the information returned by the PBHGetVolParmsSync function to see if the volume supports PBHCopyFileSync. If the bHasCopyFile bit is set in the vMAttrib field of the GetVolParmsInfoBuffer structure, then the volume supports PBHCopyFileSync.

For AppleShare file servers, the source and destination pathnames must indicate the same file server; however, the parameter block may specify different source and destination volumes on that file server. A useful way to tell if two file server volumes are on the same file server is to call the PBHGetVolParmsSync function for each volume and compare the server addresses returned. The server opens source files with read/deny write enabled and destination files with write/deny read and write enabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHCopyFileSync (
   HParmBlkPtr paramBlock
){};

/*PBHGetDirAccessSync

Returns the access control information for a directory or file.

OSErr PBHGetDirAccessSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname for the directory or file. 
ioVRefNum 

On input, a volume specification for the volume containing the directory or file. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioACOwnerID 

On output, the user ID for the owner of the directory or file. 
ioACGroupID 

On output, the primary group ID of the directory or file. 
ioACAccess 

On output, the access rights for the directory or file. See File and Folder Access Privilege Constants for more information on these access rights.
ioDirID 

On input, the directory ID. 
Version Notes

On Mac OS 8 and 9, PBHGetDirAccessSync only returns access information for directories; you cannot use it to return information for files.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHGetDirAccessSync (
   HParmBlkPtr paramBlock
){};



/*FSAllocateFork

Allocates space on a volume to an open fork.

OSErr FSAllocateFork (
   SInt16 forkRefNum,
   FSAllocationFlags flags,
   UInt16 positionMode,
   SInt64 positionOffset,
   UInt64 requestCount,
   UInt64 * actualCount
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain a fork reference number with the FSOpenFork function, or with one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
flags

A constant indicating how the new space should be allocated. See Allocation Flags for a description of the constants which you can use in this parameter.
positionMode

A constant specifying the base location for the start of the allocation. See Position Mode Constants for more information on the constants which you can use to specify the base location. 
positionOffset

The offset from the base location of the start of the allocation. 
requestCount

The number of bytes to allocate. 
actualCount

On return, a pointer to the number of bytes actually allocated to the file. The value returned in here may be smaller than the number specified in the requestCount parameter if some of the space was already allocated. The value pointed to by the actualCount parameter does not reflect any additional bytes that may have been allocated because space is allocated in terms of fixed units such as allocation blocks, or the use of a clump size to reduce fragmentation. 

The actualCount output is optional if you don’t want the number of allocated bytes returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSAllocateFork function attempts to allocate requestCount bytes of physical storage starting at the offset specified by the positionMode and positionOffset parameters. For volume formats that support preallocated space, you can later write to this range of bytes (including extending the size of the fork) without requiring an implicit allocation.

Any extra space allocated but not used will be deallocated when the fork is closed, using FSCloseFork , PBCloseForkSync , or PBCloseForkAsync ; or when the fork is flushed, using FSFlushFork , PBFlushForkSync , or PBFlushForkAsync. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSAllocateFork (
   SInt16 forkRefNum,
   FSAllocationFlags flags,
   UInt16 positionMode,
   SInt64 positionOffset,
   UInt64 requestCount,
   UInt64 * actualCount
){};


/*FSWriteFork

Writes data to an open fork.

OSErr FSWriteFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   const void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching.
positionOffset

The offset from the base location for the start of the write. 
requestCount

The number of bytes to write. 
buffer

A pointer to a buffer containing the data to write. 
actualCount

On return, a pointer to the number of bytes actually written. The value pointed to by the actualCount parameter will be equal to the value in the requestCount parameter unless there was an error during the write operation.

This parameter is optional; if you don’t want this information, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned.
Discussion

FSWriteFork writes data starting at the position specified by the positionMode and positionOffset parameters. The function attempts to write requestCount bytes from the buffer pointed at by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSWriteFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   const void * buffer,
   ByteCount * actualCount
){};

/*FSCreateFork

Creates a named fork for a file or directory.

OSErr FSCreateFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName
);
Parameters
ref

A pointer to an FSRef specifying the file or directory. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the name of the new fork. 
forkName

A pointer to the Unicode name of the fork. 
Return Value

A result code. See “File Manager Result Codes”. If the named fork already exists, the function returns errFSForkExists. If the fork name is syntactically invalid or otherwise unsupported for the given volume, FSCreateFork returns errFSBadForkName or errFSNameTooLong.
Discussion

A newly created fork has zero length (that is, its logical end-of-file is zero). The data and resource forks of a file are automatically created and deleted as needed. This is done for compatibility with older APIs, and because data and resource forks are often handled specially. If a given fork always exists for a given volume format (such as data and resource forks for HFS and HFS Plus, or data forks for most other volume formats), an attempt to create that fork when a zero-length fork already exists should return noErr; if a non-empty fork already exists then errFSForkExists should be returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName
){};

/*FSSetForkSize

Changes the size of an open fork.

OSErr FSSetForkSize (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant indicating the base location within the fork for the new size. See Position Mode Constants for more information about the constants you can use to specify the base location. 
positionOffset

The offset of the new size from the base location specified in the positionMode parameter. 
Return Value

A result code. See “File Manager Result Codes”. If there is not enough space on the volume to extend the fork, then dskFulErr is returned and the fork’s size is unchanged.
Discussion

The FSSetForkSize function sets the logical end-of-file to the position indicated by the positionMode and positionOffset parameters. The fork’s new size may be less than, equal to, or greater than the fork’s current size. If the fork’s new size is greater than the fork’s current size, then the additional bytes, between the old and new size, will have an undetermined value.

If the fork’s current position is larger than the fork’s new size, then the current position will be set to the new fork size the current position will be equal to the logical end-of-file. 
Special Considerations

You do not need to check that the volume supports the FSSetForkSize function. If a volume does not support the FSSetForkSize function, but the FSSetForkSize function is present, the File Manager automatically calls the PBSetEOFSync function and translates between the calls appropriately. 

Note, however, that if the volume does not support the FSSetForkSize function, you can only access the data and resource forks, and you cannot grow the fork beyond 2GB. To check that the FSSetForkSize function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetForkSize (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
){};


/*ConvertLocalTimeToUTC

Converts local time to UTC. (Deprecated in Mac OS X v10.4.)

OSStatus ConvertLocalTimeToUTC (
   UInt32 localSeconds,
   UInt32 * utcSeconds
);
Parameters
localSeconds

A value of type UInt32 containing the local time.
utcSeconds

A pointer to a value of type UInt32. On return, this points to the UTC value corresponding to the given time in localSeconds.
Return Value

A result code. See “Date, Time, and Measurement Utilities Result Codes”.
Discussion

Given a local time in localSeconds, the function will place the corresponding UTC value in utcSeconds. This function returns noErr if the conversion is successful. Otherwise, it may return kUTCUnderflowErr or kUTCOverflowErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
UTCUtils.h*/

OSStatus ConvertLocalTimeToUTC (
   UInt32 localSeconds,
   UInt32 * utcSeconds
){};

/*UpgradeScriptInfoToTextEncoding

Converts any combination of a Mac OS script code, a language code, a region code, and a font name to a text encoding.

OSStatus UpgradeScriptInfoToTextEncoding (
   ScriptCode iTextScriptID,
   LangCode iTextLanguageID,
   RegionCode iRegionID,
   ConstStr255Param iTextFontname,
   TextEncoding * oEncoding
);
Parameters
iTextScriptID

A valid Script Manager script code. The Mac OS Script Manager defines constants for script codes using this format: smXxx. To designate the system script, specify the meta-value of smSystemScript. To designate the current script based on the font specified in the graphics port (grafPort), specify the metavalue of smCurrentScript. To indicate that you do not want to provide a script code for this parameter, specify the constant kTextScriptDontCare. 
iTextLanguageID

A valid Script Manager language code. The Mac OS Script Manager defines constants for language codes using this format: langXxx. To indicate that you do not want to provide a language code for this parameter, specify the constant kTextLanguageDontCare. 
iRegionID

A valid Script Manager region code. The Mac OS Script Manager defines constants for region codes using this format: verXxx. To indicate that you do not want to provide a region code for this parameter, specify the constant kTextRegionDontCare. 
iTextFontname

The name of a font associated with a particular text encoding specification, such as Symbol or Zapf Dingbats, or the name of any font that is currently installed on the system. To indicate that you do not want to provide a font name, specify a value of NULL. 
oEncoding

A pointer to a value of type TextEncoding. On return, this value holds the text encoding specification that the function created from the other values you provided. 
Return Value

A result code. See “TEC Manager Result Codes”. This function returns paramErr if two or more of the input parameter values conflict in some way—for example, the Mac OS language code does not belong to the script whose script code you specified, or if the input parameter values are invalid. The function returns a kTECTableFormatErr result code if the internal mapping tables used for translation are invalid.
Discussion

The UpgradeScriptInfoToTextEncoding function allows you to derive a text encoding specification from script codes, language codes, region codes, and font names. A one-to-one correspondence exists between many of the Script Manager’s script codes and a particular Mac OS text encoding base value. However, because text encodings are a superset of script codes, some combinations of script code, language code, region code, and font name might result in a different text encoding base value than would be the case if the translation were based on the script code alone. 

When you call the UpgradeScriptInfoToTextEncoding function, you can specify any combination of its parameters, but you must specify at least one. 

If you don’t specify an explicit value for a script, language, or region code parameter, you must pass the do-not-care constant appropriate to that parameter. If you do not specify an explicit value for iTextFontName, you must pass NULL. UpgradeScriptInfoToTextEncoding uses as much information as you supply to determine the equivalent text encoding or the closest approximation. If you provide more than one parameter, all parameters are checked against one another to ensure that they are valid in combination. 

A font name, such as 'Symbol' or 'Zapf Dingbats,' can indicate a particular text encoding base. Other font names can indicate particular variants associated with a particular text encoding base. Otherwise, the font name is used to obtain a script code, and this script code will be checked against any script code you supply (in this case, the font must be installed; if it is not, the function returns a paramErr result code). If you do not supply either a language code or a region code and the script code you supply or the one that is derived matches the system script, then the system’s localization is used to determine the appropriate region and language code. This is used for deriving text encoding base values that depend on region and language, such as kTextEncodingMacTurkish. 

For more information see the RevertTextEncodingToScriptInfo function and “Base Text Encodings”. 
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
TextCommon.h*/

OSStatus UpgradeScriptInfoToTextEncoding (
   ScriptCode iTextScriptID,
   LangCode iTextLanguageID,
   RegionCode iRegionID,
   ConstStr255Param iTextFontname,
   TextEncoding * oEncoding
){};


/*CreateTextEncoding

Creates and returns a text encoding specification.

TextEncoding CreateTextEncoding (
   TextEncodingBase encodingBase,
   TextEncodingVariant encodingVariant,
   TextEncodingFormat encodingFormat
);
Parameters
encodingBase

A base text encoding.
encodingVariant

A variant of the base text encoding. To specify the default variant for the base encoding given in the encodingBase parameter, you can use the kTextEncodingDefaultVariant constant. 
encodingFormat

A format for the base text encoding. To specify the default format for the base encoding, you can use the kTextEncodingDefaultFormat constant. If you want to obtain a TextEncoding value that references UTF-16 or UTF-8, pass kUnicode16BitFormat or kUnicodeUTF8Format . 
Return Value

The text encoding specification that the function creates from the values you pass it.
Discussion

When you create a text encoding specification, the three values that you specify are packed into an unsigned integer, which you can then pass by value to the functions that use text encodings. See the data type TextEncodingRun. 
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
TextCommon.h*/

TextEncoding CreateTextEncoding (
   TextEncodingBase encodingBase,
   TextEncodingVariant encodingVariant,
   TextEncodingFormat encodingFormat
){};


/*GetTextEncodingBase

Returns the base encoding of the specified text encoding. 

TextEncodingBase GetTextEncodingBase (
   TextEncoding encoding
);
Parameters
encoding

A text encoding specification whose base encoding you want to obtain. 
Return Value

The base encoding portion of the specified text encoding. 
Discussion

See the data type TextEncodingRun
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
TextCommon.h*/
TextEncodingBase GetTextEncodingBase (
   TextEncoding encoding
){};




/*CreateUnicodeToTextInfo

Creates and returns a Unicode converter object containing information required for converting strings from Unicode to a non-Unicode encoding. 

OSStatus CreateUnicodeToTextInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   UnicodeToTextInfo * oUnicodeToTextInfo
);
Parameters
iUnicodeMapping

A pointer to a structure of type UnicodeMapping. Your application provides this structure to identify the mapping to be used for the conversion. The unicodeEncoding field of this structure can specify a Unicode format of kUnicode16BitFormat or kUnicodeUTF8Format. Note that the versions of the Unicode Converter prior to 1.2.1 do not support kUnicodeUTF8Format. 
oUnicodeToTextInfo

On return, a pointer to a Unicode converter object that holds the mapping table information you supply as the iUnicodeMapping parameter and the state information related to the conversion. The information contained in the Unicode converter object is required for the conversion of a Unicode string to a non-Unicode encoding. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

You pass the Unicode converter object returned from CreateUnicodeToTextInfo to the function ConvertFromUnicodeToText or ConvertFromUnicodeToPString to identify the information to be used for the conversion. These two functions modify the contents of the Unicode converter object. 

If an error is returned, the Unicode converter object is invalid. 

Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/

OSStatus CreateUnicodeToTextInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   UnicodeToTextInfo * oUnicodeToTextInfo
){};


/*ConvertFromUnicodeToText

Converts a Unicode text string to the destination encoding you specify. 

OSStatus ConvertFromUnicodeToText (
   UnicodeToTextInfo iUnicodeToTextInfo,
   ByteCount iUnicodeLen,
   const UniChar iUnicodeStr[],
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oInputRead,
   ByteCount * oOutputLen,
   LogicalAddress oOutputStr
);
Parameters
iUnicodeToTextInfo

A Unicode converter object of type UnicodeToTextInfo for converting text from Unicode. You use the function CreateUnicodeToTextInfo or CreateUnicodeToTextInfoByEncoding to obtain a Unicode converter object to specify for this parameter. This function modifies the contents of the iUnicodeToTextInfo parameter. 
iUnicodeLen

The length in bytes of the Unicode string to be converted. 
iUnicodeStr

A pointer to the Unicode string to be converted. If the input text is UTF-8, which is supported for versions 1.2.1 or later of the converter, you must cast the UTF-8 buffer pointer to ConstUniCharArrayPtr before you can pass it as this parameter. 
iControlFlags

Conversion control flags. You can use “Conversion Masks” and “Directionality Masks” to set the iControlFlags parameter. 
iOffsetCount

The number of offsets contained in the array provided by the iOffsetArray parameter. Your application supplies this value. If you don’t want offsets returned to you, specify 0 (zero) for this parameter. 
iOffsetArray

An array of type ByteOffset. On input, you specify the array that gives an ordered list of significant byte offsets pertaining to the Unicode source string to be converted. These offsets may identify font or style changes, for example, in the source string. If you don’t want offsets returned to your application, specify NULL for this parameter and 0 (zero) for iOffsetCount. All offsets must be less than iUnicodeLen. 
oOffsetCount

On return, a pointer to the number of offsets that were mapped in the output stream.
oOffsetArray

An array of type ByteOffset. On return, this array contains the corresponding new offsets for the converted string in the new encoding.
iOutputBufLen

The length in bytes of the output buffer pointed to by the oOutputStr parameter. Your application supplies this buffer to hold the returned converted string. The oOutputLen parameter may return a byte count that is less than this value if the converted byte string is smaller than the buffer size you allocated.
oInputRead

On return, a pointer to a the number of bytes of the Unicode string that were converted. If the function returns a kTECUnmappableElementErr result code, this parameter returns the number of bytes that were converted before the error occurred.
oOutputLen

On return, a pointer to the length in bytes of the converted text stream.
oOutputStr

A value of type LogicalAddress. On input, this value points to a buffer for the converted string. On return, the buffer holds the converted text string. (For guidelines on estimating the size of the buffer needed, see the following discussion. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

This function can also map offsets for style or font information from the source text string to the returned converted string. The converter reads the application-supplied offsets and returns the corresponding new offsets in the converted string. If you do not want font or style information offsets mapped to the resulting string, you should pass NULL for iOffsetArray and 0 (zero) for iOffsetCount. 

Your application must allocate a buffer to hold the resulting converted string and pass a pointer to the buffer in the oOutputStr parameter. To determine the size of the output buffer to allocate, you should consider the size and content of the Unicode source string in relation to the type of encoding to which it will be converted. For example, for many encodings, such as MacRoman and Shift-JIS, the size of the returned string will be between half the size and the same size as the source Unicode string. However, for some encodings that are not Mac OS ones, such as EUC-JP, which has some 3-byte characters for Kanji, the returned string could be larger than the source Unicode string. For MacArabic and MacHebrew, the result will usually be less than half the size of the Unicode string. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus ConvertFromUnicodeToText (
   UnicodeToTextInfo iUnicodeToTextInfo,
   ByteCount iUnicodeLen,
   const UniChar iUnicodeStr[],
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oInputRead,
   ByteCount * oOutputLen,
   LogicalAddress oOutputStr
){};


/*DisposeUnicodeToTextInfo

Releases the memory allocated for the specified Unicode converter object. 

OSStatus DisposeUnicodeToTextInfo (
   UnicodeToTextInfo * ioUnicodeToTextInfo
);
Parameters
ioUnicodeToTextInfo

A pointer to a Unicode converter object for converting from Unicode to a non-Unicode encoding. You specify a Unicode converter object that your application created using the function CreateUnicodeToTextInfo or CreateUnicodeToTextInfoByEncoding. You must not point to any other type of Unicode converter object. Your application should not attempt to dispose of the same Unicode converter object more than once. 
Return Value

A result code. See “TEC Manager Result Codes”. The function returns noErr if it disposes of the Unicode converter object successfully. If your application specifies an invalid Unicode converter object, such as NULL, the function returns a paramErr result code.
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/

OSStatus DisposeUnicodeToTextInfo (
   UnicodeToTextInfo * ioUnicodeToTextInfo
){};


/*FSCopyObjectAsync

Starts an asynchronous file operation to copy a source object into a destination directory.

OSStatus FSCopyObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this copy operation.
source

A pointer to the source object to copy. The object can be a file or a directory.
destDir

A pointer to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSCopyObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};


/*FSMoveObjectAsync

Starts an asynchronous file operation to move a source object into a destination directory.

OSStatus FSMoveObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this move operation.
source

A pointer to the source object to move. The object can be a file or a directory.
destDir

A pointer to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSMoveObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};
/*FSFileOperationCreate

Creates an object that represents an asynchronous file operation.

FSFileOperationRef FSFileOperationGetTypeID (
   CFAllocatorRef alloc
);
Parameters
alloc

The allocator to use. Pass NULL for the default allocator.
Return Value

A new FSFileOperation object, or NULL if the object could not be created. When you no longer need the object, you should release it by calling CFRelease.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
FSFileOperationRef FSFileOperationCreate (
   CFAllocatorRef alloc
){};

/*FSFileOperationScheduleWithRunLoop

Schedules an asynchronous file operation with the specified run loop and mode.

OSStatus FSFileOperationScheduleWithRunLoop (
   FSFileOperationRef fileOp,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
fileOp

The file operation to schedule.
runLoop

The run loop in which to schedule the operation. For information about Core Foundation run loops, see Run Loops.
runLoopMode

The run loop mode in which to schedule the operation. In most cases, you may specify kCFRunLoopCommonModes.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To run, a file operation must be scheduled with at least one run loop. A file operation can be scheduled with multiple run loop and mode combinations.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSFileOperationScheduleWithRunLoop (
   FSFileOperationRef fileOp,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
){};

/*FSPathMoveObjectSync

Moves a source object into a destination directory using paths.

OSStatus FSPathMoveObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);
Parameters
sourcePath

The UTF-8 path to the source object to move. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
targetPath

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the new object in the destination directory. If the operation fails, the path is set to NULL. When you no longer need the path, you should free it. This parameter is optional; pass NULL if you don’t need the path to the new object.
options

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the destination directory is on the same volume as the source object, this is a fast operation. If the move is across volumes, this function could take a significant amount of time to execute; you should call it in a thread other than the main thread or use FSPathMoveObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathMoveObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
){};

/*FSPathCopyObjectSync

Copies a source object into a destination directory using paths.

OSStatus FSPathCopyObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);
Parameters
sourcePath

The UTF-8 path to the source object to copy. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
targetPath

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the new object in the destination directory. If the operation fails, the path is set to NULL. When you no longer need the path, you should free it. This parameter is optional; pass NULL if you don’t need the path to the new object.
options

One or more file operation option flags. See File Operation Options.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function could take a significant amount of time to execute. To avoid blocking your user interface, you should either call this function in a thread other than the main thread or use FSPathCopyObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathCopyObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
){};



/*FSPathFileOperationCopyStatus

Gets a copy of the current status information for an asynchronous file operation that uses paths.

OSStatus FSPathFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   char **currentItem,
   FSFileOperationStage *stage,
   OSStatus *error
   CFDictionaryRef *statusDictionary,
   void **info
);
Parameters
fileOp

The file operation to access.
currentItem

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory). You should free the path when you are finished using it.
stage

A pointer to a file operation stage variable. On output, the variable contains the current stage of the file operation.
error

A pointer to an error status variable. On output, the variable contains the current error status of the file operation.
statusDictionary

A pointer to a dictionary variable. On output, the variable contains a dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You should release the dictionary when you are finished using it.
info

A pointer to a generic pointer. On output, the generic pointer refers to user-defined data associated with this file operation.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   char **currentItem,
   FSFileOperationStage *stage,
   OSStatus *error,
   CFDictionaryRef *statusDictionary,
   void **info
){};


/*FSPathMoveObjectAsync

Starts an asynchronous file operation to move a source object into a destination directory using paths.

OSStatus FSPathMoveObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this move operation.
sourcePath

The UTF-8 path to the source object to move. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/

OSStatus FSPathMoveObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};

/*FSPathCopyObjectAsync

Starts an asynchronous file operation to copy a source object into a destination directory using paths.

OSStatus FSPathCopyObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this copy operation.
sourcePath

The UTF-8 path to the source object to copy. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathCopyObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};


/*FSMoveObjectSync

Moves a source object into a destination directory.

OSStatus FSMoveObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);
Parameters
source

A pointer to the source object to move. The object can be a file or a directory. On output, the source object is no longer valid; if you want to refer to the moved object, you should use the FSRef variable passed back in the target parameter.
destDir

A pointer to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
target

A pointer to an FSRef variable. On output, the variable refers to the new object in the destination directory. This parameter is optional; pass NULL if you don’t need to refer to the new object.
options

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the destination directory is on the same volume as the source object, this is a fast operation. If the move is across volumes, this function could take a significant amount of time to execute; you should either call it in a thread other than the main thread or use FSMoveObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSMoveObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
){};


/*FSCopyObjectSync

Copies a source object into a destination directory.

OSStatus FSCopyObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);
Parameters
source

A pointer to the source object to copy. The object can be a file or a directory.
destDir

A pointer to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
target

A pointer to an FSRef variable. On output, the variable refers to the new object in the destination directory. This parameter is optional; pass NULL if you don’t need to refer to the new object.
options

One or more file operation option flags. See File Operation Options.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function could take a significant amount of time to execute. To avoid blocking your user interface, you should either call this function in a thread other than the main thread or use FSCopyObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSCopyObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
){};



/*FSFileOperationCopyStatus

Gets a copy of the current status information for an asynchronous file operation.

OSStatus FSFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   FSRef *currentItem,
   FSFileOperationStage *stage,
   OSStatus *error
   CFDictionaryRef *statusDictionary,
   void **info
);
Parameters
fileOp

The file operation to access.
currentItem

A pointer to an FSRef variable. On output, the variable contains the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory).
stage

A pointer to a file operation stage variable. On output, the variable contains the current stage of the file operation.
error

A pointer to an error status variable. On output, the variable contains the current error status of the file operation.
statusDictionary

A pointer to a dictionary variable. On output, the variable contains a dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You should release the dictionary when you are finished using it.
info

A pointer to a generic pointer. On output, the generic pointer refers to user-defined data associated with this file operation.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/

OSStatus FSFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   FSRef *currentItem,
   FSFileOperationStage *stage,
   OSStatus *error,
   CFDictionaryRef *statusDictionary,
   void **info
){};

/*MatchAlias

Identifies a list of possible matches for an alias and passes the list through an optional selection filter. The filter can return more than one possible match. (Deprecated in Mac OS X v10.4. Use FSMatchAlias instead.)

Not recommended

OSErr MatchAlias (
   const FSSpec * fromFile,
   unsigned long rulesMask,
   AliasHandle alias,
   short * aliasCount,
   FSSpecArrayPtr aliasList,
   Boolean * needsUpdate,
   AliasFilterUPP aliasFilter,
   void * yourDataPtr
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you do not want MatchAlias to perform a relative search, set fromFile to NULL. If you want MatchAlias to perform a relative search, pass a pointer to a file system specification structure that describes the starting point for the search.
rulesMask

A set of rules to guide the resolution. Pass the sum of all of the rules you want to invoke. For a description of the values you can use in this parameter, see “Matching Constants”.
alias

A handle to the alias record to be resolved.
aliasCount

On input, a pointer to the maximum number of possible matches to return. On output, the actual number of matches returned.
aliasList

A pointer to the array that holds the results of the search, a list of possible candidates.
needsUpdate

A pointer to a Boolean flag that indicates whether the alias record to be resolved needs to be updated.
aliasFilter

An application-defined filter function. The Alias Manager executes this function each time it identifies a possible match and after the search has continued for three seconds without a match. Your filter function returns a Boolean value that determines whether the possible match is discarded (true) or added to the list of possible targets (false). It can also terminate the search by setting the variable parameter quitFlag. See AliasFilterProcPtr for a description of the filter function.
yourDataPtr

A pointer to data to be passed to the filter function. The yourDataPtr parameter can point to any data your application might need in the filter function.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

If MatchAlias finds the parent directory on the correct volume but does not find the target, it sets the aliasCount parameter to 1, puts the file system specification structure for the target in the results list, and returns fnfErr. The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, use the FSSpec structure and the File Manager function FSpCreate to create a replacement for a missing file.

After it identifies a target, MatchAlias compares some key information about the target with the same information in the record. If the information does not match, MatchAlias sets the needsUpdate flag to true. The key information is
the name of the target 
the directory ID of the target’s parent 
the file ID or directory ID of the target 
the name and creation date of the volume on which the target resides 

The MatchAlias function also sets the needsUpdate flag to true if it identifies a list of possible matches rather than a single match or if kARMsearchRelFirst is set in the rulesMask parameter but the target is identified through either an absolute search or an exhaustive search. Otherwise, the MatchAlias function sets the needsUpdate flag to false. MatchAlias always sets the needsUpdate flag to false when resolving an alias created by NewAliasMinimal. If you want to update the alias record to reflect the final results of the resolution, call UpdateAlias. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSMatchAlias instead.
Declared In
Aliases.h*/

OSErr MatchAlias (
   const FSSpec * fromFile,
   unsigned long rulesMask,
   AliasHandle alias,
   short * aliasCount,
   FSSpecArrayPtr aliasList,
   Boolean * needsUpdate,
   AliasFilterUPP aliasFilter,
   void * yourDataPtr
){};

/*UpdateAlias

Updates an alias record. (Deprecated in Mac OS X v10.4. Use FSUpdateAlias instead.)

Not recommended

OSErr UpdateAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle alias,
   Boolean * wasChanged
);
Parameters
fromFile

The starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the record, pass a fromFile value of NULL. If you want UpdateAlias to record relative path information, pass a pointer to a valid FSSpec structure in this parameter.
target

The target of the alias record. This parameter must be a pointer to a valid FSSpec structure.
alias

A handle to the alias record to be updated.
wasChanged

A pointer to a Boolean value indicating whether the newly constructed alias record is exactly the same as the old one. If the new record is the same as the old one, UpdateAlias sets the wasChanged parameter to false. Otherwise, it sets it to true. Check this parameter to determine whether you need to save an updated record.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The UpdateAlias function rebuilds the entire alias record and fills it in as the NewAlias function would.

The UpdateAlias function always creates a complete alias record. When you use UpdateAlias to update a minimal alias record, you convert the minimal record to a complete record.
Special Considerations

The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSUpdateAlias instead.
Declared In
Aliases.h*/
OSErr UpdateAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle alias,
   Boolean * wasChanged
){};


/*DisposeThread

Deletes a thread when it finishes executing. 

OSErr DisposeThread (
   ThreadID threadToDump,
   void * threadResult,
   Boolean recycleThread
);
Parameters
threadToDump

The thread ID of the thread to delete. 
threadResult

A pointer to the thread’s result. The DisposeThread function places this result to an address which you originally specify with the threadResult parameter of the NewThread function when you create or allocate the thread. Pass a value of NULL if you are not interested in obtaining a function result. 
recycleThread

A Boolean value that specifies whether to return the thread to the allocation pool or to remove it entirely. Specify False to dispose of the thread entirely and True to return it to the thread pool. 
Return Value

A result code. See “Thread Manager Result Codes”.
Discussion

When a thread finishes executing, the Thread Manager automatically calls DisposeThread to delete it. Therefore, the only reason for you to explicitly call DisposeThread is to recycle a terminating thread. To do so, set the recycleThread parameter to True. The Thread Manager clears out the thread’s internal data structure, resets it, and puts the thread in the thread pool where it can be used again as necessary. 

The DisposeThread function sets the threadResult parameter to the thread’s function result. You allocate the storage for the thread result when you create or allocate a thread with the NewThread function.

You cannot explicitly dispose of the main application thread. If you attempt to do so, DisposeThread returns the threadProtocolErr result code.

When your application terminates, the Thread Manager calls DisposeThread to terminate any active threads. It terminates stopped and ready threads first but in no special order. It terminates the currently running thread last. This thread should always be the main application thread. 

To install a callback function to do special cleanup when a thread terminates, use the SetThreadTerminator function. 
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/

OSErr DisposeThread (
   ThreadID threadToDump,
   void * threadResult,
   Boolean recycleThread
){};



/*NewThread

Creates a new thread or allocates one from the existing pool of threads.

Modified

OSErr NewThread (
   ThreadStyle threadStyle,
   ThreadEntryTPP threadEntry,
   void * threadParam,
   Size stackSize,
   ThreadOptions options,
   void ** threadResult,
   ThreadID * threadMade
);
Parameters
threadStyle

The type of thread to create. Cooperative is the only type that you can specify. Historically, the Thread Manger supported two types of threads, preemptive and cooperative, but the Thread Manager no longer supports preemptive threads. 
threadEntry

A pointer to the thread entry function. 
threadParam

A pointer to a value that the Thread Manager passes as a parameter to the thread entry function. Specify NULL if you are passing no information. 
stackSize

The stack size (in bytes) to allocate for this thread. This stack must be large enough to handle saved thread context, normal application stack usage, interrupt handling functions, and CPU exceptions. Specify a stack size of 0 (zero) to request the Thread Manager’s default stack size. 
options

Options that define characteristics of the new thread. See the Thread Option Constants data type for details on the options. You sum the options together to create a single options parameter. 
threadResult

On return, a pointer to the address of a location to hold the function result provided by the Thread Option Constants function when the thread terminates. Specify NULL for this parameter if you are not interested in the function result.
threadMade

On return, a pointer to the thread ID of the newly created or allocated thread. If there is an error, threadMade points to a value of kNoThreadID. 
Return Value

A result code. See “Thread Manager Result Codes”.
Discussion

The NewThread function obtains a thread ID that you can use in other Thread Manager functions to identify the thread. If you want to allocate a thread from the pool of threads, specify the kUsePremadeThread option of the options parameter. Otherwise, NewThread creates a new thread.

When you request a thread from the existing pool, the Thread Manager allocates one that best fits your specified stack size. If you specify the kExactMatchThread option of the options parameter, the Thread Manager allocates a thread whose stack exactly matches your stack-size requirement or, if it can’t allocate one because no such thread exists, it returns the threadTooManyReqsErr result code.

Before making any calls to NewThread, be certain that you first have called the Memory Manager function MaxApplZone to extend the application heap to its limit. You must call MaxApplZone from the main application thread before any other threads in your application run. 

When you call the NewThread function, you pass, as the threadEntry parameter, a pointer to the name of the entry function to the thread. When the newly created thread runs initially, it begins by executing this function.

You can use the threadParam parameter to pass thread-specific information to a newly created or allocated thread. In the data structure pointed to by this parameter, you could place something like A5 information or the address of a window to update. You could also use this parameter to specify a place for a thread’s local storage.

Be sure to create the storage for the threadResult parameter in a place that is guaranteed to be available when the thread terminates—for example, in an application global variable or in a local variable of the application’s main function (the main thread, by definition, cannot be disposed of so it is always available). Do not create the storage in a local variable of a subfunction that completes before the thread terminates or the storage will become invalid.

For Carbon applications, the pointer to your thread entry function must be a universal procedure pointer (UPP).

To dispose of a thread, use the DisposeThread function.

See the description of the Thread Option Constants data type for details on the characteristics you can specify in the options parameter.

For more information about the thread entry function, see the ThreadEntryProcPtr function. 
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Carbon Porting Notes

For Carbon applications, you must create and pass a universal procedure pointer (UPP) to specify the new thread callback. Use the NewThreadEntryUPP and DisposeThreadEntryUPP functions to create and remove the UPP.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/

OSErr NewThread (
   ThreadStyle threadStyle,
   ThreadEntryTPP threadEntry,
   void * threadParam,
   Size stackSize,
   ThreadOptions options,
   void ** threadResult,
   ThreadID * threadMade
){};


/*YieldToAnyThread

Relinquishes the current thread’s control.

OSErr YieldToAnyThread ();
Return Value

A result code. See “Thread Manager Result Codes”.
Discussion

The YieldToAnyThread function invokes the Thread Manager’s scheduling mechanism. The current thread relinquishes control and the Thread Manager schedules the next available thread.

The current thread is suspended in the ready state and awaits rescheduling when the CPU is available. When the suspended thread is scheduled again, YieldToAnyThread regains control and returns to the function that called it.

If you have installed a custom scheduler, the Thread Manager passes it the thread ID of the suspended thread.

In each thread you must make one or more strategically placed calls to relinquish control to another thread. You can either make this yield call or another yield call such as YieldToThread; or you can make a call such as SetThreadState to explicitly change the state of the thread.

Threads must yield in the CPU addressing mode (24-bit or 32-bit) in which the application was launched.

To relinquish control to a specific thread, use the YieldToThread function.

To change the state of a specified thread, use the SetThreadState function. 
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/
OSErr YieldToAnyThread (){};


/*rinttol


long rinttol (
   double_t x
);
Parameters
x
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/

long rinttol (
   double_t x
){};

/*NewAlias

Creates a complete alias record. (Deprecated in Mac OS X v10.4. Use FSNewAlias instead.)

Not recommended

OSErr NewAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle * alias
);
Parameters
fromFile

The starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the structure, pass a fromFile value of NULL. If you want NewAlias to record relative path information, pass a pointer to a valid FSSpec structure in this parameter. The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
target

A pointer to an FSSpec structure for the target of the alias record.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAlias function creates an alias record that describes the specified target. It allocates the storage, fills in the record, and puts a record handle to that storage in the alias parameter. NewAlias always records the name and file or directory ID of the target, its creation date, the parent directory name and ID, and the volume name and creation date. It also records the full pathname of the target and a collection of other information relevant to locating the target, verifying the target, and mounting the target’s volume, if necessary. You can have NewAlias store relative path information as well by supplying a starting point for a relative path. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAlias instead.
Declared In
Aliases.h*/

OSErr NewAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle * alias
){};

/*Converting Numeric Representations Into Date and Time Strings
pascal void DateString        (long dateTime, DateForm longFlag,
                               Str255 result, Handle intlHandle);
pascal void TimeString        (long dateTime, Boolean wantSeconds,
                               Str255 result, Handle intlHandle);*/
pascal void DateString        (long dateTime, DateForm longFlag,
                               Str255 result, Handle intlHandle){};
pascal void TimeString        (long dateTime, Boolean wantSeconds,
                               Str255 result, Handle intlHandle){};




/*Accessing Information About Files and Directories
pascal OSErr PBGetCatInfo	(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBGetCatInfoSync
   				(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBGetCatInfoAsync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBSetCatInfo	(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBSetCatInfoSync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBSetCatInfoAsync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBHGetFInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetFInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetFInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHSetFInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFLock	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHSetFLockSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFLockAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHRstFLock	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHRstFLockSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHRstFLockAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHRename		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHRenameSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHRenameAsync	(HParmBlkPtr paramBlock);*/
pascal OSErr PBGetCatInfo	(CInfoPBPtr paramBlock, Boolean async){};


/*Count1Resources

Returns the total number of resources of a given type in the current resource file.

short Count1Resources (
   ResType theType
);
Parameters
theType

A resource type.
Return Value

The total number of resources of the given type in the current resource file only.
Discussion

To check for errors, call the ResError function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

short Count1Resources (
   ResType theType
){};


/*Getting Information About the Operating Environment
pascal OSErr Gestalt	(OSType selector, long *response);
pascal OSErr SysEnvirons(short versionRequested, SysEnvRec *theWorld);*/
pascal OSErr SysEnvirons(short versionRequested, SysEnvRec *theWorld){};



/*LMGetHeapEnd

(Deprecated in Mac OS X v10.4. There is no replacement; this function was included to facilitate porting legacy applications to Carbon, but it serves no useful purpose in Mac OS X.)

Ptr LMGetHeapEnd (void);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
LowMem.h*/
Ptr LMGetHeapEnd (void){};


/*CountSymbols

Determines how many symbols are exported from a specified fragment.

OSErr CountSymbols (
   CFragConnectionID connID,
   long * symCount
);
Parameters
connID

A connection ID. 
symCount

On return, a pointer to the number of exported symbols in the fragment whose connection ID is connID. You can use the value returned in symCount to index through all the exported symbols in a particular fragment (using the GetIndSymbol function). 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/

OSErr CountSymbols (
   CFragConnectionID connID,
   long * symCount
){};


/*GetIndSymbol

Gets information about the exported symbols in a fragment.

OSErr GetIndSymbol (
   CFragConnectionID connID,
   long symIndex,
   Str255 symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
);
Parameters
connID

A connection ID. 
symIndex

A symbol index. This index is zero-based. That is, the value of this parameter should be between zero and the number of symbols -1 (where the number of symbols is determined by calling the CountSymbols function). 
symName

On return, the name of the indicated symbol. 
symAddr

On return, a pointer to the address of the indicated symbol. 
symClass

On return, a pointer to the class of the indicated symbol. See “Load Flag, Symbol Class, and Fragment Locator Constants”. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

If GetIndSymbol executes successfully, it returns the symbol’s name, starting address, and class in the symName, symAddr, and symClass parameters, respectively. A fragment’s exported symbols are retrieved in no predetermined order. 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr GetIndSymbol (
   CFragConnectionID connID,
   long symIndex,
   Str255 symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
){};


/*StringToNum

Converts the Pascal string representation of a base-10 number into a long integer value. (Deprecated in Mac OS X v10.4. Use CFStringGetIntValue instead.)

void StringToNum (
   ConstStr255Param theString,
   long * theNum
);
Parameters
theString

A Pascal string representation of a base-10 number. The numeric string can be padded with leading zeros or with a sign. 
theNum

On output, contains a pointer to the numeric value. 
Discussion

Unless patched by a script system with different rules, this function assumes that you are using standard numeric token processing, meaning that the Roman script system number processing rules are used.

For functions that make use of the token-processing information that is found in the tokens ('itl4') resource of script systems for converting numbers, see the sections “Using Number Format Specification Strings for International Number Formatting” and “Converting Between Strings and Floating-Point Numbers”.

The 32-bit result is negated if the string begins with a minus sign. Integer overflow occurs if the magnitude is greater than or equal to 2 raised to the 31st power. StringToNum performs the negation using the two’s complement method: the state of each bit is reversed and then 1 is added to the result. For example, here are possible results produced by StringToNum:
The value of theString is “-23”. StringToNum returns the value -23 in theNum. 
The value of theString is “-0”. StringToNum returns the value 0 in theNum. 
The value of theString is “055”. StringToNum returns the value 55 in theNum. 
The value of theString is “2147483648” (magnitude is 2^31). StringToNum returns the value –2147483648 in theNum. 
The value of theString is “–2147483648”. StringToNum returns the value –2147483648 in theNum. 
The value of theString is “4294967295” (magnitude is 2^32–1). StringToNum returns the value -1 in theNum. 
The value of theString is “–4294967295”. StringToNum returns the value 1 in theNum. 

StringToNum does not check whether the characters in the string are between 0 and 9; instead, it takes advantage of the fact that the ASCII values for these characters are $30 through $39, and masks the last four bits for use as a digit. For example, StringToNum converts 2: to the number 30 since the character code for the colon (:) is $3A. Because StringToNum operates this way, spaces are treated as zeros (the character code for a space is $20), and other characters do get converted into numbers. For example, the character codes for 'C', 'A', and 'T' are $43, $41, and $54 respectively. Hence, the strings ‘CAT’, ‘+CAT’, and ‘-CAT’ would produce the results 314, 314, and -314.

One consequence of this conversion method is that StringToNum does not ignore thousand separators (the “,” character in the United States), which can lead to improper conversions. It is a good idea to ensure that all characters in theString are valid digits before you call StringToNum. 
Special Considerations

StringToNum may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
void StringToNum (
   ConstStr255Param theString,
   long * theNum
){};


/*SetResLoad

Enables and disables automatic loading of resource data into memory for functions that return handles to resources.

void SetResLoad (
   Boolean load
);
Parameters
load

Determines whether Resource Manager functions should read resource data into memory. If you set this parameter to TRUE, Resource Manager functions that return handles will, during subsequent calls, automatically read resource data into memory if it is not already in memory; if you set this parameter to FALSE, Resource Manager functions will not automatically read resource data into memory. Instead, such functions return a handle whose master pointer is set to NULL unless the resource is already in memory. In addition, when first opening a resource fork the Resource Manager won’t load into memory resources whose resPreload attribute is set. The default setting is TRUE.

If you call the function with this parameter set to FALSE, be sure to call SetResLoad with this parameter set to TRUE as soon as possible. Other parts of system software that call the Resource Manager expect this value to be TRUE, and some functions won’t work if resources are not loaded automatically.
Discussion

You can use the SetResLoad function when you want to read from the resource map without reading the resource data into memory. To read the resource data into memory after a call t this function, call the LoadResource function.

To check for errors, call the ResError function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void SetResLoad (
   Boolean load
){};
/*FSpExchangeFiles

Exchanges the data stored in two files on the same volume. (Deprecated in Mac OS X v10.4. Use FSExchangeObjects instead.)

OSErr FSpExchangeFiles (
   const FSSpec * source,
   const FSSpec * dest
);
Parameters
source

A pointer to an FSSpec for the first file to swap. The contents of this file and its file information are placed in the file specified in the dest parameter. See FSSpec for a description of the FSSpec data type.
dest

A pointer to an FSSpec for the second file to swap. The contents of this file and its file information are placed in the file specified in the source parameter.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpExchangeFiles function swaps the data in two files by changing the information in the volume’s catalog and, if either of the files are open, in the file control blocks. The following fields in the catalog entries for the files are exchanged:
ioFlStBlk 
ioFlLgLen 
ioFlPyLen 
ioFlRStBlk 
ioFlRLgLen 
ioFlRPyLen 
ioFlMdDat 

In the file control blocks, the fcbFlNum, fcbDirID, and fcbCName fields are exchanged.

You should use FSpExchangeFiles when updating an existing file, so that the file ID remains valid in case the file is being tracked through its file ID. The FSpExchangeFiles function changes the fields in the catalog entries that record the location of the data and the modification dates. It swaps both the data forks and the resource forks.

The FSpExchangeFiles function works on both open and closed files. If either file is open, FSpExchangeFiles updates any file control blocks associated with the file. Exchanging the contents of two files requires essentially the same access permissions as opening both files for writing.

The files whose data is to be exchanged must both reside on the same volume. If they do not, FSpExchangeFiles returns the result code diffVolErr.

To exchange the contents of files with named forks other than the data and resource forks, or of files larger than 2 GB, use the FSExchangeObjects , PBExchangeObjectsSync , or PBExchangeObjectsAsync function. 
Special Considerations

The “compatibility code,” by which FSpExchangeFiles attempted to perform the file exchange itself if it suspected that the underlying filesystem did not have Exchange capability, has been removed in Carbon on Mac OS 9 and X. 

Because other programs may have access paths open to one or both of the files exchanged, your application should have exclusive read/write access permission (fsRdWrPerm) to both files before calling FSpExchangeFiles. Exclusive read/write access to both files will ensure that FSpExchangeFiles doesn't affect another application because it prevents other applications from obtaining write access to one or both of the files exchanged.

FSpExchangeFiles does not respect the file-locked attribute; it will perform the exchange even if one or both of the files are locked. Obtaining exclusive read/write access to both files before calling FSpExchangeFiles ensures that the files are unlocked because locked files cannot be opened with write access.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpExchangeFiles (
   const FSSpec * source,
   const FSSpec * dest
){};



/*ChangedResource

Sets a flag in the resource’s resource map entry in memory to show that you’ve made changes to a resource’s data or to an entry in a resource map. 

void ChangedResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource whose data you’ve changed. The function sets the resChanged attribute for that resource in the resource map in memory. If the resChanged attribute for a resource has been set and your application calls the UpdateResFile function or quits, the Resource Manager writes the resource data for that resource (and for all other resources whose resChanged attribute is set) and the entire resource map to the resource fork of the corresponding file on disk. If the resChanged attribute for a resource has been set and your application calls the WriteResource function, the Resource Manager writes only the resource data for that resource to disk.

If the given handle isn’t a handle to a resource, if the modified resource data can’t be written to the resource fork, or if the resProtected attribute is set for the modified resource, the function does nothing. To find out whether any of these errors occurred, call the ResError function.
Discussion

If you change information in the resource map with a call to the SetResInfo or SetResAttrs function and then call ChangedResource and UpdateResFile, the Resource Manager still writes both the resource map and the resource data to disk. If you want any of your changes to the resource map or resource data to be temporary, you must restore the original information before the Resource Manager updates the resource fork on disk.

After writing a resource to disk, the Resource Manager clears the resource’s resChanged attribute in the appropriate entry of the resource map in memory.

When your application calls this function, the Resource Manager attempts to reserve enough disk space to contain the changed resource. The function reserves space every time you call it, but the resource is not actually written until you call WriteResource or UpdateResFile. Thus, if you call ChangedResource several times before the resource is actually written, the function reserves much more space than is needed. If the resource is large, you may unexpectedly run out of disk space. When the resource is actually written, the file’s end-of-file (EOF) is set correctly, and the next call to ChangedResource will work as expected.

If the modified resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call UpdateResFile or WriteResource, the Resource Manager won’t know that the resource data has been changed. Thus, the function won’t write the modified resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to ChangedResource.

If your application frequently changes the contents of resources (especially large resources), you should call WriteResource or UpdateResFile immediately after calling ChangedResource. 

If you need to make changes to a purgeable resource using functions that may cause the Memory Manager to purge the resource, you should make the resource temporarily not purgeable. To do so, use the Memory Manager functions HGetState, HNoPurge, and HSetState to make sure the resource data remains in memory while you change it and until the resource data is written to disk. (You can’t use the SetResAttrs function for this purpose, because the changes don’t take effect immediately.) First call HGetState and HNoPurge, then change the resource as necessary. To make a change to a resource permanent, use ChangedResource and UpdateResFile or WriteResource; then call HSetState when you’re finished. Or, instead of calling WriteResource to write the resource data immediately, you can call the SetResPurge function with the install parameter set to TRUE before making changes to purgeable resource data.

If your application doesn’t make its resources purgeable, or if the changes you are making to a purgeable resource don’t involve functions that may cause the resource to be purged, you don’t need to take these precautions 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void ChangedResource (
   Handle theResource
){};


/*HomeResFile

Gets the file reference number associated with a particular resource.

short HomeResFile (
   Handle theResource
);
Parameters
theResource

A handle to the resource for which you wish to get the associated file reference number.
Return Value

The file reference number for the resource fork containing the specified resource. If the given handle isn’t a handle to a resource, the function returns –1, and the ResError function returns the result code resNotFound. If HomeResFile returns 0, the resource is in the System file’s resource fork. If it returns 1, the resource is ROM-resident.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short HomeResFile (
   Handle theResource
){};











/*LMSetHeapEnd

(Deprecated in Mac OS X v10.4. There is no replacement; this function was included to facilitate porting legacy applications to Carbon, but it serves no useful purpose in Mac OS X.)

void LMSetHeapEnd (
   Ptr value
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
LowMem.h*/
void LMSetHeapEnd (
   Ptr value
){};


/*Obtaining Volume Information
pascal OSErr PBHGetVInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetVInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBSetVInfo		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBSetVInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBSetVInfoAsync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVolParms	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetVolParmsSync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVolParmsAsync
   				(HParmBlkPtr paramBlock);*/
pascal OSErr PBHGetVolParms	(HParmBlkPtr paramBlock, Boolean async){};

/*Searching a Catalog
pascal OSErr PBCatSearch	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBCatSearchSync	(HParmBlkPtr paramBlock);
pascal OSErr PBCatSearchAsync
   				(HParmBlkPtr paramBlock);*/
pascal OSErr PBCatSearch	(HParmBlkPtr paramBlock, Boolean async){};


/*Unique1ID

Gets a resource ID that’s unique with respect to resources in the current resource file.

short Unique1ID (
   ResType theType
);
Parameters
theType

A resource type.
Return Value

A resource ID greater than 0 that isn’t currently assigned to any resource of the specified type in the current resource file.
Discussion

You should use this function before adding a new resource to ensure that you don’t duplicate a resource ID and override an existing resource. 

To check for errors, call the ResError function.

For more information about restrictions on resource IDs for specific resource types, see ResID.

In versions of system software earlier than System 7, this function may return a resource ID in the range 0 through 127, which is generally reserved for system resources. You should check that the resource ID returned is not in this range. If it is, call Unique1ID again, and continue doing so until you get a resource ID greater than 127.

In System 7 and later versions, this function won’t return a resource ID of less than 128. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short Unique1ID (
   ResType theType
){};


/*UpdateResFile

Updates the resource map and resource data for a resource fork without closing it.

void UpdateResFile (
   short refNum
);
Parameters
refNum

A file reference number for a resource fork. If there’s no open resource fork with the given reference number, the function does nothing, and the ResError function returns the result code resNotFound. If the value of the refNum parameter is 0, it represents the System file’s resource fork. If you call this function but the mapReadOnly attribute of the resource fork is set, the function does nothing, and the ResError function returns the result code resAttrErr. 
Discussion

Given the reference number of a file whose resource fork is open, this function performs three tasks. The first task is to change, add, or remove resource data in the file’s resource fork to match the resource map in memory. Changed resource data for each resource is written only if that resource’s resChanged bit has been set by a successful call to the ChangedResource or AddResource function. The UpdateResFile function calls the WriteResource function to write changed or added resources to the resource fork.

The second task is to compact the resource fork, closing up any empty space created when a resource was removed, made smaller, or made larger. If a resource is made larger, the Resource Manager writes it at the end of the resource fork rather than at its original location. It then compacts the space occupied by the original resource data. The actual size of the resource fork is adjusted when a resource is removed or made larger, but not when a resource is made smaller.

The third task is to write the resource map in memory to the resource fork if your application has called the ChangedResource function for any resource listed in the resource map or if it has added or removed a resource. All changes to resource information in the resource map become permanent at this time; if you want any of these changes to be temporary, you must restore the original information before calling UpdateResFile.

Because the CloseResFile function calls UpdateResFile before it closes the resource fork, you need to call UpdateResFile directly only if you want to update the file without closing it.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void UpdateResFile (
   short refNum
){};


/*GetDiskFragment

Locates and possibly also loads a fragment contained in a file’s data fork into your application’s context.

OSErr GetDiskFragment (
   const FSSpec * fileSpec,
   UInt32 offset,
   UInt32 length,
   ConstStr63Param fragName,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
);
Parameters
fileSpec

A pointer to a file system specification that identifies the disk-based fragment to load. 
offset

The number of bytes from the beginning of the file’s data fork at which the beginning of the fragment is located. 
length

The length (in bytes) of the fragment. Specify the constant kWholeFork for this parameter if the fragment extends to the end-of-file of the data fork. Specify a nonzero value for the exact length of the fragment.
fragName

An optional name of the fragment. (This information is used primarily to allow you to identify the fragment during debugging. 
loadFlags

A flag that specifies the operation to perform on the fragment.The Code Fragment Manager recognizes the constants described in “Load Flag, Symbol Class, and Fragment Locator Constants”. 
connID

On return, a pointer to the connection ID that identifies the connection to the fragment. You can pass this ID to other Code Fragment Manager functions. 
mainAddr

On return, a pointer to the main address of the fragment. The value returned is specific to the fragment itself. Your application can use this parameter for its own purposes. 
errMessage

On return, the name of the fragment that could not successfully be loaded. This parameter is meaningful only if the call to GetDiskFragment fails. 
Return Value

A result code. See “Code Fragment Manager Result Codes”. The kFindLib constant in the loadFlags parameter specifies that the Code Fragment Manager search for the specified fragment. If the fragment is already prepared and connected to your application, GetDiskFragment returns fragNoErr. If the specified fragment is not found, GetDiskFragment returns the result code fragLibNotFound. If the specified fragment is found but could not be connected to your application, the function returns fragLibConnErr.
Discussion

Loading involves finding the specified fragment, reading it into memory (if it is not already in memory), and preparing it for execution. The Code Fragment Manager attempts to resolve all symbols imported by the fragment; to do so may involve loading import libraries.

If the fragment loading fails, the Code Fragment Manager returns an error code. Note, however, that the error encountered is not always in the fragment you asked to load. Rather, the error might have occurred while attempting to load an import library that the fragment you want to load depends on. For this reason, the Code Fragment Manager also returns, in the errMessage parameter, the name of the fragment that caused the load to fail. Although fragment names are restricted to 63 characters, the errMessage parameter is declared as type Str255; doing this allows future versions of the Code Fragment Manager to return a more informative message in the errMessage parameter. 
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

On Mac OS X, GetDiskFragment does not include the folder containing the root fragment (assuming that it is different from the application fragment) in its search path for import libraries. For example, say your application used a special folder to store plugins. If that folder also contained special libraries for those plugins, then calling GetDiskFragment to load a plugin would not find those libraries. 

The workaround is to make sure that any import libraries you require are in the Code Fragment Manager's search path (such as by designating an application library subfolder in the code fragment resource, or placing the libraries in the application's container). For more details of how the Code Fragment Manager searches for import libraries, see Mac OS Runtime Architectures. 
Declared In
CodeFragments.h*/
OSErr GetDiskFragment (
   const FSSpec * fileSpec,
   UInt32 offset,
   UInt32 length,
   ConstStr63Param fragName,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
){};



/*CloseConnection

Closes a connection to a fragment.

OSErr CloseConnection (
   CFragConnectionID * connID
);
Parameters
connID

A pointer to a connection ID. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The CloseConnection function closes the connection to a fragment indicated by the connID parameter. CloseConnection decrements the count of existing connections to the specified fragment and, if the resulting count is 0, calls the fragment’s termination function and releases the memory occupied by the code and data sections of the fragment. If the resulting count is not 0, any per-connection data is released but the code section remains in memory.

When a fragment is unloaded as a result of its final connection having been closed, all libraries that depend on that fragment are also released, provided that their usage counts are also 0.

The Code Fragment Manager automatically closes any connections that remain open at the time ExitToShell is called for your application, so you need to call CloseConnection only for fragments you wish to unload before your application terminates. 
Special Considerations

You can close a connection only to the root of a loading sequence (that is, the fragment whose loading triggered the entire load chain).
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/

OSErr CloseConnection (
   CFragConnectionID * connID
){};

/*PBCatalogSearchAsync

Searches for objects traversed by a catalog iterator that match a given set of criteria.

void PBCatalogSearchAsync (
   FSCatalogBulkParam * paramBlock
);
Parameters
paramBlock

A pointer to a catalog information parameter block. See FSCatalogBulkParam for a description of the FSCatalogBulkParam data type.
Discussion

The relevant fields of this parameter are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. When the entire volume has been searched, errFSNoMoreItems is returned. 
iterator 

On input, the iterator to use. Objects traversed by this iterator are matched against the criteria specified by the searchParams field. You can obtain a catalog iterator with the function FSOpenIterator , or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, this iterator must be created with the kFSIterateSubtree option and the container must be the root directory of a volume. See FSIterator for more information on the FSIterator data type. 
searchParams 

On input, a pointer to an FSSearchParams structure containing the search criteria. You can match against the object’s name in Unicode and by the fields in an FSCatalogInfo structure. You may use the same search bits as passed in the ioSearchBits field to the PBCatSearchSync and PBCatSearchAsync functions; they control the corresponding FSCatalogInfo fields. See Catalog Search Masks for a description of the search bits.There are a few new search criteria supported by PBCatalogSearchAsync but not by PBCatSearchSync and PBCatSearchAsync. These new search criteria are indicated by the constants described in Catalog Search Constants.If the searchTime field of this structure is non-zero, it is interpreted as a Time Manager duration; the search may terminate after this duration even if maximumItems objects have not been returned and the entire catalog has not been scanned. If searchTime is zero, there is no time limit for the search.If you are searching by any criteria other than name, you must set the searchInfo1 and searchInfo2 fields of the structure in this field to point to FSCatalogInfo structures containing the values to match against. 
maximumItems 

On input, the maximum number of items to return for this call. 
actualItems 

On output, the actual number of items returned for this call. 
containerChanged 

On output, a Boolean value indicating whether the container’s contents have changed. If true, the container’s contents changed since the previous PBCatalogSearchAsync call. Objects may still be returned even though the container changed. Note that if the container has changed, then the total set of items returned may be incorrect; some items may be returned multiple times, and some items may not be returned at all. 
whichInfo 

On input, a bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this field. See Catalog Information Bitmap Constants for a description of the bits in this field. 
catalogInfo 

On output, a pointer to an array of FSCatalogInfo structures; one for each found item. On input, the catalogInfo field should point to an array of maximumItems catalog information structures.This field is optional; if you do not wish any catalog information returned, pass NULL here. 
refs 

On output, a pointer to an array of FSRef structures; one for each returned item. On input, if you want an FSRef for each item found, pass a pointer to an array of maximumItems FSRef structures. Otherwise, pass NULL. 
names 

On output, a pointer to an array of filenames; one for each returned item. On input, if you want the Unicode filename for each item found, pass a pointer to an array of maximumItems HFSUniStr255 structures. Otherwise, pass NULL. 

A single search may span more than one call to PBCatalogSearchAsync. The call may complete with no error before scanning the entire volume. This typically happens because the time limit ( searchTime) has been reached or maximumItems items have been returned. If the search is not completed, you can continue the search by making another call to PBCatalogSearchAsync and passing the updated iterator returned by the previous call in the iterator field.

Before calling this function, you should determine that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
void PBCatalogSearchAsync (
   FSCatalogBulkParam * paramBlock
){};


/*DisposeIOCompletionUPP

Disposes of a universal procedure pointer (UPP) to your completion callback function.

void DisposeIOCompletionUPP (
   IOCompletionUPP userUPP
);
Parameters
userUPP

The universal procedure pointer to dispose. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Discussion

See IOCompletionProcPtr for more information about completion functions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void DisposeIOCompletionUPP (
   IOCompletionUPP userUPP
){};


/*PBGetFCBInfoSync

Gets information about an open file from the file control block. (Deprecated in Mac OS X v10.4. Use PBGetForkCBInfoSync instead.)

OSErr PBGetFCBInfoSync (
   FCBPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a file control block parameter block. See FCBPBRec for a description of the FCBPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. You should pass a pointer to a Str31 value if you want the name of the file returned. If you pass NULL, no filename is returned. On output, if PBGetFCBInfoSync executes successfully, a pointer to the name of the specified open file. 
ioVRefNum 

On input, a volume specification. If you specify a valid index number in the ioFCBIndx field, the File Manager returns information on the file having that index in the FCB buffer on the volume specified in this field. This field may contain a drive number or volume reference number. If the value of ioVRefNum is 0, all open files are indexed; otherwise, only open files on the specified volume are indexed. 
ioRefNum 

On input, if the ioFCBIndx field is 0, the file reference number of the file to get information about. If the value of ioFCBIndx is positive, the ioRefNum field is ignored on input and contains the file reference number on output. 
ioFCBIndx 

On input, an index. If the value of ioFCBIndx is positive, the File Manager returns information about the file whose index in the FCB buffer is ioFCBIndx and that is located on the volume specified in the ioVRefNum field.If the value of ioFCBIndx is 0, the File Manager returns information about the file whose file reference number is specified by the ioRefNum field. 
ioFCBFlNm 

On output, the file ID. 
ioFCBFlags 

On output, file status flags. See FCB Flags for a description of the bits in this field. 
ioFCBStBlk 

On output, the first allocation block of the file. 
ioFCBEOF 

On output, the logical size (the logical end-of-file) of the file. 
ioFCBPLen 

On output, the physical size (the physical end-of-file) of the file. 
ioFCBCrPs 

On output, the current position of the file mark. 
ioFCBVRefNum 

On output, the volume reference number. 
ioFCBClpSiz 

On output, the file clump size. 
ioFCBParID 

On output, the directory ID of the file’s parent directory. 

To get information about a fork control block, use one of the functions, FSGetForkCBInfo , PBGetForkCBInfoSync , or PBGetForkCBInfoAsync. 
Special Considerations

On OS X, the value returned by PBGetFCBInfoSync in the ioFCBPLen field may differ from the physical file length reported by FSGetCatalogInfo, PBGetCatInfo, and related functions. When a write causes a file to grow in size, the physical length reported by FSGetCatalogInfo and similar calls increases by the clump size, which is a multiple of the allocation block size. However, the physical length returned by PBGetFCBInfoSync changes according to the allocation block size and the file lengths returned by the respective functions get out of sync.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetFCBInfoSync (
   FCBPBPtr paramBlock
){};


/*PLstrcat

(Deprecated in Mac OS X v10.4. Use Core Foundation strings (CFStrings) instead. See CFString Reference.)

StringPtr PLstrcat (
   StringPtr str1,
   ConstStr255Param str2
);
Parameters
str1
str2
Return Value
Discussion
Special Considerations

If you need to convert Pascal strings, you can use functions like CFStringCreateWithPascalString to do so.
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PLStringFuncs.h*/

StringPtr PLstrcat (
   StringPtr str1,
   ConstStr255Param str2
){};




/*NewThreadEntryUPP


ThreadEntryUPP NewThreadEntryUPP (
   ThreadEntryProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ThreadEntryUPP data type.
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/

ThreadEntryUPP NewThreadEntryUPP (
   ThreadEntryProcPtr userRoutine
){};


/*GetString

Loads a string from a string ('STR') resource into memory. (Deprecated in Mac OS X v10.4. Use CFBundleCopyLocalizedString instead.)

StringHandle GetString (
   short stringID
);
Parameters
stringID

The resource ID of the string ('STR ') resource containing the string. 
Return Value

A handle to a string with the specified resource ID. If necessary, GetString reads the handle form the resource file. If GetString cannot read the resource, it returns NULL. 
Discussion

GetString calls the GetResource function of the Resource Manager to access the string. This means that if the specified resource is already in memory, GetString simply returns its handle.

Like the NewString function, GetString returns a handle whose size is based upon the actual length of the string.

If your application uses a large number of strings, it is more efficient to store them in a string list ('STR#') resource than as individual resources in the resource file. You then use the GetIndString function to access each string in the list. 
Special Considerations

GetString does not create a copy of the string.

GetString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/
StringHandle GetString (
   short stringID
){};


/*CallComponentCanDo


ComponentResult CallComponentCanDo (
   ComponentInstance ci,
   short ftnNumber
);
Parameters
ci
Return Value

See the description of the ComponentResult data type.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentResult CallComponentCanDo (
   ComponentInstance ci,
   short ftnNumber
){};

/*ResolveAliasFile

Resolves an alias contained in an alias file. (Deprecated in Mac OS X v10.4. Use FSResolveAliasFile instead.)

Not recommended

OSErr ResolveAliasFile (
   FSSpec * theSpec,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased
);
Parameters
theSpec

A pointer to a file system specification (FSSpec) structure for the alias file you plan to open. If the function completes successfully, this FSSpec refers to the file or the directory that was referred to by the alias file.
resolveAliasChains

A Boolean value. Set this parameter to TRUE if you want ResolveAliasFile to resolve all aliases in a chain (for example, an alias file that refers to an alias file and so on), stopping only when it reaches the target file. Set this parameter to FALSE if you want to resolve only one alias file, even if the target is another alias file. 
targetIsFolder

A return parameter only. The ResolveAliasFile function returns TRUE in this parameter if the file specification structure in the parameter theSpec points to a directory or a volume; otherwise, ResolveAliasFile returns FALSE in this parameter. 
wasAliased

A return parameter only. The ResolveAliasFile function returns TRUE in this parameter if the file specification structure in the parameter theSpec points to an alias; otherwise, ResolveAliasFile returns FALSE in this parameter. 
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

If your application bypasses the Finder when manipulating documents, it should check for and resolve aliases itself by using the ResolveAliasFile function.

The ResolveAliasFile function first checks the catalog file for the file or directory specified in the parameter theSpec to determine whether it is an alias and whether it is a file or a directory. If the object is not an alias, ResolveAliasFile leaves theSpec unchanged, sets the targetIsFolder parameter to TRUE for a directory or volume and FALSE for a file, sets wasAliased to FALSE, and returns noErr. If the object is an alias, ResolveAliasFile resolves it, places the target in the parameter theSpec, and sets the wasAliased flag to TRUE.

When ResolveAliasFile finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAliasFile returns a result code of fnfErr and fills in the parameter theSpec with a complete file system specification structure describing the target (that is, its volume reference number, parent directory ID, and filename or folder name). The file system specification structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, use the file system specification structure to create a replacement for a missing file with the File Manager function FSpCreate.

If ResolveAliasFile receives an error code while resolving an alias, it leaves the input parameters as they are and exits, returning an error code. ResolveAliasFile can return any Resource Manager or File Manager errors.
Special Considerations

Before calling the ResolveAliasFile function, you should make sure that it is available by using the Gestalt function with the gestaltAliasMgrAttr selector. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAliasFile instead.
Declared In
Aliases.h*/

OSErr ResolveAliasFile (
   FSSpec * theSpec,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased
){};

/*MaxMem

Returns the size, in bytes, of the largest contiguous free block in the current heap zone. (Deprecated. There is no replacement function; you can assume that any reasonable memory allocation will succeed.)

Size MaxMem (
   Size * grow
);
Parameters
grow

On return, the maximum number of bytes by which the current heap zone can grow. After a call to MaxApplZone, MaxMem always sets this parameter to 0. 
Return Value

The size, in bytes, of the largest contiguous free block in the zone after the compacting and purging.
Discussion

In Mac OS 8 and 9, the MaxMem function compacts the current heap zone and purges all relocatable, unlocked, and purgeable blocks from the zone. If the current zone is the original application zone, the grow parameter is set to the maximum number of bytes by which the zone can grow. For any other heap zone, grow is set to 0. MaxMem does not actually expand the zone or call the zone’s grow-zone function.

In Mac OS X, the MaxMem function returns a large fixed value because applications run in a large, protected memory space.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Size MaxMem (
   Size * grow
){};


/*Manipulating Memory Addresses
pascal Ptr StripAddress		(Ptr address);
pascal Ptr Translate24To32	(Ptr addr24);*/
pascal Ptr StripAddress		(Ptr address){};


/*DelegateComponentCall

Allows your component to pass on a request to a specified component. 

long DelegateComponentCall (
   ComponentParameters * originalParams,
   ComponentInstance ci
);
Parameters
originalParams

A pointer to the ComponentParameters structure provided to your component by the Component Manager. 
ci

The component instance that is to process the request. The Component Manager provides a component instance to your component when it opens a connection to another component with the OpenComponent or OpenDefaultComponent function. You must specify a component instance; this function does not accept a component identifier. 
Return Value

The component result returned by the specified component. 
Discussion

Your component may supplement its capabilities by using the services of another component to directly satisfy application requests using this function. For example, you might want to create two similar components that provide different levels of service to applications. Rather than completely implementing both components, you could design one to rely on the capabilities of the other. In this manner, you have to implement only that portion of the more capable component that provides additional services.

You may also invoke the services of another component using the standard mechanisms used by applications. The Component Manager then passes the requests to the appropriate component, and your component receives the results of those requests.

Your component must open a connection to the component to which the requests are to be passed. Your component must close that connection when it has finished using the services of the other component.

Your component should never use this function with open or close requests from the Component Manager—always use the OpenComponent and CloseComponent functions to manage connections with other components. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

long DelegateComponentCall (
   ComponentParameters * originalParams,
   ComponentInstance ci
){};

/*MPDelayUntil

Blocks the calling task until a specified time. 

OSStatus MPDelayUntil (
   AbsoluteTime * expirationTime
);
Parameters
expirationTime

The time to unblock the task. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

You cannot call this function from a cooperative task. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPDelayUntil (
   AbsoluteTime * expirationTime
){};



/*_MPLibraryVersion

Determines the Multiprocessin g Services library version.

void _MPLibraryVersion (
   char ** versionCString,
   UInt32 * major,
   UInt32 * minor,
   UInt32 * release,
   UInt32 * revision
);
Parameters
versionCString
major
minor
release
revision
Return Value
Discussion
Version Notes
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
void _MPLibraryVersion (
   char ** versionCString,
   UInt32 * major,
   UInt32 * minor,
   UInt32 * release,
   UInt32 * revision
){};

/*PBHGetVInfoSync

Gets detailed information about a volume. (Deprecated in Mac OS X v10.4. Use PBGetVolumeInfoSync instead.)

OSErr PBHGetVInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HVolumeParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a buffer. If you specify a negative number in the ioVolIndex field, this buffer should hold the name of the volume for which to return information.On output, a pointer to the volume’s name. You should pass a pointer to a Str31 value if you want the name returned. If you pass NULL, no volume name is returned. 
ioVRefNum 

On input, a volume reference number or drive number for the volume for which to return information; or 0 for the default volume. If the ioVolIndex field is negative, the File Manager uses the value in the ioNamePtr field, along with the value specified in the ioVRefNum field, to determine the volume. If the value in ioVolIndex is 0, the File Manager attempts to access the volume using only the value in this field. On output, the volume reference number. 
ioVolIndex 

On input, an index used for indexing through all mounted volumes. If this value is positive, the File Manager uses it to find the volume for which to return information. For instance, if the value of ioVolIndex is 2, the File Manager attempts to access the second mounted volume in the VCB queue.If ioVolIndex is negative, the File Manager uses the values in the ioNamePtr and ioVRefNum fields to access the requested volume. If ioVolIndex is 0, the File Manager uses only the value in the ioVRefNum field. 
ioVCrDate 

On output, the date and time of the volume’s initialization. 
ioVLsMod 

On output, the date and time of the volume’s last modification. 
ioVAtrb 

On output, the volume attributes. See Volume Information Attribute Constants for a description of the volume attributes returned by this function. 
ioVNmFls 

On output, the number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field. 
ioVBitMap 

On output, the first block of the volume bitmap. 
ioVAllocPtr 

On output, the block at which the search for the next new file allocation should start. 
ioVNmAlBlks 

On output, the number of allocation blocks on the volume. 
ioVAlBlkSiz 

On output, the size of the allocation blocks. 
ioVClpSiz 

On output, the default clump size. 
ioAlBlSt 

On output, the first block in the volume block map. 
ioVNxtCNID 

On output, the next unused catalog node ID. 
ioVFrBlk 

On output, the number of unused allocation blocks. 
ioVSigWord 

On output, the volume signature. For HFS volumes, this is ‘BD’ for HFS Plus volumes, this is ‘H+’. 
ioVDrvInfo 

On output, the drive number. You can determine whether the given volume is online by inspecting the value of this field. For online volumes, the ioVDrvInfo field contains the drive number of the drive containing the specified volume and hence is always greater than 0. If the value returned in ioVDrvInfo is 0, the volume is either offline or ejected. 

Mac OS X does not support drive numbers; in Mac OS X, the File Manager always returns a value of 1 in this field.
ioVDRefNum 

On output, the driver reference number. You can determine whether the volume is offline or ejected by inspecting the value of this field. If the volume is offline, the value of ioVDRefNum is the negative of the drive number (which is cleared when the volume is placed offline; hence the ioVDrvInfo field for an offline volume is zero), and is a negative number. If the volume is ejected, the value of ioVDRefNum is the drive number itself, and thus is a positive number. For online volumes, ioVDRefNum contains a driver reference number; these numbers are always less than 0. 
ioVFSID 

On output, the file system handling this volume. 
ioVBkUp 

On output, the date and time of the volume’s last backup. 
ioVSeqNum 

Used internally. 
ioVWrCnt 

On output, the volume write count. 
ioVFilCnt 

On output, the number of files on the volume. 
ioVDirCnt 

On output, the number of directories on the volume. 
ioVFndrInfo 

On output, Finder information for the volume. 

You can get information about all the online volumes by making repeated calls to PBHGetVInfoSync, starting with the value of the ioVolIndex field set to 1 and incrementing that value until PBHGetVInfoSync returns nsvErr.

If you need to obtain information about HFS Plus volumes, you should use the FSGetVolumeInfo function, or one of the corresponding parameter block calls, PBGetVolumeInfoSync and PBGetVolumeInfoAsync. The PBHGetVInfoSync function is still supported for HFS Plus volumes, but there is additional information returned by the FSGetVolumeInfo function (such as the date and time that the volume was last checked for consistency). 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to PBHGetVInfoSync returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.

If the value of ioVolIndex is negative, the File Manager uses ioNamePtr and ioVRefNum in the standard way to determine the volume. However, because PBHGetVInfoSync returns the volume name in the buffer whose address you passed in ioNamePtr, your input pathname will be modified. If you don't want your input pathname modified, make a copy of it and pass the copy to PBHGetVInfoSync.

The volume name returned by PBHGetVInfoSync is not a full pathname to the volume because it does not contain a colon.

For compatibility with older programs, some values returned by PBHGetVInfoSync are not what is stored in the volume's Volume Control Block (VCB). Specifically:
ioVNmAlBlks and ioVFrBlk are pinned to values which, when multiplied by ioVAlBlkSiz, are always less than 2 Gigabytes.
ioVNmAlBlks may not include the allocation blocks used by the catalog and extents overflow files. 
$4244 is returned in ioVSigWord for both HFS and HFS Plus volumes. 

For unpinned total and free byte counts, and for the real ioVSigWord, use PBXGetVolInfoSync instead of PBHGetVInfoSync.
Version Notes

In non-Carbon applications, you may pass a working directory reference in the ioVRefNum field; if you pass a working directory reference in that field, the number of files and directories in the specified directory is returned in the ioVNmFls field.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHGetVInfoSync (
   HParmBlkPtr paramBlock
){};


/*MPDeleteQueue

Deletes a message queue.

OSStatus MPDeleteQueue (
   MPQueueID queue
);
Parameters
queue

The ID of the message queue you want to delete. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

After calling MPDeleteQueue, the specified queue ID becomes invalid, and all internal resources associated with the queue (including queued messages) are reclaimed. Any tasks waiting on the queue are unblocked and their respective MPWaitOnQueue calls will return with the result code kMPDeletedErr.

Also see the function MPCreateQueue. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPDeleteQueue (
   MPQueueID queue
){};

/*MPWaitOnQueue

Obtains a message from a specified message queue. 

OSStatus MPWaitOnQueue (
   MPQueueID queue,
   void ** param1,
   void ** param2,
   void ** param3,
   Duration timeout
);
Parameters
queue

The ID of the message queue from which to receive the notification. 
param1

A pointer to a 32-bit variable. On return, this variable contains the first 32-bits of the notification message. Pass NULL if you do not need this portion of the message. 
param2

A pointer to a 32-bit variable. On return, the variable contains the second 32-bits of the notification message. Pass NULL if you do not need this portion of the message.
param3

A pointer to a 32-bit variable. On return, the variable contains the third 32-bits of the notification message. Pass NULL if you do not need this portion of the message.
timeout

The time to wait for a notification before timing out. See Timer Duration Constants for a list of constants you can use to specify the wait interval. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

This function receives a message from the specified message queue. If no messages are currently available, the timeout specifies how long the function should wait for one. Tasks waiting on the queue are handled in a first in, first out manner; that is, the first task to wait on the queue receives the message from the MPNotifyQueue call. 

After calling this function, when a message appears, it is removed from the queue and the three fields, param1, param2, and param3 are set to the values specified by the message text. Note these parameters are pointers to variables to be set with the message text.

If you call this function from a cooperative task, you should specify only kDurationImmediate for the timeout length; other waits will cause the task to block. 

Also see the function MPNotifyQueue. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPWaitOnQueue (
   MPQueueID queue,
   void ** param1,
   void ** param2,
   void ** param3,
   Duration timeout
){};

/*MPCreateQueue

Creates a message queue.

OSStatus MPCreateQueue (
   MPQueueID * queue
);
Parameters
queue

On return, the variable contains the ID of the newly created message queue. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If a queue could not be created, MPCreateQueue returns kMPInsufficientResourcesErr.
Discussion

This call creates a message queue, which can be used to notify (that is, send) and wait for (that is, receive) messages consisting of three 32-bit words in a preemptively safe manner.

Message queues are created from dynamically allocated internal resources. Other tasks may be competing for these resources so it is possible this function may not be able to create a queue. 

See also the functions MPDeleteQueue and MPSetQueueReserve. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPCreateQueue (
   MPQueueID * queue
){};

/*FSGetResourceForkName

Returns a Unicode string constant for the name of the resource fork. 

OSErr FSGetResourceForkName (
   HFSUniStr255 * resourceForkName
);
Parameters
resourceForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the resource fork. Currently, this is “RESOURCE_FORK”. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetResourceForkName (
   HFSUniStr255 * resourceForkName
){};


/*MPAllocateAligned

Allocates a nonrelocatable memory block.

Modified

LogicalAddress MPAllocateAligned (
   ByteCount size,
   UInt8 alignment,
   OptionBits options
);
Parameters
size

The size, in bytes, of the memory block to allocate. 
alignment

The desired alignment of the allocated memory block. See Memory Allocation Alignment Constants for a list of possible values to pass. Note that there will be a minimum alignment regardless of the requested alignment. If the requested memory block is 4 bytes or smaller, the block will be at least 4-byte aligned. If the requested block is greater than 4 bytes, the block will be at least 8-byte aligned. 
options

Any optional information to use with this call. See Memory Allocation Option Constants for a list of possible values to pass. 
Return Value

A pointer to the allocated memory. If the function cannot allocate the requested memory or the requested alignment, the returned address is NULL. 
Discussion

The memory referenced by the returned address is guaranteed to be accessible by the application's cooperative task and any preemptive tasks that it creates, but not by other applications or their preemptive tasks. Any existing nonglobal heap blocks are freed when the application terminates. As with all shared memory, you must explicitly synchronize access to allocated heap blocks using a notification mechanism.

You can replicate the effect of the older MPAllocate function by calling MPAllocateAligned with 32-byte alignment and no options. 

Also see the function MPFree. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Mac OS X does not support allocation of global (cross address space) or resident memory with this function. In addition, passing the kMPAllocateNoGrowthMask constant in the options parameter has no effect under Mac OS X, since memory allocation is done with sparse heaps.
Declared In
Multiprocessing.h*/

LogicalAddress MPAllocateAligned (
   ByteCount size,
   UInt8 alignment,
   OptionBits options
){};


/*MPFree

Frees memory allocated by MPAllocateAligned. 

void MPFree (
   LogicalAddress object
);
Parameters
object

A pointer to the memory you want to release. 
Return Value
Discussion

Also see the function MPAllocateAligned. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

void MPFree (
   LogicalAddress object
){};


/*MPGetAllocatedBlockSize

Returns the size of a memory block.

ByteCount MPGetAllocatedBlockSize (
   LogicalAddress object
);
Parameters
object

The address of the memory block whose size you want to determine. 
Return Value

The size of the allocated memory block, in bytes. 
Discussion
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

ByteCount MPGetAllocatedBlockSize (
   LogicalAddress object
){};


/*Driver Support Functions
pascal OSErr DriverInstall              (Ptr drvrPtr, short refNum);
pascal OSErr DriverInstallReserveMem    (Ptr drvrPtr, short refNum);
pascal OSErr DriverRemove               (short refNum);
pascal DCtlHandle GetDCtlEntry          (short refNum);*/
pascal OSErr DriverRemove               (short refNum){};
pascal DCtlHandle GetDCtlEntry          (short refNum){};
pascal OSErr DriverInstallReserveMem    (Ptr drvrPtr, short refNum){};

/*Opening and Closing Device Drivers
pascal OSErr OpenDriver   (ConstStr255Param name, short *drvrRefNum);
pascal OSErr PBOpen       (ParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBOpenSync   (ParmBlkPtr paramBlock);
pascal OSErr OpenSlot     (ParmBlkPtr paramBlock, Boolean async);
pascal short OpenDeskAcc  (ConstStr255Param deskAccName);
pascal OSErr CloseDriver  (short refNum);
pascal OSErr PBClose      (ParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBCloseSync  (ParmBlkPtr paramBlock);
pascal void  CloseDeskAcc (short refNum);*/
pascal OSErr CloseDriver  (short refNum){};
pascal OSErr OpenDriver   (ConstStr255Param name, short *drvrRefNum){};


/*Allocating and Releasing Nonrelocatable Blocks of Memory
pascal Ptr NewPtr		(Size byteCount);
pascal Ptr NewPtrSys		(Size byteCount);
pascal Ptr NewPtrClear		(Size byteCount);
pascal Ptr NewPtrSysClear	(Size byteCount);
pascal void DisposePtr		(Ptr p);*/
pascal Ptr NewPtrSys		(Size byteCount){};


/*Get1NamedResource

Gets a named resource in the current resource file.

Handle Get1NamedResource (
   ResType theType,
   ConstStr255Param name
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data.
name

A name that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds an entry for the resource in the current resource file’s resource map and the entry contains a valid handle, the function returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, Get1NamedResource attempts to read the resource into memory. If it can’t find the resource data, the function returns NULL, and the ResError function returns the result code resNotFound. The Get1NamedResource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code. 

If you call this function with a resource type that can’t be found in the resource map of the current resource file, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the current resource file’s resource map in memory for the specified resource. You can change the search order by calling the UseResFile function before Get1NamedResource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps for open resource forks, use the RGetResource function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1NamedResource (
   ResType theType,
   ConstStr255Param name
){};

/*MPCreateTimer

Creates a timer.

OSStatus MPCreateTimer (
   MPTimerID * timerID
);
Parameters
timerID

On return, the timerID contains the ID of the newly created timer. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

You can use a timer to notify an event, queue, or semaphore after a specified amount of time has elapsed. 

Timer objects are created from dynamically-allocated internal resources. Other tasks may be competing for these resources so it is possible this function may not be able to create one.

To specify the notification mechanism to signal, use the function MPSetTimerNotify.

Also see the functions MPDeleteTimer and MPArmTimer. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPCreateTimer (
   MPTimerID * timerID
){};


/*MPSetTimerNotify

Sets the notification information associated with a timer. 

OSStatus MPSetTimerNotify (
   MPTimerID timerID,
   MPOpaqueID anID,
   void * notifyParam1,
   void * notifyParam2,
   void * notifyParam3
);
Parameters
timerID

The ID of the timer whose notification information you want to set. 
notificationID

The ID of the notification mechanism to associate with the timer. This value should be the ID of an event group, a message queue, or a semaphore. 
notifyParam1

If anID specifies an event group, this parameter should contain the flags to set in the event group when the timer expires. If anID specifies a message queue, this parameter should contain the first 32-bits of the message to be sent to the message queue when the timer expires. 
notifyParam2

If anID specifies a message queue, this parameter should contain the second 32-bits of the message to be sent to the message queue when the timer expires. Pass NULL if you don’t need this parameter.
notifyParam3

If anID specifies a message queue, this parameter should contain the third 32-bits of the message sent to the message queue when the timer expires. Pass NULL if you don’t need this parameter.
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

When the timer expires, Multiprocessing Services checks the notification ID, and if it is valid, notifies the related notification mechanisms (that is, event groups, queues, or semaphores) you had specified in your MPSetTimerNotify calls. 

You can specify multiple notification mechanisms by calling this function several times. For example, you can call MPSetTimerNotify to specify a message queue and then call it again to specify a semaphore. When the timer expires, a message is sent to the message queue and the appropriate semaphore is signaled. You cannot, however, specify more than one notification per notification mechanism (for example, if you call MPSetTimerNotify twice, specifying different messages or message queues in each call, the second call will overwrite the first). Note that if a call to MPSetTimerNotify returns an error, any previous calls specifying the same timer are still valid; previously set notifications will still be notified when the timer expires. 

You can set the notification information at any time. If the timer is armed, it will modify the notification parameters dynamically. If the timer is disarmed, it will modify the notification parameters to be used for the next MPArmTimer call. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPSetTimerNotify (
   MPTimerID timerID,
   MPOpaqueID anID,
   void * notifyParam1,
   void * notifyParam2,
   void * notifyParam3
){};

/*MPArmTimer

Arms the timer to expire at a given time. 

OSStatus MPArmTimer (
   MPTimerID timerID,
   AbsoluteTime * expirationTime,
   OptionBits options
);
Parameters
timerID

The ID of the timer you want to arm. 
expirationTime

A pointer to a value that specifies when you want the timer to expire. Note that if you arm the timer with a time that has already passed, the timer expires immediately. 
options

Any optional actions. See Timer Option Masks for a list of possible values. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the timer has already expired, the reset does not take place and the function returns kMPInsufficientResourcesErr.
Discussion

The expiration time is an absolute time, which you can generate by calling the Driver Services Library function UpTime. When the timer expires, a notification is sent to the notification mechanism specified in the last MPSetTimerNotify call. If the specified notification ID has become invalid, no action is taken when the timer expires. The timer itself is deleted when it expires unless you specified the kMPPreserveTimerID option in the options parameter.

Also see the function MPCancelTimer. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPArmTimer (
   MPTimerID timerID,
   AbsoluteTime * expirationTime,
   OptionBits options
){};


/*MPCancelTimer

Cancels an armed timer. 

OSStatus MPCancelTimer (
   MPTimerID timerID,
   AbsoluteTime * timeRemaining
);
Parameters
timerID

The ID of the armed timer you want to cancel. 
timeRemaining

On return, the timeRemaining contains the time remaining before the timer would have expired. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the timer has already expired, this function returns kMPInsufficientResourcesErr.
Discussion

Also see the function MPArmTimer. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPCancelTimer (
   MPTimerID timerID,
   AbsoluteTime * timeRemaining
){};


/*MPDeleteTimer

Removes a timer. 

OSStatus MPDeleteTimer (
   MPTimerID timerID
);
Parameters
timerID

The ID of the timer you want to remove. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

After deletion, the timer ID becomes invalid, and all internal resources associated with the timer are reclaimed.

Also see the function MPCreateTimer. 
Version Notes

Introduced with Multiprocessing Services 2.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPDeleteTimer (
   MPTimerID timerID
){};

/*CallComponentTarget


ComponentResult CallComponentTarget (
   ComponentInstance ci,
   ComponentInstance target
);
Parameters
ci
target
Return Value

See the description of the ComponentResult data type.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentResult CallComponentTarget (
   ComponentInstance ci,
   ComponentInstance target
){};



/*GetComponentIndString


OSErr GetComponentIndString (
   Component aComponent,
   Str255 theString,
   short strListID,
   short index
);
Parameters
aComponent
theString
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 3.0 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr GetComponentIndString (
   Component aComponent,
   Str255 theString,
   short strListID,
   short index
){};

/*U64SetU


UInt64 U64SetU (
   UInt32 value
);
Parameters
value
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

UInt64 U64SetU (
   UInt32 value
){};


/*U64Multiply


UInt64 U64Multiply (
   UInt64 left,
   UInt64 right
);
Parameters
xparam
yparam
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

UInt64 U64Multiply (
   UInt64 left,
   UInt64 right
){};


/*U32SetU


UInt32 U32SetU (
   UInt64 value
);
Parameters
value
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
UInt32 U32SetU (
   UInt64 value
){};

/*U64Div


Under evaluation

UInt64 U64Div (
   UInt64 dividend,
   UInt64 divisor
);
Parameters
dividend
divisor
Return Value
Availability
Declared In
Math64.h*/
UInt64 U64Div (
   UInt64 dividend,
   UInt64 divisor
){};


/*HRename

Renames a file, directory, or volume. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr HRename (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   ConstStr255Param newName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

A directory ID. 
oldName

An existing filename, directory name, or volume name. 
newName

The new filename, directory name, or volume name.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Given the name of a file or directory in the oldName parameter, HRename changes it to the name in the newName parameter. Given a volume name in the oldName parameter or a volume reference number in the vRefNum parameter, HRename changes the name of the volume to the name in newName. Access paths currently in use aren’t affected by this function.

If a file ID reference exists for a file you are renaming, the file ID remains with the renamed file.

To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Special Considerations

You cannot use HRename to change the directory in which a file resides. To move a file or directory, use the FSpCatMove, PBCatMoveSync, or PBCatMoveAsync functions. 

If you’re renaming a volume, make sure that both names end with a colon.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HRename (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   ConstStr255Param newName
){};


/*DirCreate

Creates a new directory. (Deprecated in Mac OS X v10.4. Use FSCreateDirectoryUnicode instead.)

OSErr DirCreate (
   short vRefNum,
   long parentDirID,
   ConstStr255Param directoryName,
   long * createdDirID
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
parentDirID

The directory ID of the parent directory. If the parent directory ID is 0 and the volume specified in the vRefNum parameter is the default volume, the new directory is placed in the default directory of the volume. If the parent directory ID is 0 and the volume specified in the vRefNum parameter is a volume other than the default volume, the new directory is placed in the root directory of the volume.To create a directory at the root of a volume, regardless of whether that volume is the current default volume, pass the constant fsRtDirID(2) in this parameter. 
directoryName

The name of the new directory. 
createdDirID

On return, a pointer to the directory ID of the new directory. Note that a directory ID, unlike a volume reference number, is a long integer.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The date and time of the new directory’s creation and last modification are set to the current date and time.

To create a directory with a Unicode name, use the function FSCreateDirectoryUnicode , or one of the corresponding parameter block calls, PBCreateDirectoryUnicodeSync and PBCreateDirectoryUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr DirCreate (
   short vRefNum,
   long parentDirID,
   ConstStr255Param directoryName,
   long * createdDirID
){};

/*U64ShiftRight


UInt64 U64ShiftRight (
   UInt64 value,
   UInt32 shift
);
Parameters
value
shift
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

UInt64 U64ShiftRight (
   UInt64 value,
   UInt32 shift
){};

/*CharacterByteType

Identifies a byte in a text buffer as a single-byte character or as the first or second byte of a double-byte character. (Deprecated in Mac OS X v10.4. You should update your application to handle Unicode text. There is no replacement function because Unicode handles encoding in a different manner.)

short CharacterByteType (
   Ptr textBuf,
   short textOffset,
   ScriptCode script
);
Parameters
textBuf

A pointer to a text buffer containing the byte to be identified. 
textOffset

The offset to the byte to be identified. The offset is measured in bytes; the first byte has an offset of 0. 
script

A value that specifies the script system of the text in the buffer. Constants for all defined script codes are listed on “Meta Script Codes”. To specify the font script, pass smCurrentScript in this parameter. 
Return Value

One of three identifications: a single-byte character, the first byte of a double-byte character, or the second byte of a double-byte character. The first byte of a double-byte character—the one at the lower offset in memory—is the high-order byte the second byte of a double-byte character—the one at the higher offset—is the low-order byte. This is the same order in which text is processed and numbers are represented. 
Discussion

The script system associated with the character you wish to examine must be enabled in order for the function to provide useful information. For example, if only the Roman script system is available and you attempt to identify a byte in a run of double-byte characters, the CharacterByteType function returns 0, indicating that the byte is a single-byte character.

For single-byte script systems, the character-type tables reside in the string-manipulation ('itl2') resource and reflect region-specific or language-specific differences in uppercase conventions.

For double-byte script systems, the character-type tables reside in the encoding/rendering ('itl5') resource, not the string-manipulation resource. Whenever you call CharacterByteType, the necessary character-set encoding information is taken from the encoding/rendering resource. You cannot use the GetIntlResource function to access double-byte character-type tables directly.

From byte value alone, it is not possible to distinguish the second byte of a double-byte character from a single-byte character. CharacterByteType differentiates the second byte of a double-byte character from a single-byte character by assuming that the byte at offset 0 is the first byte of a character. With that assumption, it then sequentially identifies the size and starting position of each character in the buffer up to textOffset. 
Special Considerations

If you specify smCurrentScript for the script parameter, the value returned by CharacterByteType can be affected by the state of the font force flag. It is unaffected by the state of the international resources selection flag.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short CharacterByteType (
   Ptr textBuf,
   short textOffset,
   ScriptCode script
){};

/*FreeMem

Returns the total amount of free space in the current heap zone. (Deprecated. There is no replacement function; you can assume that any reasonable memory allocation will succeed.)

long FreeMem ();
Return Value

Returns a fixed value for heap size that is compatible with most applications.
Discussion

In Mac OS 8 and 9, this function returns the total amount of free space in the current heap zone. In Mac OS X, this function always returns a large fixed value because applications run in a large, protected memory space.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Special Considerations

Even though FreeMem does not move or purge memory, you should not call it at interrupt time because the heap might be in an inconsistent state.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
long FreeMem (){};


/*PBGetEOFSync

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use PBGetForkSizeSync instead.)

OSErr PBGetEOFSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, a file reference number for the open file. 
ioMisc 

On output, a pointer to the logical size (the logical end-of-file) of the given file. Because the ioMisc field is of type Ptr, you’ll need to coerce the value to a long integer to interpret the value correctly. 

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetEOFSync (
   ParmBlkPtr paramBlock
){};

/*MaxBlock

Returns a fixed value for block size that is compatible with most applications. (Deprecated. There is no replacement function; you can assume that any reasonable memory allocation will succeed.)

long MaxBlock ();
Return Value

The maximum contiguous space, in bytes, that you could obtain after compacting the current heap zone. MaxBlock does not actually do the compaction. 
Discussion

In Mac OS X, this function always returns a large value because virtual memory is always available to fulfill any request for memory.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
long MaxBlock (){};


/*PBXGetVolInfoSync

Returns information about a volume, including size information for volumes up to 2 terabytes. (Deprecated in Mac OS X v10.4. Use FSGetVolumeInfo instead.)

OSErr PBXGetVolInfoSync (
   XVolumeParamPtr paramBlock
);
Parameters
paramBlock

A pointer to an extended volume parameter block. See XVolumeParam for a description of the XVolumeParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a buffer. You should pass a pointer to a Str31 value if you want the volume name returned; otherwise, pass NULL. If you specify a negative number in the ioVolIndex field, this buffer should hold the name of the volume for which to return information.the volume’s name. On output, a pointer to the volume’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. If the value in the ioVolIndex field is negative, the File Manager uses the name in the ioNamePtr field, along with the value in the ioVRefNum field, to determine the volume. If the value in ioVolIndex is 0, the File Manager attempts to access the volume using only the value in this field.On output, the volume reference number. 
ioXVersion 

On input, the version of the extended volume parameter block. Currently, this value is 0. 
ioVolIndex 

On input, an index used for indexing through all the mounted volumes. If this value is positive, the File Manager uses it to find the volume for which to return information. For instance, if the value of ioVolIndex is 2, the File Manager attempts to access the second mounted volume in the VCB queue.If ioVolIndex is negative, the File Manager uses the values in the ioNamePtr and ioVRefNum fields to access the requested volume. If ioVolIndex is 0, the File Manager uses only the value in the ioVRefNum field. 
ioVCrDate 

On output, the date and time of the volume’s creation (initialization). 
ioVLsMod 

On output, the date and time that the volume was last modified. 
ioVAtrb 

On output, the volume attributes. See Volume Information Attribute Constants for a description of these attributes. 
ioVNmFls 

On output, the number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field. 
ioVBitMap 

On output, the first block of the volume bitmap. 
ioVAllocPtr 

On output, the block where the next new file allocation search should start. 
ioVNmAlBlks 

On output, the number of allocation blocks on the volume. 
ioVAlBlkSiz 

On output, the allocation block size for the volume. 
ioVClpSiz 

On output, the volume’s default clump size. 
ioAlBlSt 

On output, the first block in the volume block map. 
ioVNxtCNID 

On output, the next unused catalog node ID. 
ioVFrBlk 

On output, the number of free (unused) allocation blocks on the volume. 
ioVSigWord 

On output, the volume signature. For HFS volumes, this is ‘BD’ for HFS Plus volumes, this is ‘H+’. 
ioVDrvInfo 

On output, the drive number. You can determine whether the given volume is online by inspecting the value of this field. For online volumes, the ioVDrvInfo field contains the drive number of the drive containing the specified volume and hence is always greater than 0. If the value returned in ioVDrvInfo is 0, the volume is either offline or ejected. 
ioVDRefNum 

On output, the driver reference number. You can determine whether the volume is offline or ejected by inspecting the value of this field. If the volume is offline, the value of ioVDRefNum is the negative of the drive number (which is cleared when the volume is placed offline; hence the ioVDrvInfo field for an offline volume is zero), and is a negative number. If the volume is ejected, the value of ioVDRefNum is the drive number itself, and thus is a positive number. For online volumes, ioVDRefNum contains a driver reference number; these numbers are always less than 0. 
ioVFSID 

On output, the file system ID for the file system handling this volume. 
ioVBkUp 

On output, the date and time that the volume was last backed up. 
ioVSeqNum 

Used internally. 
ioVWrCnt 

On output, the volume write count. 
ioVFilCnt 

On output, the number of files on the volume. 
ioVDirCnt 

On output, the number of directories on the volume. 
ioVFndrInfo 

On output, Finder information for the volume. 
ioVTotalBytes 

On output, the total number of bytes on the volume. 
ioVFreeBytes 

On output, the number of free bytes on the volume. 

The PBXGetVolInfoSync function is similar to the PBHGetVInfoSync function except that it returns additional volume space information in 64-bit integers and does not modify the information copied from the volume’s volume control block (VCB). Systems that support PBXGetVolInfoSync will have the gestaltFSSupports2TBVols bit set in the response returned by the gestaltFSAttr Gestalt selector. See Inside Mac OS X: Gestalt Manager Reference for a description of the gestaltFSAttr selector and of the bits that may be returned in the response. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to PBXGetVolInfoSync returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBXGetVolInfoSync (
   XVolumeParamPtr paramBlock
){};

/*Mounting and Unmounting Volumes
pascal OSErr PBMountVol		(ParmBlkPtr paramBlock);
pascal OSErr PBUnmountVol	(ParmBlkPtr paramBlock);
pascal OSErr PBEject		(ParmBlkPtr paramBlock);
pascal OSErr PBOffLine		(ParmBlkPtr paramBlock);*/
pascal OSErr PBEject		(ParmBlkPtr paramBlock){};


/*PBHOpenDenySync

Opens a file’s data fork using the access deny modes.

OSErr PBHOpenDenySync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. The function returns the result code opWrErr if you’ve requested write permission and you have already opened the file for writing in that case, the existing file reference number is returned in ioRefNum. You should not use this reference number unless your application originally opened the file.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname for the file. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file. Pass 0 to indicate the default volume. 
ioRefNum 

On output, the file reference number for the file. 
ioDenyModes 

On input, the type of access you are requesting to the fork. See File Access Permission Constants for a description of the types of access that you can request. 
ioDirID 

On input, the parent directory ID of the file. 

You should use the PBHOpenDenySync and PBHOpenRFDenySync functions (or their asynchronous counterparts, PBHOpenDenyAsync and PBHOpenRFDenyAsync ) if you want to ensure that you get the access permissions and deny-mode permissions that you request. PBHOpenDenySync is not retried in any way. If the file cannot be opened because of a deny conflict, the error afpDenyConflict is returned and the ioRefNum field is set to 0. 

You can check that the volume supports AFP deny-mode permissions by checking that the bHasOpenDeny bit is set in the vMAttrib field returned by the PBHGetVolParmsSync or PBHGetVolParmsAsync function. If you don’t want to special case volumes that support AFP deny mode permissions, you can use the File Manager permissions. See File Access Permission Constants for a description of how File Manager permissions are translated to AFP deny-mode permissions.

To open a file’s resource fork with access deny permissions, use the PBHOpenRFDenySync or PBHOpenRFDenyAsync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHOpenDenySync (
   HParmBlkPtr paramBlock
){};



/*PBGetUGEntrySync

Gets a user or group entry from the list of User and Group names and IDs on a local file server. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBGetUGEntrySync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetUGEntrySync (
   HParmBlkPtr paramBlock
){};

/*PBUnmountVol

Unmounts a volume. (Deprecated in Mac OS X v10.4. Use FSEjectVolumeSync instead.)

OSErr PBUnmountVol (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the VolumeParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioResult 

On output, the result code of the function. 
ioNamePtr 

On input, a pointer to the name of the volume. 
ioVRefNum 

On input, the volume reference number of the volume to unmount, or 0 for the default volume. 

The PBUnmountVol function unmounts the specified volume. All user files on the volume must be closed. Then, PBUnmountVol calls PBFlushVolSync to flush the volume and releases the memory used for the volume.

The PBUnmountVol function always executes synchronously. 
Special Considerations

Don’t unmount the startup volume. Doing so will cause a system crash.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnmountVol (
   ParmBlkPtr paramBlock
){};

/*CatMove

Moves files or directories from one directory to another on the same volume. (Deprecated in Mac OS X v10.4. Use FSMoveObject instead.)

OSErr CatMove (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   long newDirID,
   ConstStr255Param newName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The parent directory ID of the file or directory to move. 
oldName

The existing name of the file or directory to move. 
newDirID

If the newName parameter is empty, the directory ID of the destination directory; otherwise, the parent directory ID of the destination directory.
newName

The name of the destination directory. If a valid directory name is provided in this parameter, the destination directory’s parent directory is specified in the newDirID parameter. However, you can specify an empty name for newName, in which case newDirID should be set to the directory ID of the destination directory.

It is usually simplest to specify the destination directory by passing its directory ID in the newDirID parameter and by setting newName to an empty name. To specify an empty name, set newName to ':'.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

CatMove is strictly a file catalog operation; it does not actually change the location of the file or directory on the disk.

The CatMove function cannot move a file or directory to another volume (that is, the vRefNum parameter is used in specifying both the source and the destination). Also, you cannot use it to rename files or directories; to rename a file or directory, use HRename.

If you need to move files or directories with named forks other than the data and resource forks, with long Unicode names, or files larger than 2GB, you should use the FSMoveObject function, or one of the corresponding parameter block calls, PBMoveObjectSync and PBMoveObjectAsync. 
Version Notes

On Mac OS 9, CatMove can change the location of locked files (files whose kHFSFileLockedBit bit is set). On Mac OS X, locked files cannot be moved, and CatMove returns permErr if called on a locked file.

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr CatMove (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   long newDirID,
   ConstStr255Param newName
){};

/*PBHSetFLockSync

Locks a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBHSetFLockSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a name for the file or directory to lock. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the parent directory ID of the file or directory to lock. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use PBHSetFLockSync to lock a directory. Otherwise, you can only use this function to lock a file.

After you lock a file, all new access paths to that file are read-only. Access paths currently in use aren’t affected. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHSetFLockSync (
   HParmBlkPtr paramBlock
){};

/*HSetVol

Sets the default volume and the default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HSetVol (
   ConstStr63Param volName,
   short vRefNum,
   long dirID
);
Parameters
volName

The name of a mounted volume or the partial pathname of a directory. This parameter can be NULL. 
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

A directory ID. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The HSetVol function lets you specify the default directory by volume reference number or by directory ID.

Both the default volume and the default directory are used in calls made with no volume name, a volume reference number of 0, and a directory ID of 0. 
Special Considerations

Use of the HSetVol function is discouraged if your application may execute in system software versions prior to version 7.0. Because the specified directory might not itself be a working directory, HSetVol records the default volume and directory separately, using the volume reference number of the volume and the actual directory ID of the specified directory. Subsequent calls to GetVol (or PBGetVolSync or PBGetVolAsync) return only the volume reference number, which will cause that volume’s root directory (rather than the default directory, as expected) to be accessed. 
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr HSetVol (
   ConstStr63Param volName,
   short vRefNum,
   long dirID
){};


/*PBSetFPosSync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionSync instead.)

OSErr PBSetFPosSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the file mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosSync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosSync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosSync (
   ParmBlkPtr paramBlock
){};

/*PBHOpenRFDenySync

Opens a file’s resource fork using the access deny modes.

OSErr PBHOpenRFDenySync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. The function returns the result code opWrErr if you’ve requested write permission and you have already opened the file for writing in that case, the existing file reference number is returned in ioRefNum. You should not use this reference number unless your application originally opened the file.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion function. 
ioResult 

On output, the result code of the function. 
ioNamePtr 

On input, a pointer to a pathname for the file. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file. Pass 0 to indicate the default volume. 
ioRefNum 

On output, the file reference number for the file. 
ioDenyModes 

On input, the type of access you are requesting to the fork. See File Access Permission Constants for a description of the types of access that you can request. 
ioDirID 

On input, the parent directory ID of the file. 

You should use the PBHOpenRFDenySync and PBHOpenDenySync functions (or their asynchronous counterparts, PBHOpenRFDenyAsync and PBHOpenDenyAsync ) if you want to ensure that you get the access permissions and deny-mode permissions that you request. PBHOpenRFDenySync is not retried in any way. If the file cannot be opened because of a deny conflict, the error afpDenyConflict is returned and the ioRefNum field is set to 0. 

You can check that the volume supports AFP deny-mode permissions by checking that the bHasOpenDeny bit is set in the vMAttrib field returned by the PBHGetVolParmsSync or PBHGetVolParmsAsync function. If you don’t want to special case volumes that support AFP deny mode permissions, you can use the File Manager permissions. See File Access Permission Constants for a description of how File Manager permissions are translated to AFP deny-mode permissions.

To open a file’s data fork with access deny permissions, use the PBHOpenDenySync or PBHOpenDenyAsync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHOpenRFDenySync (
   HParmBlkPtr paramBlock
){};

/*PBHDeleteSync

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use PBDeleteObjectSync instead.)

OSErr PBHDeleteSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block.See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, PBHDeleteSync returns the result code fBsyErr. PBHDeleteSync also returns fBsyErr if you attempt to delete a directory that has an open working directory associated with it.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory to delete. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the parent directory of the file or directory to delete. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the specified target is a file, both the data and the resource fork of the file are deleted. In addition, if a file ID reference for the specified file exists, that file ID reference is also removed. A file must be closed before you can delete it. Similarly, you cannot delete a directory unless it’s empty. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHDeleteSync (
   HParmBlkPtr paramBlock
){};


/*PBSetEOFSync

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use PBSetForkSizeSync instead.)

OSErr PBSetEOFSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, a file reference number for the open file. 
ioMisc 

On input, the new logical size (the logical end-of-file) of the given file. Because the ioMisc field is of type Ptr, you must coerce the desired value from a long integer to type Ptr. If the value of the ioMisc field is 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 

If you attempt to set the logical end-of-file beyond the current physical end-of-file, another allocation block is added to the file if there isn’t enough space on the volume, no change is made and PBSetEOFSync returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBSetEOFSync (
   ParmBlkPtr paramBlock
){};

/*HRstFLock

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr HRstFLock (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The parent directory ID of the file or directory to unlock. 
fileName

The name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use HRstFLock to unlock a directory. Otherwise, you can only use this function to unlock a file.

You can lock a file or directory with the FSpSetFLock , HSetFLock , PBHSetFLockSync , and PBHSetFLockAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr HRstFLock (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
){};

/*PBHRstFLockSync

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBHRstFLockSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to the name for the file or directory to unlock. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the parent directory ID of the file or directory to unlock. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use PBHRstFLockSync to unlock a directory. Otherwise, you can only use this function to unlock a file.

Access paths currently in use aren’t affected by this function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHRstFLockSync (
   HParmBlkPtr paramBlock
){};



/*PBHOpenRFSync

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenRFSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. On some file systems, PBHOpenRFSync will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, a file reference number for accessing the open resource fork. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the PBOpenRFSync function, you will receive an error message. 
Special Considerations

Generally your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The PBHOpenRFSync function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork.

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenRFSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHOpenRFSync (
   HParmBlkPtr paramBlock
){};

/*PBHOpenDFSync

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenDFSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. . If you attempt to open a locked file for writing, PBHOpenDFSync returns the result code permErr. If you request exclusive read/write permission but another access path is already open, PBHOpenDFSync returns the reference number of the existing access path in ioRefNum and opWrErr as its function result.
Discussion

You should use PBHOpenDFSync instead of the PBHOpenSync function; PBHOpenDFSync allows you to safely open a file whose name begins with a period (.).

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, the file reference number for accessing the open data fork. If you request exclusive read/write permission but another access path is already open, PBHOpenDFSync returns the reference number of the existing access path. You should not use this reference number unless your application originally opened the file. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants.You can open a path for writing even if it accesses a file on a locked volume, and no error is returned until a PBWriteSync, PBSetEOFSync , or PBAllocateSync call is made. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the PBHOpenDFSync function, you will receive an error message. 
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenDFSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHOpenDFSync (
   HParmBlkPtr paramBlock
){};


/*HDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr HDelete (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The directory ID of the parent directory of the file or directory to delete. 
fileName

The name of the file or directory to delete. This can be a full or partial pathname. 
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, HDelete returns the result code fBsyErr. HDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both the data and the resource fork of the file are deleted. In addition, if a file ID reference for the specified file exists, that reference is removed. A file must be closed before you can delete it. Similarly, you cannot delete a directory unless it’s empty. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HDelete (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
){};


/*PBHOpenSync

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to open a locked file for writing, PBHOpenSync returns the result code permErr. If you request exclusive read/write permission but another access path is already open, PBHOpenSync returns the reference number of the existing access path in ioRefNum and opWrErr as its function result.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, a file reference number for accessing the open data fork. If you request exclusive read/write permission but another access path is already open, PBHOpenSync returns the reference number of the existing access path. You should not use this reference number unless your application originally opened the file. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants.You can open a path for writing even if it accesses a file on a locked volume, and no error is returned until a PBWriteSync, PBSetEOFSync , or PBAllocateSync call is made. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If you use PBHOpenSync to try to open a file whose name begins with a period, you might mistakenly open a driver instead; subsequent attempts to write data might corrupt data on the target device. To avoid these problems, you should always use PBHOpenDFSync instead of PBHOpenSync. 
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHOpenSync (
   HParmBlkPtr paramBlock
){};

/*PBDTOpenInform

Gets the reference number of the specified desktop database, reporting whether the desktop database was empty when it was opened. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTOpenInform (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the volume associated with the desktop database or the full pathname of the desktop database. 
ioVRefName 

On input, the volume reference number of the volume associated with the desktop database. 
ioDTRefNum 

On output, the desktop database reference number, which represents the access path to the database. You cannot use the desktop reference number as a file reference number in any File Manager functions other than the desktop database functions. If PBDTOpenInform fails, it sets this field to 0. 
ioTagInfo 

On output, the return flag (in the low bit of this field). If the desktop database was just created in response to PBDTOpenInform (and is therefore empty), PBDTOpenInform sets the low bit in this field to 0. If the desktop database had been created before you called PBDTOpenInform, PBDTOpenInform sets the low bit in this field to 1. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.

This function executes synchronously only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTOpenInform (
   DTPBPtr paramBlock
){};

/*PBGetForeignPrivsSync

Determines the native access-control information for a file or directory stored on a volume managed by a foreign file system. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBGetForeignPrivsSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetForeignPrivsSync (
   HParmBlkPtr paramBlock
){};





/*PBDTGetAPPLSync

Identifies the application that can open a file with a given creator. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetAPPLSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On output, a pointer to the application’s name. 
ioDTRefNum 

On input, the desktop database reference number of the desktop database containing the specified application. 
ioIndex 

On input, an index into the application list. 
ioTagInfo 

On output, the application’s creation date. 
ioFileCreator 

On input, the signature of the application. 
ioAPPLParID 

On output, the application’s parent directory. 

A single call, with the ioIndex field set to 0, finds the application file with the most recent creation date. If you want to retrieve information about all copies of the application with the given signature, start with ioIndex set to 1 and increment this value by 1 with each call to PBDTGetAPPLSync until the result code afpItemNotFound is returned in the ioResult field; when called multiple times in this fashion, PBDTGetAPPLSync returns information about all the application’s copies, including the file with the most recent creation date, in arbitrary order. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBDTGetAPPLSync (
   DTPBPtr paramBlock
){};


/*HOpenResFile

Opens a file’s resource fork, when the FSpOpenResFile function is not available. 

short HOpenResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   SInt8 permission
);
Parameters
vRefNum

The volume reference number of the volume on which the file is located.
dirID

The directory ID of the directory where the file is located.
fileName

The name of the file whose resource fork is to be opened.
permission

A constant indicating the type of access with which to open the resource fork. For a description of the types of access you can request, see the section File Access Permission Constants in File Manager Reference.
Return Value

The file reference number for the file. You can use this file reference number to refer to the file in other Resource Manager functions. The function also makes this file the current resource file. If the file’s resource fork is already open, the function returns the file reference number but does not make that file the current resource file. If the function fails to open the specified file’s resource fork (because there’s no file with the specified name or because there are permission problems), it returns –1 as the file reference number. Use the ResError function to determine what kind of error occurred.

Versions of system software before System 7 do not allow you to use this function to open a second access path, with write access, to a resource fork. In this case, the function returns the reference number already assigned to the file.
Discussion

The Resource Manager reads the resource map from the resource fork of the specified file into memory. It also reads into memory every resource whose resPreload attribute is set.

You don’t have to call this function to open the System file’s resource fork or an application file’s resource fork. These files are opened automatically when the system and the application start up, respectively. To get the file reference number for your application, call the CurResFile function after the application starts up and before you open the resource forks for any other files.

The HOpenResFile function checks that the information in the resource map is internally consistent. If it isn’t, ResError returns the result code mapReadErr. It’s possible to create multiple, unique, read-only access paths to a resource fork using HOpenResFile; however, you should avoid doing so, to prevent inconsistencies between multiple copies of the resource map. See the discussion of this issue in relation to FSpOpenResFile. The HOpenResFile function works the same way. 

To open a resource fork just for block-level operations, such as copying files without reading the resource map into memory, use the File Manager function OpenRF.

If you want to open the resource fork for another application (or any resource fork other than your application’s that includes 'CODE' resources), you must bracket your calls to HOpenResFile with calls to the SetResLoad function with the load parameter set to FALSE and then to TRUE. You must also avoid making intersegment calls while the other application’s resource fork is open. The discussion of this issue in relation to FSpOpenResFile also applies to HOpenResFile. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

short HOpenResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   SInt8 permission
){};

/*FSpDirCreate

Creates a new directory. (Deprecated in Mac OS X v10.4. Use FSCreateDirectoryUnicode instead.)

OSErr FSpDirCreate (
   const FSSpec * spec,
   ScriptCode scriptTag,
   long * createdDirID
);
Parameters
spec

A pointer to an FSSpec structure specifying the directory to be created. 

Note that if the parent directory ID for the directory described by this FSSpec is 0 and the volume specified in this FSSpec is the default volume, the new directory is placed in the default directory of the volume. If the parent directory ID is 0 and the specified volume is a volume other than the default volume, the new directory is placed in the root directory of the volume. To create a directory at the root of a volume, regardless of whether that volume is the current default volume, set the parent directory ID to the constant fsRtDirID(2).

scriptTag

The code of the script system in which the directory name is to be displayed. If you have established the name and location of the new directory using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information on the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. For a description of the smSystemScript constant, see the Script Manager Reference.

createdDirID

On return, a pointer to the directory ID of the directory that was created. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpDirCreate function sets the date and time of creation and last modification to the current date and time.

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDirCreate is not available, you can use the function DirCreate instead. To create a directory with a Unicode name, use the function FSCreateDirectoryUnicode , or one of the corresponding parameter block calls, PBCreateDirectoryUnicodeSync and PBCreateDirectoryUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpDirCreate (
   const FSSpec * spec,
   ScriptCode scriptTag,
   long * createdDirID
){};



/*PBHSetDirAccessSync

Changes the access control information for a directory.

OSErr PBHSetDirAccessSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to an AccessParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification for the volume containing the directory. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioACOwnerID 

On input, the owner ID. 
ioACGroupID 

On input, the group ID. 
ioACAccess 

On input, the directory’s access rights. You cannot set the owner or user rights bits of the ioACAccess field directly; if you try to do this, PBHSetDirAccessSync returns the result code paramErr. Only the blank access privileges can be set for a directory using this function. See File and Folder Access Privilege Constants for more information on directory access privileges. 
ioDirID 

On input, the directory ID. 

To change the owner or group, you should set the ioACOwnerID or ioACGroupID field to the appropriate ID. You must be the owner of the directory to change the owner or group ID. A guest on a server can manipulate the privileges of any directory owned by the guest. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHSetDirAccessSync (
   HParmBlkPtr paramBlock
){};

/*FSpSetFLock

Locks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFLock (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to lock. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync functions indicate that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use FSpSetFLock to lock a directory. Otherwise, you can only use this function to lock a file.

After you lock a file, all new access paths to that file are read-only. This function has no effect on existing access paths. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFLock (
   const FSSpec * spec
){};


/*PBHCreateSync

Creates a new file. (Deprecated in Mac OS X v10.4. Use PBCreateFileUnicodeSync instead.)

OSErr PBHCreateSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name for the new file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the parent directory of the new file. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

The PBHCreateSync function creates both the data and resource fork of the file the new file is unlocked and empty. The date and time of its creation and last modification are set to the current date and time. If the file created isn’t temporary (that is, if it will exist after the user quits the application), the application should call PBHSetFInfoSync after the call to PBHCreateSync to fill in the information needed by the Finder.

Files created using PBHCreateSync are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager procedures HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it (by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHCreateSync (
   HParmBlkPtr paramBlock
){};
/*PBDTGetCommentSync

Retrieves the user comments for a file or directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetCommentSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you want to retrieve comments. 
ioDTRefNum 

On input, the desktop database reference number of the database in which the specified file or directory is found. 
ioDTBuffer 

On input, a pointer to a buffer allocated to hold the comment text. On output, a pointer to the comment text. Allocate a buffer at least 255 bytes in size. The PBDTGetCommentSync function places up to ioDTReqCount bytes of the comment into the buffer as a plain text string and places the actual length of the comment in the ioDTActCount field. 
ioDTReqCount 

On input, the size of the buffer allocated to hold the comment. 
ioDTActCount 

On output, the comment size. 
ioDirID 

On input, the parent directory of the file or directory. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetCommentSync (
   DTPBPtr paramBlock
){};

/*PBDTGetPath

Gets the reference number of the specified desktop database. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetPath (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the volume associated with the desktop database or the full pathname of the desktop database. 
ioVRefName 

On input, the volume reference number of the volume associated with the desktop database. 
ioDTRefNum 

On output, the desktop database reference number, which represents the access path to the database. You cannot use the desktop reference number as a file reference number in any File Manager functions other than the desktop database functions. If PBDTGetPath fails, it sets this field to 0. 

If the desktop database is not already open, PBDTGetPath opens it and then returns the reference number. If the desktop database doesn’t exist, PBDTGetPath creates it . 
Special Considerations

PBDTGetPath allocates memory in the system heap; do not call it at interrupt time.

This function executes synchronously only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetPath (
   DTPBPtr paramBlock
){};


/*FSpRstFLock

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpRstFLock (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to unlock. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use FSpRstFLock to unlock a directory. Otherwise, you can only use this function to unlock a file. 

You can lock a file or directory with the FSpSetFLock , HSetFLock , PBHSetFLockSync , and PBHSetFLockAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRstFLock (
   const FSSpec * spec
){};




/*PBExchangeFilesSync

Exchanges the data stored in two files on the same volume. (Deprecated in Mac OS X v10.4. Use PBExchangeObjectsSync instead.)

OSErr PBExchangeFilesSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the first file to swap. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDestNamePtr 

On input, a pointer to the name of the second file to swap. 
ioDestDirID 

On input, the second file’s parent directory ID. 
ioSrcDirID 

On input, the first file’s parent directory ID. 

Typically, you use PBExchangeFilesSync after creating a new file during a safe save. The PBExchangeFilesSync function changes the fields in the catalog entries that record the location of the data and the modification dates. It swaps both the data forks and the resource forks.

The PBExchangeFilesSync function works on either open or closed files. PBExchangeFilesSync swaps the data in two files by changing some of the information in the volume catalog. If either file is open, PBExchangeFilesSync updates any file control blocks associated with the file. Exchanging the contents of two files requires essentially the same access privileges as opening both files for writing.

The following fields in the catalog entries for the files are exchanged:
ioFlStBlk 
ioFlLgLen 
ioFlPyLen 
ioFlRStBlk 
ioFlRLgLen 
ioFlRPyLen 
ioFlMdDat 

In the file control blocks, the fcbFlNum, fcbDirID, and fcbCName fields are exchanged.

You should use PBExchangeFilesSync to preserve the file ID when updating an existing file, in case the file is being tracked through its file ID. The PBExchangeFilesSync function does not require that file ID references exist for the files being exchanged.

To exchange the contents of files with named forks other than the data and resource forks, or of files larger than 2 GB, use the FSExchangeObjects , PBExchangeObjectsSync , or PBExchangeObjectsAsync function. 
Special Considerations

Your application will have to swap any open reference numbers to the two files because the file's name and parent directory ID are exchanged in the file control blocks. 

Because other programs may have access paths open to one or both of the files exchanged, your application should have exclusive read/write access permission (fsRdWrPerm) to both files before calling PBExchangeFilesSync. Exclusive read/write access to both files will ensure that PBExchangeFilesSync doesn't affect another application because it prevents other applications from obtaining write access to one or both of the files exchanged.

PBExchangeFilesSync does not respect the file-locked attribute; it will perform the exchange even if one or both of the files are locked. Obtaining exclusive read/write access to both files before calling PBExchangeFilesSync ensures that the files are unlocked because locked files cannot be opened with write access.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBExchangeFilesSync (
   HParmBlkPtr paramBlock
){};


/*PBUnshareSync

Makes a share point unavailable on the network. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBUnshareSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnshareSync (
   HParmBlkPtr paramBlock
){};

/*PBLockRangeSync

Locks a portion of a file. (Deprecated in Mac OS X v10.4. Use PBXLockRangeSync or FSLockRange instead.)

OSErr PBLockRangeSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you call PBLockRangeSync on a file system that does not implement it—for example, SMB—PBLockRangeSync returns noErr and does nothing.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number of the file owning the range to lock. 
ioReqCount 

On input, the number of bytes in the range. Set ioReqCount to –1 to lock the maximum number of bytes from the position specified in the ioPosOffset field. 
ioPosMode 

On input, a constant specifying the base location for the start of the locked range. See Position Mode Constants for more information about the constants you can use to specify the base location. 

You should not use the fsFromLEOF constant when locking a file range. PBLockRangeSync does not return the start of the locked range; thus, there is no way to determine what range was actually locked when you specify fsFromLEOF.
ioPosOffset 

On input, the offset from the base location specified in the ioPosMode field for the start of the locked range. 

The PBLockRangeSync function locks a portion of a file that was opened with shared read/write permission. The beginning of the range to be locked is determined by the ioPosMode and ioPosOffset fields. The end of the range to be locked is determined by the beginning of the range and the ioReqCount field. For example, to lock the first 50 bytes in a file, set ioReqCount to 50, ioPosMode to fsFromStart, and ioPosOffset to 0.

The PBLockRangeSync function uses the same parameters as both PBReadSync and PBWriteSync; by calling it immediately before PBReadSync, you can use the information in the parameter block for the PBReadSync call. For more information about the PBReadSync and PBWriteSync functions, see the Device Manager Reference .

When you’re finished with the data (typically after a call to PBWriteSync), you can call PBUnlockRangeSync to free that portion of the file for subsequent read and write calls. Closing a file also releases all locked ranges in that file.
Special Considerations

The PBLockRangeSync function does nothing if the file specified in the ioRefNum field is open with shared read/write permission but is not located on a remote server volume or is not located under a share point on a sharable local volume. To check whether file sharing is currently on, check that the bHasPersonalAccessPrivileges bit in the vMAttrib field of the GetVolParmsInfoBuffer returned by the PBHGetVolParmsSync function is set. 
Version Notes

In system software versions 6.0.7 and earlier, specifying ioPosMode as fsFromLEOF results in the wrong byte range being locked. System software version 7.0 fixes this bug.
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible to have multiple writers for the same file. Locking a portion of a file with PBLockRangeSync does not guarantee exclusive access to that part of the file. If you call PBLockRangeSync to lock a portion of a file to which another process already has write access, the call will succeed without error. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBLockRangeSync (
   ParmBlkPtr paramBlock
){};

/*PBDTSetCommentSync

Adds a user comment for a file or a directory to the desktop database. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTSetCommentSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the file or directory. 
ioDTRefNum 

On input, the desktop database reference number for the desktop database to which to add the user comment. 
ioDTBuffer 

On input, a pointer to the buffer containing the comment text. Put the comment in the buffer as a plain text string. 
ioDTReqCount 

On input, the length of the buffer containing the comment text, in bytes. The maximum length of a comment is 200 bytes; longer comments are truncated. Since the comment is a plain text string and not a Pascal string, the File Manager relies on the value in the ioDTReqCount field for determining the length of the buffer. 
ioDirID 

On input, the parent directory ID of the file or directory. 

If the specified object already has a comment in the database, the new comment replaces the old. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTSetCommentSync (
   DTPBPtr paramBlock
){};


/*PBDTGetIconSync

Retrieves an icon definition. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetIconSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBDTGetIconSync function returns the bitmap for an icon that represents a file of a given type and creator. For example, to get the icon for a file of file type 'SFWR' created by the application with a signature of 'WAVE', specify these two values in the ioFileType and ioFileCreator fields. 

The relevant fields of the parameter block for this function are:
ioDTRefNum 

On input, the desktop database reference number. 
ioTagInfo 

Reserved; on input, this field must be set to 0. 
ioDTBuffer 

On input, a pointer to a buffer to hold the icon’s data. On return, a pointer to the bitmap returned in the buffer. 
ioDTReqCount 

On input, the requested size of the icon’s bitmap. Pass the size in bytes of the buffer that you’ve allocated for the icon’s bitmap, pointed to by the ioDTBuffer field; this value depends on the icon type. Be sure to allocate enough storage for the icon data; 1024 bytes is the largest amount required for any icon in System 7. You can use the constants described in Icon Size Constants to indicate the amount of memory you have provided for the icon’s data. 
ioDTActCount 

On output, the actual size of the icon’s bitmap. If this value is larger than the value specified in the ioDTReqCount field, only the amount of data allowed by ioDTReqCount is valid. 
ioIconType 

On input, the icon type. For a description of the constants which you can use in this field, see Icon Type Constants. 
ioFileCreator 

On input, the icon’s file creator. 
ioFileType 

On input, the icon’s file type. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetIconSync (
   DTPBPtr paramBlock
){};


/*PBResolveFileIDRefSync

Retrieves the filename and parent directory ID of a file given its file ID.

OSErr PBResolveFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to an FIDParam variant of the HFS parameter block. See HParamBlockRec for more information on the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. A return code of fidNotFound means that the specified file ID reference has become invalid, either because the file was deleted or because the file ID reference was destroyed by PBDeleteFileIDRefSync or PBDeleteFileIDRefAsync.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. If the name string is NULL, PBResolveFileIDRefSync doe s not return the filename, but returns only the parent directory ID of the file in the ioSrcDirID field. If the name string is not NULL but is only a volume name, PBResolveFileIDRefSync ignores the value in the ioVRefNum field and uses the volume name instead. On output, a pointer to the filename of the file with the given file ID. 
ioVRefNum 

On input, a volume specification for the volume containing the file. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioSrcDirID 

On output, the file’s parent directory ID. 
ioFileID 

On input, a file ID for the file to retrieve information about. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBResolveFileIDRefSync (
   HParmBlkPtr paramBlock
){};


/*PBShareSync

Establishes a local volume or directory as a share point. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBShareSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBShareSync (
   HParmBlkPtr paramBlock
){};


/*PBDeleteFileIDRefSync

Deletes a file ID reference.

OSErr PBDeleteFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification for the volume containing the file. 
ioFileID 

On input, the file ID reference to delete. After it has invalidated a file ID reference, the File Manager can no longer resolve that ID reference to a filename and parent directory ID. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBDeleteFileIDRefSync (
   HParmBlkPtr paramBlock
){};

/*FSpCatMove

Moves a file or directory from one location to another on the same volume. (Deprecated in Mac OS X v10.4. Use FSMoveObject instead.)

OSErr FSpCatMove (
   const FSSpec * source,
   const FSSpec * dest
);
Parameters
source

A pointer to an FSSpec structure specifying the name and location of the file or directory to move. See FSSpec for a description of the FSSpec data type.
dest

A pointer to an FSSpec structure specifying the name and location of the directory into which the source file or directory is to be moved. The directory ID specified in the parID field of this FSSpec is the directory ID of the parent of the directory into which you want to move the source file or directory. The name field of this FSSpec specifies the name of the directory into which you want to move the source file or directory.

If you don’t already know the parent directory ID of the destination directory, it might be easier to use the PBCatMoveSync or PBCatMoveAsync function, which allow you to specify only the directory ID of the destination directory.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCatMove function is strictly a file catalog operation; it does not actually change the location of the file or directory on the disk. You cannot use FSpCatMove to move a file or directory to another volume (that is, the vRefNum field in both FSSpec structures in the source and dest parameters must be the same). Also, you cannot use FSpCatMove to rename files or directories; to rename a file or directory, use FSpRename.

If you need to move files or directories with named forks other than the data and resource forks, with long Unicode names, or files larger than 2GB, you should use the FSMoveObject function, or one of the corresponding parameter block calls, PBMoveObjectSync and PBMoveObjectAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpCatMove (
   const FSSpec * source,
   const FSSpec * dest
){};


/*PBHGetLogInInfoSync

Determines the login method used to log on to a particular shared volume. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBHGetLogInInfoSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHGetLogInInfoSync (
   HParmBlkPtr paramBlock
){};


/*PBFlushFileSync

Writes the contents of a file’s access path buffer to the disk. (Deprecated in Mac OS X v10.4. Use PBFlushForkSync instead.)

OSErr PBFlushFileSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant field of the parameter block is:
ioRefNum 

On input, a file reference number for the file to flush. 

After writing the contents of the file to the volume, the PBFlushFileSync function updates the file’s entry in the volume catalog.

In the event of a system crash, all cached data not yet written to disk is lost. If you have made changes to space that alreday exists within a file (you are overwriting existing data before the file’s end-of-file), you must use PBFlushFileSync to ensure that everything written to the file will be written to disk. If you flush the fork’s cached blocks using PBFlushFileSync, the only possible data loss in a system crash will be the file’s modification date. 

You do not, however, need to use PBFlushFileSync to flush a file fork before it is closed; the file is automatically flushed when it is closed and all cache blocks associated with it are removed from the cache.

PBFlushFileSync flushes an open fork’s dirty cached blocks, but may not flush catalog information associated with the file. To flush catalog information, call FlushVol , or one of the related parameter block calls, PBFlushVolSync and PBFlushVolAsync. 

To update a file larger than 2GB, or a named fork other than the data and resource forks, you must use the FSFlushFork function, or one of the corresponding parameter block calls, PBFlushForkSync and PBFlushForkAsync. 
Special Considerations

Some information stored on the volume won’t be correct until PBFlushVolSync is called.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBFlushFileSync (
   ParmBlkPtr paramBlock
){};


/*PBCatSearchSync

Searches a volume’s catalog file using a set of search criteria that you specify. (Deprecated in Mac OS X v10.4. Use PBCatalogSearchSync instead.)

OSErr PBCatSearchSync (
   CSParamPtr paramBlock
);
Parameters
paramBlock

A pointer to a CSParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. When PBCatSearchSync has searched the entire volume, it returns eofErr. If it exits because it either spends the maximum time allowed in the ioSearchTime field or finds the maximum number of matches allowed in the ioReqMatchCount field, it returns noErr.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the volume to search. 
ioVRefNum 

On input, a volume reference number or drive number for the volume to search; or 0 for the default volume. 
ioMatchPtr 

On input, a pointer to an array of FSSpec structure to hold the matches found by this function. On return, the FSSpec structures in this array identify the files and directories that match the criteria. 
ioReqMatchCount 

On input, the maximum number of matches to return. 
ioActMatchCount 

On output, the actual number of matches returned. 
ioSearchBits 

On input, a bitmap specifying the fields in the criteria structures to match against. See Catalog Search Masks for a description of the bits in this field. 
ioSearchInfo1 

On input, a pointer to a CInfoPBRec union containing search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in ioSearchInfo2, and set the matching value in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this structure. 
ioSearchInfo2 

On input, a pointer to a CInfoPBRec union containing search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching value in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this structure. 
ioSearchTime 

On input, the maximum allowed search time. If you pass 0 in this field, no time limit is set. 
ioCatPosition 

The current catalog position, specified as a CatPositionRec structure. You can use this field, along with the ioSearchTime field, to search a volume in segments. To search a volume in segments, set a time limit for the search in the ioSearchTime field and set the initialize field of the CatPositionRec structure to the location for the start of the search (0 if you wish to start searching at the beginning of the volume). On return, the catalog position will be updated. You can then pass this updated CatPositionRec structure to the next call to PBCatSearchSync to continue searching at the place where you left off. 
ioOptBuffer 

On input, a pointer to an optional read buffer. 
ioOptBufSize 

On input, the length of the optional read buffer. 

If the catalog file changes between two timed calls to PBCatSearchSync (that is, when you are using ioSearchTime and ioCatPosition to search a volume in segments and the catalog file changes between searches), PBCatSearchSync returns a result code of catChangedErr and no matches. Depending on what has changed on the volume, ioCatPosition might be invalid, most likely by a few entries in one direction or another. You can continue the search, but you risk either skipping some entries or reading some twice. 
Special Considerations

Not all volumes support the PBCatSearchSync function. Before you call PBCatSearchSync to search a particular volume, you should call the PBHGetVolParmsSync function to determine whether that volume supports PBCatSearchSync.If the bHasCatSearch bit is set in the vMAttrib field, then the volume supports PBCatSearchSync.

Even though AFP volumes support PBCatSearchSync, they do not support all of its features that are available on local volumes. These restrictions apply to AFP volumes:
AFP volumes do not use the ioSearchTime field. Current versions of the AppleShare server software search for 1 second or until 4 matches are found. The AppleShare workstation software keeps requesting the appropriate number of matches until the server returns either the number specified in the ioReqMatchCount field or an error.
AFP volumes do not support both logical and physical fork lengths. If you request a search using the length of a fork, the actual minimum length used is the smallest of the values in the logical and physical fields of the ioSearchInfo1 structure and the actual maximum length used is the largest of the values in the logical and physical fields of the ioSearchInfo2 structure.
The fsSBNegate bit of the ioSearchBits field is ignored during searches of remote volumes that support AFP version 2.1.
If the AFP server returns afpCatalogChanged, the catalog position structure returned to your application (in the ioCatPosition field) is the same one you passed to PBCatSearchSync. You should clear the initialize field of that structure to restart the search from the beginning.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBCatSearchSync (
   CSParamPtr paramBlock
){};


/*PBHMoveRenameSync

Moves a file or directory and optionally renames it. (Deprecated in Mac OS X v10.4. Use FSMoveObjectSync instead.)

OSErr PBHMoveRenameSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a CopyParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBHMoveRenameSync function allows you to move (not copy) a file or directory. The source and destination pathnames must point to the same file server volume. This function is especially useful when you want to copy or move files located on a remote volume, because it allows you to forgo transmitting large amounts of data across a network. This function is used internally by the Finder; most applications do not need to use it.

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the pathname for the source file or directory. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the source file or directory. Pass 0 for the default volume. 
ioNewName 

On input, a pointer to the destination pathname. If ioNewName is NULL, the destination directory is the directory having the ID specified in the ioNewDirID field. If ioNewName is not NULL, the destination directory is the directory having the partial pathname pointed to by ioNewName in the directory having ID ioNewDirID on the specified volume. 
ioCopyName 

On input, a pointer to the file’s new name. The string pointed to by this field must be a filename, not a partial pathname. If you do not wish to rename the file, pass NULL in this field. 
ioNewDirID 

On input, if the ioNewName field is NULL, the directory ID of the destination directory. If ioNewName is not NULL, the parent directory ID of the destination directory. 
ioDirID 

On input, the directory ID of the source directory. 
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHMoveRenameSync (
   HParmBlkPtr paramBlock
){};


/*DisposeTimerUPP

Disposes of the universal procedure pointer (UPP) to your Time Manager task callback function. (Deprecated. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

void DisposeTimerUPP (
   TimerUPP userUPP
);
Parameters
userUPP

A UPP to your callback function. 
Discussion

See the callback TimerProcPtr for more information.
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Timer.h*/

void DisposeTimerUPP (
   TimerUPP userUPP
){};


/*PBUnlockRangeSync

Unlocks a portion of a file. (Deprecated in Mac OS X v10.4. Use PBXUnlockRangeSync or FSUnlockRange instead.)

OSErr PBUnlockRangeSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you call PBUnlockRangeSync on a file system that does not implement it—for example, SMB—PBUnlockRangeSync returns noErr and does nothing.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number of the file owning the range to unlock. 
ioReqCount 

On input, the number of bytes in the range. 
ioPosMode 

On input, a constant specifying the base location for the start of the locked range. See Position Mode Constants for more information on the constants you can use to indicate the base location. 
ioPosOffset 

On input, the offset from the base location specified in the ioPosMode field for the start of the locked range. 

The PBUnlockRangeSync function unlocks a portion of a file that you locked with PBLockRangeSync or PBLockRangeAsync. The beginning of the range to be unlocked is determined by the ioPosMode and ioPosOffset fields. The end of the range to be unlocked is determined by the beginning of the range and the ioReqCount field. For example, to unlock the first 50 bytes in a file, set ioReqCount to 50, ioPosMode to fsFromStart, and ioPosOffset to 0. The range of bytes to be unlocked must be the exact same range locked by a previous call to PBLockRangeSync or PBLockRangeAsync.

If for some reason you need to unlock a range whose beginning or length is unknown, you can simply close the file. When a file is closed, all locked ranges held by the user are unlocked. 
Special Considerations

The PBUnlockRangeSync function does nothing if the file specified in the ioRefNum field is open with shared read/write permission but is not located on a remote server volume or is not located under a share point on a local volume. To check whether file sharing is currently on, check that the bHasPersonalAccessPrivileges bit in the vMAttrib field of the GetVolParmsInfoBuffer returned by the PBHGetVolParmsSync function is set.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnlockRangeSync (
   ParmBlkPtr paramBlock
){};

/*PBVolumeMount

Mounts a volume.

OSErr PBVolumeMount (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioVRefNum 

On output, a volume reference number for the mounted volume. 
ioBuffer 

On input, a pointer to mounting information. You can use the volume mounting information returned by the PBGetVolMountInfo function or you can use a volume mounting information structure filled in by your application. If you’re mounting an AppleShare volume, place the volume’s AFP mounting information structure in the buffer pointed to by the ioBuffer field. 

This function allows your application to record the mounting information for a volume and then to mount the volume later. 

The PBGetVolMountInfo function does not return the user and volume passwords they’re returned blank. Typically, your application asks the user for any necessary passwords and fills in those fields just before calling PBVolumeMount. If you want to mount a volume with guest status, pass an empty string as the user password.

If you have enough information about the volume, you can fill in the mounting structure yourself and call PBVolumeMount, even if you did not save the mounting information while the volume was mounted. To mount an AFP volume, you must fill in the structure with at least the zone name, server name, user name, user password, and volume password. You can lay out the fields in any order within the data field, as long as you specify the correct offsets.

In general, it is easier to mount remote volumes by creating and then resolving alias records that describe those volumes. The Alias Manager displays the standard user interface for user authentication when resolving alias records for remote volumes. As a result, this function is primarily of interest for applications that need to mount remote volumes with no user interface or with some custom user interface. 
Special Considerations

AFP volumes currently ignore the user authentication method passed in the uamType field of the volume mounting information structure whose address is passed in the ioBuffer field of the parameter block. The most secure available method is used by default, except when a user mounts the volume as Guest and uses the kNoUserAuthentication authentication method.

This function executes synchronously. You should not call it at interrupt time.
Version Notes

The File Sharing workstation software introduced in system software version 7.0 does not currently pass the volume password. The AppleShare 3.0 workstation software does, however, pass the volume password.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBVolumeMount (
   ParmBlkPtr paramBlock
){};



/*PBSetForeignPrivsSync

Changes the native access-control information for a file or directory stored on a volume managed by a foreign file system. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBSetForeignPrivsSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBSetForeignPrivsSync (
   HParmBlkPtr paramBlock
){};


/*UpperString

Converts any lowercase letters in a Pascal string to their uppercase equivalents, using the Macintosh file system rules. (Deprecated in Mac OS X v10.4. Use CFStringUppercase instead.)

void UpperString (
   Str255 theString,
   Boolean diacSensitive
);
Parameters
theString

On input, this is the Pascal string to be converted. On output, this contains the string resulting from the conversion. UpperString traverses the characters in theString and converts any lowercase characters with character codes in the range 0x00 through 0xD8 into their uppercase equivalents. UpperString places the converted characters in theString. 
diacSensitive

A flag that indicates whether the case conversion is to strip diacritical marks. If the value of this parameter is TRUE, diacritical marks are considered in the conversion; if it is FALSE, any diacritical marks are stripped. 
Discussion

Only a subset of the Roman character set (character codes with values through $D8) are converted. Use this function to emulate the behavior of the Macintosh file system. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/

void UpperString (
   Str255 theString,
   Boolean diacSensitive
){};



/*NewTimerUPP

Creates a new universal procedure pointer (UPP) to your Time Manager task callback. (Deprecated. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

TimerUPP NewTimerUPP (
   TimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your Time Manager event callback function. For information on how to create a Time Manager event callback see TimerProcPtr
Return Value

A UPP to your callback function. See the description of the TimerUPP data type.
Discussion

See the callback TimerProcPtr for more information.
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Timer.h*/
TimerUPP NewTimerUPP (
   TimerProcPtr userRoutine
){};

/*PBHMapIDSync

Determines the name of a user or group given the user or group ID.

OSErr PBHMapIDSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the ObjParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification. 
ioObjType 

On input, the mapping function code its value is 1 if you’re mapping a user ID to a user name or 2 if you’re mapping a group ID to a group name. See Mapping Code Constants for more information about the values you can use in this field. 
ioObjNamePtr 

On output, a pointer to the user or group name; the maximum size of the name is 31 characters (preceded by a length byte). 
ioObjID 

On input, the user or group ID to be mapped. AppleShare uses the value 0 to signify Any User. 
Version Notes

Because user and group IDs are interchangeable under AFP 2.1 and later volumes, you might not need to specify a value in the ioObjType field.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHMapIDSync (
   HParmBlkPtr paramBlock
){};


/*IPBHMapNameSync

Determines the user ID or group ID from a user or group name.

OSErr PBHMapNameSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the ObjParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification. 
ioObjType 

On input, the mapping function code its value is 3 if you’re mapping a user name to a user ID or 4 if you’re mapping a group name to a group ID. See Mapping Code Constants for more information on the values you can use in this field. 
ioObjNamePtr 

On input, a pointer to the user or group name. The maximum size of the name is 31 characters. If NULL is passed, the ID returned is always 0. 
ioObjID 

On output, the mapped user or group ID. 
Version Notes

Because user and group IDs are interchangeable under AFP 2.1 and later volumes, you might need to set the ioObjType field to determine which database (user or group) to search first. If both a user and a group have the same name, this field determines which kind of ID you receive.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHMapNameSync (
   HParmBlkPtr paramBlock
){};



/*FSSetForkPosition

Sets the current position of an open fork. 

OSErr FSSetForkPosition (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);
Parameters
forkRefNum

The reference number of a fork previously opened by the FSOpenFork, PBOpenForkSync, or PBOpenForkAsync function. 
positionMode

A constant specifying the base location within the fork for the new position. If this parameter is equal to fsAtMark, then the positionOffset parameter is ignored. See Position Mode Constants for a description of the constants you can use to specify the base location. 
positionOffset

The offset of the new position from the base location specified in the positionMode parameter. 
Return Value

A result code. See “File Manager Result Codes”. On Mac OS X, FSSetForkPosition will return the result code posErr if you attempt to set the current position of the fork to an offset before the start of the file. On Mac OS 9, this same attempt will return the result code eofErr.
Special Considerations

To determine if the FSSetForkPosition function is present, call the Gestalt function with the gestaltFSAttr selector. If the FSSetForkPosition function is present, but the volume does not directly support it, the File Manager will automatically call the PBSetFPosSync function. However, if the volume does not directly support the FSSetForkPosition function, you can only set the file position for the data and resource forks, and you cannot grow these files beyond 2GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetForkPosition (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
){};

/*FSGetForkCBInfo

Returns information about a specified open fork, or about all open forks.

OSErr FSGetForkCBInfo (
   SInt16 desiredRefNum,
   FSVolumeRefNum volume,
   SInt16 * iterator,
   SInt16 * actualRefNum,
   FSForkInfo * forkInfo,
   FSRef * ref,
   HFSUniStr255 * outForkName
);
Parameters
desiredRefNum

If you want information on a specific fork, set this parameter to that fork’s reference number, and pass NULL in the iterator parameter. If you pass a non-zero value in this parameter, the function attempts to get information on the fork specified by that reference number. 

Pass zero in this parameter to iterate over all open forks. You can limit this iteration to a specific volume with the volume parameter.
volume

The volume to search, when iterating over multiple forks. To iterate over all open forks on a single volume, specify the volume reference number in this parameter. To iterate over all open forks on all volumes, set this parameter to the constant kFSInvalidVolumeRefNum.

This parameter is ignored if you specify a fork reference number in the desiredRefNum parameter. Set desiredRefNum to zero if you wish to iterate over multiple forks.

See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
iterator

A pointer to an iterator. If the desiredRefNum parameter is 0, the iterator maintains state between calls to FSGetForkCBInfo. Set the iterator parameter to 0 before you begin iterating, on the first call to FSGetForkCBInfo. On return, the iterator will be updated; pass this updated iterator in the iterator parameter of the next call to FSIterateForks to continue iterating.
actualRefNum

On return, a pointer to the reference number of the open fork. This parameter is optional if you do not wish to retrieve the fork’s reference number, pass NULL.
forkInfo

On return, a pointer to an FSForkInfo structure containing information about the open fork. This parameter is optional; if you do not wish this information returned, set forkInfo to NULL. See FSForkInfo for a description of the FSForkInfo data type.

On OS X, the value returned by FSGetForkCBInfo in the physicalEOF field of the FSForkInfo structure may differ from the physical file length reported by FSGetCatalogInfo, PBGetCatInfo, and related functions. When a write causes a file to grow in size, the physical length reported by FSGetCatalogInfo and similar calls increases by the clump size, which is a multiple of the allocation block size. However, the physical length returned by FSGetForkCBInfo changes according to the allocation block size and the file lengths returned by the respective functions get out of sync.
ref

On return, a pointer to the FSRef for the file or directory that contains the fork. This parameter is optional; if you do not wish to retrieve the FSRef, set ref to NULL. See FSRef for a description of the FSRef data type.
outForkName

On return, a pointer to the name of the fork. This parameter is optional; if you do not wish the name returned, set outForkName to NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”. If you are iterating over multiple forks, the function returns errFSNoMoreItems if there are no more open forks to return.
Discussion

Carbon applications are no longer guaranteed access to the FCB table. Instead, applications should use FSGetForkCBInfo, or one of the related parameter block functions, PBGetForkCBInfoSync and PBGetForkCBInfoAsync , to access information about a fork control block. 
Special Considerations

Returning the fork information in the forkInfo parameter generally does not require a disk access; returning the information in the ref or forkName parameters may cause disk access for some volume formats.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkCBInfo (
   SInt16 desiredRefNum,
   FSVolumeRefNum volume,
   SInt16 * iterator,
   SInt16 * actualRefNum,
   FSForkInfo * forkInfo,
   FSRef * ref,
   HFSUniStr255 * outForkName
){};


/*CreateTextToUnicodeInfo

Creates and returns a Unicode converter object containing information required for converting strings from a non-Unicode encoding to Unicode. 

OSStatus CreateTextToUnicodeInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   TextToUnicodeInfo * oTextToUnicodeInfo
);
Parameters
iUnicodeMapping

A pointer to a structure of type UnicodeMapping. Your application provides this structure to identify the mapping to use for the conversion. You must supply a value of type TextEncoding in the unicodeEncoding field of this structure. A TextEncoding is a triple composed of an encoding base, an encoding variant, and a format. You can obtain a UnicodeMapping value by calling the function CreateTextEncoding. 
oTextToUnicodeInfo

On return, the Unicode converter object holds mapping table information you supplied as the UnicodeMapping parameter and state information related to the conversion. This information is required for conversion of a text stream in a non-Unicode encoding to Unicode. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

You pass a Unicode converter object returned from the function CreateTextToUnicodeInfo to the function ConvertFromTextToUnicode or ConvertFromPStringToUnicode to identify the information to be used for the conversion. These two functions modify the contents of the object. 

You pass a Unicode converter object returned from CreateTextToUnicodeInfo to the function TruncateForTextToUnicode to identify the information to be used to truncate the string. This function does not modify the contents of the Unicode converter object.

If an error is returned, the Unicode converter object is invalid. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus CreateTextToUnicodeInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   TextToUnicodeInfo * oTextToUnicodeInfo
){};

/*ConvertFromTextToUnicode

Converts a string from any encoding to Unicode. 

OSStatus ConvertFromTextToUnicode (
   TextToUnicodeInfo iTextToUnicodeInfo,
   ByteCount iSourceLen,
   ConstLogicalAddress iSourceStr,
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oSourceRead,
   ByteCount * oUnicodeLen,
   UniChar oUnicodeStr[]
);
Parameters
iTextToUnicodeInfo

A Unicode converter object of type TextToUnicodeInfo containing mapping and state information used for the conversion. The contents of this Unicode converter object are modified by the function. Your application obtains a Unicode converter object using the function CreateTextToUnicodeInfo. 
iSourceLen

The length in bytes of the source string to be converted. 
iSourceStr

The address of the source string to be converted. 
iControlFlags

Conversion control flags. You can use “Conversion Masks” to set the iControlFlags parameter. 
iOffsetCount

The number of offsets in the iOffsetArray parameter. Your application supplies this value. The number of entries in iOffsetArray must be fewer than the number of bytes specified in iSourceLen. If you don’t want offsets returned to you, specify 0 (zero) for this parameter. 
iOffsetArray

An array of type ByteOffset. On input, you specify the array that contains an ordered list of significant byte offsets pertaining to the source string. These offsets may identify font or style changes, for example, in the source string. All array entries must be less than the length in bytes specified by the iSourceLen parameter. If you don’t want offsets returned to your application, specify NULL for this parameter and 0 (zero) for iOffsetCount. 
oOffsetCount

On return, a pointer to the number of offsets that were mapped in the output stream.
oOffsetArray

An array of type ByteOffset. On return, this array contains the corresponding new offsets for the Unicode string produced by the converter.
iOutputBufLen

The length in bytes of the output buffer pointed to by the oUnicodeStr parameter. Your application supplies this buffer to hold the returned converted string. The oUnicodeLen parameter may return a byte count that is less than this value if the converted byte string is smaller than the buffer size you allocated. The relationship between the size of the source string and the Unicode string is complex and depends on the source encoding and the contents of the string.
oSourceRead

On return, a pointer to the number of bytes of the source string that were converted. If the function returns a kTECUnmappableElementErr result code, this parameter returns the number of bytes that were converted before the error occurred.
oUnicodeLen

On return, a pointer to the length in bytes of the converted stream.
oUnicodeStr

A pointer to an array used to hold a Unicode string. On input, this value points to the beginning of the array for the converted string. On return, this buffer holds the converted Unicode string. (For guidelines on estimating the size of the buffer needed, see the discussion. 
Return Value

A result code. See “TEC Manager Result Codes”. The function returns a noErr result code if it has completely converted the input string to Unicode without using fallback characters.
Discussion

You specify the source string’s encoding in the Unicode mapping structure that you pass to the function CreateTextToUnicodeInfo to obtain a Unicode converter object for the conversion. You pass the Unicode converter object returned by CreateTextToUnicodeInfo to ConvertFromTextToUnicode as the iTextToUnicodeInfo parameter. 

In addition to converting a text string in any encoding to Unicode, the ConvertFromTextToUnicode function can map offsets for style or font information from the source text string to the returned converted string. The converter reads the application-supplied offsets, which apply to the source string, and returns the corresponding new offsets in the converted string. If you do not want the offsets at which font or style information occurs mapped to the resulting string, you should pass NULL for iOffsetArray and 0 (zero) for iOffsetCount. 

Your application must allocate a buffer to hold the resulting converted string and pass a pointer to the buffer in the oUnicodeStr parameter. To determine the size of the output buffer to allocate, you should consider the size of the source string, its encoding type, and its content in relation to the resulting Unicode string. 

For example, for 1-byte encodings, such as MacRoman, the Unicode string will be at least double the size (more if it uses noncomposed Unicode) for MacArabic and MacHebrew, the corresponding Unicode string could be up to six times as big. For most 2-byte encodings, for example Shift-JIS, the Unicode string will be less than double the size. For international robustness, your application should allocate a buffer three to four times larger than the source string. If the output Unicode text is actually UTF-8—which could occur beginning with the current release of the Text Encoding Conversion Manager, version 1.2.1—the UTF-8 buffer pointer must be cast to UniCharArrayPtr before it can be passed as the oUnicodeStr parameter. Also, the output buffer length will have a wider range of variation than for UTF-16; for ASCII input, the output will be the same size; for Han input, the output will be twice as big, and so on. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus ConvertFromTextToUnicode (
   TextToUnicodeInfo iTextToUnicodeInfo,
   ByteCount iSourceLen,
   ConstLogicalAddress iSourceStr,
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oSourceRead,
   ByteCount * oUnicodeLen,
   UniChar oUnicodeStr[]
){};


/*FSExchangeObjects

Swaps the contents of two files.

OSErr FSExchangeObjects (
   const FSRef * ref,
   const FSRef * destRef
);
Parameters
ref

A pointer to an FSRef for the first file. See FSRef for a description of the FSRef data type.
destRef

A pointer to an FSRef for the second file.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSExchangeObjects function allows programs to implement a “safe save” operation by creating and writing a complete new file and swapping the contents. An alias, FSSpec, or FSRef that refers to the old file will now access the new data. The corresponding information in in-memory data structures are also exchanged.

Either or both files may have open access paths. After the exchange, the access path will refer to the opposite file’s data (that is, to the same data it originally referred, which is now part of the other file). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSExchangeObjects (
   const FSRef * ref,
   const FSRef * destRef
){};


/*PBMakeFSRefUnicodeSync

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr PBMakeFSRefUnicodeSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ref 

On input, a pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type. 
nameLength 

On input, the length of the file or directory name. 
name 

On input, a pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to PBMakeFSRefUnicodeSync. 
textEncodingHint 

On input, the suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef 

On output, if the function returns a result of noErr, a pointer to the new FSRef 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBMakeFSRefUnicodeSync (
   FSRefParam * paramBlock
){};

/*FSMoveObject

Moves a file or directory into a different directory.

OSErr FSMoveObject (
   const FSRef * ref,
   const FSRef * destDirectory,
   FSRef * newRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to move. See FSRef for a description of the FSRef data type.
destDirectory

A pointer to an FSRef specifying the directory into which the file or directory indicated by the ref parameter will be moved.
newRef

On return, a pointer to the new FSRef for the file or directory in its new location. This parameter is optional; if you do not wish the FSRef returned, pass NULL.
Return Value

A result code. See “File Manager Result Codes”. If the destDirectory parameter specifies a non-existent object, dirNFErr is returned; if it refers to a file, errFSNotAFolder is returned. If the directory specified in the destDirectory parameter is on a different volume than the file or directory indicated in the ref parameter, diffVolErr is returned.
Discussion

Moving an object may change its FSRef. If you want to continue to refer to the object, you should pass a non- NULL pointer in the newRef parameter and use the FSRef returned there to refer to the object after the move. The original FSRef passed in the ref parameter may or may not be usable after the move. The newRef parameter may point to the same storage as the destDirectory or ref parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMoveObject (
   const FSRef * ref,
   const FSRef * destDirectory,
   FSRef * newRef
){};

/*FNNotify

Broadcasts notification of changes to the specified directory.

OSStatus FNNotify (
   const FSRef * ref,
   FNMessage message,
   OptionBits flags
);
Parameters
ref

A file system reference describing the directory for which to broadcast the notification. 
message

An indication of what happened to the target directory.
flags

Options regarding the delivery of the notification. Specify kNilOptions for the default behaviour.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FNNotify (
   const FSRef * ref,
   FNMessage message,
   OptionBits flags
){};




/*GetUTCDateTime

Gets the UTC date and time. (Deprecated in Mac OS X v10.4.)

OSStatus GetUTCDateTime (
   UTCDateTime * utcDateTime,
   OptionBits options
);
Parameters
utcDateTime

A pointer to a value of type UTCDateTime. On return, the value this parameter points to is the current UTC date and time. 
options

A value of type OptionBits. Pass kUTCDefaultOptions for the default behavior.
Return Value

A result code. See “Date, Time, and Measurement Utilities Result Codes”.
Discussion

This API returns the current date and time as UTC in utcDateTime. Otherwise, it is set to 0. Use kUTCDefaultOptions in the options for default behavior. Different behavior may be specified through this parameter in the future. If the operation is successful noErr is returned. If a NULL pointer is passed in utcDateTime, paramErr is returned.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
UTCUtils.h*/
OSStatus GetUTCDateTime (
   UTCDateTime * utcDateTime,
   OptionBits options
){};

/*DisposeTextToUnicodeInfo

Releases the memory allocated for the specified Unicode converter object. 

OSStatus DisposeTextToUnicodeInfo (
   TextToUnicodeInfo * ioTextToUnicodeInfo
);
Parameters
ioTextToUnicodeInfo

A pointer to a Unicode converter object of type TextToUnicodeInfo, used for converting text to Unicode. On input, you specify the object to dispose. It must be an object which your application created using the function CreateTextToUnicodeInfo or CreateTextToUnicodeInfoByEncoding. You must not point to any other type of Unicode converter object. Your application should not use this function with the same structure more than once. 
Return Value

A result code. See “TEC Manager Result Codes”. If your application specifies an invalid Unicode converter object, such as NULL, the function returns a paramErr result code.
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus DisposeTextToUnicodeInfo (
   TextToUnicodeInfo * ioTextToUnicodeInfo
){};


/*c2pstrcpy

Converts a C string to a Pascal string. (Deprecated in Mac OS X v10.4. You should store strings as Core Foundation CFStrings instead. See CFString Reference.)

void c2pstrcpy (
   Str255 dst,
   const char * src
);
Parameters
dst

On output, the Pascal string.
src

The C string you want to convert.
Discussion

This function allows in-place conversion. That is, the src and dst parameters can point to the memory location.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/
void c2pstrcpy (
   Str255 dst,
   const char * src
){};


/*PLstrcmp

(Deprecated in Mac OS X v10.4. Use Core Foundation strings (CFStrings) instead. See CFString Reference.)

short PLstrcmp (
   ConstStr255Param str1,
   ConstStr255Param str2
);
Parameters
str1
str2
Return Value
Discussion
Special Considerations

If you need to convert Pascal strings, you can use functions like CFStringCreateWithPascalString to do so.
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PLStringFuncs.h*/
short PLstrcmp (
   ConstStr255Param str1,
   ConstStr255Param str2
){};


/*RegisterComponentResource

Registers a component stored in a resource file.

Component RegisterComponentResource (
   ComponentResourceHandle cr,
   short global
);
Parameters
cr

A handle to a component resource that describes the component to be registered. The component resource contains all the information required to register the component. Components you register with this function must be stored in a resource file as a component resource. The Component Manager automatically registers component resources stored in files with file types of 'thng' that are stored in the Extensions folder. See “Resources” for more information on component resource files. 
global

A set of flags that controls the scope of component registration. See “Register Component Resource flags” for a description of the flags. 
Return Value

The unique component identifier assigned to the component by the Component Manager, or NULL if the function could not register the component. See the description of the Component data type.
Discussion

Before a component can be used by an application, the component must be registered with the Component Manager. Applications can then find and open the component using the standard Component Manager functions. 

If you want to register a component that is in memory, use the RegisterComponent function.

This function does not actually load the code specified by the component resource into memory. Rather, the Component Manager loads the component code the first time an application opens the component. If the code is not in the same file as the component resource or if the Component Manager cannot find the file, the open request fails.

Note that a component registered locally by your application remains registered until your application unregisters it or quits. When an application quits, the Component Manager automatically closes any component connections to that application. In addition, if the application has registered components that reside in its heap space, the Component Manager automatically unregisters those components. A component registered globally by your application remains registered until your application unregisters it or until the computer is shut down. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

Component RegisterComponentResource (
   ComponentResourceHandle cr,
   short global
){};


/*SetDefaultComponent

Changes the search order for registered components. 

OSErr SetDefaultComponent (
   Component aComponent,
   short flags
);
Parameters
aComponent

The component which you wish moved to the front of the search chain. The order of the search chain influences which component the Component Manager selects in response to an application’s use of the OpenDefaultComponent and FindNextComponent functions. You can use a component instance here, but you must coerce the data type appropriately. 
flags

A value specifying the control information governing the operation. The value of this parameter controls which component description fields the Component Manager examines during the reorder operation. Set the appropriate flags to 1 to define the fields that are examined during the reorder operation. See “Set Default Component Flags” for a description of the values you can use here. 
Return Value

A result code. See “Component Manager Result Codes”.
Discussion

Note that this function changes the search order for all applications. As a result, you should use this function carefully. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr SetDefaultComponent (
   Component aComponent,
   short flags
){};

/*CopyPascalStringToC

Converts a Pascal String to a C string. (Deprecated in Mac OS X v10.4. You should store strings as Core Foundation CFStrings instead. See CFString Reference.)

void CopyPascalStringToC (
   ConstStr255Param src,
   char * dst
);
Parameters
src

The Pascal string you want to convert.
dst

On output, the C string.
Discussion

This function allows in-place conversion. That is, the src and dst parameters can point to the same memory location.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/

void CopyPascalStringToC (
   ConstStr255Param src,
   char * dst
){};


/*MPNotifyQueue

Sends a message to the specified message queue.

OSStatus MPNotifyQueue (
   MPQueueID queue,
   void * param1,
   void * param2,
   void * param3
);
Parameters
queue

The queue ID of the message queue you want to notify. 
param1

The first 32-bits of the message to send. 
param2

The second 32-bits of the message to send.
param3

The third 32-bits of the message to send.
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

This function sends a message to the specified queue, which consist of the three parameters, param1, param2, and param3. The system does not interpret the three 32-bit words which comprise the text of the message. If tasks are waiting on the specified queue, the first waiting task is unblocked and the task’s MPWaitOnQueue function completes.

Depending on the queue mode, the system either allocates messages dynamically or assigns them to memory reserved for the queue. In either case, if no more memory is available for messages MPNotifyQueue returns kMPInsufficientResourcesErr.

You can call this function from an interrupt handler if messages are reserved on the queue. For more information about queueing modes and reserving messages, see MPSetQueueReserve.

Also see the function MPWaitOnQueue. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPNotifyQueue (
   MPQueueID queue,
   void * param1,
   void * param2,
   void * param3
){};

/*InitUtil

Copies the contents of parameter RAM into low memory. (Deprecated in Mac OS X v10.3. There is no replacement because Mac OS X doesn’t require this initialization.)

OSErr InitUtil ();
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
OSUtils.h*/
OSErr InitUtil (){};


/*GetSysPPtr

Returns a pointer to the low-memory copy of parameter RAM. (Deprecated in Mac OS X v10.4. There is no replacement; this function always returns NULL in Mac OS X.)

SysPPtr GetSysPPtr ();
Return Value

See the description of the SysPPtr data type.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
SysPPtr GetSysPPtr (){};


/*WriteParam

Write the modified values in the system parameters data structure to parameter RAM. (Deprecated in Mac OS X v10.4. There is no replacement, because this function does nothing in Mac OS X.)

OSErr WriteParam ();
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
OSErr WriteParam (){};
/*LMGetApplZone

(Deprecated in Mac OS X v10.4. There is no replacement; this function was included to facilitate porting legacy applications to Carbon, but it serves no useful purpose in Mac OS X.)

THz LMGetApplZone (void);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
THz LMGetApplZone (void){};


/*CallComponentFunctionWithStorageProcInfo


long CallComponentFunctionWithStorageProcInfo (
   Handle storage,
   ComponentParameters * params,
   ProcPtr func,
   ProcInfoType funcProcInfo
);
Parameters
storage
params
funcProcInfo
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Components.h*/
long CallComponentFunctionWithStorageProcInfo (
   Handle storage,
   ComponentParameters * params,
   ProcPtr func,
   ProcInfoType funcProcInfo
){};


/*MoreMasterPointers

Allocates a specified number of master pointers in the current heap zone. (Deprecated in Mac OS X v10.4. There is no replacement function; master pointers do not need to be pre-allocated in Mac OS X.)

void MoreMasterPointers (
   UInt32 inCount
);
Parameters
inCount

The number of master pointers you want to allocate in a single nonrelocatable block. 
Carbon Porting Notes

Carbon applications should use this function instead of MoreMasters to allocate a nonrelocatable block of master pointers in the current heap zone.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void MoreMasterPointers (
   UInt32 inCount
){};


/*LMGetSysFontFam

(Deprecated in Mac OS X v10.4. Use GetSysFont instead.)

SInt16 LMGetSysFontFam (void);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
LowMem.h*/
SInt16 LMGetSysFontFam (void){};



/*LMGetSysFontSize

(Deprecated in Mac OS X v10.4. Use GetDefFontSize instead.)

SInt16 LMGetSysFontSize (void);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
LowMem.h*/
SInt16 LMGetSysFontSize (void){};


/*LMSetSysFontFam

(Deprecated in Mac OS X v10.4. There is no replacement; this function was included to facilitate porting legacy applications to Carbon, but it serves no useful purpose in Mac OS X.)

void LMSetSysFontFam (
   SInt16 value
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
LowMem.h*/
void LMSetSysFontFam (
   SInt16 value
){};


/*LMSetSysFontSize


void LMSetSysFontSize (
   SInt16 value
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
LowMem.h*/

void LMSetSysFontSize (
   SInt16 value
){};


/*ReleaseFolder

Releases the Trash folder in preparation for unmounting a server volume. (Deprecated in Mac OS X v10.3. This function is not needed in Mac OS X.)

OSErr ReleaseFolder (
   short vRefNum,
   OSType folderType
);
Parameters
vRefNum

Pass the volume reference number of the server volume on which you want to release the Trash folder. 
folderType

Always pass the kTrashFolderType constant. Other folder types are currently ignored.
Return Value

A result code. See "Folder Manager Result Codes".
Discussion

When you call FindFolder with the kTrashFolderType constant, it opens a file on a server volume that ensures each server volume user gets a unique Trash folder. Because a server volume’s Trash folder may contain files or folders put there by the user, applications should delete the contents of the server volume’s Trash folder. To do this, before your application unmounts a server volume, your application should call ReleaseFolder, or the UnmountVol request could fail with a fBsyErr result code. ReleaseFolder closes the file FindFolder may have opened and releases the Trash folder on that volume.

Your application should not use this function unless you want to unmount one or more server volumes. Normally, applications should not unmount servers; they should let users use the Finder to unmount volumes. In particular, applications should have no need to release the Trash folder explicitly; rather, unmounting volumes should be left to users to do with the Finder or by restarting. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
Folders.h*/
OSErr ReleaseFolder (
   short vRefNum,
   OSType folderType
){};

/*Status
You can use the Status function to obtain status information from a device driver.

pascal OSErr Status(short refNum, short csCode,
                    void *csParamPtr); 
refNum 
The driver reference number. 
csCode 
A driver-dependent code specifying the type of information requested. 
csParamPtr 
A pointer to a csParam array where the status information will be returned. 
DESCRIPTION
The Status function returns information about the device driver specified by the refNum parameter. The value you pass in the csCode parameter and the received information pointed to by the csParamPtr parameter are defined by the driver you are calling. For more information, see the appropriate chapters for the standard device drivers in this book and other books in the Inside Macintosh series.

The Status function is a high-level synchronous version of the low-level PBStatus function. Use the PBStatus function if you need to specify a drive number or if you want the status request to be asynchronous. 

Note 
The Device Manager interprets a csCode value of 1 as a special case. When the Device Manager receives a status request with a csCode value of 1, it returns a handle to the driver's device control entry. 
This type of status request is not passed to the device driver.  
SPECIAL CONSIDERATIONS
Do not call the Status function at interrupt time. Synchronous requests at interrupt time may block other pending I/O requests and cause the Device Manager to loop indefinitely while it waits for the device driver to complete the interrupted requests.

RESULT CODES noErr	0	No error
statusErr	-18	Driver does not respond to this status request
badUnitErr	-21	Driver reference number does not match unit table
unitEmptyErr	-22	Driver reference number specifies a nil handle in unit table
abortErr	-27	Request aborted by KillIO
notOpenErr	-28	Driver not open

SEE ALSO
For information about the low-level function for monitoring device drivers, see the next section, which describes the PBStatus function.*/
pascal OSErr Status(short refNum, short csCode,  void *csParamPtr){}; 


/*EndianS32_NtoB

Converts a signed 32-bit value in the computer’s native format to the equivalent big-endian value.

SInt32 EndianS32_NtoB (
   SInt32    value
);
Parameters
value

A signed 32-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt32 EndianS32_NtoB (
   SInt32    value
){};


/*S64Div


SInt64 S64Div (
   SInt64 dividend,
   SInt64 divisor
);
Parameters
dividend
divisor
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt64 S64Div (
   SInt64 dividend,
   SInt64 divisor
){};

/*S64SetU


SInt64 S64SetU (
   UInt32 value
);
Parameters
value
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt64 S64SetU (
   UInt32 value
){};

/*S64Add


SInt64 S64Add (
   SInt64 left,
   SInt64 right
);
Parameters
x
y
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt64 S64Add (
   SInt64 left,
   SInt64 right
){};


/*U64Subtract


UInt64 U64Subtract (
   UInt64 left,
   UInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
UInt64 U64Subtract (
   UInt64 left,
   UInt64 right
){};

/*U64Compare


SInt32 U64Compare (
   UInt64 left,
   UInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

SInt32 U64Compare (
   UInt64 left,
   UInt64 right
){};

/*EndianU32_LtoN

Converts an unsigned 32-bit little-endian value to the equivalent value in the computer’s native format.

UInt32 EndianU32_LtoN (
   UInt32    value
);
Parameters
value

An unsigned 32-bit little-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
UInt32 EndianU32_LtoN (
   UInt32    value
){};


/*EndianU16_LtoN

Converts an unsigned 16-bit little-endian value to the equivalent value in the computer’s native format.

UInt16 EndianU16_LtoN (
   UInt16    value
);
Parameters
value

An unsigned 16-bit little-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
UInt16 EndianU16_LtoN (
   UInt16    value
){};


/*BitAnd

Performs the AND logical operation on two long words.

long BitAnd (
   long value1,
   long value2
);
Parameters
value1

A long word. 
value2

A long word.
Return Value

A long word that is the result of the AND operation on the long words passed as arguments. Each bit in the returned value is set if and only if the corresponding bit is set in both value1 and value2. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
ToolUtils.h*/
long BitAnd (
   long value1,
   long value2
){};

/*BitShift

Shifts bits in a long word.

long BitShift (
   long value,
   short count
);
Parameters
value

A long word. 
count

The number of bits to shift. If this number is positive, BitShift shifts this many positions to the left; if this number is negative, BitShift shifts this many positions to the right. The value in this parameter is converted to the result of MOD 32. 
Return Value

A long word that is the result of shifting the bits in the long word passed in as an argument. The shift’s direction and extent are determined by the count parameter. Zeroes are shifted into empty positions regardless of the direction of the shift. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
ToolUtils.h*/

long BitShift (
   long value,
   short count
){};



/*GetScriptVariable

Retrieves the value of the specified script variable from the specified script system.

long GetScriptVariable (
   short script,
   short selector
);
Parameters
script

A value that specifies the script system whose variable you are accessing. Use one of the script-code constants listed in “Meta Script Codes”. 
selector

A value that specifies a particular script variable. Use one of the selector constants listed in “Script Variable Selectors”. Valid selector values are defined by each script system.
Return Value

0 if the selector value is invalid or if the specified script system is not installed. For some valid selectors, 0 may also be a valid return value. For example, calling GetScriptVariable with a selector of smScriptLang on a version of Macintosh system software that has been localized for the United States returns 0. Although GetScriptVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptVariable; the remaining bytes are set to 0.
Discussion

Each enabled script system maintains a set of variables that control the current settings of that script system, including the ID numbers of its international resources, its preferred fonts and font sizes, and its primary line direction. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/
long GetScriptVariable (
   short script,
   short selector
){};

/*RelString

Compares two Pascal strings using the string comparison rules of the Macintosh file system and returns a value that indicates the sorting order of the first string relative to the second string. (Deprecated in Mac OS X v10.4. Use CFStringCompare or UCCompareText instead.)

short RelString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
);
Parameters
str1

One of the Pascal strings to be compared. 
str2

The other Pascal string to be compared.
caseSensitive

A flag that indicates how to handle case-sensitive information during the comparison. If the value of caseSens is TRUE, uppercase characters are distinguished from the corresponding lowercase characters. If it is FALSE, case information is ignored. 
diacSensitive

A flag that indicates how to handle information about diacritical marks during the string comparison. If the value of diacSensitive is TRUE, characters with diacritical marks are distinguished from the corresponding characters without diacritical marks during the comparison. If it is FALSE, diacritical marks are ignored.
Return Value

Returns –1 if the first string is less than the second string, 0 if the two strings are equal, and 1 if the first string is greater than the second string. It compares the two strings in the same manner as does the EqualString function, by simply looking at the ASCII values of their characters. However, RelString provides more information about the two strings—it indicates their relationship to each other, rather than determining if they are exactly equal. 
Discussion

This function does not make use of any script or language information; it assumes the original Macintosh character set only. 
Special Considerations

The RelString function is not localizable and does not work properly with non-Roman script systems.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
StringCompare.h*/
short RelString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
){};


/*Maintaining Working Directories
pascal OSErr OpenWD	(short vRefNum, long dirID, long procID, 
			short *wdRefNum);
pascal OSErr CloseWD	(short wdRefNum);
pascal OSErr GetWDInfo	(short wdRefNum, short *vRefNum, long *dirID, 
			long *procID);*/
pascal OSErr GetWDInfo	(short wdRefNum, short *vRefNum, long *dirID, 
			long *procID){};


/*Manipulating the Default Volume
pascal OSErr GetVol 		(StringPtr volName, short *vRefNum);
pascal OSErr SetVol		(StringPtr volName, short vRefNum);
pascal OSErr HGetVol		(StringPtr volName, short *vRefNum, 
				long *dirID);
pascal OSErr HSetVol		(StringPtr volName, short vRefNum, long dirID);*/
pascal OSErr SetVol		(StringPtr volName, short vRefNum){};


/*p2cstrcpy

Converts a Pascal string to a C string. (Deprecated in Mac OS X v10.4. You should store strings as Core Foundation CFStrings instead. See CFString Reference.)

void p2cstrcpy (
   char * dst,
   ConstStr255Param src
);
Parameters
dst

On output, the C string.
src

The Pascal string you want to convert.
Discussion

This function allows in-place conversion. That is, the src and dst parameters can point to the memory location.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextUtils.h*/

void p2cstrcpy (
   char * dst,
   ConstStr255Param src
){};

/*CreateTextToUnicodeInfoByEncoding

Based on the given text encoding specification, creates and returns a Unicode converter object containing information required for converting strings from the specified non-Unicode encoding to Unicode. 

OSStatus CreateTextToUnicodeInfoByEncoding (
   TextEncoding iEncoding,
   TextToUnicodeInfo * oTextToUnicodeInfo
);
Parameters
iEncoding

The text encoding specification for the source text. 
oTextToUnicodeInfo

The Unicode converter object of type TextToUnicodeInfo returned by the function. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

You can use this function instead of the CreateTextToUnicodeInfo function when you do not need to create a Unicode mapping structure. You simply specify the text encoding of the source text. However, this method is less efficient because the text encoding parameter must be resolved internally into a Unicode mapping. 

You cannot specify a version of Unicode. The function uses a 16-bit form of Unicode as the default.

You pass a Unicode converter object returned from CreateTextToUnicodeInfoByEncoding to the function ConvertFromTextToUnicode or ConvertFromPStringToUnicode to identify the information to be used for the conversion. These two functions modify the contents of the Unicode converter object. 

You pass a Unicode converter object returned from CreateTextToUnicodeInfoByEncoding to the function TruncateForTextToUnicode to identify the information to be used to truncate the string. This function does not modify the contents of the Unicode converter object.

If you are converting the text stream to Unicode as an intermediary encoding, and then from Unicode to the final destination encoding, you use the function CreateUnicodeToTextInfo to create a Unicode converter object for the second part of the process. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
UnicodeConverter.h*/
OSStatus CreateTextToUnicodeInfoByEncoding (
   TextEncoding iEncoding,
   TextToUnicodeInfo * oTextToUnicodeInfo
){};



/*PurgeSpace

Determines the total amount of free memory and the size of the largest allocatable block in the current heap zone if it were purged. (Deprecated in Mac OS X v10.4. There is no replacement; heaps are never purged in Mac OS X.)

void PurgeSpace (
   long * total,
   long * contig
);
Parameters
total

On return, the total amount of free memory, in bytes, in the current heap zone if it were purged. This amount includes space that is already free. 
contig

On return, the size of the largest contiguous block of free memory in the current heap zone if it were purged.
Discussion

The PurgeSpace function does not actually purge the current heap zone.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void PurgeSpace (
   long * total,
   long * contig
){};

/*EndianS16_NtoB

Converts a signed 16-bit value in the computer’s native format to the equivalent big-endian value.

SInt16 EndianS16_NtoB (
   SInt16    value
);
Parameters
value

A signed 16-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt16 EndianS16_NtoB (
   SInt16    value
){};


/*ReadLocation

Obtains information about a geographic location or time zone.

void ReadLocation (
   MachineLocation * loc
);
Parameters
loc

On return, the fields of the geographic location structure containing the geographic location and the time-zone information.The ReadLocation procedure reads the stored geographic location and time zone of the Macintosh computer from extended parameter RAM. 

You can get values for the latitude, longitude, daylight savings time (DST), or Greenwich mean time (GMT). If the geographic location record has never been set, all fields contain 0.

Discussion

The latitude and longitude are stored as Fract values, giving accuracy to within one foot. For example, a Fract value of 1.0 equals 90 degrees –1.0 equals –90 degrees and –2.0 equals –180 degrees. 

To convert these values to a degrees format, you need to convert the Fract values first to the Fixed data type, then to the LongInt data type. Use the Mathematical and Logical Utilities functions Fract2Fix and Fix2Long to accomplish this task.

The DST value is a signed byte value that specifies the offset for the hour field—whether to add one hour, subtract one hour, or make no change at all. 

The GMT value is in seconds east of GMT. For example, San Francisco is at –28,800 seconds (8 hours * 3,600 seconds per hour) east of GMT. The gmtDelta field is a 3-byte value contained in a long word, so you must take care to get it properly.

The ReadLocation function was previously available with the Script Manager.

For more information on the geographic location record, see MachineLocation. 

For more information on the Fract data type and the conversion routines Long2Fix, Fix2Fract, Fract2Fix, and Fix2Long, see Mathematical and Logical Utilities. 
Special Considerations

Do not call the ReadLocation function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void ReadLocation (
   MachineLocation * loc
){};

/*HandAndHand

Concatenates two relocatable blocks.

OSErr HandAndHand (
   Handle hand1,
   Handle hand2
);
Parameters
hand1

A handle to the first relocatable block, whose contents do not change but are concatenated to the end of the second relocatable block. 
hand2

A handle to the second relocatable block, whose size the Memory Manager expands so that it can concatenate the information from handl to the end of the contents of this block.
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The HandAndHand function concatenates the information from the relocatable block specified by handl onto the end of the relocatable block specified by hand2. The handl variable remains unchanged.

Because the HandAndHand function dereferences the handle handl, you must call the HLock function to lock the block before calling HandAndHand. Afterward, you can call the HUnlock function to unlock it. Alternatively, you can save the block’s original state by calling the HGetState function, lock the block by calling HLock, and then restore the original settings by calling HSetState.

Because HandAndHand moves memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr HandAndHand (
   Handle hand1,
   Handle hand2
){};

/*CountResources

Returns the total number of available resources of a given type.

short CountResources (
   ResType theType
);
Parameters
theType

A resource type.
Return Value

The total number of resources of the given type in all resource forks open to your application.
Discussion

To check for errors, call the ResError function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short CountResources (
   ResType theType
){};

/*GetIndResource

Returns a handle to a resource of a given type in resource forks open to your application.

Handle GetIndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type. 
index

An integer ranging from 1 to the number of resources of a given type returned by the CountResources function, which is the number of resources of that type in all resource forks open to your application. 
Return Value

A handle to a resource of the given type. If you call this function repeatedly over the entire range of the index, it returns handles to all resources of the given type in all resource forks open to your application. The function returns handles for all resources in the most recently opened resource fork first, and then for those in resource forks opened earlier in reverse chronological order. If you provide an index to that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by CountResources, the function returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code. 
Discussion

This function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE.

If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, the function returns an empty handle (a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the GetIndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.

The UseResFile function affects which file the Resource Manager searches first when looking for a particular resource; this is not the case when you use GetIndResource to get an indexed resource.

If you want to find out how many resources of a given type are in a particular resource fork, set the current resource file to that resource fork, then call the Count1Resources function and use the Get1IndResource function to get handles to the resources of that type. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle GetIndResource (
   ResType theType,
   short index
){};


/*GetResInfo

Gets a resource’s resource ID, resource type, and resource name.

void GetResInfo (
   Handle theResource,
   short * theID,
   ResType * theType,
   Str255 name
);
Parameters
theResource

A handle to the resource for which you want to retrieve information. If the handle isn’t a valid handle to a resource, the function does nothing to determine whether this has occurred, call the ResError function. 
theID

On return, a pointer to the resource ID of the specified resource.
theType

On return, a pointer to the resource type of the specified resource.
name

On return, the name of the specified resource.
Discussion

To set a resource’s ID, resource type, or resource name, use the SetResInfo function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void GetResInfo (
   Handle theResource,
   short * theID,
   ResType * theType,
   Str255 name
){};


/*RGetResource

Gets resource data for a resource and includes ROM-resident system resources in the Resource Manager’s search of resource maps.

Unsupported

Handle RGetResource (
   ResType theType,
   SInt16 theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data. 
theID

An integer that uniquely identifies the resource about which you wish to retrieve data. 
Return Value

If the function finds the specified resource entry in one of the resource maps and the entry contains a valid handle, it returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, RGetResource attempts to read the resource into memory. If it can’t find the resource data, the function returns NULL, and the ResError function returns the result code resNotFound. The RGetResource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code. If you call RGetResource with a resource type that can’t be found in any of the resource maps of the open resource forks, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL. 
Discussion

The function searches the resource maps in memory for the specified resource. The resource maps in memory, which represent all open resource forks, are arranged as a linked list. The RGetResource function first uses the GetResource function to search this list. The GetResource function starts with the current resource file and progresses through the list in order (that is, in reverse chronological order in which the resource forks were opened) until it finds the resource’s entry in one of the resource maps. If GetResource doesn’t find the specified resource in its search of the resource maps of open resource forks (which includes the System file’s resource fork), RGetResource sets the global variable RomMapInsert to TRUE, then calls GetResource again. In response, GetResource performs the same search, but this time it looks in the resource map of the ROM-resident resources before searching the resource map of the System file. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Carbon Porting Notes

There will be no ROM in Mac OS X, so this ROM-related function will not be supported.
Declared In
Resources.h*/
Handle RGetResource (
   ResType theType,
   SInt16 theID
){};

/*GetVRefNum

Gets a volume reference number from a file reference number. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr GetVRefNum (
   short fileRefNum,
   short * vRefNum
);
Parameters
fileRefNum

The file reference number of an open file. 
vRefNum

On return, a pointer to the volume reference number of the volume containing the file specified in the refNum parameter.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you also want to determine the directory ID of the specified file’s parent directory, call the PBGetFCBInfoSync or PBGetFCBInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetVRefNum (
   short fileRefNum,
   short * vRefNum
){};



/*File Operation Status Dictionary Keys

Keys used to determine the status of a file operation as reported in a status dictionary.

const CFStringRef kFSOperationTotalBytesKey;
const CFStringRef kFSOperationBytesCompleteKey;
const CFStringRef kFSOperationBytesRemainingKey;
const CFStringRef kFSOperationTotalObjectsKey;
const CFStringRef kFSOperationObjectsCompleteKey;
const CFStringRef kFSOperationObjectsRemainingKey;
const CFStringRef kFSOperationTotalUserVisibleObjectsKey;
const CFStringRef kFSOperationUserVisibleObjectsCompleteKey;
const CFStringRef kFSOperationUserVisibleObjectsRemainingKey;
const CFStringRef kFSOperationThroughputKey;
Constants
kFSOperationTotalBytesKey

The value for this key is a CFNumber that represents the total number of bytes that will be moved or copied by this file operation. This value is not available for a directory operation if the kFSFileOperationSkipPreflight option flag is specified.

Available in Mac OS X v10.4 and later.
kFSOperationBytesCompleteKey

The value for this key is a CFNumber that represents the total number of bytes that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationBytesRemainingKey

The value for this key is a CFNumber that represents the total number of bytes that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationTotalObjectsKey

The value for this key is a CFNumber that represents the total number of objects that will be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationObjectsCompleteKey

The value for this key is a CFNumber that represents the total number of objects that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationObjectsRemainingKey

The value for this key is a CFNumber that represents the total number of objects that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationTotalUserVisibleObjectsKey

The value for this key is a CFNumber that represents the total number of user-visible objects that will be moved or copied by this file operation. In general, an object is user-visible if it is displayed in a Finder window. For example, a package is counted as a single user-visible object even though it typically contains many other objects.

Available in Mac OS X v10.4 and later.
kFSOperationUserVisibleObjectsCompleteKey

The value for this key is a CFNumber that represents the total number of user-visible objects that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationUserVisibleObjectsRemainingKey

The value for this key is a CFNumber that represents the total number of user-visible objects that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationThroughputKey

The value for this key is a CFNumber that represents the current throughput of this file operation in bytes per second.

Available in Mac OS X v10.4 and later.
Discussion

The status dictionary for a file operation is passed back to your status callback function. For more information, see “File Operation Callbacks”. You can also get the status dictionary for a file operation by calling a status accessor function such as FSFileOperationCopyStatus.*/
const CFStringRef kFSOperationTotalBytesKey;
 const CFStringRef kFSOperationBytesCompleteKey;
const CFStringRef kFSOperationBytesRemainingKey;
const CFStringRef kFSOperationTotalObjectsKey;
 const CFStringRef kFSOperationObjectsCompleteKey;
 const CFStringRef kFSOperationObjectsRemainingKey;
 const CFStringRef kFSOperationTotalUserVisibleObjectsKey;
 const CFStringRef kFSOperationUserVisibleObjectsCompleteKey;
 const CFStringRef kFSOperationUserVisibleObjectsRemainingKey;
 const CFStringRef kFSOperationThroughputKey;

/*CSCopyUserName

Returns a reference to the CFString that represents the user name.

CFStringRef CSCopyUserName (
   Boolean useShortName
);
Parameters
useShortName

A Boolean value that specifies whether to return the short name or full name of the user.
Return Value

A CFStringRef. See the Base Services documentation for a description of the CFStringRef data type.
Discussion

The function CSCopyUserName returns a CFStringRef based on the read UID (RUID, as returned by getuid) of the calling process. This can result in unexpected behavior (that is, CSCopyUserName returning different results than SCDynamicStoreCopyConsoleUser) for processes that manipulate their UID.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
CFStringRef CSCopyUserName (
   Boolean useShortName
){};


/*CSCopyMachineName

Returns a reference to the CFString that represents the computer name.

CFStringRef CSCopyMachineName ();
Return Value

A CFStringRef. See the Base Services documentation for a description of the CFStringRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
CFStringRef CSCopyMachineName (){};


/*Calling Routines via Universal Procedure Pointers
long CallUniversalProc  (UniversalProcPtr theProcPtr, 
                         ProcInfoType theProcInfo, ...);
long CallOSTrapUniversalProc
                        (UniversalProcPtr theProcPtr, 
                         ProcInfoType theProcInfo, ...);*/
long CallOSTrapUniversalProc
                        (UniversalProcPtr theProcPtr, 
                         ProcInfoType theProcInfo, ...){};
long CallUniversalProc  (UniversalProcPtr theProcPtr, 
                         ProcInfoType theProcInfo, ...){};


/*Manipulating the Processor Caches
pascal Boolean SwapInstructionCache
				(Boolean cacheEnable);
pascal void FlushInstructionCache
				(void);
pascal Boolean SwapDataCache(Boolean cacheEnable);
pascal void FlushDataCache	(void);
void FlushCodeCache		(void);
OSErr FlushCodeCacheRange	(void *address, unsigned long count);*/
OSErr FlushCodeCacheRange	(void *address, unsigned long count){};

/*Adding a Drive
pascal void AddDrive	(short drvrRefNum, short drvNum, DrvQElPtr qEl);*/
pascal void AddDrive	(short drvrRefNum, short drvNum, DrvQElPtr qEl){};


/*NewGestaltValue

Installs a new Gestalt selector code and a value that Gestalt returns for that selector.

OSErr NewGestaltValue (
   OSType selector,
   long newValue
);
Parameters
selector

The selector code you want to add. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
newValue

The value to return for the new selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You call the function NewGestaltValue when the specified selector is not already installed and you don't want to override an existing value.

In Mac OS X, the new selector and value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr NewGestaltValue (
   OSType selector,
   long newValue
){};

/*ReplaceGestaltValue

Replaces the value that the function Gestalt returns for a specified selector code with the value provided to the function.

OSErr ReplaceGestaltValue (
   OSType selector,
   long replacementValue
);
Parameters
selector

The selector code you want to add. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
replacementValue

The replacement Gestalt value for the selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You use the function ReplaceGestaltValue to replace an existing value. You should not call this function to introduce a value that doesn't already exist; instead call the function NewGestaltValue.

In Mac OS X, the selector and replacement value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr ReplaceGestaltValue (
   OSType selector,
   long replacementValue
){};

/*SetGestaltValue

Sets the value the function Gestalt will return for a specified selector code, installing the selector if it was not already installed.

OSErr SetGestaltValue (
   OSType selector,
   long newValue
);
Parameters
selector

The selector code you want to set. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
newValue

The new Gestalt value for the selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You use SetGestaltValue to establish a value for a selector, without regard to whether the selector was already installed.

In Mac OS X, the selector and new value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr SetGestaltValue (
   OSType selector,
   long newValue
){};


/*DeleteGestaltValue

Deletes a Gestalt selector code so that it is no longer recognized by Gestalt.

OSErr DeleteGestaltValue (
   OSType selector
);
Parameters
selector

The selector code you want to delete. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

After calling this function, subsequent query or replacement calls for the selector code will fail as if the selector had never been installed. 

In Mac OS X, the selector is on a per-context basis. You cannot use this function to affect another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr DeleteGestaltValue (
   OSType selector
){};


/*LMGetCurApName


StringPtr LMGetCurApName (void);
Availability
Available in Mac OS X v10.0 and later.
Declared In
LowMem.h*/
StringPtr LMGetCurApName (void){};

/*PLstrcpy

(Deprecated in Mac OS X v10.4. Use Core Foundation strings (CFStrings) instead. See CFString Reference.)

StringPtr PLstrcpy (
   StringPtr str1,
   ConstStr255Param str2
);
Parameters
str1
str2
Return Value
Discussion
Special Considerations

If you need to convert Pascal strings, you can use functions like CFStringCreateWithPascalString to do so.
Version Notes
Carbon Porting Notes
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PLStringFuncs.h*/
StringPtr PLstrcpy (
   StringPtr str1,
   ConstStr255Param str2
){};

/*GetSharedLibrary

Locates and possibly also loads an import library into your application’s context.

OSErr GetSharedLibrary (
   ConstStr63Param libName,
   CFragArchitecture archType,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
);
Parameters
libName

The name of an import library. 
archType

The instruction set architecture of the import library. For the PowerPC architecture, use the constant kPowerPCArch. For the 680x0 architecture, use the constant kMotorola68KArch. 
loadFlags

A flag that specifies the operation to perform on the import library. The Code Fragment Manager recognizes the constants described in “Load Flag, Symbol Class, and Fragment Locator Constants”. 
connID

On return, a pointer to the connection ID that identifies the connection to the import library. You can pass this ID to other Code Fragment Manager functions. 
mainAddr

On return, a pointer to the main address of the import library. The value returned is specific to the import library itself and is not used by the Code Fragment Manager. 
errMessage

On return, the name of the fragment that could not successfully be loaded. This parameter is meaningful only if the call to GetSharedLibrary fails. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The GetSharedLibrary function locates the import library named by the libName parameter and possibly also loads that import library into your application’s context. The actions of GetSharedLibrary depend on the action flag you pass in the loadFlags parameter; pass kFindLib to get the connection ID of an existing connection to the specified fragment, kLoadLib to load the specified fragment, or kLoadNewCopy to load the fragment with a new copy of the fragment’s data section.

The GetSharedLibrary function does not resolve any unresolved imports in your application. In particular, you cannot use it to resolve any weak imports in your code fragment.

Loading involves finding the specified fragment, reading it into memory (if it is not already in memory), and preparing it for execution. The Code Fragment Manager attempts to resolve all symbols imported by the fragment; to do so may involve loading import libraries.

If the fragment loading fails, the Code Fragment Manager returns an error code. Note, however, that the error encountered is not always in the fragment you asked to load. Rather, the error might have occurred while attempting to load an import library that the fragment you want to load depends on. For this reason, the Code Fragment Manager also returns, in the errMessage parameter, the name of the fragment that caused the load to fail. Although fragment names are restricted to 63 characters, the errMessage parameter is declared as type Str255; doing this allows future versions of the Code Fragment Manager to return a more informative message in the errMessage parameter. 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr GetSharedLibrary (
   ConstStr63Param libName,
   CFragArchitecture archType,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
){};

/*FSResolveAliasWithMountFlags

Returns an FSRef to the target of an alias.

OSErr FSResolveAliasWithMountFlags (
   const FSRef * fromFile,
   AliasHandle inAlias,
   FSRef * target,
   Boolean * wasChanged,
   unsigned long mountFlags
);
Parameters
fromFile

A pointer to an FSRef specifying the starting point for a relative search. If you pass NULL in this parameter, FSResolveAliasWithMountFlags performs only an absolute search. If you pass a pointer to a valid FSRef in the fromFile parameter, FSResolveAliasWithMountFlags performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the FSMatchAlias function.
inAlias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to an FSRef structure. On successful return, this FSRef refers to the target of the alias record. This parameter must point to a valid FSRef structure.
wasChanged

A pointer to a Boolean value indicating, on return, whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, FSResolveAliasWithMountFlags sets the wasChanged parameter to true. Otherwise, it sets it to false. (FSResolveAliasWithMountFlags never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
mountFlags

Options controlling how the alias is resolved. See “Volume Mount Options” for a description of the values you can use here. Set this parameter to kResolveAliasFileNoUI to prevent any user interaction while the alias is being resolved.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The function FSResolveAliasWithMountFlags is identical to FSResolveAlias with the exception that it provides the mountFlags parameter, allowing callers additional control over how the alias is resolved.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/
OSErr FSResolveAliasWithMountFlags (
   const FSRef * fromFile,
   AliasHandle inAlias,
   FSRef * target,
   Boolean * wasChanged,
   unsigned long mountFlags
){};

/*GetSysDirection

Returns the current value of SysDirection, the global variable that determines the system direction (primary line direction). (Deprecated in Mac OS X v10.4. This function does not return anything useful in Mac OS X.)

short GetSysDirection ();
Parameters
Return Value

The current value of SysDirection: 0 if the system direction is left-to-right; -1 ($FFFF) if the system direction is right-to-left. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short GetSysDirection (){};




/*FontToScript

Translates a font family ID number into its corresponding script code, if that script system is currently enabled. (Deprecated in Mac OS X v10.4. Use ATSFontFamilyGetEncoding instead.)

short FontToScript (
   short fontNumber
);
Parameters
fontNumber

A font family ID number. 
Return Value

A script code. All recognized script codes and their defined constants are listed in “Meta Script Codes”. FontToScript returns only explicit script codes (≥ 0). If fontNumber is in the Roman range and the font force flag is TRUE, the script code returned is that of the system script and the script-forced result flag is set to TRUE. If fontNumber is in the non-Roman range, the state of the font force flag is ignored. If the script system corresponding to fontNumber is not enabled, the script code returned is that of the system script and the script-defaulted result flag is set to TRUE.
Discussion

The information about the script code is subject to two control flags—the font force flag and the international resources selection flag. You can test and set these flags with the GetScriptManagerVariable and SetScriptManagerVariable selectors smFontForce and smIntlForce.

The function starts by initializing two result flags, the script-forced result flag and the script-defaulted result flag, to FALSE. These flags are Script Manager variables, accessed through the GetScriptManagerVariable function selectors smForced and smDefault.

Do not use the function FontToScript to convert resource IDs to scripts codes. 
Special Considerations

FontToScript may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short FontToScript (
   short fontNumber
){};


/*SetScriptManagerVariable

Sets the specified Script Manager variable to the value of the input parameter.

OSErr SetScriptManagerVariable (
   short selector,
   long param
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you wish to change, use one of the selector constants listed in “Script Manager Selectors”. 
param

The new value for the specified Script Manager variable.

The actual values to be assigned may be long integers, standard integers, or signed bytes. If the value is other than a long integer, you must store it in the low-order word or byte of the param parameter and set the unused bytes to 0.
Return Value

A result code. See “Script Manager Result Codes”. The value smBadVerb if the selector is not valid. Otherwise, the function returns 0 (noErr).
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/
OSErr SetScriptManagerVariable (
   short selector,
   long param
){};

/*Controlling and Monitoring Device Drivers
pascal OSErr Control          (short refNum, short csCode, const void 
                               *csParamPtr);
pascal OSErr PBControl        (ParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBControlSync    (ParmBlkPtr paramBlock);
pascal OSErr PBControlAsync   (ParmBlkPtr paramBlock);
pascal OSErr Status           (short refNum, short csCode, void *csParamPtr);
pascal OSErr PBStatus         (ParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBStatusSync     (ParmBlkPtr paramBlock);
pascal OSErr PBStatusAsync    (ParmBlkPtr paramBlock);
pascal OSErr KillIO           (short refNum);
pascal OSErr PBKillIO         (ParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBKillIOSync     (ParmBlkPtr paramBlock);
pascal OSErr PBKillIOAsync    (ParmBlkPtr paramBlock);*/
pascal OSErr PBControlSync    (ParmBlkPtr paramBlock){};












































































































