#include <AudioToolbox/AudioToolbox.h>

/*NewAUGraph

Creates a new AUGraph instance.

extern OSStatus NewAUGraph(AUGraph *outGraph);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NewAUGraph(AUGraph *outGraph){
printf ("NewAUGraph",*outGraph);
};

//work
/*AUGraphNewNode

Creates a new node inside of the specified graph.

extern OSStatus AUGraphNewNode(
AUGraph inGraph,
const ComponentDescription *inDescription,
UInt32 inClassDataSize,
const void *inClassData,
AUNode *outNode
);
Discussion

The graph to which the new node is to be added is set in inGraph, while the node to be added may be specified using either a ComponentDescription, obtained from the Component Manager. The value of inClassData is a CFPropertyList containing the serialized data of a saved state. The function returns outNode for future reference towards the newly-created node.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphNewNode(
AUGraph inGraph,
const ComponentDescription *inDescription,
UInt32 inClassDataSize,
const void *inClassData,
AUNode *outNode
){
printf ("AUGraphNewNode",inGraph,*inDescription,inClassDataSize,inClassData,*outNode);
};

/*AUGraphUninitialize

Uninitializes the graph and all of the Audio Units.

extern OSStatus AUGraphUninitialize(AUGraph inGraph);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphUninitialize(AUGraph inGraph){
printf ("AUGraphUninitialize",inGraph);
};

/*AUGraphStop

Stops all rendering through the graph.

extern OSStatus AUGraphStop(AUGraph inGraph);
Availability
Available in Mac OS X v10.0 and later.*/
 OSStatus AUGraphStop(AUGraph inGraph){
printf ("AUGraphStop",inGraph);
};

/*AUGraphConnectNodeInput

Connects two graph nodes together and specifies the way inputs are ordered.

extern OSStatus AUGraphConnectNodeInput(
AUGraph inGraph,
AUNode inSourceNode,
UInt32 inSourceOutputNumber,
AUNode inDestNode,
UInt32 inDestInputNumber
);
Discussion

When connecting nodes together, the developer must specify how the output of one node maps to the input of another. To prevent fan out, all output-input connections are one-to-one, where each node may have multiple inputs and outputs (indexed starting with 0).
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphConnectNodeInput(
AUGraph inGraph,
AUNode inSourceNode,
UInt32 inSourceOutputNumber,
AUNode inDestNode,
UInt32 inDestInputNumber
){
printf ("AUGraphConnectNodeInput",inGraph,inSourceNode,inSourceOutputNumber,inDestNode,inDestInputNumber);
};

/*AUGraphGetNodeCount

Returns the number of nodes in the current graph.

extern OSStatus AUGraphGetNodeCount(
AUGraph inGraph,
UInt32 *outNumberOfNodes
);
Availability
Available in Mac OS X v10.0 and later.*/
 OSStatus AUGraphGetNodeCount(
AUGraph inGraph,
UInt32 *outNumberOfNodes
){
printf ("AUGraphGetNodeCount",inGraph,*outNumberOfNodes);
};

/*AUGraphStart

Begins audio rendering through the graph.

extern OSStatus AUGraphStart(AUGraph inGraph);
Discussion

This function starts with the head node, always an output unit, and works through the graph to get to the inputs, pulls the data, and renders it through all of the Audio Units in the path leading to the head.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphStart(AUGraph inGraph){
printf ("AUGraphStart",inGraph);
};

/*AUGraphOpen

Instantiates every Audio Unit in the graph.

extern OSStatus AUGraphOpen(AUGraph inGraph);
Discussion

This function should be called after the initial set of nodes is added to the graph and connections have been made between them. This will instantiate the nodes, meaning that their properties will be ready for modification. Each node’s sample rate may also be set after the graph is opened.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphOpen(AUGraph inGraph){
printf ("AUGraphOpen",inGraph);
};

/*AUGraphClose

Closes the graph and deallocates its Audio Unit nodes.

extern OSStatus AUGraphClose(AUGraph inGraph);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphClose(AUGraph inGraph){
printf ("AUGraphClose",inGraph);
};

/*AUGraphInitialize

Initializes the graph and the connected Audio Units.

extern OSStatus AUGraphInitialize(AUGraph inGraph);
Discussion

Invoking this function will activate the connections between nodes and will initialize all nodes that are part of a connection. It is important to note that if format changes occur, sample rates for output nodes must be set before this function is called.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphInitialize(AUGraph inGraph){
printf ("AUGraphInitialize",inGraph);
};

/*AUGraphGetNodeInfo

Returns information about a node.

extern OSStatus AUGraphGetNodeInfo(
AUGraph inGraph,
AUNode inNode,
ComponentDescription *outDescription,
UInt32 *outClassDataSize,
void **outClassData,
AudioUnit *outAudioUnit
);
Discussion

This function retrieves various pieces of information about a graph’s nodes, which may be saved and used to rebuild the graph later using AUGraphNewNode(). The node and graph containing the node in question are passed as inGraph and inNode, respectively. Upon output, outDescription points to a ComponentDescription, provided by the Component Manager. Also, outClassData points towards a CFPropertyRef, which may be saved and used to rebuild the graph later on. The node’s Audio Unit type is pointed to by outAudioUnit. The outClassDataSize parameter is currently not used, and will return 0.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphGetNodeInfo(
AUGraph inGraph,
AUNode inNode,
ComponentDescription *outDescription,
UInt32 *outClassDataSize,
void **outClassData,
AudioUnit *outAudioUnit
){
printf ("AUGraphGetNodeInfo",inGraph,inNode,*outDescription,*outClassDataSize,outClassData,*outAudioUnit);
};

