#include <AE/AE.h>


/*AEDisposeDesc

Deallocates the memory used by a descriptor.

OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to deallocate. On return, a null descriptor. If you pass a null descriptor in this parameter, AEDisposeDesc returns noErr. See AEDesc.
Return Value

A result code. See Apple Event Manager Result Codes. As currently implemented, AEDisposeDesc always returns noErr.
Discussion

The AEDisposeDesc function deallocates the memory used by a descriptor. After calling this method, the descriptor becomes an empty descriptor with a type of typeNULL. Because all Apple event structures (except for keyword-specified descriptors) are descriptors, you can use AEDisposeDesc for any of them.

Do not call AEDisposeDesc on a descriptor obtained from another Apple Event Manager function (such as the reply event from a call to AESend) unless that function returns successfully.
Special Considerations

If the AEDesc might contain an OSL token, dispose of it with AEDisposeToken.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEDisposeDesc (
   AEDesc * theAEDesc
){
printf ("AEDisposeDesc",*theAEDesc);
};




/*AEGetParamDesc

Gets a copy of the descriptor for a keyword-specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to pass the extracted data to another function as a descriptor. 

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter descriptor from. See AppleEvent.
theAEKeyword

A keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The descriptor type for the desired Apple event parameter. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the requested Apple event parameter is not of the desired type, the Apple Event Manager attempts to coerce it to the desired type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned descriptor is the same as the descriptor type of the Apple event parameter.

See DescType.
result

A pointer to a descriptor. On successful return, a copy of the descriptor for the specified Apple event parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

If the actual parameter you are getting with AEGetParamDesc is a record, AEGetParamDesc will only allow you to request it as a typeAERecord, typeAEList, or typeWildcard. For any other type, it will return errAECoercionFail.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
){
printf ("AEGetParamDesc",*theAppleEvent,theAEKeyword,desiredType,*result);
};

/*NewAEEventHandlerUPP

Creates a new universal procedure pointer to an event handler function.

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);
Return Value

See AEEventHandlerUPP.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
){
printf ("AEEventHandlerUPP",userRoutine);
};


/*AECountItems

Counts the number of descriptors in a descriptor list.

OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);
Parameters
theAEDescList

A pointer to the descriptor list to count. See AEDescList.
theCount

A pointer to a count variable. On return, the number of descriptors in the specified descriptor list.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application typically counts the descriptors in a descriptor list when it is extracting data from an Apple event. You can use the functions in “Getting Items From Descriptor Lists” to get an individual item from a descriptor list or to iterate through the items. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
){
printf ("AECountItems",*theAEDescList,*theCount);
};


/*AEGetNthPtr

Gets a copy of the data from a descriptor at a specified position in a descriptor list; typically used when your application needs to work with the extracted data directly.

OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAEDescList

A pointer to the descriptor list that contains the descriptor. See AEDescList.
index

A one-based positive integer indicating the position in the descriptor list of the descriptor to get the data from. AEGetNthPtr returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthPtr attempts to coerce the data to this type. If you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied data is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthPtr returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor at the position in the descriptor list specified by the index parameter.
maximumSize

The maximum length, in bytes, of the expected data. The AEGetNthPtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified descriptor. If this value is larger than the value of the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the descriptor, though AEGetNthPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetNthPtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEGetNthPtr function uses a buffer to return the data for a specified descriptor from a specified descriptor list. The function attempts to coerce the descriptor to the descriptor type specified by the desiredType parameter.

Before calling AEGetNthPtr, you can call the AESizeOfNthItem function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AESizeOfNthItem may coerce the data, which may cause the size of the data to change. If you are using AEGetNthPtr to iterate through a list of descriptors of the same type with a fixed size, such as a list of descriptors of type typeFSS, you can get the size once, allocate a buffer, and reuse it for each call.

The order of items in an Apple event record may change after an insertion or deletion. In addition, duplicating an Apple event record is not guaranteed to preserve the item order. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
){
printf ("AEGetNthPtr",*theAEDescList,index,desiredType,*theAEKeyword,*typeCode,dataPtr,maximumSize,*actualSize);
};


/*AEGetDescData

Gets the data from the specified descriptor.

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);
Parameters
theAEDesc

A pointer to the descriptor to get the data from. See AEDesc.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes should be the same as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor.
maximumSize

The length, in bytes, of the expected descriptor data. The AEGetDescData function will not return more data than you specify in this parameter. You typically determine the maximum size by calling AEGetDescDataSize.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application can call AEGetDescDataSize to get the size, in bytes, of the data in a descriptor, allocate a buffer or variable of that size, then call AEGetDescData to get the data. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
){
printf ("AEGetDescData",*theAEDesc,dataPtr,maximumSize);
};


/*AECreateDesc

Creates a new descriptor that incorporates the specified data.

OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);
Parameters
typeCode

The descriptor type for the new descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the new descriptor. This data is copied into a newly-allocated block of memory for the descriptor that is created. To minimize copying overhead, consider using AECreateDescFromExternalPtr.
dataSize

The length, in bytes, of the data for the new descriptor.
result

A pointer to a descriptor. On successful return, a descriptor that incorporates the data specified by the dataPtr parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

While it is possible to create an Apple event descriptor or a descriptor list or a descriptor with the AECreateDesc function (assuming you have access to the raw data for an Apple event, list, or descriptor), you typically create these structured objects with their specific creation routines—AECreateAppleEvent, AECreateList, or AECreateDesc. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
){
printf ("AECreateDesc",typeCode,dataPtr,dataSize,*result);
};



/*AEGetParamPtr

Gets a copy of the data for a specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to work with the extracted data directly.

OSErr AEGetParamPtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter data from. See AppleEvent.
theAEKeyword

The keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the theAEKeyword parameter is not of the desired type, AEGetParamPtr attempts to coerce the data to this type. However, if the desired type is typeWildCard, no coercion is performed.

On return, you can determine the actual descriptor type by examining the typeCode parameter.

See DescType.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. The returned type is either the same as the type specified by the desiredType parameter or, if the desired type was type wildcard, the true type of the descriptor. Specify NULL if you do not care about this return value. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the parameter data. Specify NULL if you do not care about this return value. 
maximumSize

The maximum length, in bytes, of the expected Apple event parameter data. The AEGetParamPtr function will not return more data than you specify in this parameter.
actualSize

A pointer to a variable of type Size. On return, the length, in bytes, of the data for the specified Apple event parameter. If this value is larger than the value you passed in the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the parameter, though AEGetParamPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetParamPtr again. Specify NULL if you do not care about this return value.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

You should use this function only to extract data from value descriptors such as typeUTF8Text.

Because this function allows you to specify a desired type, it can result in coercion. When used correctly, this has the positive effect of returning the data in the desired format. However, it can have side effects you may not be expecting, such as the overhead of calls to coercion handlers. See also the Version Notes section below for possible problems with coercion.

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

Before calling AEGetParamPtr, you can call the AESizeOfParam function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AEGetParamPtr may coerce the data, which may cause the size of the data to change. 

In some cases, you may get improved efficiency extracting information from an Apple event with the AEGetDescDataRange function.
Version Notes

Thread safe starting in Mac OS X v10.2.

If the actual parameter you are getting with AEGetParamPtr is a record, AEGetParamPtr will erroneously allow you to get the parameter as any type at all, when it really should allow only typeAERecord, typeAEList, or typeWildcard. For other types, it will place raw record data into the designated buffer. With AppleScript 1.1.2, it would then return errAECoercionFail, as expected. With AppleScript 1.3 and later, however, it returns noErr.

You can work around this problem by checking the returned parameter from any call to AEGetParamPtr. If the source type is typeAERecord and the type you asked for was anything other than typeAERecord, typeAEList, or typeWildcard, you should assume the coercion failed.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetParamPtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
){
printf ("AEGetParamPtr",*theAppleEvent,theAEKeyword, desiredType,*typeCode,dataPtr,maximumSize,*actualSize);
};


/*AEGetNthDesc

Copies a descriptor from a specified position in a descriptor list into a specified descriptor; typically used when your application needs to pass the extracted data to another function as a descriptor.

OSErr AEGetNthDesc (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   AEDesc * result
);
Parameters
theAEDescList

A pointer to the descriptor list to get the descriptor from. See AEDescList.
index

A one-based positive integer indicating the position of the descriptor to get. AEGetNthDesc returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the descriptor to copy. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthDesc attempts to coerce it to this type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied descriptor is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On successful return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthDesc returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
result

A pointer to a descriptor. On successful return, a copy of the descriptor specified by the index parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

If the Nth descriptor in the list is itself an Apple event record and the desired type is not wildcard, record, or list, AEGetNthDesc will fail with an errAECoercionFailed error. This behavior prevents coercion problems. 

You may find the AEGetNthPtr function convenient for retrieving data for direct use in your application, as it includes automatic coercion. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEGetNthDesc (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   AEDesc * result
){
printf ("AEGetNthDesc",*theAEDescList,index,desiredType,*theAEKeyword,*result);
};

/*AECreateAppleEvent

Creates an Apple event with several important attributes but no parameters.

OSErr AECreateAppleEvent (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   const AEAddressDesc * target,
   AEReturnID returnID,
   AETransactionID transactionID,
   AppleEvent * result
);
Parameters
theAEEventClass

The event class of the Apple event to create. This parameter becomes accessible through the keyEventClassAttr attribute of the Apple event. Some event classes are described in “Event Class Constants”. See AEEventClass.
theAEEventID

The event ID of the Apple event to create. This parameter becomes accessible through the keyEventIDAttr attribute of the Apple event. Some event IDs are described in “Event ID Constants”. See AEEventID.
target

A pointer to an address descriptor. Before calling AECreateAppleEvent, you set the descriptor to identify the target (or server) application for the Apple event. This parameter becomes accessible through the keyAddressAttr attribute of the Apple event. See AEAddressDesc.
returnID

The return ID for the created Apple event. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID. This parameter becomes accessible through the keyReturnIDAttr attribute of the Apple event. The return ID constant is described in “ID Constants for the AECreateAppleEvent Function”. See AEReturnID.
transactionID

The transaction ID for this Apple event. A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify the kAnyTransactionID constant if the Apple event is not one of a series of interdependent Apple events. This parameter becomes accessible through the keyTransactionIDAttr attribute of the Apple event. This transaction ID constant is described in “ID Constants for the AECreateAppleEvent Function”. See AETransactionID.
result

A pointer to an Apple event. On successful return, the new Apple event. On error, a null descriptor (one with descriptor type typeNull). If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting Apple event after it has finished using it. See the AppleEvent data type.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AECreateAppleEvent function creates an empty Apple event. You can add parameters to the Apple event after you create it with the functions described in “Adding Parameters and Attributes to an Apple Event”. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateAppleEvent (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   const AEAddressDesc * target,
   AEReturnID returnID,
   AETransactionID transactionID,
   AppleEvent * result
){
printf ("AECreateAppleEvent",theAEEventClass,theAEEventID,*target,returnID,transactionID,*result);
};

/*AEPutParamDesc

Puts a descriptor and a keyword into an Apple event or Apple event record as an Apple event parameter.

OSErr AEPutParamDesc (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   const AEDesc * theAEDesc
);
Parameters
theAppleEvent

A pointer to the Apple event to add a parameter to. See the AppleEvent data type.
theAEKeyword

The keyword specifying the parameter to add. If the Apple event already has a parameter with this keyword, the parameter is replaced.

Some keyword constants are described in “Keyword Parameter Constants”.

See AEKeyword.
theAEDesc

A pointer to the descriptor for the parameter to add. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEPutParamDesc (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   const AEDesc * theAEDesc
){
printf ("AEPutParamDesc",*theAppleEvent,theAEKeyword,*theAEDesc);
};

/*AECreateList

Creates an empty descriptor list or Apple event record.

OSErr AECreateList (
   const void * factoringPtr,
   Size factoredSize,
   Boolean isRecord,
   AEDescList * resultList
);
Parameters
factoringPtr

A pointer to the data at the beginning of each descriptor that is the same for all descriptors in the list. If there is no common data, or if you decide not to isolate the common data, pass NULL as the value of this parameter.
factoredSize

The size of the common data. If there is no common data, or if you decide not to isolate the common data, pass 0 as the value of this parameter. (See the Discussion section for more information.)
isRecord

A Boolean value that specifies the kind of list to create. Pass a value of TRUE to create an Apple event record (a data structure of type AERecord) or FALSE to create a descriptor list.
resultList

A pointer to a descriptor list variable. On successful return, the descriptor list or Apple event record that the AECreateList function creates. On error, a null descriptor. See AEDescList.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AECreateList function creates an empty descriptor list or Apple event record. You can use the functions described in “Adding Items to Descriptor Lists” to populate the list as part of creating an Apple event. After sending the Apple event with the AESend function, you should dispose of the descriptor list with the AEDisposeDesc function when you no longer need it.

If you intend to use a descriptor list for a factored Apple event array, you must provide, in the factoringPtr parameter, a pointer to the data shared by all items in the array and, in the factoredSize parameter, the size of the common data. The common data must be 4, 8, or more than 8 bytes in length because it always consists of (a) the descriptor type (4 bytes) (b) the descriptor type (4 bytes) and the size of each item’s data (4 bytes) or (c) the descriptor type (4 bytes), the size of each item’s data (4 bytes), and some portion of the data itself (1 or more bytes).

For information about data types used with Apple event arrays, see “Apple Event Manager Data Types”.
Version Notes

The factoringPtr and factoredSize parameters are not supported in Mac OS X v10.2 and later. You should pass NULL and zero, respectively, for these parameters.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateList (
   const void * factoringPtr,
   Size factoredSize,
   Boolean isRecord,
   AEDescList * resultList
){
printf ("AECreateList",factoringPtr,factoredSize,isRecord,*resultList);
};


/*AECoercePtr

Coerces data to a desired descriptor type and creates a descriptor containing the newly coerced data.

OSErr AECoercePtr (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   AEDesc * result
);
Parameters
typeCode

The descriptor type of the source data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data to coerce.
dataSize

The length, in bytes, of the data to coerce.
toType

The desired descriptor type of the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
result

A pointer to a descriptor. On successful return, a descriptor containing the coerced data and matching the descriptor type specified in toType. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Starting in Mac OS X version 10.2, pointer-based coercion handlers are not called if the input type is “structured”—that is, if the type to be coerced is typeAEList, typeAERecord, or coerced typeAERecord. If you want to add a coercion handler for one of these types, it must be a descriptor-based handler. This does not mean you are required to use descriptor-based coercion handlers everywhere—for “flat” data types, such as typeText, pointer-based handlers are still fine.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECoercePtr (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   AEDesc * result
){
printf ("AECoercePtr",typeCode,dataPtr,dataSize,toType,*result);
};

/*AECoerceDesc

Coerces the data in a descriptor to another descriptor type and creates a descriptor containing the newly coerced data.

OSErr AECoerceDesc (
   const AEDesc * theAEDesc,
   DescType toType,
   AEDesc * result
);
Parameters
theAEDesc

A pointer to the descriptor containing the data to coerce. See AEDesc.
toType

The desired descriptor type of the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
result

A pointer to a descriptor. On successful return, a descriptor containing the coerced data and matching the descriptor type specified in toType. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”. If AECoerceDesc returns a nonzero result code, it returns a null descriptor record (a descriptor record of type typeNull, which does not contain any data) unless the Apple Event Manager is not available because of limited memory.
Version Notes

See the Version Notes section for the AECoercePtr function for information on when to use descriptor-based versus pointer-based coercion handlers starting in Mac OS X version 10.2.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECoerceDesc (
   const AEDesc * theAEDesc,
   DescType toType,
   AEDesc * result
){
printf ("AECoerceDesc",*theAEDesc,toType,*result);
};

/*AEPutParamPtr

Puts a pointer to data, a descriptor type, and a keyword into an Apple event or Apple event record as an Apple event parameter.

OSErr AEPutParamPtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAppleEvent

A pointer to the Apple event to add a parameter to. See the AppleEvent data type.
theAEKeyword

The keyword for the parameter to add. If the Apple event already includes an parameter with this keyword, the parameter is replaced.

Some keyword constants are described in “Keyword Parameter Constants”.

See AEKeyword.
typeCode

The descriptor type for the parameter to add. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the parameter to add.
dataSize

The length, in bytes, of the data for the parameter to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutParamPtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
){
printf ("AEPutParamPtr",*theAppleEvent,theAEKeyword,typeCode,dataPtr,dataSize);
};


/*AEInitializeDesc

Initializes a new descriptor. 

void AEInitializeDesc (
   AEDesc * desc
);
Parameters
desc

A pointer to a new descriptor. See AEDesc.
Discussion

The function sets the type of the descriptor to typeNull and sets the data handle to NULL. If you need to initialize a descriptor that already has some data in it, use AEDisposeDesc to deallocate the memory and initialize the descriptor.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

void AEInitializeDesc (
   AEDesc * desc
){
printf ("AEInitializeDescr",*desc);
};

/*AEGetDescDataSize

Gets the size, in bytes, of the data in the specified descriptor.

Size AEGetDescDataSize (
   const AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to obtain the data size for. See AEDesc.
Return Value

Returns the size, in bytes, of the data in the specified descriptor.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
Size AEGetDescDataSize (
   const AEDesc * theAEDesc
){
printf ("AEGetDescDataSize",*theAEDesc);
};

/*AEPutDesc

Adds a descriptor to any descriptor list, possibly replacing an existing descriptor in the list.

OSErr AEPutDesc (
   AEDescList * theAEDescList,
   long index,
   const AEDesc * theAEDesc
);
Parameters
theAEDescList

A pointer to the descriptor list to add a descriptor to. See AEDescList.
index

A one-based positive integer indicating the position to insert the descriptor at. If there is already a descriptor in the specified position, it is replaced.

You can pass a value of zero or count + 1 to add the descriptor at the end of the list. AEPutDesc returns an error (AEIllegalIndex) if you pass a negative number or a value that is out of range.
theAEDesc

A pointer to the descriptor to add to the list. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutDesc (
   AEDescList * theAEDescList,
   long index,
   const AEDesc * theAEDesc
){
printf ("AEPutDesc",*theAEDescList,index,*theAEDesc);
};

/*AEPutPtr

Puts data specified in a buffer to a descriptor list as a descriptor, possibly replacing an existing descriptor in the list.

OSErr AEPutPtr (
   AEDescList * theAEDescList,
   long index,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAEDescList

A pointer to the descriptor list to add a descriptor to. See AEDescList.
index

A one-based positive integer indicating the position to insert the descriptor at. If there is already a descriptor in the specified position, it is replaced.

You can pass a value of zero or count + 1 to add the descriptor at the end of the list. AEPutPtr returns an error (AEIllegalIndex) if you pass a negative number or a value that is out of range.
typeCode

The descriptor type for the descriptor to be put into the list. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the descriptor to add.
dataSize

The length, in bytes, of the data for the descriptor to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutPtr (
   AEDescList * theAEDescList,
   long index,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
){
printf ("AEPutPtr",theAEDescList,index, typeCode,dataPtr,dataSize);
};

/*DisposeAEEventHandlerUPP

Disposes of a universal procedure pointer to an event handler function.

void DisposeAEEventHandlerUPP (
   AEEventHandlerUPP userUPP
);
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

void DisposeAEEventHandlerUPP (
   AEEventHandlerUPP userUPP
){
printf ("DisposeAEEventHandlerUPP",userUPP);
};

/*AEGetAttributePtr

Gets a copy of the data for a specified Apple event attribute from an Apple event; typically used when your application needs to work with the data directly.

OSErr AEGetAttributePtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAppleEvent

A pointer to the Apple event to get the attribute data from. See AppleEvent.
theAEKeyword

The keyword that specifies the desired attribute. Some keyword constants are described in “Keyword Attribute Constants”. See AEKeyword.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the theAEKeyword parameter is not of the desired type, AEGetAttributePtr attempts to coerce the data to this type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned data is the same as the descriptor type of the Apple event attribute.

On return, you can determine the actual descriptor type by examining the typeCode parameter.

See DescType.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the attribute data pointed to by dataPtr. The returned type is either the same as the type specified by the desiredType parameter or, if the desired type was type wildcard, the true type of the descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to a buffer, local variable, or other storage location, created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the attribute data.
maximumSize

The maximum length, in bytes, of the expected attribute data. The AEGetAttributePtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified Apple event attribute. If this value is larger than the value you passed in the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the attribute, though AEGetAttributePtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetAttributePtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event attribute data for your application to use directly, call AEGetAttributePtr. To get a descriptor for an Apple event attribute to pass on to another Apple Event Manager routine, call AEGetAttributeDesc.

Before calling AEGetAttributePtr, you can call the AESizeOfAttribute function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AEGetAttributePtr may coerce the data, which may cause the size of the data to change. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetAttributePtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
){
printf ("AEGetAttributePtr",*theAppleEvent,theAEKeyword,desiredType,*typeCode,dataPtr,maximumSize,*actualSize);
};

/*AEDuplicateDesc

Creates a copy of a descriptor.

OSErr AEDuplicateDesc (
   const AEDesc * theAEDesc,
   AEDesc * result
);
Parameters
theAEDesc

A pointer to the descriptor to duplicate. See AEDesc.
result

A pointer to a descriptor. On return, the descriptor contains a copy of the descriptor specified by the theAEDesc parameter. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

It is common for applications to send Apple events that have one or more attributes or parameters in common. For example, if you send a series of Apple events to the same application, the address attribute is the same. In these cases, the most efficient way to create the necessary Apple events is to make a template Apple event that you can then copy—by calling the AEDuplicateDesc function—as needed. You then fill in or change the remaining parameters and attributes of the copy, send the copy by calling the AESend function and, after AESend returns a result code, dispose of the copy by calling AEDisposeDesc. You can use this approach to prepare structures of type AEDesc, AEDescList, AERecord, and AppleEvent. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEDuplicateDesc (
   const AEDesc * theAEDesc,
   AEDesc * result
){
printf ("AEDuplicateDesc",*theAEDesc,*result);
};

/*Getting Data and Keyword-Specified Descriptor Records Out of AE Records
pascal OSErr AEGetKeyPtr(const AERecord *theAERecord, 
AEKeyword theAEKeyword, DescType desiredType, 
DescType *typeCode, void* dataPtr, 
Size maximumSize, Size *actualSize);
pascal OSErr AEGetKeyDesc(const AERecord *theAERecord, 
AEKeyword theAEKeyword, DescType desiredType, 
AEDesc *result);*/
pascal OSErr AEGetKeyDesc(const AERecord *theAERecord, 
AEKeyword theAEKeyword, DescType desiredType, 
AEDesc *result){
printf ("AEGetKeyDesc",*theAERecord,theAEKeyword,desiredType,*result);
};

/*AEPutAttributePtr

Adds a pointer to data, a descriptor type, and a keyword to an Apple event as an attribute.

OSErr AEPutAttributePtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAppleEvent

A pointer to the Apple event to add an attribute to. See the AppleEvent data type.
theAEKeyword

The keyword for the attribute to add. If the Apple event already includes an attribute with this keyword, the attribute is replaced.

Some keyword constants are described in “Keyword Attribute Constants”.

See AEKeyword.
typeCode

The descriptor type for the attribute to add. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the attribute to add.
dataSize

The length, in bytes, of the data for the attribute to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutAttributePtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
){
printf ("AEPutAttributePtr",*theAppleEvent,theAEKeyword,typeCode,dataPtr,dataSize);
};

/*InvokeAEEventHandlerUPP

Calls an event handler universal procedure pointer.

OSErr InvokeAEEventHandlerUPP (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon,
   AEEventHandlerUPP userUPP
);
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr InvokeAEEventHandlerUPP (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon,
   AEEventHandlerUPP userUPP
){
printf ("InvokeAEEventHandlerUPP",*theAppleEvent,*reply,handlerRefcon,userUPP);
};

/*NewAECoercePtrUPP

Creates a new universal procedure pointer to a function that coerces data stored in a buffer.

AECoercePtrUPP NewAECoercePtrUPP (
   AECoercePtrProcPtr userRoutine
);
Return Value

See AECoercePtrUPP.
Discussion

See the AECoercePtrProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
AECoercePtrUPP NewAECoercePtrUPP (
   AECoercePtrProcPtr userRoutine
){
printf ("NewAECoercePtrUPP",userRoutine);
};

/*AEInstallCoercionHandler

Installs a coercion handler in either the application or system coercion handler dispatch table.

OSErr AEInstallCoercionHandler (
   DescType fromType,
   DescType toType,
   AECoercionHandlerUPP handler,
   long handlerRefcon,
   Boolean fromTypeIsDesc,
   Boolean isSysHandler
);
Parameters
fromType

The descriptor type of the data coerced by the handler. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
toType

The descriptor type of the resulting data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If there was already an entry in the specified coercion handler table for the same source descriptor type and result descriptor type, the existing entry is replaced. See DescType.
handler

A universal procedure pointer to the coercion handler function to install. See AECoercionHandlerUPP.
handlerRefcon

A reference constant. The Apple Event Manager passes this value to the handler each time it calls it. If your handler doesn’t require a reference constant, pass 0 for this parameter.
fromTypeIsDesc

Specifies the form of the data to coerce. Pass TRUE if the coercion handler expects the data as a descriptor or FALSE if the coercion handler expects a pointer to the data. The Apple Event Manager can provide a pointer to data more efficiently than it can provide a descriptor, so all coercion functions should accept a pointer to data if possible.
isSysHandler

Specifies the coercion table to add the handler to. Pass TRUE to add the handler to the system coercion table or FALSE to add the handler to your application’s coercion table. Use of the system coercion table is not recommended.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Before using AEInstallCoercionHandler to install a handler for a particular descriptor type, you can use the AEGetCoercionHandler function to determine whether the table already contains a coercion handler for that type. 
Version Notes

See the Version Notes section for the AECoercePtr function for information on when to use descriptor-based versus pointer-based coercion handlers starting in Mac OS X version 10.2.

Thread safe starting in Mac OS X v10.2.

Your application should not install a coercion handler in a system coercion handler dispatch table with the goal that the handler will get called when other applications perform coercions—this won’t work in Mac OS X. For more information, see “Writing and Installing Coercion Handlers” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEInstallCoercionHandler (
   DescType fromType,
   DescType toType,
   AECoercionHandlerUPP handler,
   long handlerRefcon,
   Boolean fromTypeIsDesc,
   Boolean isSysHandler
){
printf ("AEInstallCoercionHandler",fromType,toType,handler,handlerRefcon,fromTypeIsDesc,isSysHandler);
};


/*NewAECoerceDescUPP

Creates a new universal procedure pointer to a function that coerces data stored in a descriptor.

AECoerceDescUPP NewAECoerceDescUPP (
   AECoerceDescProcPtr userRoutine
);
Return Value

See AECoerceDescUPP.
Discussion

See the AECoerceDescProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
AECoerceDescUPP NewAECoerceDescUPP (
   AECoerceDescProcPtr userRoutine
){
printf ("AECoerceDescUPP",userRoutine);
};






