#ifndef SYS_EVENT_H
#define SYS_EVENT_H

#include <machine/types.h>
#include <sys/cdefs.h>
#include <stdint.h>


typedef unsigned short		u_short;//hys
typedef unsigned int		u_int;//hys
//#include <HYS/sys/event.h>
#include <APPLE/sys/event.h>
#include <linux/types.h>
/*The kevent structure is defined as:

     struct kevent {
             uintptr_t ident;        /identifier for this event *
             short     filter;       /*filter for event *
             u_short   flags;        * action flags for kqueue *
             u_int     fflags;       *filter flag value *
             intptr_t  data;          filter data value *
             void      *udata;      * opaque user data identifier *
     };
The fields of struct kevent are:

     ident      Value used to identify this event.  The exact interpretation
                is determined by the attached filter, but often is a file
                descriptor.

     filter     Identifies the kernel filter used to process this event.  The
                pre-defined system filters are described below.

     flags      Actions to perform on the event.

     fflags     Filter-specific flags.

     data       Filter-specific data value.

     udata      Opaque user-defined value passed through the kernel unchanged.

*/


struct kevent {
             uintptr_t ident;        /* identifier for this event */
             short     filter;       /* filter for event */
             u_short   flags;        /* action flags for kqueue */
             u_int     fflags;       /* filter flag value */
             intptr_t  data;         /* filter data value */
             void      *udata;       /* opaque user data identifier */
     };

//func
 /*int
     kqueue(void);

     int
     kevent(int kq, const struct kevent *changelist, int nchanges,
         struct kevent *eventlist, int nevents,
         const struct timespec *timeout);*/

int     kqueue(void);
int    kevent(int kq, const struct kevent *changelist, int nchanges,
         struct kevent *eventlist, int nevents,
         const struct timespec *timeout);


#endif
