#ifndef  SCPREFERENCES_H
#define SCPREFERENCES_H

#include <AvailabilityMacros.h>
#include <sys/cdefs.h>
#include <CoreFoundation/CoreFoundation.h>
#include <SystemConfiguration/SCDynamicStore.h>

/*SCPreferencesRef

typedef const struct __SCPreferences * SCPreferencesRef;  
Discussion 

This is the handle to an open preferences session for accessing system configuration preferences.*/
typedef const struct __SCPreferences * SCPreferencesRef;  

//function

/*SCPreferencesGetValue

CFPropertyListRef SCPreferencesGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key );  
Parameters
prefs
The preferences session.
key
The preference key to be returned.
Return Value

Returns the value associated with the specified preference key; NULL if no value was located. 
Discussion 

Returns the data associated with a preference key. 

This function retrieves data associated with the specified key. 

Note: To avoid inadvertantly reading stale data, first call the SCPreferencesLock function.*/
CFPropertyListRef SCPreferencesGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key );  


#endif