#ifndef CIPHERSUITE_H
#define CIPHERSUITE_H

#include <CarbonCore/MacTypes.h>

/*SSL Cipher Suite Constants

Represents the cipher suites available.

typedef UInt32 SSLCipherSuite;
enum
{SSL_NULL_WITH_NULL_NULL =                  0x0000,
   SSL_RSA_WITH_NULL_MD5 =                 0x0001,
   SSL_RSA_WITH_NULL_SHA =                 0x0002,
   SSL_RSA_EXPORT_WITH_RC4_40_MD5 =        0x0003,
   SSL_RSA_WITH_RC4_128_MD5 =              0x0004,
   SSL_RSA_WITH_RC4_128_SHA =              0x0005,
   SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 =    0x0006,
   SSL_RSA_WITH_IDEA_CBC_SHA =             0x0007,
   SSL_RSA_EXPORT_WITH_DES40_CBC_SHA =     0x0008,
   SSL_RSA_WITH_DES_CBC_SHA =              0x0009,
   SSL_RSA_WITH_3DES_EDE_CBC_SHA =         0x000A,
   SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA =  0x000B,
   SSL_DH_DSS_WITH_DES_CBC_SHA =           0x000C,
   SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA =      0x000D,
   SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA =  0x000E,
   SSL_DH_RSA_WITH_DES_CBC_SHA =           0x000F,
   SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA =      0x0010,
   SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 0x0011,
   SSL_DHE_DSS_WITH_DES_CBC_SHA =          0x0012,
   SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA =     0x0013,
   SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x0014,
   SSL_DHE_RSA_WITH_DES_CBC_SHA =          0x0015,
   SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA =     0x0016,
   SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 =    0x0017,
   SSL_DH_anon_WITH_RC4_128_MD5 =          0x0018,
   SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA = 0x0019,
   SSL_DH_anon_WITH_DES_CBC_SHA =          0x001A,
   SSL_DH_anon_WITH_3DES_EDE_CBC_SHA =     0x001B,
   SSL_FORTEZZA_DMS_WITH_NULL_SHA =        0x001C,
   SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA =0x001D,
   SSL_RSA_WITH_RC2_CBC_MD5 =              0xFF80,
   SSL_RSA_WITH_IDEA_CBC_MD5 =             0xFF81,
   SSL_RSA_WITH_DES_CBC_MD5 =              0xFF82,
   SSL_RSA_WITH_3DES_EDE_CBC_MD5 =         0xFF83,
   SSL_NO_SUCH_CIPHERSUITE =               0xFFFF
};
Constants
SSL_RSA_EXPORT_WITH_RC4_40_MD5

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_RSA_EXPORT_WITH_DES40_CBC_SHA

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_DH_anon_EXPORT_WITH_RC4_40_MD5

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA

Session key size conforms to pre-1998 US export restrictions.

Available in Mac OS X v10.2 and later.
SSL_RSA_WITH_RC2_CBC_MD5

This value can be specified for SSL 2 but not SSL 3.

Available in Mac OS X v10.2 and later.
SSL_RSA_WITH_IDEA_CBC_MD5

This value can be specified for SSL 2 but not SSL 3.

Available in Mac OS X v10.2 and later.
SSL_RSA_WITH_DES_CBC_MD5

This value can be specified for SSL 2 but not SSL 3.

Available in Mac OS X v10.2 and later.
SSL_RSA_WITH_3DES_EDE_CBC_MD5

This value can be specified for SSL 2 but not SSL 3.

Available in Mac OS X v10.2 and later.*/

typedef UInt32 SSLCipherSuite;
enum
{SSL_NULL_WITH_NULL_NULL =                  0x0000,
   SSL_RSA_WITH_NULL_MD5 =                 0x0001,
   SSL_RSA_WITH_NULL_SHA =                 0x0002,
   SSL_RSA_EXPORT_WITH_RC4_40_MD5 =        0x0003,
   SSL_RSA_WITH_RC4_128_MD5 =              0x0004,
   SSL_RSA_WITH_RC4_128_SHA =              0x0005,
   SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 =    0x0006,
   SSL_RSA_WITH_IDEA_CBC_SHA =             0x0007,
   SSL_RSA_EXPORT_WITH_DES40_CBC_SHA =     0x0008,
   SSL_RSA_WITH_DES_CBC_SHA =              0x0009,
   SSL_RSA_WITH_3DES_EDE_CBC_SHA =         0x000A,
   SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA =  0x000B,
   SSL_DH_DSS_WITH_DES_CBC_SHA =           0x000C,
   SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA =      0x000D,
   SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA =  0x000E,
   SSL_DH_RSA_WITH_DES_CBC_SHA =           0x000F,
   SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA =      0x0010,
   SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 0x0011,
   SSL_DHE_DSS_WITH_DES_CBC_SHA =          0x0012,
   SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA =     0x0013,
   SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 0x0014,
   SSL_DHE_RSA_WITH_DES_CBC_SHA =          0x0015,
   SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA =     0x0016,
   SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 =    0x0017,
   SSL_DH_anon_WITH_RC4_128_MD5 =          0x0018,
   SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA = 0x0019,
   SSL_DH_anon_WITH_DES_CBC_SHA =          0x001A,
   SSL_DH_anon_WITH_3DES_EDE_CBC_SHA =     0x001B,
   SSL_FORTEZZA_DMS_WITH_NULL_SHA =        0x001C,
   SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA =0x001D,
   SSL_RSA_WITH_RC2_CBC_MD5 =              0xFF80,
   SSL_RSA_WITH_IDEA_CBC_MD5 =             0xFF81,
   SSL_RSA_WITH_DES_CBC_MD5 =              0xFF82,
   SSL_RSA_WITH_3DES_EDE_CBC_MD5 =         0xFF83,
   SSL_NO_SUCH_CIPHERSUITE =               0xFFFF
};


#endif	
