

#ifndef IMAGECOMPRESSION_H
#define IMAGECOMPRESSION_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif


#include <OpenGL/OpenGL.h>
#include <QuartzCore/CoreVideo.h>

#ifndef STANDARDFILE_H
#include <StandardFile.h>//hys
#endif

#include <ColorSync/CMTypes.h>//hys

//#include <HYS/QuickTime/ImageCompression.h>
#include <APPLE/QuickTime/ImageCompression.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Data Types and Constants

All of the new data types and constants in this header file are listed alphabetically, with links to documentation and abstracts, if available.ICMCompressionFrameOptionsRef	
ICMCompressionPassModeFlags	
ICMCompressionSessionOptionsRef	
ICMCompressionSessionRef	
ICMCompressorSessionRef	
ICMCompressorSourceFrameRef	
ICMDataRateLimit	
ICMDecompressionFrameOptionsRef	
ICMDecompressionSessionOptionsRef	
ICMDecompressionSessionRef	
ICMDecompressionTrackingCallback	
ICMDecompressionTrackingCallbackRecord	
ICMDecompressionTrackingFlags	
ICMEncodedFrameOutputCallback	
ICMEncodedFrameOutputRecord	
ICMEncodedFrameRef	
ICMFieldMode	
ICMFrameType	
ICMMultiPassCopyDataAtTimeStampCallback	
ICMMultiPassGetTimeStampCallback	
ICMMultiPassReleaseCallback	
ICMMultiPassSetDataAtTimeStampCallback	
ICMMultiPassStorageCallbacks	
ICMMultiPassStorageCreationFlags	
ICMMultiPassStorageRef	
ICMMultiPassStorageStep	
ICMMutableEncodedFrameRef	
ICMNonScheduledDisplayTime	
ICMSourceTrackingCallback	
ICMSourceTrackingCallbackRecord	
ICMSourceTrackingFlags	
ICMValidTimeFlags	
MediaSampleFlags	
QTVisualContextImageAvailableCallback	
QTVisualContextRef	
codecCompletionDecoded	Codec has decoded this frame; if it is cancelled and rescheduled, set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags.
codecCompletionNotDisplayable	The frame may still be scheduled for decode, but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames..
codecCompletionNotDrawn	Set in conjunction with codecCompletionDest to indicate that the frame was not drawn.
codecInfoDoesMultiPass	Codec can perform multi-pass compression.
codecInfoDoesReorder	Codec can rearrange frames during compression.
icmFrameAlreadyDecoded	
icmFrameTimeDecodeImmediately	
icmFrameTimeDoNotDisplay	
icmFrameTimeHasDecodeTime	Indicates that decodeTime is valid.
icmFrameTimeIsNonScheduledDisplayTime	
kDVCPROHD1080i50CodecType	
kDVCPROHD1080i60CodecType	
kDVCPROHD720pCodecType	
kH264CodecType	
kICMCompressionFrameOptionsPropertyID_-
ForceKeyFrame	Boolean, ReadWrite.
kICMCompressionFrameOptionsPropertyID_FrameType	ICMFrameType, ReadWrite.
kICMCompressionPassMode_NoSourceFrames	
kICMCompressionPassMode_-
NotReadyToOutputEncodedFrames	
kICMCompressionPassMode_OutputEncodedFrames	
kICMCompressionPassMode_ReadFromMultiPassStorage	
kICMCompressionPassMode_WriteToMultiPassStorage	
kICMCompressionSessionOptionsPropertyID_-
AllowAsyncCompletion	Enables the compressor to call the encoded-frame callback from a different thread. By default this option is FALSE, which means that the compressor must call the encoded-frame callback from the same thread as ICMCompressionSessionEncodeFrame and ICMCompressionSession-
CompleteFrames. Also 'asok'.
kICMCompressionSessionOptionsPropertyID_-
AllowFrameReordering	Enables frame reordering. To encode B-frames a compressor must reorder frames, which may mean that the order in which they are emitted and stored (the decode order) may be different from the order in which they are presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must enable frame reordering by passing TRUE in this property. Also 'b ok'.
kICMCompressionSessionOptionsPropertyID_-
AllowFrameTimeChanges	Enables the compressor to modify frame times, improving its performance. Some compressors are able to identify and coalesce runs of identical frames and emit single frames with longer duration, or emit frames at a different frame rate from the original. By default, this flag is set to FALSE, which forces the compressor to emit one encoded frame for every source frame and to preserve frame display times. This option replaces the practice of having compressors return special high similarity values to indicate that frames can be dropped. Also '+ ok'.
kICMCompressionSessionOptionsPropertyID_-
AllowTemporalCompression	Enables temporal compression of P-frames and B-frames. By default, temporal compression is disabled. Also 'p ok'.
kICMCompressionSessionOptionsPropertyID_-
AverageDataRate	The long-term desired average data rate in bytes per second. This is not an absolute limit. The default data rate is zero, indicating that the setting of kICMCompressionSessionOptionsPropertyID_-
Quality should determine the size of compressed data. Data rate settings have effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'aver'.
kICMCompressionSessionOptionsPropertyID_-
CPUTimeBudget	UInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
CleanAperture	Native-endian CleanApertureImageDescription-
Extension, ReadWrite.
kICMCompressionSessionOptionsPropertyID_ColorTable	The color table for compression, used with indexed-color depths. Clients who are passed this property are responsible for disposing the returned CTabHandle. Also 'clut'.
kICMCompressionSessionOptionsPropertyID_-
CompressorComponent	Sets a specific compressor component or component instance to be used, or passes one of the wildcards anyCodec, bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. Pass this option to force the Image Compression Manager to use a specific compressor component or compressor component instance. To allow the Image Compression Manager to choose the compressor component, set the compressorComponent to anyCodec (the default), bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. If you pass in a component instance that you opened, the ICM will not close that instance; you must do so after the compression session is released. Also 'imco'.
kICMCompressionSessionOptionsPropertyID_-
CompressorSettings	A handle containing compressor settings. The compressor will be configured with these settings (by a call to ImageCodecSetSettings) during the ICMCompressionSessionCreate process. Also 'cost'.
kICMCompressionSessionOptionsPropertyID_-
DataRateLimitCount	UInt32, Read.
kICMCompressionSessionOptionsPropertyID_-
DataRateLimits	Zero, one, or two hard limits on data rate. Each hard limit is described by a data size in bytes and a duration in seconds. It requires that the total size of compressed data for any contiguous segment of that duration (in decode time) must not exceed the data size. By default, no data rate limits are set. When setting this property, the inPropValueSize parameter should be the number of data rate limits multiplied by sizeof(ICMDataRateLimit). Data rate settings have an effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'hard'.
kICMCompressionSessionOptionsPropertyID_Depth	UInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
DurationsNeeded	Indicates that durations of emitted frames are needed. If this option is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default, this flag is FALSE, so frames will not be delayed in order to calculate durations. If you pass encoded frames to AddMediaSampleFromEncodedFrame, you must set this flag to TRUE. Also 'need'.
kICMCompressionSessionOptionsPropertyID_-
ExpectedFrameRate	Fixed, ReadWrite.
kICMCompressionSessionOptionsPropertyID_FieldInfo	FieldInfoImageDescription-
Extension2, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MaxDataRateLimits	UInt32, Read.
kICMCompressionSessionOptionsPropertyID_-
MaxFrameDelayCount	The maximum frame delay count is the maximum number of frames that a compressor is allowed to hold before it must output a compressed frame. This value limits the number of frames that may be held in the compression window. If the maximum frame delay count is M, then before the call to encode frame N returns, frame N-M must have been emitted. The default value is kICMUnlimitedFrameDelayCount, which sets no limit on the compression window. Also 'cwin'.
kICMCompressionSessionOptionsPropertyID_-
MaxFrameDelayTime	TimeValue64, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MaxKeyFrameInterval	The maximum interval between key frames, also known as the key frame rate. Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames. This differs from previous practice, in which a key frame rate of zero disabled temporal compression. Also 'kyfr'.
kICMCompressionSessionOptionsPropertyID_-
MaxPartialSyncFrameInterval	SInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MultiPassStorage	A multipass compression client must provide a storage location for multipass data. Pass ICMMultiPassStorageCreate-
WithTemporaryFile to make the ICM store multipass data in a temporary file. Pass ICMMultiPassStorageCreate-
WithCallbacks to manage the storage yourself. Note that the amount of multipass data to be stored can be substantial; it could be greater than the size of the output movie file. If this property is not NULL, the client must call ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass around groups of calls to ICMCompressionSessionEncodeFrame. By default, this property is NULL and multipass compression is not enabled. The compression session options object retains the multipass storage object when one is set. Also 'imps'.
kICMCompressionSessionOptionsPropertyID_-
PixelAspectRatio	Native-endian PixelAspectRatioImageDescription-
Extension, ReadWrite.
kICMCompressionSessionOptionsPropertyID_Quality	The compression quality. This value is always used to set the spatial quality; if temporal compression is enabled, it is also used to set temporal quality. The default quality is codecNormalQuality. Also 'qual'.
kICMCompressionSessionOptionsPropertyID_-
ScalingMode	OSType, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
SourceFrameCount	UInt64, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
WasCompressed	Indicates that the source was previously compressed. This property is an optional information hint to the compressor; by default it is FALSE. Also 'wasc'.
kICMCompressionSessionPropertyID_-
CompressorPixelBufferAttributes	The compressor's pixel buffer attributes for the compression session. You can use these to create a pixel buffer pool for source pixel buffers. This is not the same as the sourcePixelBufferAttributes property passed to ICMCompressionSessionCreate. Getting this property does not change its retain count. Also 'batt'.
kICMCompressionSessionPropertyID_ImageDescription	The image description for a compression session. For some codecs, the image description may not be available before the first frame is compressed. Multiple calls to retrieve this property will return the same handle. The ICM will dispose of this handle when the compression session is disposed; the caller must not dispose of it. Also 'idsc'.
kICMCompressionSessionPropertyID_PixelBufferPool	A pool that can provide ideal source pixel buffers for a compression session. The compression session creates this pixel buffer pool based on the compressor's pixel buffer attributes and any pixel buffer attributes passed in to ICMCompressionSessionCreate. If the source pixel buffer attributes and the compressor pixel buffer attributes can not be reconciled, the pool is based on the source pixel buffer attributes and the ICM converts each CVPixelBuffer internally. Also 'pool'.
kICMCompressionSessionPropertyID_TimeScale	The time scale for the compression session. Also 'tscl'.
kICMDecompressionFrameOptionsPropertyID_-
DestinationPixelBuffer	CVPixelBufferRef, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_Accuracy	CodecQ, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
DecompressorComponent	DecompressorComponent, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
DisplayOrderRequired	Boolean, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
FieldMode	ICMFieldMode, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
MaxBufferCount	UInt32, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
OutputAheadTime	TimeRecord, ReadWrite.
kICMDecompressionSessionPropertyID_-
NonScheduledDisplayDirection	Fixed, ReadWrite.
kICMDecompressionSessionPropertyID_-
NonScheduledDisplayTime	ICMNonScheduledDisplayTime, ReadWrite.
kICMDecompressionSessionPropertyID_PixelBufferPool	CVPixelBufferPoolRef, Read.
kICMDecompressionSessionPropertyID_-
PixelBufferPoolIsShared	Boolean, Read.
kICMDecompressionTracking_EmittingFrame	
kICMDecompressionTracking_FrameDecoded	
kICMDecompressionTracking_FrameDropped	
kICMDecompressionTracking_FrameNeedsRequeueing	
kICMDecompressionTracking_LastCall	
kICMDecompressionTracking_ReleaseSourceData	
kICMFieldMode_BothFields	
kICMFieldMode_BottomFieldOnly	
kICMFieldMode_DeinterlaceFields	
kICMFieldMode_TopFieldOnly	
kICMFrameType_B	
kICMFrameType_I	
kICMFrameType_P	
kICMFrameType_Unknown	
kICMImageDescriptionPropertyID_ClassicTrackHeight	Fixed, Read.
kICMImageDescriptionPropertyID_ClassicTrackWidth	Fixed, Read.
kICMImageDescriptionPropertyID_CleanAperture	Native-endian CleanApertureImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_DisplayHeight	SInt32, Read.
kICMImageDescriptionPropertyID_DisplayWidth	SInt32, Read.
kICMImageDescriptionPropertyID_EncodedHeight	SInt32, ReadWrite.
kICMImageDescriptionPropertyID_EncodedWidth	SInt32, ReadWrite.
kICMImageDescriptionPropertyID_FieldInfo	FieldInfoImageDescription-
Extension2, ReadWrite.
kICMImageDescriptionPropertyID_GammaLevel	Fixed, ReadWrite.
kICMImageDescriptionPropertyID_NCLCColorInfo	Native-endian NCLCColorInfoImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_PixelAspectRatio	Native-endian PixelAspectRatioImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_-
ProductionDisplayHeight	SInt32, Read.
kICMImageDescriptionPropertyID_-
ProductionDisplayWidth	SInt32, Read.
kICMImageDescriptionPropertyID_RowBytes	SInt32, ReadWrite.
kICMMultiPassStorageCallbacksVersionOne	
kICMMultiPassStorage_DoNotDeleteWhenDone	
kICMMultiPassStorage_GetFirstTimeStamp	
kICMMultiPassStorage_GetLastTimeStamp	
kICMMultiPassStorage_GetNextTimeStamp	
kICMMultiPassStorage_GetPreviousTimeStamp	
kICMScalingMode_Letterbox	The clean aperture of the source frames is scaled to fit inside the clean aperture of the destination, preserving the original display aspect ratio. If the display aspect ratios are different, the source frames are centered with black bars above and below, or to the left and right.
kICMScalingMode_StretchCleanAperture	The clean aperture of the source frames is scaled to the clean aperture of the destination.
kICMScalingMode_StretchProductionAperture	The full width and height of source frames is scaled to the full width and height of the destination. This is the default if no other scaling mode is specified.
kICMScalingMode_Trim	The clean aperture of the source frames is scaled to cover the clean aperture of the destination, preserving the original display aspect ratio. If the display aspect ratios are different, the source frames are centered and cropped.
kICMSourceTracking_CopiedPixelBuffer	
kICMSourceTracking_FrameTimeWasChanged	
kICMSourceTracking_FrameWasDropped	
kICMSourceTracking_FrameWasEncoded	
kICMSourceTracking_FrameWasMerged	
kICMSourceTracking_LastCall	
kICMSourceTracking_ReleasedPixelBuffer	
kICMUnlimitedCPUTimeBudget	No CPU time limit on compression.
kICMUnlimitedFrameDelayCount	No limit on the number of frames in the compression window.
kICMUnlimitedFrameDelayTime	No time limit on the frames in the compression window.
kICMValidTime_DecodeDurationIsValid	
kICMValidTime_DecodeTimeStampIsValid	
kICMValidTime_DisplayDurationIsValid	The time value passed in displayDuration is valid.
kICMValidTime_DisplayOffsetIsValid	
kICMValidTime_DisplayTimeStampIsValid	The time value passed in displayTimeStamp is valid.
kQTPropertyClass_ICMCompressionFrameOptions	
kQTPropertyClass_ICMCompressionSession	Class identifier for compression session properties. Also 'icse'.
kQTPropertyClass_ICMCompressionSessionOptions	Class identifier for compression session option object properties. Also 'icso'.
kQTPropertyClass_ICMDecompressionFrameOptions	
kQTPropertyClass_ICMDecompressionSession	
kQTPropertyClass_ICMDecompressionSessionOptions	
kQTPropertyClass_ImageDescription	Class identifier for image description properties.
kQTVisualContextExpectedReadAheadKey	A CFNumberRef that defines the number of seconds ahead of real time that the client expects to pull images out of a visual context.
kQTVisualContextOutputColorSpaceKey	
kQTVisualContextPixelBufferAttributesKey	A CFDictionaryRef that defines the dictionary containing pixel buffer attributes. See kICMCompressionSessionPropertyID_-
PixelBufferPool in ICM Compression Session Properties.
kQTVisualContextTargetDimensionsKey	A CFDictionaryRef that defines the dictionary containing kQTVisualContextTargetDimensions_-
WidthKey and kQTVisualContextTargetDimensions_-
HeightKey values (see below).
kQTVisualContextTargetDimensions_HeightKey	A CFNumberRef that defines the height, in pixels, of the rendering target.
kQTVisualContextTargetDimensions_WidthKey	A CFNumberRef that defines the width, in pixels, of the rendering target.
kQTVisualContextTypeKey	
kQTVisualContextType_OpenGLTexture	The value of kQTVisualContextTypeKey for OpenGL texture visual contexts.
kQTVisualContextType_PixelBuffer	The value of kQTVisualContextTypeKey for pixel buffer visual contexts.
kQTVisualContextWorkingColorSpaceKey	

Movies.h

A variety of new functions in Movies.h support high-resolution audio, a new metadata format, a new sample table API, the ability to create movies from properties, and other features of QuickTime 7.
Functions

All of the new functions in this header file are listed alphabetically, with links to documentation and abstracts, if available.AddMediaSample2	Adds sample data and a description to a media.
AddMediaSampleFromEncodedFrame	Adds sample data and description from an encoded frame to a media.
AddSampleTableToMedia	Adds a sample table to a media.
CopyMediaMutableSampleTable	Obtains information about sample references in a media in the form of a sample table.
DisposeQTTrackPropertyListenerUPP	Disposes a track property listener UPP.
ExtendMediaDecodeDurationToDisplayEndTime	Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.
GetMediaAdvanceDecodeTime	Returns the advance decode time of a media.
GetMediaDataSizeTime64	Determines the size, in bytes, of the sample data in a media segment.
GetMediaDecodeDuration	Returns the decode duration of a media.
GetMediaDisplayDuration	Returns the display duration of a media.
GetMediaDisplayEndTime	Returns the display end time of a media.
GetMediaDisplayStartTime	Returns the display start time of a media.
GetMediaNextInterestingDecodeTime	Searches for decode times of interest in a media.
GetMediaNextInterestingDisplayTime	Searches for display times of interest in a media.
GetMediaSample2	Retrieves sample data from a media file.
GetMovieAudioBalance	Returns the balance value for the audio mix of a movie currently playing.
GetMovieAudioContext	Returns the current audio context for a movie.
GetMovieAudioFrequencyLevels	Returns the current frequency meter levels of a movie mix.
GetMovieAudioFrequencyMeteringBandFrequencies	Returns the chosen middle frequency for each band in the configured frequency metering of a particular movie mix.
GetMovieAudioFrequencyMeteringNumBands	Returns the number of frequency bands being metered for a movie's specified audio mix.
GetMovieAudioGain	Returns the gain value for the audio mix of a movie currently playing.
GetMovieAudioMute	Returns the mute value for the audio mix of a movie currently playing.
GetMovieAudioVolumeLevels	Returns the current volume meter levels of a movie.
GetMovieAudioVolumeMeteringEnabled	Returns the enabled or disabled status of volume metering of a particular audio mix of a movie.
GetMovieVisualBrightness	Returns the brightness adjustment for the movie.
GetMovieVisualContext	Returns the current visual context for a movie.
GetMovieVisualContrast	Returns the contrast adjustment for the movie.
GetMovieVisualHue	Returns the hue adjustment for the movie.
GetMovieVisualSaturation	Returns the color saturation adjustment for the movie.
GetTrackAudioGain	Returns the gain value for the audio mix of a track currently playing.
GetTrackAudioMute	Returns the mute value for the audio mix of a track currently playing.
GetTrackAudioVolumeLevels	
GetTrackAudioVolumeMeteringEnabled	
GetTrackEditRate64	Returns the rate of the track edit of a specified track at an indicated time.
InvokeQTTrackPropertyListenerUPP	Invokes the specified property listener of a track.
MediaContainsDisplayOffsets	Tests whether a media contains display offsets.
MediaDecodeTimeToSampleNum	Finds the sample for a specified decode time.
MediaDisplayTimeToSampleNum	Finds the sample number for a specified display time.
MovieAudioExtractionBegin	Begins a movie audio extraction session.
MovieAudioExtractionEnd	Ends a movie audio extraction session.
MovieAudioExtractionFillBuffer	Extracts audio from a movie.
MovieAudioExtractionGetProperty	Gets a property of a movie audio extraction session.
MovieAudioExtractionGetPropertyInfo	Gets information about a property of a movie audio extraction session.
MovieAudioExtractionSetProperty	Sets a property of a movie audio extraction session.
NewMovieFromProperties	Creates a new movie using movie properties.
NewQTTrackPropertyListenerUPP	Creates a new callback to monitor a track property.
QTAddTrackPropertyListener	Installs a callback to monitor a track property.
QTAudioContextCreateForAudioDevice	Creates a QTAudioContext object that encapsulates a connection to a CoreAudio output device.
QTAudioContextRelease	
QTAudioContextRetain	
QTCopyMediaMetaData	Retains a media's metadata object and returns it.
QTCopyMovieMetaData	Retains a movie's metadata object and returns it.
QTCopyTrackMetaData	Retains a track's metadata object and returns it.
QTGetTrackProperty	Returns the value of a specific track property.
QTGetTrackPropertyInfo	Returns information about the properties of a track.
QTMetaDataAddItem	Adds an inline metadata item to the metadata storage format.
QTMetaDataGetItemCountWithKey	
QTMetaDataGetItemProperty	Returns a property of a metadata item.
QTMetaDataGetItemPropertyInfo	Returns information about a property of a metadata item.
QTMetaDataGetItemValue	Returns the value of a metadata item from an item identifier.
QTMetaDataGetNextItem	Returns the next metadata item corresponding to a specified key.
QTMetaDataGetProperty	Returns a property of a metadata object.
QTMetaDataGetPropertyInfo	Returns information about a property of a metadata object.
QTMetaDataRelease	Decrements the retain count of a metadata object.
QTMetaDataRemoveItem	Removes a metadata item from a storage format.
QTMetaDataRemoveItemsWithKey	Removes metadata items with a specific key from the storage format.
QTMetaDataRetain	Increments the retain count of a metadata object.
QTMetaDataSetItem	Sets the value of the metadata item from the item identifier.
QTMetaDataSetItemProperty	Sets a property of a metadata item.
QTMetaDataSetProperty	Sets a property of a metadata object.
QTRemoveTrackPropertyListener	Removes a track property monitoring callback
QTSampleTableAddSampleDescription	Adds a sample description to a sample table, returning a sample description ID that can be used to refer to it.
QTSampleTableAddSampleReferences	Adds sample references to a sample table.
QTSampleTableCopySampleDescription	Retrieves a sample description from a sample table.
QTSampleTableCreateMutable	Creates a new, empty sample table.
QTSampleTableCreateMutableCopy	Copies a sample table.
QTSampleTableGetDataOffset	Returns the data offset of a sample.
QTSampleTableGetDataSizePerSample	Returns the data size of a sample.
QTSampleTableGetDecodeDuration	Returns the decode duration of a sample.
QTSampleTableGetDisplayOffset	Returns the offset from decode time to display time of a sample.
QTSampleTableGetNextAttributeChange	Finds the next sample number at which one or more of a set of given sample attributes change.
QTSampleTableGetNumberOfSamples	Returns the number of samples in a sample table.
QTSampleTableGetProperty	Returns the value of a specific sample table property.
QTSampleTableGetPropertyInfo	Returns information about the properties of a sample table.
QTSampleTableGetSampleDescriptionID	Returns the sample description ID of a sample.
QTSampleTableGetSampleFlags	Returns the media sample flags of a sample.
QTSampleTableGetTimeScale	Returns the timescale of a sample table.
QTSampleTableGetTypeID	Returns the CFTypeID value for the current sample table.
QTSampleTableRelease	Decrements the retain count of a sample table.
QTSampleTableReplaceRange	Replaces a range of samples in a sample table with a range of samples from another sample table.
QTSampleTableRetain	Increments the retain count of a sample table.
QTSampleTableSetProperty	Sets the value of a specific sample table property.
QTSampleTableSetTimeScale	Changes the timescale of a sample table.
QTSetTrackProperty	Sets the value of a specific track property.
QTSoundDescriptionConvert	Converts a sound description from one version to another.
QTSoundDescriptionCreate	Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.
QTSoundDescriptionGetProperty	Gets a particular property of a sound description.
QTSoundDescriptionGetPropertyInfo	Gets information about a particular property of a sound description.
QTSoundDescriptionSetProperty	Sets a particular property of a sound description.
SampleNumToMediaDecodeTime	Finds the decode time for a specified sample.
SampleNumToMediaDisplayTime	Finds the display time for a specified sample.
SetMovieAudioBalance	Sets the balance level for the mixed audio output of a movie.
SetMovieAudioContext	Targets a movie to render into an audio context.
SetMovieAudioFrequencyMeteringNumBands	Configures frequency metering for a particular audio mix in a movie.
SetMovieAudioGain	Sets the audio gain level for the mixed audio output of a movie, altering the perceived volume of the movie's playback.
SetMovieAudioMute	Sets the mute value for the audio mix of a movie currently playing.
SetMovieAudioVolumeMeteringEnabled	Enables or disables volume metering of a particular audio mix of a movie.
SetMovieVisualBrightness	Sets the brightness adjustment for the movie.
SetMovieVisualContext	Targets a movie to render into a visual context.
SetMovieVisualContrast	Sets the contrast adjustment for the movie.
SetMovieVisualHue	Sets the hue adjustment for the movie.
SetMovieVisualSaturation	Sets the color saturation adjustment for the movie.
SetTrackAudioGain	Sets the audio gain level for the audio output of a track, altering the perceived volume of the track's playback.
SetTrackAudioMute	Mutes or unmutes the audio output of a track.
SetTrackAudioVolumeMeteringEnabled	
TrackTimeToMediaDisplayTime	Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.*/
extern const CFStringRef kQTVisualContextOutputColorSpaceKey;
extern const CFStringRef  kQTVisualContextTargetDimensions_WidthKey;	//A CFNumberRef that defines the width, in pixels, of the rendering target.
extern const CFStringRef kQTVisualContextTargetDimensions_HeightKey;	//A CFNumberRef that defines the height, in pixels, of the rendering target.
extern const CFStringRef kQTVisualContextTargetDimensionsKey; //	A CFDictionaryRef that defines the dictionary containing kQTVisualContextTargetDimensions_-
extern const CFStringRef kQTVisualContextPixelBufferAttributesKey; //	A CFDictionaryRef that defines the dictionary containing pixel buffer attributes. See kICMCompressionSessionPropertyID_-
extern const CFStringRef kQTVisualContextWorkingColorSpaceKey;	








/*Film Noise Filter

kFilmNoiseImageFilterType ('fmns')

The film noise filter alters a single source, simulating some of the effects that are seen on aged film stock. This effect can be used to transform a video source into one that looks like it was shot on film that has suffered the effects of age and mishandling.

The specific features, which can be controlled independently, are:
Hairs. These are a simulation of hairs lying on the surface of the film. Each hair is randomly generated, and is colored in a randomly chosen shade of light grey.
Scratches. These are vertical or near-vertical one-pixel lines drawn onto the destination image that simulate scratches in the film. Each scratch lasts for a pre-calculated length of time. During its lifespan the scratch’s position is randomly perturbed. Shortly before the scratch is removed, it will begin to shorten. The color of the scratches is a randomly chosen shade of light grey.
Dust. These simulate dust particles on the surface of the film. Dust particles are drawn using the same algorithm that generates the hairs, but the particles are more tightly curled, and drawn in a darker shade of grey.
Film fade. This simulates an overall change in the color of the film stock. Every pixel of the source image is passed through the film fade algorithm, so this can be processor-intensive.

The film noise effect takes a single source and has eight parameters.

Use the descriptions below to help you understand what the parameters do. To learn how to use parameter atoms, see “Adding Video Effects to a QuickTime Movie.”
Name	
Code	
QTAtom Type	
Description

Hair density	
'hden'	
kParameterTypeDataLong	
This parameter controls the number of hairs that are drawn on each frame and the frequency with which hairs appear. The maximum number of hairs per frame is a randomly generated number between 1 and the value of this parameter. The chance of each hair appearing on a single frame is 1 in (the value of this parameter).

Hair length	
'hlen'	
kParameterTypeDataLong	
The maximum length (in pixels) of the hairs being drawn.

Scratch density	
'sden'	
kParameterTypeDataLong	
This parameter controls the number of scratches that are drawn on each frame and the frequency with which scratches appear. The maximum number of scratches per frame is a randomly generated number between 1 and the value of this parameter. The chance of each scratch appearing on a single frame is 1 in (the value of this parameter).

Scratch duration	
'sdur'	
kParameterTypeDataLong	
The maximum number of frames that each scratch appears for. The actual number of frames for each scratch is a randomly chosen value between 1 and this value plus 20.

Scratch width	
'swid'	
kParameterTypeDataLong	
The maximum width, in pixels, of a scratch. The actual width is a randomly chosen number between 1 and this value.

Dust density	
'dden'	
kParameterTypeDataLong	
This parameter controls the number of dust particles that are drawn on each frame and the frequency with which dust particles appear. The maximum number of dust particles per frame is a randomly generated number between 1 and the value of this parameter. The chance of each dust particle appearing on a single frame is 1 in (the value of this parameter).

Dust size	
'dsiz'	
kParameterTypeDataLong	
For each dust particle, the length in pixels is a random number between 1 and 5, plus the value of the Dust Size parameter.

Film fade	
'fade'	
kParameterTypeDataEnum	
The type of film fade effect (if any) to apply. See list below.*/
enum {
  kFilmNoiseImageFilterType     = 'fmns',
};

/*SMPTE Wipe Effects

kWipeTransitionType ('smpt')

This effect is an implementation of the 34 wipes from ANSI/SMPTE 258M-1993, plus two Apple-defined wipes that choose a random effect. These are a series of masking or “reveal” type wipes that take place between two sources. For full definitions of these 34 wipes and what they look like, refer to the SMPTE documentation.

The SMPTE wipe effects take two sources and seven parameters.

Use the descriptions below to help you understand what the parameters do. To learn how to use parameter atoms, see “Adding Video Effects to a QuickTime Movie.”
Name	
Code	
QTAtom Type	
Description

Percentage	
'pcnt'	
kParameterTypeDataFixed; Always a tween	
This parameter contains a tween. As the effect progresses, QuickTime renders the frame of the effect indicated by the tween's current value, as a percentage of the whole effect. For example, if the tween goes from 0 to 100, the effect renders completely; if the tween goes from 25 to 75, rendering begins 25% into the effect and terminates 75% through the effect.

Wipe ID	
'wpID'	
kParameterTypeDataEnum	
The SMPTE ID for the effect. By setting this parameter, you control which of the 47 available wipes is used. See the enumeration list below.

Soft border	
'soft'	
kParameterTypeDataBitField	
If this parameter contains true, the border drawn around the second source is blurred.

Border width	
'widt'	
kParameterTypeDataFixed; Can be a tween	
The width, in pixels, of a border that is drawn around the second source.

Border color	
'bclr'	
kParameterTypeDataRGBValue; Can be a tween	
The RGB color of the border around the second source.

Horizontal repeat	
'hori'	
kParameterTypeDataLong; Can be a tween	
The number of horizontal repeats of the effect that are executed in a single source.

Vertical repeat	
'vert'	
kParameterTypeDataLong; Can be a tween	
The number of vertical repeats of the effect that are executed in a single source.


The Wipe ID parameter can take the following values:
Value	
Description

1	
Slide horizontal

2	
Slide vertical

3	
Top left

4	
Top right

5	
Bottom right

6	
Bottom left

7	
Four corner

8	
Four box

21	
Barn vertical

22	
Barn horizontal

23	
Top center

24	
Right center

25	
Bottom center

26	
Left center
SMPTE Wipe Effects

kWipeTransitionType ('smpt')

This effect is an implementation of the 34 wipes from ANSI/SMPTE 258M-1993, plus two Apple-defined wipes that choose a random effect. These are a series of masking or “reveal” type wipes that take place between two sources. For full definitions of these 34 wipes and what they look like, refer to the SMPTE documentation.

The SMPTE wipe effects take two sources and seven parameters.

Use the descriptions below to help you understand what the parameters do. To learn how to use parameter atoms, see “Adding Video Effects to a QuickTime Movie.”
Name	
Code	
QTAtom Type	
Description

Percentage	
'pcnt'	
kParameterTypeDataFixed; Always a tween	
This parameter contains a tween. As the effect progresses, QuickTime renders the frame of the effect indicated by the tween's current value, as a percentage of the whole effect. For example, if the tween goes from 0 to 100, the effect renders completely; if the tween goes from 25 to 75, rendering begins 25% into the effect and terminates 75% through the effect.

Wipe ID	
'wpID'	
kParameterTypeDataEnum	
The SMPTE ID for the effect. By setting this parameter, you control which of the 47 available wipes is used. See the enumeration list below.

Soft border	
'soft'	
kParameterTypeDataBitField	
If this parameter contains true, the border drawn around the second source is blurred.

Border width	
'widt'	
kParameterTypeDataFixed; Can be a tween	
The width, in pixels, of a border that is drawn around the second source.

Border color	
'bclr'	
kParameterTypeDataRGBValue; Can be a tween	
The RGB color of the border around the second source.

Horizontal repeat	
'hori'	
kParameterTypeDataLong; Can be a tween	
The number of horizontal repeats of the effect that are executed in a single source.

Vertical repeat	
'vert'	
kParameterTypeDataLong; Can be a tween	
The number of vertical repeats of the effect that are executed in a single source.


The Wipe ID parameter can take the following values:
Value	
Description

1	
Slide horizontal

2	
Slide vertical

3	
Top left

4	
Top right

5	
Bottom right

6	
Bottom left

7	
Four corner

8	
Four box

21	
Barn vertical

22	
Barn horizontal

23	
Top center

24	
Right center

25	
Bottom center

26	
Left center

41	
Diagonal left down

42	
Diagonal right down

43	
Vertical bow tie

44	
Horizontal bow tie

45	
Diagonal left out

46	
Diagonal right out

47	
Diagonal cross

48	
Diagonal box

61	
Filled V

62	
Filled V right

63	
Filled V bottom

64	
Filled V left

65	
Hollow V

66	
Hollow V right

67	
Hollow V bottom

68	
Hollow V left

71	
Vertical zig zag

72	
Horizontal zig zag

73	
Vertical barn zig zag

74	
Horizontal barn zig zag

409	
Random effect (One of the 133 SMPTE effects is chosen at random)

501	
Random wipe (One of the 34 SMPTE wipe effects is chosen at random)
41	
Diagonal left down

42	
Diagonal right down

43	
Vertical bow tie

44	
Horizontal bow tie

45	
Diagonal left out

46	
Diagonal right out

47	
Diagonal cross

48	
Diagonal box

61	
Filled V

62	
Filled V right

63	
Filled V bottom

64	
Filled V left

65	
Hollow V

66	
Hollow V right

67	
Hollow V bottom

68	
Hollow V left

71	
Vertical zig zag

72	
Horizontal zig zag

73	
Vertical barn zig zag

74	
Horizontal barn zig zag

409	
Random effect (One of the 133 SMPTE effects is chosen at random)

501	
Random wipe (One of the 34 SMPTE wipe effects is chosen at random)*/
enum {
  kWipeTransitionType           = 'smpt',
};


/*Slide

kSlideTransitionType ('slid')

In a slide effect, source B slides onto the screen to cover source A. The angle from which source B enters the frame is stored in a parameter, with 0 degrees being the top of the screen.

The slide effect takes a maximum of two sources and has two parameters.

Use the descriptions below to help you understand what the parameters do. To learn how to use parameter atoms, see “Adding Video Effects to a QuickTime Movie.”
Name	
Code	
QTAtom Type	
Description

Percentage	
'pcnt'	
kParameterTypeDataFixed Always a tween	
This parameter contains a tween. As the effect progresses, QuickTime renders the frame of the effect indicated by the tween's current value, as a percentage of the whole effect. For example, if the tween goes from 0 to 100, the effect renders completely; if the tween goes from 25 to 75, rendering begins 25% into the effect and terminates 75% through the effect.

Slide angle	
'angl'	
kParameterTypeDataFixed Can be a tween	
The angle from which source B will enter the frame. This value is expressed in degrees, with 0 degrees defined as the top of the screen.*/
enum {
  kSlideTransitionType          = 'slid',
};

/*Example: Cross Fade

kCrossFadeTransitionType ('dslv')

A “cross fade” or “dissolve” provides a smooth alpha blending between two video sources, changing over time to give a smooth fade out from the first source into the second.

This effect takes a maximum of two sources and has a single parameter.

Use the description below to help you understand what the parameter does. To learn how to use parameter atoms, see “Adding Video Effects to a QuickTime Movie.”
Name	
Code	
QTAtom Type	
Description

Percentage	
'pcnt'	
kParameterTypeDataFixed; Always a tween	
This parameter contains a tween. As the effect progresses, QuickTime renders the frame of the effect indicated by the tween's current value as a percentage of the whole effect. For example, if the tween goes from 0 to 100, the effect renders completely; if the tween goes from 25 to 75, rendering begins 25% into the effect and terminates 75% through the effect.*/
enum {
  kCrossFadeTransitionType      = 'dslv',
};

/*Explode

kExplodeTransitionType ('xplo')

In an explode effect, source B grows from a single point, expanding out until it entirely covers source A. The center point of the explosion is defined in the effect parameters.

This effect takes a maximum of two sources, and has three parameters.

Use the descriptions below to help you understand what the parameters do. To learn how to use parameter atoms, see “Adding Video Effects to a QuickTime Movie.”
Name	
Code	
QTAtom Type	
Description

Percentage	
'pcnt'	
kParameterTypeDataFixed; Always a tween	
This parameter contains a tween. As the effect progresses, QuickTime renders the frame of the effect indicated by the tween's current value, as a percentage of the whole effect. For  example, if the tween goes from 0 to 100, the effect renders completely; if the tween goes from 25 to 75, rendering begins 25% into the effect and terminates 75% through the effect.

Explode centre X	
'xcnt'	
kParameterTypeDataFixed; Can be a tween	
The x-coordinate of the explosion centre.

Explode centre Y	
'ycnt'	
kParameterTypeDataFixed; Can be a tween	
The y-coordinate of the explosion centre.*/

enum {
kExplodeTransitionType ='xplo'
};

/*ICMPixelFormatInfo

Defines a pixel format.

struct ICMPixelFormatInfo {
   long             size;
   unsigned long    formatFlags;
   short            bitsPerPixel[14];
};
Fields
size
Discussion

The size of this structure. This quantity isn't necessarily equal to sizeof(ICMPixelFormatInfo) because it is dependent on whether the pixel format is chunky or planar, and, if planar, the number of components (see below).
formatFlags
Discussion

A constant (see below) indicating the pixel format. See these constants: 
kICMPixelFormatIsPlanarMask
kICMPixelFormatIsIndexed
kICMPixelFormatIsSupportedByQD
bitsPerPixel
Discussion

An array that defines the number of bits for each component. The element bitsPerPixel[0] contains the number of bits for the first component, bitsPerPixel[1] the number of bits for the second component, etc. The meaning of this parameter depends on the format flag (see below).
Discussion

You can represent a format that has from 1 to 14 discrete components using this data structure. For ARGB, there are 4 components. RGB without an alpha channel has 3 components. A component count of 15 is reserved for future expansion.
Related Functions
ICMGetPixelFormatInfo
ICMSetPixelFormatInfo 
Declared In
ImageCompression.h*/

struct ICMPixelFormatInfo {
   long             size;
   unsigned long    formatFlags;
   short            bitsPerPixel[14];
};
typedef struct  ICMPixelFormatInfo ICMPixelFormatInfo;




/*DSequence Flags

Constants that represent <codeVoice>DSequence</codeVoice> flags.

enum {
   codecDSequenceDisableOverlaySurface = (1L << 5),
   codecDSequenceSingleField     = (1L << 6),
   codecDSequenceBidirectionalPrediction = (1L << 7),
   codecDSequenceFlushInsteadOfDirtying = (1L << 8),
   codecDSequenceEnableSubPixelPositioning = (1L << 9),
   codecDSequenceDeinterlaceFields = (1L << 10)
};
Declared In
ImageCompression.h*/
enum {
   codecDSequenceDisableOverlaySurface = (1L << 5),
   codecDSequenceSingleField     = (1L << 6),
   codecDSequenceBidirectionalPrediction = (1L << 7),
   codecDSequenceFlushInsteadOfDirtying = (1L << 8),
   codecDSequenceEnableSubPixelPositioning = (1L << 9),
   codecDSequenceDeinterlaceFields = (1L << 10)
};

/*Color Modes

Constants that represent color modes.

enum {
   defaultDither                 = 0,
   forceDither                   = 1,
   suppressDither                = 2,
   useColorMatching              = 4
};
enum {
   graphicsModeStraightAlpha     = 256,
   graphicsModePreWhiteAlpha     = 257,
   graphicsModePreBlackAlpha     = 258,
   graphicsModeComposition       = 259,
   graphicsModeStraightAlphaBlend = 260,
   graphicsModePreMulColorAlpha  = 261,
   graphicsModePerComponentAlpha = 272
};
enum {
   kQTTIFFUserDataPrefix         = 0x74690000,
   / Added to some tag values in TIFF IFDs to generate user data codes.  (0x7469 is 'ti'.) /
   / For example,
   YCbCrPositioning is tag x0213,
   so its user data code is 0x74690213. /
   kQTTIFFExifUserDataPrefix     = 0x65780000,
   / Added to tag values in Exif IFDs to generate user data codes.  (0x6578 is 'ex'.) /
   / For example,
   DateTimeOriginal is tag x9003,
   so its user data code is 0x65789003. /
   kQTTIFFExifGPSUserDataPrefix  = 0x67700000,
   / Added to tag values in Exif GPS IFDs to generate user data codes.  (0x6770 is 'gp'.) /
   / For example,
   GPSAltitude is tag x0006,
   so its user data code is 0x6770006. /
   kQTAlphaMode                  = 'almo',
   / UInt32; eg,
   graphicsModeStraightAlpha or graphicsModePreBlackAlpha /
   kQTAlphaModePreMulColor       = 'almp',
   / RGBColor; used if kQTAlphaMode is graphicsModePreMulColorAlpha /
   kUserDataIPTC                 = 'iptc'
};
Constants
kQTTIFFUserDataPrefix

Added to some tag values in TIFF IFDs to generate user data codes. (0x7469 is 'ti'.). 

Available in Mac OS X v10.1 and later.
kQTTIFFExifUserDataPrefix

Added to tag values in Exif IFDs to generate user data codes. (0x6578 is 'ex'.). 

Available in Mac OS X v10.1 and later.
kQTTIFFExifGPSUserDataPrefix

Added to tag values in Exif GPS IFDs to generate user data codes. (0x6770 is 'gp'.). 

Available in Mac OS X v10.1 and later.
kQTAlphaMode

UInt32; for example, graphicsModeStraightAlpha or graphicsModePreBlackAlpha. 

Available in Mac OS X v10.1 and later.
kQTAlphaModePreMulColor

RGBColor; used if kQTAlphaMode is graphicsModePreMulColorAlpha. 

Available in Mac OS X v10.1 and later.
Declared In
ImageCompression.h*/
enum {
   defaultDither                 = 0,
   forceDither                   = 1,
   suppressDither                = 2,
   useColorMatching              = 4
};
enum {
   graphicsModeStraightAlpha     = 256,
   graphicsModePreWhiteAlpha     = 257,
   graphicsModePreBlackAlpha     = 258,
   graphicsModeComposition       = 259,
   graphicsModeStraightAlphaBlend = 260,
   graphicsModePreMulColorAlpha  = 261,
   graphicsModePerComponentAlpha = 272
};
enum {
   kQTTIFFUserDataPrefix         = 0x74690000,
   /* Added to some tag values in TIFF IFDs to generate user data codes.  (0x7469 is 'ti'.) */
   /* For example,
   YCbCrPositioning is tag x0213,
   so its user data code is 0x74690213. */
   kQTTIFFExifUserDataPrefix     = 0x65780000,
   /* Added to tag values in Exif IFDs to generate user data codes.  (0x6578 is 'ex'.) */
   /* For example,
   DateTimeOriginal is tag x9003,
   so its user data code is 0x65789003. */
   kQTTIFFExifGPSUserDataPrefix  = 0x67700000,
   /* Added to tag values in Exif GPS IFDs to generate user data codes.  (0x6770 is 'gp'.) */
   /* For example,
   GPSAltitude is tag x0006,
   so its user data code is 0x6770006. */
   kQTAlphaMode                  = 'almo',
   /* UInt32; eg,
   graphicsModeStraightAlpha or graphicsModePreBlackAlpha */
   kQTAlphaModePreMulColor       = 'almp',
   /* RGBColor; used if kQTAlphaMode is graphicsModePreMulColorAlpha */
   kUserDataIPTC                 = 'iptc'
};


/*OpenCPicParams

Specifies resolutions when creating images.

struct OpenCPicParams {
   Rect     srcRect;
   Fixed    hRes;
   Fixed    vRes;
   short    version;
   short    reserved1;
   long     reserved2;
};
Fields
srcRect
Discussion

The optimal bounding rectangle for the resolution indicated by the hRes and vRes fields. To display a picture at a resolution other than that specified in the the hRes and vRes fields, your application should compute an appropriate destination rectangle by scaling the image's width and height by the destination resolution divided by the source resolution.
hRes
Discussion

The best horizontal resolution for the picture. A value of 0x0048000 specifies a horizontal resolution of 72 dpi.
vRes
Discussion

The best vertical resolution for the picture. A value of 0x0048000 specifies a vertical resolution of 72 dpi.
version
Discussion

Always set this field to -2.
reserved1
Discussion

Reserved; set to 0.
reserved2
Discussion

Reserved; set to 0.
Related Functions
GetPictureFileHeader 
Declared In
ImageCompression.h*/
//struct OpenCPicParams {
   //Rect     srcRect;
   //Fixed    hRes;
   //Fixed    vRes;
   //short    version;
   //short    reserved1;
   //long     reserved2;
//};
//typedef struct OpenCPicParams OpenCPicParams;
//defined QuickDraw.h

/*ICMProgressProc Values

Constants passed to ICMProgressProc.

enum {
   codecProgressOpen             = 0,
   codecProgressUpdatePercent    = 1,
   codecProgressClose            = 2
};
Constants
codecProgressOpen

Indicates the start of a long operation. This is always the first message sent to your function. Your function can use this message to trigger the display of your progress window. 

Available in Mac OS X v10.0 and later.
codecProgressUpdatePercent

Passes completion information to your function. The Image Compression Manager repeatedly sends this message to your function. The completeness parameter indicates the relative completion of the operation. You can use this value to update your progress window. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
enum {
   codecProgressOpen             = 0,
   codecProgressUpdatePercent    = 1,
   codecProgressClose            = 2
};


/*FCompressImage Values

Constants passed to FCompressImage.

enum {
   codecFlagUseImageBuffer       = (1L << 0),
   * decompress*
   codecFlagUseScreenBuffer      = (1L << 1),
   * decompress*
   codecFlagUpdatePrevious       = (1L << 2),
   / compress*
   codecFlagNoScreenUpdate       = (1L << 3),
   / decompress*
   codecFlagWasCompressed        = (1L << 4),
   * compress*
   codecFlagDontOffscreen        = (1L << 5),
   * decompress*
   codecFlagUpdatePreviousComp   = (1L << 6),
   * compress*
   codecFlagForceKeyFrame        = (1L << 7),
   * compress*
   codecFlagOnlyScreenUpdate     = (1L << 8),
   * decompress*
   codecFlagLiveGrab             = (1L << 9),
   * compress*
   codecFlagDiffFrame            = (1L << 9),
   * decompress*
   codecFlagDontUseNewImageBuffer = (1L << 10),
   * decompress*
   codecFlagInterlaceUpdate      = (1L << 11),
   * decompress*
   codecFlagCatchUpDiff          = (1L << 12),
   * decompress*
   codecFlagSupportDisable       = (1L << 13),
   * decompress*
   codecFlagReenable             = (1L << 14)  decompress*
};
Constants
codecFlagUpdatePrevious

Controls whether your compressor updates the previous image during compression. This flag is only used with sequences that are being temporally compressed. If this flag is set to 1, your compressor should copy the current frame into the previous frame buffer at the end of the frame-compression sequence. Use the source image. 

Available in Mac OS X v10.0 and later.
codecFlagWasCompressed

Indicates to your compressor that the image to be compressed has been compressed before. This information may be useful to compressors that can compensate for the image degradation that may otherwise result from repeated compression and decompression of the same image. This flag is set to 1 to indicate that the image was previously compressed. This flag is set to 0 if the image was not previously compressed. 

Available in Mac OS X v10.0 and later.
codecFlagUpdatePreviousComp

Controls whether your compressor updates the previous image buffer with the compressed image. This flag is only used with temporal compression. If this flag is set to 1, your compressor should update the previous frame buffer at the end of the frame-compression sequence, allowing your compressor to perform frame differencing against the compression results. Use the image that results from the compression operation. If this flag is set to 0, your compressor should not modify the previous frame buffer during compression. 

Available in Mac OS X v10.0 and later.
codecFlagLiveGrab

Indicates whether the current sequence results from grabbing live video. When working with live video, your compressor should operate as quickly as possible and disable any additional processing, such as compensation for previously compressed data. This flag is set to 1 when you are compressing from a live video source. 

Available in Mac OS X v10.0 and later.
codecFlagDiffFrame

Decompress. 

Available in Mac OS X v10.0 and later.
codecFlagSupportDisable

Decompress. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
enum {
   codecFlagUseImageBuffer       = (1L << 0),
   /* decompress*/
   codecFlagUseScreenBuffer      = (1L << 1),
   /* decompress*/
   codecFlagUpdatePrevious       = (1L << 2),
   /* compress*/
   codecFlagNoScreenUpdate       = (1L << 3),
   /* decompress*/
   codecFlagWasCompressed        = (1L << 4),
   /* compress*/
   codecFlagDontOffscreen        = (1L << 5),
   /* decompress*/
   codecFlagUpdatePreviousComp   = (1L << 6),
   /* compress*/
   codecFlagForceKeyFrame        = (1L << 7),
   /* compress*/
   codecFlagOnlyScreenUpdate     = (1L << 8),
   /* decompress*/
   codecFlagLiveGrab             = (1L << 9),
   /* compress*/
   codecFlagDiffFrame            = (1L << 9),
   /* decompress*/
   codecFlagDontUseNewImageBuffer = (1L << 10),
   /* decompress*/
   codecFlagInterlaceUpdate      = (1L << 11),
   /* decompress*/
   codecFlagCatchUpDiff          = (1L << 12),
   /* decompress*/
   codecFlagSupportDisable       = (1L << 13),
   /* decompress*/
   codecFlagReenable             = (1L << 14) /* decompress*/
};

/*ImageSequenceDataSource

Represents a type used by the Compression and Decompression API.

typedef long ImageSequenceDataSource;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef long ImageSequenceDataSource;


/*CodecInfo Values

Constants passed to CodecInfo.

enum {
   codecInfoDepth1               = (1L << 0),
   /* compressed data at 1 bpp depth available *
   codecInfoDepth2               = (1L << 1),
   /* compressed data at 2 bpp depth available *
   codecInfoDepth4               = (1L << 2),
   /* compressed data at 4 bpp depth available *
   codecInfoDepth8               = (1L << 3),
   /* compressed data at 8 bpp depth available *
   codecInfoDepth16              = (1L << 4),
   /* compressed data at 16 bpp depth available *
   codecInfoDepth32              = (1L << 5),
   /* compressed data at 32 bpp depth available *
   codecInfoDepth24              = (1L << 6),
   /* compressed data at 24 bpp depth available *
   codecInfoDepth33              = (1L << 7),
   /* compressed data at 1 bpp monochrome depth  available *
   codecInfoDepth34              = (1L << 8),
   /* compressed data at 2 bpp grayscale depth available *
   codecInfoDepth36              = (1L << 9),
   /* compressed data at 4 bpp grayscale depth available *
   codecInfoDepth40              = (1L << 10),
   /* compressed data at 8 bpp grayscale depth available *
   codecInfoStoresClut           = (1L << 11),
   /* compressed data can have custom cluts *
   codecInfoDoesLossless         = (1L << 12),
   /* compressed data can be stored in lossless format *
   codecInfoSequenceSensitive    = (1L << 13) /* compressed data is sensitive to out of sequence decoding *
};
Constants
codecInfoDepth1

Compressed data available at 1 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth2

Compressed data available at 2 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth4

Compressed data available at 4 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth8

Compressed data available at 8 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth16

Compressed data available at 16 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth32

Compressed data available at 32 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth24

Compressed data available at 24 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth33

Compressed data available at 1 bit-per-pixel monochrome depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth34

Compressed data available at 2 bit-per-pixel grayscale depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth36

Compressed data available at 4 bit-per-pixel grayscale depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth40

Compressed data available at 8 bit-per-pixel grayscale depth. 

Available in Mac OS X v10.0 and later.
codecInfoStoresClut

Compressed data can have custom color lookup tables. 

Available in Mac OS X v10.0 and later.
codecInfoDoesLossless

Compressed data can be stored in lossless format. 

Available in Mac OS X v10.0 and later.*/

enum {
   codecInfoDepth1               = (1L << 0),
   /* compressed data at 1 bpp depth available */
   codecInfoDepth2               = (1L << 1),
   /* compressed data at 2 bpp depth available */
   codecInfoDepth4               = (1L << 2),
   /* compressed data at 4 bpp depth available */
   codecInfoDepth8               = (1L << 3),
   /* compressed data at 8 bpp depth available */
   codecInfoDepth16              = (1L << 4),
   /* compressed data at 16 bpp depth available */
   codecInfoDepth32              = (1L << 5),
   /* compressed data at 32 bpp depth available */
   codecInfoDepth24              = (1L << 6),
   /* compressed data at 24 bpp depth available */
   codecInfoDepth33              = (1L << 7),
   /* compressed data at 1 bpp monochrome depth  available */
   codecInfoDepth34              = (1L << 8),
   /* compressed data at 2 bpp grayscale depth available */
   codecInfoDepth36              = (1L << 9),
   /* compressed data at 4 bpp grayscale depth available */
   codecInfoDepth40              = (1L << 10),
   /* compressed data at 8 bpp grayscale depth available */
   codecInfoStoresClut           = (1L << 11),
   /* compressed data can have custom cluts */
   codecInfoDoesLossless         = (1L << 12),
   /* compressed data can be stored in lossless format */
   codecInfoSequenceSensitive    = (1L << 13) /* compressed data is sensitive to out of sequence decoding */
};


/*Graphics Importer Component Type

Graphics importer components have this component type:enum {
    GraphicsImporterComponentType = 'grip'
};*/

enum {
    GraphicsImporterComponentType = 'grip'
};



/*CodecComponent

Represents a type used by the Compression and Decompression API.

typedef Component CodecComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef Component CodecComponent;

/*CodecType

Abst_CodecType

typedef OSType CodecType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType CodecType;

/*CMValidTime_DecodeDurationIsValid

Constants grouped with kICMValidTime_DecodeDurationIsValid.

enum {
   /
   * Indicates that a display time stamp is valid.
   *
   kICMValidTime_DisplayTimeStampIsValid = 1L << 0,
   /
   * Indicates that a display duration is valid.
   *
   kICMValidTime_DisplayDurationIsValid = 1L << 1,
   /
   * Indicates that a decode time stamp is valid.
   *
   kICMValidTime_DecodeTimeStampIsValid = 1L << 2,
   /
   * Indicates that a decode duration is valid.
   *
   kICMValidTime_DecodeDurationIsValid = 1L << 3,
   /
   * Indicates that a display offset (the offset from a decode time
   * stamp to a display time stamp) is valid.
   *
   kICMValidTime_DisplayOffsetIsValid = 1L << 4
};
Constants
kICMValidTime_DisplayTimeStampIsValid

The time value passed in displayTimeStamp is valid. 

Available in Mac OS X v10.3 and later.
kICMValidTime_DisplayDurationIsValid

The time value passed in displayDuration is valid. 

Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
enum {
   /*
   * Indicates that a display time stamp is valid.
   */
   kICMValidTime_DisplayTimeStampIsValid = 1L << 0,
   /*
   * Indicates that a display duration is valid.
   */
   kICMValidTime_DisplayDurationIsValid = 1L << 1,
   /*
   * Indicates that a decode time stamp is valid.
   */
   kICMValidTime_DecodeTimeStampIsValid = 1L << 2,
   /*
   * Indicates that a decode duration is valid.
   */
   kICMValidTime_DecodeDurationIsValid = 1L << 3,
   /*
   * Indicates that a display offset (the offset from a decode time
   * stamp to a display time stamp) is valid.
   */
   kICMValidTime_DisplayOffsetIsValid = 1L << 4
};
/*MEncodedFrameSetFrameType Values

Constants passed to ICMEncodedFrameSetFrameType.

enum {
   kICMFrameType_I               = 'I',
   kICMFrameType_P               = 'P',
   kICMFrameType_B               = 'B',
   kICMFrameType_Unknown         = 0
};
Declared In
ImageCompression.h*/

enum {
   kICMFrameType_I               = 'I',
   kICMFrameType_P               = 'P',
   kICMFrameType_B               = 'B',
   kICMFrameType_Unknown         = 0
};


/*QTSetPixMapPtrRequestedGammaLevel Values

Constants passed to QTSetPixMapPtrRequestedGammaLevel.

enum {
   kQTUsePlatformDefaultGammaLevel = 0,
   / When decompressing into this PixMap,
   gamma-correct to the platform's standard gamma. *
   kQTUseSourceGammaLevel        = -1L,
   / When decompressing into this PixMap,
   don't perform gamma-correction. 
   kQTCCIR601VideoGammaLevel     = 0x00023333 / 2.2,
   standard television video gamma.
};
Constants
kQTCCIR601VideoGammaLevel

Gamma 2.2, for ITU-R BT.601 based video. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
enum {
   kQTUsePlatformDefaultGammaLevel = 0,
   /* When decompressing into this PixMap,
   gamma-correct to the platform's standard gamma. */
   kQTUseSourceGammaLevel        = -1L,
   /* When decompressing into this PixMap,
   don't perform gamma-correction. */
   kQTCCIR601VideoGammaLevel     = 0x00023333 /* 2.2,
   standard television video gamma.*/
};
/*Graphics Importer Flags

Constants that represent the flags of graphics importers.

enum {
   graphicsImporterIsBaseImporter = 1L << 0,
   graphicsImporterCanValidateFile = 1L << 9,
   graphicsImporterSubTypeIsFileExtension = 1L << 12,
   graphicsImporterHasMIMEList   = 1L << 14,
   graphicsImporterUsesImageDecompressor = 1L << 23
};
enum {
   kGraphicsImporterDontDoGammaCorrection = 1L << 0,
   kGraphicsImporterTrustResolutionFromFile = 1L << 1,
   kGraphicsImporterEnableSubPixelPositioning = 1L << 2,
   kGraphicsImporterDontUseColorMatching = 1L << 3 /set this flag (*before* calling GraphicsImportGetColorSyncProfile) if you do matching yourself 
};
Declared In
ImageCompression.h*/
enum {
   graphicsImporterIsBaseImporter = 1L << 0,
   graphicsImporterCanValidateFile = 1L << 9,
   graphicsImporterSubTypeIsFileExtension = 1L << 12,
   graphicsImporterHasMIMEList   = 1L << 14,
   graphicsImporterUsesImageDecompressor = 1L << 23
};
enum {
   kGraphicsImporterDontDoGammaCorrection = 1L << 0,
   kGraphicsImporterTrustResolutionFromFile = 1L << 1,
   kGraphicsImporterEnableSubPixelPositioning = 1L << 2,
   kGraphicsImporterDontUseColorMatching = 1L << 3 /* set this flag (*before* calling GraphicsImportGetColorSyncProfile) if you do matching yourself */
};


/*Codec Flags

Constants that represent codec flags.

enum {
   codecCompletionSource         = (1 << 0),
   // asynchronous codec is done with source data 
   codecCompletionDest           = (1 << 1),
   // asynchronous codec is done with destination data 
   codecCompletionDontUnshield   = (1 << 2),
   // on dest complete don't unshield cursor *
   codecCompletionWentOffscreen  = (1 << 3),
   / codec used offscreen buffer *
   codecCompletionUnlockBits     = (1 << 4),
   / on dest complete,
   call ICMSequenceUnlockBits *
   codecCompletionForceChainFlush = (1 << 5),
   / ICM needs to flush the whole chain *
   codecCompletionDropped        = (1 << 6),
   / codec decided to drop this frame *
   codecCompletionDecoded        = (1 << 10),
   / codec has decoded this frame; if it is cancelled and rescheduled,
   set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags *
   codecCompletionNotDisplayable = (1 << 11),
   / the frame may still be scheduled for decode,
   but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames. *
   codecCompletionNotDrawn       = (1 << 12) / set in conjunction with codecCompletionDest to indicate that the frame was not drawn *
};
enum {
   codecFlagOutUpdateOnNextIdle  = (1L << 9),
   codecFlagOutUpdateOnDataSourceChange = (1L << 10),
   codecFlagSequenceSensitive    = (1L << 11),
   codecFlagOutUpdateOnTimeChange = (1L << 12),
   codecFlagImageBufferNotSourceImage = (1L << 13),
   codecFlagUsedNewImageBuffer   = (1L << 14),
   codecFlagUsedImageBuffer      = (1L << 15)
};
enum {
   codecInfoDoes1                = (1L << 0),
   /* codec can work with 1-bit pixels *
   codecInfoDoes2                = (1L << 1),
   /* codec can work with 2-bit pixels *
   codecInfoDoes4                = (1L << 2),
   /* codec can work with 4-bit pixels *
   codecInfoDoes8                = (1L << 3),
   /* codec can work with 8-bit pixels *
   codecInfoDoes16               = (1L << 4),
   / codec can work with 16-bit pixels *
   codecInfoDoes32               = (1L << 5),
   / codec can work with 32-bit pixels *
   codecInfoDoesDither           = (1L << 6),
   / codec can do ditherMode *
   codecInfoDoesStretch          = (1L << 7),
   / codec can stretch to arbitrary sizes *
   codecInfoDoesShrink           = (1L << 8),
   / codec can shrink to arbitrary sizes *
   codecInfoDoesMask             = (1L << 9),
   /* codec can mask to clipping regions *
   codecInfoDoesTemporal         = (1L << 10),
   /* codec can handle temporal redundancy *
   codecInfoDoesDouble           = (1L << 11),
   /* codec can stretch to double size exactly *
   codecInfoDoesQuad             = (1L << 12),
   /* codec can stretch to quadruple size exactly *
   codecInfoDoesHalf             = (1L << 13),
   /* codec can shrink to half size *
   codecInfoDoesQuarter          = (1L << 14),
   /* codec can shrink to quarter size *
   codecInfoDoesRotate           = (1L << 15),
   /* codec can rotate on decompress *
   codecInfoDoesHorizFlip        = (1L << 16),
   /* codec can flip horizontally on decompress *
   codecInfoDoesVertFlip         = (1L << 17),
   /* codec can flip vertically on decompress *
   codecInfoHasEffectParameterList = (1L << 18),
   /* codec implements get effects parameter list call,
   once was codecInfoDoesSkew *
   codecInfoDoesBlend            = (1L << 19),
   /* codec can blend on decompress *
   codecInfoDoesReorder          = (1L << 19),
   /* codec can rearrange frames during compression *
   codecInfoDoesWarp             = (1L << 20),
   /* codec can warp arbitrarily on decompress *
   codecInfoDoesMultiPass        = (1L << 20),
   /* codec can perform multi-pass compression *
   codecInfoDoesRecompress       = (1L << 21),
   /* codec can recompress image without accumulating errors *
   codecInfoDoesSpool            = (1L << 22),
   /* codec can spool image data *
   codecInfoDoesRateConstrain    = (1L << 23) / codec can data rate constrain *
};
enum {
   codecLockBitsShieldCursor     = (1 << 0) /* shield cursor *
};
Constants
codecCompletionSource

The Image Compression Manager is done with the source buffer. The Image Compression Manager sets this flag to 1 when it is done with the processing associated with the source buffer. For compression operations, the source is the uncompressed pixel map you are compressing. For decompression operations, the source is the decompressed data you are decompressing. 

Available in Mac OS X v10.0 and later.
codecCompletionDest

The Image Compression Manager is done with the destination buffer. The Image Compression Manager sets this flag to 1 when it is done with the processing associated with the destination buffer. 

Available in Mac OS X v10.0 and later.
codecCompletionWentOffscreen

Codec used offscreen buffer. 

Available in Mac OS X v10.0 and later.
codecCompletionUnlockBits

On dest complete, call ICMSequenceUnlockBits. 

Available in Mac OS X v10.0 and later.
codecCompletionForceChainFlush

ICM needs to flush the whole chain. 

Available in Mac OS X v10.0 and later.
codecCompletionDropped

Codec decided to drop this frame. 

Available in Mac OS X v10.0 and later.
codecCompletionDecoded

Codec has decoded this frame; if it is cancelled and rescheduled, set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags. 

Available in Mac OS X v10.3 and later.
codecCompletionNotDisplayable

The frame may still be scheduled for decode, but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames.. 

Available in Mac OS X v10.3 and later.
codecCompletionNotDrawn

Set in conjunction with codecCompletionDest to indicate that the frame was not drawn. 

Available in Mac OS X v10.3 and later.
codecFlagUsedImageBuffer

Indicates to your application that the decompressor used the offscreen image buffer for this frame. If this flag is set to 1, the decompressor used the image buffer. If this flag is set to 0, the decompressor did not use the image buffer. 

Available in Mac OS X v10.0 and later.
codecInfoDoes1

Codec can work with 1-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes2

Codec can work with 2-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes4

Codec can work with 4-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes8

Codec can work with 8-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes16

Codec can work with 16-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes32

Codec can work with 32-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoesDither

Codec can dither images. 

Available in Mac OS X v10.0 and later.
codecInfoDoesStretch

Codec can stretch images to arbitrary sizes. 

Available in Mac OS X v10.0 and later.
codecInfoDoesShrink

Codec can shrink images to arbitrary sizes. 

Available in Mac OS X v10.0 and later.
codecInfoDoesMask

Codec can mask images to clipping regions. 

Available in Mac OS X v10.0 and later.
codecInfoDoesTemporal

Codec can handle temporal redundancy. 

Available in Mac OS X v10.0 and later.
codecInfoDoesDouble

Codec can stretch images to exactly double size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesQuad

Codec can stretch images to exactly quadruple size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesHalf

Codec can shrink images to exactly half size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesQuarter

Codec can shrink images to exactly quarter size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesRotate

Codec can rotate images during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesHorizFlip

Codec can flip images horizontally during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesVertFlip

Codec can flip images vertically during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoHasEffectParameterList

Codec implements QTGetEffectsList. 

Available in Mac OS X v10.0 and later.
codecInfoDoesBlend

Codec can blend image during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesReorder

Codec can rearrange frames during compression. 

Available in Mac OS X v10.3 and later.
codecInfoDoesWarp

Codec can warp image arbitrarily during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesMultiPass

Codec can perform multi-pass compression. 

Available in Mac OS X v10.3 and later.
codecInfoDoesRecompress

Codec can recompress image without accumulating errors. 

Available in Mac OS X v10.0 and later.
codecInfoDoesSpool

Codec can spool image data. 

Available in Mac OS X v10.0 and later.*/
enum {
   codecCompletionSource         = (1 << 0),
   /* asynchronous codec is done with source data */
   codecCompletionDest           = (1 << 1),
   /* asynchronous codec is done with destination data */
   codecCompletionDontUnshield   = (1 << 2),
   /* on dest complete don't unshield cursor */
   codecCompletionWentOffscreen  = (1 << 3),
   /* codec used offscreen buffer */
   codecCompletionUnlockBits     = (1 << 4),
   /* on dest complete,
   call ICMSequenceUnlockBits */
   codecCompletionForceChainFlush = (1 << 5),
   /* ICM needs to flush the whole chain */
   codecCompletionDropped        = (1 << 6),
   /* codec decided to drop this frame */
   codecCompletionDecoded        = (1 << 10),
   /* codec has decoded this frame; if it is cancelled and rescheduled,
   set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags */
   codecCompletionNotDisplayable = (1 << 11),
   /* the frame may still be scheduled for decode,
   but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames. */
   codecCompletionNotDrawn       = (1 << 12) /* set in conjunction with codecCompletionDest to indicate that the frame was not drawn */
};
enum {
   codecFlagOutUpdateOnNextIdle  = (1L << 9),
   codecFlagOutUpdateOnDataSourceChange = (1L << 10),
   codecFlagSequenceSensitive    = (1L << 11),
   codecFlagOutUpdateOnTimeChange = (1L << 12),
   codecFlagImageBufferNotSourceImage = (1L << 13),
   codecFlagUsedNewImageBuffer   = (1L << 14),
   codecFlagUsedImageBuffer      = (1L << 15)
};
enum {
   codecInfoDoes1                = (1L << 0),
   /* codec can work with 1-bit pixels */
   codecInfoDoes2                = (1L << 1),
   /* codec can work with 2-bit pixels */
   codecInfoDoes4                = (1L << 2),
   /* codec can work with 4-bit pixels */
   codecInfoDoes8                = (1L << 3),
   /* codec can work with 8-bit pixels */
   codecInfoDoes16               = (1L << 4),
   /* codec can work with 16-bit pixels */
   codecInfoDoes32               = (1L << 5),
   /* codec can work with 32-bit pixels */
   codecInfoDoesDither           = (1L << 6),
   /* codec can do ditherMode */
   codecInfoDoesStretch          = (1L << 7),
   /* codec can stretch to arbitrary sizes */
   codecInfoDoesShrink           = (1L << 8),
   /* codec can shrink to arbitrary sizes */
   codecInfoDoesMask             = (1L << 9),
   /* codec can mask to clipping regions */
   codecInfoDoesTemporal         = (1L << 10),
   /* codec can handle temporal redundancy */
   codecInfoDoesDouble           = (1L << 11),
   /* codec can stretch to double size exactly */
   codecInfoDoesQuad             = (1L << 12),
   /* codec can stretch to quadruple size exactly */
   codecInfoDoesHalf             = (1L << 13),
   /* codec can shrink to half size */
   codecInfoDoesQuarter          = (1L << 14),
   /* codec can shrink to quarter size */
   codecInfoDoesRotate           = (1L << 15),
   /* codec can rotate on decompress */
   codecInfoDoesHorizFlip        = (1L << 16),
   /* codec can flip horizontally on decompress */
   codecInfoDoesVertFlip         = (1L << 17),
   /* codec can flip vertically on decompress */
   codecInfoHasEffectParameterList = (1L << 18),
   /* codec implements get effects parameter list call,
   once was codecInfoDoesSkew */
   codecInfoDoesBlend            = (1L << 19),
   /* codec can blend on decompress */
   codecInfoDoesReorder          = (1L << 19),
   /* codec can rearrange frames during compression */
   codecInfoDoesWarp             = (1L << 20),
   /* codec can warp arbitrarily on decompress */
   codecInfoDoesMultiPass        = (1L << 20),
   /* codec can perform multi-pass compression */
   codecInfoDoesRecompress       = (1L << 21),
   /* codec can recompress image without accumulating errors */
   codecInfoDoesSpool            = (1L << 22),
   /* codec can spool image data */
   codecInfoDoesRateConstrain    = (1L << 23) /* codec can data rate constrain */
};
enum {
   codecLockBitsShieldCursor     = (1 << 0) /* shield cursor */
};

/*Codec Type Constants

Constants that represent codec types.

kDVCPro50NTSCCodecType        = 'dv5n'
kDVCPro50PALCodecType         = 'dv5p'
kDVCPro100NTSCCodecType       = 'dv1n'
kDVCPro100PALCodecType        = 'dv1p'
kDVCPROHD720pCodecType        = 'dvhp'
kDVCPROHD1080i60CodecType     = 'dvh6'
kDVCPROHD1080i50CodecType     = 'dvh5'
kSorenson3CodecType           = 'SVQ3'
kMPEG4VisualCodecType         = 'mp4v'
k422YpCbCr8CodecType          = '2vuy'
k444YpCbCr8CodecType          = 'v308'
k4444YpCbCrA8CodecType        = 'v408'
k422YpCbCr16CodecType         = 'v216'
k422YpCbCr10CodecType         = 'v210'
k444YpCbCr10CodecType         = 'v410'
k4444YpCbCrA8RCodecType       = 'r408'
kJPEG2000CodecType            = 'mjp2'
kPixletCodecType              = 'pxlt'
kH264CodecType                = 'avc1'
kSorenson3CodecType

Available in QuickTime 5 and later. 

Available in Mac OS X v10.0 and later.
k422YpCbCr8CodecType

Component Y'CbCr 8-bit 4:2:2. 

Available in Mac OS X v10.0 and later.
k444YpCbCr8CodecType

Component Y'CbCr 8-bit 4:4:4. 

Available in Mac OS X v10.0 and later.
k4444YpCbCrA8CodecType

Component Y'CbCrA 8-bit 4:4:4:4. 

Available in Mac OS X v10.0 and later.
k422YpCbCr16CodecType

Component Y'CbCr 10,12,14,16-bit 4:2:2. 

Available in Mac OS X v10.0 and later.
k422YpCbCr10CodecType

Component Y'CbCr 10-bit 4:2:2. 

Available in Mac OS X v10.0 and later.
k444YpCbCr10CodecType

Component Y'CbCr 10-bit 4:4:4. 

Available in Mac OS X v10.0 and later.
k4444YpCbCrA8RCodecType

Component Y'CbCrA 8-bit 4:4:4:4, rendering format. full range alpha, zero biased YUV. 

Available in Mac OS X v10.0 and later.*/
enum {
kDVCPro50NTSCCodecType        = 'dv5n' ,
kDVCPro50PALCodecType         = 'dv5p',
kDVCPro100NTSCCodecType       = 'dv1n',
kDVCPro100PALCodecType        = 'dv1p',
kDVCPROHD720pCodecType        = 'dvhp',
kDVCPROHD1080i60CodecType     = 'dvh6',
kDVCPROHD1080i50CodecType     = 'dvh5',
kSorenson3CodecType           = 'SVQ3',
kMPEG4VisualCodecType         = 'mp4v',
k422YpCbCr8CodecType          = '2vuy',
k444YpCbCr8CodecType          = 'v308',
k4444YpCbCrA8CodecType        = 'v408',
k422YpCbCr16CodecType         = 'v216',
k422YpCbCr10CodecType         = 'v210',
k444YpCbCr10CodecType         = 'v410',
k4444YpCbCrA8RCodecType       = 'r408',
kJPEG2000CodecType            = 'mjp2',
kPixletCodecType              = 'pxlt',
kH264CodecType                = 'avc1'
};


//Typedef&


/*ICMCompletionProc

Called by a compressor component upon completion of an asynchronous operation.

typedef void (*ICMCompletionProcPtr) (OSErr result, short flags, long refcon);

If you name your function MyICMCompletionProc, you would declare it this way:

void MyICMCompletionProc (
   OSErr    result,
   short    flags,
   long     refcon );
Parameters
result

Indicator of success of current operation.
flags

Contains flags (see below) that indicate which part of the operation is complete. Note that more than one of the flags may be set to 1. See these constants: 
codecCompletionSource
codecCompletionDest
refcon

Contains a reference constant value for use by your completion function. Your application specifies the value of this reference constant in the callback function structure you pass to the Image Compression Manager.
Declared In
ImageCompression.h*/
typedef void (*ICMCompletionProcPtr) (OSErr result, short flags, long refcon);

/*ICMCompletionUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMCompletionProcPtr) ICMCompletionUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMCompletionProcPtr) ICMCompletionUPP;

/*ICMCompletionProcRecord

Specifies an image compression completion callback.

struct ICMCompletionProcRecord {
   ICMCompletionUPP    completionProc;
   long                completionRefCon;
};
Fields
completionProc
Discussion

Contains a Universal Procedure Pointer that accesses your ICMCompletionProc callback. 
completionRefCon
Discussion

Contains a reference constant for use by your callback.
Discussion

This structure governs whether you perform a compression asynchronously. If the completionProc field in this structure is set to NIL, perform the compression synchronously. If this field is not NIL, it specifies an application completion function. Perform the compression asynchronously and call that completion function when your component is finished. If the completionProc field in this structure has a value of -1, perform the operation asynchronously but do not call the application's completion function
Related Functions
CompressSequenceFrame
DecompressSequenceFrame
DecompressSequenceFrameS
DecompressSequenceFrameWhen
ICMDecompressComplete
ICMDecompressCompleteS
MediaQueueNonPrimarySourceData
MediaSetNonPrimarySourceData
SCCompressSequenceFrameAsync
TweenerDataProc 
Programming Info
C interface file: ImageCompression.h*/
struct ICMCompletionProcRecord {
   ICMCompletionUPP    completionProc;
   long                completionRefCon;
};
typedef struct ICMCompletionProcRecord ICMCompletionProcRecord;

/*ICMCompletionProcRecordPtr

Abst_ICMCompletionProcRecordPtr

typedef ICMCompletionProcRecord * ICMCompletionProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMCompletionProcRecord * ICMCompletionProcRecordPtr;

/*DecompressorComponent

Represents a type used by the Compression and Decompression API.

typedef Component DecompressorComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef Component DecompressorComponent;

/*MatrixRecord

Contains a transformation matrix.

struct MatrixRecord {
   Fixed    matrix[3][3];
};
Fields
matrix
Discussion

A 3-by-3 array of matrix values.
Related Functions
GetMovieMatrix
GetTrackMatrix
GraphicsImportGetDefaultMatrix
MediaSetMatrix
TransformRgn
TranslateMatrix
VDSetPlayThruDestination 
Programming Info
C interface file: ImageCompression.h*/
struct MatrixRecord {
   Fixed    matrix[3][3];
};
typedef struct MatrixRecord MatrixRecord;

/*MatrixRecordPtr

Abst_MatrixRecordPtr

typedef MatrixRecord * MatrixRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MatrixRecord * MatrixRecordPtr;

/*ImageSequence

Abst_ImageSequence

typedef long ImageSequence;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long ImageSequence;

/*GraphicsImportCreateCGImage Values

Constants passed to GraphicsImportCreateCGImage.

enum {
   kGraphicsImportCreateCGImageUsingCurrentSettings = 1L << 0
};
Declared In
ImageCompression.h*/
enum {
   kGraphicsImportCreateCGImageUsingCurrentSettings = 1L << 0
};


/*Codec Identifiers

Identify codec components and data types in QuickTime.

kAnimationCodecType          ='rle '
kAVRJPEGCodecType            ='avr '
kBaseCodecType               ='base'
kBMPCodecType                ='WRLE'
kCinepakCodecType            ='cvid'
kCloudCodecType              ='clou'
kCMYKCodecType               ='cmyk'
kComponentVideoCodecType     ='yuv2'
kComponentVideoSigned        ='yuvu'
kComponentVideoUnsigned      ='yuvs'
kDVCNTSCCodecType            ='dvc '
kDVCPALCodecType             ='dvcp'
kDVCProNTSCCodecType         ='dvpn'
kDVCProPALCodecType          ='dvpp'
kFireCodecType               ='fire'
kFLCCodecType                ='flic'
k48RGBCodecType              ='b48r'
kGIFCodecType                ='gif '
kGraphicsCodecType           ='smc '
kH261CodecType               ='h261'
kH263CodecType               ='h263'
kIndeo4CodecType             ='IV41'
kJPEGCodecType               ='jpeg'
kMacPaintCodecType           ='PNTG'
kMicrosoftVideo1CodecType    ='msvc'
kMotionJPEGACodecType        ='mjpa'
kMotionJPEGBCodecType        ='mjpb'
kMpegYUV420CodecType         ='myuv'
kOpenDMLJPEGCodecType        ='dmb1'
kPhotoCDCodecType            ='kpcd'
kPlanarRGBCodecType          ='8BPS'
kPNGCodecType                ='png '
kQuickDrawCodecType          ='qdrw'
kQuickDrawGXCodecType        ='qdgx'
kRawCodecType                ='raw '
kSGICodecType                ='.SGI'
k16GrayCodecType             ='b16g'
k64ARGBCodecType             ='b64a'
kSorensonCodecType           ='SVQ1'
kSorensonYUV9CodecType       ='syv9'
kTargaCodecType              ='tga '
k32AlphaGrayCodecType        ='b32a'
kTIFFCodecType               ='tiff'
kVectorCodecType             ='path'
kVideoCodecType              ='rpza'
kWaterRippleCodecType        ='ripl'
kWindowsRawCodecType         ='WRAW'
kYUV420CodecType             ='y420
Discussion

All codec components of the same type provide the same kinds of services and support a common application programming interface.*/
enum {
kAnimationCodecType          ='rle ',
kAVRJPEGCodecType            ='avr ',
kBaseCodecType               ='base',
kBMPCodecType                ='WRLE',
kCinepakCodecType            ='cvid',
kCloudCodecType              ='clou',
kCMYKCodecType               ='cmyk',
kComponentVideoCodecType     ='yuv2',
kComponentVideoSigned        ='yuvu',
kComponentVideoUnsigned      ='yuvs',
kDVCNTSCCodecType            ='dvc ',
kDVCPALCodecType             ='dvcp',
kDVCProNTSCCodecType         ='dvpn',
kDVCProPALCodecType          ='dvpp',
kFireCodecType               ='fire',
kFLCCodecType                ='flic',
k48RGBCodecType              ='b48r',
kGIFCodecType                ='gif ',
kGraphicsCodecType           ='smc ',
kH261CodecType               ='h261',
kH263CodecType               ='h263',
kIndeo4CodecType             ='IV41',
kJPEGCodecType               ='jpeg',
kMacPaintCodecType           ='PNTG',
kMicrosoftVideo1CodecType    ='msvc',
kMotionJPEGACodecType        ='mjpa',
kMotionJPEGBCodecType        ='mjpb',
kMpegYUV420CodecType         ='myuv',
kOpenDMLJPEGCodecType        ='dmb1',
kPhotoCDCodecType            ='kpcd',
kPlanarRGBCodecType          ='8BPS',
kPNGCodecType                ='png ',
kQuickDrawCodecType          ='qdrw',
kQuickDrawGXCodecType        ='qdgx',
kRawCodecType                ='raw ',
kSGICodecType                ='.SGI',
k16GrayCodecType             ='b16g',
k64ARGBCodecType             ='b64a',
kSorensonCodecType           ='SVQ1',
kSorensonYUV9CodecType       ='syv9',
kTargaCodecType              ='tga ',
k32AlphaGrayCodecType        ='b32a',
kTIFFCodecType               ='tiff',
kVectorCodecType             ='path',
kVideoCodecType              ='rpza',
kWaterRippleCodecType        ='ripl',
kWindowsRawCodecType         ='WRAW',
kYUV420CodecType             ='y420'
};

/*Constants

The following constants are used to specify graphics exporter characteristics:
enum {
    GraphicsExporterComponentType = FOUR_CHAR_CODE('grex'),
    kBaseGraphicsExporterSubType = FOUR_CHAR_CODE('base')
};
 
enum {
    graphicsExporterIsBaseExporter = 1L << 0,
    graphicsExporterCanTranscode = 1L << 1,
    graphicsExporterUsesImageCompressor = 1L << 2
};*/

enum {
    GraphicsExporterComponentType = FOUR_CHAR_CODE('grex'),
    kBaseGraphicsExporterSubType = FOUR_CHAR_CODE('base')
};
 
enum {
    graphicsExporterIsBaseExporter = 1L << 0,
    graphicsExporterCanTranscode = 1L << 1,
    graphicsExporterUsesImageCompressor = 1L << 2
};


/*GraphicsExportComponent

Represents a type used by the Graphics Import and Export API.

typedef ComponentInstance GraphicsExportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ComponentInstance GraphicsExportComponent;

/*ICMProgressProc

Reports on the progress of a compressor or decompressor.

typedef OSErr (*ICMProgressProcPtr) (short message, Fixed completeness, long refcon);

If you name your function MyICMProgressProc, you would declare it this way:

OSErr MyICMProgressProc (
   short    message,
   Fixed    completeness,
   long     refcon );
Parameters
message

Indicates why the Image Compression Manager called your function. There are three valid messages, listed below. See these constants: 
codecProgressOpen
codecProgressUpdatePercent
codecProgressClose
completeness

Contains a fixed-point value indicating how far the operation has progressed. Its value is always between 0.0 and 1.0. This parameter is valid only when the message field is set to codecProgressUpdatePercent.
refcon

Contains a reference constant value for use by your progress function. Your application specifies the value of this reference constant in the progress function structure you pass to the Image Compression Manager.
Return Value

See Error Codes. Your callback should return noErr if there is no error. When a component calls your progress function, it supplies you with a number that indicates the completion percentage. Your program can cause the component to terminate the current operation by returning a result code of codecAbortErr.
Discussion

The Image Compression Manager calls your progress function only during long operations, and it does not call your function more than 30 times per second.
Declared In
ImageCompression.h*/
typedef OSErr (*ICMProgressProcPtr) (short message, Fixed completeness, long refcon);

/*ICMProgressUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMProgressProcPtr) ICMProgressUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMProgressProcPtr) ICMProgressUPP;

/*ICMProgressProcRecord

Specifies an image compression progress callback.

struct ICMProgressProcRecord {
   ICMProgressUPP    progressProc;
   long              progressRefCon;
};
Fields
progressProc
Discussion

Contains a pointer to your progress function.
progressRefCon
Discussion

Contains a reference constant for use by your progress function.
Discussion

During a compression operation, your compressor may occasionally call a function that the application provides in order to report your progress. This field contains a structure that identifies the progress function. If the progressProc field in this structure is set to NIL, the application has not supplied a progress function
Related Functions
DrawPictureFile
DrawTrimmedPicture
DrawTrimmedPictureFile
FCompressImage
FCompressPicture
FCompressPictureFile
FDecompressImage
GetCompressedPixMapInfo
GraphicsExportGetProgressProc
GraphicsExportSetProgressProc
GraphicsImportGetProgressProc
GraphicsImportSetProgressProc
ImageCodecTrimImage
MakeFilePreview
MakeThumbnailFromPicture
MakeThumbnailFromPictureFile
MakeThumbnailFromPixMap
PreviewMakePreview
SetCompressedPixMapInfo
SetSequenceProgressProc
TrimImage 
Programming Info
C interface file: ImageCompression.h*/

struct ICMProgressProcRecord {
   ICMProgressUPP    progressProc;
   long              progressRefCon;
};
typedef  struct ICMProgressProcRecord ICMProgressProcRecord;

/*ICMProgressProcRecordPtr

Abst_ICMProgressProcRecordPtr

typedef ICMProgressProcRecord * ICMProgressProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMProgressProcRecord * ICMProgressProcRecordPtr;

/*GraphicsImportComponent

Represents a type used by the Graphics Import and Export API.

typedef ComponentInstance GraphicsImportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ComponentInstance GraphicsImportComponent;

/*ICM Preferences and Flags

Constants that represent the flags and preferences for ICM sessions.

enum {
   icmFrameTimeHasVirtualStartTimeAndDuration = 1 << 0,
   icmFrameAlreadyDecoded        = 1 << 1,
   icmFrameTimeIsNonScheduledDisplayTime = 1 << 2,
   icmFrameTimeHasDecodeTime     = 1 << 3,
   icmFrameTimeDecodeImmediately = 1 << 4,
   icmFrameTimeDoNotDisplay      = 1 << 5
};
enum {
   kICMGetChainUltimateParent    = 0,
   kICMGetChainParent            = 1,
   kICMGetChainChild             = 2,
   kICMGetChainUltimateChild     = 3
};
enum {
   kICMImageBufferNoPreference   = 0,
   kICMImageBufferPreferMainMemory = 1,
   kICMImageBufferPreferVideoMemory = 2
};
enum {
   kICMNoDeinterlacing           = 0,
   kICMDeinterlaceFields         = 1
};
enum {
   kICMPixelFormatIsPlanarMask   = 0x0F,
   // these bits in formatFlags indicate how many planes there are; they're 0 if chunky
   kICMPixelFormatIsIndexed      = (1L << 4),
   kICMPixelFormatIsSupportedByQD = (1L << 5),
   kICMPixelFormatIsMonochrome   = (1L << 6),
   kICMPixelFormatHasAlphaChannel = (1L << 7)
};
enum {
   kICMSequenceTaskWeight        = 'twei',
   // data is pointer to UInt32
   kICMSequenceTaskName          = 'tnam',
   //data is pointer to OSType
   kICMSequenceUserPreferredCodecs = 'punt' // data is pointer to CodecComponentHandle
};
enum {
   kICMTempThenAppMemory         = 1L << 12,
   kICMAppThenTempMemory         = 1L << 13
};
Constants
icmFrameTimeHasVirtualStartTimeAndDuration

Indicates that virtualStartTime and virtualDuration are valid. 

Available in Mac OS X v10.0 and later.
icmFrameTimeHasDecodeTime

Indicates that decodeTime is valid. 

Available in Mac OS X v10.3 and later.
kICMPixelFormatIsPlanarMask

If this flag is 1, the pixel format is a planar mask and bitsPerPixel[] represents the bits for each pixel component. If this flag is 0, the pixel format is chunky (not planar) and bitsPerPixel[0] represents the bits per pixel. Chunky pixel formats pack the different components together. For example, 3 pixels of 32-bit ARGB is represented in memory as ARGBARGBARGB. Planar formats pack the different components separately. If the pixel format is planar, then (formatFlags & kICMPixelFormatIsPlanarMask) is equal to the number of components. 

Available in Mac OS X v10.0 and later.
kICMPixelFormatIsIndexed

If the pixel format is indexed (which, by definition, means that there are no individual components) then this flag is 1. Generally, color modes of 8 bit per pixel or less are indexed. 

Available in Mac OS X v10.0 and later.
kICMPixelFormatIsSupportedByQD

If this flag is 1, you can call QuickDraw on PixMap structures that store this kind of pixel data. With Macintosh, the classic QD pixel formats will have this set, but not any of the YUV pixel formats. With Windows, more formats will have this set, because the Windows implementation of QuickDraw needs to support more pixel formats. 

Available in Mac OS X v10.0 and later.
kICMSequenceUserPreferredCodecs

Data is pointer to CodecComponentHandle. 

Available in Mac OS X v10.0 and later.*/
enum {
   icmFrameTimeHasVirtualStartTimeAndDuration = 1 << 0,
   icmFrameAlreadyDecoded        = 1 << 1,
   icmFrameTimeIsNonScheduledDisplayTime = 1 << 2,
   icmFrameTimeHasDecodeTime     = 1 << 3,
   icmFrameTimeDecodeImmediately = 1 << 4,
   icmFrameTimeDoNotDisplay      = 1 << 5
};
enum {
   kICMGetChainUltimateParent    = 0,
   kICMGetChainParent            = 1,
   kICMGetChainChild             = 2,
   kICMGetChainUltimateChild     = 3
};
enum {
   kICMImageBufferNoPreference   = 0,
   kICMImageBufferPreferMainMemory = 1,
   kICMImageBufferPreferVideoMemory = 2
};
enum {
   kICMNoDeinterlacing           = 0,
   kICMDeinterlaceFields         = 1
};
enum {
   kICMPixelFormatIsPlanarMask   = 0x0F,
   /* these bits in formatFlags indicate how many planes there are; they're 0 if chunky*/
   kICMPixelFormatIsIndexed      = (1L << 4),
   kICMPixelFormatIsSupportedByQD = (1L << 5),
   kICMPixelFormatIsMonochrome   = (1L << 6),
   kICMPixelFormatHasAlphaChannel = (1L << 7)
};
enum {
   kICMSequenceTaskWeight        = 'twei',
   /* data is pointer to UInt32*/
   kICMSequenceTaskName          = 'tnam',
   /* data is pointer to OSType*/
   kICMSequenceUserPreferredCodecs = 'punt' /* data is pointer to CodecComponentHandle*/
};
enum {
   kICMTempThenAppMemory         = 1L << 12,
   kICMAppThenTempMemory         = 1L << 13
};

/*decompressionTrackingFlags

One or more flags describing the a frame's state transitions:
kICMDecompressionTracking_LastCall = 1L<<0

This is the last call for this sourceFrameRefCon.
kICMDecompressionTracking_ReleaseSourceData = 1L<<1

The session no longer needs the source data pointer.
kICMDecompressionTracking_EmittingFrame = 1L<<2

A frame is being emitted. The pixelBuffer parameter contains the decompressed frame. If the decompression session is targetting a visual context, the frame has not yet been sent to the visual context but will be sent after the callback returns.
kICMDecompressionTracking_FrameDecoded = 1L<<3

This frame was decoded.
kICMDecompressionTracking_FrameDropped = 1L<<4

The codec decided to drop this frame.
kICMDecompressionTracking_FrameNeedsRequeueing = 1L<<5

This frame will not be able to be displayed unless it is queued for redecode ( this constant is also known as FrameNotDisplayable).*/
enum {
kICMDecompressionTracking_LastCall = 1L<<0,
kICMDecompressionTracking_ReleaseSourceData = 1L<<1,
kICMDecompressionTracking_EmittingFrame = 1L<<2,
kICMDecompressionTracking_FrameDecoded = 1L<<3,
kICMDecompressionTracking_FrameDropped = 1L<<4,
kICMDecompressionTracking_FrameNeedsRequeueing = 1L<<5
};

/*ICM Property IDs

Constants that contain the IDs of ICM properties.

enum {
      //Both fields should be decompressed.
   
   kICMFieldMode_BothFields      = 0,
   
   // Only the top field should be decompressed,
   //producing a half-height
   // image.
   //
   kICMFieldMode_TopFieldOnly    = 1,
   
   //Only the bottom field should be decompressed,
   //producing a
   //half-height image.
   
   /ICMFieldMode_BottomFieldOnly = 2,
   //
   //Both fields should be decompressed,
   //and then filtered to reduce
   /interlacing artifacts.
   //
   kICMFieldMode_DeinterlaceFields = 3
};
enum {
   /*
   * Class identifier for compression frame options object properties.
   */
   //kQTPropertyClass_ICMCompressionFrameOptions = 'icfo',
   /*
   * Forces frames to be compressed as key frames.
   * The compressor must obey the "force key frame" flag if set. By
   * default this property is false.
   */
 //  kICMCompressionFrameOptionsPropertyID_ForceKeyFrame = 'keyf',
   /* Boolean,
   Read/Write */
   /*
   * Requests a frame be compressed as a particular frame type.
   *  The frame type setting may be ignored by the compressor if not
   * appropriate.
   * By default this is set to kICMFrameType_Unknown.
   * Do not assume that kICMFrameType_I means a key frame; if you need
   * a key frame,
   set the "force key frame" property.
   */
   //kICMCompressionFrameOptionsPropertyID_FrameType = 'frty' /* ICMFrameType,
  // Read/Write */
//};
//enum {
   /*
   * Class identifier for compression session options object properties.
   */
   //kQTPropertyClass_ICMCompressionSessionOptions = 'icso',
   /*
   * Enables temporal compression. By default,
   temporal compression is
   * disabled.
   * IMPORTANT: If you want temporal compression (P frames and/or B
   * frames) you must set this to true.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression = 'p ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables frame reordering.
   * In order to encode B frames,
   a compressor must reorder frames,
   * which means that the order in which they will be emitted and
   * stored (the decode order) is different from the order in which
   * they were presented to the compressor (the display order).
   * By default,
   frame reordering is disabled.
   * IMPORTANT: In order to encode using B frames,
   you must enable
   * frame reordering.
   */
  // kICMCompressionSessionOptionsPropertyID_AllowFrameReordering = 'b ok',
   /* Boolean,
   Read/Write */
   /*
   * Indicates that durations of emitted frames are needed.
   * If this flag is set and source frames are provided with times but
   * not durations,
   then frames will be delayed so that durations can
   * be calculated as the difference between one frame's time stamp and
   * the next frame's time stamp.
   * By default,
   this flag is clear,
   so frames will not be delayed in
   * order to calculate durations.
   * IMPORTANT: If you will be passing encoded frames to
   * AddMediaSampleFromEncodedFrame,
   you must set this flag to true.
   */
  // kICMCompressionSessionOptionsPropertyID_DurationsNeeded = 'need',
   /* Boolean,
   Read/Write */
   /*
   * The maximum interval between key frames,
   also known as the key
   * frame rate.
   * Key frames,
   also known as sync frames,
   reset inter-frame
   * dependencies; decoding a key frame is sufficient to prepare a
   * decompressor for correctly decoding the difference frames that
   * follow.
   * Compressors are allowed to generate key frames more frequently if
   * this would result in more efficient compression.
   * The default key frame interval is 0,
   which indicates that the
   * compressor should choose where to place all key frames. A key
   * frame interval of 1 indicates that every frame must be a key
   * frame,
   2 indicates that at least every other frame must be a key
   * frame,
   etc.
   */
   //kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval = 'kyfr',
   /* SInt32,
   Read/Write */
   /*
   * The requested maximum interval between partial sync frames. If the
   * interval is n,
   any sequence of n successive frames must include at
   * least one key or partial sync frame.
   * Where supported,
   partial sync frames perform a partial reset of
   * inter-frame dependencies; decoding two partial sync frames and the
   * non-droppable difference frames between them is sufficient to
   * prepare a decompressor for correctly decoding the difference
   * frames that follow.
   * Compressors are allowed to generate partial sync frames more
   * frequently if this would result in more efficient compression.
   *
   * The default partial sync frame interval is 0,
   which indicates that
   * the compressor should choose where to place partial sync frames. A
   * partial sync frame interval of 1 means there can be no difference
   * frames,
   so it is equivalent to a key frame interval of 1. A
   * partial sync frame interval of 2 means that every other frame must
   * be a key frame or a partial sync frame.
   * Compressors that do not support partial sync frames will ignore
   * this setting.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval = 'psfr',
   /* SInt32,
   Read/Write */
   /*
   * Enables the compressor to modify frame times.
   * Some compressors are able to identify and coalesce runs of
   * identical frames and output single frames with longer duration,
   or
   * output frames at a different frame rate from the original. This
   * feature is controlled by the "allow frame time changes" flag. By
   * default,
   this flag is set to false,
   which forces compressors to
   * emit one encoded frame for every source frame,
   and to preserve
   * frame display times.
   * (Note: this feature replaces the practice of having compressors
   * return special high similarity values to indicate that frames
   * could be dropped.)
   * If you want to allow the compressor to modify frame times in order
   * to improve compression performance,
   enable frame time changes.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges = '+ ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables the compressor to call the encoded-frame callback from a
   * different thread.
   * By default,
   the flag is false,
   which means that the compressor
   * must call the encoded-frame callback from the same thread that
   * ICMCompressionSessionEncodeFrame and
   * ICMCompressionSessionCompleteFrames were called on.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion = 'asok',
   /* Boolean,
   Read/Write */
   /*
   * The maximum frame delay count is the maximum number of frames that
   * a compressor is allowed to hold before it must output a compressed
   * frame. It limits the number of frames that may be held in the
   * "compression window". If the maximum frame delay count is M,
   then
   * before the call to encode frame N returns,
   frame N-M must have
   * been emitted.
   * The default is kICMUnlimitedFrameDelayCount,
   which sets no limit
   * on the compression window.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount = 'cwin',
   /* SInt32,
   Read/Write */
   /*
   * The maximum frame delay time is the maximum difference between a
   * source frame's display time and the corresponding encoded frame's
   * decode time. It limits the span of display time that may be held
   * in the "compression window". If the maximum frame delay time is
   * TM,
   then before the call to encode a frame with display time TN
   * returns,
   all frames with display times up to and including TN-TM
   * must have been emitted.
   * The default is kICMUnlimitedFrameDelayTime,
   which sets no time
   * limit on the compression window.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime = 'cwit',
   /* TimeValue64,
   Read/Write */
   /*
   * Sets a specific compressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * Use this API to force the Image Compression Manager to use a
   * specific compressor component or compressor component instance.
   * (If you pass in a component instance that you opened,
   the ICM will
   * not close that instance; you must do so after the compression
   * session is released.) To allow the Image Compression Manager to
   * choose the compressor component,
   set the compressorComponent to
   * anyCodec (the default),
   bestSpeedCodec,
   bestFidelityCodec or
   * bestCompressionCodec.
   */
 //  kICMCompressionSessionOptionsPropertyID_CompressorComponent = 'imco',
   /* CompressorComponent,
   Read/Write */
   /*
   * A handle containing compressor settings. The compressor will be
   * configured with these settings (by a call to
   * ImageCodecSetSettings) during ICMCompressionSessionCreate.
   */
  // kICMCompressionSessionOptionsPropertyID_CompressorSettings = 'cost',
   /* Handle,
   Read/Write */
   /*
   * The depth for compression.
   * If a compressor does not support a specific depth,
   the closest
   * supported depth will be used (preferring deeper depths to
   * shallower depths). The default depth is k24RGBPixelFormat.
   */
 //  kICMCompressionSessionOptionsPropertyID_Depth = 'deep',
   /* UInt32,
   Read/Write */
   /*
   * The color table for compression.  Used with indexed-color depths.
   *
   * Clients who get this property are responsible for disposing the
   * returned CTabHandle.
   */
  // kICMCompressionSessionOptionsPropertyID_ColorTable = 'clut',
   /* CTabHandle,
   Read/Write*/
   /*
   * The compression quality.
   * This value is always used to set the spatialQuality; if temporal
   * compression is enabled,
   it is also used to set temporalQuality.
   * <BR> The default quality is codecNormalQuality.
   */
   //kICMCompressionSessionOptionsPropertyID_Quality = 'qual',
   /* CodecQ,
   Read/Write */
   /*
   * The long-term desired average data rate in bytes per second.
   *  This is not a hard limit.
   * The default data rate is zero,
   which indicates that the quality
   * setting should determine the size of compressed data.
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
  // kICMCompressionSessionOptionsPropertyID_AverageDataRate = 'aver',
   /* SInt32,
   Read/Write */
   /*
   * Zero,
   one or two hard limits on data rate.
   * Each hard limit is described by a data size in bytes and a
   * duration in seconds,
   and requires that the total size of
   * compressed data for any contiguous segment of that duration (in
   * decode time) must not exceed the data size.
   * By default,
   no data rate limits are set.
   * When setting this property,
   the inPropValueSize parameter should
   * be the number of data rate limits multiplied by
   * sizeof(ICMDataRateLimit).
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
  // kICMCompressionSessionOptionsPropertyID_DataRateLimits = 'hard',
   /* C array of ICMDataRateLimit struct,
   Read/Write */
   /*
   * The current number of data rate limits.
   */
  // kICMCompressionSessionOptionsPropertyID_DataRateLimitCount = 'har#',
   /* UInt32,
   Read */
   /*
   * The maximum allowed number of data rate limits.  (Currently 2.)
   */
  // kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits = 'mhar',
   /* UInt32,
   Read */
   /*
   * Indicates that the source was previously compressed.
   * This property is purely an optional,
   informational hint to the
   * compressor; by default it is false.
   */
  // kICMCompressionSessionOptionsPropertyID_WasCompressed = 'wasc',
   /* Boolean,
   Read/Write */
   /*
   * Recommends a CPU time budget for the compressor in microseconds
   * per frame.
   * Zero means to go as fast as possible.
   * By default,
   this is set to kICMUnlimitedCPUTimeBudget,
   which sets
   * no limit.
   * This is an advisory hint to the compressor,
   and some compressors
   * may ignore it. Multithreaded compressors may use this amount of
   * CPU time on each processor.
   * Compressors should not feel compelled to use the full time budget
   * if they complete ahead of time!
   */
  // kICMCompressionSessionOptionsPropertyID_CPUTimeBudget = 'cput',
   /* UInt32,
   Read/Write */
   /*
   * Storage for multi-pass compression.
   * To enable multipass compression,
   the client must provide a storage
   * location for multipass data.  Use
   * ICMMultiPassStorageCreateWithTemporaryFile to have the ICM store
   * it in a temporary file.  Use
   * ICMMultiPassStorageCreateWithCallbacks to manage the storage
   * yourself.
   * Note that the amount of multipass data to be stored can be
   * substantial; it could be greater than the size of the output movie
   * file.
   * If this property is not NULL,
   the client must call
   * ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass
   * around groups of calls to ICMCompressionSessionEncodeFrame.
   *  By default,
   this property is NULL and multipass compression is
   * not enabled. The compression session options object retains the
   * multipass storage object,
   when one is set.
   */
   //kICMCompressionSessionOptionsPropertyID_MultiPassStorage = 'imps',
   /* ICMMultiPassStorageRef,
   Read/Write */
   /*
   * Indicates the number of source frames,
   if known. If nonzero,
   this
   * should be the exact number of times that the client calls
   * ICMCompressionSessionEncodeFrame in each pass.
   * The default is 0,
   which indicates that the number of source frames
   * is not known.
   */
 //  kICMCompressionSessionOptionsPropertyID_SourceFrameCount = 'frco',
   /* UInt64,
   Read/Write */
   /*
   * Indicates the expected frame rate,
   if known. The frame rate is
   * measured in frames per second. This is not used to control the
   * frame rate; it is provided as a hint to the compressor so that it
   * can set up internal configuration before compression begins. The
   * actual frame rate will depend on frame durations and may vary. By
   * default,
   this is zero,
   indicating "unknown".
   */
  // kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate = 'fran',
   /* Fixed,
   Read/Write */
   /*
   * Indicates how source frames to a compression session should be
   * scaled if the dimensions and/or display aspect ratio do not match.
   */
  // kICMCompressionSessionOptionsPropertyID_ScalingMode = 'scam',
   /* OSType,
   Read/Write */
   /*
   * Describes the clean aperture for compressed frames. Note that if
   * the compressor enforces a clean aperture,
   it will override this
   * setting. The clean aperture will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
 //  kICMCompressionSessionOptionsPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio for compressed frames. Note that
   * if the compressor enforces a pixel aspect ratio,
   it will override
   * this setting. The pixel aspect ratio will be set on the output
   * image description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
  // kICMCompressionSessionOptionsPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the number and order of fields for compressed frames.
   * Note that if the compressor enforces field info,
   it will override
   * this setting. The field info will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
  // kICMCompressionSessionOptionsPropertyID_FieldInfo = 'fiel' /* FieldInfoImageDescriptionExtension2,
   //Read/Write */
//};
//enum {
   /*
   * Class identifier for compression session properties.
   */
  // kQTPropertyClass_ICMCompressionSession = 'icse',
   /*
   * The time scale for the compression session.
   */
 //  kICMCompressionSessionPropertyID_TimeScale = 'tscl',
   /* TimeScale,
   Read */
   /*
   * The compressor's pixel buffer attributes for the compression
   * session. You can use these to create a pixel buffer pool for
   * source pixel buffers. Note that this is not the same as the
   * sourcePixelBufferAttributes passed in to
   * ICMCompressionSessionCreate. Getting this property does not change
   * its retain count.
   */
  // kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes = 'batt',
   /* CFDictionaryRef,
   Read */
   /*
   * A pool that can provide ideal source pixel buffers for a
   * compression session. The compression session creates this pixel
   * buffer pool based on the compressor's pixel buffer attributes and
   * any pixel buffer attributes passed in to
   * ICMCompressionSessionCreate. If the source pixel buffer attributes
   * and the compressor pixel buffer attributes can not be reconciled,
   * the pool is based on the source pixel buffer attributes and the
   * ICM converts each CVPixelBuffer internally.
   */
  // kICMCompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * The image description for the compression session. For some
   * codecs,
   the image description may not be available before the
   * first frame is compressed. Multiple calls to retrieve this
   * property will return the same handle. The ICM will dispose this
   * handle when the compression session is disposed.
   * IMPORTANT: The caller must NOT dispose this handle.
   */
  // kICMCompressionSessionPropertyID_ImageDescription = 'idsc' /* ImageDescriptionHandle,
  // Read */
//};
//enum {
   /*
   * Class identifier for decompression frame options object properties.
   */
  // kQTPropertyClass_ICMDecompressionFrameOptions = 'idfo',
   /*
   * A specific pixel buffer that the frame should be decompressed
   * into. Setting this circumvents the pixel buffer pool mechanism. If
   * this buffer is not compatible with the codec's pixel buffer
   * requirements,
   decompression will fail.
   */
  // kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer = 'cvpb' /* CVPixelBufferRef,
 //  Read/Write */
//};
//enum {
   /*
   * Class identifier for decompression session options object
   * properties.
   */
  // kQTPropertyClass_ICMDecompressionSessionOptions = 'idso',
   /*
   * By default,
   this is true,
   meaning that frames must be output in
   * display order. Set this to false to allow frames to be output in
   * decode order rather than in display order.
   */
  // kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired = 'dorq',
   /* Boolean,
   Read/Write */
   /*
   * A specific decompressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * By default,
   this is anyCodec.
   */
   //kICMDecompressionSessionOptionsPropertyID_DecompressorComponent = 'imdc',
   /* DecompressorComponent,
   Read/Write */
   /*
   * The decompression accuracy.
   * The default accuracy is codecNormalQuality.
   */
//   kICMDecompressionSessionOptionsPropertyID_Accuracy = 'acur',
   /* CodecQ,
   Read/Write */
   /*
   * Requests special handling of fields. Not all codecs will obey this
   * request; some codecs will only handle it at certain accuracy
   * levels. Ignored for non-interlaced content.
   */
   //kICMDecompressionSessionOptionsPropertyID_FieldMode = 'fiel',
   /* ICMFieldMode,
   Read/Write */
   /*
   * The maximum number of buffers ahead of the current time that
   * should be decompressed. Used in sessions that target visual
   * contexts. By default,
   the number of buffers will be determined
   * from the visual context.
   */
  // kICMDecompressionSessionOptionsPropertyID_MaxBufferCount = 'm#bf',
   /* UInt32,
   Read/Write */
   /*
   * The minimum time ahead of the current time that frames should be
   * decompressed. Used in sessions that target visual contexts. By
   * default,
   the output-ahead time will be determined from the visual
   * context.
   */
  // kICMDecompressionSessionOptionsPropertyID_OutputAheadTime = 'futu' /* TimeRecord,
  // Read/Write */
////};
//enum {
   /*
   * Class identifier for decompression session properties.
   */
  // kQTPropertyClass_ICMDecompressionSession = 'icds',
   /*
   * The non-scheduled display time for a decompression session.
   * Setting this requests display of the non-scheduled queued frame at
   * that display time,
   if there is one.
   * See ICMDecompressionSessionSetNonScheduledDisplayTime.
   */
  // kICMDecompressionSessionPropertyID_NonScheduledDisplayTime = 'nsti',
   /* ICMNonScheduledDisplayTime,
   Read/Write */
   /*
   * The direction for non-scheduled display time.
   * See ICMDecompressionSessionSetNonScheduledDisplayDirection.
   */
  // kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection = 'nsdu',
   /* Fixed,
   Read/Write */
   /*
   * The pixel buffer pool from which emitted pixel buffers are
   * allocated. Getting this does not change the retain count of the
   * pool.
   */
 //  kICMDecompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * Indicates whether the a common pixel buffer pool is shared between
   * the decompressor and the session client. This is false if separate
   * pools are used because the decompressor's and the client's pixel
   * buffer attributes were incompatible.
   */
//   kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared = 'plsh' /* Boolean,
//   Read */
//};
//enum {
   /*
   * Class identifier for image description properties.
   */
  // kQTPropertyClass_ImageDescription = 'idsc',
   /*
   * The width of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's width field.
 //  */
//   kICMImageDescriptionPropertyID_EncodedWidth = 'encw',
   /* SInt32,
   Read/Write */
   /*
   * The height of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's height field.
   */
//   kICMImageDescriptionPropertyID_EncodedHeight = 'ench',
   /* SInt32,
   Read/Write */
   /*
   * Describes the clean aperture of the buffer. If not specified
   * explicitly in the image description,
   the default clean aperture
   * (full encoded width and height) will be returned.
   */
  // kICMImageDescriptionPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio. If not specified explicitly in
   * the image description,
   a square (1:1) pixel aspect ratio will be
   * returned.
   */
  // kICMImageDescriptionPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * A width at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
 //  kICMImageDescriptionPropertyID_DisplayWidth = 'disw',
   /* SInt32,
   Read */
   /*
   * A height at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
 //  kICMImageDescriptionPropertyID_DisplayHeight = 'dish',
   /* SInt32,
   Read */
   /*
   * A width at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayWidth instead.
   */
  // kICMImageDescriptionPropertyID_ProductionDisplayWidth = 'pdsw',
   /* SInt32,
   Read */
   /*
   * A height at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayHeight instead.
   */
 //  kICMImageDescriptionPropertyID_ProductionDisplayHeight = 'pdsh',
   /* SInt32,
   Read */
   /*
   * Color information,
   if available in the
   * NCLCColorInfoImageDescriptionExtension format.
   */
 //  kICMImageDescriptionPropertyID_NCLCColorInfo = 'nclc',
   /* Native-endian NCLCColorInfoImageDescriptionExtension,
   Read/Write */
   /*
   * The gamma level described by the image description.
   */
//   kICMImageDescriptionPropertyID_GammaLevel = 'gama',
   /* Fixed,
   Read/Write */
   /*
   * Information about the number and order of fields,
   if available.
   */
//   kICMImageDescriptionPropertyID_FieldInfo = 'fiel',
   /* FieldInfoImageDescriptionExtension2,
   Read/Write */
   /*
   * The offset in bytes from the start of one row to the next. Only
   * valid if the codec type is a chunky pixel format.
   */
 //  kICMImageDescriptionPropertyID_RowBytes = 'rowb',
   /* SInt32,
   Read/Write */
   /*
   * A track width suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
  // kICMImageDescriptionPropertyID_ClassicTrackWidth = 'claw',
   /* Fixed,
   Read */
   /*
   * A track height suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
  // kICMImageDescriptionPropertyID_ClassicTrackHeight = 'clah' /* Fixed,
 //  Read */
//};
//enum {
   /*
   * In this pass the compressor shall output encoded frames.
   */
  // kICMCompressionPassMode_OutputEncodedFrames = 1L << 0,
   /*
   * In this pass the client need not provide source frame buffers.
   */
   //kICMCompressionPassMode_NoSourceFrames = 1L << 1,
   /*
   * In this pass the compressor may write private data to multipass
   * storage.
   */
 //  kICMCompressionPassMode_WriteToMultiPassStorage = 1L << 2,
   /*
   * In this pass the compressor may read private data from multipass
   * storage.
   */
  // kICMCompressionPassMode_ReadFromMultiPassStorage = 1L << 3,
   /*
   * The compressor will set this flag to indicate that it will not be
   * able to output encoded frames in the coming pass. If this flag is
   * not set,
   then the client is allowed to set the
   * kICMCompressionPassMode_OutputEncodedFrames flag before calling
   * ICMCompressionSessionBeginPass.
   */
  // kICMCompressionPassMode_NotReadyToOutputEncodedFrames = 1L << 4
//};
//enum {
   /*
   * Indicates that this is the last call for this sourceFrameRefCon.
   */
  // kICMSourceTracking_LastCall   = 1L << 0,
   /*
   * Indicates that the session is done with the source pixel buffer
   * and has released any reference to it that it had.
   */
  // kICMSourceTracking_ReleasedPixelBuffer = 1L << 1,
   /*
   * Indicates that this frame was encoded.
   */
  // kICMSourceTracking_FrameWasEncoded = 1L << 2,
   /*
   * Indicates that this frame was dropped.
   */
   //kICMSourceTracking_FrameWasDropped = 1L << 3,
   /*
   * Indicates that this frame was merged into other frames.
   */
  // kICMSourceTracking_FrameWasMerged = 1L << 4,
   /*
   * Indicates that the time stamp of this frame was modified.
   */
 //  kICMSourceTracking_FrameTimeWasChanged = 1L << 5,
   /*
   * Indicates that the ICM has copied the image from the source pixel
   * buffer into another pixel buffer because the source pixel buffer
   * was not compatible with the compressor's required pixel buffer
   * attributes.
   */
 //  kICMSourceTracking_CopiedPixelBuffer = 1L << 6
//};
//enum {
   /*
   * The full width and height of source frames shall be scaled to the
   * full width and height of the destination. This is the default if
   * no other scaling mode is specified.
   */
//   kICMScalingMode_StretchProductionAperture = 'sp2p',
   /*
   * The clean aperture of the source frames shall be scaled to the
   * clean aperture of the destination.
   */
//   kICMScalingMode_StretchCleanAperture = 'sc2c',
   /*
   * The clean aperture of the source frames shall be scaled to fit
   * inside the clean aperture of the destination,
   preserving the
   * original display aspect ratio. If the display aspect ratios are
   * different,
   the source frames will be centered with black bars
   * above and below,
   or to the left and right.
   */
 //  kICMScalingMode_Letterbox     = 'lett',
   /*
   * The clean aperture of the source frames shall be scaled to cover
   * the clean aperture of the destination,
   preserving the original
   * display aspect ratio. If the display aspect ratios are different,
   * the source frames will be centered and cropped.
   */
  // kICMScalingMode_Trim          = 'trim'
/*};
Constants
kICMCompressionFrameOptionsPropertyID_ForceKeyFrame

Boolean, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionFrameOptionsPropertyID_FrameType

ICMFrameType, ReadWrite. 

Available in Mac OS X v10.3 and later.
kQTPropertyClass_ICMCompressionSessionOptions

Class identifier for compression session option object properties. Also 'icso'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression

Enables temporal compression of P-frames and B-frames. By default, temporal compression is disabled. Also 'p ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowFrameReordering

Enables frame reordering. To encode B-frames a compressor must reorder frames, which may mean that the order in which they are emitted and stored (the decode order) may be different from the order in which they are presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must enable frame reordering by passing TRUE in this property. Also 'b ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DurationsNeeded

Indicates that durations of emitted frames are needed. If this option is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default, this flag is FALSE, so frames will not be delayed in order to calculate durations. If you pass encoded frames to AddMediaSampleFromEncodedFrame, you must set this flag to TRUE. Also 'need'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval

The maximum interval between key frames, also known as the key frame rate. Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames. This differs from previous practice, in which a key frame rate of zero disabled temporal compression. Also 'kyfr'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges

Enables the compressor to modify frame times, improving its performance. Some compressors are able to identify and coalesce runs of identical frames and emit single frames with longer duration, or emit frames at a different frame rate from the original. By default, this flag is set to FALSE, which forces the compressor to emit one encoded frame for every source frame and to preserve frame display times. This option replaces the practice of having compressors return special high similarity values to indicate that frames can be dropped. Also '+ ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion

Enables the compressor to call the encoded-frame callback from a different thread. By default this option is FALSE, which means that the compressor must call the encoded-frame callback from the same thread as ICMCompressionSessionEncodeFrame and ICMCompressionSessionCompleteFrames. Also 'asok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount

The maximum frame delay count is the maximum number of frames that a compressor is allowed to hold before it must output a compressed frame. This value limits the number of frames that may be held in the compression window. If the maximum frame delay count is M, then before the call to encode frame N returns, frame N-M must have been emitted. The default value is kICMUnlimitedFrameDelayCount, which sets no limit on the compression window. Also 'cwin'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime

TimeValue64, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CompressorComponent

Sets a specific compressor component or component instance to be used, or passes one of the wildcards anyCodec, bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. Pass this option to force the Image Compression Manager to use a specific compressor component or compressor component instance. To allow the Image Compression Manager to choose the compressor component, set the compressorComponent to anyCodec (the default), bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. If you pass in a component instance that you opened, the ICM will not close that instance; you must do so after the compression session is released. Also 'imco'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CompressorSettings

A handle containing compressor settings. The compressor will be configured with these settings (by a call to ImageCodecSetSettings) during the ICMCompressionSessionCreate process. Also 'cost'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_Depth

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ColorTable

The color table for compression, used with indexed-color depths. Clients who are passed this property are responsible for disposing the returned CTabHandle. Also 'clut'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_Quality

The compression quality. This value is always used to set the spatial quality; if temporal compression is enabled, it is also used to set temporal quality. The default quality is codecNormalQuality. Also 'qual'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AverageDataRate

The long-term desired average data rate in bytes per second. This is not an absolute limit. The default data rate is zero, indicating that the setting of kICMCompressionSessionOptionsPropertyID_Quality should determine the size of compressed data. Data rate settings have effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'aver'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DataRateLimits

Zero, one, or two hard limits on data rate. Each hard limit is described by a data size in bytes and a duration in seconds. It requires that the total size of compressed data for any contiguous segment of that duration (in decode time) must not exceed the data size. By default, no data rate limits are set. When setting this property, the inPropValueSize parameter should be the number of data rate limits multiplied by sizeof(ICMDataRateLimit). Data rate settings have an effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'hard'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DataRateLimitCount

UInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits

UInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_WasCompressed

Indicates that the source was previously compressed. This property is an optional information hint to the compressor; by default it is FALSE. Also 'wasc'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CPUTimeBudget

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MultiPassStorage

A multipass compression client must provide a storage location for multipass data. Pass ICMMultiPassStorageCreateWithTemporaryFile to make the ICM store multipass data in a temporary file. Pass ICMMultiPassStorageCreateWithCallbacks to manage the storage yourself. Note that the amount of multipass data to be stored can be substantial; it could be greater than the size of the output movie file. If this property is not NULL, the client must call ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass around groups of calls to ICMCompressionSessionEncodeFrame. By default, this property is NULL and multipass compression is not enabled. The compression session options object retains the multipass storage object when one is set. Also 'imps'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_SourceFrameCount

UInt64, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ScalingMode

OSType, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CleanAperture

Native-endian CleanApertureImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_PixelAspectRatio

Native-endian PixelAspectRatioImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_FieldInfo

FieldInfoImageDescriptionExtension2, ReadWrite. 

Available in Mac OS X v10.3 and later.
kQTPropertyClass_ICMCompressionSession

Class identifier for compression session properties. Also 'icse'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_TimeScale

The time scale for the compression session. Also 'tscl'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes

The compressor's pixel buffer attributes for the compression session. You can use these to create a pixel buffer pool for source pixel buffers. This is not the same as the sourcePixelBufferAttributes property passed to ICMCompressionSessionCreate. Getting this property does not change its retain count. Also 'batt'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_PixelBufferPool

A pool that can provide ideal source pixel buffers for a compression session. The compression session creates this pixel buffer pool based on the compressor's pixel buffer attributes and any pixel buffer attributes passed in to ICMCompressionSessionCreate. If the source pixel buffer attributes and the compressor pixel buffer attributes can not be reconciled, the pool is based on the source pixel buffer attributes and the ICM converts each CVPixelBuffer internally. Also 'pool'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_ImageDescription

The image description for a compression session. For some codecs, the image description may not be available before the first frame is compressed. Multiple calls to retrieve this property will return the same handle. The ICM will dispose of this handle when the compression session is disposed; the caller must not dispose of it. Also 'idsc'.

Available in Mac OS X v10.3 and later.
kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer

CVPixelBufferRef, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired

Boolean, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_DecompressorComponent

DecompressorComponent, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_Accuracy

CodecQ, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_FieldMode

ICMFieldMode, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_MaxBufferCount

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_OutputAheadTime

TimeRecord, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_NonScheduledDisplayTime

ICMNonScheduledDisplayTime, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_PixelBufferPool

CVPixelBufferPoolRef, Read. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared

Boolean, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_EncodedWidth

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_EncodedHeight

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_CleanAperture

Native-endian CleanApertureImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_PixelAspectRatio

Native-endian PixelAspectRatioImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_DisplayWidth

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_DisplayHeight

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ProductionDisplayWidth

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ProductionDisplayHeight

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_NCLCColorInfo

Native-endian NCLCColorInfoImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_GammaLevel

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_FieldInfo

FieldInfoImageDescriptionExtension2, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_RowBytes

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ClassicTrackWidth

Fixed, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ClassicTrackHeight

Fixed, Read. 

Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

enum {
   /*
   * Both fields should be decompressed.
   */
   kICMFieldMode_BothFields      = 0,
   /*
   * Only the top field should be decompressed,
   producing a half-height
   * image.
   */
   kICMFieldMode_TopFieldOnly    = 1,
   /*
   * Only the bottom field should be decompressed,
   producing a
   * half-height image.
   */
   kICMFieldMode_BottomFieldOnly = 2,
   /*
   * Both fields should be decompressed,
   and then filtered to reduce
   * interlacing artifacts.
   */
   kICMFieldMode_DeinterlaceFields = 3
};
enum {
   /*
   * Class identifier for compression frame options object properties.
   */
   kQTPropertyClass_ICMCompressionFrameOptions = 'icfo',
   /*
   * Forces frames to be compressed as key frames.
   * The compressor must obey the "force key frame" flag if set. By
   * default this property is false.
   */
   kICMCompressionFrameOptionsPropertyID_ForceKeyFrame = 'keyf',
   /* Boolean,
   Read/Write */
   /*
   * Requests a frame be compressed as a particular frame type.
   *  The frame type setting may be ignored by the compressor if not
   * appropriate.
   * By default this is set to kICMFrameType_Unknown.
   * Do not assume that kICMFrameType_I means a key frame; if you need
   * a key frame,
   set the "force key frame" property.
   */
   kICMCompressionFrameOptionsPropertyID_FrameType = 'frty' /* ICMFrameType,
   Read/Write */
};
enum {
   /*
   * Class identifier for compression session options object properties.
   */
   kQTPropertyClass_ICMCompressionSessionOptions = 'icso',
   /*
   * Enables temporal compression. By default,
   temporal compression is
   * disabled.
   * IMPORTANT: If you want temporal compression (P frames and/or B
   * frames) you must set this to true.
   */
   kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression = 'p ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables frame reordering.
   * In order to encode B frames,
   a compressor must reorder frames,
   * which means that the order in which they will be emitted and
   * stored (the decode order) is different from the order in which
   * they were presented to the compressor (the display order).
   * By default,
   frame reordering is disabled.
   * IMPORTANT: In order to encode using B frames,
   you must enable
   * frame reordering.
   */
   kICMCompressionSessionOptionsPropertyID_AllowFrameReordering = 'b ok',
   /* Boolean,
   Read/Write */
   /*
   * Indicates that durations of emitted frames are needed.
   * If this flag is set and source frames are provided with times but
   * not durations,
   then frames will be delayed so that durations can
   * be calculated as the difference between one frame's time stamp and
   * the next frame's time stamp.
   * By default,
   this flag is clear,
   so frames will not be delayed in
   * order to calculate durations.
   * IMPORTANT: If you will be passing encoded frames to
   * AddMediaSampleFromEncodedFrame,
   you must set this flag to true.
   */
   kICMCompressionSessionOptionsPropertyID_DurationsNeeded = 'need',
   /* Boolean,
   Read/Write */
   /*
   * The maximum interval between key frames,
   also known as the key
   * frame rate.
   * Key frames,
   also known as sync frames,
   reset inter-frame
   * dependencies; decoding a key frame is sufficient to prepare a
   * decompressor for correctly decoding the difference frames that
   * follow.
   * Compressors are allowed to generate key frames more frequently if
   * this would result in more efficient compression.
   * The default key frame interval is 0,
   which indicates that the
   * compressor should choose where to place all key frames. A key
   * frame interval of 1 indicates that every frame must be a key
   * frame,
   2 indicates that at least every other frame must be a key
   * frame,
   etc.
   */
   kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval = 'kyfr',
   /* SInt32,
   Read/Write */
   /*
   * The requested maximum interval between partial sync frames. If the
   * interval is n,
   any sequence of n successive frames must include at
   * least one key or partial sync frame.
   * Where supported,
   partial sync frames perform a partial reset of
   * inter-frame dependencies; decoding two partial sync frames and the
   * non-droppable difference frames between them is sufficient to
   * prepare a decompressor for correctly decoding the difference
   * frames that follow.
   * Compressors are allowed to generate partial sync frames more
   * frequently if this would result in more efficient compression.
   *
   * The default partial sync frame interval is 0,
   which indicates that
   * the compressor should choose where to place partial sync frames. A
   * partial sync frame interval of 1 means there can be no difference
   * frames,
   so it is equivalent to a key frame interval of 1. A
   * partial sync frame interval of 2 means that every other frame must
   * be a key frame or a partial sync frame.
   * Compressors that do not support partial sync frames will ignore
   * this setting.
   */
   kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval = 'psfr',
   /* SInt32,
   Read/Write */
   /*
   * Enables the compressor to modify frame times.
   * Some compressors are able to identify and coalesce runs of
   * identical frames and output single frames with longer duration,
   or
   * output frames at a different frame rate from the original. This
   * feature is controlled by the "allow frame time changes" flag. By
   * default,
   this flag is set to false,
   which forces compressors to
   * emit one encoded frame for every source frame,
   and to preserve
   * frame display times.
   * (Note: this feature replaces the practice of having compressors
   * return special high similarity values to indicate that frames
   * could be dropped.)
   * If you want to allow the compressor to modify frame times in order
   * to improve compression performance,
   enable frame time changes.
   */
   kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges = '+ ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables the compressor to call the encoded-frame callback from a
   * different thread.
   * By default,
   the flag is false,
   which means that the compressor
   * must call the encoded-frame callback from the same thread that
   * ICMCompressionSessionEncodeFrame and
   * ICMCompressionSessionCompleteFrames were called on.
   */
   kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion = 'asok',
   /* Boolean,
   Read/Write */
   /*
   * The maximum frame delay count is the maximum number of frames that
   * a compressor is allowed to hold before it must output a compressed
   * frame. It limits the number of frames that may be held in the
   * "compression window". If the maximum frame delay count is M,
   then
   * before the call to encode frame N returns,
   frame N-M must have
   * been emitted.
   * The default is kICMUnlimitedFrameDelayCount,
   which sets no limit
   * on the compression window.
   */
   kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount = 'cwin',
   /* SInt32,
   Read/Write */
   /*
   * The maximum frame delay time is the maximum difference between a
   * source frame's display time and the corresponding encoded frame's
   * decode time. It limits the span of display time that may be held
   * in the "compression window". If the maximum frame delay time is
   * TM,
   then before the call to encode a frame with display time TN
   * returns,
   all frames with display times up to and including TN-TM
   * must have been emitted.
   * The default is kICMUnlimitedFrameDelayTime,
   which sets no time
   * limit on the compression window.
   */
   kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime = 'cwit',
   /* TimeValue64,
   Read/Write */
   /*
   * Sets a specific compressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * Use this API to force the Image Compression Manager to use a
   * specific compressor component or compressor component instance.
   * (If you pass in a component instance that you opened,
   the ICM will
   * not close that instance; you must do so after the compression
   * session is released.) To allow the Image Compression Manager to
   * choose the compressor component,
   set the compressorComponent to
   * anyCodec (the default),
   bestSpeedCodec,
   bestFidelityCodec or
   * bestCompressionCodec.
   */
   kICMCompressionSessionOptionsPropertyID_CompressorComponent = 'imco',
   /* CompressorComponent,
   Read/Write */
   /*
   * A handle containing compressor settings. The compressor will be
   * configured with these settings (by a call to
   * ImageCodecSetSettings) during ICMCompressionSessionCreate.
   */
   kICMCompressionSessionOptionsPropertyID_CompressorSettings = 'cost',
   /* Handle,
   Read/Write */
   /*
   * The depth for compression.
   * If a compressor does not support a specific depth,
   the closest
   * supported depth will be used (preferring deeper depths to
   * shallower depths). The default depth is k24RGBPixelFormat.
   */
   kICMCompressionSessionOptionsPropertyID_Depth = 'deep',
   /* UInt32,
   Read/Write */
   /*
   * The color table for compression.  Used with indexed-color depths.
   *
   * Clients who get this property are responsible for disposing the
   * returned CTabHandle.
   */
   kICMCompressionSessionOptionsPropertyID_ColorTable = 'clut',
   /* CTabHandle,
   Read/Write*/
   /*
   * The compression quality.
   * This value is always used to set the spatialQuality; if temporal
   * compression is enabled,
   it is also used to set temporalQuality.
   * <BR> The default quality is codecNormalQuality.
   */
   kICMCompressionSessionOptionsPropertyID_Quality = 'qual',
   /* CodecQ,
   Read/Write */
   /*
   * The long-term desired average data rate in bytes per second.
   *  This is not a hard limit.
   * The default data rate is zero,
   which indicates that the quality
   * setting should determine the size of compressed data.
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
   kICMCompressionSessionOptionsPropertyID_AverageDataRate = 'aver',
   /* SInt32,
   Read/Write */
   /*
   * Zero,
   one or two hard limits on data rate.
   * Each hard limit is described by a data size in bytes and a
   * duration in seconds,
   and requires that the total size of
   * compressed data for any contiguous segment of that duration (in
   * decode time) must not exceed the data size.
   * By default,
   no data rate limits are set.
   * When setting this property,
   the inPropValueSize parameter should
   * be the number of data rate limits multiplied by
   * sizeof(ICMDataRateLimit).
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
   kICMCompressionSessionOptionsPropertyID_DataRateLimits = 'hard',
   /* C array of ICMDataRateLimit struct,
   Read/Write */
   /*
   * The current number of data rate limits.
   */
   kICMCompressionSessionOptionsPropertyID_DataRateLimitCount = 'har#',
   /* UInt32,
   Read */
   /*
   * The maximum allowed number of data rate limits.  (Currently 2.)
   */
   kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits = 'mhar',
   /* UInt32,
   Read */
   /*
   * Indicates that the source was previously compressed.
   * This property is purely an optional,
   informational hint to the
   * compressor; by default it is false.
   */
   kICMCompressionSessionOptionsPropertyID_WasCompressed = 'wasc',
   /* Boolean,
   Read/Write */
   /*
   * Recommends a CPU time budget for the compressor in microseconds
   * per frame.
   * Zero means to go as fast as possible.
   * By default,
   this is set to kICMUnlimitedCPUTimeBudget,
   which sets
   * no limit.
   * This is an advisory hint to the compressor,
   and some compressors
   * may ignore it. Multithreaded compressors may use this amount of
   * CPU time on each processor.
   * Compressors should not feel compelled to use the full time budget
   * if they complete ahead of time!
   */
   kICMCompressionSessionOptionsPropertyID_CPUTimeBudget = 'cput',
   /* UInt32,
   Read/Write */
   /*
   * Storage for multi-pass compression.
   * To enable multipass compression,
   the client must provide a storage
   * location for multipass data.  Use
   * ICMMultiPassStorageCreateWithTemporaryFile to have the ICM store
   * it in a temporary file.  Use
   * ICMMultiPassStorageCreateWithCallbacks to manage the storage
   * yourself.
   * Note that the amount of multipass data to be stored can be
   * substantial; it could be greater than the size of the output movie
   * file.
   * If this property is not NULL,
   the client must call
   * ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass
   * around groups of calls to ICMCompressionSessionEncodeFrame.
   *  By default,
   this property is NULL and multipass compression is
   * not enabled. The compression session options object retains the
   * multipass storage object,
   when one is set.
   */
   kICMCompressionSessionOptionsPropertyID_MultiPassStorage = 'imps',
   /* ICMMultiPassStorageRef,
   Read/Write */
   /*
   * Indicates the number of source frames,
   if known. If nonzero,
   this
   * should be the exact number of times that the client calls
   * ICMCompressionSessionEncodeFrame in each pass.
   * The default is 0,
   which indicates that the number of source frames
   * is not known.
   */
   kICMCompressionSessionOptionsPropertyID_SourceFrameCount = 'frco',
   /* UInt64,
   Read/Write */
   /*
   * Indicates the expected frame rate,
   if known. The frame rate is
   * measured in frames per second. This is not used to control the
   * frame rate; it is provided as a hint to the compressor so that it
   * can set up internal configuration before compression begins. The
   * actual frame rate will depend on frame durations and may vary. By
   * default,
   this is zero,
   indicating "unknown".
   */
   kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate = 'fran',
   /* Fixed,
   Read/Write */
   /*
   * Indicates how source frames to a compression session should be
   * scaled if the dimensions and/or display aspect ratio do not match.
   */
   kICMCompressionSessionOptionsPropertyID_ScalingMode = 'scam',
   /* OSType,
   Read/Write */
   /*
   * Describes the clean aperture for compressed frames. Note that if
   * the compressor enforces a clean aperture,
   it will override this
   * setting. The clean aperture will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio for compressed frames. Note that
   * if the compressor enforces a pixel aspect ratio,
   it will override
   * this setting. The pixel aspect ratio will be set on the output
   * image description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the number and order of fields for compressed frames.
   * Note that if the compressor enforces field info,
   it will override
   * this setting. The field info will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_FieldInfo = 'fiel' /* FieldInfoImageDescriptionExtension2,
   Read/Write */
};
enum {
   /*
   * Class identifier for compression session properties.
   */
   kQTPropertyClass_ICMCompressionSession = 'icse',
   /*
   * The time scale for the compression session.
   */
   kICMCompressionSessionPropertyID_TimeScale = 'tscl',
   /* TimeScale,
   Read */
   /*
   * The compressor's pixel buffer attributes for the compression
   * session. You can use these to create a pixel buffer pool for
   * source pixel buffers. Note that this is not the same as the
   * sourcePixelBufferAttributes passed in to
   * ICMCompressionSessionCreate. Getting this property does not change
   * its retain count.
   */
   kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes = 'batt',
   /* CFDictionaryRef,
   Read */
   /*
   * A pool that can provide ideal source pixel buffers for a
   * compression session. The compression session creates this pixel
   * buffer pool based on the compressor's pixel buffer attributes and
   * any pixel buffer attributes passed in to
   * ICMCompressionSessionCreate. If the source pixel buffer attributes
   * and the compressor pixel buffer attributes can not be reconciled,
   * the pool is based on the source pixel buffer attributes and the
   * ICM converts each CVPixelBuffer internally.
   */
   kICMCompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * The image description for the compression session. For some
   * codecs,
   the image description may not be available before the
   * first frame is compressed. Multiple calls to retrieve this
   * property will return the same handle. The ICM will dispose this
   * handle when the compression session is disposed.
   * IMPORTANT: The caller must NOT dispose this handle.
   */
   kICMCompressionSessionPropertyID_ImageDescription = 'idsc' /* ImageDescriptionHandle,
   Read */
};
enum {
   /*
   * Class identifier for decompression frame options object properties.
   */
   kQTPropertyClass_ICMDecompressionFrameOptions = 'idfo',
   /*
   * A specific pixel buffer that the frame should be decompressed
   * into. Setting this circumvents the pixel buffer pool mechanism. If
   * this buffer is not compatible with the codec's pixel buffer
   * requirements,
   decompression will fail.
   */
   kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer = 'cvpb' /* CVPixelBufferRef,
   Read/Write */
};
enum {
   /*
   * Class identifier for decompression session options object
   * properties.
   */
   kQTPropertyClass_ICMDecompressionSessionOptions = 'idso',
   /*
   * By default,
   this is true,
   meaning that frames must be output in
   * display order. Set this to false to allow frames to be output in
   * decode order rather than in display order.
   */
   kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired = 'dorq',
   /* Boolean,
   Read/Write */
   /*
   * A specific decompressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * By default,
   this is anyCodec.
   */
   kICMDecompressionSessionOptionsPropertyID_DecompressorComponent = 'imdc',
   /* DecompressorComponent,
   Read/Write */
   /*
   * The decompression accuracy.
   * The default accuracy is codecNormalQuality.
   */
   kICMDecompressionSessionOptionsPropertyID_Accuracy = 'acur',
   /* CodecQ,
   Read/Write */
   /*
   * Requests special handling of fields. Not all codecs will obey this
   * request; some codecs will only handle it at certain accuracy
   * levels. Ignored for non-interlaced content.
   */
   kICMDecompressionSessionOptionsPropertyID_FieldMode = 'fiel',
   /* ICMFieldMode,
   Read/Write */
   /*
   * The maximum number of buffers ahead of the current time that
   * should be decompressed. Used in sessions that target visual
   * contexts. By default,
   the number of buffers will be determined
   * from the visual context.
   */
   kICMDecompressionSessionOptionsPropertyID_MaxBufferCount = 'm#bf',
   /* UInt32,
   Read/Write */
   /*
   * The minimum time ahead of the current time that frames should be
   * decompressed. Used in sessions that target visual contexts. By
   * default,
   the output-ahead time will be determined from the visual
   * context.
   */
   kICMDecompressionSessionOptionsPropertyID_OutputAheadTime = 'futu' /* TimeRecord,
   Read/Write */
};
enum {
   /*
   * Class identifier for decompression session properties.
   */
   kQTPropertyClass_ICMDecompressionSession = 'icds',
   /*
   * The non-scheduled display time for a decompression session.
   * Setting this requests display of the non-scheduled queued frame at
   * that display time,
   if there is one.
   * See ICMDecompressionSessionSetNonScheduledDisplayTime.
   */
   kICMDecompressionSessionPropertyID_NonScheduledDisplayTime = 'nsti',
   /* ICMNonScheduledDisplayTime,
   Read/Write */
   /*
   * The direction for non-scheduled display time.
   * See ICMDecompressionSessionSetNonScheduledDisplayDirection.
   */
   kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection = 'nsdu',
   /* Fixed,
   Read/Write */
   /*
   * The pixel buffer pool from which emitted pixel buffers are
   * allocated. Getting this does not change the retain count of the
   * pool.
   */
   kICMDecompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * Indicates whether the a common pixel buffer pool is shared between
   * the decompressor and the session client. This is false if separate
   * pools are used because the decompressor's and the client's pixel
   * buffer attributes were incompatible.
   */
   kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared = 'plsh' /* Boolean,
   Read */
};
enum {
   /*
   * Class identifier for image description properties.
   */
   kQTPropertyClass_ImageDescription = 'idsc',
   /*
   * The width of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's width field.
   */
   kICMImageDescriptionPropertyID_EncodedWidth = 'encw',
   /* SInt32,
   Read/Write */
   /*
   * The height of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's height field.
   */
   kICMImageDescriptionPropertyID_EncodedHeight = 'ench',
   /* SInt32,
   Read/Write */
   /*
   * Describes the clean aperture of the buffer. If not specified
   * explicitly in the image description,
   the default clean aperture
   * (full encoded width and height) will be returned.
   */
   kICMImageDescriptionPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio. If not specified explicitly in
   * the image description,
   a square (1:1) pixel aspect ratio will be
   * returned.
   */
   kICMImageDescriptionPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * A width at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
   kICMImageDescriptionPropertyID_DisplayWidth = 'disw',
   /* SInt32,
   Read */
   /*
   * A height at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
   kICMImageDescriptionPropertyID_DisplayHeight = 'dish',
   /* SInt32,
   Read */
   /*
   * A width at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayWidth instead.
   */
   kICMImageDescriptionPropertyID_ProductionDisplayWidth = 'pdsw',
   /* SInt32,
   Read */
   /*
   * A height at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayHeight instead.
   */
   kICMImageDescriptionPropertyID_ProductionDisplayHeight = 'pdsh',
   /* SInt32,
   Read */
   /*
   * Color information,
   if available in the
   * NCLCColorInfoImageDescriptionExtension format.
   */
   kICMImageDescriptionPropertyID_NCLCColorInfo = 'nclc',
   /* Native-endian NCLCColorInfoImageDescriptionExtension,
   Read/Write */
   /*
   * The gamma level described by the image description.
   */
   kICMImageDescriptionPropertyID_GammaLevel = 'gama',
   /* Fixed,
   Read/Write */
   /*
   * Information about the number and order of fields,
   if available.
   */
   kICMImageDescriptionPropertyID_FieldInfo = 'fiel',
   /* FieldInfoImageDescriptionExtension2,
   Read/Write */
   /*
   * The offset in bytes from the start of one row to the next. Only
   * valid if the codec type is a chunky pixel format.
   */
   kICMImageDescriptionPropertyID_RowBytes = 'rowb',
   /* SInt32,
   Read/Write */
   /*
   * A track width suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
   kICMImageDescriptionPropertyID_ClassicTrackWidth = 'claw',
   /* Fixed,
   Read */
   /*
   * A track height suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
   kICMImageDescriptionPropertyID_ClassicTrackHeight = 'clah' /* Fixed,
   Read */
};
enum {
   /*
   * In this pass the compressor shall output encoded frames.
   */
   kICMCompressionPassMode_OutputEncodedFrames = 1L << 0,
   /*
   * In this pass the client need not provide source frame buffers.
   */
   kICMCompressionPassMode_NoSourceFrames = 1L << 1,
   /*
   * In this pass the compressor may write private data to multipass
   * storage.
   */
   kICMCompressionPassMode_WriteToMultiPassStorage = 1L << 2,
   /*
   * In this pass the compressor may read private data from multipass
   * storage.
   */
   kICMCompressionPassMode_ReadFromMultiPassStorage = 1L << 3,
   /*
   * The compressor will set this flag to indicate that it will not be
   * able to output encoded frames in the coming pass. If this flag is
   * not set,
   then the client is allowed to set the
   * kICMCompressionPassMode_OutputEncodedFrames flag before calling
   * ICMCompressionSessionBeginPass.
   */
   kICMCompressionPassMode_NotReadyToOutputEncodedFrames = 1L << 4
};
enum {
   /*
   * Indicates that this is the last call for this sourceFrameRefCon.
   */
   kICMSourceTracking_LastCall   = 1L << 0,
   /*
   * Indicates that the session is done with the source pixel buffer
   * and has released any reference to it that it had.
   */
   kICMSourceTracking_ReleasedPixelBuffer = 1L << 1,
   /*
   * Indicates that this frame was encoded.
   */
   kICMSourceTracking_FrameWasEncoded = 1L << 2,
   /*
   * Indicates that this frame was dropped.
   */
   kICMSourceTracking_FrameWasDropped = 1L << 3,
   /*
   * Indicates that this frame was merged into other frames.
   */
   kICMSourceTracking_FrameWasMerged = 1L << 4,
   /*
   * Indicates that the time stamp of this frame was modified.
   */
   kICMSourceTracking_FrameTimeWasChanged = 1L << 5,
   /*
   * Indicates that the ICM has copied the image from the source pixel
   * buffer into another pixel buffer because the source pixel buffer
   * was not compatible with the compressor's required pixel buffer
   * attributes.
   */
   kICMSourceTracking_CopiedPixelBuffer = 1L << 6
};
enum {
   /*
   * The full width and height of source frames shall be scaled to the
   * full width and height of the destination. This is the default if
   * no other scaling mode is specified.
   */
   kICMScalingMode_StretchProductionAperture = 'sp2p',
   /*
   * The clean aperture of the source frames shall be scaled to the
   * clean aperture of the destination.
   */
   kICMScalingMode_StretchCleanAperture = 'sc2c',
   /*
   * The clean aperture of the source frames shall be scaled to fit
   * inside the clean aperture of the destination,
   preserving the
   * original display aspect ratio. If the display aspect ratios are
   * different,
   the source frames will be centered with black bars
   * above and below,
   or to the left and right.
   */
   kICMScalingMode_Letterbox     = 'lett',
   /*
   * The clean aperture of the source frames shall be scaled to cover
   * the clean aperture of the destination,
   preserving the original
   * display aspect ratio. If the display aspect ratios are different,
   * the source frames will be centered and cropped.
   */
   kICMScalingMode_Trim          = 'trim'
};

/*ICMDecompressionTrackingCallbackRecord

Designates a tracking callback for an ICM decompression session.

struct ICMDecompressionTrackingCallbackRecord {
   ICMDecompressionTrackingCallback    decompressionTrackingCallback;
   void                                *decompressionTrackingRefCon;
};
Fields
decompressionTrackingCallback
Discussion

The callback function pointer. See ICMDecompressionTrackingCallbackProc.
decompressionTrackingRefCon
Discussion

The callback's reference value.
Declared In
ImageCompression.h*/
struct ICMDecompressionTrackingCallbackRecord {
   ICMDecompressionTrackingCallback    decompressionTrackingCallback;
   void                                *decompressionTrackingRefCon;
};
typedef  struct ICMDecompressionTrackingCallbackRecord ICMDecompressionTrackingCallbackRecord;
/*ImageDescriptionPtr

Abst_ImageDescriptionPtr

typedef ImageDescription * ImageDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ImageDescription * ImageDescriptionPtr;

/*ImageDescriptionHandle

Abst_ImageDescriptionHandle

typedef ImageDescriptionPtr * ImageDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ImageDescriptionPtr * ImageDescriptionHandle;

/*ICMFrameTimeRecord

Contains a frame's time information for scheduled asynchronous decompression operations.

struct ICMFrameTimeRecord {
   wide           value;
   long           scale;
   void *         base;
   long           duration;
   Fixed          rate;
   long           recordSize;
   long           frameNumber;
   long           flags;
   wide           virtualStartTime;
   long           virtualDuration;
   TimeValue64    decodeTime;
};
Fields
value
Discussion

Specifies the time at which the frame is to be displayed.
scale
Discussion

Indicates the units for the frame's display time.
base
Discussion

Refers to the time base.
duration
Discussion

Specifies the duration for which the frame is to be displayed. This must be in the same units as specified by the scale field. It is 0 if the duration is unknown.
rate
Discussion

Indicates the time base's effective rate.
recordSize
Discussion

Total number of bytes in this structure.
frameNumber
Discussion

Number of frame; 0 if the frame number is not known.
flags
Discussion

Flag (see below) to indicate if virtualStartTime and virtualDuration are valid. See these constants: 
icmFrameTimeHasVirtualStartTimeAndDuration
icmFrameTimeHasDecodeTime
virtualStartTime
Discussion

Conceptual start time.
virtualDuration
Discussion

Conceptual duration.
decodeTime
Discussion

Suggested decode time. Valid only if icmFrameTimeHasDecodeTime is set in the flags parameter.
Programming Info
C interface file: ImageCompression.h*/
struct ICMFrameTimeRecord {
   wide           value;
   long           scale;
   void *         base;
   long           duration;
   Fixed          rate;
   long           recordSize;
   long           frameNumber;
   long           flags;
   wide           virtualStartTime;
   long           virtualDuration;
   TimeValue64    decodeTime;
};
typedef  struct ICMFrameTimeRecord ICMFrameTimeRecord;
typedef ICMFrameTimeRecord *ICMFrameTimePtr; //hys

/*Component Property IDs and Flags

Constants that contain the flags and IDs of component properties.

uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0
kCallComponentExecuteWiredActionSelect     = -9
kComponentPropertyFlagCanSetLater = (1L << 0)
kComponentPropertyFlagCanSetNow = (1L << 1)
kComponentPropertyFlagCanGetNow = (1L << 3)
kComponentPropertyFlagHasExtendedInfo = (1L << 4)
kComponentPropertyFlagValueMustBeReleased = (1L << 5)
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6)
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7)
kQTComponentPropertyListenerCollectionContextVersion = 1
kQTGetComponentPropertyInfoSelect          = -11
kQTGetComponentPropertySelect              = -12
kQTSetComponentPropertySelect              = -13
kQTAddComponentPropertyListenerSelect      = -14
kQTRemoveComponentPropertyListenerSelect   = -15*/
enum {
uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0,
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0,
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0,
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0,
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0,
kCallComponentExecuteWiredActionSelect     = -9,
kComponentPropertyFlagCanSetLater = (1L << 0),
kComponentPropertyFlagCanSetNow = (1L << 1),
kComponentPropertyFlagCanGetNow = (1L << 3),
kComponentPropertyFlagHasExtendedInfo = (1L << 4),
kComponentPropertyFlagValueMustBeReleased = (1L << 5),
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6),
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7),
kQTComponentPropertyListenerCollectionContextVersion = 1,
kQTGetComponentPropertyInfoSelect          = -11,
kQTGetComponentPropertySelect              = -12,
kQTSetComponentPropertySelect              = -13,
kQTAddComponentPropertyListenerSelect      = -14,
kQTRemoveComponentPropertyListenerSelect   = -15,
};

/*QTSetComponentProperty Values

Constants passed to QTSetComponentProperty.

enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};
Constants
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache. 

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all. 

Available in Mac OS X v10.3 and later.
kComponentPropertyClassPropertyInfo

A QTComponentPropertyInfo structure that defines a property information class. Also 'pnfo'.

Available in Mac OS X v10.3 and later.
kComponentPropertyInfoList

An array of QTComponentPropertyInfo structures, one for each property. Also 'list'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheSeed

A component property cache seed value. Also 'seed'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlags

One of the following two flags: Also 'flgs'.

Available in Mac OS X v10.3 and later.*/
enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};

/*VDSetCompression Values

Constants passed to VDSetCompression.

enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};
Constants
codecLosslessQuality

Lossless compression or decompression. This special value is valid only for components that can support lossless compression or decompression. 

Available in Mac OS X v10.0 and later.
codecMaxQuality

The maximum standard value. 

Available in Mac OS X v10.0 and later.
codecMinQuality

The minimum valid value. 

Available in Mac OS X v10.0 and later.
codecLowQuality

Low-quality image reproduction. This value should correspond to the lowest image quality that still results in acceptable display characteristics. 

Available in Mac OS X v10.0 and later.
codecNormalQuality

Image reproduction of normal quality. 

Available in Mac OS X v10.0 and later.*/
enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};

/*CodecQ

Abst_CodecQ

typedef unsigned long CodecQ;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long CodecQ;

/*ICMDataProc

Supplies compressed data during a decompression operation.

typedef OSErr (*ICMDataProcPtr) (Ptr *dataP, long bytesNeeded, long refcon);

If you name your function MyICMDataProc, you would declare it this way:

OSErr MyICMDataProc (
   Ptr     *dataP,
   long    bytesNeeded,
   long    refcon );
Parameters
dataP

Contains a pointer to the address of the data buffer. The decompressor uses this parameter to indicate where your data-loading function should return the compressed data. You establish this data buffer when you start the decompression operation. For example, the data parameter to FDecompressImage defines the location of the data buffer for that operation. Upon return from your data-loading function, this pointer should refer to the beginning of the compressed data that you loaded. The decompressor may also use this parameter to indicate that it wants to reset the mark within the compressed data stream. If the dataP parameter is set to NIL, the bytesNeeded parameter contains the new mark position, relative to the current position of the data stream. If your data-loading function does not support this operation, return a nonzero result code.
bytesNeeded

Specifies the number of bytes requested or the new mark offset. If the decompressor has requested additional compressed data (that is, the value of the dataP parameter is not NIL), then this parameter specifies how many bytes to return. This value never exceeds the size of the original data buffer. Your data-loading function should read the data from the current mark in the input data stream. If the decompressor has requested to set a new mark position in the data stream (that is, the value of the dataP parameter is NIL), then this parameter specifies the new mark position relative to the current position of the data stream.
refcon

Contains a reference constant value for use by your data-loading function. Your application specifies the value of this reference constant in the data-loading function structure you pass to the Image Compression Manager.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
ImageCompression.h*/
typedef OSErr (*ICMDataProcPtr) (Ptr *dataP, long bytesNeeded, long refcon);

/*ICMDataUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMDataProcPtr) ICMDataUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMDataProcPtr) ICMDataUPP;

/*ICMDataProcRecord

Specifies an image compression data-loading function.

struct ICMDataProcRecord {
   ICMDataUPP    dataProc;
   long          dataRefCon;
};
Fields
dataProc
Discussion

Contains a pointer to your data-loading function.
dataRefCon
Discussion

Contains a reference constant for use by your data-loading function.
Discussion

If there is no data-loading function, the Image Compression Manager sets the dataProc field to NIL, and the entire image must be in memory at the location specified by the codecData field of the ImageSubCodecDecompressRecord structure.
Related Functions
FDecompressImage
GetCompressedImageSize
GetCompressedPixMapInfo
ImageCodecGetCompressedImageSize
ImageCodecTrimImage
SetCompressedPixMapInfo
SetDSequenceDataProc
TrimImage 
Programming Info
C interface file: ImageCompression.h*/
struct ICMDataProcRecord {
   ICMDataUPP    dataProc;
   long          dataRefCon;
};
typedef struct ICMDataProcRecord ICMDataProcRecord;

/*CodecInfo

Describes the capabilities of a compressor.

struct CodecInfo {
   Str31             typeName;
   short             version;
   short             revisionLevel;
   long              vendor;
   long              decompressFlags;
   long              compressFlags;
   long              formatFlags;
   UInt8             compressionAccuracy;
   UInt8             decompressionAccuracy;
   unsigned short    compressionSpeed;
   unsigned short    decompressionSpeed;
   UInt8             compressionLevel;
   UInt8             resvd;
   short             minimumHeight;
   short             minimumWidth;
   short             decompressPipelineLatency;
   short             compressPipelineLatency;
   long              privateData;
};
Fields
typeName
Discussion

Indicates the compression algorithm used by the component; for example, 'Animation'. This Pascal string may be used to identify the compression algorithm to the user. The string always takes up 32 bytes no matter how long it is. The 32 bytes consist of 31 bytes plus one length byte. Apple assigns these type names. The value of this field should correspond to the value of the typeName field in the appropriate compressor name structure returned by GetCodecNameList.
version
Discussion

Indicates the version of compressed data this component supports. The contents of this field should indicate the most recent version of the compression algorithm that the component can understand.
revisionLevel
Discussion

Indicates the version of the component; for example, 0x00010001 (1.0.1). Developers of compressors assign these version numbers.
vendor
Discussion

Identifies the developer of the component; for example, 'appl'. The value of this field corresponds to the manufacturer code or application signature assigned to the developer.
decompressFlags
Discussion

Contains flags (see below) that specify the decompression capabilities of the component. Typically, these flags are of interest only to developers of image decompressors. See these constants: 
codecInfoDoes1
codecInfoDoes2
codecInfoDoes4
codecInfoDoes8
codecInfoDoes16
codecInfoDoes32
codecInfoDoesDither
codecInfoDoesStretch
codecInfoDoesShrink
codecInfoDoesMask
codecInfoDoesTemporal
codecInfoDoesDouble
codecInfoDoesQuad
codecInfoDoesHalf
codecInfoDoesQuarter
codecInfoDoesRotate
codecInfoDoesHorizFlip
codecInfoDoesVertFlip
codecInfoHasEffectParameterList
codecInfoDoesBlend
codecInfoDoesWarp
codecInfoDoesRecompress
codecInfoDoesSpool
codecInfoDoesRateConstrain
compressFlags
Discussion

Contains flags (see below) that specify the compression capabilities of the component. Typically, these flags are of interest only to developers of image compressors.
formatFlags
Discussion

Contains flags (see below) that describe the possible format for compressed data produced by this component and the format of compressed files that the component can handle during decompression. Typically, these flags are of interest only to developers of compressor components. See these constants: 
codecInfoDepth1
codecInfoDepth2
codecInfoDepth4
codecInfoDepth8
codecInfoDepth16
codecInfoDepth24
codecInfoDepth32
codecInfoDepth33
codecInfoDepth34
codecInfoDepth36
codecInfoDepth40
codecInfoStoresClut
codecInfoDoesLossless
codecInfoSequenceSensitive
compressionAccuracy
Discussion

Indicates the relative accuracy of the compression algorithm employed by the component. Valid values for this field range from 0 to 255. A value of 0 means that the accuracy is unknown. Values from 1 to 255 provide a gauge for the relative accuracy of the compression algorithm; higher values indicate better accuracy. The Image Compression Manager examines this field to determine which compressor component can most accurately compress a given image. The compressionAccuracy field can only approximate the accuracy of a compression algorithm. Typically, compression algorithms produce results of varying quality based on a variety of parameters, including image size and content. Since this information is not available until a compression request is issued, a precise measure of accuracy is not possible. However, the value of this field should still give a rough idea of the accuracy of the supported algorithm.
decompressionAccuracy
Discussion

Indicates the relative accuracy of the decompression algorithm employed by the component. Valid values for this field range from 0 to 255. A value of 0 means that the accuracy is unknown. Values from 1 to 255 indicate the relative accuracy of the decompression technique; higher values mean better accuracy. The Image Compression Manager examines this field to determine which decompressor component can most accurately decompress a given image. The decompressionAccuracy field can only approximate the accuracy of a decompression algorithm. Typically, decompression algorithms produce results of varying quality based on a variety of parameters, including image size and content. Since this information is not available until a decompression request is issued, a precise measure of accuracy is not possible. However, the value of this field should still give a rough idea of the accuracy of the supported algorithm.
compressionSpeed
Discussion

Indicates the relative speed of the component for compression operations. Valid values for this field lie in the range from 0 to 65,535. A value of 0 means that the speed is unknown. Values from 1 to 65,535 correspond to the number of milliseconds the component requires to compress a 320-by-240 pixel image on a Macintosh II computer. The Image Compression Manager examines this field to determine which compressor component can most quickly compress a given image.
decompressionSpeed
Discussion

Indicates the relative speed of the component for decompression operations. Valid values for this field lie in the range from 0 to 65,535. A value of 0 means that the speed is unknown. Values from 1 to 65,535 correspond to the number of milliseconds the component requires to decompress a 320-by-240 pixel image on a Macintosh II computer. The Image Compression Manager examines this field to determine which compressor component can most quickly decompress a given image.
compressionLevel
Discussion

Indicates the relative compression achieved by this component. Valid values for this field lie in the range from 0 to 255. A value of 0 means that the compression level is unknown. Values from 1 to 255 map to percentage values of relative compression; lower values mean lesser compression. A value of 1 means no compression (0 percent); a value of 255 means maximum compression (100 percent). The Image Compression Manager examines this field to determine which available compressor component will yield the smallest resulting data for a given image. The compressionLevel field can only approximate the effectiveness of a compression algorithm. Typically, compression algorithms produce results of varying quality based on a variety of parameters, including image size and content. Since this information is not available until a compression request is issued, a precise measure of compression is not possible. However, the value of this field should still give a rough idea of the effectiveness of the supported algorithm.
resvd
Discussion

Reserved; set to 0.
minimumHeight
Discussion

Specifies the height in pixels of the smallest image the component can handle. Together with the minimumWidth field, this field defines the block size for the component. The Image Compression Manager does not issue compression or decompression requests for images smaller than the block size.
minimumWidth
Discussion

Specifies the width in pixels of the smallest image the component can handle. Together with the minimumHeight field, this field defines the block size for the component. The Image Compression Manager does not issue compression or decompression requests for images smaller than the block size.
decompressPipelineLatency
Discussion

Decompression pipeline latency in milliseconds, for asynchronous codecs.
compressPipelineLatency
Discussion

Compression pipeline latency in milliseconds, for asynchronous codecs.
privateData
Discussion

Reserved for future use. This field must be set to 0.
Discussion

Contains the description of a codec.
Version Notes

The codecInfoHasEffectParameterList constant was formerly codecInfoDoesSkew.
Related Functions
GetCodecInfo
ImageCodecGetCodecInfo 
Programming Info
C interface file: ImageCompression.h*/
struct CodecInfo {
   Str31             typeName;
   short             version;
   short             revisionLevel;
   long              vendor;
   long              decompressFlags;
   long              compressFlags;
   long              formatFlags;
   UInt8             compressionAccuracy;
   UInt8             decompressionAccuracy;
   unsigned short    compressionSpeed;
   unsigned short    decompressionSpeed;
   UInt8             compressionLevel;
   UInt8             resvd;
   short             minimumHeight;
   short             minimumWidth;
   short             decompressPipelineLatency;
   short             compressPipelineLatency;
   long              privateData;
};
typedef struct CodecInfo CodecInfo;

/*CompressorComponent

Abst_CompressorComponent

typedef Component CompressorComponent;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Component CompressorComponent;

/*ICMAlignmentProc

Provides an alignment behavior for windows based on the screen's bit depth.

typedef void (*ICMAlignmentProcPtr) (Rect *rp, long refcon);

If you name your function MyICMAlignmentProc, you would declare it this way:

void MyICMAlignmentProc (
   Rect    *rp,
   long    refcon );
Parameters
rp

Contains a pointer to a rectangle that has already been aligned with a default alignment function.
refcon

Contains a reference constant value for use by your alignment function. Your application specifies the value of this reference constant in the alignment function structure you pass to the Image Compression Manager.
Declared In
ImageCompression.h*/
typedef void (*ICMAlignmentProcPtr) (Rect *rp, long refcon);

/*ICMAlignmentUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMAlignmentProcPtr) ICMAlignmentUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMAlignmentProcPtr) ICMAlignmentUPP;

/*ICMAlignmentProcRecord

Specifies an image compression alignment callback.

struct ICMAlignmentProcRecord {
   ICMAlignmentUPP    alignmentProc;
   long               alignmentRefCon;
};
Fields
alignmentProc
Discussion

Contains a Universal Procedure Pointer that accesses your ICMAlignmentProc callback.
alignmentRefCon
Discussion

Contains a reference constant for use by your callback.
Discussion

This structure defines a pointer to an alignment function. You assign an alignment function by passing a pointer to this structure.
Related Functions
AlignScreenRect
AlignWindow
DragAlignedGrayRgn
DragAlignedWindow
SGGetAlignmentProc 
Programming Info
C interface file: ImageCompression.h*/
struct ICMAlignmentProcRecord {
   ICMAlignmentUPP    alignmentProc;
   long               alignmentRefCon;
};

typedef struct ICMAlignmentProcRecord ICMAlignmentProcRecord;;

/*ICMAlignmentProcRecordPtr

Abst_ICMAlignmentProcRecordPtr

typedef ICMAlignmentProcRecord * ICMAlignmentProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMAlignmentProcRecord * ICMAlignmentProcRecordPtr;

/*ICMFlushProc

Writes compressed data to a storage device during a compression operation.

typedef OSErr (*ICMFlushProcPtr) (Ptr data, long bytesAdded, long refcon);

If you name your function MyICMFlushProc, you would declare it this way:

OSErr MyICMFlushProc (
   Ptr     data,
   long    bytesAdded,
   long    refcon );
Parameters
data

Points to the data buffer. The compressor uses this parameter to indicate where your data-unloading function can find the compressed data. You establish this data buffer when you start the compression operation. For example, the data parameter to FCompressImage defines the location of the data buffer for that operation. This pointer contains a 32-bit clean address. Your ICMFlushProc function should make no other assumptions about the value of this address. The compressor may also use this parameter to indicate that it wants to reset the mark within the compressed data stream. If the data parameter is set to NIL, the bytesNeeded parameter contains the new mark position, relative to the current position of the output data stream. If your ICMFlushProc function does not support this operation, return a nonzero result code.
bytesAdded

Specifies the number of bytes to write or the new mark offset. If the compressor wants to write out some compressed data (that is, the value of data is not NIL), then this parameter specifies how many bytes to write. This value never exceeds the size of the original data buffer. Your ICMFlushProc function should write that data at the current mark in the output data stream. If the compressor has requested to set a new mark position in the output data stream (that is, the value of data is NIL), then this parameter specifies the new mark position relative to the current position of the data stream.
refcon

Contains a reference constant value for use by your ICMFlushProc function. Your application specifies the value of this reference constant in the data-unloading function structure you pass to the Image Compression Manager.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Discussion

You assign an ICMFlushProc function to an image or a sequence by passing a pointer to a structure that identifies the function to the appropriate compression function.
Declared In
ImageCompression.h*/
typedef OSErr (*ICMFlushProcPtr) (Ptr data, long bytesAdded, long refcon);

/*ICMFlushUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMFlushProcPtr) ICMFlushUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMFlushProcPtr) ICMFlushUPP;

/*ICMFlushProcRecord

Specifies an image compression data-unloading callback.

struct ICMFlushProcRecord {
   ICMFlushUPP    flushProc;
   long           flushRefCon;
};
Fields
flushProc
Discussion

Contains a pointer to your data-unloading function.
flushRefCon
Discussion

Contains a reference constant for use by your data-unloading function.
Discussion

If there is not enough memory to store a compressed image, your application may provide a function that unloads some of the compressed data. This field contains a structure that identifies that data-unloading function. If the application did not provide a data-unloading function, the flushProc field in this structure is set to NIL. In this case, your component writes the entire compressed image into the memory location specified by the data field
Related Functions
FCompressImage
ImageCodecTrimImage
SetCSequenceFlushProc
TrimImage 
Programming Info
C interface file: ImageCompression.h*/
struct ICMFlushProcRecord {
   ICMFlushUPP    flushProc;
   long           flushRefCon;
};
typedef struct ICMFlushProcRecord ICMFlushProcRecord;

/*ICMFlushProcRecordPtr

Abst_ICMFlushProcRecordPtr

typedef ICMFlushProcRecord * ICMFlushProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMFlushProcRecord * ICMFlushProcRecordPtr;

/*ICMMemoryDisposedProc

Called before disposing of the memory allocated by a codec.

typedef void (*ICMMemoryDisposedProcPtr) (Ptr memoryBlock, void *refcon);

If you name your function MyICMMemoryDisposedProc, you would declare it this way:

void MyICMMemoryDisposedProc (
   Ptr     memoryBlock,
   void    *refcon );
Parameters
memoryBlock

Pointer to a block of memory.
refcon

Contains a reference constant value that your codec must pass to the memoryGoneProc function.
Discussion

This function must be called if the memory block is to be disposed of by the codec instead of by ImageCodecDisposeMemory. For example, this would occur if the codec is closed and still has memory allocation outstanding or if the memory is required to complete another operation.
Special Considerations

The Image Compression Manager does not currently track memory allocations. When a compressor or decompressor component instance is closed, it must ensure that all blocks allocated by that instance are disposed and call your ICMMemoryDisposedProc. This callback must not be called at interrupt time.
See Also

See the CDSequenceNewMemory, ImageCodecNewImageBufferMemory, ImageCodecNewMemory, and NewICMMemoryDisposedUPP functions.*/
typedef void (*ICMMemoryDisposedProcPtr) (Ptr memoryBlock, void *refcon);

/*ICMMemoryDisposedUPP

Abst_ICMMemoryDisposedUPP

typedef STACK_UPP_TYPE(ICMMemoryDisposedProcPtr) ICMMemoryDisposedUPP;*/
typedef STACK_UPP_TYPE(ICMMemoryDisposedProcPtr) ICMMemoryDisposedUPP;

/*ICMConvertDataFormatProc

Undocumented

typedef OSErr (*ICMConvertDataFormatProcPtr) (void *refCon, long flags, Handle desiredFormat, Handle sourceDataFormat, void *srcData, long srcDataSize,
void **dstData, long *dstDataSize);

If you name your function MyICMConvertDataFormatProc, you would declare it this way:

OSErr MyICMConvertDataFormatProc (
   void      *refCon,
   long      flags,
   Handle    desiredFormat,
   Handle    sourceDataFormat,
   void      *srcData,
   long      srcDataSize,
   void      **dstData,
   long      *dstDataSize );
Parameters
refCon

Pointer to a reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
flags

Undocumented
desiredFormat

Undocumented
sourceDataFormat

Undocumented
srcData

Undocumented
srcDataSize

Undocumented
dstData

Undocumented
dstDataSize

Undocumented
Return Value

See Error Codes. Your callback should return noErr if there is no error.
See Also

See the CDSequenceNewDataSource and NewICMConvertDataFormatUPP functions.*/

typedef OSErr (*ICMConvertDataFormatProcPtr) (void *refCon, long flags, Handle desiredFormat, Handle sourceDataFormat, void *srcData, long srcDataSize,
void **dstData, long *dstDataSize);

/*ICMConvertDataFormatUPP

Abst_ICMConvertDataFormatUPP

typedef STACK_UPP_TYPE(ICMConvertDataFormatProcPtr) ICMConvertDataFormatUPP;*/
typedef STACK_UPP_TYPE(ICMConvertDataFormatProcPtr) ICMConvertDataFormatUPP;

/*StdPixProc

Undocumented

typedef void (*StdPixProcPtr) (PixMap *src, Rect *srcRect, MatrixRecord *matrix, short mode, RgnHandle mask, PixMap *matte, Rect *matteRect,
short flags);

If you name your function MyStdPixProc, you would declare it this way:

void MyStdPixProc (
   PixMap          *src,
   Rect            *srcRect,
   MatrixRecord    *matrix,
   short           mode,
   RgnHandle       mask,
   PixMap          *matte,
   Rect            *matteRect,
   short           flags );
Parameters
src

Undocumented
srcRect

Undocumented
matrix

Undocumented
mode

Undocumented
mask

Undocumented
matte

Undocumented
matteRect

Undocumented
flags

Undocumented
Declared In
ImageCompression.h*/
typedef void (*StdPixProcPtr) (PixMap *src, Rect *srcRect, MatrixRecord *matrix, short mode, RgnHandle mask, PixMap *matte, Rect *matteRect,
short flags);

/*StdPixUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(StdPixProcPtr) StdPixUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(StdPixProcPtr) StdPixUPP;

/*ModalFilterYDProc

Determines how the Dialog Manager filters events.

typedef Boolean (*ModalFilterYDProcPtr) (DialogPtr theDialog, EventRecord *theEvent, short *itemHit, void *yourDataPtr);

If you name your function MyModalFilterYDProc, you would declare it this way:

Boolean MyModalFilterYDProc (
   DialogPtr      theDialog,
   EventRecord    *theEvent,
   short          *itemHit,
   void           *yourDataPtr );
Parameters
theDialog

A pointer to the dialog record.
theEvent

A pointer to the event record.
itemHit

The item number.
yourDataPtr

A pointer to the data received from your application, if any.
Return Value

Your ModalFilterProc callback returns a Boolean value that reports whether it handled the event. If your function returns a value of FALSE, QuickTime processes the event through its own filters. If your function returns a value of TRUE, QuickTime returns with no further action.
Discussion

The ModalFilterProc callback used with custom file dialogs requires the additional yourDataPtr parameter.
Declared In
ImageCompression.h*/
typedef Boolean (*ModalFilterYDProcPtr) (DialogPtr theDialog, EventRecord *theEvent, short *itemHit, void *yourDataPtr);


/*ModalFilterYDUPP

Represents a type used by the Graphics Import and Export API.

typedef STACK_UPP_TYPE(ModalFilterYDProcPtr) ModalFilterYDUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ModalFilterYDProcPtr) ModalFilterYDUPP;

/*ICMPixelFormatInfoPtr

Represents a type used by the Compression and Decompression API.

typedef ICMPixelFormatInfo * ICMPixelFormatInfoPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ICMPixelFormatInfo * ICMPixelFormatInfoPtr;

/*QHdrPtr

Represents a type used by the Compression and Decompression API.

typedef QHdr * QHdrPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef QHdr * QHdrPtr;

#include <APPLE/QuickTime/ImageCompression_E.h>

//Func

/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );

/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );

/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );

/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
typedef QTVisualContextRef QTOpenGLTextureContextRef ;
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );

/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext
);

/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);

/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext
);

/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);

/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );

/*ICMDecompressionSessionRelease

Decrements the retain count of a decompression session.

void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );

/*ICMDecompressionSessionSetNonScheduledDisplayTime

Sets the display time for a decompression session, and requests display of the non-scheduled queued frame at that display time, if there is one.

OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
displayTime

A display time. Usually this is the display time of a non-scheduled queued frame. 
displayTimeScale

The timescale according to which displayTime should be interpreted. 
flags

Reserved; set to 0. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );

/*ICMDecompressionSessionDecodeFrame

Queues a frame for decompression.

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
data

A pointer to the compressed data for this frame. The data must remain in this location until ICMDecompressionTrackingCallbackProc is called with the kICMDecompressionTracking_ReleaseSourceData flag set in decompressionTrackingFlags.
dataSize

The number of bytes of compressed data. You may not pass 0 in this parameter. 
frameOptions

A reference to a frame decompression options object containing options for this frame. You can create this object by calling ICMDecompressionFrameOptionsCreate.
frameTime

A pointer to a structure describing the frame's timing information. 
sourceFrameRefCon

Your reference value for the frame. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );

/*ICMDecompressionSessionOptionsRelease

Decrements the retain count of a decompression session options object.

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );
Parameters
options

A reference to a decompression session options object. This reference is returned by ICMDecompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );

/*ICMDecompressionSessionCreate

Creates a session for decompressing video frames.

OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
desc

An image description for the source frames. 
decompressionOptions

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate. The session will retain the object. You may change some options during the session by modifying the object. You may also pass NULL.
destinationPixelBufferAttributes

Requirements for emitted pixel buffers. You may pass NULL.
trackingCallback

A pointer to a structure that designates a callback to be called for information about queued frames and pixel buffers containing decompressed frames. See ICMDecompressionTrackingCallbackRecord and ICMDecompressionTrackingCallbackProc.
decompressionSessionOut

A pointer to a variable to receive a reference to the new decompression session. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Frames are returned through calls to the callback pointed to by trackingCallback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );

/*ICMDecompressionSessionOptionsCreate

Creates a decompression session options object.

OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a decompression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );

/*ICMImageDescriptionGetProperty

Returns a particular property of a image description handle.

OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inDesc

The image description handle being interrogated.
inPropClass

The class of property being requested.
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

Points to the buffer to receive the property value.
outPropValueSizeUsed

Points to a variable to receive the actual size of returned property value. (This can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns a particular property of a image description handle.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );

/*ICMDecompressionSessionOptionsSetProperty

Sets the value of a specific property of a decompression session options object.

OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );
Parameters
options

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );

/*QTNewGWorld

Creates an offscreen graphics world that may have a non-Macintosh pixel format.

OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this routine.
PixelFormat

The new graphics world's pixel format; see Pixel Formats. This function won't work with planar pixel formats; use QTNewGWorldFromPtr instead. See the ICMPixelFormatInfo structure for a discussion of planar and chunky formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the PixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the PixelFormat parameter. If you set the PixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the PixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the PixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

Constants (see below) that identify options available to your application. You can set a combination of these flags. If you don't wish to use any of them, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, the graphics world uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See these constants: 
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );

/*ICMImageDescriptionSetProperty

Sets a particular property of a image description handle.

OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );
Parameters
inDesc

The image description handle being modified.
inPropClass

The class of property being set.
inPropID

The ID of the property being set.
inPropValueSize

The size of property value.
inPropValueAddress

Points to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );

/*GraphicsImportDraw

Draws an imported image.

ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the image currently in use by the graphics import component to the graphics port and device specified by GraphicsImportSetGWorld. GraphicsImportDraw takes into account all settings previously specified for the image, such as the source rectangle, transformation matrix, clipping region, graphics mode, and image quality.
Special Considerations

The base graphics importer's drawing function uses the results of GraphicsImportGetImageDescription and GraphicsImportGetDataOffsetAndSize to create a decompression sequence, which it uses to draw the image. Subsequent draw operations with the same connection may reuse the decompression sequence. Other graphics importers may override this behavior.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );

/*GraphicsImportSetProgressProc

Installs a progress procedure to call while drawing an imported image.

ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets a progress function that will be installed in the image decompression sequence used to draw the image.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );


/*GraphicsImportSetGWorld

Sets the graphics port and device for drawing an imported image.

ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
port

A pointer to the CGrafPort structure that defines the destination graphics port or graphics world. Set to NIL to use the current port.
gd

A handled to the GDevice structure that defines the destination graphics device. Set to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's device.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics world is initialized to the current port and device when the graphics importer component is opened. Use this function to select another port or device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );

/*GraphicsImportSetBoundsRect

Defines the rectangle in which to draw an imported image.

ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure that describes the bounding rectangle into which the image will be drawn.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You use this function to define the rectangle into which the graphics image should be drawn. The function creates a transformation matrix to map the image's natural bounds to the specified bounds and then calls GraphicsImportSetMatrix.
Special Considerations

Because this function affects the transformation matrix, you should use GraphicsImportSetMatrix instead of this function if you also need to specify more complex transformations of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );

/*GraphicsImportGetNaturalBounds

Returns the bounding rectangle of an imported image.

ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
naturalBounds

A pointer to a Rect structure that describes the size of the bounding rectangle for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to determine the native size of the image associated with a graphics importer component. The natural bounds are always zero-based. This is a convenience function that simply calls GraphicsImportGetImageDescription and extracts the width and height fields.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );


/*NewICMProgressUPP

Allocates a Universal Procedure Pointer for the ICMProgressProc callback.

ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );

/*GetGraphicsImporterForDataRef

Locates and opens a graphics importer component that can be used to draw the image from specified data reference.

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );
Parameters
dataRef

The data reference to be drawn using a graphics importer component.
dataRefType

The type of data reference pointed to by the dataRef parameter; see Data References. For alias-based data references, the dataRef handle contains an AliasRecord and dataRefType is set to rAliasType.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found, this parameter will be set to NIL. If GetGraphicsImporterForDataRef is able to locate a graphics importer for the data reference, the returned graphics importer ComponentInstance will already be set up to draw from the specified data reference to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function tries to locate a graphics importer component for the specified data reference by checking the file extension (such as .GIF or .JPG), the Macintosh file type, and the MIME type of the file. The file extension is retrieved from the data reference by using DataHGetFileName to call the data handler associated with the data reference. If a graphics importer cannot be found using the file's type, file extension, or MIME type, GetGraphicsImporterForDataRef asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming; to bypass it, call GetGraphicsImporterForDataRefWithFlags instead.
Special Considerations

The caller of GetGraphicsImporterForDataRef is responsible for closing the returned ComponentInstance using CloseComponent. You must call CloseComponent when you are finished with the importer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );

/*GraphicsImportSetQuality

Sets the image quality value for an imported image.

ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
quality

Contains a constant (see below) that defines the desired image quality for decompression. Values for this parameter are on the same scale as compression quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The quality parameter controls how precisely the decompressor decompresses the image data. Some decompressors may choose to ignore some image data to improve decompression speed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );

/*GraphicsExportDoExport

Performs a graphics export operation.

ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
actualSizeWritten

Points to a variable to receive the number of bytes written. If you are not interested in this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function , you must specify an input image, using one of the GraphicsExportSetInput... functions, and a destination for the output image file, using one of the GraphicsExportSetOutput... functions.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );

/*GraphicsExportSetProgressProc

Installs a progress function in a graphics export operation.

ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is always implemented by the base graphics exporter.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );

/*GraphicsExportSetCompressionQuality

Defines the compression quality for a graphics export operation.

ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
spatialQuality

A constant (see below) that defines the currently specified quality value. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This setting is only supported by lossy compression methods.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );

/*GraphicsExportSetOutputFile

Defines the output file for a graphics export operation.

ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
theFile

an FSSpec structure that identifies the file.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );

/*GraphicsExportSetInputGraphicsImporter

Specifies that the source image for a graphics export operation is to be drawn by a graphics importer instance.

ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
grip

The source graphics importer component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

It is the caller's responsibility to dispose of the graphics importer.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );

/*GraphicsExportGetMIMETypeList

Returns MIME types and other information about the graphics format in a graphics export operation.

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Receives a newly-created QuickTime atom container that contains information about the graphics format.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container that contains the format's name, as a string in an atom of type 'desc' (kMimeInfoDescriptionTag), and optionally the MIME type as a string in an atom of type 'mime'[atom] (kMimeInfoMimeTypeTag).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GraphicsExportGetDefaultFileNameExtension

Returns the suggested file name extension for a graphics export operation.

ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
fileNameExtension

Points to a location to receive the file name extension.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

File name extensions are returned as upper-case big-endian four-character codes. For example, the extension .png would be returned as 'PNG ' (0x504E4720).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );

/*GraphicsImportCreateCGImage

Imports an image as a Core Graphics CGImage.

ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageRefOut

A reference to the CG image to be created.
flags

A flag that determines the settings to use.
kGraphicsImportCreateCGImageUsingCurrentSettings

Use the current settings.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: ImageCompression.h*/
ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags );


/*GetGraphicsImporterForFile

Locates and opens a graphics importer component that can be used to draw a specified file.

OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi );
Parameters
theFile

The file to be drawn using a graphics importer component.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found for the specified file, the gi will be set to NIL. If GetGraphicsImporterForFile is able to locate a graphics importer for the file, the returned graphics importer ComponentInstance will already be set up to draw the specified file to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function first tries to locate a graphics importer component for the specified file based on its file type. If it is unable to locate a graphics importer component based on the Macintosh file type, or the call is made on a non-Macintosh file, GetGraphicsImporterForFile will try to locate a graphics importer component based on the file extension (such as .JPG or .GIF). If a graphics importer cannot be found using the file's type or extension, GetGraphicsImporterForFile asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming. To bypass the validation attempt, call GetGraphicsImporterForFileWithFlags instead. The following code sample illustrates the use of GetGraphicsImporterForFile:// Get a graphics importer for the image file, determine the natural size
// of the image, and draw the image
// See "Discovering QuickTime," page 274
void drawFile(const FSSpec *fss, const Rect *boundsRect)
    {
        GraphicsImportComponent gi;
        GetGraphicsImporterForFile(fss, &gi);
        GraphicsImportSetBoundsRect(gi, boundsRect);
        GraphicsImportDraw(gi);
        CloseComponent(gi);
    }

Special Considerations

The caller of GetGraphicsImporterForFile is responsible for closing the returned ComponentInstance using CloseComponent.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi );

/*MakeImageDescriptionForPixMap

Fills out an ImageDescription structure corresponding to a PixMap structure.

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh );
Parameters
pixmap

A handle to a PixMap structure.
idh

The handle of an ImageDescription structure. On entry, this parameter normally points to an ImageDescription structure whose contents are NIL. On return, the structure is correctly filled out for the selected PixMap.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh );

/*DecompressSequenceBegin

Obsolete. See DecompressSequenceBeginS.

OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );

/*DecompressSequenceFrameS

Queues a frame for decompression and specifies the size of the compressed data; new applications should use DecompressSequenceFrameWhen.

OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
dataSize

The size of the data buffer.
inFlags

Contains flags (see below) that provide further control information. See these constants: 
codecFlagNoScreenUpdate
codecFlagDontOffscreen
codecFlagOnlyScreenUpdate
outFlags

Contains status flags (see below). The decompressor updates these flags at the end of the decompression operation. See these constants: 
codecFlagUsedNewImageBuffer
codecFlagUsedImageBuffer
codecFlagDontUseNewImageBuffer
codecFlagInterlaceUpdate
codecFlagCatchUpDiff
asyncCompletionProc

Points to an ICMCompletionProcRecord structure. The compressor calls your completion function when an asynchronous decompression operation is complete. You can cause the decompression to be performed asynchronously by specifying a completion function. If you specify asynchronous operation, you must not read the decompressed image until the decompressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous decompression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the decompressor does not call your completion function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function accepts the same parameters as the DecompressSequenceFrame function, with the addition of the dataSize parameter.
Special Considerations

New applications should use DecompressSequenceFrameWhen.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );

/*CDSequenceEnd

Indicates the end of processing for an image sequence.

OSErr CDSequenceEnd (
   ImageSequence    seqID );
Parameters
seqID

Contains the unique sequence identifier that was returned by DecompressSequenceBegin or CompressSequenceBegin.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceEnd (
   ImageSequence    seqID );

/*SetIdentityMatrix

Sets the contents of a matrix so that it performs no transformation.

void SetIdentityMatrix (
   MatrixRecord    *matrix );
Parameters
matrix

A pointer to a MatrixRecord structure. The function updates the contents of this matrix so that the matrix describes the identity matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void SetIdentityMatrix (
   MatrixRecord    *matrix );

/*RotateMatrix

Modifies the contents of a matrix so that it defines a rotation operation.

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY );
Parameters
m

A pointer to a MatrixRecord structure.
degrees

The number of degrees of rotation.
aboutX

The x coordinate of the anchor point of rotation.
aboutY

The y coordinate of the anchor point of rotation.
Discussion

This function updates the contents of a matrix so that the matrix describes a rotation operation; that is, it concatenates the rotation transformations onto whatever was initially in the matrix structure. You specify the direction and amount of rotation with the degrees parameter. You specify the point of rotation with the aboutX and aboutY parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY );

/*TranslateMatrix

Adds a translation value to a specified matrix.

void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV );
Parameters
m

A pointer to the MatrixRecord structure for this operation.
deltaH

The value to be added to the x coordinate translation value.
deltaV

The value to be added to the y coordinate translation value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV );

/*GraphicsImportSetMatrix

Defines the transformation matrix to use for drawing an imported image.

ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
matrix

A pointer to a matrix structure that specifies how to transform the image during decompression. For example, you can use a transformation matrix to scale or rotate the image. To set the matrix to identity, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function establishes the transformation matrix to be applied to an image, which determines where and how it will be drawn.
Special Considerations

This function affects the bounding rectangle defined for the image. You can specify where an image will be drawn by setting either a transformation matrix or a bounding rectangle, but it is usually more convenient for applications to set a bounding rectangle using the GraphicsImportSetBoundsRect function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix );

/*GraphicsImportGetBoundsRect

Returns the bounding rectangle for drawing an imported image.

ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure describing the bounding rectangle that has been defined for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a convenience function. It is implemented by calling GraphicsImportGetMatrix and GraphicsImportGetNaturalBounds and using the results to calculate the drawing rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds );

/*GraphicsImportSetSourceRect

Sets the source rectangle to use for an imported image.

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
sourceRect

A pointer to a Rect structure defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the source image. Set to NIL to use the entire image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides a way to use only a portion of the source image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect );


/*GraphicsImportSetFlags

Sets the flags for a graphics importer component.

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
flags

The new flags (see below) to use. See these constants: 
kGraphicsImporterDontDoGammaCorrection
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags );

/*GraphicsImportSetClip

Defines the clipping region for drawing an imported image.

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
clipRgn

A handle to a MacRegion structure that defines the clipping region in the destination coordinate system. Set to NIL to disable clipping. The graphics import component makes a copy of this region.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Because all drawing operations ignore the port clipping region, you must use this function to clip an image. The graphics importer component draws only that portion of the image that lies within the specified clipping region.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn );

/*ICMCompressorSourceFrameGetFrameOptions

Retrieves the frame compression options for a source frame.

ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A compression session frame options reference representing options for this frame. A frame options object is created by ICMCompressionFrameOptionsCreate.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame );

/*ICMCompressionSessionOptionsGetAllowTemporalCompression

Retrieves the allow temporal compression flag.

Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if temporal compression is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options );

/*ICMCompressionFrameOptionsGetForceKeyFrame

Retrieves the force key frame flag.

Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

Returns TRUE if frames are forced to be compressed as key frames, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options );

/*ICMCompressorSourceFrameRetain

Increments the retain count of a source frame object.

ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Return Value

A reference to the object passed in sourceFrame, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame );

/*ICMCompressorSourceFrameRelease

Decrements the retain count of a source frame object.

void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame );


/*ICMCompressorSourceFrameGetDisplayNumber

Retrieves a source frames display number.

long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

The display number of the source frame.
Discussion

The ICM tags source frames with display numbers in the order that they are passed to ICMCompressionSessionEncodeFrame. The first display number is 1. Compressors may compare these numbers to work out whether prediction is forward or backward, even when display times are not provided. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame );

/*ICMCompressionSessionOptionsGetAllowFrameReordering

Retrieves the allow frame reordering flag.

Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if frame reordering is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/


Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options );

/*ICMCompressorSourceFrameGetDisplayTimeStampAndDuration

Retrieves the display time stamp and duration of a source frame.

OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
displayTimeStampOut

A pointer to the source frame's display time stamp.
displayDurationOut

A pointer to the source frame's display duration.
timeScaleOut

A pointer to the source frame's display time scale.
validTimeFlagsOut

A pointer to one of these display time flags for the source frame: kICMValidTime_DisplayTimeStampIsValid = 1L<<0 The value of displayTimeStamp is valid. kICMValidTime_DisplayDurationIsValid = 1L<<1 The value of displayDuration is valid. See these constants: 
kICMValidTime_DisplayTimeStampIsValid
kICMValidTime_DisplayDurationIsValid
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut );

/*ICMCompressionSessionOptionsGetProperty

Retrieves the value of a specific property of a compression session options object.

OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
outPropType

A pointer to the type of the returned property's value.
outPropValueAddress

A pointer to a variable to receive the returned property's value.
outPropValueSizeUsed

On return, a pointer to the number of bytes actually used to store the property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed );

/*ICMEncodedFrameCreateMutable

Called by a compressor to create an encoded-frame token corresponding to a given source frame.

OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
bufferSize

The size of the frame buffer in bytes.
frameOut

On return, a reference to an encoded frame object with write capabilities.
Return Value

An error code. Returns noErr if there is no error.
Discussion

The encoded frame will initially show 0 for mediaSampleFlags; if the frame is not a key frame, the compressor must call ICMEncodedFrameSetMediaSampleFlags to set mediaSampleNotSync. If the frame is droppable, the compressor should set mediaSampleDroppable. If the frame is a partial key frame, the compressor should set mediaSamplePartialSync.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut );


/*ICMEncodedFrameGetDataPtr

Gets the data buffer for an encoded frame.

UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

A pointer to the object's data buffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame );

/*ICMCompressorSourceFrameGetPixelBuffer

Retrieves a source frames pixel buffer.

CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A reference to the pixel buffer containing the source frame's image being compressed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame );

/*ICMEncodedFrameSetDataSize

Sets the data size of the compressed frame in an encoded frame's buffer.

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize );
Parameters
frame

A reference to an encoded frame object with write capabilities.
dataSize

The data size of the compressed frame in the encoded frame object's buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize );


/*ICMEncodedFrameSetMediaSampleFlags

Sets the media sample flags for an encoded frame.

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags );
Parameters
frame

A reference to an encoded frame object with write capabilities.
mediaSampleFlags

The object's media sample flags. These flags are listed in the header file Movies.h.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags );

/*ICMEncodedFrameSetFrameType

Sets the frame type for an encoded frame.

OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType );
Parameters
frame

A reference to an encoded frame object with write capabilities.
frameType

The frame type to be set: kICMFrameType_I = 'I' An I frame. kICMFrameType_P = 'P' A P frame. kICMFrameType_B = 'B' A B frame. kICMFrameType_Unknown = 0 A frame of unknown type. See these constants: 
kICMFrameType_I
kICMFrameType_P
kICMFrameType_B
kICMFrameType_Unknown
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType );


/*ICMCompressorSessionEmitEncodedFrame

Called by a compressor to output an encoded frame corresponding to one or more source frames.

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
encodedFrame

A reference to an encoded frame object with write capabilities.
numberOfSourceFrames

The number of source frames encoded in the encoded frame.
sourceFrames

References to frames that have been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Encoded frames may correspond to more than one source frame only if allowFrameTimeChanges is set in the compression session's compressionSessionOptions.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] );

/*ICMEncodedFrameRelease

Decrements the retain count of an encoded frame object.

void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame );
Parameters
frame

A reference to an encoded frame object. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame );


/*ICMCompressionSessionOptionsRelease

Decrements the retain count of a compression session options object.

void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options );

/*ICMCompressionFrameOptionsGetFrameType

Retrieves the frame type setting.

ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

On return, one of the frame types listed below.
Discussion

This function can return one of these constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options );


/*ICMCompressionSessionOptionsRetain

Increments the retain count of a compression session options object.

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Return Value

A copy of the object reference passed in options, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options );

/*ICMCompressionSessionOptionsGetMaxKeyFrameInterval

Retrieves the maximum key frame interval.

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns the maximum key frame interval.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options );


/*GetCodecInfo

Returns information about a single compressor component.

OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec );
Parameters
info

A pointer to a CodecInfo structure. GetCodecInfo returns detailed information about the appropriate compressor component in this structure.
cType

Set this parameter to a valid compressor type constant; see Codec Identifiers. If you want information about any compressor of the type specified by this parameter, set the codec parameter to 0. The Image Compression Manager then returns information about the first compressor it finds of the type you have specified.
codec

Set this parameter to the component identifier of the specific compressor for the request, or to 0 for any compressor. Component identifiers are available in the CodecNameSpecList structure returned by GetCodecNameList.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec );

/*GraphicsExportGetSettingsAsAtomContainer

Retrieves the current settings from a graphics exporter component.

ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Points to a variable to receive a new QuickTime atom container containing the current graphics exporter component settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

The caller is responsible for disposing of the returned atom container.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GraphicsImportGetExportSettingsAsAtomContainer

Retrieves settings for image files exported by the graphics importer.

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
qtAtomContainerPtr

A pointer to a QuickTime atom container that is to receive the settings information.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a new QuickTime atom container which holds information about how images will be saved by GraphicsImportExportImageFile.
Special Considerations

It is the responsibility of the caller to dispose of this atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GetMaxCompressionSize

Determines the maximum size an image will be after compression.

OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size );
Parameters
src

A handle to the source image. The source image must be stored in a pixel map structure. The compressor uses only the image's size and pixel depth to determine the maximum size of the compressed image.
srcRect

A pointer to a rectangle defining the portion of the source image that is to be compressed. You may set this parameter to NIL if you are interested only in information about quality settings. GetCompressionTime then uses the bounds of the source pixel map.
colorDepth

The depth at which the image is to be compressed. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by GetCodecInfo.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

You must set this parameter to a valid compressor type constant; see Codec Identifiers.
codec

A compressor identifier. Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). You can also specify a component instance. This may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
size

A pointer to a field to receive the size, in bytes, of the compressed image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the maximum resulting size for the specified image and parameters. Your application may then use this information to allocate memory for the compression operation. The following code sample illustrates its use:// GetMaxCompressionSize coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size );


/*CompressImage

Compresses a single-frame image that is currently stored as a pixel map structure.

OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data );
Parameters
src

A handle to the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

A compressor type; see Codec Identifiers.
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned image description structure. Your application should store this image description with the compressed image data.
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. The Image Compression Manager places the actual size of the compressed image into the dataSize field of the ImageDescription structure structure referred to by the desc parameter. This pointer must contain a 32-bit clean address.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The following code sample illustrates the process of compressing and decompressing a pixel map.// CompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data );

/*DecompressImage

Decompresses a single-frame image into a pixel map structure.

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask );
Parameters
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
desc

A handle to the ImageDescription structure that describes the compressed image.
dst

A handle to the pixel map where the decompressed image is to be displayed. Set the current graphics port to the port that contains this pixel map.
srcRect

A pointer to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by (0,0) and ((**desc).width,(**desc).height). If you want to decompress the entire source image, set this parameter to NIL. If the parameter is NIL, the rectangle is set to the rectangle structure of the ImageDescription structure.
dstRect

A pointer to the rectangle into which the decompressed image is to be loaded. The compressor scales the source image to fit into this destination rectangle.
mode

The transfer mode for the operation, as listed in Graphics Transfer Modes.
mask

A handle to a clipping region in the destination coordinate system. If specified, the compressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Note that DecompressImage is invoked through the StdPix function. The following code sample illustrates the process of compressing and decompressing a pixel map.// DecompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask );

/*QTGetPixMapHandleRowBytes

Gets the rowBytes value for a pixel map accessed by a handle.

long QTGetPixMapHandleRowBytes (
   PixMapHandle    pm );
Parameters
pm

A handle to a PixMap structure.
Return Value

The rowBytes value.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

long QTGetPixMapHandleRowBytes (
   PixMapHandle    pm );

/*RectMatrix

Creates a matrix that performs the translate and scale operation described by the relationship between two rectangles.

void RectMatrix (
   MatrixRecord    *matrix,
   const Rect      *srcRect,
   const Rect      *dstRect );
Parameters
matrix

A pointer to a MatrixRecord structure. This function updates the contents of this matrix so that the matrix describes a transformation from points in the rectangle specified by the srcRect parameter to points in the rectangle specified by the dstRect parameter. The previous contents of the matrix are ignored.
srcRect

A pointer to the source Rect structure.
dstRect

A pointer to the destination Rect structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void RectMatrix (
   MatrixRecord    *matrix,
   const Rect      *srcRect,
   const Rect      *dstRect );


/*DecompressSequenceBeginS

Sends a sample image to a decompressor.

OSErr DecompressSequenceBeginS (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   Ptr                       data,
   long                      dataSize,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );
Parameters
seqID

A pointer to a field to receive the unique identifier for the sequence you are creating. You should use this identifier for subsequent calls relating to this decompression sequence.
desc

A handle to the ImageDescription structure that describes the compressed image.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address. Ideally, you should pass a pointer to the first frame of the compressed image data, which lets the Image Compression Manager do a better job of preflighting the decompression sequence. If the image data is not available at the time of this call, you can pass NIL for this parameter and 0 for dataSize. If you pass NIL here, then your first call to DecompressSequenceFrameWhen may require more setup time.
dataSize

The size of the data buffer, or 0 if you passed NIL in the data parameter.
port

Points to the CGrafPort structure for the destination image.
gdh

A handle to the GDevice structure for the destination image. You can pass NIL if the GDevice is implicit in the port selection (for example, if it is an offscreen graphics world).
srcRect

A pointer to a Rect structure that defines the portions of the image to decompress. Pass NIL if you want to decompress the entire source image. You can call SetDSequenceSrcRect to change the source rectangle for an active decompression sequence.
matrix

Points to a MatrixRecord structure that specifies how to transform the image during decompression. Pass NIL to use the identity matrix. Your application can change the matrix for an active sequence by calling SetDSequenceMatrix.
mode

The transfer mode for the operation. See Graphics Transfer Modes. Your application can change the transfer mode for an active sequence by calling SetDSequenceTransferMode.
mask

A handle to a clipping region in the destination coordinate system. If specified, the compressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL. Your application can change the clipping mask for an active sequence by calling SetDSequenceMask.
flags

Buffer allocation flags (see below). See these constants: 
codecFlagUseScreenBuffer
codecFlagUseImageBuffer
accuracy

A constant (see below) that defines the desired compression accuracy. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
codec

A decompressor identifier. Specify a particular decompressor by setting this parameter to its identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
Return Value

See Error Codes. Returns codecWouldOffscreenErr if codecFlagDontUseImageBuffer is set and the codec requires an offscreen buffer to decompress to the destination port. Returns noErr if there is no error.
Discussion

This function lets you pass a compressed sample so a codec can perform preflighting before the first DecompressSequenceFrameWhen call. To decompress a series of images, call it once to preflight the decompressor, make calls to DecompressSequenceFrameWhen to decompress each image in the sequence, then call CDSequenceEnd when you are done.
Version Notes

Introduced in QuickTime 1.6.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressSequenceBeginS (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   Ptr                       data,
   long                      dataSize,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );


/*DragAlignedWindow

Drags the specified window along an optimal alignment grid.

void DragAlignedWindow (
   WindowRef                    wp,
   Point                        startPt,
   Rect                         *boundsRect,
   Rect                         *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
wp

A window pointer to the window to be dragged.
startPt

A point that is equal to the point where the mouse button was pressed (in global coordinates, as stored in the where field of the event structure). DragAlignedWindow pulls a gray outline of the window around the screen, following the movements of the mouse until the button is released.
boundsRect

Points to the boundary rectangle in global coordinates. If the mouse button is released when the mouse position is outside the limits of the boundary rectangle, DragAlignedWindow returns without moving the window or making it the active window. For a document window, the boundary rectangle typically is four pixels in from the menu bar and from the other edges of the screen, to ensure that there won't be less than a four-pixel-square area of the title bar visible on the screen.
alignmentRect

Points to a rectangle in window coordinates that allows you to align the window to a rectangle within the window. Set this parameter to NIL to align using the bounds of the window.
alignmentProc

A pointer to your alignment behavior function; see ICMAlignmentProc. Pass NIL to use the standard behavior.
Discussion

The following code sample illustrates the use of DragAlignedWindow:// DragAlignedWindow coding example
// See "Discovering QuickTime," page 265
Boolean IsQuickTimeInstalled (void)
{
    OSErr       nErr;
    long        lResult;
    nErr =Gestalt(gestaltQuickTime, &lResult);
    return (nErr ==noErr);
}
void MyInitialize (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    MaxApplZone();
    EnterMovies();
}
WindowRef MakeMyWindow (void)
{
    WindowRef   pMacWnd;
    Rect        rectWnd ={0, 0, 120, 160};
    Rect        rectBest;
    // figure out the best monitor for the window
    GetBestDeviceRect(NIL, &rectBest);
    // put the window in the top left corner of that monitor
    OffsetRect(&rectWnd, rectBest.left + 10, rectBest.top + 50);
    // create the window
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pGrabber",
                            TRUE, noGrowDocProc, (WindowRef)-1,
                            TRUE, 0);
    // set the port to the new window
    SetPort(pMacWnd);
    return pMacWnd;
}
main (void)
{
    WindowRef           pMacWnd;
    SeqGrabComponent    seqGrab;
    SGChannel           sgchanVideo, sgchanSound;
    Boolean             bDone =FALSE;
    OSErr               nErr;
    MyInitialize();
    pMacWnd =MakeMyWindow();
    seqGrab =MakeMySequenceGrabber(pMacWnd);
    if (seqGrab ==NIL)
        return;
    MakeMyGrabChannels(seqGrab, &sgchanVideo, &sgchanSound,
                         &pMacWnd->
portRect, FALSE);
    nErr =SGStartPreview(seqGrab);
    while (!bDone) {
        ICMAlignmentProcRecord  apr;
        short                   nPart;
        WindowRef               pWhichWnd;
        EventRecord             er;
        GetNextEvent(everyEvent, &er);
        switch (er.what) {
            case nullEvent:     // give the sequence grabber time
                nErr =SGIdle(seqGrab);
                if (nErr !=noErr)
                    bDone =TRUE;
                break;
            case updateEvt:
                if (er.message ==(long)pMacWnd) {
                    // inform the sequence grabber of the update
                    SGUpdate(seqGrab,((WindowPeek)
                                     pMacWnd)->
updateRgn);
                    // and swallow the update event
                    BeginUpdate(pMacWnd);
                    EndUpdate(pMacWnd);
                }
                break;
            case mouseDown:
                nPart =FindWindow(er.where, &pWhichWnd);
                if (pWhichWnd !=pMacWnd)
                    break;
                switch (nPart) {
                    case inContent:
                        // pause until mouse button is released
                        SGPause(seqGrab, TRUE);
                        while (StillDown())
                            SGPause(seqGrab, FALSE);
                            break;
                    case inGoAway:
                        bDone =TrackGoAway(pMacWnd, er.where);
                        break;
                    case inDrag:
                        // pause when dragging window so video
                        // doesn't draw in the wrong place
                        SGPause(seqGrab, TRUE);
                        SGGetAlignmentProc(seqGrab, &apr);
                        DragAlignedWindow(pMacWnd,
                                            er.where,
                                            &screenBits.bounds,
                                            NIL, &alignProc);
                        SGPause(seqGrab, FALSE);
                        break;
                    }
                break;
        }
    }
    // clean up
    SGStop(seqGrab);
    CloseComponent(seqGrab);
    DisposeWindow(pMacWnd);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void DragAlignedWindow (
   WindowRef                    wp,
   Point                        startPt,
   Rect                         *boundsRect,
   Rect                         *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc );

/*TransformRect

Transforms the upper-left and lower-right points of a rectangle through a specified matrix.

Boolean TransformRect (
   const MatrixRecord    *m,
   Rect                  *r,
   FixedPoint            *fpp );
Parameters
m

The matrix for this operation.
r

A pointer to the Rect structure that defines the rectangle to be transformed. The function returns the updated coordinates into the structure referred to by this parameter.
fpp

A pointer to an array of four fixed points. The TransformRect function returns the coordinates of the four corners of the rectangle after the transformation operation. If you do not want this information, set this parameter to NIL.
Return Value

If the resulting rectangle has been rotated or skewed (that is, the transformation involves operations other than scaling and translation), the function returns FALSE, updates the rectangle specified by the r parameter to define the boundary box of the resulting rectangle, and places the coordinates of the corners of the resulting rectangle in the points specified by the fpp parameter. If the transformed rectangle and its boundary box are the same, the function returns TRUE.
Discussion

This function does not return any error codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

Boolean TransformRect (
   const MatrixRecord    *m,
   Rect                  *r,
   FixedPoint            *fpp );

/*AlignWindow

Moves a specified window to the nearest optimal alignment position.

void AlignWindow (
   WindowRef                    wp,
   Boolean                      front,
   const Rect                   *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
wp

Points to the window to be aligned.
front

The frontmost window. If the front parameter is TRUE and the window specified in the wp parameter isn't the active window, AlignWindow makes it the active window.
alignmentRect

A pointer to a rectangle in window coordinates that allows you to align the window to a rectangle within the window. Set this parameter to NIL to align using the bounds of the window.
alignmentProc

Points to a function that allows you to provide your own alignment behavior. Set this parameter to NIL to use the standard behavior.
Discussion

For a specification of your alignment function, see ICMAlignmentProc.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void AlignWindow (
   WindowRef                    wp,
   Boolean                      front,
   const Rect                   *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc );

/*ConcatMatrix

Concatenates two matrices, combining the transformations described by both matrices into a single matrix.

void ConcatMatrix (
   const MatrixRecord    *a,
   MatrixRecord          *b );
Parameters
a

A pointer to the source matrix.
b

A pointer to the destination matrix. The ConcatMatrix function performs a matrix multiplication operation on the two matrices and leaves the result in the matrix specified by this parameter.
Discussion

This is a matrix multiplication operation, as a result of which [B] =[B] x [A]. Note that matrix multiplication is not commutative.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void ConcatMatrix (
   const MatrixRecord    *a,
   MatrixRecord          *b );

/*FCompressImage

Compresses a single-frame image that is currently stored as a pixel map structure, with added control over the compression process.

OSErr FCompressImage (
   PixMapHandle                src,
   const Rect                  *srcRect,
   short                       colorDepth,
   CodecQ                      quality,
   CodecType                   cType,
   CompressorComponent         codec,
   CTabHandle                  ctable,
   CodecFlags                  flags,
   long                        bufferSize,
   ICMFlushProcRecordPtr       flushProc,
   ICMProgressProcRecordPtr    progressProc,
   ImageDescriptionHandle      desc,
   Ptr                         data );
Parameters
src

A handle to the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress.
colorDepth

The depth at which the image is likely to be viewed. Compressors may use this as an indication of the color or grayscale resolution of the compressed image. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by the GetCodecInfo function.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

A compressor type. You must set this parameter to a valid compressor type constant.
codec

A compressor identifier. Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
ctable

A handle to a custom color lookup table. Your program may use this parameter to indicate a custom color lookup table to be used with this image. If the value of the colorDepth parameter is less than or equal to 8 and the custom color lookup table is different from that of the source pixel map (that is, the ctSeed field values differ in the two pixel maps), the compressor remaps the colors of the image to the custom colors. If you set the colorDepth parameter to 16, 24, or 32, the compressor stores the custom color table with the compressed image. The compressor may use the table to specify the best colors to use when displaying the image at lower bit depths. The compressor ignores the ctable parameter when colorDepth is set to 33, 34, 36, or 40. If you set this parameter to NIL, the compressor uses the color lookup table from the source pixel map.
flags

Contains a flag (see below) that indicates whether or not the image was previously compressed. See these constants: 
codecFlagWasCompressed
bufferSize

The size of the buffer to be used by the data-unloading function specified by the flushProc parameter. If you have not specified a data-unloading function, set this parameter to 0.
flushProc

Points to an ICMDataProc data-unloading callback. If there is not enough memory to store the compressed image, the compressor calls a function you provide that unloads some of the compressed data. If you have not provided a data-unloading callback, set this parameter to NIL. In this case, the compressor writes the entire compressed image into the memory location specified by the data parameter.
progressProc

Points to an ICMProgressProc progress callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress callback, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned ImageDescription structure. Your application should store this image description with the compressed image data.
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. If there is not sufficient memory to store the compressed image, you may choose to write the compressed data to mass storage during the compression operation. Use the flushProc parameter to identify your data-unloading function to the compressor. This pointer must contain a 32-bit clean address. The Image Compression Manager places the actual size of the compressed image into the dataSize field of the ImageDescription structure referenced by the desc parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function acts like CompressImage, but gives your application additional control over the parameters that guide the compression operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr FCompressImage (
   PixMapHandle                src,
   const Rect                  *srcRect,
   short                       colorDepth,
   CodecQ                      quality,
   CodecType                   cType,
   CompressorComponent         codec,
   CTabHandle                  ctable,
   CodecFlags                  flags,
   long                        bufferSize,
   ICMFlushProcRecordPtr       flushProc,
   ICMProgressProcRecordPtr    progressProc,
   ImageDescriptionHandle      desc,
   Ptr                         data );


/*GraphicsImportGetImageDescription

Returns image description information for an imported image.

ComponentResult GraphicsImportGetImageDescription (
   GraphicsImportComponent    ci,
   ImageDescriptionHandle     *desc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
desc

Points to a handle to an ImageDescription structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns an ImageDescription structure containing information such as the format of the compressed data, its bit depth, natural bounds, and resolution.
Special Considerations

The caller is responsible for disposing of the returned image description handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetImageDescription (
   GraphicsImportComponent    ci,
   ImageDescriptionHandle     *desc );

/*ScaleMatrix

Modifies the contents of a matrix so that it defines a scaling operation.

void ScaleMatrix (
   MatrixRecord    *m,
   Fixed           scaleX,
   Fixed           scaleY,
   Fixed           aboutX,
   Fixed           aboutY );
Parameters
m

A pointer to a MatrixRecord structure. The ScaleMatrix function updates the contents of this matrix so that the matrix describes a scaling operation; that is, it concatenates the respective transformations onto whatever was initially in the matrix structure. You specify the magnitude of the scaling operation with the scaleX and scaleY parameters. You specify the anchor point with the aboutX and aboutY parameters.
scaleX

The scaling factor applied to x coordinates.
scaleY

The scaling factor applied to y coordinates.
aboutX

The x coordinate of the anchor point.
aboutY

The y coordinate of the anchor point.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void ScaleMatrix (
   MatrixRecord    *m,
   Fixed           scaleX,
   Fixed           scaleY,
   Fixed           aboutX,
   Fixed           aboutY );

/*QTNewGWorldFromPtr

Wraps a graphics world and pixel map structure around an existing block of memory containing an image.

OSErr QTNewGWorldFromPtr (
   GWorldPtr      *gw,
   OSType         pixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags,
   void           *baseAddr,
   long           rowBytes );
Parameters
gw

On entry, a pointer that isn't going to change during the lifetime of the allocated graphics world. On return, this pointer references the offscreen graphics world created by this function.
pixelFormat

The new graphics world's pixel format; see Pixel Formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the pixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the pixelFormat parameter. If you set the pixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the pixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the pixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

A constant (see below) that identifies an option available to your application. If you don't wish to use this option, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world that uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure. Most constants used in creating a GWorld are irrelevant for this function, as its purpose is to wrap a GWorld around an existing block of pixels rather than to define and create a pixmap. See these constants: 
baseAddr

The base address for the pixel data. 
rowBytes

The total size of the pixel data divided by the height of the pixel map. In other words, the number of bytes in one row of pixels or the number of bytes between vertically adjacent pixels.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function wraps a GWorld around an existing pixel map. Note that it does not copy the pixmap. A subsequent call to DisposeGWorld will not dispose of the pixel map; it will only dispose of the GWorld wrapper. It is the caller's responsibility to dispose of the pixel map.

You can use this call to allocate an offscreen graphics world using special memory (such as on a video card). If you have an image in memory that belong to something else (a hardware screen buffer, a 3D card, or another file format or program), you can use this function to wrap a graphics world around the image and then use QuickTime calls on that graphics world to compress it, scale it, draw to it, and so on. If your new graphics world has a planar pixel format, you must use this call instead of QTNewGWorld.
Special Considerations

Do not unlock the pixels of the allocated graphics world. If your original pixels are from another graphics world then you must ensure that the source pixels are locked.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr QTNewGWorldFromPtr (
   GWorldPtr      *gw,
   OSType         pixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags,
   void           *baseAddr,
   long           rowBytes );

/*ICMCompressionSessionCompleteFrames

Forces a compression session to complete encoding frames.

OSStatus ICMCompressionSessionCompleteFrames (
   ICMCompressionSessionRef    session,
   Boolean                     completeAllFrames,
   TimeValue64                 completeUntilDisplayTimeStamp,
   TimeValue64                 nextDisplayTimeStamp );
Parameters
session

A reference to a video compression session, returned by a previous call to ICMCompressionSessionCreate.
completeAllFrames

Pass TRUE to direct the session to complete all pending frames.
completeUntilDisplayTimeStamp

A 64-bit time value that represents the display time up to which to complete frames. This value is ignored if completeAllFrames is TRUE.
nextDisplayTimeStamp

A 64-bit time value that represents the display time of the next frame that should be passed to EncodeFrame. This value is ignored unless ICMCompressionSessionOptionsSetDurationsNeeded set TRUE and kICMValidTime_DisplayDurationIsValid was 0 in validTimeFlags in the last call to ICMCompressionSessionEncodeFrame.
Return Value

Returns an error code, or 0 if there is no error. The function may return before frames are completed if the encoded frame callback routine returns an error.
Discussion

Call this function to force a compression session to complete encoding frames. Set completeAllFrames to direct the session to complete all pending frames. If completeAllFrames is false, only frames with display time stamps up to and including the time passed in completeUntilDisplayTimeStamp will be encoded. If ICMCompressionSessionOptionsSetDurationsNeeded set TRUE and you are passing valid display timestamps but not display durations to ICMCompressionSessionEncodeFrame, pass in nextDisplayTimeStamp the display timestamp of the next frame that would be passed to EncodeFrame.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionCompleteFrames (
   ICMCompressionSessionRef    session,
   Boolean                     completeAllFrames,
   TimeValue64                 completeUntilDisplayTimeStamp,
   TimeValue64                 nextDisplayTimeStamp );

/*ICMCompressionSessionRelease

Decrements the retain count of a compression session.

void ICMCompressionSessionRelease (
   ICMCompressionSessionRef    session );
Parameters
session

A compression session reference. This reference is returned by ICMCompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the session is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMCompressionSessionRelease (
   ICMCompressionSessionRef    session );


/*ICMCompressionSessionOptionsCreate

Creates a compression session options object.

OSStatus ICMCompressionSessionOptionsCreate (
   CFAllocatorRef                    allocator,
   ICMCompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a new compression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsCreate (
   CFAllocatorRef                    allocator,
   ICMCompressionSessionOptionsRef   *options );

/*ICMEncodedFrameGetDecodeDuration

Retrieves an encoded frame's decode duration.

TimeValue64 ICMEncodedFrameGetDecodeDuration (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's decode duration.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeValue64 ICMEncodedFrameGetDecodeDuration (
   ICMEncodedFrameRef   frame );


/*ICMEncodedFrameGetDisplayTimeStamp

Retrieves an encoded frame's display time stamp.

TimeValue64 ICMEncodedFrameGetDisplayTimeStamp (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's display time stamp.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeValue64 ICMEncodedFrameGetDisplayTimeStamp (
   ICMEncodedFrameRef   frame );

/*ICMEncodedFrameGetMediaSampleFlags

Retrieves the media sample flags for an encoded frame.

MediaSampleFlags ICMEncodedFrameGetMediaSampleFlags (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The object's media sample flags. These flags are listed in the header file Movies.h.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
MediaSampleFlags ICMEncodedFrameGetMediaSampleFlags (
   ICMEncodedFrameRef   frame );

/*ICMEncodedFrameGetDecodeTimeStamp

Retrieves an encoded frame's decode time stamp.

TimeValue64 ICMEncodedFrameGetDecodeTimeStamp (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's decode time stamp.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeValue64 ICMEncodedFrameGetDecodeTimeStamp (
   ICMEncodedFrameRef   frame );

/*ICMEncodedFrameGetValidTimeFlags

Retrieves an encoded frame's flags indicating which of its time stamps and durations are valid.

ICMValidTimeFlags ICMEncodedFrameGetValidTimeFlags (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

One of the constants listed below.
Discussion

This function returns one of these values:
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ICMValidTimeFlags ICMEncodedFrameGetValidTimeFlags (
   ICMEncodedFrameRef   frame );

/*ICMEncodedFrameGetDisplayOffset

Retrieves an encoded frame's display offset.

TimeValue64 ICMEncodedFrameGetDisplayOffset (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's display offset. This is the time offset from decode time stamp to display time stamp.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

TimeValue64 ICMEncodedFrameGetDisplayOffset (
   ICMEncodedFrameRef   frame );

/*ICMEncodedFrameGetDataSize

Gets the data size of the compressed frame in an encoded frame's buffer.

ByteCount ICMEncodedFrameGetDataSize (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The logical size in bytes of the encoded frame's data buffer, which may be less than the physical size of the buffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ByteCount ICMEncodedFrameGetDataSize (
   ICMEncodedFrameRef   frame );

/*ICMEncodedFrameGetTimeScale

Retrieves the timescale of an encoded frame.

TimeScale ICMEncodedFrameGetTimeScale (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The time scale of an encoded frame. This is always the same as the time scale of the compression session.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeScale ICMEncodedFrameGetTimeScale (
   ICMEncodedFrameRef   frame );

/*ICMCompressionSessionEncodeFrame

Presents video frames to a compression session.

OSStatus ICMCompressionSessionEncodeFrame (
   ICMCompressionSessionRef           session,
   CVPixelBufferRef                   pixelBuffer,
   TimeValue64                        displayTimeStamp,
   TimeValue64                        displayDuration,
   ICMValidTimeFlags                  validTimeFlags,
   ICMCompressionFrameOptionsRef      frameOptions,
   ICMSourceTrackingCallbackRecord    *sourceTrackingCallback,
   void                               *sourceFrameRefCon );
Parameters
session

A reference to a video compression session, returned by a previous call to ICMCompressionSessionCreate.
pixelBuffer

A reference to a buffer containing a source image to be compressed, which must have a nonzero reference count. The session will retain it as long as necessary. The client should not modify the pixel buffer's pixels until the pixel buffer release callback is called. In a multipass encoding session pass, where the compressor suggested the flag kICMCompressionPassMode_NoSourceFrames, you may pass NULL in this parameter.
displayTimeStamp

A 64-bit time value that represents the display time of the frame, using the time scale passed to ICMCompressionSessionCreate. If you pass a valid value, set the kICMValidTime_DisplayTimeStampIsValid flag in the validTimeFlags parameter (below).
displayDuration

A 64-bit time value that represents the display duration of the frame, using the time scale passed to ICMCompressionSessionCreate. If you pass a valid value, set the kICMValidTime_DisplayDurationIsValid flag in the validTimeFlags parameter (below).
validTimeFlags

Flags to indicate which of the values passed in displayTimeStamp and displayDuration are valid: kICMValidTime_DisplayTimeStampIsValid The time value passed in displayTimeStamp is valid. kICMValidTime_DisplayDurationIsValid The time value passed in displayDuration is valid. See these constants: 
kICMValidTime_DisplayTimeStampIsValid
kICMValidTime_DisplayDurationIsValid
frameOptions

Options for this frame. Currently not used; pass NULL.
sourceTrackingCallback

A pointer to a callback to be notified about the status of this source frame. Pass NULL if you do not require notification.
sourceFrameRefCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

Returns an error code, or 0 if there is no error. Encoded frames may or may not be output before the function returns.
Discussion

The session will retain the pixel buffer as long as necessary, and the client should not modify the pixel data until the session releases it. The most practical way to deal with this is by allocating pixel buffers from a pool. The client may fill in both, either, or neither of displayTimeStamp and displayDuration, but should set the appropriate flags to indicate which are valid. If the client needs to track the progress of a source frame, it should provide a source tracking callback. If multipass compression is enabled, calls to this function must be bracketed by calls to ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionEncodeFrame (
   ICMCompressionSessionRef           session,
   CVPixelBufferRef                   pixelBuffer,
   TimeValue64                        displayTimeStamp,
   TimeValue64                        displayDuration,
   ICMValidTimeFlags                  validTimeFlags,
   ICMCompressionFrameOptionsRef      frameOptions,
   ICMSourceTrackingCallbackRecord    *sourceTrackingCallback,
   void                               *sourceFrameRefCon );

/*ICMCompressionSessionOptionsSetAllowTemporalCompression

Enables temporal compression.

OSStatus ICMCompressionSessionOptionsSetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowTemporalCompression );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
allowTemporalCompression

Pass TRUE to enable temporal compression, FALSE to disable it.
Return Value

An error code. Returns noErr if there is no error.
Discussion

By default, temporal compression is disabled. If you want temporal compression for P-frames or B-frames you must call this function and pass TRUE. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsSetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowTemporalCompression );

/*ICMCompressionSessionOptionsSetAllowFrameReordering

Enables frame reordering.

OSStatus ICMCompressionSessionOptionsSetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameReordering );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
allowFrameReordering

Pass TRUE to enable frame reordering, FALSE to disable it.
Return Value

An error code. Returns noErr if there is no error.
Discussion

To encode B-frames a compressor must reorder frames, which means that the order in which they will be emitted and stored (the decode order) is different from the order in which they were presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must call this function, passing TRUE. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionOptionsSetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameReordering );

/*ICMCompressionSessionOptionsSetMaxKeyFrameInterval

Sets the maximum interval between key frames.

OSStatus ICMCompressionSessionOptionsSetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options,
   SInt32                            maxKeyFrameInterval );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
maxKeyFrameInterval

The maximum interval between key frames, also known as the key frame rate.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsSetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options,
   SInt32                            maxKeyFrameInterval );

/*ICMCompressionSessionOptionsSetProperty

Sets the value of a specific property of a compression session options object.

OSStatus ICMCompressionSessionOptionsSetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ConstComponentValuePtr            inPropValueAddress );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionOptionsSetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ConstComponentValuePtr            inPropValueAddress );

/*ICMCompressionSessionOptionsSetAllowFrameTimeChanges

Allows the compressor to modify frame times.

OSStatus ICMCompressionSessionOptionsSetAllowFrameTimeChanges (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameTimeChanges );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
allowFrameTimeChanges

Pass TRUE to let the compressor to modify frame times, FALSE to prohibit it.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Some compressors are able to identify and coalesce runs of identical frames and output single frames with longer durations, or output frames at a different frame rate from the original. This feature is controlled by the allow frame time changes flag. By default, this flag is set to false, which forces compressors to emit one encoded frame for every source frame and preserve frame display times.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h
ICMCompressionSessionOptio*/

OSStatus ICMCompressionSessionOptionsSetAllowFrameTimeChanges (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameTimeChanges );


/*ICMCompressionSessionOptionsSetDurationsNeeded

Indicates that the durations of outputted frames must be calculated.

OSStatus ICMCompressionSessionOptionsSetDurationsNeeded (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           decodeDurationsNeeded );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
decodeDurationsNeeded

Pass TRUE to indicate that durations must be calculated, FALSE otherwise.
Return Value

An error code. Returns noErr if there is no error.
Discussion

If this flag is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default this flag is 0, so frames will not be delayed in order to calculate durations.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionOptionsSetDurationsNeeded (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           decodeDurationsNeeded );

/*ICMEncodedFrameGetImageDescription

Retrieves the image description of an encoded frame.

OSStatus ICMEncodedFrameGetImageDescription (
   ICMEncodedFrameRef       frame,
   ImageDescriptionHandle   *imageDescOut );
Parameters
frame

A reference to an encoded frame object.
imageDescOut

A pointer to a handle containing the encoded frame's image description. The caller should not dispose of this handle.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This function returns the same image description handle as ICMCompressionSessionGetImageDescription. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameGetImageDescription (
   ICMEncodedFrameRef       frame,
   ImageDescriptionHandle   *imageDescOut );

/*ICMCompressionSessionCreate

Creates a compression session for a specified codec type.

OSStatus ICMCompressionSessionCreate (
   CFAllocatorRef                     allocator,
   int                                width,
   int                                height,
   CodecType                          cType,
   TimeScale                          timescale,
   ICMCompressionSessionOptionsRef    compressionOptions,
   CFDictionaryRef                    sourcePixelBufferAttributes,
   ICMEncodedFrameOutputRecord        *encodedFrameOutputRecord,
   ICMCompressionSessionRef           *compressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
width

The width of frames. Pass 0 to let the compressor control the width.
height

The height of frames. Pass 0 to let the compressor control the height.
cType

The codec type. 
timescale

The timescale to be used for all time stamps and durations used in the session. 
compressionOptions

A reference to a settings object that configures the session. You create such an object by calling ICMCompressionSessionOptionsCreate. You can then use these constants to set its properties: kICMUnlimitedFrameDelayCount No limit on the number of frames in the compression window. kICMUnlimitedFrameDelayTime No time limit on the frames in the compression window. kICMUnlimitedCPUTimeBudget No CPU time limit on compression. 
sourcePixelBufferAttributes

Required attributes for source pixel buffers, used when creating a pixel buffer pool for source frames. If you do not want the ICM to create one for you, pass NULL. Using pixel buffers not allocated by the ICM may increase the chance that it will be necessary to copy image data. 
encodedFrameOutputRecord

The callback that will receive encoded frames. 
compressionSessionOut

Points to a variable to receive the created session object. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Some compressors do not support arbitrary source dimensions, and may override the suggested width and height. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionCreate (
   CFAllocatorRef                     allocator,
   int                                width,
   int                                height,
   CodecType                          cType,
   TimeScale                          timescale,
   ICMCompressionSessionOptionsRef    compressionOptions,
   CFDictionaryRef                    sourcePixelBufferAttributes,
   ICMEncodedFrameOutputRecord        *encodedFrameOutputRecord,
   ICMCompressionSessionRef           *compressionSessionOut );

/*GraphicsExportSetInputGWorld

Specifies that the source image for a graphics export operation is a graphics world.

ComponentResult GraphicsExportSetInputGWorld (
   GraphicsExportComponent    ci,
   GWorldPtr                  gworld );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
gworld

The source graphics world. It must be a real graphics world; you may not pass an ordinary color GrafPort. 
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

The graphics exporter will never dispose the graphics world.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportSetInputGWorld (
   GraphicsExportComponent    ci,
   GWorldPtr                  gworld );


/*GraphicsImportSetDataHandle

Specifies the handle that references imported graphics data.

ComponentResult GraphicsImportSetDataHandle (
   GraphicsImportComponent    ci,
   Handle                     h );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
h

Specifies a handle containing graphics data. The format of the data in the handle is the same as that found in a file.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics importer component doesn't make a copy of this data. Therefore, you must not dispose this handle until the graphics importer has been closed.
Special Considerations

Graphics importer components use QuickTime data handler components to obtain their data. Applications, however, will use graphics importer functions rather than directly calling a data handler. Besides GraphicsImportSetDataHandle, these functions include GraphicsImportGetDataFile, GraphicsImportSetDataFile, GraphicsImportGetDataHandle, GraphicsImportSetDataReference, GraphicsImportSetDataReferenceOffsetAndLimit, and GraphicsImportGetDataReferenceOffsetAndLimit. These functions allow the data source to be a file, a handle, or a QuickTime data reference. You only need to use these functions if you open the graphics importer component directly. You don't need to call them if you use one of the GetGraphicsImporter... functions such as GetGraphicsImporterForDataRef. The GetGraphicsImporter... functions automatically open the graphics importer component and set its data source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetDataHandle (
   GraphicsImportComponent    ci,
   Handle                     h );

/*GraphicsImportGetSourceRect

Returns the current source rectangle for an imported image.

ComponentResult GraphicsImportGetSourceRect (
   GraphicsImportComponent    ci,
   Rect                       *sourceRect );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
sourceRect

A pointer to a Rect structure that defines the source rectangle currently specified for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the current source rectangle, as specified by GraphicsImportSetSourceRect. The default source rectangle is the image's natural bounds.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetSourceRect (
   GraphicsImportComponent    ci,
   Rect                       *sourceRect );


/*GraphicsImportSetDestinationColorSyncProfileRef

Sets the ColorSync profile for a graphics importer component.

ComponentResult GraphicsImportSetDestinationColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newDestinationProfileRef);
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
newDestinationProfileRef

A pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetDestinationColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newDestinationProfileRef);

/*GraphicsImportGetOverrideSourceColorSyncProfileRef

Retrieves the override ColorSync profile for a graphics importer component.

ComponentResult GraphicsImportGetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              *outOverrideSourceProfileRef );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
outOverrideSourceProfileRef

A pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              *outOverrideSourceProfileRef );

/*GraphicsImportSetOverrideSourceColorSyncProfileRef

Sets the override ColorSync profile for a graphics importer component.

ComponentResult GraphicsImportSetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newOverrideSourceProfileRef);
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
newOverrideSourceProfileRef

A pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newOverrideSourceProfileRef);


/*GraphicsImportGetDestinationColorSyncProfileRef

Retrieves a ColorSync profile from a graphics importer component.

GraphicsImportGetDestinationColorSyncProfileRef (
   GraphicsImportComponent   ci,
   CMProfileRef              *destinationProfileRef);
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
destinationProfileRef

On return, a pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ComponentResult  GraphicsImportGetDestinationColorSyncProfileRef (
   GraphicsImportComponent   ci,
  CMProfileRef              *destinationProfileRef);

/*GraphicsImportGetFlags

Returns the current flags of a graphics importer component.

ComponentResult GraphicsImportGetFlags (
   GraphicsImportComponent    ci,
   long                       *flags );
Parameters
ci

The component instance that identifies your connection to a graphics importer component.
flags

Pointer to a long integer to receive the current flags (see below). See these constants: 
kGraphicsImporterDontDoGammaCorrection
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetFlags (
   GraphicsImportComponent    ci,
   long                       *flags );

/*GetCompressionTime

Determines the estimated amount of time required to compress a given image.

OSErr GetCompressionTime (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecType              cType,
   CompressorComponent    codec,
   CodecQ                 *spatialQuality,
   CodecQ                 *temporalQuality,
   unsigned long          *compressTime );
Parameters
src

A handle to the source image. The source image must be stored in a pixel map structure. The compressor uses only the bit depth of this image to determine the compression time. You may set this parameter to NIL if you are interested only in information about quality settings.
srcRect

A pointer to a rectangle defining the portion of the source image to compress. You may set this parameter to NIL if you are interested only in information about quality settings. GetCompressionTime then uses the bounds of the source pixel map.
colorDepth

The depth at which the image is to be compressed. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by the GetCodecInfo function
cType

You must set this parameter to a valid compressor type constant; see Codec Identifiers.
codec

Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). You can also specify a component instance. This may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
spatialQuality

A pointer to a field containing a constant (see below) that defines the desired compressed image quality. The Image Compression Manager sets this field to the closest actual quality that the compressor can achieve. If you are not interested in this information, pass NIL in this parameter. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
temporalQuality

A pointer to a field containing a constant (see below) that defines the desired temporal quality. Use this value only with images that are part of image sequences. The Image Compression Manager sets this field to the closest actual quality that the compressor can achieve. If you are not interested in this information, pass NIL in this parameter.
compressTime

A pointer to a field to receive the compression time in milliseconds. If the compressor cannot determine the amount of time required to compress the image or if the compressor does not support this function, this field is set to 0. If you are not interested in this information, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to verify that the quality settings you desire are supported by a given compressor component. You specify the compression characteristics, including compression type and quality, along with the image. The Image Compression Manager returns the maximum compression time for the specified image and parameters. Note that some compressors may not support this function. If the component you specify does not support this function, the Image Compression Manager returns a time value of 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCompressionTime (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecType              cType,
   CompressorComponent    codec,
   CodecQ                 *spatialQuality,
   CodecQ                 *temporalQuality,
   unsigned long          *compressTime );

/*DecompressSequenceFrame

Obsolete. See DecompressSequenceFrameS.

OSErr DecompressSequenceFrame (
   ImageSequence                 seqID,
   Ptr                           data,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressSequenceFrame (
   ImageSequence                 seqID,
   Ptr                           data,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );

/*QTGetPixelSize

Returns the bits per pixel for a given pixel format.

short QTGetPixelSize (
   OSType    PixelFormat );
Parameters
PixelFormat

A constant that identifies the pixel format; see Pixel Formats. This function returns meaningful information only for non-planar formats.
Return Value

The bits per pixel. Returns 0 if the format is unknown.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

short QTGetPixelSize (
   OSType    PixelFormat );

/*QTGetPixMapPtrRowBytes

Gets the rowBytes value for a pixel map accessed by a pointer.

long QTGetPixMapPtrRowBytes (
   PixMapPtr    pm );
Parameters
pm

A pointer to a PixMap structure.
Return Value

The rowBytes value.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

long QTGetPixMapPtrRowBytes (
   PixMapPtr    pm );

/*CompSub

Undocumented

void CompSub (
   wide    *src,
   wide    *dst );
Parameters
src

Undocumented
dst

Undocumented
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void CompSub (
   wide    *src,
   wide    *dst );

/*MapMatrix

Alters an existing matrix so that it defines a transformation from one rectangle to another.

void MapMatrix (
   MatrixRecord    *matrix,
   const Rect      *fromRect,
   const Rect      *toRect );
Parameters
matrix

A pointer to a matrix structure. The MapMatrix function modifies this matrix so that it performs a transformation in the rectangle specified by the toRect parameter that is analogous to the transformation it currently performs in the rectangle specified by the fromRect parameter.
fromRect

A pointer to the source Rect structure.
toRect

A pointer to the destination Rect structure.
Discussion

MapMatrix affects only the scaling and translation attributes of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void MapMatrix (
   MatrixRecord    *matrix,
   const Rect      *fromRect,
   const Rect      *toRect );

/*NewStdPixUPP

Allocates a Universal Procedure Pointer for the StdPixProc callback.

StdPixUPP NewStdPixUPP (
   StdPixProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewStdPixProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
StdPixUPP NewStdPixUPP (
   StdPixProcPtr    userRoutine );

/*DisposeStdPixUPP

Disposes of a StdPixUPP pointer.

void DisposeStdPixUPP (
   StdPixUPP    userUPP );
Parameters
userUPP

A StdPixUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void DisposeStdPixUPP (
   StdPixUPP    userUPP );

/*GetCompressedPixMapInfo

Retrieves information about a compressed image.

OSErr GetCompressedPixMapInfo (
   PixMapPtr                 pix,
   ImageDescriptionHandle    *desc,
   Ptr                       *data,
   long                      *bufferSize,
   ICMDataProcRecord         *dataProc,
   ICMProgressProcRecord     *progressProc );
Parameters
pix

Points to a structure that holds encoded compressed image data.
desc

A pointer to a field that is to receive a handle to the ImageDescription structure that defines the compressed image. If you are not interested in this information, specify NIL in this parameter.
data

A pointer to a field that is to receive a pointer to the compressed image data. If the entire compressed image cannot be stored at this location, you can define a data-loading function for this operation. If you are not interested in this information, you may specify NIL in this parameter.
bufferSize

A pointer to a field that is to receive the size of the buffer to be used by the data-loading function specified by the dataProc parameter. If there is no data-loading function defined for this operation, this parameter is ignored. If you are not interested in this information, you may specify NIL in this parameter.
dataProc

A pointer to an ICMDataProc callback. If there is not enough memory to store the compressed image, the decompressor calls a function you provide that loads more compressed data. If there is no data-loading function for this image, the function sets the dataProc field in the function structure to NIL. If you are not interested in this information, specify NIL in this parameter.
progressProc

A pointer to an ICMProgressProc callback. During a decompression operation, the decompressor may occasionally call a function you provide in order to report its progress. If there is no progress function for this image, the function sets the progressProc field in the function structure to NIL. If you pass a value of -1, QuickTime provides a standard progress function. If you are not interested in progress information, specify NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCompressedPixMapInfo (
   PixMapPtr                 pix,
   ImageDescriptionHandle    *desc,
   Ptr                       *data,
   long                      *bufferSize,
   ICMDataProcRecord         *dataProc,
   ICMProgressProcRecord     *progressProc );

/*SetImageDescriptionCTable

Updates the custom ColorTable structure for an image.

OSErr SetImageDescriptionCTable (
   ImageDescriptionHandle    desc,
   CTabHandle                ctable );
Parameters
desc

Contains a handle to the appropriate ImageDescription structure. The function updates the size of the structure to accommodate the new ColorTable structure and removes the old color table, if one is present.
ctable

A handle to the new ColorTable structure. The function loads this color table into the ImageDescription structure referred to by the desc parameter. Set this parameter to NIL to remove a ColorTable structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function does not change the image data, just the color table.
Special Considerations

This function is rarely used. Typically, you supply the color table when your application compresses an image, and the Image Compression Manager stores the ColorTable structure with the image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr SetImageDescriptionCTable (
   ImageDescriptionHandle    desc,
   CTabHandle                ctable );

/*CompressSequenceBegin

Signals the beginning of the process of compressing a sequence of frames.

OSErr CompressSequenceBegin (
   ImageSequence             *seqID,
   PixMapHandle              src,
   PixMapHandle              prev,
   const Rect                *srcRect,
   const Rect                *prevRect,
   short                     colorDepth,
   CodecType                 cType,
   CompressorComponent       codec,
   CodecQ                    spatialQuality,
   CodecQ                    temporalQuality,
   long                      keyFrameRate,
   CTabHandle                ctable,
   CodecFlags                flags,
   ImageDescriptionHandle    desc );
Parameters
seqID

A pointer to a field to receive the unique identifier for this sequence. You must supply this identifier to all subsequent Image Compression Manager functions that relate to this sequence.
src

A handle to a pixel map that will contain the image to be compressed. The image must be stored in a pixel map structure.
prev

A handle to a pixel map that will contain a previous image. The compressor uses this buffer to store a previous image against which the current image (stored in the pixel map referred to by the src parameter) is compared when performing temporal compression. This pixel map must be created at the same depth and with the same color table as the source image. The compressor manages the contents of this pixel map based upon several considerations, such as the key frame rate and the degree of difference between compared images. If you want the compressor to allocate this pixel map or if you do not want to perform temporal compression (that is, you have set the value of the temporalQuality parameter to 0), set this parameter to NIL.
srcRect

A pointer to a rectangle defining the portion of the image to compress. The compressor applies this rectangle to the image stored in the buffer referred to by the src parameter.
prevRect

A pointer to a rectangle defining the portion of the previous image to use for temporal compression. The compressor uses this portion of the previous image as the basis of comparison with the current image. The compressor ignores this parameter if you have not provided a buffer for previous images. This rectangle must be the same size as the source rectangle, which is specified with the srcRect parameter.
colorDepth

The depth at which the sequence is likely to be viewed. Compressors may use this as an indication of the color or grayscale resolution of the compressed images. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by the GetCodecInfo function.
cType

You must set this parameter to a valid compressor type constant. See Codec Identifiers.
codec

Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
spatialQuality

A pointer to a field containing a constant (see below) that defines the desired compressed image quality. You can change the value of this parameter for an active sequence by calling SetCSequenceQuality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
temporalQuality

A pointer to a field containing a constant (see below) that defines the desired temporal quality. This parameter governs the level of compression you desire with respect to information between successive frames in the sequence. Set to 0 if you do not want temporal compression. You can change the value of this parameter for an active sequence by calling SetCSequenceQuality.
keyFrameRate

Specifies the maximum number of frames allowed between key frames. The compressor determines the optimum placement for key frames based upon the amount of redundancy between adjacent images in the sequence. Consequently, the compressor may insert key frames more frequently than you have requested. However, the compressor never places fewer key frames than is indicated by the setting of the keyFrameRate parameter. The compressor ignores this parameter if you have not requested temporal compression (that is, you have set the temporalQuality parameter to 0). If you pass in 0 in this parameter, this indicates that there are no key frames in the sequence. If you pass in any other number, it specifies the number of non-key frames between key frames. Set this parameter to 1 to specify all key frames, to 2 to specify every other frame as a key frame, to 3 to specify every third frame as a key frame, and so forth. Your application may change the key frame rate for an active sequence by calling SetCSequenceKeyFrameRate.
ctable

A handle to a custom color lookup table. Your program may use this parameter to indicate a custom color lookup table to be used with this image. If the value of the colorDepth parameter is less than or equal to 8 and the custom color lookup table is different from that of the source pixel map (that is, the ctSeed field values differ in the two pixel maps), the compressor remaps the colors of the image to the custom colors. If you set the colorDepth parameter to 16, 24, or 32, the compressor stores the custom color table with the compressed image. The compressor may use the table to specify the best colors to use when displaying the image at lower bit depths. The compressor ignores the ctable parameter when colorDepth is set to 33, 34, 36, or 40. If you set this parameter to NIL, the compressor uses the color lookup table from the source pixel map.
flags

Contains flags (see below) that provide further control information. You must set either codecFlagUpdatePrevious or codecFlagUpdatePreviousComp to 1. Set unused flags to 0. See these constants: 
codecFlagUpdatePrevious
codecFlagUpdatePreviousComp
codecFlagWasCompressed
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned image description structure. Your application should store this image description with the compressed sequence. During the compression operation, the Image Compression Manager and the compressor component update the contents of this image description. Consequently, you should not store the image description until the sequence has been completely processed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The Image Compression Manager prepares for a sequence-compression operation by reserving appropriate system resources. Hence you must call CompressSequenceBegin before you call CompressSequenceFrame.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr CompressSequenceBegin (
   ImageSequence             *seqID,
   PixMapHandle              src,
   PixMapHandle              prev,
   const Rect                *srcRect,
   const Rect                *prevRect,
   short                     colorDepth,
   CodecType                 cType,
   CompressorComponent       codec,
   CodecQ                    spatialQuality,
   CodecQ                    temporalQuality,
   long                      keyFrameRate,
   CTabHandle                ctable,
   CodecFlags                flags,
   ImageDescriptionHandle    desc );

/*CDSequenceNewDataSource

Creates a new data source.

OSErr CDSequenceNewDataSource (
   ImageSequence              seqID,
   ImageSequenceDataSource    *sourceID,
   OSType                     sourceType,
   long                       sourceInputNumber,
   Handle                     dataDescription,
   ICMConvertDataFormatUPP    transferProc,
   void                       *refCon );
Parameters
seqID

The unique sequence identifier that was returned by the DecompressSequenceBegin function.
sourceID

Returns the new data source identifier.
sourceType

A four-character code describing how the input will be used. This code is usually derived from the information returned by the codec. For example, if a mask plane was passed, this field might contain 'mask'.
sourceInputNumber

More than one instance of a given source type may exist. The first occurrence should have a source input number of 1, the second a source input number of 2, and so on.
dataDescription

A handle to a data structure describing the input data. For compressed image data, this is an ImageDescriptionHandle.
transferProc

A routine that allows the application to transform the type of the input data to the kind of data preferred by the codec. The client of the codec passes the source data in the form most convenient for it. If the codec needs the data in another form, it can negotiate with the client or directly with the Image Compression Manager to obtain the required data format.
refCon

A reference constant to be passed to the transfer procedure. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns a sourceID parameter which must be passed to all other functions that reference the source. All data sources are automatically disposed when the sequence they are associated with is disposed.// CDSequenceNewDataSource coding example
// See "Discovering QuickTime," page 309
{
    ImageSequenceDataSource     lSrc1 =0;
    // Store a description of the first GWorld in hImageDesc1
    nErr =MakeImageDescriptionForPixMap(GetGWorldPixMap(gWorld1),
                    &hImageDesc1);
    // Create a source from the GWorld description.
    nErr =CDSequenceNewDataSource(gEffectSequenceID,
                                    &lSrc1,
                                    'srcA',
                                    1,
                                    (Handle)hImageDesc1,
                                    NIL,
                                    0);
    // Set the data for source srcA to be the pixMap of gWorld1
    CDSequenceSetSourceData(lSrc1,
                            GetPixBaseAddr(GetGWorldPixMap(gWorld1)),
                            (**hImageDesc1).dataSize);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceNewDataSource (
   ImageSequence              seqID,
   ImageSequenceDataSource    *sourceID,
   OSType                     sourceType,
   long                       sourceInputNumber,
   Handle                     dataDescription,
   ICMConvertDataFormatUPP    transferProc,
   void                       *refCon );

/*CDSequenceSetSourceData

Sets data in a new frame to a specific data source.

OSErr CDSequenceSetSourceData (
   ImageSequenceDataSource    sourceID,
   void                       *data,
   long                       dataSize );
Parameters
sourceID

Contains the source identifier of the data source.
data

Points to the data. This pointer must contain a 32-bit clean address.
dataSize

The size of the data buffer.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is called to set data in a new frame to a specific source. For example, as a new frame of compressed data arrives at a source, CDSequenceSetSourceData will be called.// CDSequenceSetSourceData coding example
// See "Discovering QuickTime," page 309
{
    ImageSequenceDataSource     lSrc1 =0;
    // Store a description of the first GWorld in hImageDesc1
    nErr =MakeImageDescriptionForPixMap(GetGWorldPixMap(gWorld1),
                    &hImageDesc1);
    // Create a source from the GWorld description.
    nErr =CDSequenceNewDataSource(gEffectSequenceID,
                                    &lSrc1,
                                    'srcA',
                                    1,
                                    (Handle)hImageDesc1,
                                    NIL,
                                    0);
    // Set the data for source srcA to be the pixMap of gWorld1
    CDSequenceSetSourceData(lSrc1,
                            GetPixBaseAddr(GetGWorldPixMap(gWorld1)),
                            (**hImageDesc1).dataSize);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceSetSourceData (
   ImageSequenceDataSource    sourceID,
   void                       *data,
   long                       dataSize );

/*CompressSequenceFrame

Compresses one of a sequence of frames.

OSErr CompressSequenceFrame (
   ImageSequence                 seqID,
   PixMapHandle                  src,
   const Rect                    *srcRect,
   CodecFlags                    flags,
   Ptr                           data,
   long                          *dataSize,
   UInt8                         *similarity,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Parameters
seqID

Unique sequence identifier that was returned by CompressSequenceBegin.
src

A handle to a pixel map that contains the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress. The compressor applies this rectangle to the image stored in the buffer referred to by the src parameter.
flags

Specifies flags (see below) that provide further control information. You must set either codecFlagUpdatePrevious or codecFlagUpdatePreviousComp to 1. Set unused flags to 0. See these constants: 
codecFlagUpdatePrevious
codecFlagWasCompressed
codecFlagUpdatePreviousComp
codecFlagForceKeyFrame
codecFlagLiveGrab
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. The Image Compression Manager places the actual size of the compressed image into the field referred to by the dataSize parameter. This pointer must contain a 32-bit clean address.
dataSize

A pointer to a field that is to receive the size, in bytes, of the compressed image.
similarity

A pointer to a field that is to receive a similarity value. The CompressSequenceFrame function returns a value that indicates the similarity of the current frame to the previous frame. A value of 0 indicates that the current frame is a key frame in the sequence. A value of 255 indicates that the current frame is identical to the previous frame. Values from 1 through 254 indicate relative similarity, ranging from very different (1) to very similar (254).
asyncCompletionProc

Points to an ICMCompletionProc callback. The compressor calls your completion function when an asynchronous compression operation is complete. You can cause the compression to be performed asynchronously by specifying a completion function if the compressor supports asynchronous compression.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The Image Compression Manager prepares for a sequence-compression operation by reserving appropriate system resources. Hence you must call CompressSequenceBegin before you call CompressSequenceFrame.
Special Considerations

If you specify asynchronous operation, you must not read the compressed data until the compressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous compression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the compressor does not call your completion function. If the asyncCompletionProc parameter is not NIL, the following conditions are in effect: the pixels in the source image must stay valid until the completion function is called with its codecCompletionSource flag, and the resulting compressed data is not valid until it is called with its codecCompletionDest flag set.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CompressSequenceFrame (
   ImageSequence                 seqID,
   PixMapHandle                  src,
   const Rect                    *srcRect,
   CodecFlags                    flags,
   Ptr                           data,
   long                          *dataSize,
   UInt8                         *similarity,
   ICMCompletionProcRecordPtr    asyncCompletionProc );

/*SetCSequencePrev

Allows the application to set the pixel map and boundary rectangle used by the previous frame in temporal compression.

OSErr SetCSequencePrev (
   ImageSequence    seqID,
   PixMapHandle     prev,
   const Rect       *prevRect );
Parameters
seqID

The unique sequence identifier assigned by CompressSequenceBegin or DecompressSequenceBegin.
prev

A handle to the new previous image buffer. You must allocate this buffer using the same pixel depth and ColorTable structure as the source image buffer that you specified with the src parameter when you called CompressSequenceBegin. The compressor uses this buffer to store a previous image against which the current image is compared when performing temporal compression. The compressor manages the contents of this buffer based upon several considerations, such as the key frame rate and the degree of difference between compared images. The current image is stored in the buffer referred to by the src parameter to CompressSequenceBegin. 
prevRect

A pointer to a Rect structure that defines the portion of the previous image to use for temporal compression. The compressor uses this portion of the previous image as the basis of comparison with the current image. This rectangle must be the same size as the source rectangle you specify with the srcRect parameter to CompressSequenceBegin. To get the boundary of a source pixel map, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When you start compressing a sequence, you may assign a previous frame buffer and rectangle with the prev and prevRect parameters to CompressSequenceBegin. If you specified a NIL value for the prev parameter, the compressor allocates an offscreen buffer for the previous frame. In either case you may use this function to assign a new previous frame buffer.
Special Considerations

This is a very specialized function; your application should not need to call it under most circumstances.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr SetCSequencePrev (
   ImageSequence    seqID,
   PixMapHandle     prev,
   const Rect       *prevRect );

/*GetCSequenceMaxCompressionSize

Determines the maximum size an image will be after compression for a given compression sequence.

OSErr GetCSequenceMaxCompressionSize (
   ImageSequence    seqID,
   PixMapHandle     src,
   long             *size );
Parameters
seqID

Contains the unique sequence identifier that was returned by the CompressSequenceBegin function.
src

A handle to the source PixMap structure. The compressor uses only the image's size and pixel depth to determine the maximum size of the compressed image.
size

A pointer to a field to receive the maximum size, in bytes, of the compressed image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is similar to GetMaxCompressionSize, but operates on a compression sequence instead of requiring the application to pass individual parameters about the source image.
Special Considerations

Before calling GetCSequenceMaxCompressionSize you must have already started a compression sequence with CompressSequenceBegin
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCSequenceMaxCompressionSize (
   ImageSequence    seqID,
   PixMapHandle     src,
   long             *size );

/*GraphicsImportGetAsPicture

Creates a QuickDraw picture handle to an imported image.

ComponentResult GraphicsImportGetAsPicture (
   GraphicsImportComponent    ci,
   PicHandle                  *picture );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
picture

Points to a handle to a Picture structure that is to receive the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates a new QuickDraw picture handle containing the image currently in use by the graphics import component. If possible, the image will remain in the compressed format. For example, if the image is from a JFIF file, the picture will contain compressed JPEG data. It is the responsibility of the caller to dispose of the picture handle.
Special Considerations

Graphics import components can save data in several formats, including QuickDraw pictures and QuickTime Image files. This capability is only needed by applications that perform file format translation. Applications that only wish to draw the image can use GraphicsImportDraw.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetAsPicture (
   GraphicsImportComponent    ci,
   PicHandle                  *picture );

/*TransformRgn

Applies a specified matrix to a region.

OSErr TransformRgn (
   MatrixRecordPtr    matrix,
   RgnHandle          rgn );
Parameters
matrix

Points to the matrix for this operation. The TransformRgn function currently supports only translation and scaling operations.
rgn

A handle to the MacRegion structure to be transformed. The function transforms each point in the region according to the specified matrix
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr TransformRgn (
   MatrixRecordPtr    matrix,
   RgnHandle          rgn );

/*DrawTrimmedPictureFile

Draws an image that is stored as a picture file into the current graphics port and trims that image to fit a specified region.

OSErr DrawTrimmedPictureFile (
   short                       srcRefnum,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc );
Parameters
srcRefnum

A file reference number for the source PICT file.
frame

A pointer to the rectangle into which the decompressed image is to be loaded.
trimMask

A handle to a clipping region in the destination coordinate system. The decompressor applies this mask to the destination image and ignores any image data that fall outside the specified region. Set this parameter to NIL if you do not want to clip the source image. In this case, this function acts like DrawPictureFile.
doDither

Indicates whether to dither the image. Use this parameter if you want the image to be dithered when it is displayed on a lower-resolution screen (see below). See these constants: 
defaultDither
forceDither
suppressDither
progressProc

A pointer to an ICMProgressProc callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress function, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to save part of a picture, since the image data that is not within the trim region is ignored and is not included in the destination picture file. All the remaining objects in the resulting object are clipped.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DrawTrimmedPictureFile (
   short                       srcRefnum,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc );

/*DrawTrimmedPicture

Draws an image that is stored as a picture into the current graphics port and trims that image to fit a specified region.

OSErr DrawTrimmedPicture (
   PicHandle                   srcPicture,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc );
Parameters
srcPicture

A handle to the source image, stored as a picture.
frame

A pointer to the rectangle into which the decompressed image is to be loaded.
trimMask

A handle to a clipping region in the destination coordinate system. The decompressor applies this mask to the destination image and ignores any image data that fall outside the specified region. Set this parameter to NIL if you do not want to clip the source image.
doDither

Indicates whether to dither the image. Use this parameter if you want the image to be dithered when it is displayed on a lower-resolution screen (see below). See these constants: 
defaultDither
forceDither
suppressDither
progressProc

A pointer to an ICMProgressProc callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress function, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function works with compressed image data; the source data stays compressed. The function trims the image to fit the specified clipping region. Note that if you just use a clip while making a picture, the data (though not visible) is still stored in the picture.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DrawTrimmedPicture (
   PicHandle                   srcPicture,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc );

/*GetPictureFileHeader

Extracts the picture frame and file header from a specified picture file.

OSErr GetPictureFileHeader (
   short             refNum,
   Rect              *frame,
   OpenCPicParams    *header );
Parameters
refNum

A file reference number for the source PICT file.
frame

A pointer to a rectangle that is to receive the picture frame rectangle of the picture file. This function places the picFrame rectangle from the picture structure into the rectangle referred to by the frame parameter. If you are not interested in this information, pass NIL in this parameter.
header

A pointer to an OpenCPicParams structure. The GetPictureFileHeader function places the header from the specified picture file into this structure. If you are not interested in this information, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your program can use the information returned in the header parameter to determine how to draw an image without having to read the picture file.
Special Considerations

Note that this function always returns a version 2 header. If the source file is a version 1 PICT file, the GetPictureFileHeader function converts the header into version 2 format before returning it to your application. See Inside Macintosh: Imaging With QuickDraw for more information about picture headers.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetPictureFileHeader (
   short             refNum,
   Rect              *frame,
   OpenCPicParams    *header );

/*GraphicsImportSetGraphicsMode

Sets the graphics transfer mode for an imported image.

ComponentResult GraphicsImportSetGraphicsMode (
   GraphicsImportComponent    ci,
   long                       graphicsMode,
   const RGBColor             *opColor );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
graphicsMode

The graphics transfer mode to use for drawing the image; see Graphics Transfer Modes.
opColor

A pointer to an RGBColor structure that describes the color to use for blending and transparent operations.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to specify the graphics transfer mode and color to use for blending and transparent operations.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetGraphicsMode (
   GraphicsImportComponent    ci,
   long                       graphicsMode,
   const RGBColor             *opColor );

/*GraphicsImportGetMatrix

Returns the transformation matrix to be used for drawing an imported image.

ComponentResult GraphicsImportGetMatrix (
   GraphicsImportComponent    ci,
   MatrixRecord               *matrix );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
matrix

A pointer to a MatrixRecord structure that defines the transformation matrix that applies to the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The transformation matrix is initialized to the identity matrix when the graphics import component is instantiated.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetMatrix (
   GraphicsImportComponent    ci,
   MatrixRecord               *matrix );

/*GraphicsExportRequestSettings

Displays a dialog for the user to configure graphics exporter settings, if applicable.

ComponentResult GraphicsExportRequestSettings (
   GraphicsExportComponent    ci,
   ModalFilterYDUPP           filterProc,
   void                       *yourDataProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
filterProc

A ModalFilterYDProc callback. If you don't need one, pass NIL.
yourDataProc

An extra parameter that will be passed to the ModalFilterProc callback when it is called. If you don't need one, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Some graphics exporters don't support settings dialogs, and so don't implement this call. To find out whether a graphics exporter implements this call, you can use this code:CallComponentCanDo( myGraphicsExporter,
                    kGraphicsExportRequestSettingsSelect);

Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportRequestSettings (
   GraphicsExportComponent    ci,
   ModalFilterYDUPP           filterProc,
   void                       *yourDataProc );

/*GraphicsExportSetDepth

Defines the depth to use in a graphics export operation.

ComponentResult GraphicsExportSetDepth (
   GraphicsExportComponent    ci,
   long                       depth );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
depth

A value describing the depth of the image data. Some image file formats support more than one pixel depth.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The BMP, JPEG, Photoshop, PNG, PICT, QuickTime Image, TGA and TIFF graphics exporters support the depth setting. Some image file formats support more than one pixel depth.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetDepth (
   GraphicsExportComponent    ci,
   long                       depth );

/*MakeImageDescriptionForEffect

Returns an ImageDescription structure you can use to help create a sample description for an effect.

OSErr MakeImageDescriptionForEffect (
   OSType                    effectType,
   ImageDescriptionHandle    *idh );
Parameters
effectType

The four-character code identifying the type of effect to make an image description for. See Effects Codes.
idh

The handle of an ImageDescription structure. On entry, this parameter normally points to an ImageDescription structure whose contents are NIL. On return, the structure is correctly filled out for the selected effect type.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

To create a sample description, you create and fill out a data structure of type ImageDescription. This function simplifies this process. Only sample descriptions made with this function can be used in stacked effects, where one effect track acts as a source for another.

The following sample code creates a sample description:.// MakeImageDescriptionForEffect coding example
// Return a new image description with default and specified values.
ImageDescriptionHandle QTEffSeg_MakeSampleDescription (
                   OSType theEffectType, short theWidth, short theHeight)
{
    ImageDescriptionHandle      mySampleDesc =NIL;
#if USES_MAKE_IMAGE_DESC_FOR_EFFECT
    OSErr  myErr =noErr;
    // create a new sample description
    myErr =MakeImageDescriptionForEffect(theEffectType, &mySampleDesc);
    if (myErr !=noErr)
        return(NIL);
#else
    // create a new sample description
    mySampleDesc =(ImageDescriptionHandle)
                                 NewHandleClear(sizeof(ImageDescription));
    if (mySampleDesc ==NIL)
        return(NIL);
 
    // fill in the fields of the sample description
    (**mySampleDesc).cType =theEffectType;
    (**mySampleDesc).idSize =sizeof(ImageDescription);
    (**mySampleDesc).hRes =72L << 16;
    (**mySampleDesc).vRes =72L << 16;
    (**mySampleDesc).frameCount =1;
    (**mySampleDesc).depth =0;
    (**mySampleDesc).clutID =-1;
#endif
 
    (**mySampleDesc).vendor =kAppleManufacturer;
    (**mySampleDesc).temporalQuality =codecNormalQuality;
    (**mySampleDesc).spatialQuality =codecNormalQuality;
    (**mySampleDesc).width =theWidth;
    (**mySampleDesc).height =theHeight;
 
    return(mySampleDesc);
}

Version Notes

Introduced in QuickTime 4. Image descriptions built using sample code from earlier versions of QuickTime cannot be used when stacking effects.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr MakeImageDescriptionForEffect (
   OSType                    effectType,
   ImageDescriptionHandle    *idh );

/*GetImageDescriptionExtension

Returns a new handle with the data from a specified image description extension.

OSErr GetImageDescriptionExtension (
   ImageDescriptionHandle    desc,
   Handle                    *extension,
   long                      idType,
   long                      index );
Parameters
desc

A handle to the appropriate ImageDescription structure.
extension

A pointer to a field to receive a handle to the returned data. The GetImageDescriptionExtension function returns the extended data for the image described by the ImageDescription structure referred to by the desc parameter. The function correctly sizes the handle for the data it returns.
idType

Specifies the extension's type value. Use this parameter to determine the data type of the extension. This parameter contains a four-character code, similar to an OSType field value.
index

The index of the extension to retrieve. This is a number between 1 and the count returned by CountImageDescriptionExtensionType.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows the application to get a copy of a specified image description extension. Note that each compressor type may have its own format for the extended data that is stored with an image. The extended data is similar in concept to the user data that applications can associate with QuickTime movies. Once you have added extended data to an image, you cannot delete it.
Special Considerations

The Image Compression Manager allocates a new handle and passes it back in the extension parameter. Your application should dispose of the handle when it is no longer needed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetImageDescriptionExtension (
   ImageDescriptionHandle    desc,
   Handle                    *extension,
   long                      idType,
   long                      index );

/*CompressPicture

Compresses a single-frame image stored as a picture structure and places the result in another picture.

OSErr CompressPicture (
   PicHandle    srcPicture,
   PicHandle    dstPicture,
   CodecQ       quality,
   CodecType    cType );
Parameters
srcPicture

A handle to the source image, stored as a picture.
dstPicture

A handle to the destination for the compressed image. The compressor resizes this handle for the result data.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

You must set this parameter to a valid compressor identifier; see Codec Identifiers. If the value passed in is 0, or 'raw ', and the source picture is compressed, the destination picture is created as an uncompressed picture and does not require QuickTime for its display.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function compresses only image data. Any other types of data in the picture, such as text, graphics primitives, and previously compressed images, are not modified in any way and are passed through to the destination picture. This function supports parameters governing image quality and compressor type. The compressor infers the other compression parameters from the image data in the source picture.
Special Considerations

If a picture with multiple pixel maps and other graphical objects is passed, the pixel maps will be compressed individually and the other graphic objects will not be affected. This function does not use the graphics port.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr CompressPicture (
   PicHandle    srcPicture,
   PicHandle    dstPicture,
   CodecQ       quality,
   CodecType    cType );

/*NewICMDataUPP

Allocates a Universal Procedure Pointer for the ICMDataProc callback.

ICMDataUPP NewICMDataUPP (
   ICMDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMDataUPP NewICMDataUPP (
   ICMDataProcPtr    userRoutine );

/*FDecompressImage

Decompresses a single-frame image into a pixel map structure, with added control over the decompression process.

OSErr FDecompressImage (
   Ptr                         data,
   ImageDescriptionHandle      desc,
   PixMapHandle                dst,
   const Rect                  *srcRect,
   MatrixRecordPtr             matrix,
   short                       mode,
   RgnHandle                   mask,
   PixMapHandle                matte,
   const Rect                  *matteRect,
   CodecQ                      accuracy,
   DecompressorComponent       codec,
   long                        bufferSize,
   ICMDataProcRecordPtr        dataProc,
   ICMProgressProcRecordPtr    progressProc );
Parameters
data

Points to the compressed image data. If the entire compressed image cannot be stored at this location, your application may provide a data-loading function (see the discussion of the dataProc parameter to this function). This pointer must contain a 32-bit clean address. 
desc

A handle to the ImageDescription structure that describes the compressed image.
dst

A handle to the pixel map where the decompressed image is to be displayed. Set the current graphics port to the port that contains this pixel map.
srcRect

A pointer to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by (0,0) and ((**desc).width,(**desc).height). If you want to decompress the entire source image, set this parameter to NIL. If the parameter is NIL, the rectangle is set to the rectangle structure of the ImageDescription structure.
matrix

Points to a matrix structure that specifies how to transform the image during decompression. You can use the matrix structure to translate or scale the image during decompression. If you do not want to apply such effects, set the matrix parameter to NIL.
mode

The transfer mode for the operation; see Graphics Transfer Modes.
mask

A handle to a clipping region in the destination coordinate system. If specified, the decompressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL.
matte

A handle to a pixel map that contains a blend matte. You can use the blend matte to cause the decompressed image to be blended into the destination pixel map. The matte can be defined at any supported pixel depth; the matte depth need not correspond to the source or destination depths. However, the matte must be in the coordinate system of the source image. If you do not want to apply a blend matte, set this parameter to NIL.
matteRect

A pointer to a rectangle defining a portion of the blend matte to apply. If you do not want to use the entire matte referred to by the matte parameter, use this parameter to specify a rectangle within that matte. If specified, this rectangle must be the same size as the rectangle specified by the srcRect parameter. If you want to use the entire matte, or if you are not providing a blend matte, set this parameter to NIL.
accuracy

A constant (see below) that defines the desired compression accuracy. For a good display of still images, you should specify at least codecHighQuality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
codec

A decompressor identifier. Specify a particular decompressor by setting this parameter to its identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
bufferSize

The size of the buffer to be used by the data-loading function specified by the dataProc parameter. If you have not specified a data-loading function, set this parameter to 0.
dataProc

Points to an ICMDataProc data-loading callback. If there is not enough memory to store the compressed image, the compressor calls a function you provide that loads more compressed data. If you have not provided a data-unloading callback, set this parameter to NIL. In this case, the compressor expects that the entire compressed image is in the memory location specified by the data parameter.
progressProc

Points to an ICMProgressProc progress callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress callback, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function gives your application greater control over the parameters that guide the decompression operation. If you find that you do not need this level of control, use DecompressImage. Note that this function is invoked through the StdPix function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr FDecompressImage (
   Ptr                         data,
   ImageDescriptionHandle      desc,
   PixMapHandle                dst,
   const Rect                  *srcRect,
   MatrixRecordPtr             matrix,
   short                       mode,
   RgnHandle                   mask,
   PixMapHandle                matte,
   const Rect                  *matteRect,
   CodecQ                      accuracy,
   DecompressorComponent       codec,
   long                        bufferSize,
   ICMDataProcRecordPtr        dataProc,
   ICMProgressProcRecordPtr    progressProc );

/*DrawPictureFile

Draws an image from a specified picture file in the current graphics port.

OSErr DrawPictureFile (
   short                       refNum,
   const Rect                  *frame,
   ICMProgressProcRecordPtr    progressProc );
Parameters
refNum

A file reference number for the source PICT file.
frame

A pointer to the rectangle into which the image is to be loaded. The compressor scales the source image to fit into this destination rectangle.
progressProc

Points to an ICMProgressProc callback. During the operation, the draw function may occasionally call a function you provide in order to report its progress; see ICMProgressProcRecord. If you have not provided a progress function, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the picture that it finds in the picture file specified by the refNum parameter within the rectangle specified by the frame parameter. The Image Compression Manager performs any spooling that may be necessary when reading the picture file. Specify a clipping region appropriate for your picture before drawing it. If the clipping region is very large (as it is when a graphics port is initialized) and you want to scale the picture, the clipping region can become invalid when DrawPictureFile scales the clipping region, in which case your picture will not be drawn. On the other hand, if the graphics port specifies a small clipping region, part of your drawing may be clipped when DrawPictureFile draws it. Setting a clipping region equal to the port rectangle of the current graphics port always sets a valid clipping region.
Special Considerations

When it scales fonts, DrawPictureFile changes the size of the font instead of scaling the bits. However, the widths used by bitmap fonts are not always linear. For example, the 12-point width isn't exactly 1/2 of the 24-point width. This can cause lines of text to become slightly longer or shorter as the picture is scaled. The easiest way to avoid such problems is to specify a destination rectangle that is the same size as the bounding rectangle for the picture.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DrawPictureFile (
   short                       refNum,
   const Rect                  *frame,
   ICMProgressProcRecordPtr    progressProc );

/*SetDSequenceFlags

Sets data loading flags.

OSErr SetDSequenceFlags (
   ImageSequence    seqID,
   long             flags,
   long             flagsMask );
Parameters
seqID

The unique sequence identifier assigned by CompressSequenceBegin or DecompressSequenceBegin.
flags

Flags (see below) for data loading. See these constants: 
codecDSequenceSingleField
flagsMask

Use this field to preserve the state of any flags you do not wish to alter. If a flag (see below) is set in this field, and is not set in the flags parameter, it will not be changed from its current setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr SetDSequenceFlags (
   ImageSequence    seqID,
   long             flags,
   long             flagsMask );

/*ICMSetPixelFormatInfo

Lets you define your own pixel format.

OSErr ICMSetPixelFormatInfo (
   OSType                   PixelFormat,
   ICMPixelFormatInfoPtr    theInfo );
Parameters
PixelFormat

A pixel format constant. See Pixel Formats.
theInfo

A pointer to an ICMPixelFormatInfo structure containing a definition of the new pixel format.
Return Value

Returns paramErr if the format is already defined. See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr ICMSetPixelFormatInfo (
   OSType                   PixelFormat,
   ICMPixelFormatInfoPtr    theInfo );

/*GraphicsImportDoExportImageFileDialog

Presents a dialog box letting the user save an imported image in a foreign file format.

ComponentResult GraphicsImportDoExportImageFileDialog (
   GraphicsImportComponent    ci,
   const FSSpec               *inDefaultSpec,
   StringPtr                  prompt,
   ModalFilterYDUPP           filterProc,
   OSType                     *outExportedType,
   FSSpec                     *outExportedSpec,
   ScriptCode                 *outScriptTag );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
inDefaultSpec

A pointer to an FSSpec that suggests a default name for the file. If you don't want to suggest a default name, pass NIL.
prompt

A pointer to a prompt string that appears in the standard put dialog box; it may be NIL, in which case a default string is used.
filterProc

A modal filter function to be passed to the Mac OS function CustomPutFile; see Inside Macintosh: Files for more information. If you don't need to filter events, pass NIL.
outExportedType

A pointer to a variable that will receive the type of the export file that was chosen by the user. If you don't want this information, pass NIL. See File Types and Creators.
outExportedSpec

A pointer to a variable that will receive the FSSpec of the file that was written. If you don't want this information, pass NIL.
outScriptTag

A pointer to a variable that will receive the script system in which the exported file name is to be displayed. See Localization Codes. If you don't want this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function presents the user with an extended Standard File dialog box that allows the image currently in use by the graphics import component to be exported to a file, in a format of the user's choice.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDoExportImageFileDialog (
   GraphicsImportComponent    ci,
   const FSSpec               *inDefaultSpec,
   StringPtr                  prompt,
   ModalFilterYDUPP           filterProc,
   OSType                     *outExportedType,
   FSSpec                     *outExportedSpec,
   ScriptCode                 *outScriptTag );

/*GraphicsImportGetColorSyncProfile

Returns a ColorSync profile for an imported image, if one is embedded in the image file.

ComponentResult GraphicsImportGetColorSyncProfile (
   GraphicsImportComponent    ci,
   Handle                     *profile );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
profile

A pointer to receive a handle containing a ColorSync profile, or NIL if the image file does not contain one.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Some graphics importers don't implement this function. The caller is responsible for disposing of the returned handle.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetColorSyncProfile (
   GraphicsImportComponent    ci,
   Handle                     *profile );

/*GetBestDeviceRect

Selects the deepest of all available graphics devices, while treating 16-bit and 32-bit screens as having equal depth.

OSErr GetBestDeviceRect (
   GDHandle    *gdh,
   Rect        *rp );
Parameters
gdh

A pointer to the handle of the rectangle for the chosen device. If you do not need the information in this parameter returned, specify NIL.
rp

A pointer to the rectangle that is adjusted for the height of the menu bar if the device is the main device. If you do not need the information in this parameter returned, specify NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function does not center a rectangle on a device. Rather, it returns the rectangle for the best device. The following code sample illustrates its use:// GetBestDeviceRect coding example
// See "Discovering QuickTime," page 265
WindowRef MakeMyWindow (void)
{
    WindowRef   pMacWnd;
    Rect        rectWnd ={0, 0, 120, 160};
    Rect        rectBest;
    // figure out the best monitor for the window
    GetBestDeviceRect(NIL, &rectBest);
    // put the window in the top left corner of that monitor
    OffsetRect(&rectWnd, rectBest.left + 10, rectBest.top + 50);
    // create the window
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pGrabber",
                            TRUE, noGrowDocProc, (WindowRef)-1, TRUE, 0);
    // set the port to the new window
    SetPort(pMacWnd);
    return pMacWnd;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetBestDeviceRect (
   GDHandle    *gdh,
   Rect        *rp );

/*GraphicsExportSetOutputHandle

Sets a handle to the output of a graphics export operation.

ComponentResult GraphicsExportSetOutputHandle (
   GraphicsExportComponent    ci,
   Handle                     h );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
h

The output handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputHandle (
   GraphicsExportComponent    ci,
   Handle                     h );

/*CDSequenceEquivalentImageDescription

Reports whether two image descriptions are the same.

OSErr CDSequenceEquivalentImageDescription (
   ImageSequence             seqID,
   ImageDescriptionHandle    newDesc,
   Boolean                   *equivalent );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
newDesc

A handle to the ImageDescription structure structure that describes the compressed image.
equivalent

A pointer to a Boolean value. If the ImageDescriptionHandle provided in the newDesc parameter is equivalent to the ImageDescription structure currently in use by the image sequence, this value is set to TRUE. If the ImageDescriptionHandle is not equivalent, and therefore a new image sequence must be created to display an image using the new image description, this value is set to FALSE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows an application to ask whether two image descriptions are the same. If they are, the decompressor does not have to create a new image decompression sequence to display those images.
Special Considerations

The Image Compression Manager can only implement part of this function by itself. There are some fields in the ImageDescription structure that it knows are irrelevant to the decompressor. If the Image Compression Manager determines that there are differences in fields that may be significant to the codec, it calls the function ImageCodecIsImageDescriptionEquivalent to ask the codec.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceEquivalentImageDescription (
   ImageSequence             seqID,
   ImageDescriptionHandle    newDesc,
   Boolean                   *equivalent );

/*EqualMatrix

Compares two matrices and returns a result that indicates whether the matrices are equal.

Boolean EqualMatrix (
   const MatrixRecord    *m1,
   const MatrixRecord    *m2 );
Parameters
m1

A pointer to one matrix for the compare operation.
m2

A pointer to the other matrix for the compare operation.
Return Value

TRUE if the matrices are equal, FALSE otherwise.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
Boolean EqualMatrix (
   const MatrixRecord    *m1,
   const MatrixRecord    *m2 );

/*DisposeICMProgressUPP

Disposes of an ICMProgressUPP pointer.

void DisposeICMProgressUPP (
   ICMProgressUPP    userUPP );
Parameters
userUPP

An ICMProgressUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void DisposeICMProgressUPP (
   ICMProgressUPP    userUPP );

/*GraphicsImportSetImageIndex

Specifies the image index for an imported image.

ComponentResult GraphicsImportSetImageIndex (
   GraphicsImportComponent    ci,
   unsigned long              imageIndex );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageIndex

The image index. Image indexes are one-based; 0 is considered a special index by some importers, and treated the same as 1 by others. The default image index is 1.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The base graphics importer ensures that the image index is no greater than the image count returned by GraphicsImportGetImageCount.
Special Considerations

The base graphics importer implements this function. Format-specific importers should delegate it.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetImageIndex (
   GraphicsImportComponent    ci,
   unsigned long              imageIndex );

/*GraphicsImportGetImageCount

Returns the number of images in an imported image file.

ComponentResult GraphicsImportGetImageCount (
   GraphicsImportComponent    ci,
   unsigned long              *imageCount );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageCount

Points to a variable to receive the number of images.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Most image file formats don't support multiple images. Of the image formats supported by QuickTime 4, however, TIFF files can support multiple images, Photoshop files can contain multiple layers and FlashPix files can contain multiple resolutions. The base graphics importer returns a count of 1.
Special Considerations

Format-specific importers for multiple-image formats should override this function; other importers should delegate it.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetImageCount (
   GraphicsImportComponent    ci,
   unsigned long              *imageCount );

/*NewICMFlushUPP

Allocates a Universal Procedure Pointer for the ICMFlushProc callback.

ICMFlushUPP NewICMFlushUPP (
   ICMFlushProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMFlushProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
  #define NewICMFlushProc(userRoutine)                        NewICMFlushUPP(userRoutine)

ICMFlushUPP NewICMFlushUPP (
   ICMFlushProcPtr    userRoutine );

/*GraphicsImportExportImageFile

Saves an imported image in a foreign file format.

ComponentResult GraphicsImportExportImageFile (
   GraphicsImportComponent    ci,
   OSType                     fileType,
   OSType                     fileCreator,
   const FSSpec               *fss,
   ScriptCode                 scriptTag );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
fileType

The file type for the new image file, such as 'JPEG'. See File Types and Creators.
fileCreator

The file creator for the new image file. See File Types and Creators. You may pass 0, in which case a default file creator for this file type is used.
fss

A pointer to the FSSpec structure that identifies the file that is to receive the exported image.
scriptTag

The script system in which the file name is to be displayed; see Localization Codes. If you have established the name and location of the file using one of the Standard File Package functions, use the script code returned in the reply record (reply.sfScript). Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript. See Inside Macintosh: Files for more information about script specifications.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates a new file containing the image currently in use by the graphics import component. The new file is compressed in a format corresponding to the provided file type. If a non-identity matrix has been applied to the graphics import component, this matrix is applied to the image before export. Since most image formats don't support nonzero top-left coordinates, the matrix is temporarily adjusted to ensure that the exported image's bounds have top-left coordinates at (0,0). If the matrix does not map the graphics import component's source rectangle to a rectangle, there will be extra white space left around the image.
Special Considerations

Graphics import components can save data in several formats, including QuickDraw pictures and QuickTime Image files. This capability is only needed by applications that perform file format translation. Applications that only wish to draw the image can use GraphicsImportDraw.
Version Notes

In QuickTime 3, the supported export file types are kQTFileTypePicture, kQTFileTypeQuickTimeImage, kQTFileTypeBMP, kQTFileTypeJPEG, and kQTFileTypePhotoShop. QuickTime 4 uses graphics exporter components to implement image export.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportExportImageFile (
   GraphicsImportComponent    ci,
   OSType                     fileType,
   OSType                     fileCreator,
   const FSSpec               *fss,
   ScriptCode                 scriptTag );

/*GraphicsImportGetExportImageTypeList

Returns information about available export formats for a graphics importer.

ComponentResult GraphicsImportGetExportImageTypeList (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
qtAtomContainerPtr

A pointer to a QuickTime atom container that is to receive the type list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container of type 'expo' containing information about the file types that can be exported by the graphics import component. For each file type, the atom container contains the following child atoms: 'ftyp', the exported file type; 'mime'[atom], the MIME type for this format (optional); 'ext ', the suggested file extension for this format; and 'desc', a human-readable name for this format. The 'ftyp' atom contains an OSType; the other atoms contain nonterminated strings.
Special Considerations

It is the responsibility of the caller to dispose of the 'expo' atom container.
Version Notes

In QuickTime 3, the supported export file types are kQTFileTypePicture, kQTFileTypeQuickTimeImage, kQTFileTypeBMP, kQTFileTypeJPEG, and kQTFileTypePhotoShop. In QuickTime 4, the generic graphics importer builds this atom container from the values returned by the installed graphics exporter components.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetExportImageTypeList (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );

/*DecompressSequenceFrameWhen

Queues a frame for decompression and specifies the time at which decompression will begin.

OSErr DecompressSequenceFrameWhen (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc,
   const ICMFrameTimeRecord      *frameTime );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address. 
dataSize

The size of the data buffer.
inFlags

Contains flags (see below) that provide further control information. See these constants: 
codecFlagNoScreenUpdate
codecFlagDontOffscreen
codecFlagOnlyScreenUpdate
outFlags

Contains status flags (see below). The decompressor updates these flags at the end of the decompression operation. See these constants: 
codecFlagUsedNewImageBuffer
codecFlagUsedImageBuffer
codecFlagDontUseNewImageBuffer
codecFlagInterlaceUpdate
codecFlagCatchUpDiff
asyncCompletionProc

Points to an ICMCompletionProcRecord structure. The compressor calls your completion function when an asynchronous decompression operation is complete. You can cause the decompression to be performed asynchronously by specifying a completion function. If you specify asynchronous operation, you must not read the decompressed image until the decompressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous decompression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the decompressor does not call your completion function.
frameTime

Points to an ICMFrameTimeRecord structure, which contains the frame's time information, including the time at which the frame should be displayed, its duration, and the movie's playback rate. This parameter can be NIL, in which case the decompression operation will happen immediately.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The following code snippet shows this function being used to execute one frame of a visual effect.// DecompressSequenceFrameWhen coding example
// See "Discovering QuickTime," page 310
// Decompress a single step of the effect sequence.
OSErr RunEffect(TimeValue lTime, int nNumberOfSteps)
{
    OSErr               nErr =noErr;
    ICMFrameTimeRecord  ftr;
    // Set the timebase time to the step of the sequence to be rendered
    SetTimeBaseValue(timeBase, lTime, nNumberOfSteps);
    ftr.value.lo            =lTime;
    ftr.value.hi            =0;
    ftr.scale               =nNumberOfSteps;
    ftr.base                =0;
    ftr.duration            =nNumberOfSteps;
    ftr.rate                =0;
    ftr.recordSize          =sizeof(ftr);
    ftr.frameNumber         =1;
    ftr.flags               =icmFrameTimeHasVirtualStartTimeAndDuration;
    ftr.virtualStartTime.lo     =0;
    ftr.virtualStartTime.hi     =0;
    ftr.virtualDuration         =nNumberOfSteps;
    HLock(hEffectDesc);
    DecompressSequenceFrameWhen(gEffectSequenceID,
                                StripAddress(*hEffectDesc),
                                GetHandleSize(hEffectDesc),
                                0,
                                0,
                                NIL,
                                &ftr);
    HUnlock(hEffectDesc);
}

Special Considerations

If the current decompressor component does not support scheduled asynchronous decompression, the Image Compression Manager returns an error code of codecCantWhenErr. In this case, the application will need to reissue the request with the frameTime parameter set to NIL. If the decompressor cannot service your request at a particular time (for example, if its queue is full), the Image Compression Manager returns an error code of codecCantQueueErr. The best way to determine whether a decompressor component supports this function is to call the function and test the result code. A decompressor's ability to honor the request may change based on screen depth, clipping settings, and so on.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceFrameWhen (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc,
   const ICMFrameTimeRecord      *frameTime );

/*CDSequenceSetTimeBase

Sets a time base for a decompression sequence.

OSErr CDSequenceSetTimeBase (
   ImageSequence    seqID,
   void             *base );
Parameters
seqID

A unique sequence identifier that was returned by CompressSequenceBegin.
base

A pointer to the time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When you run a visual effect outside a movie, you must designate a time base that will be used when the effect is run. The following code illustrates this use of CDSequenceSetTimeBase:// CDSequenceSetTimeBase coding example
// See "Discovering QuickTime," page 310
timeBase =NewTimeBase();
SetTimeBaseRate(timeBase, 0);
CDSequenceSetTimeBase(gEffectSequenceID, timeBase);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceSetTimeBase (
   ImageSequence    seqID,
   void             *base );

/*InverseMatrix

Creates a new matrix that is the inverse of a specified matrix.

Boolean InverseMatrix (
   const MatrixRecord    *m,
   MatrixRecord          *im );
Parameters
m

A pointer to the source MatrixRecord structure for the operation.
im

A pointer to a MatrixRecord structure that is to receive the new matrix. The function updates this structure so that it contains a matrix that is the inverse of that specified by the m parameter.
Return Value

A Boolean value of TRUE if InverseMatrix was able to create an inverse matrix, FALSE otherwise.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

Boolean InverseMatrix (
   const MatrixRecord    *m,
   MatrixRecord          *im );

#ifdef __cplusplus
}
#endif

#endif 


