#ifndef DISPLAYS_H
#define DISPLAYS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef VIDEO_H
#include <QD/Video.h>
#endif

#ifndef CMAPPLICATION_H
#include <ColorSync/CMApplication.h>
#endif

#ifndef  APPLEEVENTS_H
#include <AE/AppleEvents.h>
#endif


#include <AvailabilityMacros.h>
//#include <HYS/QD/Displays.h>
#include <APPLE/QD/Displays.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Switch Flags

enum {
   kNoSwitchConfirmBit = 0,
   kDepthNotAvailableBit = 1,
   kShowModeBit = 3,
   kModeNotResizeBit = 4,
   kNeverShowModeBit = 5
};
Constants
kNoSwitchConfirmBit

If the Display Manager sets this bit the display mode is required to function correctly. Your application does not need to provide confirmation if the user switches to this mode.

Available in Mac OS X v10.0 and later.
kDepthNotAvailableBit

If the Display Manager sets this bit the pixel depth of the specified device is not available for the specified display mode.

Available in Mac OS X v10.0 and later.
kShowModeBit

If the Display Manager sets this bit your application should display this mode to the user, even though it may require confirmation.

Available in Mac OS X v10.0 and later.
kModeNotResizeBit

If the Display Manager sets this bit you should not use this mode to resize a display; this mode drives a different connector in cards than in a built-in display.

Available in Mac OS X v10.0 and later.
kNeverShowModeBit

If the Display Manager sets this bit you should not show the mode in the user interface.

Available in Mac OS X v10.0 and later.
Discussion

In its switchFlags parameter, the function DMCheckDisplayMode returns a pointer to a long integer that specifies flags in two of its bits. The constants represent bits that are set to 1. These bits are set by the Display Manager, not your application*/
enum {
   kNoSwitchConfirmBit = 0,
   kDepthNotAvailableBit = 1,
   kShowModeBit = 3,
   kModeNotResizeBit = 4,
   kNeverShowModeBit = 5
};


/*Active Device Only Values

enum {
   dmOnlyActiveDisplays = true,
   dmAllDisplays = false
};
Constants
dmOnlyActiveDisplays

Returns a handle to the GDevice structure for an active device only.

Available in Mac OS X v10.0 and later.
dmAllDisplays

Returns a handle to the GDevice structure for a device, active or not.

Available in Mac OS X v10.0 and later.
Discussion

The functions DMGetFirstScreenDevice and DMGetNextScreenDevice contain the parameter activeOnly which you can specify with an Active Device Constant.*/
enum {
   dmOnlyActiveDisplays = true,
   dmAllDisplays = false
};


/*DMDisplayTimingInfoRec

struct DMDisplayTimingInfoRec {
   UInt32 timingInfoVersion;
   UInt32 timingInfoAttributes;
   SInt32 timingInfoRelativeQuality;
   SInt32 timingInfoRelativeDefault;
   UInt32 timingInfoReserved[16];
};
typedef struct DMDisplayTimingInfoRec DMDisplayTimingInfoRec;
typedef DMDisplayTimingInfoRec * DMDisplayTimingInfoPtr;
Fields
timingInfoVersion

An unsigned 32 bit integer that shows the timing version. See “Display Version Values” for timing version values.
timingInfoAttributes

An unsigned 32 bit integer that the Display Manager sets to show timing attributes.
timingInfoRelativeQuality

A signed 32 bit integer whose flags the Display Manager sets to provide information on the quality of the timing.
timingInfoRelativeDefault

A signed 32 bit integer the Display Manager sets that specifies the relative default value of the timing.
timingInfoReserved

Reserved for future expansion.
Discussion

This structure supplies information about timing attributes, defaults and values to the structure DMDisplayModeListEntryRec. 
Availability
Available in Mac OS X v10.0 and later.*/
struct DMDisplayTimingInfoRec {
   UInt32 timingInfoVersion;
   UInt32 timingInfoAttributes;
   SInt32 timingInfoRelativeQuality;
   SInt32 timingInfoRelativeDefault;
   UInt32 timingInfoReserved[16];
};
typedef struct DMDisplayTimingInfoRec DMDisplayTimingInfoRec;
typedef DMDisplayTimingInfoRec * DMDisplayTimingInfoPtr;


/*DMListIndexType

typedef unsigned long DMListIndexType;
Discussion

The function DMGetIndexedDisplayModeFromList uses this data type to supply a list of display modes from which you can obtain information about a specified display mode. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long DMListIndexType;

/*DMListType

typedef void * DMListType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef void * DMListType;

/*DMDepthInfoRec

struct DMDepthInfoRec {
   VDSwitchInfoPtr depthSwitchInfo;
   VPBlockPtr depthVPBlock;
   UInt32 depthFlags;
   UInt32 depthReserved1;
   UInt32 depthReserved2;
};
typedef struct DMDepthInfoRec DMDepthInfoRec;
typedef DMDepthInfoRec * DMDepthInfoPtr;
Fields
depthSwitchInfo

A pointer to the structure VDSwitchInfoRec, which contains values that specify information on video switch modes and data. 
depthVPBlock

A pointer to the structure VPBlock, which supplies information about size, depth and format. 
depthFlags

Values from the video structure VDVideoParametersInfoRec, which specify color, size, and depth.
depthReserved1

Reserved for future expansion.
depthReserved2

Reserved for future expansion.
Discussion

This structure provides information that the structure DMDepthInfoBlockRec supplies to the function DMGetIndexedDisplayModeFromList. 
Availability
Available in Mac OS X v10.0 and later.*/

struct DMDepthInfoRec {
   VDSwitchInfoPtr depthSwitchInfo;
   VPBlockPtr depthVPBlock;
   UInt32 depthFlags;
   UInt32 depthReserved1;
   UInt32 depthReserved2;
};
typedef struct DMDepthInfoRec DMDepthInfoRec;
typedef DMDepthInfoRec * DMDepthInfoPtr;



/*DMDepthInfoBlockRec

struct DMDepthInfoBlockRec {
   unsigned long depthBlockCount;
   DMDepthInfoPtr depthVPBlock;
   unsigned long depthBlockFlags;
   unsigned long depthBlockReserved1;
   unsigned long depthBlockReserved2;
};
typedef struct DMDepthInfoBlockRec DMDepthInfoBlockRec;
typedef DMDepthInfoBlockRec * DMDepthInfoBlockPtr;
Fields
depthBlockCount

Specifies the number of mode depths available.
depthVPBlock

Array of DMDepthInfoRec. 
depthBlockFlags

Reserved for future expansion.
depthBlockReserved1

Reserved for future expansion.
depthBlockReserved2

Reserved for future expansion.
Discussion

When you call the function DMGetIndexedDisplayModeFromList , the Display Manager passes a pointer to a DMDisplayModeListEntryRec structure to your application. Its field displayModeDepthBlockInfo is a pointer to a DMDepthInfoBlockRec structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct DMDepthInfoBlockRec {
   unsigned long depthBlockCount;
   DMDepthInfoPtr depthVPBlock;
   unsigned long depthBlockFlags;
   unsigned long depthBlockReserved1;
   unsigned long depthBlockReserved2;
};
typedef struct DMDepthInfoBlockRec DMDepthInfoBlockRec;
typedef DMDepthInfoBlockRec * DMDepthInfoBlockPtr;


/*DMDisplayModeListEntryRec

struct DMDisplayModeListEntryRec {
   UInt32 displayModeFlags;
   VDSwitchInfoPtr displayModeSwitchInfo;
   VDResolutionInfoPtr displayModeResolutionInfo;
   VDTimingInfoPtr displayModeTimingInfo;
   DMDepthInfoBlockPtr displayModeDepthBlockInfo;
   UInt32 displayModeVersion;
   StringPtr displayModeName;
   DMDisplayTimingInfoPtr displayModeDisplayInfo;
};
typedef struct DMDisplayModeListEntryRec DMDisplayModeListEntryRec;
typedef DMDisplayModeListEntryRec * DMDisplayModeListEntryPtr;
Fields
displayModeFlags

A pointer to a video structure, VDSwitchInfoRec, which provides information you need to tell the driver how to switch into different configurations, bit depths, or resolutions. See the function DMSetDisplayMode for more information.
displayModeSwitchInfo

A pointer to a VDSwitchInfoRec video structure, which provides information you need to tell the driver how to switch into different configurations, bit depths, or resolutions. See the function DMSetDisplayMode for more information. 
displayModeResolutionInfo

A pointer to a pointer to a VDResolutionInfoRec video structure, which provides information about horizontal pixels, maximum depth modes, and the vertical line of the specified display mode. 
displayModeTimingInfo

A pointer to a pointer to a VDTimingInfoRec video structure, which provides information about timing, format of the specified display mode. 
displayModeDepthBlockInfo

A pointer to a DMDepthInfoBlockRec structure, which provides information about available pixel formats and the VPBlock, including size and depth. 
displayModeVersion

The version of this structure. Currently it is version kDisplayTimingInfoVersionOne. See “Display Version Values” for more information.
displayModeName

A string pointer giving the display mode name.
displayModeDisplayInfo

A pointer to the DMDisplayTimingInfoRec data type. This data type supplies information about the quality and default values of the timing. 
Discussion

The DMDisplayModeListEntryRec structure contains information about a display mode in a display mode list built by the function DMNewDisplayModeList. 
Availability
Available in Mac OS X v10.0 and later.*/
struct DMDisplayModeListEntryRec {
   UInt32 displayModeFlags;
   VDSwitchInfoPtr displayModeSwitchInfo;
   VDResolutionInfoPtr displayModeResolutionInfo;
   VDTimingInfoPtr displayModeTimingInfo;
   DMDepthInfoBlockPtr displayModeDepthBlockInfo;
   UInt32 displayModeVersion;
   StringPtr displayModeName;
   DMDisplayTimingInfoPtr displayModeDisplayInfo;
};
typedef struct DMDisplayModeListEntryRec DMDisplayModeListEntryRec;
typedef DMDisplayModeListEntryRec * DMDisplayModeListEntryPtr;



/*DMDisplayModeListIteratorProcPtr

Defines a pointer to a list iterator callback function.

typedef void (*DMDisplayModeListIteratorProcPtr)
(
   void * userData,
   DMListIndexType itemIndex,
   DMDisplayModeListEntryPtr displaymodeInfo
);

If you name your function MyDMDisplayModeListIteratorProc, you would declare it like this:

void MyDMDisplayModeListIteratorProc (
   void * userData,
   DMListIndexType itemIndex,
   DMDisplayModeListEntryPtr displaymodeInfo
);
Parameters
userData

A pointer to data about mode changes provided by the user. 
itemIndex

Specifies the list entry. See DMListIndexType for more information. This is the index passed into DMGetIndexedDisplayModeFromList. 
displaymodeInfo

A pointer to a structure of type DMDisplayModeListEntryRec that provides display mode information. 
Discussion

The function DMGetIndexedDisplayModeFromList uses this callback function to retrieve and return information about a display mode to the caller of DMGetIndexedDisplayModeFromList. 

When you implement this function, the pointer you pass to the DMGetIndexedDisplayModeFromList function should be a universal procedure pointer with the following type definition:typedef (DMDisplayModeListIteratorProcPtr)             DMDisplayModeListIteratorUPP;


To create a universal procedure pointer for your application-defined function, you should use the NewDMDisplayModeListIteratorUPP function as follows:DMDisplayModeListIteratorUPP MyDMDisplayModeListIteratorUPP;
MyDMDisplayModeListIteratorUPP = NewDMDisplayModeListIteratorUPP  (&MyDMDisplayModeListIteratorCallback)


You can then pass MyDMDisplayModeListIteratorUPP in the listIterator parameter of the DMGetIndexedDisplayModeFromList function. When you no longer need the list iterator, you should dispose of the UPP using the DisposeDMDisplayModeListIteratorUPP function:DisposeDMDisplayModeListIteratorUPP (
    MyDMDisplayModeListIteratorUPP);


Using this call ensures that the call is made through a universal procedure pointer.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.*/
typedef void (*DMDisplayModeListIteratorProcPtr)
(
   void * userData,
   DMListIndexType itemIndex,
   DMDisplayModeListEntryPtr displaymodeInfo
);


/*DMDisplayModeListIteratorUPP

typedef DMDisplayModeListIteratorProcPtr DMDisplayModeListIteratorUPP;
Discussion

For more information, see the description of the DMDisplayModeListIteratorProcPtr callback function.*/
typedef DMDisplayModeListIteratorProcPtr DMDisplayModeListIteratorUPP;




//function

/*DMExtendedNotificationProcPtr

Defines a pointer to an extended notification callback function.

typedef void (*DMExtendedNotificationProcPtr)
(
   void * userData,
   short theMessage,
   void * notifyData
);

If you name your function MyDMExtendedNotificationProc, you would declare it like this:

void MyDMExtendedNotificationProc (
   void * userData,
   short theMessage,
   void * notifyData
);
Parameters
userData

A pointer you passed into DMRegisterExtendedNotifyProc. 
theMessage

A message selector. See “Notification Messages” for information on specific message selectors. 
notifyData

A pointer to message-specific information data provided by the the Display Manager, described in “Notification Messages”.
Discussion

Display Manager notification functions use this callback function when your application needs to know when certain events have occurred. The system software may implement these events or follow a user action. When these events occur, the Display Manager will send notification messages to registrants.

When you call the function DMRegisterExtendedNotifyProc you designate an application-defined function to handle the extended notification procedure. 

When you implement this function, the pointer you pass to the DMRegisterExtendedNotifyProc function should be a universal procedure pointer with the following type definition:typedef (DMExtendedNotificationProcPtr)             DMExtendedNotificationUPP;


To create a universal procedure pointer for your application-defined function, you should use the NewDMExtendedNotificationProc macro as follows:DMExtendedNotificationUPP  MyExtendedNotificationUPP;
MyExtendedNotificationUPP = NewDMExtendedNotificationProc  (MyExtendedNotificationCallback);


You can then pass MyExtendedNotificationUPP in the notifyProc parameter of the DMRegisterExtendedNotifyProc function. When you no longer need notifications, you should remove it using the DMRemoveExtendedNotifyProc function. You sould also dispose of the UPP using the DisposeDMExtendedNotificationUPP function:

DisposeDMExtendedNotificationUPP(MyExtendedNotificationUPP);

Using this call ensures that the call is made through a universal procedure pointer.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.*/

typedef void (*DMExtendedNotificationProcPtr)
(
   void * userData,
   short theMessage,
   void * notifyData
);


/*DMExtendedNotificationUPP

typedef DMExtendedNotificationProcPtr DMExtendedNotificationUPP;
Discussion

For more information, see the description of the DMExtendedNotificationProcPtr callback function.*/
typedef DMExtendedNotificationProcPtr DMExtendedNotificationUPP;

//function

/*DMGetFirstScreenDevice

Returns a handle for the first video device in the device list. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

GDHandle DMGetFirstScreenDevice (
   Boolean activeOnly
);
Parameters
activeOnly

If true, the DMGetFirstScreenDevice function returns a handle to the first of all active video devices. If false, the function returns a handle to the first of all video devices, active or not. You may use the Active Device Constants in this parameter. See “Active Device Only Values”.
Return Value

If activeOnly is true, a handle to the GDevice structure for the first active video device. If activeOnly is false, a handle to the GDevice structure for the first video device. See the QuickDraw Manager documentation for a description of the GDHandle data type.
Discussion

The DMGetFirstScreenDevice function is useful if you want to find out more about the current mode.

You can use the function DMGetNextScreenDevice to loop through all of the video devices in the device list.

The DMGetFirstScreenDevice function is similar to the QuickDraw function GetDeviceList, except that when returning GDevice structures, GetDeviceList does not distinguish between inactive and active video devices or between the GDevice structures for video devices and the GDevice structures associated with no video devices. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/

GDHandle DMGetFirstScreenDevice (
   Boolean activeOnly
);

/*DMGetDisplayIDByGDevice

Obtains the display ID number for a video device. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMGetDisplayIDByGDevice (
   GDHandle displayDevice,
   DisplayIDType * displayID,
   Boolean failToMain
);
Parameters
displayDevice

A handle to the GDevice structure for the video device whose display ID you wish to obtain. 
displayID

On return, a pointer to the display ID for the video device specified by the displayDevice parameter. 
failToMain

If true and the specified video device does not have a display ID, on return the function sets the displayID parameter to a pointer to the display ID of the video device for the main screen. If false and the specified video device does not have a display ID, the function returns the kDMDisplayNotFoundErr result code. 
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMGetDisplayIDByGDevice (
   GDHandle displayDevice,
   DisplayIDType * displayID,
   Boolean failToMain
);

/*DMGetNextScreenDevice

Returns a handle for the next video device in the device list. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

GDHandle DMGetNextScreenDevice (
   GDHandle theDevice,
   Boolean activeOnly
);
Parameters
theDevice

A handle to the GDevice structure at which you want the function to begin. You can supply the handle returned by the function DMGetFirstScreenDevice or DMGetNextScreenDevice. 
activeOnly

If true, the DMGetNextScreenDevice function returns a handle for the next active video device. If false, DMGetNextScreenDevice returns a handle for the next video device, active or not. You may use the Active Device Constants in this parameter. See “Active Device Only Values”.
Return Value

If activeOnly is true, a handle to the next GDevice structure for an active video device. If activeOnly is false, a handle to the next GDevice structure for a video device. If there are no more GDevice structures in the list, DMGetNextScreenDevice returns NULL. See the QuickDraw Manager documentation for a description of the GDHandle data type.
Discussion

The DMGetNextScreenDevice function is similar to the QuickDraw function GetNextDevice, except that when returning GDevice structures, GetNextDevice does not distinguish between inactive and active video devices or between the GDevice structures for video devices and the GDevice structures associated with no video devices. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
GDHandle DMGetNextScreenDevice (
   GDHandle theDevice,
   Boolean activeOnly
);

/*DMGetIndexedDisplayModeFromList

Obtains a display mode from the display mode list built by DMNewDisplayModeList. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMGetIndexedDisplayModeFromList (
   DMListType panelList,
   DMListIndexType itemIndex,
   unsigned long reserved,
   DMDisplayModeListIteratorUPP listIterator,
   void * userData
);
Parameters
panelList

A value that specifies the list from which to obtain information about the display modes created by the function DMNewDisplayModeList. 
itemIndex

A value that specifies the index of the display mode you wish to obtain. 
reserved

Reserved for future expansion. Pass NULL in this parameter. 
listIterator

A universal procedure pointer. The iterator this pointer specifies supplies the function to be called with the information about the display mode specified by theListCount. 
userData

A pointer you pass for listIterator usually used to obtain information about the display mode from the UPP and return it to the caller of DMGetIndexedDisplayModeFromList. 
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.

Generally, your application should not use this function, but should instead allow system software to maintain the device list. This function is described here for completeness only. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMGetIndexedDisplayModeFromList (
   DMListType panelList,
   DMListIndexType itemIndex,
   unsigned long reserved,
   DMDisplayModeListIteratorUPP listIterator,
   void * userData
);

/*DMCheckDisplayMode

Determines if a video device supports a particular display mode and pixel depth. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMCheckDisplayMode (
   GDHandle theDevice,
   unsigned long mode,
   unsigned long depthMode,
   unsigned long * switchFlags,
   unsigned long reserved,
   Boolean * modeOk
);
Parameters
theDevice

A handle to the GDevice structure for the video device whose display mode and pixel depth you wish to check. 
mode

The display mode you wish to check. You get a list of display modes by calling DMGetDisplayMode. 
depthMode

The pixel depth you wish to check. See “Video Depth Mode Values” for list of possible values.
switchFlags

On return, a pointer to a long integer that indicates if a video device will support the mode specified by the mode parameter and the pixel depth specified by the depthMode parameter. See “Switch Flags” for a description.
reserved

Reserved for future expansion. Pass NULL in this parameter.
modeOk

On return, a pointer to a Boolean. If modeOk points to a value of true, the user or your application can switch the display mode for the video device to the one specified by mode.
Return Value

A result code. See “Display Manager Result Codes”.
Discussion

Usually, your application only needs to know if a video device supports a specific pixel depth. Thus your application can use the Color QuickDraw function HasDepth. The function DMCheckDisplayMode is essentially obsolete, and is here for completeness. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMCheckDisplayMode (
   GDHandle theDevice,
   unsigned long mode,
   unsigned long depthMode,
   unsigned long * switchFlags,
   unsigned long reserved,
   Boolean * modeOk
);

/*DMSetDisplayMode

Sets the display mode and pixel depth for a video device. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMSetDisplayMode (
   GDHandle theDevice,
   unsigned long mode,
   unsigned long * depthMode,
   unsigned long reserved,
   Handle displayState
);
Parameters
theDevice

A handle to the GDevice structure for the video device whose display mode and pixel depth you wish to set. 
mode

The number used by a video device to identify its display mode. If you supply the value 0 in this parameter, DMSetDisplayMode uses the current display mode. To specify another display mode, use the function DMNewDisplayModeList. 
depthMode

A pointer to the desired pixel depth for the video device specified by theDevice. If you pass a pointer to 0, DMSetDisplayMode attempts to keep the current depth. If you pass a pointer to 1, 2, 4, 8, 16, or 32, DMSetDisplayMode attempts to set the device to use your specified pixel depth. If you supply a pointer to a value of 128 or greater, then DMSetDisplayMode sets the depth to the depth mode represented by the Video Depth Mode values. See “Video Depth Mode Values” for more information.

On return, this parameter contains a pointer to the new pixel depth. This value represents the depth mode closest to the one you requested when calling DMSetDisplayMode.
reserved

Reserved for future expansion. Pass NULL in this parameter.
displayState

If your aDMSetDisplayMode

Sets the display mode and pixel depth for a video device. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMSetDisplayMode (
   GDHandle theDevice,
   unsigned long mode,
   unsigned long * depthMode,
   unsigned long reserved,
   Handle displayState
);
Parameters
theDevice

A handle to the GDevice structure for the video device whose display mode and pixel depth you wish to set. 
mode

The number used by a video device to identify its display mode. If you supply the value 0 in this parameter, DMSetDisplayMode uses the current display mode. To specify another display mode, use the function DMNewDisplayModeList. 
depthMode

A pointer to the desired pixel depth for the video device specified by theDevice. If you pass a pointer to 0, DMSetDisplayMode attempts to keep the current depth. If you pass a pointer to 1, 2, 4, 8, 16, or 32, DMSetDisplayMode attempts to set the device to use your specified pixel depth. If you supply a pointer to a value of 128 or greater, then DMSetDisplayMode sets the depth to the depth mode represented by the Video Depth Mode values. See “Video Depth Mode Values” for more information.

On return, this parameter contains a pointer to the new pixel depth. This value represents the depth mode closest to the one you requested when calling DMSetDisplayMode.
reserved

Reserved for future expansion. Pass NULL in this parameter.
displayState

If your application called DMBeginConfigureDisplays, you must pass the displayState handle obtained. Otherwise pass NULL in this parameter.
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.hpplication called DMBeginConfigureDisplays, you must pass the displayState handle obtained. Otherwise pass NULL in this parameter.
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMSetDisplayMode (
   GDHandle theDevice,
   unsigned long mode,
   unsigned long * depthMode,
   unsigned long reserved,
   Handle displayState
);

/*DMDisposeList

Disposes of a display mode list built by DMNewDisplayModeList. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMDisposeList (
   DMListType panelList
);
Parameters
panelList

A value that specifies the display mode list you want to delete. 
Return Value

A result code. See “Display Manager Result Codes”.
Discussion

You should call the DMDisposeList function after you have iterated the mode list.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.

Generally, your application should not use this function, but should instead allow system software to maintain the device list. This function is described here for completeness only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMDisposeList (
   DMListType panelList
);

/*DMNewDisplayModeList

Builds a new display mode list for a specified video device. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMNewDisplayModeList (
   DisplayIDType displayID,
   unsigned long modeListFlags,
   unsigned long reserved,
   DMListIndexType * thePanelCount,
   DMListType * thePanelList
);
Parameters
displayID

The display ID for the video device that will have a new display mode list. 
modeListFlags

Reserved for future expansion. Pass NULL in this parameter. 
reserved

Reserved for future expansion. Pass NULL in this parameter.
thePanelCount

The number of entries in the display mode list specified by the theList parameter. 
thePanelList

The display mode list for the specified video device. 
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.

Generally, your application should not use this function, but should instead allow system software to maintain the device list. This function is described here for completeness only. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMNewDisplayModeList (
   DisplayIDType displayID,
   unsigned long modeListFlags,
   unsigned long reserved,
   DMListIndexType * thePanelCount,
   DMListType * thePanelList
);

/*DMBeginConfigureDisplays

Allows your application to configure displays. You should generally never need to use this function. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMBeginConfigureDisplays (
   Handle * displayState
);
Parameters
displayState

On return, a pointer to a handle to internal Display Manager information about the current display state. The DMEndConfigureDisplays function and many other functions require this parameter.
Return Value

A result code. See “Display Manager Result Codes”.
Discussion

The DMBeginConfigureDisplays function tells the Display Manager to postpone Display Manager configuration checking, the rebuilding of desktop regions, and Apple event notification of Display Manager changes until your application uses the DMEndConfigureDisplays function.

You should call the function DMBeginConfigureDisplays before calling other Display Manager functions that configure the user’s display. When calling functions that configure displays, you should pass the handle obtained by the DMBeginConfigureDisplays function. DMBeginConfigureDisplays causes system software to wait for your application to complete display changes before managing additional Display Manager events. When your application completes configuring the display environment, call the function DMEndConfigureDisplays. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.

Applications generally never need to use this function. In case you find a compelling need to change the user’s display configuration, this function is described here for completeness. Note that if your application uses Display Manager functions to change the display configuration of the user’s video devices, your application should make these changes only with the consent of the user. If your application must have a specific pixel depth, for example, it should display a dialog box that offers the user a choice between changing to that depth or canceling display of the image. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMBeginConfigureDisplays (
   Handle * displayState
);

/*DMGetDisplayMode

Obtains the current display mode of a specified video display. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMGetDisplayMode (
   GDHandle theDevice,
   VDSwitchInfoPtr switchInfo
);
Parameters
theDevice

A handle to the GDevice structure for the video device whose display mode you wish to obtain. 
switchInfo

On return, a pointer to an internal Display Manager structure containing display mode information. 
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMGetDisplayMode (
   GDHandle theDevice,
   VDSwitchInfoPtr switchInfo
);

/*DMEndConfigureDisplays

Ends configuration begun by DMBeginConfigureDisplays. You should generally never need to use this function. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMEndConfigureDisplays (
   Handle displayState
);
Parameters
displayState

Supply this parameter with the handle obtained by the DMBeginConfigureDisplays function.
Return Value

A result code. See “Display Manager Result Codes”.
Discussion

The function DMEndConfigureDisplays resumes Display Manager configuration checking, the rebuilding of desktop regions, and Apple event notification of Display Manager changes, all of which are postponed when you use the function DMBeginConfigureDisplays. Your application will then receive a single Display Notice event notifying your application of Display Manager changes, and your application can manage its windows accordingly. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.

Applications generally never need to use this function. In case you find a compelling need to change the user’s display configuration, this function is described here for completeness. Note that if your application uses Display Manager functions to change the display configuration of the user’s video devices, your application should make these changes only with the consent of the user. If your application must have a specific pixel depth, for example, it should display a dialog box that offers the user a choice between changing to that depth or canceling display of the image. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMEndConfigureDisplays (
   Handle displayState
);

/*NewDMDisplayModeListIteratorUPP

(Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

DMDisplayModeListIteratorUPP NewDMDisplayModeListIteratorUPP (
   DMDisplayModeListIteratorProcPtr userRoutine
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
DMDisplayModeListIteratorUPP NewDMDisplayModeListIteratorUPP (
   DMDisplayModeListIteratorProcPtr userRoutine
);


#ifdef __cplusplus
}
#endif

#endif
