#ifndef ATSUNICODEFLATTENING_H
#define ATSUNICODEFLATTENING_H

#ifndef  ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSUFontVariationAxis

Represents a stylistic attribute and the range of values that the font can use to express this attribute.

typedef FourCharCode ATSUFontVariationAxis;
Discussion

Font variations allow your application to produce a range of type styles algorithmically. You can obtain a a variation axis and its maximum, minimum, and default values for a font by calling the function ATSUGetIndFontVariation. For a complete discussion of font variations, see Inside Mac OS X: Rendering Unicode Text With ATSUI.
Availability
Available in Mac OS X v10.0 and later.*/
typedef FourCharCode ATSUFontVariationAxis;

/*Unflattened Style Run Data Options

Specify options to use when unflattening ATSUI style run data.

typedef UInt32 ATSUUnflattenStyleRunOptions;
enum {
   kATSUUnflattenOptionNoOptionsMask = 0x00000000
};
Constants
kATSUUnflattenOptionNoOptionsMask

Specifies that no options are to be used.
Discussion

Additional options may be added in the future.*/
typedef UInt32 ATSUUnflattenStyleRunOptions;
#define kATSUUnFlattenOptionNoOptionsMask kATSUUnflattenOptionNoOptionsMask
enum {
   kATSUUnflattenOptionNoOptionsMask = 0x00000000
};


/*Flattened Style Run Data Options

Specify options to use when flattening ATSUI style run data.

typedef UInt32 ATSUFlattenStyleRunOptions;
enum {
   kATSUFlattenOptionNoOptionsMask = 0x00000000
};
Constants
kATSUFlattenOptionNoOptionsMask

Specifies that no options are to be used.

Available in Mac OS X v10.2 and later.
Discussion

Additional options may be added in the future.*/
typedef UInt32 ATSUFlattenStyleRunOptions;
enum {
   kATSUFlattenOptionNoOptionsMask = 0x00000000
};


/*Flattened Data Format Selectors

Specify the format to use when flattening or unflattening data.

typedef UInt32 ATSUFlattenedDataStreamFormat;
enum {
   kATSUDataStreamUnicodeStyledText = 'ustl'
};
Constants
kATSUDataStreamUnicodeStyledText

Specifies to use the 'ustl' data specification when flattening or unflattening data.

Available in Mac OS X v10.2 and later.*/
typedef UInt32 ATSUFlattenedDataStreamFormat;
enum {
   kATSUDataStreamUnicodeStyledText = 'ustl'
};


/*ATSUStyleRunInfo

Contains information for a style run. 

struct ATSUStyleRunInfo {
   UniCharCount        runLength;
   ItemCount           styleObjectIndex;
};
typedef struct ATSUStyleRunInfo         ATSUStyleRunInfo;
Fields
runLength

The length of the style run.
styleObjectIndex

An index into an array of unique style objects.
Discussion

This structure is used by the function ATSUUnflattenStyleRunsFromStream to return style run information.
Availability
Available in Mac OS X v10.2 and later.*/
struct ATSUStyleRunInfo {
   UniCharCount        runLength;
   ItemCount           styleObjectIndex;
};
typedef struct ATSUStyleRunInfo         ATSUStyleRunInfo;

//function

/*ATSUFlattenStyleRunsToStream

Flattens ATSUI style-run data so that it can be saved to disk or passed (through the pasteboard) to another application. 

extern OSStatus ATSUFlattenStyleRunsToStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUFlattenStyleRunOptions      iFlattenOptions,
   ItemCount                       iNumberOfRunInfo,
   const ATSUStyleRunInfo          iRunInfoArray[],
   ItemCount                       iNumberOfStyleObjects,
   const ATSUStyle                 iStyleArray[],
   ByteCount                       iStreamBufferSize,
   void *                          oStreamBuffer,
   ByteCount *                     oActualStreamBufferSize
)
Parameters
iStreamFormat

The format of the flattened data. There is only one format supported at this time, 'ustl' so you must pass the constant kATSUDataStreamUnicodeStyledText.
iFlattenOptions

The options you want to use to flatten the data. There are no options supported at this time, so you must pass the constant kATSUFlattenOptionsNoOptionsMask.
iNumberOfRunInfo

The number of style run information structures passed in the iRunInfoArray parameter. If you pass 0, ATSUI assumes there is only one style for the entire text block passed in the oStreamBuffer parameter. The flattened data format passed to the iStreamFormat parameter must support the use of one style.
iRunInfoArray[]

An array of ATSUStyleRunInfo structures that describes the style runs to be flattened. This array must contain iNumberOfRunInfo entries. An ATSUStyleRunInfo structure contains an index into an array of unique ATSUI style objects (ATSUStyle) and the length of the run to which the style object applies. Each index in the ATSUStyleRunInfo structure must reference a valid ATSUStyle object passed in the iStyleArray parameter. You can pass NULL, only if iNumberOfRunInfo is set to zero.
iNumberOfStyleObjects

The number of ATSUStyle objects in the array passed to the iStyleArray parameter. You must pass a value that is greater than 0.
iStyleArray[]

An array of ATSUStyle objects to be flattened. You cannot pass NULL.
iStreamBufferSize

The size of the stream buffer, pointed to by the oStreamBuffer parameter. You can pass 0 only if the iStreamBufferSize parameter is set to NULL. If you are uncertain of the size of the array, see the Discussion.
oStreamBuffer

On input, a pointer to the data you want to flatten. On return, points to the flattened data. If you pass NULL for this parameter, no data is flattened. Instead, the size of the buffer is calculated by ATSUI and returned in oActualStreamSize parameter. See the Discussion for more details. You are responsible for allocating the text buffer passed in the oStreamBuffer parameter.
oActualStreamBufferSize

On return, the size of the data written to the oStreamBuffer parameter. You can pass NULL only if the oStreamBuffer parameter is not NULL.
Return Value

A result code. See “ATSUI Result Codes”. This function can also return paramErr if you pass invalid values for any of the parameters.
Discussion

The function ATSUFlattenStyleRunsToStream takes an array of ATSUStyle objects and style run information and flattens the data to the specified format. The style runs must all reference the same block of Unicode text (usually passed separately as text in the 'utxt' format). The style runs must also be in ascending order relative to the text in the text block.

Typically you use the function ATSUFlattenStyleRunsFromStream by calling it twice, as follows:
Provide appropriate values for the iStreamFormat, iFlattenOptions, iNumberOfRunInfo, iRunInfoArray, iNumberOfStyleObjects, and iStyleArray parameters. Set iStreamBufferSize to 0, oStreamBuffer to NULL, and pass a valid reference to a ByteCount variable in the oActualStreamBufferSize parameter. Call the function ATSUFlattenStyleRunsToStream. On return, oActualStreamBufferSize points to the size needed for the buffer.
Allocate an appropriately-sized buffer for the oStreamBuffer parameter and then call the function ATSUFlattenStyleRunsToStream a second time.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeFlattening.h*/
extern OSStatus ATSUFlattenStyleRunsToStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUFlattenStyleRunOptions      iFlattenOptions,
   ItemCount                       iNumberOfRunInfo,
   const ATSUStyleRunInfo          iRunInfoArray[],
   ItemCount                       iNumberOfStyleObjects,
   const ATSUStyle                 iStyleArray[],
   ByteCount                       iStreamBufferSize,
   void *                          oStreamBuffer,
   ByteCount *                     oActualStreamBufferSize
);

/*ATSUUnflattenStyleRunsFromStream

Unflattens previously-flattened ATSUI style run data so that it can be read from disk or accepted (through the pasteboard) from another application.

extern OSStatus ATSUUnflattenStyleRunsFromStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUUnflattenStyleRunOptions    iUnflattenOptions,
   ByteCount                       iStreamBufferSize,
   const void *                    iStreamBuffer,
   ItemCount                       iNumberOfRunInfo,
   ItemCount                       iNumberOfStyleObjects,
   ATSUStyleRunInfo                oRunInfoArray[],
   ATSUStyle                       oStyleArray[],
   ItemCount *                     oActualNumberOfRunInfo,
   ItemCount *                     oActualNumberOfStyleObjects
);
Parameters
iStreamFormat

The format of the flattened data. There is only one format supported at this time ('ustl') so you must pass the constant kATSUDataStreamUnicodeStyledText.
iUnflattenOptions

The options you want to use to unflatten the data. There are no options supported at this time, so you must pass the constant kATSUUnflattenOptionsNoOptionsMask.
iStreamBufferSize

The size of the buffer pointed to by the iStreamBuffer parameter. You must pass a value greater than 0.
iStreamBuffer

A pointer to the buffer that contains the flattened data. The data must be of the format specified by the iStreamFormat parameter and must be of size specified by the iStreamBufferSize parameter. You cannot pass NULL.
iNumberOfRunInfo

The number of style run information structures passed in the iRunInfoArray parameter. If you are uncertain of the number of style run information structures, see the Discussion.
iNumberOfStyleObjects

The number of ATSUStyle objects in the array passed into the iStyleArray parameter. If you are uncertain of the number of ATSUStyle objects, see the Discussion.
oRunInfoArray[]

On return, points to an array of style run information structures. Each structure contains a style run length and index into the oStyleArray array. If you are uncertain of how much memory to allocate for this array, see the Discussion. You are responsible for disposing of the array when you no longer need it.
oStyleArray[]

On return, a pointer to an array of the unique ATSUI style objects (ATSUStyle) obtained from the flattened data. The indices returned in the array oRunInfoArray are indices into this array. If you are uncertain of how much memory to allocate for this array, see the Discussion. You are responsible for disposing of the array and the ATSUI style objects in the array when you no longer need the array.
oActualNumberOfRunInfo

On return, points to the actual number of ATSUStyleRunInfo structures obtained from the flattened data. The actual number of structures is the number of entries added to the array oRunInfoArray. You can pass NULL if you to not want to obtain this value.
oActualNumberOfStyleObjects

On return, points to the actual number of unique ATSUI style objects (ATSUStyle) obtained from the flattened data. The actual number is the number of entries added to the oStyleArray array. You can pass NULL if you do no want to obtain this value.
Return Value

A result code. See “ATSUI Result Codes”. This function can also return paramErr if you pass invalid values for any of the parameters.
Discussion

The function ATSUUnflattenStyleRunsFromStream extracts the ATSUI style run information from previously-flattened data. The style objects and style run information structures are returned in two separate arrays—the array oStyleArray and the array oRunInfoArray. These arrays are not parallel. Each ATSUStyle object in the oStyleArray is a unique ATSUStyle object. To figure out which ATSUStyle object belongs to which text run, the caller must parse the array of ATSUStyleRunInfo structures. These structures contain the style run lengths and an index into the oStyleArray. 

Typically you use the function ATSUUnflattenStyleRunsFromStream by calling it twice, as follows:
Provide appropriate values for the iStreamFormat, iUnflattenOptions, and iStreamBuffer parameters. Pass 0 for the iNumberOfRunInfo and iNumberOfStyleObjects parameters, NULL for the oRunInfoArray and oStyleArray, parameters and valid ItemCount references for the oActualNumberOfRunInfo and oActualNumberOfStyleObjects parameters. On return, oActualNumberOfRunInfo and oActualNumberOfStyleObjects point to the sizes needed to allocate these arrays.
Allocate appropriately-sized arrays of ATSUStyleRunInfo data structures and ATSUStyle objects. Call the function ATSUUnflattenStyleRunsFromStream a second time, passing the newly allocated arrays in the oRunInfoArray and oStyleArray parameters, with the iNumberOfRunInfo and iNumberOfStyleObjects parameters set to the values you obtained from the first call.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeFlattening.h*/
extern OSStatus ATSUUnflattenStyleRunsFromStream(
   ATSUFlattenedDataStreamFormat   iStreamFormat,
   ATSUUnflattenStyleRunOptions    iUnflattenOptions,
   ByteCount                       iStreamBufferSize,
   const void *                    iStreamBuffer,
   ItemCount                       iNumberOfRunInfo,
   ItemCount                       iNumberOfStyleObjects,
   ATSUStyleRunInfo                oRunInfoArray[],
   ATSUStyle                       oStyleArray[],
   ItemCount *                     oActualNumberOfRunInfo,
   ItemCount *                     oActualNumberOfStyleObjects
);

#ifdef __cplusplus
}
#endif

#endif