#ifndef PMERRORS_H
#define PMERRORS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Ticket Services. Result Codes

This table lists result codes defined for Ticket Services.
Result Code	Value	Description
kPMTicketTypeNotFound	-9580	
The ticket type was not found.
kPMUpdateTicketFailed	-9581	
Could not update the ticket.
kPMValidateTicketFailed	-9582	
Could not validate the ticket.
kPMSubTicketNotFound	-9583	
Could not find the subticket.
kPMInvalidSubTicket	-9584	
The subticket is invalid.
kPMDeleteSubTicketFailed	-9585	
Could not delete the subticket.
kPMItemIsLocked	-9586	
The item is locked.
kPMTicketIsLocked	-9587	
The ticket is locked.
kPMTemplateIsLocked	-9588	
The job template is locked.
kPMKeyNotFound	-9589	
Could not find the key.
kPMKeyNotUnique	-9590	
The key is not unique.
kPMUnknownDataType	-9591	
The data type is unknown.*/

enum {
kPMTicketTypeNotFound	=-9580	,
kPMUpdateTicketFailed	=-9581	,
kPMValidateTicketFailed	=-9582	,
kPMSubTicketNotFound	=-9583	,
kPMInvalidSubTicket	=-9584	,
kPMDeleteSubTicketFailed	=-9585	,
kPMItemIsLocked=	-9586	,
kPMTicketIsLocked	=-9587	,
kPMTemplateIsLocked	=-9588	,
kPMKeyNotFound=	-9589,
kPMKeyNotUnique=	-9590	,
kPMUnknownDataType=	-9591	
};


/*Carbon Printing Manager for functions in the printing plug-in interfaces. Result Codes

The table below lists the result codes defined in the Carbon Printing Manager for functions in the printing plug-in interfaces.
Result Code	Value	Description
kPMCloseFailed	-9785	
A file or connection could not be closed.
kPMDontSwitchPDEError	-9531	
Tells the printing system not to switch out of the current pane.
kPMEditRequestFailed	-9544	
Error handling request to update Edit menu.
kPMInvalidLookupSpec	-9542	
Error retrieving lookup specification.
kPMInvalidPBMRef	-9540	
Invalid printer browser module.
kPMInvalidPDEContext	-9530	
Invalid printing dialog extension context.
kPMInvalidPrinterAddress	-9780	
Invalid printer address. NetInfo printcap entry not found.Unable to open USB interface.
kPMIOAttrNotAvailable	-9787	
I/O attribute not available on current connection type.
kPMNoSelectedPrinters	-9541	
No selected printers or error getting selection.
kPMOpenFailed	-9781	
A file or connection could not be opened.
kPMPrBrowserNoUI	-9545	
User interface function call with no user interface present.
kPMReadFailed	-9782	
A file or connection read operation failed.
kPMReadGotZeroData	-9788	
A file or connection read operation returned no data.
kPMStatusFailed	-9784	
Connection status failed.
kPMSyncRequestFailed	-9543	
Error handling sync request.
kPMUnsupportedConnection	-9786	
Connection type not supported.
kPMWriteFailed	-9783	
A file or connection write operation failed.*/
enum {
kPMCloseFailed	=-9785	,
kPMDontSwitchPDEError=	-9531	,
kPMEditRequestFailed	=-9544	,
kPMInvalidLookupSpec	=-9542	,
kPMInvalidPBMRef	=-9540	,
kPMInvalidPDEContext	=-9530	,
kPMInvalidPrinterAddress	=-9780	,
kPMIOAttrNotAvailable	=-9787	,
kPMNoSelectedPrinters	=-9541	,
kPMOpenFailed	=-9781	,
kPMPrBrowserNoUI	=-9545	,
kPMReadFailed	=-9782	,
kPMReadGotZeroData	=-9788	,
kPMStatusFailed	=-9784	,
kPMSyncRequestFailed	=-9543	,
kPMUnsupportedConnection	=-9786	,
kPMWriteFailed	=-9783	
};


/*Carbon Printing Manager. Result Codes

This table lists result codes defined for the Carbon Printing Manager.
Result Code	Value	Description
kPMGeneralError	-30870	
An unspecified error occurred.
kPMOutOfScope	-30871	
Your application called this function out of sequence with other Carbon Printing Manager functions.
kPMNoDefaultPrinter	-30872	
The user has not specified a default printer.
kPMNotImplemented	-30873	
The function is not implemented.
kPMNoSuchEntry	-30874	
There is no entry to match your application’s request.
kPMInvalidPrintSettings	-30875	
Your application passed an invalid print settings object.
kPMInvalidPageFormat	-30876	
Your application passed an invalid page format object.
kPMValueOutOfRange	-30877	
Your application passed an out-of-range value.
kPMLockIgnored	-30878	
The lock value was ignored.
kPMInvalidPrintSession	-30879	
Your application passed an invalid printing session object.
kPMInvalidPrinter	-30880	
Your application passed an invalid printer object.
kPMObjectInUse	-30881	
The specified object is in use.
kPMInvalidIndex	-30882	
An array index is invalid.
kPMStringConversionFailure	-30883	
An internal error occurred while converting a string.
kPMXMLParseError	-30884	
An error occurred while parsing XML data.
kPMInvalidJobTemplate	-30885	
An internal error occurred while creating a job template.
kPMInvalidPrinterInfo	-30886	
The printer information is invalid.
kPMInvalidConnection	-30887	
The printer connection type is invalid.
kPMInvalidKey	-30888	
The key in a ticket, job template, or dictionary is invalid.
kPMInvalidValue	-30889	
The value in a ticket, job template, or dictionary is missing.
kPMInvalidAllocator	-30890	
The specified memory allocator is invalid.
kPMInvalidTicket	-30891	
The job ticket is invalid.
kPMInvalidItem	-30892	
The item being added to a ticket is invalid.
kPMInvalidType	-30893	
The data type in a ticket, job template, or dictionary is not the expected type.
kPMInvalidReply	-30894	
A remote server or client sent an invalid reply.
kPMInvalidFileType	-30895	
The file type is invalid.
kPMInvalidObject	-30896	
The object is invalid.
kPMInvalidPaper	-30897	
Your application passed an invalid paper object.
kPMInvalidCalibrationTarget	-30898	
The dictionary specifying a printer calibration target is invalid.
kPMInvalidPreset	-30899	
Your application passed an invalid preset object.*/
enum {
kPMGeneralError=	-30870	,
kPMOutOfScope	=-30871	,
kPMNoDefaultPrinter	=-30872	,
kPMNotImplemented	=-30873	,
kPMNoSuchEntry	=-30874	,
kPMInvalidPrintSettings=	-30875	,
kPMInvalidPageFormat	=-30876	,
kPMValueOutOfRange	=-30877	,
kPMLockIgnored	=-30878	,
kPMInvalidPrintSession=	-30879	,
kPMInvalidPrinter	=-30880	,
kPMObjectInUse	=-30881	,
kPMInvalidIndex	=-30882	,
kPMStringConversionFailure	=-30883	,
kPMXMLParseError=	-30884	,
kPMInvalidJobTemplate	=-30885	,
kPMInvalidPrinterInfo	=-30886	,
kPMInvalidConnection	=-30887	,
kPMInvalidKey	=-30888	,
kPMInvalidValue	=-30889	,
kPMInvalidAllocator	=-30890	,
kPMInvalidTicket	=-30891	,
kPMInvalidItem	=-30892	,
kPMInvalidType=	-30893	,
kPMInvalidReply=	-30894	,
kPMInvalidFileType	=-30895	,
kPMInvalidObject	=-30896	,
kPMInvalidPaper	=-30897	,
kPMInvalidCalibrationTarget	=-30898	,
kPMInvalidPreset	=-30899	
};

#ifdef __cplusplus
}
#endif

#endif 

