#ifndef UTTYPE_H
#define UTTYPE_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*For the tag class, you pass one of the following tag class constants that define the alternate identifiers:
const CFStringRef kUTTagClassFilenameExtension;
const CFStringRef kUTTagClassMIMEType;
const CFStringRef kUTTagClassNSPboardType;
const CFStringRef kUTTagClassOSType;*/
extern const CFStringRef kUTTagClassFilenameExtension;
extern const CFStringRef kUTTagClassMIMEType;
extern const CFStringRef kUTTagClassNSPboardType;
extern const CFStringRef kUTTagClassOSType;

/*However, in many cases you want to determine whether one UTI is compatible with another, in which case you should check for conformance rather than equality:
Boolean UTTypeConformsTo (
        CFStringRef inUTI1,
        CFStringRef inUTI2
    );


The UTTypeConformsTo function returns true if inUTI1 conforms to inUTI2. Conformance relationships are transitive: if A conforms to B , and B conforms to C, then A conforms to C.*/
Boolean UTTypeConformsTo (
        CFStringRef inUTI1,
        CFStringRef inUTI2
    );


/*Accessing UTI Information

To obtain a copy of a UTI’s declaration, use the UTTCopyDeclaration function:
CFDictionaryRef UTTypeCopyDeclaration(
    CFStringRef inUTI );*/;
CFDictionaryRef UTTypeCopyDeclaration(
    CFStringRef inUTI );

/*This function returns an array of UTIs that you can examine to determine which one to use. 

If you want to create an alternate identifer from a UTI, you call the UTTypeCopyPreferredTagWithClass function:
CFStringRef UTTypeCopyPreferredTagWithClass(
    CFStringRef inUTI,
    CFStringRef inTagClass );*/
CFStringRef UTTypeCopyPreferredTagWithClass(
    CFStringRef inUTI,
    CFStringRef inTagClass );
/*Manipulating Tags

Often to use UTIs effectively, you must be able to convert various other type identifiers (OSType, MIME, and so on) to UTIs and vice versa.

To convert an identifier to a UTI, you can use the UTTypeCreatePreferredIdentifierForTag function:CFStringRef UTTypeCreatePreferredIdentifierForTag(
        CFStringRef inTagClass,
        CFStringRef inTag,
        CFStringRef inConformingToUTI
    );*/
extern CFStringRef  UTTypeCreatePreferredIdentifierForTag(
        CFStringRef inTagClass,
        CFStringRef inTag,
        CFStringRef inConformingToUTI);

/*Converting OSType Identifiers

The UTI utility functions assume that all alternate identifier tags can be represented as Core Foundation strings. However, because type OSType is integer-based rather than string-based, it may not be immediately obvious how to correctly translate between type CFStringRef and type OSType. To ensure error-free encoding/decoding of OSType identifiers, use the following conversion functions:
CFStringRef UTCreateStringForOSType( OSType inOSType );*/
CFStringRef UTCreateStringForOSType( OSType inOSType );

#ifdef __cplusplus
}
#endif

#endif