#ifndef LSOPEN_H
#define LSOPEN_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef LSINFO_H
#include <LaunchServices/LSInfo.h>
#endif

#ifndef AE_H
#include <AE/AE.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Launch Flags

Specify how to launch an application.

typedef OptionBits LSLaunchFlags;enum {
   kLSLaunchDefaults = 0x00000001,
   kLSLaunchAndPrint = 0x00000002,
   kLSLaunchReserved2 = 0x00000004,
   kLSLaunchReserved3 = 0x00000008,
   kLSLaunchReserved4 = 0x00000010,
   kLSLaunchReserved5 = 0x00000020,
   kLSLaunchAndDisplayErrors = 0x00000040,
   kLSLaunchInhibitBGOnly = 0x00000080,
   kLSLaunchDontAddToRecents = 0x00000100,
   kLSLaunchDontSwitch = 0x00000200,
   kLSLaunchNoParams = 0x00000800,
   kLSLaunchAsync = 0x00010000,
   kLSLaunchStartClassic = 0x00020000,
   kLSLaunchInClassic = 0x00040000,
   kLSLaunchNewInstance = 0x00080000,
   kLSLaunchAndHide = 0x00100000,
   kLSLaunchAndHideOthers = 0x00200000,
   kLSLaunchHasUntrustedContents = 0x00400000
};
Constants
kLSLaunchDefaults

Requests launching in the default manner (as if the only flags set were kLSLaunchNoParams, kLSLaunchAsync, and kLSLaunchStartClassic).

Available in Mac OS X v10.0 and later.
kLSLaunchAndPrint

Requests that documents opened in the application be printed.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved2

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved3

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved4

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchReserved5

Reserved for future use.

Available in Mac OS X v10.0 and later.
kLSLaunchAndDisplayErrors

Requests that launch and open failures be displayed in the UI.

Available in Mac OS X v10.4 and later.
kLSLaunchInhibitBGOnly

Requests that the launch be made to fail if the application is background-only.

Available in Mac OS X v10.0 and later.
kLSLaunchDontAddToRecents

Requests that the application or documents not be added to the Finder’s Recent Items menu.

Available in Mac OS X v10.0 and later.
kLSLaunchDontSwitch

Requests that the application be launched without being brought to the foreground.

Available in Mac OS X v10.0 and later.
kLSLaunchNoParams

Requests that the application’s information property list be used to determine the launch parameters.

Available in Mac OS X v10.0 and later.
kLSLaunchAsync

Requests that the application be launched asynchronously: that is, the Launch Services function launching it return control immediately, without waiting for it to complete its launch sequence (indicated visually to the user when the application’s icon stops “bouncing” in the Dock).

Available in Mac OS X v10.0 and later.
kLSLaunchStartClassic

Requests that the Classic emulation environment be started up if the application requires it. If this flag is not set and the application requires the Classic environment, the launch will fail.

Available in Mac OS X v10.0 and later.
kLSLaunchInClassic

Requests that the application be forced to launch in the Classic emulation environment.

Available in Mac OS X v10.0 and later.
kLSLaunchNewInstance

Requests that a new instance of the application be started, even if one is already running.

Available in Mac OS X v10.0 and later.
kLSLaunchAndHide

Requests that the application be hidden as soon as it completes its launch sequence.

Available in Mac OS X v10.0 and later.
kLSLaunchAndHideOthers

Requests that other applications be hidden as soon as the opened application completes its launch sequence.

Available in Mac OS X v10.0 and later.
kLSLaunchHasUntrustedContents

Requests that the items to be launched should be marked as untrusted. 

Available in Mac OS X v10.4 and later.
Discussion

They are passed in a launch specification structure (LSLaunchFSRefSpec to the LSOpenFromRefSpec function or LSLaunchURLSpec to the LSOpenFromURLSpec function), to control the manner in which applications are launched.*/
typedef OptionBits LSLaunchFlags;enum {
   kLSLaunchDefaults = 0x00000001,
   kLSLaunchAndPrint = 0x00000002,
   kLSLaunchReserved2 = 0x00000004,
   kLSLaunchReserved3 = 0x00000008,
   kLSLaunchReserved4 = 0x00000010,
   kLSLaunchReserved5 = 0x00000020,
   kLSLaunchAndDisplayErrors = 0x00000040,
   kLSLaunchInhibitBGOnly = 0x00000080,
   kLSLaunchDontAddToRecents = 0x00000100,
   kLSLaunchDontSwitch = 0x00000200,
   kLSLaunchNoParams = 0x00000800,
   kLSLaunchAsync = 0x00010000,
   kLSLaunchStartClassic = 0x00020000,
   kLSLaunchInClassic = 0x00040000,
   kLSLaunchNewInstance = 0x00080000,
   kLSLaunchAndHide = 0x00100000,
   kLSLaunchAndHideOthers = 0x00200000,
   kLSLaunchHasUntrustedContents = 0x00400000
};


/*LSApplicationParameters

Specifies the application, launch flags, and additional parameters that control how an application is launched.

struct LSApplicationParameters {
   CFIndex version;
   LSLaunchFlags flags;
   const FSRef * application;
   void * asyncLaunchRefCon;
   CFDictionaryRef environment;
   CFArrayRef argv;
   AppleEvent * initialEvent
};
typedef struct LSApplicationParameters LSApplicationParameters;
Fields
version

The version of the structure. The value of this field must be 0.
flags

Launch flags. For possible values, see “Launch Flags”.
application

The FSRef of the application to open.
asyncLaunchRefCon

The client refCon that is to appear in subsequent launch notifications.
environment

A dictionary of CFStringRef keys and values for environment variables to set in the launched process. The value of this field can be NULL.
argv

An array of values of type CFStringRef that specify the arguments that are to be passed to main() in the launched process. The value of this field can be NULL. This field is ignored in Mac OS X v10.4.
initialEvent

The first Apple Event to send to the launched process. The value of this field can be NULL.
Discussion

This structure is passed as a parameter to LSOpenApplication, LSOpenItemsWithRole, and LSOpenURLsWithRole.
Availability
Available in Mac OS X v10.4 and later*/
struct LSApplicationParameters {
   CFIndex version;
   LSLaunchFlags flags;
   const FSRef * application;
   void * asyncLaunchRefCon;
   CFDictionaryRef environment;
   CFArrayRef argv;
   AppleEvent * initialEvent;
};
typedef struct LSApplicationParameters LSApplicationParameters;

/*LSLaunchURLSpec

Specifies, by URL, an application to launch, items to open, or both, along with related information.

struct LSLaunchURLSpec {
   CFURLRef appURL;
   CFArrayRef itemURLs;
   const AEDesc *passThruParams;
   LSLaunchFlags launchFlags;
   void *asyncRefCon;
};
typedef struct LSLaunchURLSpec LSLaunchURLSpec;
Fields
appURL

A Core Foundation URL reference designating the application to launch; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. The URL must have scheme file and contain a valid path to an application file or application bundle. Set this field to NULL to request that each item in the itemURLs array be opened in its own preferred application.
itemURLs

A reference to an array of Core Foundation URL references designating the item or items to open; see the CFArray Reference in the Core Foundation Reference Documentation for a description of the CFArrayRef data type. The value of this field can be NULL, in which case the application designated by appURL will be launched without opening any items.
passThruParams

A pointer to an Apple event descriptor that is passed untouched as an optional parameter, with keyword keyAEPropData ('prdt'), in the Apple event sent to each application launched or activated (whether individual preferred applications or the application designated by appURL). See the Apple Event Manager Reference in the Carbon Interapplication Communication Documentation for a description of the AEDesc data type. The value of this field can be NULL.
launchFlags

Launch flags specifying how to launch each application (including whether to print or merely open documents); see “Launch Flags” for a description of these flags.
asyncRefCon

A pointer to an arbitrary application-defined value, passed in the Carbon event notifying you of an application’s launch or termination (if you have registered for such notification). The value of this field can be NULL.
Discussion

This data type defines a URL-based launch specification designating, by URL, an application to launch, items to open, or both. To request that items be opened in a particular application, set appURL and itemURLs accordingly. To request that each designated item be opened in its own preferred application, set appURL to NULL. If the item URL’s scheme is file (designating either a file or a directory), the selection of the preferred application is based on the designated item’s filename extension, file type, and creator signature; otherwise, it is based on the URL scheme (such as http, ftp, or mailto). To request that a particular application be launched without opening any document, set appURL accordingly and set itemURLs to NULL.
Availability
Available in Mac OS X v10.0 and later.*/

struct LSLaunchURLSpec {
   CFURLRef appURL;
   CFArrayRef itemURLs;
   const AEDesc *passThruParams;
   LSLaunchFlags launchFlags;
   void *asyncRefCon;
};
typedef struct LSLaunchURLSpec LSLaunchURLSpec;



//Func


/*LSOpenApplication

Launches the specified application.

OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
);
Parameters
inAppParams

A LSApplicationParameters structure specifying the application to launch and its launch parameters. This parameter cannot be NULL.
outPSN

On input, a pointer to a value of type ProcessSerialNumber that, on return, contains the process serial number (PSN) of the application specified by inAppParams, or NULL if you don’t want to receive the PSN.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The LSOpenApplication launches one application. This function is an updated alternative to the Process Manager's LaunchApplication function. Launch arguments are specified in the inAppParams argument, which must be supplied. If the application is already running in the current session, it is made the front process (unless the kLSLaunchNewInstance flag is used, which always causes a new process to be created).

If outPSN is not NULL, on return, the structure it points to contains the PSN of the launched (or activated) process. Note that for asynchronous launches, the application may not have finished launching when this function returns.
Version Notes

Thread-safe since Mac OS X v10.4.
Availability
Available in Mac OS X v10.4 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenApplication (
const LSApplicationParameters * inAppParams,
ProcessSerialNumber * outPSN
);

/*LSOpenFSRef

Opens an item designated by file-system reference, in the default manner in its preferred application.

OSStatus LSOpenFSRef (
   const FSRef *inRef,
   FSRef *outLaunchedRef
);
Parameters
inRef

A pointer to a file-system reference designating the item to open; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outLaunchedRef

A pointer to a file-system reference that, on return, will identify the application launched. Pass NULL if this information is unimportant.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The designated item is opened in the default manner, as if it had been opened with the LSOpenFromRefSpec function with a launch specification specifying the launch flag kLSLaunchDefaults: that is, asynchronously, starting the Classic emulation environment if necessary, and with the remaining launch parameters taken from the application’s information property list. For greater control, call LSOpenFromRefSpec directly. See “Launch Flags” for more information about launch flags.

The application is launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the item is a document, its preferred application is launched (or activated if it is already running) and sent an 'odoc' (“open document”) Apple event.
If the item is an application that is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the item is an application that is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.

As of Mac OS X v10.4 and later, LSOpenItemsWithRole is the preferred way of opening an item.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/

OSStatus LSOpenFSRef (
   const FSRef *inRef,
   FSRef *outLaunchedRef
);

/*LSOpenFromURLSpec

Opens one or more items designated by URL, in either their preferred applications or a designated application.

OSStatus LSOpenFromURLSpec (
   const LSLaunchURLSpec *inLaunchSpec,
   CFURLRef *outLaunchedURL
);
Parameters
inLaunchSpec

A pointer to a URL-based launch specification indicating what to open and how to launch the relevant application or applications; see “LSLaunchURLSpec” for a description of this structure.
outLaunchedURL

A pointer to a Core Foundation URL reference that, on return, will identify the application launched; see the CFURL Reference in the Core Foundation Reference Documentation for a description of the CFURLRef data type. Pass NULL if this information is unimportant. If more than one application is launched, the one identified will be the one corresponding to the first item designated in the launch specification.

Despite the absence of the word Copy in its name, this function retains the URL reference object on your behalf; you are responsible for releasing this object.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

This function affords greater control of how items are opened or applications launched than is possible with the LSOpenCFURLRef function. For instance, you can use it to open multiple items in a single call, in either the same or different applications; open documents for printing rather than for simple viewing or editing; or force a document to open in an application other than its own preferred application.

The launch specification supplied for the inLaunchSpec parameter may designate an application to launch, items to open, or both. The relevant application or applications are launched or activated, as required, and sent an appropriate Apple event depending on the circumstances:
If the launch specification designates both items to open and an application with which to open them, the designated application is used to open all of the items. The application is launched (or activated if it is already running) and sent one or more Apple events: 
If one or more of the item URLs have scheme file and designate documents to open, and if the application claims to accept file URLs, it is sent a 'GURL' (“get URL”) Apple event for each such URL.
If one or more of the item URLs have scheme file and designate documents to open, and if the application does not claim to accept file URLs, it is sent a single 'odoc' (“open document”) Apple event containing the list of items to open; if the items are to be printed, the Apple event is 'pdoc' (“print document”) instead.
For each item URL with a scheme other than file, the application is sent a 'GURL' (“get URL”) Apple event containing the item’s URL.

Note: When both an application and a list of items are supplied, the designated application is asked to open all of the items, whether or not it claims the ability to do so. Launch Services does not report an error if the application is unable to open one or more of the items; any error processing is the application’s responsibility.

If the launch specification designates items to open but not an application with which to open them, each item is opened in its own preferred application. Each application is launched or activated and sent one or more Apple events, as described for the preceding case. (If two or more of the items have the same preferred application, the application receives a single 'odoc' or 'pdoc' event listing all of the relevant items.)
If the launch specification designates only an application to launch (or if one or more of the items to open are file URLs designating applications):
If the application is not already running, it is launched and sent an 'oapp' (“open application”) Apple event.
If the application is already running, it is activated and sent an 'rapp' (“reopen application”) Apple event.

As of Mac OS X v10.4 and later, LSOpenURLsWithRole is the preferred way of opening URLs.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSOpen.h*/
OSStatus LSOpenFromURLSpec (
   const LSLaunchURLSpec *inLaunchSpec,
   CFURLRef *outLaunchedURL
);

#ifdef __cplusplus
}
#endif

#endif