
#ifndef __ATA_SMART_LIB_H__
#define __ATA_SMART_LIB_H__

#include <IOKit/IOReturn.h>
#include <IOKit/IOTypes.h>

#if !KERNEL
	#include <CoreFoundation/CFPlugIn.h>
	#if COREFOUNDATION_CFPLUGINCOM_SEPARATE
		#include <CoreFoundation/CFPlugInCOM.h>
	#endif
	
	#include <IOKit/IOCFPlugIn.h>
	#include <IOKit/storage/ata/IOATAStorageDefines.h>
	
#ifdef __cplusplus
extern "C" {
#endif
#include <HYS/IOKit/storage/ata/ATASMARTLib.h>

typedef struct IOATASMARTInterface{
	IUNKNOWN_C_GUTS;

/*GetATAIdentifyData


Reads the 512-byte data provided by the drive in response to the ATA IDENTIFY DEVICE command. 
IOReturn ( *GetATAIdentifyData ) (
    void *interface, 
    void *buffer, 
    UInt32 inSize, 
    UInt32 *outSize );  
Parameters
interface
A valid IOATASMARTInterface**.
buffer
A valid buffer.
inSize
The number of bytes to place in the buffer.
outSize
The number of bytes placed in the buffer. Can be NULL if the information is not required by the caller.
Return Value

Returns an IOReturn result code. If inSize is greater than 512 or less than 1, kIOReturnBadArgument is returned. 
Discussion 

Reads the 512-byte data provided by the drive in response to the ATA IDENTIFY DEVICE command. See section 8.15 of ATA/ATAPI-6. The data placed in buffer is guaranteed to be in native endian form on return (i.e. it will be byte swapped on big endian platforms, so the caller need not do anything).*/
IOReturn ( *GetATAIdentifyData ) (
    void *interface, 
    void *buffer, 
    UInt32 inSize, 
    UInt32 *outSize );  

/*SMARTEnableDisableOperations


Toggles SMART Operations. 
IOReturn ( *SMARTEnableDisableOperations ) (
    void *interface, 
    Boolean enable );  
Parameters
interface
Pointer to an IOATASMARTInterface.
enable
Passing true will ENABLE SMART operations, false will DISABLE SMART operations.
Return Value

Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnExclusiveAccess if it is already opened by another client. 
Discussion 

See section 8.54.1 and 8.54.3 of ATA/ATAPI-6.*/
IOReturn ( *SMARTEnableDisableOperations ) (
    void *interface, 
    Boolean enable );  

/*SMARTReadData


Retrieves 512 byte device SMART data structure. 
IOReturn ( *SMARTReadData ) (
    void *interface,
    ATASMARTData *data );  
Parameters
interface
Pointer to an IOATASMARTInterface.
data
Pointer to an ATASMARTData data structure to hold the device's SMART data.
Discussion 

See section 8.54.5 of ATA/ATAPI-6. Will return an appropriate error if command can not be completed.*/
IOReturn ( *SMARTReadData ) (
    void *interface,
    ATASMARTData *data );  

/*SMARTEnableDisableAutosave


Toggles SMART Autosave. 
IOReturn ( *SMARTEnableDisableAutosave ) (
    void *interface, 
    Boolean enable );  
Parameters
interface
Pointer to an IOATASMARTInterface.
enable
Passing true will ENABLE SMART Autosave, false will DISABLE SMART Autosave.
Return Value

Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnExclusiveAccess if it is already opened by another client. 
Discussion 

See section 8.54.2 of ATA/ATAPI-6.*/
IOReturn ( *SMARTEnableDisableAutosave ) (
    void *interface, 
    Boolean enable );  

/*SMARTValidateReadData


Tests the integrity of the device SMART data structure. 
IOReturn ( *SMARTValidateReadData ) (
    void *interface, 
    const ATASMARTData *data );  
Parameters
interface
Pointer to an IOATASMARTInterface.
data
Constant pointer to an ATASMARTData data structure to test.
Discussion 

The data structure checksum is the two's complement of the sum of the first 511 bytes in the data structure. The sum of all 512 bytes will be zero when the checksum is correct. See section 8.54.5.8.7 of ATA/ATAPI-6. Will return an error if checksum fails.*/
IOReturn ( *SMARTValidateReadData ) (
    void *interface, 
    const ATASMARTData *data );  

/*SMARTReadDataThresholds


Retrieves 512 byte device SMART data thresholds structure. 
IOReturn ( *SMARTReadDataThresholds ) (
    void *interface, 
    ATASMARTDataThresholds *dataThresholds );  
Parameters
interface
Pointer to an IOATASMARTInterface.
dataThresholds
Pointer to an ATASMARTDataThresholds data structure to hold the device's SMART data thresholds structure.
Discussion 

Retrieves 512 byte device SMART data thresholds structure. This command is not defined as part of ATA/ATAPI-6, but is implemented by a large variety of manufacturers. Will return an appropriate error if command can not be completed.*/
IOReturn ( *SMARTReadDataThresholds ) (
    void *interface, 
    ATASMARTDataThresholds *dataThresholds );  

/*SMARTExecuteOffLineImmediate


Immediately initiates collection of SMART data. 
IOReturn ( *SMARTExecuteOffLineImmediate ) (
    void *interface, 
    Boolean extendedTest );  
Parameters
interface
Pointer to an IOATASMARTInterface.
extendedTest
Passing true will collect "off-line" extended test, false short test.
Return Value

Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnExclusiveAccess if it is already opened by another client. 
Discussion 

See section 8.54.4 of ATA/ATAPI-6.*/
IOReturn ( *SMARTExecuteOffLineImmediate ) (
    void *interface, 
    Boolean extendedTest );  

/*SMARTReturnStatus


Sees if device has detected a threshold-exceeded condition. 
IOReturn ( *SMARTReturnStatus ) (
    void *interface, 
    Boolean *exceededCondition );  
Parameters
interface
Pointer to an IOATASMARTInterface.
exceededCondition
If this is non-zero the device threshold exceeded condition.
Return Value

Returns kIOReturnSuccess if successful, kIOReturnNoDevice if there is no connection to an IOService, kIOReturnExclusiveAccess if it is already opened by another client. 
Discussion 

The caller will poll this function and if exceededCondition is non-zero and we returned kIOReturnSuccess the device threshold exceeded condition. This would prompt the caller to call ATASMARTReadData to get more information. See section 8.54.7 of ATA/ATAPI-6.*/
IOReturn ( *SMARTReturnStatus ) (
    void *interface, 
    Boolean *exceededCondition );  

} IOATASMARTInterface;

#ifdef __cplusplus
}
#endif

#endif

#endif	