#ifndef HTMLRENDERING_H
#define HTMLRENDERING_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef  HITOOLBOX_H
#include <HIToolbox/HIToolbox.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*URL Source Type

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef UInt16 URLSourceType;
enum {
   kHRLookingForHTMLSource = 1,
   kHRLookingForImage = 2,
   kHRLookingForEmbedded = 3,
   kHRLookingForImageMap = 4,
   kHRLookingForFrame = 5
};
Constants
kHRLookingForHTMLSource

Indicates that the file is an HTML source document.

Available in Mac OS X v10.0 and later.
kHRLookingForImage

Indicates that the file is an image.

Available in Mac OS X v10.0 and later.
kHRLookingForEmbedded

Indicates that the file is an embedded object, such as a QuickTime movie.

Available in Mac OS X v10.0 and later.
kHRLookingForImageMap

Indicates that the file is an HTML image map.

Available in Mac OS X v10.0 and later.
kHRLookingForFrame

Indicates that the file is an HTML frameset.

Available in Mac OS X v10.0 and later.*/

typedef UInt16 URLSourceType;
enum {
   kHRLookingForHTMLSource = 1,
   kHRLookingForImage = 2,
   kHRLookingForEmbedded = 3,
   kHRLookingForImageMap = 4,
   kHRLookingForFrame = 5
};


/*Renderer HTML Type

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

enum {
   kHRRendererHTML32Type = 'ht32'
};*/

enum {
   kHRRendererHTML32Type = 'ht32'
};


/*HRReference

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef struct OpaqueHRReference * HRReference;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueHRReference * HRReference;

/*Scrollbar State

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef SInt16 HRScrollbarState;
enum {
   eHRScrollbarOn = 0,
   eHRScrollbarOff = 1,
   eHRScrollbarAuto = 2
};
Constants
eHRScrollbarOn

Tells the HTML Rendering Library to draw scrollbars at all times. If the data does not fill the current view, the scroll bars are inactive.

Available in Mac OS X v10.0 and later.
eHRScrollbarOff

Tells the HTML Rendering Library never to draw scrollbars. You may find this option useful if the HTML rendering area you specify does not extend to the edge of a window.

Available in Mac OS X v10.0 and later.
eHRScrollbarAuto

Tells the HTML Rendering Library to draw scrollbars as needed. This is the default setting.

Available in Mac OS X v10.0 and later.*/
typedef SInt16 HRScrollbarState;
enum {
   eHRScrollbarOn = 0,
   eHRScrollbarOff = 1,
   eHRScrollbarAuto = 2
};

/*HRURLToFSSpecProcPtr

Converts URL data to a file system specification. (Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef OSStatus (*HRURLToFSSpecProcPtr)
(
   const char * rootURL,
   const char * linkURL,
   FSSpec * fsspec,
   URLSourceType urlSourceType,
   void * refCon
);

If you name your function MyHRURLToFSSpecProc, you would declare it like this:

OSStatus MyHRURLToFSSpecProc (
   const char * rootURL,
   const char * linkURL,
   FSSpec * fsspec,
   URLSourceType urlSourceType,
   void * refCon
);
Parameters
rootURL

A pointer to a C string containing the root URL of the file to be loaded.
linkURL

A pointer to a C string containing the link URL of the file to be loaded.
fsspec

A pointer to a file system specification record (FSSpec) that you use to specify the file to which the HTML Rendering Library redirects the user. 
urlSourceType

The HTML Rendering Library passes one of the following constants to indicate the type of file being searched for:
kHRLookingForHTMLSource indicates that the file is an HTML source document.
kHRLookingForImage indicates that the file is an image.
kHRLookingForEmbedded indicates that the file is an embedded object, such as a QuickTime movie.
kHRLookingForImageMap indicates that the file is an HTML image map.
kHRLookingForFrame indicates that the file is an HTML frameset.
refCon

An arbitrary value set by your application. This value is passed by your application when you call the function and passed back when the HTML Rendering Library calls your MyHRURLToFSSpecProc function. You may find this value useful for referring to an object instance or a structure, for example.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

This function may be useful if you want to redirect certain URL’s to application-specific files, for example. The sequence of steps required to implement an application-defined function to intercept URL’s is as follows:
Obtain a UPP for your application-defined function by calling the function NewHRURLToFSSpecUPP.
Register your application-defined function by passing the UPP to the function HRRegisterURLToFSSpecUPP.
Respond when the HTML Rendering Library calls your application-defined function.

When you are done with your application-defined function:
Unregister your application-defined function by calling the function HRUnregisterURLToFSSpecUPP.
Dispose of the UPP by calling the function DisposeHRURLToFSSpecUPP.*/

typedef OSStatus (*HRURLToFSSpecProcPtr)
(
   const char * rootURL,
   const char * linkURL,
   FSSpec * fsspec,
   URLSourceType urlSourceType,
   void * refCon
);


/*HRURLToFSSpecUPP

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef HRURLToFSSpecProcPtr HRURLToFSSpecUPP;*/
typedef HRURLToFSSpecProcPtr HRURLToFSSpecUPP;

/*HRWasURLVisitedProcPtr

Keeps track of whether a given URL has been previously visited. (Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef Boolean (*HRWasURLVisitedProcPtr)
(
   const char * url,
   void * refCon
);

If you name your function MyHRWasURLVisitedProc, you would declare it like this:

Boolean MyHRWasURLVisitedProc (
   const char * url,
   void * refCon
);
Parameters
url

A pointer to a C string containing the URL of the link.
refCon

An arbitrary value set by your application. This value is passed by your application when you call the function and passed back when the HTML Rendering Library calls your MyHRWasURLVisitedProc function. You may find this value useful for referring to an object instance or a structure, for example.
Return Value

If the given URL was previously visited, your application-defined function should return true. If the given URL was not previously visited, your application-defined function should return false.
Discussion

The sequence of steps required to implement an application-defined function to handle previously visited links is as follows:
Obtain a UPP for your application-defined function by calling the function NewHRWasURLVisitedUPP.
Register your application-defined function by passing the UPP to the function HRRegisterWasURLVisitedUPP.
Respond when the HTML Rendering Library calls your application-defined function.

When you are done using your application-defined function:
Unregister your application-defined function by calling the function HRUnregisterWasURLVisitedUPP.
Dispose of the UPP by calling the function DisposeHRWasURLVisitedUPP.*/

typedef Boolean (*HRWasURLVisitedProcPtr)
(
   const char * url,
   void * refCon
);


/*HRWasURLVisitedUPP

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef HRWasURLVisitedProcPtr HRWasURLVisitedUPP;*/
typedef HRWasURLVisitedProcPtr HRWasURLVisitedUPP;

/*HRNewURLProcPtr

An application-defined function that tracks newly visited links. (Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef OSStatus (*HRNewURLProcPtr) (
   const char * url,
   const char * targetFrame,
   Boolean addToHistory,
   void * refCon
);

If you name your function MyHRNewURLProc, you would declare it like this:

OSStatus MyHRNewURLProc (
   const char * url,
   const char * targetFrame,
   Boolean addToHistory,
   void * refCon
);
Parameters
url

A pointer to a C string containing the URL of the link. 
targetFrame

A pointer to a C string containing the name of the target frame.
addToHistory

The HTML Rendering Library passes true in this parameter to indicate that you should add this link to a link-tracking history. It is up to your application to do any link-tracking. 
refCon

An arbitrary value set by your application. This value is passed by your application when you call the function HRRegisterNewURLUPP and passed back when the HTML Rendering Library calls your MyNewURLProc function. You may find this value useful for referring to an object instance or a structure, for example. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

You may find this function useful for maintaining a history list, for example. The sequence of steps required to implement an application-defined function to track visited links is as follows:
Obtain a UPP for your application-defined function by calling the function NewHRNewURLUPP.
Register your application-defined function by passing the UPP to the function HRRegisterNewURLUPP.
When the HTML Rendering Library calls your application-defined function, take note of the URL being visited.

When you are done using your application-defined function:
Unregister your application-defined function by calling the function HRUnregisterNewURLUPP.
Dispose of the UPP by calling the function DisposeHRNewURLUPP.*/

typedef OSStatus (*HRNewURLProcPtr) (
   const char * url,
   const char * targetFrame,
   Boolean addToHistory,
   void * refCon
);


/*HRNewURLUPP

(Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

typedef HRNewURLProcPtr HRNewURLUPP;*/
typedef HRNewURLProcPtr HRNewURLUPP;

//functions

/*HRNewReference

Obtains a new HRReference. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRNewReference (
   HRReference * hrRef,
   OSType rendererType,
   GrafPtr grafPtr
);
Parameters
hrRef

A pointer to a HRReference value. On return, your application uses this value to call other functions in the HTML Rendering Library. 
rendererType

A value of type OSType identifying the type of HTML renderer available. Currently, the constant kHRRendererHTML32Type is the only value you may pass in this parameter.
grafPtr

A pointer to a valid GrafPort. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

When your application has no further need for a particular HRReference, dispose of it by calling the function HRDisposeReference.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRNewReference (
   HRReference * hrRef,
   OSType rendererType,
   GrafPtr grafPtr
);

/*HRSetGrowboxCutout

Specifies whether to allow for a size box when drawing scrollbars. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRSetGrowboxCutout (
   HRReference hrRef,
   Boolean allowCutout
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
allowCutout

If you pass true in this parameter, the HTML Rendering Library draws scroll bars that provide space for a size box. If you pass false in this parameter, the HTML Rendering Library draws scroll bars that extend all the way to the bottom right corner of the rendering area. The default setting is false. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

You may find it useful to specify a cutout for a size box if the HTML rendering area you specify extends to the lower right corner of a window. The default setting is to draw scrollbars without leaving room for a size box. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRSetGrowboxCutout (
   HRReference hrRef,
   Boolean allowCutout
);

/*HRSetScrollbarState

Specifies how scrollbars are drawn. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRSetScrollbarState (
   HRReference hrRef,
   HRScrollbarState hScrollbarState,
   HRScrollbarState vScrollbarState
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
hScrollbarState

A value of type HRScrollbarState. See Scrollbar State for a list of the constants you may pass in this parameter. 
vScrollbarState

A value of type HRScrollbarState. See Scrollbar State for a list of the constants you may pass in this parameter.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

You can specify one of three values for scrollbars:
eHRScrollbarOn tells the HTML Rendering Library to draw scrollbars at all times. If the data does not fill the current view, the scroll bars are inactive. 
eHRScrollbarOff tells the HTML Rendering Library never to draw scrollbars. You may find this option useful if the HTML rendering area you specify does not extend to the edge of a window. 
eHRScrollbarAuto tells the HTML Rendering Library to draw scrollbars as needed. This is the default setting. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRSetScrollbarState (
   HRReference hrRef,
   HRScrollbarState hScrollbarState,
   HRScrollbarState vScrollbarState
);

/*HRDraw

Updates a specified region for a given HRReference. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRDraw (
   HRReference hrRef,
   RgnHandle updateRgnH
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
updateRgnH

A handle of type RgnHandle. This handle specifies the region that you want the HTML Rendering Library to update. Specify the region in the GrafPort’s local coordinates. If you pass NULL, the HTML Rendering Library updates the entire rectangle you previously specified with the function HRSetRenderingRect. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

Be sure to specify the dimensions of the rendering area by calling the function HRSetRenderingRect at least once before you call the HRDraw function.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRDraw (
   HRReference hrRef,
   RgnHandle updateRgnH
);

/*(HRActivate

Activates the window associated with a given HRReference. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRActivate (
   HRReference hrRef
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

Call this function whenever the window associated with a given HRReference becomes active. This allows the HTML Rendering Library to activate scrollbars and handle events as appropriate.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRActivate (
   HRReference hrRef
);

/*HRDeactivate

Deactivates the window associated with a given HRReference. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRDeactivate (
   HRReference hrRef
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

Call this function whenever the window associated with a given HRReference becomes inactive.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRDeactivate (
   HRReference hrRef
);

/*HRGetRenderedImageSize

Reports the size of the rendered image. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRGetRenderedImageSize (
   HRReference hrRef,
   Point * renderingSize
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
renderingSize

A pointer to a value of type Point. On return, the HTML Rendering Library uses this value to report the size of the entire HTML page; that is, the smallest rectangle that fully encloses the entire rendered page (as drawn without scrollbars).
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

The HTML Rendering Library attempts to limit the width of the rendered page to the width of the rectangle you specify by calling the function HRSetRenderingRect. The length of the page is calculated based on the resulting width.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRGetRenderedImageSize (
   HRReference hrRef,
   Point * renderingSize
);

/*HRSetRenderingRect

Specifies the boundaries of the HTML rendering area. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRSetRenderingRect (
   HRReference hrRef,
   const Rect * renderingRect
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
renderingRect

A pointer to a value of type Rect. This value specifies the boundaries of the HTML rendering area. Specify the boundaries in the GrafPort’s port coordinates. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

The HTML Rendering Library draws all elements, including scroll bars, inside the area you specify with the function HRSetRenderingRect.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRSetRenderingRect (
   HRReference hrRef,
   const Rect * renderingRect
);

/*HRDisposeReference

Disposes of a previously obtained HRReference. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRDisposeReference (
   HRReference hrRef
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRDisposeReference (
   HRReference hrRef
);

/*HRGoToPtr

Renders a set of HTML data from a specified buffer. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRGoToPtr (
   HRReference hrRef,
   char * buffer,
   UInt32 bufferSize,
   Boolean addToHistory,
   Boolean forceRefresh
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
buffer

A pointer to a buffer containing HTML data. 
bufferSize

A value specifying the number of bytes in the buffer. 
addToHistory

Pass true in this parameter if you wish to have this data added to the list of visited links. 
forceRefresh

Pass true in this parameter if you wish to force a screen update.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

The HTML Rendering Library displays the HTML source data pointed to by the handle. It does not copy the handle, so you should not dispose of it until you are sure you no longer need it. Note that any relative links you specify in the HTML data are relative to your application, as the HTML data has no associated URL.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRGoToPtr (
   HRReference hrRef,
   char * buffer,
   UInt32 bufferSize,
   Boolean addToHistory,
   Boolean forceRefresh
);

/*HRUtilGetURLFromFSSpec

Obtains a full URL from a given FSSpec. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRUtilGetURLFromFSSpec (
   const FSSpec * fsspec,
   Handle urlHandle
);
Parameters
fsspec

A pointer to an existing file system specification record (FSSpec). 
urlHandle

A handle to a C string. On return, this C string contains the URL of the given FSSpec. You must allocate this handle with the function NewHandle before calling HRUtilGetURLFromFSSpec. The HTML Rendering Library resizes the handle and terminates the C string with a NULL character.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

This function allows you to obtain a URL from a given FSSpec. This might be useful when you have previously obtained an FSSpec and need to pass it to an application that requires URL data, for example.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRUtilGetURLFromFSSpec (
   const FSSpec * fsspec,
   Handle urlHandle
);

/*HRIsHREvent

Gives the HTML Rendering Library an opportunity to handle events. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

Boolean HRIsHREvent (
   const EventRecord * eventRecord
);
Parameters
eventRecord

A pointer to an EventRecord. 
Return Value

Returns true if the HTML Rendering Library handles the specified event; returns false otherwise. 
Discussion

Call the HRIsHREvent function with every event received by your application. This ensures that the HTML Rendering Library has an opportunity to handle user clicks and cursor changes.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
Boolean HRIsHREvent (
   const EventRecord * eventRecord
);

/*HRFreeMemory

Attempts to release cache memory for use by your application. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

SInt32 HRFreeMemory (
   Size inBytesNeeded
);
Parameters
inBytesNeeded

A value indicating how many bytes of cache memory your application desires to obtain.
Return Value

A value indicating how many bytes of cache memory the HTML Rendering Library makes available to your application.
Discussion

Call the HRFreeMemory function to flush images and movies from the HTML Rendering Library cache. Be sure to check the function result to determine whether sufficient memory was made available to your application. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

SInt32 HRFreeMemory (
   Size inBytesNeeded
);

/*HRHTMLRenderingLibAvailable

Reports whether the HTML Rendering Library is available. (Deprecated. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

Boolean HRHTMLRenderingLibAvailable ();
Return Value

Returns true if the HTML Rendering Library is available; returns false otherwise. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in Mac OS X v10.0 and later.
Declared In
HTMLRendering.h*/
Boolean HRHTMLRenderingLibAvailable ();

/*HRUtilGetFSSpecFromURL

Obtains a FSSpec from a given set of relative URL’s. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRUtilGetFSSpecFromURL (
   const char * rootURL,
   const char * linkURL,
   FSSpec * destSpec
);
Parameters
rootURL

A pointer to a C string containing the root URL that the HTML Rendering Library will use to create the full URL. The root URL typically identifies an HTML source page.
linkURL

A pointer to a C string containing the link URL that the HTML Rendering Library will use to create the full URL. The link URL typically identifies a link being clicked on.
destSpec

A pointer to a file system specification record (FSSpec). On return, this points to the FSSPec of the full URL calculated from the specified root url and the specified link URL. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

This function allows you to obtain an FSSpec to use when a relative URL is inappropriate. This might be useful for Apple events, for example 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRUtilGetFSSpecFromURL (
   const char * rootURL,
   const char * linkURL,
   FSSpec * destSpec
);

/*HRGetTitle

Obtains the title of a given HTML page. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRGetTitle (
   HRReference hrRef,
   StringPtr title
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
title

A StringPtr. On return, the HTML Rendering Library stores the contents of the TITLE tag of the given page in the referenced string.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

This function converts any HTML entities into Mac OS characters before storing them in the string specified in the title parameter.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRGetTitle (
   HRReference hrRef,
   StringPtr title
);

/*NewHRURLToFSSpecUPP

Obtains a UPP for an application-defined function that intercepts URL’s. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

HRURLToFSSpecUPP NewHRURLToFSSpecUPP (
   HRURLToFSSpecProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your application-defined function that intercepts URL’s. For more information, see the function HRURLToFSSpecProcPtr.
Return Value

A Universal Procedure Pointer. You pass this pointer to the function HRRegisterURLToFSSpecUPP. See the description of the HRURLToFSSpecUPP data type.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

HRURLToFSSpecUPP NewHRURLToFSSpecUPP (
   HRURLToFSSpecProcPtr userRoutine
);

/*NewHRWasURLVisitedUPP

Obtains a UPP for an application-defined function that handles previously visited links. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

HRWasURLVisitedUPP NewHRWasURLVisitedUPP (
   HRWasURLVisitedProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your application-defined function that handles visited links. For more information, see the function HRWasURLVisitedProcPtr.
Return Value

A Universal Procedure Pointer. You pass this pointer to the function HRRegisterWasURLVisitedUPP. See the description of the HRWasURLVisitedUPP data type.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h */
 HRWasURLVisitedUPP NewHRWasURLVisitedUPP (
   HRWasURLVisitedProcPtr userRoutine
);

/*HRScrollToLocation

Scrolls to a specified view of the HTML rendering area. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRScrollToLocation (
   HRReference hrRef,
   Point * location
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
location

A pointer to a value of type Point. Your application uses this value to specify the upper left corner of the visible portion of the rendering area. 
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

The HTML Rendering Library limits scrolling to the available rendering area. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRScrollToLocation (
   HRReference hrRef,
   Point * location
);

/*HRRegisterNewURLUPP

Registers an application-defined function that handles newly visited links. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

void HRRegisterNewURLUPP (
   HRNewURLUPP inNewURLUPP,
   HRReference hrRef,
   void * inRefCon
);
Parameters
inNewURLUPP

A Universal Procedure Pointer (UPP). You obtain this UPP by calling the function NewHRNewURLUPP. 
hrRef

An HRReference value previously obtained by your application. 
inRefCon

An arbitrary value set by your application. This value is passed by your application when you call the HRRegisterNewURLUPP function and passed back when the HTML Rendering Library calls your function HRNewURLProcPtr. You may find this value useful for referring to an object instance or a structure, for example. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
void HRRegisterNewURLUPP (
   HRNewURLUPP inNewURLUPP,
   HRReference hrRef,
   void * inRefCon
);

/*HRGoToURL

Renders a local file specified as a URL. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRGoToURL (
   HRReference hrRef,
   const char * url,
   Boolean addToHistory,
   Boolean forceRefresh
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
url

A pointer to a C string containing a Universal Resource Locator (URL). 
addToHistory

Pass true in this parameter if you wish to have this file added to the list of visited links. 
forceRefresh

Pass true in this parameter if you wish to force a screen update.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

Use this function for rendering local files. The URL should begin with 'file:///'. Note that the HTML Rendering Library calls your HRNewURLProcPtr application-defined function (if you use one) with this URL. If you need to pass an FSSpec instead of a URL, use the function HRGoToURL. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRGoToURL (
   HRReference hrRef,
   const char * url,
   Boolean addToHistory,
   Boolean forceRefresh
);

/*HRRegisterURLToFSSpecUPP

Registers an application-defined function that handles previously visited links. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

void HRRegisterURLToFSSpecUPP (
   HRURLToFSSpecUPP inURLToFSSpecUPP,
   HRReference hrRef,
   void * inRefCon
);
Parameters
inURLToFSSpecUPP

A Universal Procedure Pointer (UPP). You obtain this UPP by calling the function NewHRURLToFSSpecUPP. 
hrRef

An HRReference value previously obtained by your application. 
inRefCon

An arbitrary value set by your application. This value is passed by your application when you call the HRRegisterURLToFSSpecUPP function and passed back when the HTML Rendering Library calls your function HRURLToFSSpecProcPtr. You may find this value useful for referring to an object instance or a structure, for example. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
void HRRegisterURLToFSSpecUPP (
   HRURLToFSSpecUPP inURLToFSSpecUPP,
   HRReference hrRef,
   void * inRefCon
);

/*NewHRNewURLUPP

Obtains a UPP for an application-defined function that handles newly visited links. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

HRNewURLUPP NewHRNewURLUPP (
   HRNewURLProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your application-defined function that handles newly visited links. For more information, see HRNewURLProcPtr.
Return Value

A Universal Procedure Pointer. You pass this pointer to the function HRRegisterNewURLUPP. See the description of the HRNewURLUPP data type.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

HRNewURLUPP NewHRNewURLUPP (
   HRNewURLProcPtr userRoutine
);

/*HRRegisterWasURLVisitedUPP

Registers an application-defined function that handles previously visited links. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

void HRRegisterWasURLVisitedUPP (
   HRWasURLVisitedUPP inWasURLVisitedUPP,
   HRReference hrRef,
   void * inRefCon
);
Parameters
inWasURLVisitedUPP

A Universal Procedure Pointer (UPP). You obtain this UPP by calling the function NewHRWasURLVisitedUPP. 
hrRef

An HRReference value previously obtained by your application. 
inRefCon

An arbitrary value set by your application. This value is passed by your application when you call the function and passed back when the HTML Rendering Library calls your MyHRWasURLVisitedProc function. You may find this value useful for referring to an object instance or a structure, for example. 
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

void HRRegisterWasURLVisitedUPP (
   HRWasURLVisitedUPP inWasURLVisitedUPP,
   HRReference hrRef,
   void * inRefCon
);

/*HRUtilCreateFullURL

Obtains a full URL from a given set of relative URLs. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRUtilCreateFullURL (
   const char * rootURL,
   const char * linkURL,
   Handle fullURLH
);
Parameters
rootURL

A pointer to a C string containing the root URL that the HTML Rendering Library will use to create the full URL. The root URL typically identifies an HTML source page.
linkURL

A pointer to a C string containing the link URL that the HTML Rendering Library will use to create the full URL. The link URL typically identifies a link being clicked on.
fullURLH

A handle. On return, this handle references a full URL created from the specified root URL and the specified link URL. You must allocate this handle with the function NewHandle before calling HRUtilCreateFullURL. The HTML Rendering Library resizes the handle and terminates the C string with a NULL character.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

This function allows you to obtain a full URL to use when a relative URL is inappropriate. This might be useful when you need to pass a URL to another application, for example.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/

OSStatus HRUtilCreateFullURL (
   const char * rootURL,
   const char * linkURL,
   Handle fullURLH
);

/*HRGoToFile

Specifies an HTML file for rendering. (Deprecated in Mac OS X v10.4. Use Web Kit instead; see Web Kit Objective-C Programming Guide.)

OSStatus HRGoToFile (
   HRReference hrRef,
   const FSSpec * fsspec,
   Boolean addToHistory,
   Boolean forceRefresh
);
Parameters
hrRef

An HRReference value previously obtained by your application. 
fsspec

A pointer to a file system specification record (FSSpec) for the HTML file that you wish to have rendered by the HTML Rendering Library. 
addToHistory

Pass true in this parameter if you wish to have this file added to the list of visited links. 
forceRefresh

Pass true in this parameter if you wish to force a screen update.
Return Value

A result code. See “HTML Rendering Library Result Codes”.
Discussion

Note that the HTML Rendering Library calls your HRNewURLProcPtr application-defined function (if you use one) with this FSSpec. If you need to pass a URL instead of an FSSpec, use the function HRGoToURL.
Special Considerations

Because the Web Kit takes a completely different approach to displaying HTML and web content from that used by the HTML Rendering Library, you cannot make a one-to-one substitution of Web Kit methods for HTML Rendering Library functions. However, the basic features of the Web Kit can be implemented very quickly, and Web Kit offers much greater capability than the HTML Rendering Library. Although the Web Kit is an Objective-C interface, you can call it from a Carbon application. See Accessing the Web Kit From Carbon Applications for details.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
HTMLRendering.h*/
OSStatus HRGoToFile (
   HRReference hrRef,
   const FSSpec * fsspec,
   Boolean addToHistory,
   Boolean forceRefresh
);



#ifdef __cplusplus
}
#endif

#endif