#ifndef  AXUIELEMENT_H
#define  AXUIELEMENT_H

#include <CoreFoundation/CoreFoundation.h>
#include <ApplicationServices/ApplicationServices.h>
//#include <HYS/HIServices/AXUIElement.h>
#include <APPLE/HIServices/AXUIElement.h>
#ifdef __cplusplus
extern "C" {
#endif

/*AXUIElementCopyElementAtPosition


Returns the accessibility object at the specified position in top-left relative screen coordinates.
extern AXError AXUIElementCopyElementAtPosition (
    AXUIElementRef application,
    float x,
    float y,
    AXUIElementRef *element);  
Parameters
application
The AXUIElementRef representing the application that contains the screen coordinates (or the system-wide accessibility object).
x
The horizontal position.
y
The vertical position.
element
On return, the accessibility object at the position specified by x and y. 

Return Value

If unsuccessful, AXUIElementCopyElementAtPosition may return one of the following error codes, among others: 
kAXErrorNoValue
There is no accessibility object at the specified position.
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

This function does hit-testing based on window z-order (that is, layering). If one window is on top of another window, the returned accessibility object comes from whichever window is topmost at the specified location. Note that if the system-wide accessibility object is passed in the application parameter, the position test is not restricted to a particular application.*/
extern AXError AXUIElementCopyElementAtPosition (
    AXUIElementRef application,
    float x,
    float y,
    AXUIElementRef *element);  

/*AXUIElementCreateSystemWide


Returns an accessibility object that provides access to system attributes. 
extern AXUIElementRef AXUIElementCreateSystemWide (
    void);  
Return Value

The AXUIElementRef representing the system-wide accessibility object. 
Discussion 

This is useful for things like finding the focused accessibility object regardless of which application is currently active.*/
extern AXUIElementRef AXUIElementCreateSystemWide (
    void);  

/*AXAPIEnabled


Returns whether the accessibility API is enabled. 
extern Boolean AXAPIEnabled ();  
Return Value

Returns TRUE if the accessibility API is currently enabled, otherwise FALSE. 
Discussion 

Assistive applications will not work if the accessibility API is not enabled or if the calling process is not a trusted accessibility client. Users can enable the accessibility API by checking "Enable access for assistive devices" in Universal Access Preferences.*/
extern Boolean AXAPIEnabled ();  

/*AXUIElementCopyAttributeNames


Returns a list of all the attributes supported by the specified accessibility object.
extern AXError AXUIElementCopyAttributeNames (
    AXUIElementRef element,
    CFArrayRef *names);  
Parameters
element
The AXUIElementRef representing the accessibility object.
names
On return, an array containing the accessibility object's attribute names. 

Return Value

If unsuccessful, AXUIElementCopyAttributeNames may return one of the following error codes, among others: 
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorIllegalArgument
One or both of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorFailure
There was a system memory failure.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
extern AXError AXUIElementCopyAttributeNames (
    AXUIElementRef element,
    CFArrayRef *names);  

/*AXUIElementGetAttributeValueCount


Returns the count of the array of an accessibility object's attribute value.
extern AXError AXUIElementGetAttributeValueCount (
    AXUIElementRef element,
    CFStringRef attribute,
    CFIndex *count);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
count
On return, the size of the array that is the attribute's value. 

Return Value

If unsuccessful, AXUIElementGetAttributeValueCount may return one of the following error codes, among others: 
kAXErrorIllegalArgument
The attribute's value is not an array or one of the other arguments is an illegal value.
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
extern AXError AXUIElementGetAttributeValueCount (
    AXUIElementRef element,
    CFStringRef attribute,
    CFIndex *count);  

/*AXUIElementCopyAttributeValue


Returns the value of an accessibility object's attribute.
extern AXError AXUIElementCopyAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef *value);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
value
On return, the value associated with the specified attribute. 

Return Value

If unsuccessful, AXUIElementCopyAttributeValue may return one of the following error codes, among others: 
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorNoValue
The specified attribute does not have a value.
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
extern AXError AXUIElementCopyAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef *value);  

/*AXUIElementGetTypeID


Returns the unique type identifier for the AXUIElementRef type.
extern CFTypeID AXUIElementGetTypeID (
    void);  
Return Value

Returns a CFTypeID representing the AXUIElementRef type.*/
extern CFTypeID AXUIElementGetTypeID (
    void);  

/*AXUIElementIsAttributeSettable


Returns whether the specified accessibility object's attribute can be modified. 
extern AXError AXUIElementIsAttributeSettable (
    AXUIElementRef element,
    CFStringRef attribute,
    Boolean *settable);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
settable
On return, a Boolean value indicating whether the attribute is settable. 

Return Value

If unsuccessful, AXUIElementIsAttributeSettable may return one of the following error codes, among others: 
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way (often due to a timeout).
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorNoValue
The specified attribute does not have a value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

If you receive a kAXErrorCannotComplete error from this function, you might want to repeat the request or change the timeout value.*/
extern AXError AXUIElementIsAttributeSettable (
    AXUIElementRef element,
    CFStringRef attribute,
    Boolean *settable);  

/*UIElementCopyActionNames


Returns a list of all the actions the specified accessibility object can perform. 
extern AXError AXUIElementCopyActionNames (
    AXUIElementRef element,
    CFArrayRef *names);  
Parameters
element
The AXUIElementRef representing the accessibility object.
names
On return, an array of actions the accessibility object can perform (empty if the accessibility object supports no actions). 

Return Value

If unsuccessful, AXUIElementCopyActionNames may return one of the following error codes, among others: 
kAXErrorIllegalArgument
One or both of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorFailure
There was some sort of system memory failure.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
extern AXError AXUIElementCopyActionNames (
    AXUIElementRef element,
    CFArrayRef *names);  

/*AXUIElementCopyActionDescription


Returns a localized description of the specified accessibility object's action.
extern AXError AXUIElementCopyActionDescription (
    AXUIElementRef element,
    CFStringRef action,
    CFStringRef *description);  
Parameters
element
The AXUIElementRef representing the accessibility object.
action
The action to be described.
description
On return, a string containing the description of the action. 

Return Value

If unsuccessful, AXUIElementCopyActionDescription may return one of the following error codes, among others: 
kAXErrorActionUnsupported
The specified AXUIElementRef does not support the specified action (you will also receive this error if you pass in the system-wide accessibility object).
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
extern AXError AXUIElementCopyActionDescription (
    AXUIElementRef element,
    CFStringRef action,
    CFStringRef *description);  

/*AXUIElementSetAttributeValue


Sets the accessibility object's attribute to the specified value. 
extern AXError AXUIElementSetAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef value);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
value
The new value for the attribute. 

Return Value

If unsuccessful, AXUIElementSetAttributeValue may return one of the following error codes, among others: 
kAXErrorIllegalArgument
The value is not recognized by the accessible application or one of the other arguments is an illegal value.
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

You can send and receive many different CFTypeRefs using the accessibility API. These include all CFPropertyListRef types, AXUIElementRef, AXValueRef, AXTextMarkerRef, AXTextMarkerRangeRef, CFNullRef, CFAttributedStringRef, and CRURLRef.*/
extern AXError AXUIElementSetAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef value);  

/*AXUIElementGetPid


Returns the process ID associated with the specified accessibility object.
extern AXError AXUIElementGetPid (
    AXUIElementRef element,
    pid_t *pid);  
Parameters
element
The AXUIElementRef representing an accessibility object.
pid
On return, the process ID associated with the specified accessibility object. 

Return Value

If unsuccessful, AXUIElementGetPid may return one of the following error codes, among others: 
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.*/
extern AXError AXUIElementGetPid (
    AXUIElementRef element,
    pid_t *pid);  

/*AXUIElementPerformAction


Requests that the specified accessibility object perform the specified action. 
extern AXError AXUIElementPerformAction (
    AXUIElementRef element,
    CFStringRef action);  
Parameters
element
The AXUIElementRef representing the accessibility object.
action
The action to be performed. 

Return Value

If unsuccessful, AXUIElementPerformAction may return one of the following error codes, among others: 
kAXErrorActionUnsupported
The specified AXUIElementRef does not support the specified action (you will also receive this error if you pass in the system-wide accessibility object).
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way or the application has not yet responded.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

It is possible to receive the kAXErrorCannotComplete error code from this function because accessible applications often need to perform some sort of modal processing inside their action callbacks and they may not return within the timeout value set by the accessibility API. This does not necessarily mean that the function has failed, however. If appropriate, your assistive application can try to call this function again. Also, you may be able to increase the timeout value (see AXUIElementSetMessagingTimeout).*/
extern AXError AXUIElementPerformAction (
    AXUIElementRef element,
    CFStringRef action);  


#ifdef __cplusplus
}
#endif

#endif